//
// Licensed to Green Energy Corp (www.greenenergycorp.com) under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Green Enery Corp licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//
#ifndef __RESPONSE_LOADER_TEST_OBJECT_H_
#define __RESPONSE_LOADER_TEST_OBJECT_H_

#include <opendnp3/APL/Log.h>
#include <opendnp3/APL/FlexibleDataObserver.h>

#include <opendnp3/DNP3/VtoReader.h>

namespace apl
{
class Logger;
}

namespace apl
{
namespace dnp
{

class ResponseLoaderTestObject
{
public:

	ResponseLoaderTestObject();

	void CheckBinaries(const std::string& arAPDU);
	void CheckCounters(const std::string& arAPDU);
	void CheckAnalogs(const std::string& arAPDU);
	void CheckSetpointStatii(const std::string& arAPDU);

	void Load(const std::string& arAPDU);

private: EventLog log;
public: FlexibleDataObserver fdo;
private: Logger* mpLogger;
public: VtoReader vto;

};

}
}

#endif

