/*************************************
1. include header file : sqf.h
2. Create Gobal variable : sqf_t sqf
3. Create buffer for sqf : sqf_createbuffer()
4. Load sqf file (optional) : sqf_load_file()
5. Edit Filter  : sqf_set()  / sqf_clear()
6. Save sqf file : sqf_save_file()
7. Free Buffer for sqf : sqf_destroybuffer().
*************************************/

#ifndef _SQF_H_
#define _SQF_H_
#include <stdint.h>

#define MAX_SZ (8192)
#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define TAIL (3) //CRC16 & 0x7E
#define MAX_EQUIP_ID 14
#define MAX_MSG_TYPE_OFFSET 24

#define LOG_RESERVED_BYTE 3
#define LOG_MAX_NUMBER_OF_ITEM_PLUS_ONE 0x807
#define LOG_MAX_NUMBER_OF_ITEM LOG_MAX_NUMBER_OF_ITEM_PLUS_ONE -1
#define LOG_HEADER_CMD_CODE 0x73
#define MSG_HEADER_CMD_CODE 0x7D
#define EVENT_HEADER_CMD_CODE 0x82
#define DEFAULT_EVENT_BUFFER_SIZE 2
#define PACKED __attribute__((__packed__))

enum{
  MSG_LOW=0,
  MSG_MEDIUM,
  MSG_HIGH,
  MSG_ERROR,
  MSG_FATAL,
}_msg_log_type_;

typedef struct{
    uint8_t* buf;
    unsigned sz;
} bitarray_s;

typedef struct PACKED
{
    uint8_t cmd;
    uint8_t ign0[3];
    uint32_t operand;
    uint32_t equip_id;
    uint32_t nitem;
} log_hdr_t;

typedef struct PACKED
{
    uint8_t cmd;
    uint8_t ign0[3];
    uint16_t nitem;
} event_hdr_t;

typedef struct PACKED
{
    uint8_t cmd;
    uint8_t ign0[1];
    uint16_t first;
    uint16_t last;
    uint8_t ign1[2];
} msg_hdr_t;

typedef struct
{
    log_hdr_t *hdr;
    bitarray_s ba;
} log_t;

typedef struct
{
    event_hdr_t *hdr;
    bitarray_s ba;
} event_t;

typedef struct
{
    msg_hdr_t *hdr;
    uint32_t *fields;
} msg_t;



typedef struct
{
    log_t logs[MAX_EQUIP_ID];
    uint8_t logs_enable[MAX_EQUIP_ID];
    unsigned nlogs;
    event_t events[1];
    unsigned nevents;
    int iEventByteLength;
    msg_t msgs[MAX_MSG_TYPE_OFFSET];
    uint8_t msg_enable;
    unsigned nmsgs;
} sqf_t;


typedef enum _log_operation_{
   LOG_SET,
   LOG_CLEAR,
}log_operation;

typedef enum _sqf_log_{
  eSQF_LOG_Obsolete__Temporal_Analyzer = 0x1000,
  eSQF_LOG_Obsolete__AGC_Power_Control = 0x1001,
  eSQF_LOG_Obsolete__Forward_Link_Frame_Types = 0x1002,
  eSQF_LOG_Obsolete__Reverse_Link_Frame_Types = 0x1003,
  eSQF_LOG_Access_Channel = 0x1004,
  eSQF_LOG_Reverse_Link_Channel_Traffic = 0x1005,
  eSQF_LOG_Sync_Channel = 0x1006,
  eSQF_LOG_Paging_Channel = 0x1007,
  eSQF_LOG_Forward_Link_Channel_Traffic = 0x1008,
  eSQF_LOG_Forward_Link_Vocoder = 0x1009,
  eSQF_LOG_Reverse_Link_Vocoder = 0x100A,
  eSQF_LOG_Obsolete__Finger = 0x100B,
  eSQF_LOG_Obsolete__Searcher = 0x100C,
  eSQF_LOG_Internal__ETAK = 0x100D,
  eSQF_LOG_Markov_Frame_Rate_Statistics = 0x100E,
  eSQF_LOG_Obsolete__Searcher_Version_2 = 0x100F,
  eSQF_LOG_Obsolete__Handset_Status = 0x1010,
  eSQF_LOG_Vocoder_Error_Mask = 0x1011,
  eSQF_LOG_Analog_Voice_Channel = 0x1012,
  eSQF_LOG_Access_Channel_Probe = 0x1013,
  eSQF_LOG_Internal__GPS_Info = 0x1014,
  eSQF_LOG_Obsolete__Test_Mobile_Command = 0x1015,
  eSQF_LOG_Sparse_AGC_Closed_Loop_Power_Control = 0x1016,
  eSQF_LOG_Band_Change = 0x1017,
  eSQF_LOG_Encapsulated_Debug_Message = 0x1018,
  eSQF_LOG_General_Temporal_Analyzer = 0x1019,
  eSQF_LOG_General_Temporal_Analyzer_With_Supplemental_Channels = 0x101A,
  eSQF_LOG_Analog_Forward_Channel = 0x101C,
  eSQF_LOG_Analog_Reverse_Channel = 0x101D,
  eSQF_LOG_Analog_Handoff = 0x101E,
  eSQF_LOG_FM_Slot_Statistics = 0x101F,
  eSQF_LOG_FOCC_Word_Sync_Count = 0x1020,
  eSQF_LOG_Partial_RLP_RX_Frames = 0x1025,
  eSQF_LOG_Partial_RLP_TX_Frames = 0x1026,
  eSQF_LOG_Channel_Configuration = 0x1028,
  eSQF_LOG_Obsolete__Forward_Link_Frame_Types_Version_1 = 0x1029,
  eSQF_LOG_Obsolete__Reverse_Link_Frame_Types_Version_1 = 0x102A,
  eSQF_LOG_Obsolete__Fast_Forward_Power_Control = 0x102B,
  eSQF_LOG_Obsolete__Reverse_Power_Control = 0x102C,
  eSQF_LOG_Searcher_and_Finger = 0x102D,
  eSQF_LOG_Service_Configuration = 0x102E,
  eSQF_LOG_Obsolete__Active_Set_and_Channel_Configuration = 0x102F,
  eSQF_LOG_Quick_Paging_Channel = 0x1030,
  eSQF_LOG_RLP_Statistics = 0x1031,
  eSQF_LOG_Simple_Test_Data_Service_Option_Counters = 0x1032,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_Results = 0x1033,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_Database = 0x1034,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_Search_Results = 0x1035,
  eSQF_LOG_GPS_IS801_Forward_Link = 0x1036,
  eSQF_LOG_GPS_IS801_Reverse_Link = 0x1037,
  eSQF_LOG_Internal__GPS_Search_Session_Statistics = 0x1038,
  eSQF_LOG_Internal__GPS_Search_Results = 0x1039,
  eSQF_LOG_Internal__Factory_Test_Mode_Forward_CRC_Summary = 0x103A,
  eSQF_LOG_Internal__GPS_Multipeaks_Information = 0x103B,
  eSQF_LOG_Internal__GPS_Post_Processed_Search_Results = 0x103C,
  eSQF_LOG_Full_Test_Data_Service_Option_Counters = 0x103D,
  eSQF_LOG_BT_General = 0x103E,
  eSQF_LOG_BT_Baseband_General = 0x103F,
  eSQF_LOG_BT_Baseband_DeviceSpecific = 0x1040,
  eSQF_LOG_BT_Link_Manager_Protocol = 0x1041,
  eSQF_LOG_BT_L2CAP = 0x1042,
  eSQF_LOG_BT_Service_Discovery = 0x1043,
  eSQF_LOG_BT_RFCOMM_SessionSpecific = 0x1044,
  eSQF_LOG_BT_RFCOMM_DLCI_ConnectionSpecific = 0x1045,
  eSQF_LOG_BT_Audio_Gateway = 0x1046,
  eSQF_LOG_BT_Baseband_L2CAP_only_Received = 0x104A,
  eSQF_LOG_BT_Baseband_L2CAP_only_Transmitted = 0x104B,
  eSQF_LOG_BT_L2CAP_Data_Received = 0x104E,
  eSQF_LOG_BT_L2CAP_Data_Transmitted = 0x104F,
  eSQF_LOG_BT_SDP_Signaling_Received = 0x1050,
  eSQF_LOG_BT_SDP_Signaling_Transmitted = 0x1051,
  eSQF_LOG_BT_RFCOMM_Data_Received = 0x1054,
  eSQF_LOG_BT_RFCOMM_Data_Transmitted = 0x1055,
  eSQF_LOG_Obsolete__1xEVDO_Searcher = 0x105D,
  eSQF_LOG_1xEVDO_Handoff_State = 0x105E,
  eSQF_LOG_1xEVDO_Active_Set_Pilot = 0x105F,
  eSQF_LOG_1xEVDO_Reverse_Link_Packet_Summary = 0x1060,
  eSQF_LOG_Obsolete__1xEVDO_Data_Rate_Control_Channel__ARQ_Buffer = 0x1061,
  eSQF_LOG_1xEVDO_Reverse_Traffic_Rate_Count = 0x1062,
  eSQF_LOG_1xEVDO_Reverse_Power_Control = 0x1063,
  eSQF_LOG_Obsolete__1xEVDO_Finger = 0x1064,
  eSQF_LOG_1xEVDO_Debug_Hex_Dump = 0x1065,
  eSQF_LOG_1xEVDO_ARQ_Effective_Receive_Rate = 0x1066,
  eSQF_LOG_Obsolete__1xEVDO_Forward_Traffic_Rate_Slot_Count = 0x1067,
  eSQF_LOG_1xEVDO_Air_Link_Summary = 0x1068,
  eSQF_LOG_1xEVDO_Power = 0x1069,
  eSQF_LOG_1xEVDO_Forward_Link_Packet_Snapshot = 0x106A,
  eSQF_LOG_Obsolete__1xEVDO_Session_Attempt = 0x106B,
  eSQF_LOG_1xEVDO_Access_Attempt = 0x106C,
  eSQF_LOG_1xEVDO_Reverse_Activity_Bits_Buffer = 0x106D,
  eSQF_LOG_1xEVDO_Connection_Attempt = 0x106E,
  eSQF_LOG_1xEVDO_Page_Message = 0x106F,
  eSQF_LOG_1xEVDO_RLP_Statistics = 0x1070,
  eSQF_LOG_1xEVDO_Connection_Release = 0x1071,
  eSQF_LOG_1xEVDO_Reverse_Activity_Bits = 0x1072,
  eSQF_LOG_1xEVDO_High_Resolution_Temporal_Analyzer = 0x1073,
  eSQF_LOG_1xEVDO_Reverse_Link_Packet_Snapshot = 0x1074,
  eSQF_LOG_1xEVDO_Signaling_Access_Channel = 0x1076,
  eSQF_LOG_1xEVDO_Signaling_Reverse_Traffic_Channel = 0x1077,
  eSQF_LOG_1xEVDO_Signaling_Control_Channel_Directed = 0x1078,
  eSQF_LOG_1xEVDO_Signaling_Forward_Traffic_Channel = 0x1079,
  eSQF_LOG_Obsolete__1xEVDO_Pilot_Sets = 0x107A,
  eSQF_LOG_1xEVDO_Traffic_Channel_Assignment = 0x107B,
  eSQF_LOG_1xEVDO_Signaling_Control_Channel_Broadcast = 0x107C,
  eSQF_LOG_Obsolete__1xEVDO_General_Temporal_Analyzer = 0x107D,
  eSQF_LOG_1xEVDO_State = 0x107E,
  eSQF_LOG_Obsolete__1xEVDO_Forward_Rate_Statistics = 0x107F,
  eSQF_LOG_1xEVDO_Sector = 0x1080,
  eSQF_LOG_1xEVDO_RX_Partial_RLP = 0x1082,
  eSQF_LOG_1xEVDO_TX_Partial_RLP = 0x1083,
  eSQF_LOG_1xEVDO_Forward_Statistics_Summary = 0x1084,
  eSQF_LOG_1xEVDO_Access_Channel_MAC_Capsule = 0x1085,
  eSQF_LOG_1xEVDO_Control_Channel_MAC_Packets = 0x1086,
  eSQF_LOG_1xEVDO_Receive_ATI_List = 0x1087,
  eSQF_LOG_1xEVDO_Session_Attempt_Version_2 = 0x1088,
  eSQF_LOG_1xEVDO_Searcher_Version_2 = 0x1089,
  eSQF_LOG_1xEVDO_Finger_Version_2 = 0x108A,
  eSQF_LOG_1xEVDO_Pilot_Sets_Version_2 = 0x108B,
  eSQF_LOG_1xEVDO_Data_Rate_Control_Channel_ARQ_Buffe_Version_2 = 0x108C,
  eSQF_LOG_1xEVDO_Acquire_Information = 0x108D,
  eSQF_LOG_1xEVDO_Reacquire_Information = 0x108E,
  eSQF_LOG_1xEVDO_Sleep_Information = 0x108F,
  eSQF_LOG_Forward_Dedicated_Control_Channel = 0x1090,
  eSQF_LOG_Reverse_Dedicated_Control_Channel = 0x1091,
  eSQF_LOG_Internal_MSP_Logging = 0x1092,
  eSQF_LOG_Active_Set = 0x1093,
  eSQF_LOG_Internal_Pilot_Phase_Measurement_4Shoulder_Results = 0x1094,
  eSQF_LOG_Internal_Extended_Pilot_Phase_Measurement_Database = 0x1095,
  eSQF_LOG_GPS_Visit_Parameters = 0x1096,
  eSQF_LOG_GPS_Measurement = 0x1097,
  eSQF_LOG_UIM_Application_Protocol_Data_Unit = 0x1098,
  eSQF_LOG_Obsolete_Simple_TDSO_Counter_for_DCCH = 0x1099,
  eSQF_LOG_Obsolete_Full_TDSO_Counter_for_DCCH = 0x109A,
  eSQF_LOG_Internal_Search_PPM_Statistics = 0x109B,
  eSQF_LOG_Legacy_UM_PPP_TX_Frames = 0x109C,
  eSQF_LOG_Legacy_UM_PPP_RX_Frames = 0x109D,
  eSQF_LOG_Security_PKX_ModMath_Statistics = 0x109E,
  eSQF_LOG_Security_PKX_ModMath_Operation = 0x109F,
  eSQF_LOG_Security_Encoding_Statistics = 0x10A0,
  eSQF_LOG_Security_Encoding_Operation_Destination_Statistics = 0x10A1,
  eSQF_LOG_Security_Encoding_Operation_ARC4_Statistics = 0x10A2,
  eSQF_LOG_Security_Encoding_Operation_Plaintext = 0x10A3,
  eSQF_LOG_Security_Encoding_Operation_Ciphertext = 0x10A4,
  eSQF_LOG_Security_Encoding_Operation_Msg_Auth_Code = 0x10A5,
  eSQF_LOG_Security_Hashing_Statistics = 0x10A6,
  eSQF_LOG_Security_Hashing_Operation_Input = 0x10A7,
  eSQF_LOG_Security_Hashing_Operation_Hash = 0x10A8,
  eSQF_LOG_Security_SSL_Session = 0x10A9,
  eSQF_LOG_Security_SSL_Session_Server_Certification = 0x10AA,
  eSQF_LOG_Security_SSL_Session_Cipherdata = 0x10AB,
  eSQF_LOG_Security_SSL_Session_Statistics = 0x10AC,
  eSQF_LOG_Security_SSL_TX_Statistics = 0x10AD,
  eSQF_LOG_Security_SSL_RX_Statistics = 0x10AE,
  eSQF_LOG_Security_SSL_HSP_Hello_Request = 0x10AF,
  eSQF_LOG_Security_SSL_HSP_Client_Hello = 0x10B0,
  eSQF_LOG_Security_SSL_HSP_Server_Hello = 0x10B1,
  eSQF_LOG_Security_SSL_HSP_Server_DH_Key_Exchange = 0x10B2,
  eSQF_LOG_Security_SSL_HSP_Server_RSA_Key_Exchange = 0x10B3,
  eSQF_LOG_Security_SSL_HSP_Server_Hello_Done = 0x10B4,
  eSQF_LOG_Security_SSL_HSP_Client_DH_Key_Exchange = 0x10B5,
  eSQF_LOG_Security_SSL_HSP_Client_RSA_Key_Exchange = 0x10B6,
  eSQF_LOG_Security_SSL_HSP_Client_Finished = 0x10B7,
  eSQF_LOG_Security_SSL_HSP_Server_Finished = 0x10B8,
  eSQF_LOG_Security_SSL_Cipherspec_Protocol_Change = 0x10B9,
  eSQF_LOG_Security_SSL_Alert_Protocol_Alert = 0x10BA,
  eSQF_LOG_Obsolete_Quick_Paging_Channel_Version_2 = 0x10BC,
  eSQF_LOG_Enhanced_Access_Probe_Information = 0x10BD,
  eSQF_LOG_BCCH_Frame_Information = 0x10BE,
  eSQF_LOG_FCCCH_Frame_Information = 0x10BF,
  eSQF_LOG_FDCH_Frame_Information = 0x10C0,
  eSQF_LOG_RDCH_Frame_Information = 0x10C1,
  eSQF_LOG_Fast_Forward_Power_Control_Statistics = 0x10C2,
  eSQF_LOG_Reverse_Power_Control_Statistics = 0x10C3,
  eSQF_LOG_Obsolete__Searcher_And_Finger_Version_2 = 0x10C4,
  eSQF_LOG_Service_Configuration_Version_2 = 0x10C5,
  eSQF_LOG_Active_Set_Version_2 = 0x10C6,
  eSQF_LOG_Reduced_Active_Set = 0x10C7,
  eSQF_LOG_Triage = 0x10C8,
  eSQF_LOG_Internal__RDA_Frame_Information_V1 = 0x10C9,
  eSQF_LOG_Internal__gpsOne_Fatpath = 0x10CA,
  eSQF_LOG_Internal__Extended_AGC = 0x10CB,
  eSQF_LOG_Internal__Transmit_AGC = 0x10CC,
  eSQF_LOG_Internal__I_Q_Offset_Registers = 0x10CD,
  eSQF_LOG_Internal__DACC_I_Q_Accum_Registers = 0x10CE,
  eSQF_LOG_Internal__Register_Polling_Results = 0x10CF,
  eSQF_LOG_System_Arbitration_Module = 0x10D0,
  eSQF_LOG_Internal__Diablo_Searcher_Finger = 0x10D1,
  eSQF_LOG_System_Determination_Last_Main_Action = 0x10D2,
  eSQF_LOG_System_Determination_Last_Hybrid_Action = 0x10D3,
  eSQF_LOG_Internal__BCCH_Signaling = 0x10D6,
  eSQF_LOG_Internal__REACH_Signaling = 0x10D7,
  eSQF_LOG_Internal__FCCCH_Signaling = 0x10D8,
  eSQF_LOG_RDA_Frame_Information_V2 = 0x10D9,
  eSQF_LOG_Internal__GPS_Bit_Edge_Results = 0x10DA,
  eSQF_LOG_Obsolete__Position_Engine_Full = 0x10DB,
  eSQF_LOG_Obsolete__Position_Engine_Partial = 0x10DC,
  eSQF_LOG_Internal__GPS_Single_Peak_Search_Results = 0x10DD,
  eSQF_LOG_Internal__SRCH4_SAMPRAM = 0x10DE,
  eSQF_LOG_Internal__1xEVDO_AN_PPP_TX_Frames = 0x10DF,
  eSQF_LOG_Internal__1xEVDO_AN_PPP_RX_Frames = 0x10E0,
  eSQF_LOG_Internal__GPS_Scheduler_Trace = 0x10E1,
  eSQF_LOG_MPEG4_YUV_Frame = 0x10E2,
  eSQF_LOG_MPEG4_Clip_Statistics_V1 = 0x10E3,
  eSQF_LOG_MPEG4_Clip_Statistics_V2 = 0x10E4,
  eSQF_LOG_Internal__BREW_Bucket_0 = 0x10F2,
  eSQF_LOG_Internal__BREW_Bucket_1 = 0x10F3,
  eSQF_LOG_Internal__BREW_Bucket_2 = 0x10F4,
  eSQF_LOG_Internal__BREW_Bucket_3 = 0x10F5,
  eSQF_LOG_Internal__BREW_Bucket_4 = 0x10F6,
  eSQF_LOG_Internal__BREW_Bucket_5 = 0x10F7,
  eSQF_LOG_Internal__BREW_Bucket_6 = 0x10F8,
  eSQF_LOG_Internal__BREW_Bucket_7 = 0x10F9,
  eSQF_LOG_Internal__BREW_Bucket_8 = 0x10FA,
  eSQF_LOG_Internal__BREW_Bucket_9 = 0x10FB,
  eSQF_LOG_Internal__BREW_Bucket_10 = 0x10FC,
  eSQF_LOG_Internal__BREW_Bucket_11 = 0x10FD,
  eSQF_LOG_Internal__BREW_Bucket_12 = 0x10FE,
  eSQF_LOG_Internal__BREW_Bucket_13 = 0x10FF,
  eSQF_LOG_Internal__BREW_Bucket_14 = 0x1100,
  eSQF_LOG_Internal__BREW_Bucket_15 = 0x1101,
  eSQF_LOG_Internal__BREW_Bucket_16 = 0x1102,
  eSQF_LOG_Internal__BREW_Bucket_17 = 0x1103,
  eSQF_LOG_Internal__BREW_Bucket_18 = 0x1104,
  eSQF_LOG_Internal__BREW_Bucket_19 = 0x1105,
  eSQF_LOG_Internal__BREW_Bucket_20 = 0x1106,
  eSQF_LOG_Internal__BREW_Bucket_21 = 0x1107,
  eSQF_LOG_Internal__BREW_Bucket_22 = 0x1108,
  eSQF_LOG_Internal__BREW_Bucket_23 = 0x1109,
  eSQF_LOG_Internal__BREW_Bucket_24 = 0x110A,
  eSQF_LOG_Internal__BREW_Bucket_25 = 0x110B,
  eSQF_LOG_Internal__BREW_Bucket_26 = 0x110C,
  eSQF_LOG_Internal__BREW_Bucket_27 = 0x110D,
  eSQF_LOG_Internal__BREW_Bucket_28 = 0x110E,
  eSQF_LOG_Internal__BREW_Bucket_29 = 0x110F,
  eSQF_LOG_Internal__BREW_Bucket_30 = 0x1110,
  eSQF_LOG_Internal__BREW_Bucket_31 = 0x1111,
  eSQF_LOG_Internal__BREW_Bucket_32__255 = 0x1112,
  eSQF_LOG_Internal__Framed_UM_Received = 0x1113,
  eSQF_LOG_Internal__Framed_RM_Received = 0x1114,
  eSQF_LOG_Internal__Framed_AN_Received = 0x1115,
  eSQF_LOG_Internal__Framed_UM_Transmitted = 0x1123,
  eSQF_LOG_Internal__Framed_RM_Transmitted = 0x1124,
  eSQF_LOG_Internal__Framed_AN_Transmitted = 0x1125,
  eSQF_LOG_Internal__Unframed_UM_Received = 0x1133,
  eSQF_LOG_Internal__Unframed_RM_Received = 0x1134,
  eSQF_LOG_Internal__Unframed_AN_Received = 0x1135,
  eSQF_LOG_Internal__Unframed_UM_Transmitted = 0x1143,
  eSQF_LOG_Internal__Unframed_RM_Transmitted = 0x1144,
  eSQF_LOG_Internal__Unframed_AN_Transmitted = 0x1145,
  eSQF_LOG_GPS_Position_Engine_Full_Version_2 = 0x1154,
  eSQF_LOG_Memory_Debug = 0x1155,
  eSQF_LOG_MPU_Task_Profiling__System_Info = 0x1156,
  eSQF_LOG_MPU_Task_Profiling__Task_Info = 0x1157,
  eSQF_LOG_Internal__Core_Dump = 0x1158,
  eSQF_LOG_GPS_Position_Engine_Partial_Version_2 = 0x115E,
  eSQF_LOG_Internal__Diag_Stress_Test = 0x115F,
  eSQF_LOG_WMS_Read = 0x1160,
  eSQF_LOG_Search_Triage_Info_Version_2 = 0x1161,
  eSQF_LOG_RLP_Fundicated_Rx_Frames = 0x1162,
  eSQF_LOG_RLP_Fundicated_Tx_Frames = 0x1163,
  eSQF_LOG_QTV_Streaming_RX_Statistics = 0x1164,
  eSQF_LOG_QTV_RTSP_Describe_Request = 0x1165,
  eSQF_LOG_QTV_RTSP_Setup_Request = 0x1166,
  eSQF_LOG_QTV_RTSP_Play_Request = 0x1167,
  eSQF_LOG_QTV_RTSP_Pause_Request = 0x1168,
  eSQF_LOG_QTV_RTSP_Teardown_Request = 0x1169,
  eSQF_LOG_QTV_RTSP_Server_Response = 0x116A,
  eSQF_LOG_QTV_RTCP_Receiver_Report = 0x116B,
  eSQF_LOG_QTV_RTCP_Sender_Report = 0x116C,
  eSQF_LOG_QTV_RTP_Statistics = 0x116D,
  eSQF_LOG_QTV_SDP_File = 0x116E,
  eSQF_LOG_QTV_RTSP_Client_Response = 0x116F,
  eSQF_LOG_QTV_RTP_Header_Only = 0x1170,
  eSQF_LOG_QTV_RTP_Entire_Packet = 0x1171,
  eSQF_LOG_QTV_RTP_Audio_Sample = 0x1172,
  eSQF_LOG_QTV_RTP_Video_Sample = 0x1173,
  eSQF_LOG_1X_Searcher_4_Parameters = 0x1174,
  eSQF_LOG_Searcher_Sleep_Statistics = 0x1175,
  eSQF_LOG_Service_Configuration_Version_3 = 0x1176,
  eSQF_LOG_1xEVDO_Searcher_4_Parameters = 0x1177,
  eSQF_LOG_AFLT_Searcher_4_Parameters = 0x1178,
  eSQF_LOG_Enhanced_Finger_Information = 0x1179,
  eSQF_LOG_DV_Information_Enabled = 0x117A,
  eSQF_LOG_WMS_Set_Routes_Information = 0x117B,
  eSQF_LOG_Factory_Test_Mode_V2 = 0x117C,
  eSQF_LOG_Internal__GPS_Simplified_Multipeak_Version_2 = 0x117D,
  eSQF_LOG_Internal__GPS_Verbose_Multipeak_Version_2 = 0x117E,
  eSQF_LOG_1xEVDO_Multicast_Packet_Rate_Metrics = 0x117F,
  eSQF_LOG_1xEVDO_Multicast_Physical_Channel_Metrics = 0x1180,
  eSQF_LOG_1xEVDO_Multicast_ECB_Status = 0x1181,
  eSQF_LOG_1xEVDO_Multicast_Logical_Channel_Metrics = 0x1182,
  eSQF_LOG_1xEVDO_Debug_Display = 0x1183,
  eSQF_LOG_1xEVDO_Tune_Away_Information = 0x1184,
  eSQF_LOG_1xEVDO_Tune_Away_RRI_Information = 0x1185,
  eSQF_LOG_1xEVDO_Connection_Termination_Statistics = 0x1186,
  eSQF_LOG_1xEVDO_Connected_State_Protocol_Stack_Statistics = 0x1187,
  eSQF_LOG_1xEVDO_Connected_State_Transmit_Statistics = 0x1188,
  eSQF_LOG_1xEVDO_Connected_State_RMAC_Statistics = 0x1189,
  eSQF_LOG_1xEVDO_Connected_State_Search_Statistics = 0x118A,
  eSQF_LOG_1xEVDO_FTC_Physical_Layer = 0x118B,
  eSQF_LOG_1xEVDO_RTC_Physical_Layer = 0x118C,
  //eSQF_LOG_1xEVDO_Reserved = 0x118D,
  //eSQF_LOG_1xEVDO_Reserved = 0x118E,
  //eSQF_LOG_1xEVDO_Reserved = 0x118F,
  //eSQF_LOG_1xEVDO_Reserved = 0x1190,
  //eSQF_LOG_1xEVDO_Reserved = 0x1191,
  eSQF_LOG_1xEVDO_Rev_A_SingleUser_Packet_Forward_Statistics = 0x1192,
  eSQF_LOG_1xEVDO_Rev_A_MultiUser_Packet_Forward_Statistics = 0x1193,
  eSQF_LOG_RLP_RX__PDCH_Partial_MuxPDU5_Frames = 0x1194,
  eSQF_LOG_RLP_TX__PDCH_Partial_MuxPDU5_Frames = 0x1195,
  eSQF_LOG_RLP_RX_Internal_Details = 0x1196,
  eSQF_LOG_RLP_TX_Internal_Details = 0x1197,
  eSQF_LOG_MPEG4_Clip_Statistics_V3 = 0x1198,
  eSQF_LOG_Mobile_IP_Performance = 0x1199,
  eSQF_LOG_Srch_TNG_Finger_Status = 0x119A,
  eSQF_LOG_Srch_TNG_1x_Searcher_Dump = 0x119B,
  eSQF_LOG_Srch_TNG_General_Status = 0x119C,
  eSQF_LOG_Srch_TNG_Demod_Status = 0x119D,
  eSQF_LOG_Srch_TNG_Sleep_Statistics = 0x119E,
  eSQF_LOG_Srch_TNG_Quick_Paging_Channel_Info = 0x119F,
  eSQF_LOG_Srch_TNG_AFC_Info = 0x11A0,
  eSQF_LOG_Srch_TNG_Acquisition_Info = 0x11A1,
  eSQF_LOG_Srch_TNG_Finger_Channel_Estimate = 0x11A2,
  eSQF_LOG_Srch_TNG_QLIC_Info = 0x11A3,
  //eSQF_LOG_Reserved = 0x11A4,
  //eSQF_LOG_Reserved = 0x11A5,
  eSQF_LOG_Srch_TNG_ASDIV = 0x11A6,
  eSQF_LOG_Internal__Srch_RDDS = 0x11A7,
  //eSQF_LOG_Reserved = 0x11A8,
  eSQF_LOG_Internal__Srch_TNG_TC_Statistics = 0x11A9,
  eSQF_LOG_Internal__Srch_TC_Set_Maintenance = 0x11AA,
  eSQF_LOG_Internal__Srch_TNG_ZZ_Profile = 0x11AB,
  eSQF_LOG_Internal__Srch_TNG_Triage = 0x11AC,
  eSQF_LOG_Internal__Srch_NonSlotted_Idle = 0x11AD,
  eSQF_LOG_Internal__Srch_Sect_Dump = 0x11AE,
  eSQF_LOG_Internal__Srch_Finger_Driver_Dump = 0x11AF,
  eSQF_LOG_QTV_RTP_Text_Sample = 0x11B0,
  eSQF_LOG_QTV_Player_Timed_Text = 0x11B1,
  eSQF_LOG_QTV_Frame_Decode_Information = 0x11B2,
  eSQF_LOG_QTV_Frame_Render_Information = 0x11B3,
  eSQF_LOG_QTV_Audio_Video_Sync = 0x11B4,
  eSQF_LOG_Internal__QTV_Streaming_SDP_Parameters = 0x11B5,
  eSQF_LOG_QTV_Pseudo_Streaming_2_Statistics = 0x11B6,
  eSQF_LOG_QTV_Pseudo_Streaming_2_Get_Request = 0x11B7,
  eSQF_LOG_QTV_Pseudo_Streaming_2_Get_Response_Header = 0x11B8,
  eSQF_LOG_Obsolete__QTV_Pseudo_Streaming_2_Get_Response_Packet = 0x11B9,
  eSQF_LOG_QTV_CMX_Audio_Input_Data = 0x11BA,
  eSQF_LOG_QTV_RTSP_Options = 0x11BB,
  eSQF_LOG_QTV_RTSP_Get_Parameter = 0x11BC,
  eSQF_LOG_QTV_RTSP_Set_Parameter = 0x11BD,
  eSQF_LOG_QTV_Video_Bitstream = 0x11BE,
  eSQF_LOG_QTV_ARM_Video_Decode_Statistics = 0x11BF,
  eSQF_LOG_QTV_DSP_Slice_Buffer = 0x11C0,
  eSQF_LOG_QTV_Command_Logging = 0x11C1,
  eSQF_LOG_Internal__QTV_Audio_Frame_PTS_Information = 0x11C2,
  eSQF_LOG_QTV_Video_Frame_Decode_Information = 0x11C3,
  eSQF_LOG_QTV_RTCP_Compound_RR_Packet = 0x11C4,
  eSQF_LOG_Internal__QTV_Frame_Buffer_Release_Reason = 0x11C5,
  eSQF_LOG_Internal__QTV_Audio_Channel_Switch_Frame = 0x11C6,
  eSQF_LOG_Internal__QTV_RTP_Decrypted_Packet = 0x11C7,
  eSQF_LOG_QTV_PCR_Drift_Rate = 0x11C8,
  eSQF_LOG_GPS_PDSM_Position_Report_Callback = 0x11E1,
  eSQF_LOG_GPS_PDSM_PD_Event_Callback = 0x11E2,
  eSQF_LOG_GPS_PDSM_PA_Event_Callback = 0x11E3,
  eSQF_LOG_GPS_PDSM_Notify_Verify_Request = 0x11E4,
  eSQF_LOG_Internal__GPS_Bandwidth_Test_Info = 0x11E5,
  //eSQF_LOG_GPS_PDSM_Reserved_2 = 0x11E6,
  //eSQF_LOG_Srch_Reserved = 0x11E7,
  //eSQF_LOG_Srch_Reserved = 0x11E8,
  eSQF_LOG_GPS_MSMPC_Forward_Link = 0x11E9,
  eSQF_LOG_GPS_MSMPC_Reverse_Link = 0x11EA,
  eSQF_LOG_Protocol_Services_Data = 0x11EB,
  eSQF_LOG_Internal__MFLO_AGC_Dynamic_Params = 0x11EC,
  eSQF_LOG_Internal__MFLO_AFC_IFT_Dynamic_Params = 0x11ED,
  eSQF_LOG_Internal__MFLO_DMTT_Full_Channel_Params = 0x11EE,
  eSQF_LOG_Obsolete__MFLO_MLC_Location_Dynamic_Params = 0x11EF,
  eSQF_LOG_Internal__MFLO_Turbo_Decoder_Dynamic_Params = 0x11F0,
  eSQF_LOG_Internal__MFLO_AGC_Loop_Static_Params = 0x11F1,
  eSQF_LOG_Internal__MFLO_TDM1_AFC_Static_Params = 0x11F2,
  eSQF_LOG_Internal__MFLO_Timing_Sync_Static_Params = 0x11F3,
  eSQF_LOG_Internal__MFLO_Channel_Estimation_Static_Params = 0x11F4,
  eSQF_LOG_MFLO_RSSI_Value_Dynamic_Params = 0x11F5,
  eSQF_LOG_MFLO_CB_Info_Dynamics_Params = 0x11F6,
  eSQF_LOG_Internal__MFLO_Wide_Local_Static_Params = 0x11F7,
  eSQF_LOG_MFLO_Wide_Local_Dynamic_Params = 0x11F8,
  eSQF_LOG_MFLO_MLC_PLP_Statistics_Per_Frame_PRE_Params = 0x11F9,
  eSQF_LOG_Obsolete__MFLO_OIS_PLP_Statistics_Dynamic_Params = 0x11FA,
  eSQF_LOG_Internal__MFLO_INIT_Acq_Test_Dynamic_Params = 0x11FB,
  eSQF_LOG_Obsolete__MFLO_OIS_Info_Static_Params = 0x11FC,
  eSQF_LOG_Internal__MFLO_Flow_Activation_Dynamic_Params = 0x11FD,
  eSQF_LOG_Internal__MFLO_DMTT_Dynamic_Params = 0x11FE,
  eSQF_LOG_Obsolete__MFLO_Stream_Info_Static_Params = 0x11FF,
  eSQF_LOG_MFLO_MAC_Info_Static_Params = 0x1200,
  eSQF_LOG_Internal__MFLO_IFT_Channel_Params = 0x1202,
  eSQF_LOG_Internal__MFLO_IM2_Calibration_Params = 0x1203,
  eSQF_LOG_Internal__MFLO_DMTT_Short_Channel_Params = 0x1204,
  eSQF_LOG_Internal__MFLO_Sleep_Dynamic_Params = 0x1205,
  eSQF_LOG_Internal__MFLO_Sleep_FEE_Dynamic_Params = 0x1206,
  eSQF_LOG_Internal__MFLO_DC_Correction_Static_Params = 0x1207,
  eSQF_LOG_Internal__MFLO_DC_Correction_Dynamic_Params = 0x1208,
  eSQF_LOG_Internal__MFLO_Digital_Filter_Params = 0x1209,
  eSQF_LOG_Obsolete__MFLO_Bound_Stream_List_Params = 0x120A,
  eSQF_LOG_Obsolete__MFLO_MLC_PLP_Statistics_Post_Params = 0x120B,
  eSQF_LOG_MFLO_FTAP_Packet_Record_Header_Params = 0x120C,
  eSQF_LOG_MFLO_FTAP_Packet_Records_Params = 0x120D,
  eSQF_LOG_MFLO_FTAP_WOIS_Params = 0x120E,
  eSQF_LOG_MFLO_FTAP_LOIS_Params = 0x120F,
  eSQF_LOG_MFLO_FTAP_WID_LID_Params = 0x1210,
  eSQF_LOG_MFLO_OIS_PLP_Statistics_Dynamic_Params = 0x1211,
  eSQF_LOG_MFLO_OIS_Info_Static_Params = 0x1212,
  eSQF_LOG_MFLO_MLC_PLP_Statistics_Post_Params = 0x1213,
  eSQF_LOG_MFLO_MLC_Location_Dynamic_Params = 0x1214,
  eSQF_LOG_MFLO_Bound_Stream_List_Params = 0x1215,
  eSQF_LOG_MFLO_Stream_Info_Static_Params = 0x1216,
  eSQF_LOG_Internal__MFLO_Profile_Data = 0x1218,
  eSQF_LOG_MFLO_Stream_PLP_Statistics = 0x1219,
  eSQF_LOG_Internal__MFLO_Control_Channel_Data = 0x121A,
  eSQF_LOG_Internal__MFLO_FMS_Message_Data = 0x121B,
  eSQF_LOG_Internal__MFLO_Sleep_Table = 0x121C,
  eSQF_LOG_Internal__MFLO_InterSuperframe_Sleep_Distance = 0x121D,
  eSQF_LOG_Internal__MFLO_Raw_PLP_Data = 0x121E,
  eSQF_LOG_Internal__MFLO_FDM_Records = 0x121F,
  eSQF_LOG_Internal__MFLO_UBM_AGC_Static_Parameters = 0x1220,
  eSQF_LOG_Internal__MFLO_UBM_Background_Monitoring_Static_Parameters = 0x1221,
  eSQF_LOG_Internal__MFLO_UBM_Interference_Cancellation_Static_Parameters = 0x1222,
  eSQF_LOG_Internal__MFLO_UBM_TDM1_AFC_Static_Parameters = 0x1223,
  eSQF_LOG_Internal__MFLO_UBM_IFT_Timing_Synchronization_Static_Parameters = 0x1224,
  eSQF_LOG_Internal__MFLO_UBM_DMTT_Timing_Synchronization_Static_Parameters = 0x1225,
  eSQF_LOG_Internal__MFLO_UBM_EDMTT_Timing_Synchronization_Static_Parameters = 0x1226,
  eSQF_LOG_Internal__MFLO_UBM_Channel_Estimation_Static_Parameters = 0x1227,
  eSQF_LOG_Internal__MFLO_UBM_Wide_Local_Static_Parameters = 0x1228,
  eSQF_LOG_Internal__MFLO_UBM_AGC_Dynamic_Parameters = 0x1229,
  eSQF_LOG_MFLO_UBM_Wide_Local_Dynamic_Parameters = 0x122A,
  eSQF_LOG_Internal__MFLO_UBM_Sleep_Dynamic_Parameters = 0x122B,
  eSQF_LOG_Internal__MFLO_UBM_IFT_Dynamic_Parameters = 0x122C,
  eSQF_LOG_Internal__MFLO_UBM_AFC_Dynamic_Parameters = 0x122D,
  eSQF_LOG_Internal__MFLO_UBM_DMTT_Dynamic_Parameters = 0x122E,
  eSQF_LOG_Internal__MFLO_UBM_IC_Dynamic_Parameters = 0x122F,
  eSQF_LOG_Internal__MFLO_UBM_MFN_RF_Table_Parameters = 0x1230,
  eSQF_LOG_Internal__MFLO_UBM_RSSI_Value_Dynamic_Parameters = 0x1231,
  eSQF_LOG_Internal__MFLO_UBM_Channel_Estimation_Log_Buffer = 0x1232,
  eSQF_LOG_Internal__MFLO_UBM_DVGA2_Log_Buffer = 0x1233,
  eSQF_LOG_Internal__MFLO_UBM_Sleep_Static_Parameters = 0x1234,
  eSQF_LOG_Internal__MFLO_UBM_Flow_Group_Parameters = 0x1235,
  eSQF_LOG_Internal__MFLO_UMB2_PPC_Data_Parameters = 0x1236,
  eSQF_LOG_Internal__MFLO_UBM_FDM_Message = 0x1237,
  eSQF_LOG_Internal__MFLO_UBM_NDM_Message = 0x1238,
  eSQF_LOG_Internal__MFLO_UBM2_SPC_Parameters = 0x1239,
  eSQF_LOG_MFLO_UBM2_DSP_Channel_Estimates = 0x123A,
  eSQF_LOG_Internal__MFLO_UBM2_Jammer_Params = 0x123B,
  eSQF_LOG_Internal__MFLO_UBM2_Doppler_Params = 0x123C,
  eSQF_LOG_MFLO_Superframe_Error_Rate_SFER = 0x123D,
  eSQF_LOG_Interference_Estimation_Based_On_TPC = 0x1241,
  eSQF_LOG_GPS_Demodulation_Tracking_Header = 0x1250,
  eSQF_LOG_GPS_Demodulation_Tracking_Results = 0x1251,
  eSQF_LOG_GPS_Demodulation_Bit_Edge = 0x1252,
  eSQF_LOG_GPS_Demodulation_Soft_Decisions = 0x1253,
  eSQF_LOG_GPS_PostProcessed_Demodulation_Tracking_Results = 0x1254,
  eSQF_LOG_GPS_Demodulation_Subframe = 0x1255,
  eSQF_LOG_FCPCCH_Quality_Information = 0x1256,
  eSQF_LOG_Reverse_PDCCH__PDCH_Frame_Information = 0x1257,
  eSQF_LOG_Forward_G_Channel_Information = 0x1258,
  eSQF_LOG_Forward_G_Channel_Frame_Information = 0x1259,
  eSQF_LOG_Forward_RC_Channel_Information = 0x125A,
  eSQF_LOG_Forward_ACK_Channel_Information = 0x125B,
  eSQF_LOG_Forward_ACK_Channel_ACKDA_Information = 0x125C,
  eSQF_LOG_Reverse_REQ_Channel_Information = 0x125D,
  eSQF_LOG_Sleep_Task_Statistics = 0x125E,
  eSQF_LOG_1x_Sleep_Controller_Statistics = 0x125F,
  eSQF_LOG_1xEVDO_Sleep_Controller_Statistics = 0x1260,
  eSQF_LOG_GSM_Sleep_Controller_Statistics = 0x1261,
  eSQF_LOG_WCDMA_Sleep_Controller_Statistics = 0x1262,
  eSQF_LOG_Sleep_Application_Statistics = 0x1263,
  //eSQF_LOG_Sleep_Statistics_Reserved = 0x1264,
  //eSQF_LOG_Sleep_Statistics_Reserved = 0x1265,
  eSQF_LOG_PDCCH_LO_Selected = 0x1266,
  eSQF_LOG_PDCCH_HI_Selected = 0x1267,
  eSQF_LOG_WALSH_Selected = 0x1268,
  eSQF_LOG_PDCH_BE_Selected = 0x1269,
  eSQF_LOG_PDCCH_LLR_Selected = 0x126A,
  eSQF_LOG_CQIACK_LO_Selected = 0x126B,
  eSQF_LOG_CQIACK_HI_Selected = 0x126C,
  eSQF_LOG_RLGAIN_Selected = 0x126D,
  eSQF_LOG_PDCCH0SNDA_Selected = 0x126E,
  eSQF_LOG_PDCCH1SNDA_Selected = 0x126F,
  eSQF_LOG_WMS_Message_List = 0x1270,
  eSQF_LOG_Multimode_Generic_SIM_Driver_Interface = 0x1271,
  eSQF_LOG_Generic_SIM_Toolkit_Task = 0x1272,
  eSQF_LOG_Call_Manager_Phone_Events = 0x1273,
  eSQF_LOG_WMS_Set_Message_List = 0x1274,
  eSQF_LOG_1xEVDO_MultiRLP_Reverse_Statistics = 0x1275,
  eSQF_LOG_1xEVDO_MultiRLP_Forward_Statistics = 0x1276,
  eSQF_LOG_1xEVDO_MultiRLP_RX_Partial_Frames = 0x1277,
  eSQF_LOG_1xEVDO_MultiRLP_TX_Partial_Frames = 0x1278,
  eSQF_LOG_1xEVDO_Equalizer_Data = 0x1279,
  eSQF_LOG_1xEVDO_Equalizer_C_I = 0x127A,
  //eSQF_LOG_1xEVDO_Reserved = 0x127B,
  eSQF_LOG_1xEVDO_Searcher_Version_3 = 0x127C,
  eSQF_LOG_1xEVDO_Rev_A_RL_Gains = 0x127D,
  eSQF_LOG_1xEVDO_Rev_A_Reverse_Link_Metrics = 0x127E,
  eSQF_LOG_1xEVDO_Rev_A_RMAC3_T2P_Resource = 0x127F,
  eSQF_LOG_1xEVDO_Rev_A_RMAC3_Packet_Information = 0x1280,
  eSQF_LOG_1xEVDO_Rev_A_RAB_Update_Information = 0x1281,
  eSQF_LOG_1xEVDO_DRC_ARQ_DSC_Buffer = 0x1282,
  eSQF_LOG_Internal__1xEVDO_Rev_A_MultiUser_Packet_User_Statistics = 0x1283,
  eSQF_LOG_1xEVDO_Forward_Link_Packet_Header_Information = 0x1284,
  eSQF_LOG_1xEVDO_Rev_A_Reverse_Link_ARQ_Status = 0x1285,
  eSQF_LOG_1xEVDO_Rev_A_Reverse_Link_Packet_Status = 0x1286,
  eSQF_LOG_1xEVDO_Rev_A_PCP_Packet_Statistics = 0x1289,
  eSQF_LOG_1xEVDO_Subtype_Stream_Config = 0x128A,
  eSQF_LOG_1xEVDO_Rev_A_Route_Update_Trigger_Code_List = 0x128B,
  eSQF_LOG_1xEVDO_Enhanced_MultiRLP_Forward_Statistics = 0x128C,
  eSQF_LOG_1xEVDO_Enhanced_MultiRLP_Reverse_Statistics = 0x128D,
  eSQF_LOG_1xEVDO_Enhanced_MultiRLP_RX_Partial_Frames = 0x128E,
  eSQF_LOG_1xEVDO_Enhanced_MultiRLP_TX_Partial_Frames = 0x128F,
  eSQF_LOG_Internal__1xEVDO_Platinum_Multicast_Rate_Metrics = 0x1290,
  eSQF_LOG_1xEVDO_Platinum_Multicast_Timing_Synchronization_Algorithm = 0x1291,
  eSQF_LOG_1xEV_Enhanced_Access_Attempt = 0x1292,
  eSQF_LOG_1xEV_Access_Probe = 0x1293,
  eSQF_LOG_1xEVDO_Multi_Carrier_Forward_Link_Packet_Header_Info = 0x1294,
  eSQF_LOG_1xEVDO_Multi_Carrier_Finger_Data = 0x1295,
  eSQF_LOG_1xEVDO_Multi_Carrier_Air_Link_Summary = 0x1296,
  eSQF_LOG_1xEVDO_Multi_Carrier_Searcher_Data = 0x1297,
  eSQF_LOG_1xEVDO_Multi_Carrier_DRC_ARQ_DSC_Buffer = 0x1298,
  eSQF_LOG_1xEVDO_Multi_Carrier_RMAC4_T2P_Resource_Info = 0x1299,
  eSQF_LOG_1xEVDO_Multi_Carrier_RMAC4_Packet_Info = 0x129A,
  eSQF_LOG_Internal__1xEVDO_Multi_Carrier_RMAC_Packet_Build_Load_Time_Info = 0x129B,
  eSQF_LOG_1xEVDO_Multi_Carrier_Power = 0x129C,
  eSQF_LOG_1xEVDO_Multi_Carrier_Reverse_Link_Gains = 0x129D,
  eSQF_LOG_1xEVDO_Multi_Carrier_Reverse_Link_ARQ_Status = 0x129E,
  eSQF_LOG_1xEVDO_Multi_Carrier_Reverse_Link_Metrics = 0x129F,
  eSQF_LOG_1xEVDO_Multi_Carrier_RAB_Update_Info = 0x12A0,
  eSQF_LOG_1xEVDO_Multi_Carrier_Pilot_Sets = 0x12A1,
  eSQF_LOG_1xEVDO_Multi_Carrier_Single_User_Packet_Forward_Statistics = 0x12A2,
  eSQF_LOG_1xEVDO_Multi_Carrier_MultiUser_Packet_Forward_Statistics = 0x12A3,
  eSQF_LOG_1xEVDO_Enhanced_Sleep_Information = 0x12A4,
  eSQF_LOG_1xEVDO_Multilink_Multiflow_RLP_Forward_Statistics = 0x12A5,
  eSQF_LOG_1xEVDO_Multilink_Multiflow_RLP_Reverse_Statistics = 0x12A6,
  eSQF_LOG_1xEVDO_Multilink_Multiflow_RLP_RX_Packet = 0x12A7,
  eSQF_LOG_1xEVDO_Multilink_Multiflow_RLP_TX_Packet = 0x12A8,
  eSQF_LOG_1xEVDO_Multilink_Multiflow_RLP_RX_Processing = 0x12A9,
  eSQF_LOG_1xEVDO_Multi_Carrier_Reverse_Link_Packet_Status = 0x12AA,
  eSQF_LOG_1xEVDO_Multi_Carrier_Equalizer_C2I_Buffer = 0x12AB,
  eSQF_LOG_Internal__1xEVDO_Platinum_Multicast_Noise_Variance_Estimation_Algorithm = 0x12AC,
  eSQF_LOG_1xEVDO_Multi_Carrier_Equalizer_Data = 0x12AD,
  eSQF_LOG_1xEVDO_Platinum_Multicast_Channel_Estimation_Algorithm = 0x12AE,
  eSQF_LOG_Internal__1xEVDO_Multi_Carrier_PA_Headroom_And_Carrier_Management = 0x12AF,
  eSQF_LOG_1xEVDO_Multi_Carrier_Forward_Link_Physical_Layer_Packet = 0x12B0,
  eSQF_LOG_1xEVDO_Multi_Carrier_Reverse_Link_Physical_Layer_Packet = 0x12B1,
  eSQF_LOG_Internal__1xEVDO_Multi_Carrier_MultiUser_Packet_User_Statistics = 0x12B2,
  eSQF_LOG_1xEVDO_Multi_Carrier_PCP_Packet_Statistics = 0x12B3,
  eSQF_LOG_Internal__1xEVDO_Platinum_Multicast_Pilot_Detection_Algorithm = 0x12B4,
  eSQF_LOG_1xEVDO_Overhead_Cache_Summary = 0x12B5,
  eSQF_LOG_1xEVDO_Pilot_Sets_Version_3 = 0x12B6,
  eSQF_LOG_HDR_MultiRLP_RX_Partial_Frames = 0x12B7,
  eSQF_LOG_HDR_MultiRLP_TX_Partial_Frames = 0x12B8,
  eSQF_LOG_HDR_ARD_Event = 0x12B9,
  eSQF_LOG_HDR_sTxD_Event_Log = 0x12BA,
  eSQF_LOG_HDR_RevA_FlexConn = 0x12BB,
  eSQF_LOG_HDR_RevA_DTX = 0x12BC,
  eSQF_LOG_HDR_RevB_FlexConn = 0x12BD,
  eSQF_LOG_HDR_RevB_DTX = 0x12BE,
  eSQF_LOG_NLB_Stats_Log = 0x12BF,
  eSQF_LOG_Call_Manager_Call_Event = 0x12C1,
  eSQF_LOG_GPS_PE_Position_Report = 0x12E3,
  eSQF_LOG_Internal__GPS_PE_Position_Report_Extended = 0x12E4,
  eSQF_LOG_Mobile_Display_Digital_Interface_Host_Statistics = 0x12E5,
  eSQF_LOG_GPS_Decoded_Ephemeris = 0x12E6,
  eSQF_LOG_GPS_Decoded_Almanac = 0x12E7,
  eSQF_LOG_Transceiver_Resource_Manager = 0x12E8,
  eSQF_LOG_Internal__GPS_Position_Engine_Info = 0x12E9,
  eSQF_LOG_Mobile_View_GPS_Position = 0x12F1,
  eSQF_LOG_QoS_Requested = 0x132B,
  eSQF_LOG_QoS_Granted = 0x132C,
  eSQF_LOG_QoS_State = 0x132D,
  eSQF_LOG_QoS_Modified = 0x132E,
  eSQF_LOG_QDJ_Enqueue = 0x132F,
  eSQF_LOG_QDJ_Dequeue = 0x1330,
  eSQF_LOG_QDJ_Update = 0x1331,
  eSQF_LOG_QDTX_Encoder = 0x1332,
  eSQF_LOG_QDTX_Decoder = 0x1333,
  eSQF_LOG_Port_Assignment_Status = 0x1334,
  eSQF_LOG_Global_IPv4_Statistics = 0x1335,
  eSQF_LOG_Global_IPv6_Statistics = 0x1336,
  eSQF_LOG_Global_ICMPv4_Statistics = 0x1337,
  eSQF_LOG_Global_ICMPv6_Statistics = 0x1338,
  eSQF_LOG_Global_TCP_Statistics = 0x1339,
  eSQF_LOG_Global_UDP_Statistics = 0x133A,
  eSQF_LOG_PS_Statistics_Describe_All_TCP_Instances = 0x133B,
  eSQF_LOG_PS_Statistics_Describe_All_Memory_Pool_Instances = 0x133C,
  eSQF_LOG_PS_Statistics_Describe_All_IFACE_Instances = 0x133D,
  eSQF_LOG_PS_Statistics_Describe_All_PPP_Instances = 0x133E,
  eSQF_LOG_PS_Statistics_Describe_All_ARP_Instances = 0x133F,
  eSQF_LOG_PS_Statistics_Describe_Delta_Instances = 0x1340,
  eSQF_LOG_PS_Statistics_Describe_Instance_TCP_Statistics = 0x1341,
  eSQF_LOG_PS_Statistics_Describe_Instance_UDP_Statistics = 0x1342,
  eSQF_LOG_PS_Statistics_Describe_Instance_PPP_Statistics = 0x1343,
  eSQF_LOG_PS_Statistics_Describe_Instance_IFACE_Statistics = 0x1344,
  eSQF_LOG_PS_Statistics_Describe_Instance_Memory_Statistics = 0x1345,
  eSQF_LOG_PS_Statistics_Describe_Instance_Flow_Statistics = 0x1346,
  eSQF_LOG_PS_Statistics_Describe_Instance_Physical_Link_Statistics = 0x1347,
  eSQF_LOG_PS_Statistics_Describe_Instance_ARP_Statistics = 0x1348,
  eSQF_LOG_PS_Statistics_Describe_Instance_LLC_Statistics = 0x1349,
  eSQF_LOG_PS_Statistics_Describe_Instance_IPHC_Statistics = 0x134A,
  eSQF_LOG_PS_Statistics_Describe_Instance_ROHC_Statistics = 0x134B,
  eSQF_LOG_PS_Statistics_Describe_Instance_RSVP_Statistics = 0x134C,
  eSQF_LOG_PS_Statistics_Describe_All_LLC_Instances = 0x134D,
  eSQF_LOG_PS_Statistics_Describe_All_RSVP_Instances = 0x134E,
  eSQF_LOG_Call_Manager_Serving_System_Event = 0x134F,
  eSQF_LOG_VcTcxo_Manager_Automatic_Frequency_Control = 0x1350,
  eSQF_LOG_Internal__Clock_Transaction_And_Status = 0x1351,
  eSQF_LOG_GPS_Processed_Peak = 0x1352,
  eSQF_LOG_MDSP_Log_Chunks = 0x1353,
  eSQF_LOG_WLAN_RSSI_Update = 0x1354,
  eSQF_LOG_WLAN_LL_Statistics = 0x1355,
  eSQF_LOG_QoS_State_Information = 0x1356,
  eSQF_LOG_BT_Host_HCI_TX_Data = 0x1357,
  eSQF_LOG_BT_Host_HCI_RX_Data = 0x1358,
  eSQF_LOG_Internal__GPS_PE_Position_Report_Part_3 = 0x1359,
  eSQF_LOG_QoS_Extended_Requested = 0x135A,
  eSQF_LOG_QoS_Extended_Granted = 0x135B,
  eSQF_LOG_QoS_Extended_Modified = 0x135C,
  eSQF_LOG_Bus_Monitor_Profiling_Info = 0x135D,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_Search_Results_V2 = 0x135E,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_Database_V2 = 0x135F,
  eSQF_LOG_Internal__Pilot_Phase_Measurement_State_Machine = 0x1360,
  eSQF_LOG_ROHC_Compressor = 0x1361,
  eSQF_LOG_ROHC_Decompressor = 0x1362,
  eSQF_LOG_ROHC_Feedback_Compressor = 0x1363,
  eSQF_LOG_ROHC_Feedback_Decompressor = 0x1364,
  eSQF_LOG_BT_HCI_Command = 0x1365,
  eSQF_LOG_BT_HCI_Event = 0x1366,
  eSQF_LOG_BT_HCI_TX_ACL_Data = 0x1367,
  eSQF_LOG_BT_HCI_RX_ACL_Data = 0x1368,
  eSQF_LOG_BT_SOC_H4_Deep_Sleep = 0x1369,
  eSQF_LOG_Obsolete__UMTS_To_CDMA_Handover_Message = 0x136A,
  eSQF_LOG_QX_Profiler_Graphic_Event_Data = 0x136B,
  eSQF_LOG_QX_Profiler_Audio_Event_Data = 0x136C,
  eSQF_LOG_Internal__GPS_Spectral_Information = 0x136D,
  eSQF_LOG_AHB_Performance_Monitor = 0x136E,
  eSQF_LOG_CGPS_Clock_Report = 0x136F,
  eSQF_LOG_CGPS_Position_Report = 0x1370,
  eSQF_LOG_CGPS_Measurement_Report = 0x1371,
  eSQF_LOG_CGPS_RF_Status = 0x1372,
  eSQF_LOG_Obsolete__VOIP_To_CDMA_Handover_Message = 0x1373,
  eSQF_LOG_CGPS_Prescribed_Dwell_Result = 0x1374,
  eSQF_LOG_Internal__CGPS_IPC_Data = 0x1375,
  eSQF_LOG_Internal__CGPS_Non_IPC_Data = 0x1376,
  eSQF_LOG_Internal__CGPS_Session_Report = 0x1377,
  eSQF_LOG_Internal__CGPS_PDSM_Get_Position = 0x1378,
  eSQF_LOG_Internal__CGPS_PDSM_Set_Parameters = 0x1379,
  eSQF_LOG_Internal__CGPS_PDSM_End_Session = 0x137A,
  eSQF_LOG_Internal__CGPS_PDSM_Notify_Verify_Response = 0x137B,
  eSQF_LOG_CGPS_PDSM_Position_Report_Callback = 0x137C,
  eSQF_LOG_Internal__CGPS_PDSM_PD_Event_Callback = 0x137D,
  eSQF_LOG_Internal__CGPS_PDSM_PA_Event_Callback = 0x137E,
  eSQF_LOG_Internal__CGPS_PDSM_Notify_Verify_Request_Callback = 0x137F,
  eSQF_LOG_Internal__CGPS_PDSM_PD_Command_Error_Callback = 0x1380,
  eSQF_LOG_Internal__CGPS_PDSM_PA_Command_Error_Callback = 0x1381,
  eSQF_LOG_Internal__CGPS_PDSM_Position_Error = 0x1382,
  eSQF_LOG_CGPS_PDSM_Extended_Status_Position_Report = 0x1383,
  eSQF_LOG_CGPS_PDSM_Extended_Status_NMEA_Report = 0x1384,
  eSQF_LOG_Internal__CGPS_PDSM_Extended_Status_Measurement_Report = 0x1385,
  eSQF_LOG_Internal__CGPS_Report_Server_TX_Packet = 0x1386,
  eSQF_LOG_Internal__CGPS_Report_Server_RX_Packet = 0x1387,
  eSQF_LOG_CGPS_IQ_Report = 0x138A,
  eSQF_LOG_QMI_Link_1_RX_PDU = 0x138E,
  eSQF_LOG_QMI_Link_1_TX_PDU = 0x138F,
  eSQF_LOG_QMI_Link_2_RX_PDU = 0x1390,
  eSQF_LOG_QMI_Link_2_TX_PDU = 0x1391,
  eSQF_LOG_QMI_Link_3_RX_PDU = 0x1392,
  eSQF_LOG_QMI_Link_3_TX_PDU = 0x1393,
  eSQF_LOG_QMI_Link_4_RX_PDU = 0x1394,
  eSQF_LOG_QMI_Link_4_TX_PDU = 0x1395,
  eSQF_LOG_QMI_Link_5_RX_PDU = 0x1396,
  eSQF_LOG_QMI_Link_5_TX_PDU = 0x1397,
  eSQF_LOG_QMI_Link_6_RX_PDU = 0x1398,
  eSQF_LOG_QMI_Link_6_TX_PDU = 0x1399,
  eSQF_LOG_QMI_Link_7_RX_PDU = 0x139A,
  eSQF_LOG_QMI_Link_7_TX_PDU = 0x139B,
  eSQF_LOG_QMI_Link_8_RX_PDU = 0x139C,
  eSQF_LOG_QMI_Link_8_TX_PDU = 0x139D,
  eSQF_LOG_QMI_Link_9_RX_PDU = 0x139E,
  eSQF_LOG_QMI_Link_9_TX_PDU = 0x139F,
  eSQF_LOG_QMI_Link_10_RX_PDU = 0x13A0,
  eSQF_LOG_QMI_Link_10_TX_PDU = 0x13A1,
  eSQF_LOG_QMI_Link_11_RX_PDU = 0x13A2,
  eSQF_LOG_QMI_Link_11_TX_PDU = 0x13A3,
  eSQF_LOG_QMI_Link_12_RX_PDU = 0x13A4,
  eSQF_LOG_QMI_Link_12_TX_PDU = 0x13A5,
  eSQF_LOG_QMI_Link_13_RX_PDU = 0x13A6,
  eSQF_LOG_QMI_Link_13_TX_PDU = 0x13A7,
  eSQF_LOG_QMI_Link_14_RX_PDU = 0x13A8,
  eSQF_LOG_QMI_Link_14_TX_PDU = 0x13A9,
  eSQF_LOG_QMI_Link_15_RX_PDU = 0x13AA,
  eSQF_LOG_QMI_Link_15_TX_PDU = 0x13AB,
  eSQF_LOG_QMI_Link_16_RX_PDU = 0x13AC,
  eSQF_LOG_QMI_Link_16_TX_PDU = 0x13AD,
  eSQF_LOG_QoS_Information_Code_Update = 0x13AF,
  eSQF_LOG_Audio_Vocoder_Data_Paths = 0x13B0,
  eSQF_LOG_Decoded_Video_Frame_CRC = 0x13B2,
  eSQF_LOG_FLUTE_Session_Info = 0x13B3,
  eSQF_LOG_FLUTE_ADP_File_Info = 0x13B4,
  eSQF_LOG_FLUTE_File_Request_Info = 0x13B5,
  eSQF_LOG_FLUTE_FDT_Instance_Info = 0x13B6,
  eSQF_LOG_FLUTE_FDT_Info = 0x13B7,
  eSQF_LOG_FLUTE_File_Info = 0x13B8,
  eSQF_LOG_VOIP_To_CDMA_3G1X_Parameters = 0x13B9,
  eSQF_LOG_Internal__CGPS_ME_Job_Info = 0x13BA,
  eSQF_LOG_Internal__CGPS_ME_SV_Lists = 0x13BB,
  eSQF_LOG_Flexible_Profiling_Generic_Status = 0x13BC,
  eSQF_LOG_Flexible_Profiling_Generic_Results = 0x13BD,
  eSQF_LOG_FLUTE_ADP_File_Content_Info = 0x13BE,
  eSQF_LOG_FLUTE_FDT_Instance_File_Content_Info = 0x13BF,
  eSQF_LOG_FLUTE_FDT_Entries_Info = 0x13C0,
  eSQF_LOG_FLUTE_File_Contents_Info = 0x13C1,
  eSQF_LOG_Internal__CGPS_ME_Time_Transfer_Information = 0x13C2,
  eSQF_LOG_Internal__CGPS_ME_UMTS_Time_Tagging_Information = 0x13C3,
  eSQF_LOG_Internal__CGPS_ME_Generic_Time_Estimate_Put_lnformation = 0x13C4,
  eSQF_LOG_Internal__CGPS_ME_Generic_Frequency_Estimate_Put_lnformation = 0x13C5,
  eSQF_LOG_Internal__CGPS_Slow_Clock_Report = 0x13C6,
  eSQF_LOG_Internal__CGPS_Medium_Grid = 0x13C7,
  eSQF_LOG_SNSD_Information = 0x13C8,
  eSQF_LOG_SNSD_State = 0x13C9,
  eSQF_LOG_SNSD_Data = 0x13CA,
  eSQF_LOG_Internal__CGPS_Cell_DB_Cell_Change_Information = 0x13CB,
  eSQF_LOG_X_Scale_YUV_Frame = 0x13CC,
  eSQF_LOG_X_Scale_CRC_Frame = 0x13CD,
  eSQF_LOG_Internal__CGPS_Frequency_Estimate_Report = 0x13CE,
  eSQF_LOG_Internal__GPS_DCME_Srch_Job_Completed = 0x13CF,
  eSQF_LOG_Internal__CGPS_ME_Fast_Scan_Results = 0x13D0,
  eSQF_LOG_XO_Frequency_Estimation = 0x13D1,
  eSQF_LOG_TCXO_Manager_Field_Calibration_Data = 0x13D2,
  eSQF_LOG_UMB_Call_Processing_Connection_Attempt = 0x13D3,
  eSQF_LOG_UMB_Call_Processing_Connection_Release = 0x13D4,
  eSQF_LOG_UMB_Call_Processing_Page_Message = 0x13D5,
  eSQF_LOG_UMB_Call_Processing_OVHD_Information = 0x13D6,
  eSQF_LOG_UMB_Call_Processing_Session_Attempt = 0x13D7,
  eSQF_LOG_UMB_Call_Processing_Route_Information = 0x13D8,
  eSQF_LOG_UMB_Call_Processing_State_Information = 0x13D9,
  eSQF_LOG_UMB_Call_Processing_SNP = 0x13DA,
  eSQF_LOG_Internal__CGPS_Session_Early_Exit_Decision = 0x13DB,
  eSQF_LOG_CGPS_ME_RF_Linearity_Status = 0x13DC,
  eSQF_LOG_Internal__CGPS_ME_5ms_IQ_Sums = 0x13DD,
  eSQF_LOG_Internal__CGPS_ME_20ms_IQ_Sums = 0x13DE,
  eSQF_LOG_ROHC_Compressor_Statistics = 0x13DF,
  eSQF_LOG_ROHC_Decompressor_Statistics = 0x13E0,
  eSQF_LOG_Sensor_Kalman_Filter_Information = 0x13E1,
  eSQF_LOG_Sensor_Integrated_Measurements = 0x13E2,
  eSQF_LOG_Sensor_Bias_Calibration_Values = 0x13E3,
  eSQF_LOG_DTV_ISDBT_Transport_Stream_Packets = 0x13E4,
  eSQF_LOG_DTV_ISDBT_PES_Packets = 0x13E5,
  eSQF_LOG_DTV_ISDBT_Sections = 0x13E6,
  eSQF_LOG_DTV_ISDBT_Buffering = 0x13E7,
  eSQF_LOG_WLAN_System_Acquisition_And_Handoff = 0x13E8,
  eSQF_LOG_WLAN_General_Configurable_Parameters = 0x13E9,
  eSQF_LOG_Internal__UMB_Physical_Layer_Channel_And_Interference_Estimation = 0x13EA,
  eSQF_LOG_Internal__UMB_Physical_Layer_MMSE_MRC_Demodulated_Data_Symbols_Low = 0x13EB,
  eSQF_LOG_Internal__UMB_Physical_Layer_MMSE_MRC_Demodulated_Data_Symbols_High = 0x13EC,
  eSQF_LOG_Internal__UMB_Physical_Layer_DCH_Decoder = 0x13ED,
  eSQF_LOG_Internal__UMB_Physical_Layer_DCH_Statistics = 0x13EE,
  eSQF_LOG_Internal__UMB_Physical_Layer_CQI_PICH_Processing = 0x13EF,
  eSQF_LOG_Internal__UMB_Physical_Layer_MIMO_SIMO_In_CQI_PICH_High = 0x13F0,
  eSQF_LOG_Internal__UMB_Physical_Layer_MIMO_SIMO_In_CQI_PICH_Low = 0x13F1,
  eSQF_LOG_Internal__UMB_Physical_Layer_TimeDomain_Channel_Taps_High = 0x13F2,
  eSQF_LOG_Internal__UMB_Physical_Layer_TimeDomain_Channel_Taps_Low = 0x13F3,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator = 0x13F4,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RACK_High = 0x13F5,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RACK_Low = 0x13F6,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RPICH = 0x13F7,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RACH_Access = 0x13F8,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RODDCCH_High = 0x13F9,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RODDCCH_Low = 0x13FA,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RCDCCH = 0x13FB,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_Non_FLSS_CQI_Sent_On_RCDCCH = 0x13FC,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_FLSS_CQI_Sent_On_RCDCCH = 0x13FD,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_PACH_Sent_On_RCDCCH = 0x13FE,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_REQ_Sent_On_RCDCCH = 0x13FF,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_PSD_Sent_On_RCDCCH = 0x1400,
  eSQF_LOG_Internal__UMB_Physical_Layer_AT_Modulator_For_RDCH = 0x1401,
  eSQF_LOG_Internal__UMB_Physical_Layer_Time_Frequency_RX_Power_Estimate = 0x1402,
  eSQF_LOG_Internal__UMB_Physical_Layer_FLCS_Processing = 0x1403,
  eSQF_LOG_Internal__UMB_Physical_Layer_PBCCH_Processing = 0x1404,
  eSQF_LOG_Internal__UMB_Physical_Layer_SBCCH_Processing = 0x1405,
  eSQF_LOG_Internal__UMB_Physical_Layer_QPCH_Processing = 0x1406,
  eSQF_LOG_Internal__UMB_Physical_Layer_MRC_Demodulated_Data_Symbols_Preamble_SBCCH_QPCH = 0x1407,
  eSQF_LOG_Internal__UMB_Physical_Layer_MRC_Demodulated_Data_Symbols_Preamble_PBCCH = 0x1408,
  eSQF_LOG_Internal__UMB_Physical_Layer_VCQI = 0x1409,
  eSQF_LOG_Internal__UMB_Physical_Layer_Acquisition_Algorithm = 0x140A,
  eSQF_LOG_Internal__UMB_Physical_Layer_Handoff_Search_Algorithm = 0x140B,
  eSQF_LOG_Internal__UMB_RF_RFFE_Configuration_Info = 0x140C,
  eSQF_LOG_Internal__UMB_RF_Calibrated_Values_After_Powerup = 0x140D,
  eSQF_LOG_Internal__UMB_RF_AGC_Block_In_Acquisition_Mode = 0x140E,
  eSQF_LOG_Internal__UMB_RF_AGC_Block_In_Idle_Mode = 0x140F,
  eSQF_LOG_Internal__UMB_RF_AGC_Block_In_Connected_Mode = 0x1410,
  eSQF_LOG_Internal__UMB_RF_AGC_Block_In_Connected_Mode_FTM = 0x1411,
  eSQF_LOG_Internal__UMB_RF_Jammer_Detector_Functionality = 0x1412,
  eSQF_LOG_Internal__UMB_RF_Jammer_Detector_Response = 0x1413,
  eSQF_LOG_Internal__UMB_RF_RFFE_TX_Power_Control = 0x1414,
  eSQF_LOG_Internal__UMB_Searcher_Dump = 0x1415,
  eSQF_LOG_Internal__UMB_System_Acquire = 0x1416,
  eSQF_LOG_Internal__UMB_Set_Maintenance = 0x1417,
  eSQF_LOG_Internal__UMB_QPCH = 0x1418,
  eSQF_LOG_Internal__UMB_RLL_Forward_Partial_RP_Packet = 0x1419,
  eSQF_LOG_Internal__UMB_RLL_Reverse_Partial_RP_Packet = 0x141A,
  eSQF_LOG_Internal__UMB_RLL_Forward_Statistics = 0x141D,
  eSQF_LOG_Internal__UMB_RLL_Reverse_Statistics = 0x141E,
  eSQF_LOG_Internal__UMB_RLL_IRTP = 0x141F,
  eSQF_LOG_Internal__UMB_AP_Forward_Link_MAC_Packets = 0x1420,
  eSQF_LOG_Internal__UMB_AP_Reverse_Link_MAC_Packets = 0x1421,
  eSQF_LOG_Internal__CGPS_Performance_Statistics = 0x1422,
  eSQF_LOG_Internal__UMB_Searcher_General_Status = 0x1423,
  eSQF_LOG_Internal__UMB_Superframe_Scheduler = 0x1424,
  eSQF_LOG_Internal__UMB_Sector_List = 0x1425,
  eSQF_LOG_Internal__UMB_MAC_Access_Attempt_Command = 0x1426,
  eSQF_LOG_Internal__UMB_MAC_Access_Probe_Information = 0x1427,
  eSQF_LOG_Internal__UMB_MAC_RTCMAC_Package_Information = 0x1428,
  eSQF_LOG_Internal__UMB_MAC_Super_Frame_Information = 0x1429,
  eSQF_LOG_Internal__UMB_MAC_Quick_Channel_Information = 0x142A,
  eSQF_LOG_Internal__UMB_MAC_Paging_ID_List = 0x142B,
  eSQF_LOG_Internal__UMB_MAC_Quick_Paging_Channel_Information = 0x142C,
  eSQF_LOG_Internal__UMB_MAC_FTCMAC_Information = 0x142D,
  eSQF_LOG_Internal__UMB_MAC_Access_Grant_Receiving = 0x142E,
  eSQF_LOG_Internal__UMB_MAC_Generic_Debug = 0x142F,
  eSQF_LOG_Internal__CGPS_MC_Frequency_Bias_Estimate = 0x1430,
  eSQF_LOG_Internal__UMB_MAC_Request_Report_Information = 0x1431,
  eSQF_LOG_Internal__UMB_MAC_Reverse_Link_QoS_Token_Bucket_Information = 0x1432,
  eSQF_LOG_Internal__UMB_MAC_Reverse_Link_QoS_Stream_Information = 0x1433,
  eSQF_LOG_Internal__UMB_MAC_Reverse_Link_QoS_Allotment_Information = 0x1434,
  eSQF_LOG_Internal__UMB_Searcher_Recent_State_Machine_Transactions = 0x1435,
  eSQF_LOG_ARM_11_Performance_Counters_Profiling_Information = 0x1436,
  eSQF_LOG_PS_Statistics_Describe_All_Flow_Instances = 0x1437,
  eSQF_LOG_PS_Statistics_Describe_All_Physical_Link_Instances = 0x1438,
  eSQF_LOG_PS_Statistics_Describe_All_UDP_Instances = 0x1439,
  eSQF_LOG_Searcher_4_Multi_Carrier_HDR = 0x143A,
  eSQF_LOG_PS_Statistics_Describe_All_IPHC_Instances = 0x143B,
  eSQF_LOG_PS_Statistics_Describe_All_ROHC_Instances = 0x143C,
  eSQF_LOG_Internal__BCast_Security_Add_Program_Information = 0x143D,
  eSQF_LOG_Internal__BCast_Security_Add_Program_Complete = 0x143E,
  eSQF_LOG_Internal__BCast_Security_SDP_Parse = 0x143F,
  eSQF_LOG_CGPS_ME_Dynamic_Power_Optimization_Status = 0x1440,
  eSQF_LOG_Internal__CGPS_PDSM_On_Demand_Session_Start = 0x1441,
  eSQF_LOG_Internal__CGPS_PDSM_On_Demand_Session_Stop = 0x1442,
  eSQF_LOG_Internal__CGPS_PDSM_On_Demand_Session_Not_Started = 0x1443,
  eSQF_LOG_Internal__CGPS_PDSM_Extern_Coarse_Position_Inject_Start = 0x1444,
  eSQF_LOG_DTV_ISDBT_TMCC_Information = 0x1445,
  eSQF_LOG_Internal__RF_Development = 0x1446,
  eSQF_LOG_RF_RFM_API = 0x1447,
  eSQF_LOG_RF_RFM_State = 0x1448,
  eSQF_LOG_1X_RF_Warmup = 0x1449,
  eSQF_LOG_1X_RF_Power_Limiting = 0x144A,
  eSQF_LOG_1X_RF_State = 0x144B,
  eSQF_LOG_1X_RF_Sleep = 0x144C,
  eSQF_LOG_1X_RF_TX_State = 0x144D,
  eSQF_LOG_1X_RF_IntelliCeiver_State = 0x144E,
  eSQF_LOG_1X_RF_RX_ADC_Clock = 0x144F,
  eSQF_LOG_1X_RF_LNA_Switch_Point = 0x1450,
  eSQF_LOG_1X_RF_RX_Calibration = 0x1451,
  eSQF_LOG_1X_RF_API = 0x1452,
  eSQF_LOG_1X_RF_RX_PLL_Locking_Status = 0x1453,
  eSQF_LOG_1X_RF_Voltage_Regulator = 0x1454,
  eSQF_LOG_CGPS_DIAG_Successful_Fix_Count = 0x1455,
  eSQF_LOG_CGPS_MC_Track_Dynamic_Power_Optimization_Status = 0x1456,
  eSQF_LOG_CGPS_MC_SBAS_Demodulated_Bits = 0x1457,
  eSQF_LOG_Internal__CGPS_MC_SBAS_Demodulated_Soft_Symbols = 0x1458,
  eSQF_LOG_Data_Services_PPP_Configuration_Parameters = 0x1459,
  eSQF_LOG_Data_Services_Physical_Link_Configuration_Parameters = 0x145A,
  eSQF_LOG_Internal__PPP_Device_Configuration_Parameters = 0x145B,
  eSQF_LOG_Internal__CGPS_PDSM_GPS_State_Information = 0x145C,
  eSQF_LOG_Internal__CGPS_PDSM_EXT_Status_GPS_State_Information = 0x145D,
  eSQF_LOG_Internal__CGPS_ME_Rapid_Search_Report = 0x145E,
  eSQF_LOG_Internal__CGPS_PDSM_XTRA_T_Session = 0x145F,
  eSQF_LOG_Internal__CGPS_PDSM_XTRA_T_Upload = 0x1460,
  eSQF_LOG_Internal__GPS_Wiper_Position_Report = 0x1461,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_HTTP_Digest_Request = 0x1462,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_HTTP_Digest_Response = 0x1463,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Services_Registration_Request = 0x1464,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Services_Registration_Complete = 0x1465,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Services_Deregistration_Request = 0x1466,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Services_Deregistration_Complete = 0x1467,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_LTKM_Request = 0x1468,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_LTKM_Request_Complete = 0x1469,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Program_Selection = 0x146A,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_Program_Selection_Complete = 0x146B,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_LTKM = 0x146C,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_LTKM_Verification_Message = 0x146D,
  eSQF_LOG_DTV_DVBH_Security_SmartCard_STKM = 0x146F,
  eSQF_LOG_PS_Statistics_Global_Sock = 0x1470,
  eSQF_LOG_MCS_Application_Manager = 0x1471,
  eSQF_LOG_MCS_MSGR = 0x1472,
  eSQF_LOG_MCS_QTF = 0x1473,
  eSQF_LOG_Stationary_Dectector_Output = 0x1474,
  eSQF_LOG_CGPS_PDSM_EXT_Status_MEAS_Report_PPM = 0x1475,
  eSQF_LOG_GNSS_Position_Report = 0x1476,
  eSQF_LOG_GNSS_GPS_Measurement_Report = 0x1477,
  eSQF_LOG_GNSS_Clock_Report = 0x1478,
  eSQF_LOG_Internal__GNSS_Demod_Soft_Decisions = 0x1479,
  eSQF_LOG_Internal__GNSS_ME_5ms_IQ_Sums = 0x147A,
  eSQF_LOG_GNSS_CD_Database_Report = 0x147B,
  eSQF_LOG_Internal__GNSS_Position_Engine_WLS_Position_Report = 0x147C,
  eSQF_LOG_Internal__GNSS_Kalman_Filter_Position_Report = 0x147D,
  eSQF_LOG_GNSS_PRX_RF_HW_Status_Report = 0x147E,
  eSQF_LOG_GNSS_DRX_RF_HW_Status_Report = 0x147F,
  eSQF_LOG_GNSS_GLONASS_Measurement_Report = 0x1480,
  eSQF_LOG_GNSS_GPS_High_Bandwidth_Receive_Diversity_Measurement = 0x1481,
  eSQF_LOG_GNSS_PDSM_Position_Report_Callback = 0x1482,
  eSQF_LOG_Internal__ISense_Request_String = 0x1483,
  eSQF_LOG_Internal__ISense_Response_String = 0x1484,
  eSQF_LOG_Internal__BT_SOC_General = 0x1485,
  eSQF_LOG_QCRIL_Call_Flow = 0x1486,
  eSQF_LOG_CGPS_WB_FFT_Stats = 0x1487,
  eSQF_LOG_CGPS_Slow_Clock_Calibration_Report = 0x1488,
  eSQF_LOG_Internal__SNS_GPS_Timestamp = 0x1489,
  eSQF_LOG_Internal__GNSS_Search_Strategy_Task_Allocation = 0x148A,
  eSQF_LOG_Internal__CGPS_Sparse_Network_DB_Record = 0x148C,
  eSQF_LOG_Internal__CGPS_Sparse_Network_DB_Record_Remove = 0x148D,
  eSQF_LOG_Internal__GNSS_Channel_Controller_Performance_Statistics = 0x148E,
  eSQF_LOG_GNSS_PDSM_Set_Parameters = 0x148F,
  eSQF_LOG_GNSS_PDSM_PD_Event_Callback = 0x1490,
  eSQF_LOG_GNSS_PDSM_PA_Event_Call_back = 0x1491,
  eSQF_LOG_GNSS_PDSM_Ext_Status_MEAS_Report = 0x1494,
  eSQF_LOG_GNSS_SM_Error = 0x1495,
  eSQF_LOG_Internal__WLAN_Scan = 0x1496,
  eSQF_LOG_Internal__WLAN_IBSS = 0x1497,
  eSQF_LOG_Internal__WLAN_802_11d = 0x1498,
  eSQF_LOG_Internal__WLAN_Handoff = 0x1499,
  eSQF_LOG_Internal__WLAN_QoS_EDCA = 0x149A,
  eSQF_LOG_Internal__WLAN_Beacon_Update = 0x149B,
  eSQF_LOG_Internal__WLAN_Powersave_WOW_Add_Pattern = 0x149C,
  eSQF_LOG_Internal__WLAN_WCM_Linkmetrics = 0x149D,
  eSQF_LOG_Internal__WLAN_WPS_Scan_Complete = 0x149E,
  eSQF_LOG_Internal__WLAN_WPS_Credentials = 0x14A0,
  eSQF_LOG_Internal__WLAN_Linklayer_Stat = 0x14A1,
  eSQF_LOG_Internal__WLAN_QoS_TSPEC = 0x14A2,
  eSQF_LOG_Internal__CGPS_SM_Ephemeris_Randomization_Information = 0x14A6,
  eSQF_LOG_Internal__QACT_Data = 0x14A7,
  eSQF_LOG_Internal__SNS_VCPS_Compass_2D_Tracked_Calibration_Set = 0x14A8,
  eSQF_LOG_Internal__SNS_VCPS_Compass_3D_Tracked_Calibration_Set = 0x14A9,
  eSQF_LOG_Internal__SNS_VCPS_Calibration_Set_Quantifying_Metric = 0x14AA,
  eSQF_LOG_Internal__SNS_VCPS_Filtered_Accelerometer_Data_Distance = 0x14AB,
  eSQF_LOG_Internal__SNS_VCPS_Plane_Update = 0x14AC,
  eSQF_LOG_Internal__SNS_VCPS_Location_Report = 0x14AD,
  eSQF_LOG_Internal__Sensor_MobiSens_Ouput = 0x14B0,
  eSQF_LOG_Internal__Accelerometer_Data = 0x14B1,
  eSQF_LOG_Internal__Accelerometer_Compensated_Data = 0x14B2,
  eSQF_LOG_Internal__Motion_State_Data = 0x14B3,
  eSQF_LOG_Internal__Stationary_Position_Indicator = 0x14B4,
  eSQF_LOG_Internal__Motion_State_Features = 0x14B5,
  eSQF_LOG_Internal__Motion_State_Hard_Decision = 0x14B6,
  eSQF_LOG_Internal__Motion_State_Soft_Decision = 0x14B7,
  eSQF_LOG_Internal__Sensors_Software_Version = 0x14B8,
  eSQF_LOG_Internal__MobiSens_Stationary_Position_Indicator = 0x14B9,
  eSQF_LOG_XO_IQ_Data = 0x14BA,
  eSQF_LOG_DTV_CMMB_Control_Table_Updated = 0x14BB,
  eSQF_LOG_DTV_CMMB_Media_API_Buffering_Status = 0x14BC,
  eSQF_LOG_DTV_CMMB_Emergency_Broadcast_Data = 0x14BD,
  eSQF_LOG_DTV_CMMB_EMM_ECM_Data = 0x14BE,
  eSQF_LOG_DTV_CMMB_HW_Status = 0x14BF,
  eSQF_LOG_DTV_CMMB_ESSG_Program_Indication_Information = 0x14C0,
  eSQF_LOG_SNS_Converted_Sensor_Data = 0x14C1,
  eSQF_LOG_CM_Subscription_Event = 0x14C2,
  eSQF_LOG_Internal__SNS_Ambient_Light_Data = 0x14C3,
  eSQF_LOG_Internal__SNS_Ambient_Light_Adaptive_Data = 0x14C4,
  eSQF_LOG_Internal__SNS_Proximity_Distance_Data = 0x14C5,
  eSQF_LOG_Internal__SNS_Proximity_Data = 0x14C6,
  eSQF_LOG_Internal__GNSS_SBAS_Report = 0x14C7,
  eSQF_LOG_Internal__CPU_Monitor_Modem = 0x14C8,
  eSQF_LOG_Internal__CPU_Monitor_Apps = 0x14C9,
  eSQF_LOG_BLAST_Task_Profiling = 0x14CA,
  eSQF_LOG_BLAST_System_Profiling = 0x14CB,
  eSQF_LOG_FM_Radio_FTM_Messages = 0x14CC,
  eSQF_LOG_FM_Radio_Debug_Messages = 0x14CD,
  eSQF_LOG_Internal__UIM_DS_Data = 0x14CE,
  eSQF_LOG_QMI_Call_Flow = 0x14CF,
  eSQF_LOG_Internal__APR_Modem = 0x14D0,
  eSQF_LOG_Internal__APR_Apps = 0x14D1,
  eSQF_LOG_APR_ADSP = 0x14D2,
  eSQF_LOG_Data_MUX_RX_Raw_Packet = 0x14D3,
  eSQF_LOG_Data_MUX_TX_Raw_Packet = 0x14D4,
  eSQF_LOG_Data_MUX_RX_Frame_Packet = 0x14D5,
  eSQF_LOG_Data_MUX_TX_Frame_Packet = 0x14D6,
  eSQF_LOG_Internal__CGPS_PDSM_EXT_Status_Pos_Inj_Request_Info = 0x14D7,
  eSQF_LOG_Temperature_Monitor_Log = 0x14D8,
  eSQF_LOG_Internal__SNS_Gestures_Rest_Detect = 0x14D9,
  eSQF_LOG_Internal__SNS_Gestures_Orientation = 0x14DA,
  eSQF_LOG_Internal__SNS_Gestures_Facing = 0x14DB,
  eSQF_LOG_Internal__SNS_Gestures_Basic = 0x14DC,
  eSQF_LOG_Internal__SNS_Gestures_HinBye = 0x14DD,
  eSQF_LOG_GNSS_OEMDRE_Measurement_Report = 0x14DE,
  eSQF_LOG_GNSS_OEMDRE_Position_Report = 0x14E0,
  eSQF_LOG_GNSS_OEMDRE_SVPoly_Report = 0x14E1,
  eSQF_LOG_GNSS_OEMDRE_Sync = 0x14E2,
  eSQF_LOG_Internal__Motion_Detect_Notification = 0x14E3,
  eSQF_LOG_Internal__Motion_Detect_Registration = 0x14E4,
  eSQF_LOG_Internal__GNSS_PDSM_PPM_Session_Begin = 0x14E5,
  eSQF_LOG_Internal__GNSS_PDSM_PPM_Session_PPM_Suspend = 0x14E6,
  eSQF_LOG_Internal__GNSS_PDSM_PPM_Report_Throttled = 0x14E7,
  eSQF_LOG_Internal__GNSS_PDSM_PPM_Report_Fired = 0x14E8,
  eSQF_LOG_Internal__GNSS_PDSM_PPM_Session_End = 0x14E9,
  eSQF_LOG_Internal__SNS_Registry_Operation = 0x14EA,
  eSQF_LOG_Internal__Watermarks_Tracing_Log_Packet_Common = 0x14EB,
  eSQF_LOG_1x_ADV_Frame_Early_Termination_Stats = 0x14EC,
  eSQF_LOG_1x_ADV_L1_PERF = 0x14ED,
  eSQF_LOG_Internal__BLAST_PM = 0x14EF,
  eSQF_LOG_SNS_Sensor1_Request = 0x14F0,
  eSQF_LOG_SNS_Sensor1_Response = 0x14F1,
  eSQF_LOG_SNS_Sensor1_Indication = 0x14F2,
  eSQF_LOG_Internal__SNS_SMR_Request = 0x14F3,
  eSQF_LOG_Internal__SNS_SMR_Response = 0x14F4,
  eSQF_LOG_Internal__SNS_SMR_Indication = 0x14F5,
  eSQF_LOG_ADSP_Internal_Tx_Audio_PCM = 0x14F6,
  eSQF_LOG_ADSP_Internal_Rx_Audio_PCM = 0x14F7,
  eSQF_LOG_ADSP_External_Tx_Audio_PCM = 0x14F8,
  eSQF_LOG_ADSP_External_Rx_Audio_PCM = 0x14F9,
  eSQF_LOG_ADSP_FM_Rx_Audio_PCM = 0x14FA,
  eSQF_LOG_ADSP_HDMI_Rx_Audio_PCM = 0x14FB,
  eSQF_LOG_Internal__TLM_Sparse_Network_DB_Record = 0x14FC,
  eSQF_LOG_Internal__TLM_Cell_DB_Record = 0x14FD,
  eSQF_LOG_TLM_Operation_Measurements = 0x14FE,
  eSQF_LOG_TLM_Mobile_Status_Header = 0x14FF,
  eSQF_LOG_Internal__TLM_Mobile_Status_Data = 0x1500,
  eSQF_LOG_Internal__TLM_XTA_Partition = 0x1501,
  eSQF_LOG_Internal__TLM_Client_Download_Data = 0x1502,
  eSQF_LOG_Internal__XTM_XTA_Message_Write = 0x1503,
  eSQF_LOG_Internal__XTM_XTA_Message_Read = 0x1504,
  eSQF_LOG_XTM_HTTP_Response_Status = 0x1505,
  eSQF_LOG_XTM_XTA_Response_Status = 0x1506,
  eSQF_LOG_TLM_Failed_Lookup = 0x1507,
  eSQF_LOG_Sensors_SDP_Virgo = 0x1508,
  eSQF_LOG_Sensors_SDP_SSD = 0x1509,
  eSQF_LOG_Sensors_SDP_CRD = 0x150A,
  eSQF_LOG_Sensors_SDP_Time_Sync = 0x150B,
  eSQF_LOG_Sensors_SDP_MSD = 0x150C,
  eSQF_LOG_GNSS_Sensor_Streaming_Ready_Status = 0x150D,
  eSQF_LOG_GNSS_Time_Sync_Req = 0x150E,
  eSQF_LOG_GNSS_Inject_Time_Sync_Data = 0x150F,
  eSQF_LOG_GNSS_Inject_Sensor_Data = 0x1510,
  eSQF_LOG_GNSS_Get_Sensor_Config_Response = 0x1511,
  eSQF_LOG_GNSS_Set_Sensor_Config = 0x1512,
  eSQF_LOG_GNSS_PE_Heading_Filter = 0x1513,
  eSQF_LOG_Internal__GNSS_PE_NHC = 0x1514,
  eSQF_LOG_GNSS_PE_CRD = 0x1515,
  eSQF_LOG_Internal__GNSS_Configuration_State = 0x1516,
  eSQF_LOG_Internal__HSUSB_Health_TX_Throughput = 0x1517,
  eSQF_LOG_Internal__HSUSB_Health_RX_Throughput = 0x1518,
  eSQF_LOG_Internal__GNSS_YAW_GYRO_Calibration = 0x1519,
  eSQF_LOG_Internal__Sensors_SDP = 0x151A,
  eSQF_LOG_SNS_DSPS_Power = 0x151B,
  eSQF_LOG_SNS_RAW_I2C_Data = 0x151C,
  eSQF_LOG_Internal__SNS_Motion_Detector_Configuration = 0x151D,
  eSQF_LOG_Internal__SNS_Motion_Detector_Result = 0x151E,
  eSQF_LOG_Internal__SNS_Motion_Detector_Report = 0x151F,
  eSQF_LOG_GNSS_BP_AMP_Info = 0x1520,
  eSQF_LOG_Internal__Core_Audio_Driver_Data = 0x1521,
  eSQF_LOG_Internal__Core_Audio_Driver_Control = 0x1522,
  eSQF_LOG_Internal__Sensors_Face_N_Shake_Detector_Configuration = 0x1523,
  eSQF_LOG_Internal__Sensors_Face_N_Shake_Detector_Result = 0x1524,
  eSQF_LOG_Internal__Sensors_Face_N_Shake_Detector_Report = 0x1525,
  eSQF_LOG_Internal__GNSS_Broadband_Jammer_Info = 0x1526,
  eSQF_LOG_ADSP_Performance_Monitor_log = 0x1527,
  eSQF_LOG_Internal__Sensors_BringtoEar_Detector_Configuration = 0x1528,
  eSQF_LOG_Internal__Sensors_BringtoEar_Detector_Result = 0x1529,
  eSQF_LOG_Internal__Sensors_BringtoEar_Detector_Report = 0x152A,
  eSQF_LOG_Internal__Gyro_Simple_Calibration_Configuration = 0x152B,
  eSQF_LOG_Internal__Gyro_Simple_Calibration_Result = 0x152C,
  eSQF_LOG_Internal__Gyro_Simple_Calibration_Report = 0x152D,
  eSQF_LOG_Internal__ADSP_Audio_Decoder_Input_log = 0x152E,
  eSQF_LOG_Internal__ADSP_Audio_Per_Object_Post_Processing_Input_log = 0x152F,
  eSQF_LOG_Internal__ADSP_Audio_Rx_Matrix_Mixer_Input_log = 0x1530,
  eSQF_LOG_Internal__ADSP_Audio_Common_Object_Post_Processing_Input_log = 0x1531,
  eSQF_LOG_Internal__ADSP_Audio_Common_Object_Pre_Processing_Input_log = 0x1532,
  eSQF_LOG_Internal__ADSP_Audio_Tx_Matrix_Mixer_Input_log = 0x1533,
  eSQF_LOG_Internal__ADSP_Audio_Per_Object_Pre_Processing_Input_log = 0x1534,
  eSQF_LOG_Internal__ADSP_Audio_Encoder_Input_log = 0x1535,
  eSQF_LOG_Internal__ADSP_Audio_Encoder_Output_log = 0x1536,
  eSQF_LOG_QTV_HTTP_Buffer_Occupancy = 0x1537,
  eSQF_LOG_QTV_HTTP_Incoming_Datarate = 0x1538,
  eSQF_LOG_QTV_HTTP_Download_Bitrate_Switch = 0x1539,
  eSQF_LOG_QTV_HTTP_Playback_Bitrate_Switch = 0x153A,
  eSQF_LOG_DS_EPC_PDN_Information_Log = 0x153B,
  eSQF_LOG_Internal__Sensors_Quaternion_Vector_Configuration = 0x153C,
  eSQF_LOG_Internal__Sensors_Quaternion_Vector_Result = 0x153D,
  eSQF_LOG_Internal__Sensors_Quaternion_Vector_Report = 0x153E,
  eSQF_LOG_Internal__Sensors_Gravity_Vector_Configuration = 0x153F,
  eSQF_LOG_Internal__Sensors_Gravity_Vector_Result = 0x1540,
  eSQF_LOG_Internal__Sensors_Gravity_Vector_Report = 0x1541,
  eSQF_LOG_Sensors_Full_Calibration = 0x1542,
  eSQF_LOG_Internal__QChatUPK_Optimization_log = 0x1543,
  eSQF_LOG_MCS_QCSI_Payload_Packet = 0x1544,
  eSQF_LOG_QBI_RX_Message_Context_0 = 0x1545,
  eSQF_LOG_QBI_TX_Message_Context_0 = 0x1546,
  eSQF_LOG_QBI_RX_Message_Context_1 = 0x1547,
  eSQF_LOG_QBI_TX_Message_Context_1 = 0x1548,
  eSQF_LOG_QBI_RX_Message_Context_2 = 0x1549,
  eSQF_LOG_QBI_TX_Message_Context_2 = 0x154A,
  eSQF_LOG_QBI_RX_Message_Context_3 = 0x154B,
  eSQF_LOG_QBI_TX_Message_Context_3 = 0x154C,
  eSQF_LOG_QBI_RX_Message_Context_4 = 0x154D,
  eSQF_LOG_QBI_TX_Message_Context_4 = 0x154E,
  eSQF_LOG_QBI_RX_Message_Context_5 = 0x154F,
  eSQF_LOG_QBI_TX_Message_Context_5 = 0x1550,
  eSQF_LOG_QBI_RX_Message_Context_6 = 0x1551,
  eSQF_LOG_QBI_TX_Message_Context_6 = 0x1552,
  eSQF_LOG_QBI_RX_Message_Context_7 = 0x1553,
  eSQF_LOG_QBI_TX_Message_Context_7 = 0x1554,
  eSQF_LOG_Wakeup_Manager_Log = 0x1555,
  eSQF_LOG_DS_Memory_Packet_Statistics = 0x1556,
  eSQF_LOG_MMode_Call_Flow = 0x1557,
  eSQF_LOG_Wireless_Connectivity_Subsystem_Audio_Data = 0x1558,
  eSQF_LOG_Internal__SNS_Motion_Detection_Interrupt = 0x1559,
  eSQF_LOG_Internal__SNS_MAG_Calibration_Config = 0x155A,
  eSQF_LOG_Internal__SNS_MAG_Calibration_Result = 0x155B,
  eSQF_LOG_Internal__SNS_MAG_Calibration_Report = 0x155C,
  eSQF_LOG_GNSS_QUIPS_Position_Report = 0x155D,
  eSQF_LOG_GNSS_QUIPS_AP_MEAS_Blocks = 0x155E,
  eSQF_LOG_Internal__SNS_Rotation_Vector_Config = 0x155F,
  eSQF_LOG_Internal__SNS_Rotation_Vector_Result = 0x1560,
  eSQF_LOG_Internal__SNS_Rotation_Vector_Report = 0x1561,
  eSQF_LOG_Internal__SNS_FMV_Config = 0x1562,
  eSQF_LOG_Internal__SNS_FMV_Quaternion_Update = 0x1563,
  eSQF_LOG_Internal__SNS_FMV_MAG_Update = 0x1564,
  eSQF_LOG_Internal__SNS_FMV_GYRO_Update = 0x1565,
  eSQF_LOG_Internal__SNS_FMV_Report = 0x1566,
  eSQF_LOG_GNSS_Fast_TCAL = 0x1567,
  eSQF_LOG_IMS_RTP_SN_And_Payload = 0x1568,
  eSQF_LOG_IMS_RTP_Packet_Loss = 0x1569,
  eSQF_LOG_IMS_RTCP_Packet = 0x156A,
  eSQF_LOG_IMS_QDJ_Enqueue = 0x156B,
  eSQF_LOG_IMS_QDJ_Dequeue = 0x156C,
  eSQF_LOG_IMS_QDJ_Update = 0x156D,
  eSQF_LOG_IMS_Message = 0x156E,
  eSQF_LOG_GNSS_QUIPS_In_Use_Ap_Database = 0x156F,
  eSQF_LOG_GNSS_PRS_Occasion_Measurements = 0x1570,
  eSQF_LOG_IMS_AMR_Redundancy = 0x1571,
  eSQF_LOG_Network_IP_Rm_Tx_100_Bytes = 0x1572,
  eSQF_LOG_Network_IP_Rm_Rx_100_Bytes = 0x1573,
  eSQF_LOG_Network_IP_Rm_Tx_Full = 0x1574,
  eSQF_LOG_Network_IP_Rm_Rx_Full = 0x1575,
  eSQF_LOG_Network_IP_Um_Tx_100_Bytes = 0x1576,
  eSQF_LOG_Network_IP_Um_Rx_100_Bytes = 0x1577,
  eSQF_LOG_Network_IP_Um_Tx_Full = 0x1578,
  eSQF_LOG_Network_IP_Um_Rx_Full = 0x1579,
  eSQF_LOG_ADSP_AFE_Rx_Tx_PCM_logging = 0x1586,
  eSQF_LOG_GNSS_PE_Events = 0x1587,
  eSQF_LOG_QMI_Supported_Interfaces = 0x1588,
  eSQF_LOG_GNSS_SAP_SDP_Event = 0x1589,
  eSQF_LOG_ADSP_VCP_VOICE_PROC_RX_TX = 0x158A,
  eSQF_LOG_ADSP_VCP_VOICESTRM_RX_TX = 0x158B,
  eSQF_LOG_XOADC_Readings_Log = 0x158C,
  eSQF_LOG_FM_Radio_HCI_Commands = 0x158D,
  eSQF_LOG_FM_Radio_HCI_Events = 0x158E,
  eSQF_LOG_SNS_Time_Service_Offsets = 0x158F,
  eSQF_LOG_CxM_BT_Control_Plane_Messages = 0x1590,
  eSQF_LOG_CxM_WLAN_Control_Plane_Messages = 0x1591,
  eSQF_LOG_CxM_LTE_Control_Plane_Messages = 0x1592,
  eSQF_LOG_CxM_BT_Data_Plane_Messages = 0x1593,
  eSQF_LOG_CxM_WLAN_Data_Plane_Messages = 0x1594,
  eSQF_LOG_CxM_LTE_Data_Plane_Messages = 0x1595,
  eSQF_LOG_Internal__GNSS_WWAN_WLAN_IMD_Jammer_Status = 0x1596,
  eSQF_LOG_Tcxo_Manager_IFC_Summary = 0x1597,
  eSQF_LOG_Tcxo_Manager_IFC_RPUSH_data = 0x1598,
  eSQF_LOG_GNSS_PRS_RSTD_Measurements = 0x1599,
  eSQF_LOG_Internal__GNSS_PRS_TOA_Measurements = 0x159A,
  eSQF_LOG_Internal__SNS_Integrated_Angle_Configuration = 0x159B,
  eSQF_LOG_Internal__SNS_Integrated_Angle_Result = 0x159C,
  eSQF_LOG_Internal__SNS_Integrated_Angle_Report = 0x159D,
  eSQF_LOG_Internal__SNS_Gyro_Tap_Configuration = 0x159E,
  eSQF_LOG_Internal__SNS_Gyro_Tap_Result = 0x159F,
  eSQF_LOG_Internal__SNS_Gyro_Tap_Report = 0x15A0,
  eSQF_LOG_Internal__SNS_Basic_Gestures_Configuration = 0x15A1,
  eSQF_LOG_Internal__SNS_Basic_Gestures_Result = 0x15A2,
  eSQF_LOG_Internal__SNS_Basic_Gestures_Report = 0x15A3,
  eSQF_LOG_Internal__SNS_Facing_Configuration = 0x15A4,
  eSQF_LOG_Internal__SNS_Facing_Result = 0x15A5,
  eSQF_LOG_Internal__SNS_Facing_Report = 0x15A6,
  eSQF_LOG_Internal__Clock_Driver_Clock_Speeds_Log = 0x15A7,
  eSQF_LOG_Internal__Time_TOD_Error_Notify = 0x15A8,
  eSQF_LOG_Internal__SNS_ALGO_Input = 0x15A9,
  eSQF_LOG_Internal__Gyro_Integration_Configuration = 0x15AA,
  eSQF_LOG_Internal__Gyro_Integration_Update = 0x15AB,
  eSQF_LOG_Internal__Gyro_Integration_Report = 0x15AC,
  eSQF_LOG_Internal__Gyro_Integration_Report_Request = 0x15AD,
  eSQF_LOG_Internal__Gyro_Buffering_Configuration = 0x15AE,
  eSQF_LOG_Internal__Gyro_Buffering_Report_Request = 0x15AF,
  eSQF_LOG_Internal__Gyro_Buffering_Report = 0x15B0,
  eSQF_LOG_GNSS_PDSM_Best_Available_Position_Info = 0x15B1,
  eSQF_LOG_GNSS_PDSM_EXT_Status_Best_Available_Position_Info = 0x15B2,
  eSQF_LOG_Kernal_Task_Profile_V3 = 0x15B3,
  eSQF_LOG_Kernal_System_Profile_V3 = 0x15B4,
  eSQF_LOG_System_Profiling_ID_Lookup = 0x15B5,
  eSQF_LOG_System_Profiling = 0x15B6,
  eSQF_LOG_Internal__Data_Services_3GPP_Events = 0x15B7,
  eSQF_LOG_Internal__Accel_Calibration_Configuration = 0x15B8,
  eSQF_LOG_Internal__Accel_Calibration_Result = 0x15B9,
  eSQF_LOG_Internal__Accel_Calibration_Report = 0x15BA,
  eSQF_LOG_Internal__GNSS_SOC_RF_DEV_Messages = 0x15BB,
  eSQF_LOG_Internal__GNSS_SOC_UBP_Messages = 0x15BC,
  eSQF_LOG_TCXOMGR_RGS_Log = 0x15BD,
  eSQF_LOG_RFIC_PMIC_Status = 0x15BE,
  eSQF_LOG_HDR_RF_Warmpup = 0x15BF,
  eSQF_LOG_HDR_RF_Power_Limiting = 0x15C0,
  eSQF_LOG_HDR_RF_State = 0x15C1,
  eSQF_LOG_HDR_RF_Sleep = 0x15C2,
  eSQF_LOG_HDR_RF_Tx_State = 0x15C3,
  eSQF_LOG_HDR_RF_IntelliCeiver_State = 0x15C4,
  eSQF_LOG_HDR_RF_LNA_Switch_Point = 0x15C5,
  eSQF_LOG_HDR_Rx_Calibration = 0x15C6,
  eSQF_LOG_HDR_RF_API = 0x15C7,
  eSQF_LOG_HDR_RF_Rx_PLL_Locking_Status = 0x15C8,
  eSQF_LOG_HDR_RF_Rx_Quality = 0x15C9,
  eSQF_LOG_1X_RF_Rx_Quality = 0x15CA,
  eSQF_LOG_IMS_VDJ_Enqueue = 0x15CB,
  eSQF_LOG_IMS_VDJ_Dequeue = 0x15CC,
  eSQF_LOG_Internal__GNSS_Loc_WWAN_MEDB_Dump_Log = 0x15CD,
  eSQF_LOG_Internal__HDR_AGC = 0x15CE,
  eSQF_LOG_Internal__HDR_AFC = 0x15CF,
  eSQF_LOG_Internal__HDR_Tx_AGC = 0x15D0,
  eSQF_LOG_Internal__HDR_DLNA = 0x15D1,
  eSQF_LOG_DSDA_MCDO_TX = 0x15D2,
  eSQF_LOG_DSDA_MCDO_RX = 0x15D3,
  eSQF_LOG_Internal__HDR_Finger = 0x15D4,
  eSQF_LOG_Internal__HDR_MAC = 0x15D5,
  eSQF_LOG_DSDA_CDMA1x_RX = 0x161A,
  eSQF_LOG_DSDA_CDMA1x_TX = 0x161B,
  eSQF_LOG_IMS_AVPF_Feedback_Messages = 0x1633,
  eSQF_LOG_Internal__GNSS_Spectrum_Analyzer_Scan_Parameters = 0x1634,
  eSQF_LOG_Internal__GNSS_Spectrum_Analyzer_Jammer_Measurements = 0x1635,
  eSQF_LOG_Internal__GNSS_Spectrum_Analyzer_Notch_Assignment = 0x1636,
  eSQF_LOG_Internal__SNS_Pedometer_Configuration = 0x1637,
  eSQF_LOG_Internal__SNS_Pedometer_Result = 0x1638,
  eSQF_LOG_Internal__SNS_Pedometer_Report = 0x1639,
  eSQF_LOG_Internal__SNS_QMAG_Cal_Config = 0x163A,
  eSQF_LOG_Internal__SNS_QMAG_Cal_Result = 0x163B,
  eSQF_LOG_Internal__SNS_QMAG_Cal_Report = 0x163C,
  eSQF_LOG_Internal__GNSS_ME_PQME1_NMEA = 0x163D,
  eSQF_LOG_Internal__GNSS_ME_PQME2_NMEA = 0x163E,
  eSQF_LOG_Internal__GNSS_ME_PQME3_NMEA = 0x163F,
  eSQF_LOG_Internal__PAM_Configuration = 0x1640,
  eSQF_LOG_Internal__PAM_Result = 0x1641,
  eSQF_LOG_Internal__PAM_Report = 0x1642,
  eSQF_LOG_MCS_QCSI_Event_Packet = 0x1643,
  eSQF_LOG_QuRT_Task_Profiling = 0x1644,
  eSQF_LOG_QuRT_PM = 0x1645,
  eSQF_LOG_TCXOMGR_RGS_Retrieval_Log = 0x1646,
  eSQF_LOG_Internal__GNSS_LTE_OTDOA_Assist_Data = 0x1647,
  eSQF_LOG_Indoor_Info = 0x1648,
  eSQF_LOG_Internal__Indoor_RTS_CTS_Scan = 0x1649,
  eSQF_LOG_Internal__Indoor_CDM = 0x164A,
  eSQF_LOG_Indoor_Active_Scan = 0x1650,
  eSQF_LOG_Internal__Indoor_IPE_IPC_Data = 0x1651,
  eSQF_LOG_Internal__Indoor_SDP_IPC_Data = 0x1652,
  eSQF_LOG_Internal__Indoor_IMC_IPC_Data = 0x1653,
  eSQF_LOG_Internal__Indoor_IWMM_IPC_Data = 0x1654,
  eSQF_LOG_Internal__TLM_Mobile_NW_Position_Info = 0x1748,
  eSQF_LOG_ANT_HCI_Command_Log = 0x1749,
  eSQF_LOG_ANT_HCI_EV_Log = 0x1750,
  eSQF_LOG_IMS_Camera = 0x1751,
  eSQF_LOG_IMS_Video_Encoder = 0x1752,
  eSQF_LOG_IMS_Video_Playout = 0x1753,
  eSQF_LOG_IRAT_List_Manager = 0x1754,
  eSQF_LOG_TCXOMGR_Temperature_Subscription = 0x1755,
  eSQF_LOG_GNSS_BDS_Measurement_Report = 0x1756,
  eSQF_LOG_eMBMS_SL_Session = 0x1757,
  eSQF_LOG_eMBMS_SL_FLUTE = 0x1758,
  eSQF_LOG_eMBMS_SL_Local_HTTP_Server = 0x1759,
  eSQF_LOG_eMBMS_SL_Bootstrap = 0x175A,
  eSQF_LOG_eMBMS_SL_Service_Discovery = 0x175B,
  eSQF_LOG_eMBMS_SL_I2 = 0x175C,
  eSQF_LOG_eMBMS_SL_I1_Common = 0x175D,
  eSQF_LOG_eMBMS_SL_I1_Streaming = 0x175E,
  eSQF_LOG_eMBMS_SL_Streaming = 0x175F,
  eSQF_LOG_eMBMS_SL_I1_File_Download = 0x1760,
  eSQF_LOG_eMBMS_SL_Session_File_Schedule = 0x1761,
  eSQF_LOG_eMBMS_SL_File_Repair = 0x1762,
  eSQF_LOG_eMBMS_SL_Reception_Reporting = 0x1763,
  eSQF_LOG_eMBMS_SL_MSP_Common = 0x1764,
  eSQF_LOG_eMBMS_SL_USD_Data = 0x1765,
  eSQF_LOG_eMBMS_Configuration = 0x1766,
  eSQF_LOG_eMBMS_FD_Store = 0x1767,
  eSQF_LOG_Audio_Front_End_AFE_Calibration_Data_Logging = 0x17D8,
  eSQF_LOG_RFA_Device_PA = 0x17D9,
  eSQF_LOG_RFA_Device_ASM = 0x17DA,
  eSQF_LOG_RFA_Device_PAPM = 0x17DB,
  eSQF_LOG_RFA_Device_Transceiver = 0x17DC,
  eSQF_LOG_RFA_Device_Tuner = 0x17DD,
  eSQF_LOG_RFA_Device_THERM = 0x17DE,
  eSQF_LOG_RFA_Device_HDET_Log = 0x17DF,
  eSQF_LOG_RFA_RFC_Signals = 0x17E0,
  eSQF_LOG_RFA_RFC_Devices = 0x17E1,
  eSQF_LOG_RFA_GSM_CMN = 0x17E2,
  eSQF_LOG_RFA_GSM_RX = 0x17E3,
  eSQF_LOG_RFA_GSM_TX = 0x17E4,
  eSQF_LOG_RFA_GSM_Temp_Comp = 0x17E5,
  eSQF_LOG_RFA_GSM_VBATT_Comp = 0x17E6,
  eSQF_LOG_RFA_GSM_IRAT = 0x17E7,
  eSQF_LOG_RFA_GSM_FTM = 0x17E8,
  eSQF_LOG_RFA_GSM_Cal = 0x17E9,
  eSQF_LOG_Internal__SNS_CMC_Config = 0x17EA,
  eSQF_LOG_Internal__SNS_CMC_Result = 0x17EB,
  eSQF_LOG_Internal__SNS_CMC_Report = 0x17EC,
  eSQF_LOG_Internal__SNS_DB_Config = 0x17ED,
  eSQF_LOG_Internal__SNS_DB_Result = 0x17EE,
  eSQF_LOG_Internal__SNS_DB_Report = 0x17EF,
  eSQF_LOG_Internal__SNS_CMC_Result2 = 0x17F0,
  eSQF_LOG_Internal__MLOG_Memory_Profiling = 0x17F1,
  eSQF_LOG_IMS_Voice_Call_Statistics = 0x17F2,
  eSQF_LOG_Internal__Sensor_FIFO_Event = 0x17F3,
  eSQF_LOG_EFS_Monitor = 0x17F4,
  eSQF_LOG_EFS_Monitor_Lookup = 0x17F5,
  eSQF_LOG_WWCOEX_State_Info = 0x17F6,
  eSQF_LOG_WWCOEX_Power_Info = 0x17F7,
  eSQF_LOG_Internal__SNS_SMD_Config = 0x17F8,
  eSQF_LOG_Internal__SNS_SMD_Result = 0x17F9,
  eSQF_LOG_Internal__SNS_SMD_Report = 0x17FA,
  eSQF_LOG_Internal__SNS_Latency_Sampling_Poll = 0x17FB,
  eSQF_LOG_Internal__SNS_Latency_Sampling_DRI = 0x17FC,
  eSQF_LOG_Internal__SNS_Latency_Delivery = 0x17FD,
  eSQF_LOG_Internal__SNS_Game_Rotation_Vector_Configuration = 0x17FE,
  eSQF_LOG_Internal__SNS_Game_Rotation_Vector_Result = 0x17FF,
  eSQF_LOG_Internal__SNS_Game_Rotation_Vector_Report = 0x1800,
  eSQF_LOG_Internal__WLAN_TRSP_Data_Stall = 0x1801,
  eSQF_LOG_Near_Field_Communication = 0x1802,
  eSQF_LOG_TCXOMGR_Coarse_DC_Cal = 0x1803,
  eSQF_LOG_ADSP_Core_Voice_Driver_Stream_Tx = 0x1804,
  eSQF_LOG_ADSP_Core_Voice_Driver_Stream_Rx = 0x1805,
  eSQF_LOG_Internal__GNSS_Measurement_Buffer_Module = 0x1806,
  eSQF_LOG_Internal__GNSS_PLE_Update = 0x1807,
  eSQF_LOG_Internal__WLAN_SLM_RA_Link = 0x1808,
  eSQF_LOG_Internal__LTE_RF_TX_Max_Power_Limiting = 0x1809,
  eSQF_LOG_Internal__LTE_RF_TX_HDEF_Measurement = 0x180A,
  eSQF_LOG_QMI_Link_17_RX_PDU = 0x180B,
  eSQF_LOG_QMI_Link_17_TX_PDU = 0x180C,
  eSQF_LOG_QMI_Link_18_RX_PDU = 0x180D,
  eSQF_LOG_QMI_Link_18_TX_PDU = 0x180E,
  eSQF_LOG_QMI_Link_19_RX_PDU = 0x180F,
  eSQF_LOG_QMI_Link_19_TX_PDU = 0x1810,
  eSQF_LOG_QMI_Link_20_RX_PDU = 0x1811,
  eSQF_LOG_QMI_Link_20_TX_PDU = 0x1812,
  eSQF_LOG_Internal__Extended_Data_Protocol_Logging = 0x182C,
  eSQF_LOG_RF_WCDMA_Rx_Tx_AGC_Parameters = 0x182D,
  eSQF_LOG_ROHC_Decompressor_Input = 0x182E,
  eSQF_LOG_ROHC_Compressor_Output = 0x182F,
  eSQF_LOG_IMS_VoLTE_Session_Setup = 0x1830,
  eSQF_LOG_IMS_VoLTE_Session_End = 0x1831,
  eSQF_LOG_IMS_Registration = 0x1832,
  eSQF_LOG_GNSS_Geofence_Motion_Detection_Report = 0x1833,
  eSQF_LOG_Internal__SNS_RunTime_Tuning_Request = 0x1834,
  eSQF_LOG_Internal__SNS_RunTime_Tuning_Response = 0x1835,
  eSQF_LOG_Internal__SNS_BMA2X2_Tune_DoubleTap = 0x1836,
  eSQF_LOG_GNSS_Geofence_Position_Report = 0x1837,
  eSQF_LOG_GNSS_DPO_status_report_log = 0x1838,
  eSQF_LOG_Internal__GNSS_SLIM_Time_Synchronization_DM = 0x1839,
  eSQF_LOG_Internal__SNS_Geomagnetic_Rotation_Vector_Configuration = 0x183A,
  eSQF_LOG_Internal__SNS_Geomagnetic_Rotation_Vector_Result = 0x183B,
  eSQF_LOG_Internal__SNS_Geomagnetic_Rotation_Vector_Report = 0x183C,
  eSQF_LOG_Internal__IPDC_Compressor_Per_Packet_Metrics = 0x183D,
  eSQF_LOG_Internal__IPDC_Compressor_Stats = 0x183E,
  eSQF_LOG_ROHC_Compressor_Statistics_Ex = 0x183F,
  eSQF_LOG_ROHC_Decompressor_Statistics_Ex = 0x1840,
  eSQF_LOG_RF_ASDIV = 0x1841,
  eSQF_LOG_Internal__RFLM_Generic_debug_1 = 0x1842,
  eSQF_LOG_Internal__RFLM_CCS_Event_Timing_Check = 0x1843,
  eSQF_LOG_Internal__RFLM_TxAGC_update = 0x1844,
  eSQF_LOG_Internal__RFLM_TxAGC_tables = 0x1845,
  eSQF_LOG_Internal__RFLM_DTR_Tx = 0x1846,
  eSQF_LOG_Internal__RFLM_DTR_Rx = 0x1847,
  eSQF_LOG_Internal__RFLM_DTR_CMN = 0x1848,
  eSQF_LOG_Internal__RFLM_FBRx_online_correction = 0x1849,
  eSQF_LOG_Internal__RFLM_FBRx_sample_capture = 0x184A,
  eSQF_LOG_ADSP_VCP_VOICEPROC_RTM = 0x184B,
  eSQF_LOG_LTE_RF_FED_TxAGC = 0x184C,
  eSQF_LOG_Internal__LTE_RF_FED_TxAGC_Timing = 0x184D,
  eSQF_LOG_Call_Manager_Serving_System_MSIM_Event = 0x184E,
  eSQF_LOG_Data_Modem_IPA_Stats = 0x184F,
  eSQF_LOG_Data_Modem_IPA_IPFLTR_Stats = 0x1850,
  eSQF_LOG_Internal__Data_Modem_IPA_PKT_Status_DL = 0x1851,
  eSQF_LOG_Internal__Data_Modem_IPA_PKT_Status_UL = 0x1852,
  eSQF_LOG_Data_Modem_IPA_SIO_CFG = 0x1853,
  eSQF_LOG_Data_Modem_IPA_WAN_CFG = 0x1854,
  eSQF_LOG_Data_Modem_IPA_FLTR_TBL_Update = 0x1855,
  eSQF_LOG_Data_Modem_IPA_RTNG_TBL_Update = 0x1856,
  eSQF_LOG_Internal__WLAN_QCA_RA_Stat = 0x1857,
  eSQF_LOG_Internal__IMS_VoIP_VT_Handover_Criteria_Change = 0x1858,
  eSQF_LOG_DS_First_Reorig_IP_Packet_Header = 0x1859,
  eSQF_LOG_Internal__Touch_Frame_Raw = 0x185A,
  eSQF_LOG_Internal__Touch_Frame_Post_Proc = 0x185B,
  eSQF_LOG_Internal__Touch_Baseline = 0x185C,
  eSQF_LOG_Internal__Touch_Frame_Type_0 = 0x185D,
  eSQF_LOG_Internal__Touch_Frame_Type_1 = 0x185E,
  eSQF_LOG_Internal__Touch_Frame_Type_2 = 0x185F,
  eSQF_LOG_Internal__Touch_Frame_Type_3 = 0x1860,
  eSQF_LOG_Internal__Touch_Frame_Type_4 = 0x1861,
  eSQF_LOG_Internal__Touch_Frame_Type_5 = 0x1862,
  eSQF_LOG_Internal__Touch_Frame_Type_6 = 0x1863,
  eSQF_LOG_Internal__Touch_Frame_Type_7 = 0x1864,
  eSQF_LOG_Internal__Touch_Frame_Type_8 = 0x1865,
  eSQF_LOG_Internal__Touch_Frame_Type_9 = 0x1866,
  eSQF_LOG_Internal__Location_WWAN_ME_Events = 0x1867,
  eSQF_LOG_RFLM_TDSCDMA_Uplink_Report = 0x1868,
  eSQF_LOG_RFLM_TDSCDMA_Downlink_Report = 0x1869,
  eSQF_LOG_RFLM_TDSCDMA_Debug = 0x186A,
  eSQF_LOG_DSP_MODEM_FW_CXM_Log = 0x186B,
  eSQF_LOG_Internal__SNS_PED_Align_Config = 0x186C,
  eSQF_LOG_Internal__SNS_PED_Align_Result1 = 0x186D,
  eSQF_LOG_Internal__SNS_PED_Align_Result2 = 0x186E,
  eSQF_LOG_Internal__SNS_PED_Align_Report = 0x186F,
  eSQF_LOG_WWCOEX_BA_SERV_Power_Info = 0x1870,
  eSQF_LOG_WWCOEX_BA_Blacklist_Info = 0x1871,
  eSQF_LOG_AOSTLM_Report = 0x1872,
  eSQF_LOG_MCPM_Device_Power_Info = 0x1873,
  eSQF_LOG_MCPM_General_Session_Power = 0x1874,
  eSQF_LOG_MCPM_Chipset_Config_Power_Info = 0x1875,
  eSQF_LOG_MCPM_Idle_Awake_Power_Info = 0x1876,
  eSQF_LOG_1X_Physical_Layer_Power_Info = 0x1877,
  eSQF_LOG_EVDO_Physical_Layer_Power_Info = 0x1878,
  eSQF_LOG_GERAN_Physical_Layer_Power_Info = 0x1879,
  eSQF_LOG_WCDMA_Session_Power_Info = 0x187A,
  eSQF_LOG_WCDMA_Physical_Layer_Power_Info = 0x187B,
  eSQF_LOG_TDSCDMA_Physical_Layer_Power_Info = 0x187C,
  eSQF_LOG_LTE_Session_Power_Info = 0x187D,
  eSQF_LOG_LTE_Physical_Layer_Power_Info = 0x187E,
  eSQF_LOG_PA_Power = 0x187F,
  eSQF_LOG_WTR_Power = 0x1880,
  eSQF_LOG_Q6_Power = 0x1881,
  eSQF_LOG_ADSP_LSM_Output = 0x1882,
  eSQF_LOG_Internal__Geofence_WWAN_MOT_Class = 0x1883,
  eSQF_LOG_Internal__GNSS_SAMLite_Algorithm_States_Output = 0x1884,
  eSQF_LOG_Internal__GNSS_SLIM_Event_DM_Log = 0x1885,
  eSQF_LOG_GNSS_GAL_Measurements_Report = 0x1886,
  eSQF_LOG_Internal__SNS_TILT_Detector_Config = 0x1887,
  eSQF_LOG_Internal__SNS_TILT_Detector_Result = 0x1888,
  eSQF_LOG_Internal__SNS_TILT_Detector_Report = 0x1889,
  eSQF_LOG_Internal__ADSP_CVD_CAL_Data = 0x188A,
  eSQF_LOG_Internal__GPS_TLM_Update_Consistency_Info = 0x188B,
  eSQF_LOG_Internal__Location_LTE_OTDOA_TDP_Measurements = 0x188C,
  eSQF_LOG_SNS_UIMG_Mode = 0x188D,
  eSQF_LOG_Internal__GNSS_OEMCPE_Measurement_Report = 0x188E,
  eSQF_LOG_Internal__RFLM_WCDMA_TxAGC_Timeline = 0x188F,
  eSQF_LOG_Internal__ADSP_CVD_VP3 = 0x1890,
  eSQF_LOG_MCS_CxM_SMEM_Data = 0x1892,
  eSQF_LOG_MCS_CxM_Low_Prio = 0x1893,
  eSQF_LOG_MCS_CxM_Medium_Prio = 0x1894,
  eSQF_LOG_MCS_CxM_High_Prio = 0x1895,
  eSQF_LOG_Internal__IMS_State_Switch = 0x1896,
  eSQF_LOG_Internal__IMS_System_Anchor = 0x1897,
  eSQF_LOG_MCS_WWCOEX_Slot_Activity_Timeline_Info = 0x1898,
  eSQF_LOG_GNSS_Geofence_Motion_Wifi_State = 0x1899,
  eSQF_LOG_Encapsulated_Streaming_Download_Request = 0x1FD0,
  eSQF_LOG_Encapsulated_Streaming_Download_Response = 0x1FD1,
  eSQF_LOG_Encapsulated_Streaming_Upload_Request = 0x1FD2,
  eSQF_LOG_Encapsulated_Streaming_Upload_Response = 0x1FD3,
  eSQF_LOG_Encapsulated_DIAG_Request = 0x1FEA,
  eSQF_LOG_Encapsulated_Extended_Message = 0x1FEB,
  eSQF_LOG_Encapsulated_Legacy_Message = 0x1FEC,
  eSQF_LOG_PC_Polling_Time = 0x1FED,
  eSQF_LOG_HTML_Page = 0x1FEF,
  eSQF_LOG_Encapsulated_DIAG_Response = 0x1FF0,
  eSQF_LOG_GPS_Information = 0x1FF1,
  eSQF_LOG_Status_Snapshot = 0x1FF7,
  eSQF_LOG_Encapsulated_Log_Mask = 0x1FF9,
  eSQF_LOG_Encapsulated_Event = 0x1FFB,
  eSQF_LOG_Log_Annotation = 0x1FFC,
  eSQF_LOG_Tool_Version = 0x1FFD,
  eSQF_LOG_Tool_Generated_Status = 0x1FFE,
  eSQF_LOG_WCDMA_Compressed_Mode_GSM_Measurements = 0x4000,
  eSQF_LOG_Obsolete__WCDMA_Power_Control = 0x4001,
  eSQF_LOG_WCDMA_UL_MAC_Traffic_Volume_Measurement_Parameters = 0x4002,
  eSQF_LOG_WCDMA_Finger_Info_For_TA__Finger_Pilot_Channel_Parameters = 0x4003,
  eSQF_LOG_WCDMA_DRX_Mode = 0x4004,
  eSQF_LOG_UMTS_Cell_Reselection = 0x4005,
  eSQF_LOG_WCDMA_Active_Neighbor_Finger_TA_Info = 0x4006,
  eSQF_LOG_WCDMA_RX_Diversity_Antenna_Radiation_Status = 0x4008,
  eSQF_LOG_WCDMA_Power_Control_with_Compressed_Mode = 0x4010,
  eSQF_LOG_Internal__WCDMA_MultiCombiner_Power_Control = 0x4011,
  eSQF_LOG_WCDMA_Compressed_Mode_Block_Error_Rate = 0x4013,
  eSQF_LOG_Internal__WCDMA_RX_Diversity_Controller_Info = 0x4014,
  eSQF_LOG_WCDMA_AGC_Version_3 = 0x4015,
  eSQF_LOG_WCDMA_Active_Neighbor_Finger_TA_Info_Version_2 = 0x4016,
  eSQF_LOG_WCDMA_List_Search_Version_4 = 0x4017,
  eSQF_LOG_WCDMA_Step_1_Search_Version_3 = 0x4018,
  eSQF_LOG_WCDMA_Step_2_Search_Version_3 = 0x4019,
  eSQF_LOG_WCDMA_Step_3_Search_Version_3 = 0x401A,
  eSQF_LOG_Internal__WCDMA_RX_Diversity_Capacity_Quality_Measurements = 0x401B,
  eSQF_LOG_WCDMA_List_Search_Version_5 = 0x401C,
  eSQF_LOG_Internal__WCDMA_FDPCH_Debug = 0x401D,
  eSQF_LOG_Internal__WCDMA_PSC_Scanner_Pilot_Info = 0x401E,
  eSQF_LOG_WCDMA_CLTD_Parameters = 0x401F,
  eSQF_LOG_WCDMA_Uplink_And_Downlink_Power_Control_Edition_2 = 0x4023,
  eSQF_LOG_Internal__WCDMA_W2L_Search_Results = 0x4024,
  eSQF_LOG_Internal__WCDMA_UPLINK_RACH_DEBUG_LOG_PACKET = 0x4025,
  eSQF_LOG_Internal__WCDMA_UPLINK_RACH_FIRMWARE_LOG_PACKET = 0x4026,
  eSQF_LOG_Absolute_Priority_Cell_Reselection = 0x4027,
  eSQF_LOG_WCDMA_AGC_Version_4 = 0x4031,
  eSQF_LOG_Internal__WCDMA_Per_Slot_TxAGC = 0x4035,
  eSQF_LOG_Obsolete__WCDMA_Step_1_Search = 0x4100,
  eSQF_LOG_Obsolete__WCDMA_Step_2_Search = 0x4101,
  eSQF_LOG_Obsolete__WCDMA_Step_3_Search = 0x4102,
  eSQF_LOG_Obsolete__WCDMA_List_Search_4103 = 0x4103,
  eSQF_LOG_Obsolete__WCDMA_Finger_Info_For_TA = 0x4104,
  eSQF_LOG_WCDMA_AGC = 0x4105,
  eSQF_LOG_Obsolete__WCDMA_RACH_Parameters = 0x4106,
  eSQF_LOG_Obsolete__WCDMA_DRX_Mode = 0x4107,
  eSQF_LOG_WCDMA_Transport_Channels_Downlink = 0x4108,
  eSQF_LOG_WCDMA_Transport_Channels_Uplink = 0x4109,
  eSQF_LOG_WCDMA_Common_Physical_Channels_Downlink = 0x410A,
  eSQF_LOG_WCDMA_Dedicated_Physical_Channels_Downlink = 0x410B,
  eSQF_LOG_WCDMA_Physical_Channels_Uplink = 0x410C,
  eSQF_LOG_WCDMA_PRACH = 0x410D,
  eSQF_LOG_WCDMA_RM_UL = 0x410E,
  eSQF_LOG_WCDMA_Active_Set = 0x4110,
  eSQF_LOG_WCDMA_Neighbor_Set = 0x4111,
  eSQF_LOG_WCDMA_Downlink_Transport_Channel_Debugging = 0x4112,
  eSQF_LOG_WCDMA_TB_Set_Status_CRC = 0x4113,
  eSQF_LOG_Obsolete__WCDMA_Uplink_And_Downlink_Power_Control = 0x4114,
  eSQF_LOG_WCDMA_Downlink_Transport_Format_Combination = 0x4115,
  eSQF_LOG_WCDMA_Block_Error_Rate = 0x4116,
  eSQF_LOG_WCDMA_MAC_Uplink_Logical_Channel_Parameters = 0x4117,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_Ciphering = 0x4118,
  eSQF_LOG_WCDMA_RLC_UL_States = 0x4119,
  eSQF_LOG_WCDMA_RLC_UL_TM = 0x411A,
  eSQF_LOG_WCDMA_RLC_UL_UM = 0x411B,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_Configuration = 0x411C,
  eSQF_LOG_WCDMA_MAC_Downlink_Logical_Channel_Parameters = 0x411D,
  eSQF_LOG_Obsolete__WCDMA_RLC_DL_Ciphering = 0x411E,
  eSQF_LOG_WCDMA_RLC_DL_States = 0x411F,
  eSQF_LOG_WCDMA_RLC_DL_TM = 0x4120,
  eSQF_LOG_WCDMA_RLC_DL_UM = 0x4121,
  eSQF_LOG_Obsolete__WCDMA_RLC_DL_AM_Configuration = 0x4122,
  eSQF_LOG_WCDMA_RACH_Control_Parameters = 0x4123,
  eSQF_LOG_WCDMA_Uplink_Transport_Format_Combination = 0x4124,
  eSQF_LOG_WCDMA_RRC_States = 0x4125,
  eSQF_LOG_WCDMA_RRC_Protocol_Errors = 0x4126,
  eSQF_LOG_WCDMA_Cell_ID = 0x4127,
  eSQF_LOG_WCDMA_UL_Channel_Mapping = 0x4128,
  eSQF_LOG_WCDMA_DL_Channel_Mapping = 0x4129,
  eSQF_LOG_WCDMA_FP_Info = 0x412A,
  eSQF_LOG_Internal__WCDMA_SIB = 0x412B,
  eSQF_LOG_Internal__WCDMA_CMAC_DL_R99 = 0x412C,
  eSQF_LOG_Obsolete__WCDMA_Reference_Position = 0x412E,
  eSQF_LOG_WCDMA_RRC_Signaling_Messages = 0x412F,
  eSQF_LOG_WCDMA_RLC_DL_AM_Configuration = 0x4132,
  eSQF_LOG_WCDMA_RLC_UL_AM_Configuration = 0x4133,
  eSQF_LOG_WCDMA_DL_AM_Data_PDU = 0x4134,
  eSQF_LOG_WCDMA_DL_AM_Signaling_PDU = 0x4135,
  eSQF_LOG_WCDMA_RLC_UL_AM_Statistics_Version_2 = 0x4138,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_Statistics_4139 = 0x4139,
  eSQF_LOG_WCDMA_Radio_Bearer_Rates = 0x413A,
  eSQF_LOG_WCDMA_UL_AM_Data_PDU = 0x413B,
  eSQF_LOG_WCDMA_UL_AM_Signaling_PDU = 0x413C,
  eSQF_LOG_WCDMA_List_Search_Version_3 = 0x413F,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_Statistics_4141 = 0x4141,
  eSQF_LOG_Obsolete__WCDMA_RLC_DL_AM_Statistics = 0x4142,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_PDU = 0x4143,
  eSQF_LOG_Obsolete__WCDMA_RLC_DL_AM_PDU = 0x4144,
  eSQF_LOG_WCDMA_RLC_UL_AM_Control_PDU = 0x4145,
  eSQF_LOG_WCDMA_RLC_DL_AM_Control_PDU = 0x4146,
  eSQF_LOG_Obsolete__WCDMA_Finger_Info_For_TA__Finger_Pilot_Channel_Parameters = 0x4147,
  eSQF_LOG_Obsolete__WCDMA_List_Search_4148 = 0x4148,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_Statistics_V2 = 0x4149,
  eSQF_LOG_WCDMA_RLC_DL_AM_Statistics = 0x414A,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_AM_PDU_V2 = 0x414B,
  eSQF_LOG_WCDMA_Step_1_Search_Version_2 = 0x414C,
  eSQF_LOG_WCDMA_Step_2_Search_Version_2 = 0x414D,
  eSQF_LOG_WCDMA_Step_3_Search_Version_2 = 0x414E,
  eSQF_LOG_WCDMA_List_Search_Version_2 = 0x414F,
  eSQF_LOG_Obsolete__WCDMA_Uplink_And_Downlink_Power_Control_V2 = 0x4150,
  eSQF_LOG_Obsolete__WCDMA_RLC_UL_Ciphering_V2 = 0x4151,
  eSQF_LOG_Obsolete__WCDMA_RLC_DL_Ciphering_V2 = 0x4152,
  //eSQF_LOG_Reserved__WCDMA_L1_Ciphering = 0x4153,
  eSQF_LOG_WCDMA_CM_Interfrequency_Step_1_Search = 0x4155,
  eSQF_LOG_WCDMA_CM_Interfrequency_List_Search = 0x4156,
  eSQF_LOG_Obsolete__WCDMA_DL_RLC_Cipher_PDU_Configuration = 0x4158,
  eSQF_LOG_Obsolete__WCDMA_UL_RLC_Cipher_PDU_Configuration = 0x4159,
  eSQF_LOG_WCDMA_RACH_Parameters = 0x4160,
  eSQF_LOG_WCDMA_RLC_UL_Ciphering = 0x4161,
  eSQF_LOG_WCDMA_RLC_DL_Ciphering = 0x4162,
  eSQF_LOG_Internal__WCDMA_L1_UL_TFC_Power_Limiting = 0x4163,
  eSQF_LOG_WCDMA_AGC_Version_2 = 0x4165,
  eSQF_LOG_WCDMA_UL_DPCH_Power_Information = 0x4166,
  eSQF_LOG_WCDMA_DL_RLC_Cipher_PDU_Configuration = 0x4168,
  eSQF_LOG_WCDMA_UL_RLC_Cipher_PDU_Configuration = 0x4169,
  eSQF_LOG_Internal__WCDMA_Combiner_Timing = 0x416B,
  eSQF_LOG_WCDMA_List_Search_Version_6 = 0x4170,
  eSQF_LOG_WCDMA_Downlink_Transport_Channels_V2 = 0x4171,
  eSQF_LOG_WCDMA_Downlink_Transport_Channel_Debugging_V2 = 0x4172,
  eSQF_LOG_WCDMA_Downlink_Transport_Format_Combination_V2 = 0x4173,
  eSQF_LOG_WCDMA_CM_Interfrequency_Step_1_Search_Version_2 = 0x4174,
  eSQF_LOG_WCDMA_CM_Interfrequency_PN_Version_2 = 0x4175,
  eSQF_LOG_WCDMA_AGC_Edition_2 = 0x4176,
  eSQF_LOG_WCDMA_Step_1_Search_Edition_2 = 0x4177,
  eSQF_LOG_WCDMA_Search_NASTT_Edition_2 = 0x4178,
  eSQF_LOG_WCDMA_PN_Search_Edition_2 = 0x4179,
  eSQF_LOG_WCDMA_CM_Interfrequency_PN_Version_3 = 0x417A,
  eSQF_LOG_WCDMA_Search_History = 0x417C,
  eSQF_LOG_WCDMA_NASTT_Search_History = 0x417D,
  eSQF_LOG_WCDMA_NASTT_Detect_History = 0x417E,
  eSQF_LOG_WCDMA_Utilization_History = 0x417F,
  eSQF_LOG_WCDMA_RACH_Preamble = 0x4180,
  eSQF_LOG_WCDMA_RACH_Timing = 0x4181,
  eSQF_LOG_Internal__WCDMA_TX_Config = 0x4182,
  eSQF_LOG_WCDMA_Step_1_Search_Version_10 = 0x4183,
  eSQF_LOG_WCDMA_Search_NASTT = 0x4184,
  eSQF_LOG_WCDMA_PN_Search = 0x4185,
  eSQF_LOG_WCDMA_Finger_Temporal_Analysis_V2 = 0x4186,
  eSQF_LOG_WCDMA_ASET_Filter_History = 0x4187,
  eSQF_LOG_Internal__WCDMA_EQ_Reconfig = 0x4188,
  eSQF_LOG_Internal__WCDMA_QICE_Debug_Info = 0x4189,
  eSQF_LOG_WCDMA_SCHIC_Debug_Log_Packet_Rev_2 = 0x418A,
  eSQF_LOG_WCDMA_Flexible_RLC_DL_AM_PDU = 0x418B,
  eSQF_LOG_WCDMA_SIRT_Filter_History = 0x418C,
  eSQF_LOG_WCDMA_Ec_I0_Filter_History = 0x418D,
  eSQF_LOG_WCDMA_RxD_Filter_History = 0x418E,
  eSQF_LOG_Internal__WCDMA_QSET_Update = 0x4191,
  eSQF_LOG_WCDMA_Demback_DPCH_Extended_Packet = 0x4193,
  eSQF_LOG_WCDMA_Uplink_HSRANCH_Configuration = 0x4194,
  eSQF_LOG_WCDMA_Uplink_HSRANCH_EDCH_Resource_Parameters = 0x4195,
  eSQF_LOG_WCDMA_Uplink_HSRACH_Channel_Timing = 0x4196,
  eSQF_LOG_WCDMA_Uplink_HSRACH_Preamble_Status = 0x4197,
  eSQF_LOG_WCDMA_ULTPC_Debug = 0x4198,
  eSQF_LOG_Internal__WCDMA_Downlink_TB_Set_Status_Compact_Log = 0x4199,
  eSQF_LOG_WCDMA_HS_Decode_Status_Compact_Log = 0x419A,
  eSQF_LOG_WCDMA_UL_HS_DPCCH_Information_Compact_Log = 0x419B,
  eSQF_LOG_Internal__WCDMA_EUL_ETFC_Restriction_Compact_Log = 0x419C,
  eSQF_LOG_Internal__WCDMA_Equalizer_Debug_Compact_Log = 0x419D,
  eSQF_LOG_WCDMA_DRX_PICH_Log_Packet = 0x41AA,
  eSQF_LOG_WCDMA_ASET_Log_Packet_v2 = 0x41AC,
  eSQF_LOG_WCDMA_CSG_ASF_Measurement_Request = 0x41AE,
  eSQF_LOG_WCDMA_CSG_Cell_Reselection = 0x41AF,
  eSQF_LOG_WCDMA_Frequency_Scan = 0x41B0,
  eSQF_LOG_WCDMA_Periodic_Statistics = 0x41B1,
  eSQF_LOG_Internal__WCDMA_MultiCombiner_Power_Control_for_DC = 0x41B2,
  eSQF_LOG_WCDMA_Neighbor_Search_Optimization = 0x41B3,
  eSQF_LOG_Internal__WCDMA_ASDiv_Configuration = 0x41B4,
  eSQF_LOG_Internal__WCDMA_Periodic_Statistics = 0x41B5,
  eSQF_LOG_WCDMA_CxM_Log_Packet = 0x41B6,
  eSQF_LOG_WCDMA_Tuneaway_Log = 0x41B7,
  eSQF_LOG_WCDMA_CTCH_Enhancement = 0x41B9,
  eSQF_LOG_Internal__WCDMA_DL_TBSet_Status = 0x41BA,
  eSQF_LOG_WCDMA_CM_Pattern_Activity = 0x41BB,
  eSQF_LOG_Internal__WCDMA_RLC_AM_Logging = 0x41BD,
  eSQF_LOG_Internal__MAC_Uplink_Configuration_Logging = 0x41BE,
  eSQF_LOG_InternalMAC_Uplink_HS_Configuration_Logging = 0x41BF,
  eSQF_LOG_Internal__MAC_DownlinkHS_Configuration_Logging = 0x41C0,
  eSQF_LOG_WCDMA_HSDPA_Configuration = 0x4200,
  eSQF_LOG_WCDMA_HSDPA_UL_Beta_Gain_Table = 0x4201,
  eSQF_LOG_WCDMA_Finger_TA__HS_Information = 0x4202,
  eSQF_LOG_WCDMA_HSDPA_Demodulator_Control_Table = 0x4203,
  eSQF_LOG_WCDMA_HSDPA_Modulator_Control_Table = 0x4204,
  eSQF_LOG_Obsolete__WCDMA_HS_Decode_Status = 0x4205,
  eSQF_LOG_WCDMA_HS_Decode_Status_With_Data_V1 = 0x4206,
  eSQF_LOG_WCDMA_HSSCCH_Statistics = 0x4207,
  eSQF_LOG_WCDMA_HSDSCH_HARQ_Statistics = 0x4208,
  eSQF_LOG_Internal__WCDMA_HS_CQI_Statistics = 0x4209,
  eSQF_LOG_Obsolete__WCDMA_Compact_UL_HS_DPCCH_Information = 0x420A,
  eSQF_LOG_WCDMA_UL_HS_DPCCH_Information = 0x420B,
  eSQF_LOG_WCDMA_TB_Set_Status_V2 = 0x420C,
  eSQF_LOG_Internal__WCDMA_HS_Pessimistic_CQI = 0x420D,
  eSQF_LOG_Obsolete__WCDMA_HS_Amplitude_And_Energy_Estimation_V1 = 0x420E,
  eSQF_LOG_Internal__WCDMA_HS_Pessimistic_CQI_Log_Packet_Version_2 = 0x420F,
  eSQF_LOG_WCDMA_MAC_HS_Configuration = 0x4210,
  eSQF_LOG_WCDMA_MAC_HS_Headers = 0x4211,
  eSQF_LOG_WCDMA_MAC_HS_Status = 0x4212,
  eSQF_LOG_WCDMA_MAC_HS_Reset = 0x4213,
  eSQF_LOG_WCDMA_HS_Decode_Status_With_Data_V2 = 0x4214,
  eSQF_LOG_Internal__WCDMA_HS_Equalizer_Debug = 0x4215,
  eSQF_LOG_Internal__WCDMA_HS_Equalizer_Reconfiguration = 0x4216,
  eSQF_LOG_Internal__WCDMA_TB_Set_Status_V3 = 0x4217,
  eSQF_LOG_Internal__WCDMA_HS_Amplitude_And_Energy_Estimation_V2 = 0x4218,
  eSQF_LOG_Internal__WCDMA_HS_Amplitude_And_Energy_Estimation_V3 = 0x4219,
  eSQF_LOG_Internal__WCDMA_TB_Set_Status_V4 = 0x421A,
  eSQF_LOG_Internal__WCDMA_Downlink_TB_Set_Status = 0x421B,
  eSQF_LOG_WCDMA_UL_HS_DPCCH_Information_V2 = 0x421C,
  eSQF_LOG_Internal__WCDMA_HS_Amplitude_and_Energy_Estimation_V1 = 0x421D,
  eSQF_LOG_WCDMA_MACehs_Reassembly = 0x421E,
  eSQF_LOG_WCDMA_HSSCCH_Statistics_Edition_2 = 0x421F,
  eSQF_LOG_WCDMA_MAC_HS_Configuration_V2 = 0x4220,
  eSQF_LOG_WCDMA_HSDSCH_HARQ_Statistics_V2 = 0x4221,
  eSQF_LOG_WCDMA_HS_Decode_Status_With_Data_V3 = 0x4222,
  eSQF_LOG_Internal__WCDMA_MIMO_Channel_Analysis = 0x4223,
  eSQF_LOG_Internal__WCDMA_MIMO_Demod = 0x4224,
  eSQF_LOG_WCDMA_HSDPA_Configuration_V2 = 0x4225,
  eSQF_LOG_Internal__WCDMA_Equalizer_Debug = 0x4226,
  eSQF_LOG_Internal__WCDMA_SCHIC_Debug = 0x4227,
  eSQF_LOG_Internal__WCDMA_QDSP6_MIPS_Profiling = 0x4228,
  eSQF_LOG_Internal__WCDMA_QDSP6_AllWait_Percent = 0x4229,
  eSQF_LOG_Internal__Watermarks_Tracing_Log_Packet = 0x422A,
  eSQF_LOG_Internal__WCDMA_CPC_DTx_State_Machine = 0x422C,
  eSQF_LOG_WCDMA_HS_CQI_Statistics_Edition_2 = 0x422E,
  eSQF_LOG_WCDMA_MBMS_Configuration = 0x4230,
  eSQF_LOG_WCDMA_MBMS_MICH_Demodulation_Information = 0x4231,
  eSQF_LOG_WCDMA_CSoHS_Downlink_Voice_Data_Information = 0x4235,
  eSQF_LOG_WCDMA_CSoHS_Uplink_Voice_Data_Information = 0x4236,
  eSQF_LOG_Internal__EWC_Regular_Info_Version_1 = 0x4238,
  eSQF_LOG_Downlink_Datapath_Log_Packet = 0x4239,
  eSQF_LOG_CPCDRX_State_Machine_Log_Packet = 0x423A,
  eSQF_LOG_DRX_Config_Log_Packet = 0x423B,
  eSQF_LOG_Internal__EWC_Debug_Info_Version_1 = 0x423E,
  eSQF_LOG_WCDMA_HS_SCCH_Decode_Status = 0x423F,
  eSQF_LOG_WCDMA_EUL_DL_Channel_Configuration = 0x4301,
  eSQF_LOG_Internal__WCDMA_EUL_DL_Decode_Information = 0x4302,
  eSQF_LOG_WCDMA_EUL_UL_Channel_Configuration = 0x4303,
  eSQF_LOG_Internal__WCDMA_EUL_R_Combo_Table = 0x4304,
  eSQF_LOG_WCDMA_EUL_UL_EDPCH = 0x4305,
  eSQF_LOG_Internal__WCDMA_EUL_UL_EDPCH_Debug = 0x4306,
  eSQF_LOG_Internal__WCDMA_EUL_ETFC_Restriction = 0x4307,
  eSQF_LOG_Internal__WCDMA_EUL_Rate_Matching = 0x4308,
  eSQF_LOG_WCDMA_EUL_Combined_L1_MAC = 0x4309,
  eSQF_LOG_DRX_In_Enh_Cell_FACH_State_Machine = 0x430A,
  eSQF_LOG_DRX_In_Enh_Cell_FACH_Configuration = 0x430B,
  eSQF_LOG_Internal__WCDMA_ARD = 0x430C,
  eSQF_LOG_WCDMA_EUL_MAC_I_IS = 0x430E,
  eSQF_LOG_WCDMA_Flexible_UL_RLC_AM_PDU = 0x430F,
  eSQF_LOG_WCDMA_EUL_Ciphering = 0x4310,
  eSQF_LOG_WCDMA_EUL_Link_Statistics = 0x4311,
  eSQF_LOG_Internal__WCDMA_EUL_Uplink_Physical_Channel_TX_Information = 0x4312,
  eSQF_LOG_Internal__WCDMA_Uplink_TX_RF_Debug = 0x4313,
  eSQF_LOG_Internal__WCDMA_HSRACH_AND_MACi_is_Timers_And_State_Machine = 0x4314,
  eSQF_LOG_WCDMA_EUL_MAC_E_ES_Configuration = 0x4321,
  eSQF_LOG_WCDMA_EUL_MAC_E_ES_Header = 0x4322,
  eSQF_LOG_Internal__WCDMA_EUL_ETFC_Selection = 0x4323,
  eSQF_LOG_Internal__EUL_EHICH_Decoding = 0x4324,
  eSQF_LOG_Internal__EUL_ERGCH_Decoding = 0x4325,
  eSQF_LOG_Internal__EUL_EAGCH_Decoding = 0x4326,
  eSQF_LOG_WCDMA_UL_UM_PDU_Data = 0x4331,
  eSQF_LOG_WCDMA_DL_UM_PDU_Data = 0x4332,
  eSQF_LOG_Internal__WCDMA_EUL_IRQ_Flow_Control = 0x4333,
  eSQF_LOG_WCDMA_EUL_ETFC_Restriction_Version_1 = 0x4336,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_DL_Channel_Configuration = 0x4340,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_UL_Channel_Configuration = 0x4341,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_UL_EDPCH = 0x4342,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_Rate_Matching = 0x4343,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_Combined_L1_Mac = 0x4344,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_Link_Statistics = 0x4345,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_UL_RF_Tx_Debug = 0x4346,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_EHICH_Decoding = 0x4347,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_ERGCH_Decoding = 0x4348,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_EAGCH_Decoding = 0x4349,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_Power_Allocation = 0x435A,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_MPR = 0x435B,
  eSQF_LOG_Internal__WCDMA_Multi_Carrier_EUL_RCOMBO_Tables = 0x435C,
  eSQF_LOG_WCDMA_Multi_Carrier_EUL_ETFC_Restriction = 0x435D,
  eSQF_LOG_WCDMA_FACH_Measurement_Occasion_Info = 0x4721,
  eSQF_LOG_WCDMA_L1_FACH_InterRAT_Measurements = 0x4722,
  eSQF_LOG_WCDMA_DL_TFCI_Status = 0x4770,
  eSQF_LOG_Internal__WCDMA_HS_Equalizer_Debug_V1 = 0x4771,
  eSQF_LOG_Internal__WCDMA_TFCI_Log_Packet = 0x4773,
  eSQF_LOG_Internal__WCDMA_ILPC_Debug_Log_Packet = 0x4774,
  eSQF_LOG_WCDMA_XO_Log_Packet = 0x4776,
  eSQF_LOG_Internal__WCDMA_Slot_Level_ILPC_Debug_Log_Packet = 0x4778,
  eSQF_LOG_H324_Downlink_223_MUX_PDU = 0x4900,
  eSQF_LOG_H324_Downlink_Audio_SDU = 0x4901,
  eSQF_LOG_H324_Downlink_Video_SDU = 0x4902,
  eSQF_LOG_H324_Downlink_245_SIG_SDU = 0x4903,
  eSQF_LOG_H324_Uplink_223_MUX_PDU = 0x4904,
  eSQF_LOG_H324_Uplink_Audio_SDU = 0x4905,
  eSQF_LOG_H324_Uplink_Video_SDU = 0x4906,
  eSQF_LOG_H324_Uplink_245_SIG_SDU = 0x4907,
  eSQF_LOG_H324_Uplink_Adaptation_Layer_245 = 0x4908,
  eSQF_LOG_H324_Downlink_Adaptation_Layer_245 = 0x4909,
  eSQF_LOG_H324_Video_Statistics = 0x490A,
  eSQF_LOG_H324_Video_Encoder = 0x490B,
  eSQF_LOG_H324_Video_Decoder = 0x490C,
  eSQF_LOG_H324_Uplink_Audio_Sequence_Number_Time_Stamp = 0x490D,
  eSQF_LOG_H324_Downlink_Audio_Sequence_Number_Time_Stamp = 0x490E,
  eSQF_LOG_H324_Uplink_Video_Time_Stamp = 0x490F,
  eSQF_LOG_H324_Downlink_Video_Time_Stamp = 0x4910,
  //eSQF_LOG_Reserved__QVP = 0x4911,
  //eSQF_LOG_Reserved__QVP = 0x4912,
  //eSQF_LOG_Reserved__QVP = 0x4913,
  //eSQF_LOG_Reserved__QVP = 0x4914,
  //eSQF_LOG_Reserved__QVP = 0x4915,
  //eSQF_LOG_Reserved__QVP = 0x4916,
  //eSQF_LOG_Reserved__QVP = 0x4917,
  //eSQF_LOG_Reserved__QVP = 0x4918,
  //eSQF_LOG_Reserved__QVP = 0x4919,
  //eSQF_LOG_Reserved__QVP = 0x491A,
  //eSQF_LOG_Reserved__QVP = 0x491B,
  //eSQF_LOG_Reserved__QVP = 0x491C,
  //eSQF_LOG_Reserved__QVP = 0x491D,
  //eSQF_LOG_Reserved__QVP = 0x491E,
  //eSQF_LOG_Reserved__QVP = 0x491F,
  //eSQF_LOG_Reserved__QVP = 0x4920,
  eSQF_LOG_Tool_Generated_WCDMA_Status = 0x4FF6,
  eSQF_LOG_GSM_PLT_Packet = 0x5000,
  eSQF_LOG_GSM_CFA_Packet = 0x5001,
  eSQF_LOG_GSM_L1_Power_Scan_Results = 0x5064,
  eSQF_LOG_GSM_L1_FCCH_Acquisition = 0x5065,
  eSQF_LOG_GSM_L1_SCH_Acquisition = 0x5066,
  eSQF_LOG_Internal__GSM_EDGE_Enhanced = 0x5069,
  eSQF_LOG_GSM_L1_New_Burst_Metrics = 0x506A,
  eSQF_LOG_Obsolete__GSM_L1_Message_Metrics = 0x506B,
  eSQF_LOG_GSM_L1_Burst_Metrics = 0x506C,
  eSQF_LOG_GSM_L1_Paging_Data = 0x506F,
  eSQF_LOG_GSM_L1_Surround_Cell_Engine_Mode = 0x5070,
  eSQF_LOG_GSM_L1_Surround_Cell_BA_List = 0x5071,
  eSQF_LOG_GSM_L1_Serving_Cell_Info = 0x5072,
  eSQF_LOG_GSM_L1_GSTMR_Adjust = 0x5073,
  eSQF_LOG_Obsolete__GSM_L1_PDM_Adjust = 0x5074,
  eSQF_LOG_GSM_L1_Neighbor_Cell_Acquisition = 0x5075,
  eSQF_LOG_GSM_L1_TxLev_Timing_Advance = 0x5076,
  eSQF_LOG_Obsolete__GSM_L1_Neighbor_BCCH_Decode = 0x5077,
  eSQF_LOG_GSM_L1_PDM_Adjust_V2 = 0x5078,
  eSQF_LOG_GSM_L1_Enhanced_Message_Metrics = 0x5079,
  eSQF_LOG_GSM_L1_Serving_Auxiliary_Measurments = 0x507A,
  eSQF_LOG_GSM_L1_Neighbor_Cell_Auxiliary_Measurments = 0x507B,
  eSQF_LOG_GSM_AFC_Adjust = 0x507C,
  eSQF_LOG_GSM_Ncell_Metrics = 0x507D,
  eSQF_LOG_GSM_Monitor_Bursts_V2 = 0x5082,
  eSQF_LOG_GSM_L1_Neighbor_Cell_SCH_Burst_Metrics = 0x5083,
  eSQF_LOG_GSM_L1_Neighbor_Cell_SCH_Message_Metrics = 0x5084,
  eSQF_LOG_GSM_L1_Neighbor_Cell_BCCH_Burst_Metrics = 0x5085,
  eSQF_LOG_GSM_L1_Neighbor_Cell_BCCH_Message_Metrics = 0x5086,
  eSQF_LOG_GSM_L1_Neighbor_Cell_SCH_Metrics_V2 = 0x5087,
  eSQF_LOG_GSM_L1_Transmit_Burst_Metrics = 0x5088,
  eSQF_LOG_GSM_L1_New_Transmit_Burst_Metrics = 0x5089,
  eSQF_LOG_GSM_MDSP_Command_Information = 0x508C,
  eSQF_LOG_GSM_GL1_Hardware_Command = 0x508D,
  eSQF_LOG_GSM_MDSP_Scaling_Factors = 0x508E,
  eSQF_LOG_GSM_FW_Debug_Buffer = 0x508F,
  eSQF_LOG_GSM_MDSP_Applications = 0x5090,
  eSQF_LOG_GSM_L1_eSAIC_Voice_Metrics = 0x5091,
  eSQF_LOG_GPRS_L1_eSAIC_Data_Metrics = 0x5092,
  eSQF_LOG_GSM_CxM = 0x5094,
  eSQF_LOG_GSM_L1_Rx_Diversity_Metrics = 0x5096,
  eSQF_LOG_Internal__GSM_EPD_Metrics_vs__Time = 0x5097,
  eSQF_LOG_Internal__GSM_L1_VAMOS_Metrics = 0x5099,
  eSQF_LOG_GSM_L1_HLLL_State = 0x509A,
  eSQF_LOG_GSM_eSAIC_Metrics_v2 = 0x509B,
  eSQF_LOG_GPRS_eSAIC_Metrics_v2 = 0x509C,
  eSQF_LOG_GSM_AEQ_SCH_Metrics_v2 = 0x509D,
  eSQF_LOG_Internal__GSM_LIF_Metrics_vs__Time = 0x509F,
  eSQF_LOG_GSM_L1_SACCH_Burst_Metrics = 0x50A0,
  eSQF_LOG_GSM_L1_Message_Metrics_Compact = 0x50A1,
  eSQF_LOG_GSM_L2_States = 0x50C8,
  eSQF_LOG_GSM_L2_Transmission_Status = 0x50C9,
  eSQF_LOG_GSM_L2_Outstanding_Frame = 0x50CA,
  eSQF_LOG_GSM_RR_State = 0x512C,
  eSQF_LOG_Obsolete__GSM_RR_Link_Failure_Detection = 0x512D,
  eSQF_LOG_GSM_RR_Protocol_Error = 0x512E,
  eSQF_LOG_GSM_RR_Signaling_Message = 0x512F,
  eSQF_LOG_GSM_RR_Cell_Selection_AND_Reselection_Parameters = 0x5130,
  eSQF_LOG_GSM_RR_RACH_Control_Parameters = 0x5131,
  eSQF_LOG_GSM_RR_Control_Channel_Desc_Parameters = 0x5132,
  eSQF_LOG_GSM_RR_Cell_Options = 0x5133,
  eSQF_LOG_GSM_RR_Cell_Information = 0x5134,
  eSQF_LOG_GSM_RR_Channel_Configuration = 0x5135,
  eSQF_LOG_GSM_RR_Ciphering_Mode = 0x5136,
  eSQF_LOG_GSM_RR_Cell_Selection_And_Reselection_Measurements = 0x5137,
  eSQF_LOG_GSM_RR_Downlink_Signaling_Counter = 0x5138,
  eSQF_LOG_GSM_RR_Radio_Link_Timeout_Counter = 0x5139,
  eSQF_LOG_GSM_RR_SACCH_Measurement_Report = 0x513A,
  eSQF_LOG_GSM_RR_BA_List = 0x513C,
  eSQF_LOG_GSM_RR_IRAT_Measurements = 0x513E,
  eSQF_LOG_GSM_RR_IRAT_Priority_List = 0x513F,
  eSQF_LOG_Obsolete__GSM_Circuit_Switched_Data_RX_Frame = 0x5190,
  eSQF_LOG_Obsolete__GSM_Circuit_Switched_Data_TX_Frame = 0x5191,
  eSQF_LOG_GPRS_Indicators = 0x51F4,
  eSQF_LOG_GPRS_General_Parameters = 0x51F5,
  eSQF_LOG_GPRS_Cell_Options = 0x51F6,
  eSQF_LOG_GPRS_Power_Control_Parameters = 0x51F7,
  eSQF_LOG_GPRS_Mobile_Allocation = 0x51F8,
  eSQF_LOG_GPRS_PBCCH_Description = 0x51F9,
  eSQF_LOG_GPRS_GRR_State = 0x51FA,
  eSQF_LOG_GPRS_GRR_Cell_Reselection_Parameters = 0x51FB,
  eSQF_LOG_GPRS_GRR_Cell_Reselection_Measurements = 0x51FC,
  eSQF_LOG_GPRS_Packet_System_Information_1 = 0x51FD,
  eSQF_LOG_GPRS_Packet_System_Information_2 = 0x51FE,
  eSQF_LOG_GPRS_Packet_System_Information_3 = 0x51FF,
  eSQF_LOG_GPRS_RLC_UL_Abnormal_Release_Counts = 0x5200,
  eSQF_LOG_GPRS_RLC_UL_Event_Counts = 0x5201,
  eSQF_LOG_GPRS_RLC_UL_Statistics = 0x5202,
  eSQF_LOG_GPRS_EGPRS_UL_RLC_Header = 0x5205,
  eSQF_LOG_GPRS_EGPRS_DL_RLC_Header = 0x5206,
  eSQF_LOG_GPRS_EGPRS_RLC_UL_Statistics = 0x5207,
  eSQF_LOG_GPRS_EGPRS_RLC_DL_Statistics = 0x5208,
  eSQF_LOG_EGPRS_RLC_UL_Ack_Nack = 0x5209,
  eSQF_LOG_GPRS_RLC_DL_Statistics = 0x520A,
  eSQF_LOG_Obsolete__GPRS_RLC_UL_Ack_Nack_Parameters = 0x520B,
  eSQF_LOG_Obsolete__GPRS_RLC_DL_Ack_Nack_Parameters = 0x520C,
  eSQF_LOG_GPRS_RLC_UL_Release_Indicator = 0x520D,
  eSQF_LOG_GPRS_RLC_DL_Release_Indicator = 0x520E,
  eSQF_LOG_GPRS_RLC_UL_Ack_Nack_Parameters = 0x520F,
  eSQF_LOG_GPRS_RLC_DL_Ack_Nack_Parameters = 0x5210,
  eSQF_LOG_EGPRS_RLC_DL_Ack_Nack = 0x5211,
  eSQF_LOG_GPRS_LLC_ME_LLME_Information = 0x5212,
  eSQF_LOG_GPRS_LLC_SAPI_States = 0x5213,
  eSQF_LOG_GPRS_LLC_XID_Information = 0x5214,
  eSQF_LOG_GPRS_LLC_PDU_Statistics = 0x5215,
  eSQF_LOG_GPRS_LLC_Periodic_Statistics = 0x5216,
  eSQF_LOG_GPRS_LLC_Ready_Timer_Status = 0x5217,
  eSQF_LOG_GPRS_LLC_UI_Send_PDU = 0x5218,
  eSQF_LOG_GPRS_LLC_UI_Receive_PDU = 0x5219,
  eSQF_LOG_GPRS_LLC_Ready_Timer_Status_V2 = 0x521A,
  eSQF_LOG_GPRS_SNDCP_Active_PDP_Contexts = 0x521C,
  eSQF_LOG_GPRS_SNDCP_PDP_Context_Information = 0x521D,
  eSQF_LOG_GPRS_SNDCP_States = 0x521E,
  eSQF_LOG_GPRS_SNDCP_PDU_Statistics = 0x521F,
  eSQF_LOG_GPRS_SNDCP_UL_TCP_Header = 0x5220,
  eSQF_LOG_GPRS_SNDCP_DL_TCP_Header = 0x5221,
  eSQF_LOG_GPRS_MAC_Signaling_Messages = 0x5226,
  eSQF_LOG_GPRS_MAC_State = 0x5227,
  eSQF_LOG_GPRS_MAC_UL_TBF_Establish = 0x5228,
  eSQF_LOG_GPRS_MAC_UL_TBF_Release = 0x5229,
  eSQF_LOG_GPRS_MAC_DL_TBF_Establish = 0x522A,
  eSQF_LOG_GPRS_MAC_DL_TBF_Release = 0x522B,
  eSQF_LOG_GPRS_EGPRS_UL_MAC_Ack_Nack = 0x522C,
  eSQF_LOG_GPRS_EGPRS_DL_MAC_Ack_Nack = 0x522D,
  eSQF_LOG_GPRS_DL_SRB_Loopback_Mode_Bit_Stream = 0x522E,
  eSQF_LOG_GPRS_SM_GMM_OTA_Signaling_Messages = 0x5230,
  eSQF_LOG_GPRS_Air_Interface_Summary = 0x5231,
  eSQF_LOG_GPRS_L1_AGC = 0x5232,
  eSQF_LOG_GPRS_Timing_Advance = 0x5233,
  eSQF_LOG_GPRS_Power_Control = 0x5234,
  eSQF_LOG_GPRS_L1_Transfer_Summary = 0x5235,
  eSQF_LOG_GPRS_L1_Hopping_ARFCNs = 0x5236,
  eSQF_LOG_GPRS_TX_Schedule_Results = 0x5237,
  eSQF_LOG_GPRS_Frame_Scheduler_Information = 0x523A,
  eSQF_LOG_GPRS_UL_TBF_Data_Block_Count = 0x523F,
  eSQF_LOG_GPRS_L1_Burst_Metrics_A = 0x5245,
  eSQF_LOG_GPRS_L1_Burst_Metrics_B = 0x5246,
  eSQF_LOG_GPRS_L1_Burst_Metrics_C = 0x5247,
  eSQF_LOG_GPRS_L1_Burst_Metrics_D = 0x5248,
  eSQF_LOG_GPRS_L1_Burst_Metrics_E = 0x5249,
  eSQF_LOG_GPRS_L1_Message_Metrics_A_Version_2 = 0x524D,
  eSQF_LOG_GPRS_L1_Message_Metrics_B_Version_2 = 0x524E,
  eSQF_LOG_GPRS_L1_Message_Metrics_C_Version_2 = 0x524F,
  eSQF_LOG_GPRS_L1_Message_Metrics_D_Version_2 = 0x5250,
  eSQF_LOG_GPRS_DLPTCCH_Burst_Metric = 0x5251,
  eSQF_LOG_GPRS_DLPTCCH_Message_Metric = 0x5252,
  eSQF_LOG_GPRS_L1_Message_Metrics_E_Version_2 = 0x5253,
  eSQF_LOG_GPRS_L1_Burst_Metrics_A_v1 = 0x5254,
  eSQF_LOG_GPRS_L1_Burst_Metrics_B_v1 = 0x5255,
  eSQF_LOG_GPRS_L1_Burst_Metrics_C_v1 = 0x5256,
  eSQF_LOG_GPRS_L1_Burst_Metrics_D_v1 = 0x5257,
  eSQF_LOG_GSM_Idle_Mode_WCDMA_Known_List = 0x5258,
  eSQF_LOG_GSM_Dedicated_Mode_Fill_Sample_RAM = 0x5259,
  eSQF_LOG_GSM_Dedicated_Mode_WCDMA_Cell_List = 0x525A,
  eSQF_LOG_GSM_RR_3G_Measurement_Report = 0x525B,
  eSQF_LOG_GSM_Idle_Mode_3G_Reselect_Reject = 0x525C,
  eSQF_LOG_GSM_G2W_Searcher_Step_1 = 0x525D,
  eSQF_LOG_GSM_G2W_Searcher_Step_2 = 0x525E,
  eSQF_LOG_GSM_G2W_Searcher_Step_3 = 0x525F,
  eSQF_LOG_GSM_G2W_Searcher_List = 0x5260,
  eSQF_LOG_Internal__GSM_RFACCH_Metrics_vs__Time = 0x5261,
  eSQF_LOG_GPRS_GRR_3G_Measurement_Parameter = 0x5262,
  eSQF_LOG_GPRS_GRR_3G_Reselection_Measurements = 0x5263,
  eSQF_LOG_G2T_IRAT_Measurement_Request = 0x5270,
  eSQF_LOG_G2T_IRAT_Measurement_Response = 0x5271,
  eSQF_LOG_G2T_IRAT_Acquisition_Request = 0x5272,
  eSQF_LOG_G2T_IRAT_Acquisition_Response = 0x5273,
  eSQF_LOG_WMS_Receive_CB = 0x5384,
  eSQF_LOG_Internal__GSM_Frame_Number_Adjustment = 0x5400,
  eSQF_LOG_Obsolete__GSM_Monitor_Bursts = 0x5408,
  eSQF_LOG_Obsolete__GSM_SACCH_Reports_Rev_0 = 0x5410,
  eSQF_LOG_Obsolete__GSM_SACCH_Reports_Rev_1 = 0x5411,
  eSQF_LOG_GSM_DSDS_PLT_Packet = 0x5A00,
  eSQF_LOG_GSM_DSDS_CFA_Packet = 0x5A01,
  eSQF_LOG_GSM_DSDS_Power_Scan_Results = 0x5A64,
  eSQF_LOG_GSM_DSDS_L1_FCCH_Acquisition = 0x5A65,
  eSQF_LOG_GSM_DSDS_L1_SCH_Acquisition = 0x5A66,
  eSQF_LOG_GSM_DSDS_L1_Burst_Metrics = 0x5A6C,
  eSQF_LOG_GSM_DSDS_Paging_Data = 0x5A6F,
  eSQF_LOG_GSM_DSDS_Surround_Cell_Engine_Mode = 0x5A70,
  eSQF_LOG_GSM_DSDS_Surround_Cell_BA_List = 0x5A71,
  eSQF_LOG_GSM_DSDS_L1_Serving_Cell_Info = 0x5A72,
  eSQF_LOG_GSM_DSDS_L1_GSTMR_ADJ = 0x5A73,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_Acquisition = 0x5A75,
  eSQF_LOG_GSM_DSDS_L1_TxLev_Timing_Advance = 0x5A76,
  eSQF_LOG_GSM_DSDS_L1_PDM_Adjust_Ver2 = 0x5A78,
  eSQF_LOG_GSM_DSDS_L1_Enhanced_Message_Metrics = 0x5A79,
  eSQF_LOG_GSM_DSDS_L1_Serving_Auxiliary_Measurements = 0x5A7A,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_Auxiliary_Measurements = 0x5A7B,
  eSQF_LOG_GSM_DSDS_AFC_Adjust = 0x5A7C,
  eSQF_LOG_GSM_DSDS_Ncell_Metrics = 0x5A7D,
  eSQF_LOG_GSM_DSDS_L1_Monitor_Bursts = 0x5A82,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_SCH_Burst_Metrics = 0x5A83,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_SCH_Message_Metrics = 0x5A84,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_BCCH_Burst_Metrics = 0x5A85,
  eSQF_LOG_GSM_DSDS_L1_Neighbor_Cell_BCCH_Message_Metrics = 0x5A86,
  eSQF_LOG_GSM_DSDS_L1_neighbor_cell_SCH_Metrics_V2 = 0x5A87,
  eSQF_LOG_GSM_DSDS_L1_Transmit_Burst_Metrics = 0x5A88,
  eSQF_LOG_GSM_DSDS_MDSP_Command = 0x5A8C,
  eSQF_LOG_GSM_DSDS_GL1_HW_Command = 0x5A8D,
  eSQF_LOG_GSM_DSDS_MDSP_scaling_factors = 0x5A8E,
  eSQF_LOG_GSM_DSDS_MDSP_Applications = 0x5A90,
  eSQF_LOG_GSM_DSDS_SAIC_Metrics = 0x5A91,
  eSQF_LOG_GSM_DSDS_L1_SACCH_Burst_Metrics = 0x5AA0,
  eSQF_LOG_GSM_DSDS_L1_Message_Metrics_Compact = 0x5AA1,
  eSQF_LOG_GSM_DSDS_L2_States = 0x5AC8,
  eSQF_LOG_GSM_DSDS_L2_Transmission_Status = 0x5AC9,
  eSQF_LOG_GSM_DSDS_L2_Outstanding_Frame = 0x5ACA,
  eSQF_LOG_GSM_DSDS_RR_State = 0x5B2C,
  eSQF_LOG_GSM_DSDS_RR_Protocol_Error = 0x5B2E,
  eSQF_LOG_GSM_DSDS_RR_Signaling_Message = 0x5B2F,
  eSQF_LOG_GSM_DSDS_RR_Cell_Selection_And_Reselection_Parameters = 0x5B30,
  eSQF_LOG_GSM_DSDS_RR_RACH_Control_Parameters = 0x5B31,
  eSQF_LOG_GSM_DSDS_RR_Control_Channel_Desc_Parameters = 0x5B32,
  eSQF_LOG_GSM_DSDS_RR_Cell_Options = 0x5B33,
  eSQF_LOG_GSM_DSDS_RR_Cell_Information = 0x5B34,
  eSQF_LOG_GSM_DSDS_RR_Channel_Configuration = 0x5B35,
  eSQF_LOG_GSM_DSDS_RR_Ciphering_Mode = 0x5B36,
  eSQF_LOG_GSM_DSDS_RR_Cell_Selection_and_Reselection_Measurements = 0x5B37,
  eSQF_LOG_GSM_DSDS_RR_Downlink_Signaling_Counter = 0x5B38,
  eSQF_LOG_GSM_DSDS_RR_Radio_Link_Timeout = 0x5B39,
  eSQF_LOG_GSM_DSDS_RR_SACCH_Report = 0x5B3A,
  eSQF_LOG_GSM_DSDS_RR_BA_List = 0x5B3C,
  eSQF_LOG_GSM_DSDS_RR_IRAT_Measurements = 0x5B3E,
  eSQF_LOG_GSM_DSDS_RR_IRAT_Priority_List = 0x5B3F,
  eSQF_LOG_GPRS_DSDS_Indicators = 0x5BF4,
  eSQF_LOG_GPRS_DSDS_General_Parameters = 0x5BF5,
  eSQF_LOG_GPRS_DSDS_Cell_Options = 0x5BF6,
  eSQF_LOG_GPRS_DSDS_Power_Control_Parameters = 0x5BF7,
  eSQF_LOG_GPRS_DSDS_Mobile_Allocation = 0x5BF8,
  eSQF_LOG_GPRS_DSDS_PBCCH_Description = 0x5BF9,
  eSQF_LOG_GPRS_DSDS_GRR_State = 0x5BFA,
  eSQF_LOG_GPRS_DSDS_GRR_Cell_Reselection_Parameters = 0x5BFB,
  eSQF_LOG_GPRS_DSDS_GRR_Cell_Reselection_Measurements = 0x5BFC,
  eSQF_LOG_GPRS_DSDS_Packet_System_Information_1 = 0x5BFD,
  eSQF_LOG_GPRS_DSDS_Packet_System_Information_2 = 0x5BFE,
  eSQF_LOG_GPRS_DSDS_Packet_System_Information_3 = 0x5BFF,
  eSQF_LOG_GPRS_DSDS_RLC_UL_Abnormal_Release_Counts = 0x5C00,
  eSQF_LOG_GPRS_DSDS_RLC_UL_Event_Counts = 0x5C01,
  eSQF_LOG_GPRS_DSDS_RLC_UL_Statistics = 0x5C02,
  eSQF_LOG_GPRS_EGPRS_DSDS_UL_RLC_Header = 0x5C05,
  eSQF_LOG_GPRS_EGPRS_DSDS_DL_RLC_Header = 0x5C06,
  eSQF_LOG_GPRS_EGPRS_DSDS_RLC_UL_Statistics = 0x5C07,
  eSQF_LOG_GPRS_EGPRS_DSDS_RLC_DL_Statistics = 0x5C08,
  eSQF_LOG_EGPRS_DSDS_RLC_UL_Ack_Nack = 0x5C09,
  eSQF_LOG_GPRS_DSDS_RLC_DL_Statistics = 0x5C0A,
  eSQF_LOG_GPRS_DSDS_RLC_UL_Release_Indicator = 0x5C0D,
  eSQF_LOG_GPRS_DSDS_RLC_DL_Release_Indicator = 0x5C0E,
  eSQF_LOG_GPRS_DSDS_RLC_UL_Ack_Nack_Parameters = 0x5C0F,
  eSQF_LOG_GPRS_DSDS_RLC_DL_Ack_Nack_Parameters = 0x5C10,
  eSQF_LOG_EGPRS_DSDS_RLC_DL_Ack_Nack = 0x5C11,
  eSQF_LOG_GPRS_DSDS_LLC_ME_LLME_Information = 0x5C12,
  eSQF_LOG_GPRS_DSDS_LLC_SAPI_States = 0x5C13,
  eSQF_LOG_GPRS_DSDS_LLC_XID_Information = 0x5C14,
  eSQF_LOG_GPRS_DSDS_LLC_PDU_Statistics = 0x5C15,
  eSQF_LOG_GPRS_DSDS_LLC_Periodic_Statistics = 0x5C16,
  eSQF_LOG_GPRS_DSDS_LLC_Ready_Timer_Status = 0x5C17,
  eSQF_LOG_GPRS_DSDS_LLC_UI_Send_PDU = 0x5C18,
  eSQF_LOG_GPRS_DSDS_LLC_UI_Receive_PDU = 0x5C19,
  eSQF_LOG_GPRS_DSDS_LLC_Ready_Timer_Status_V2 = 0x5C1A,
  eSQF_LOG_GPRS_DSDS_SNDCP_Active_PDP_Contexts = 0x5C1C,
  eSQF_LOG_GPRS_DSDS_SNDCP_PDP_Context_Information = 0x5C1D,
  eSQF_LOG_GPRS_DSDS_SNDCP_States = 0x5C1E,
  eSQF_LOG_GPRS_DSDS_SNDCP_PDU_Statistics = 0x5C1F,
  eSQF_LOG_GPRS_DSDS_SNDCP_UL_TCP_Header = 0x5C20,
  eSQF_LOG_GPRS_DSDS_SNDCP_DL_TCP_Header = 0x5C21,
  eSQF_LOG_GPRS_DSDS_MAC_Signaling_Messages = 0x5C26,
  eSQF_LOG_GPRS_DSDS_MAC_State = 0x5C27,
  eSQF_LOG_GPRS_DSDS_MAC_UL_TBF_Establish = 0x5C28,
  eSQF_LOG_GPRS_DSDS_MAC_UL_TBF_Release = 0x5C29,
  eSQF_LOG_GPRS_DSDS_MAC_DL_TBF_Establish = 0x5C2A,
  eSQF_LOG_GPRS_DSDS_MAC_DL_TBF_Release = 0x5C2B,
  eSQF_LOG_GPRS_EGPRS_DSDS_UL_MAC_Ack_Nack = 0x5C2C,
  eSQF_LOG_GPRS_EGPRS_DSDS_DL_MAC_Ack_Nack = 0x5C2D,
  eSQF_LOG_GPRS_DSDS_DL_SRB_Loopback_Mode_Bit_Stream = 0x5C2E,
  eSQF_LOG_GPRS_DSDS_SM_GMM_OTA_Signaling_Messages = 0x5C30,
  eSQF_LOG_GPRS_DSDS_Air_Interface_Summary = 0x5C31,
  eSQF_LOG_GPRS_DSDS_L1_AGC = 0x5C32,
  eSQF_LOG_GPRS_DSDS_Timing_Advance = 0x5C33,
  eSQF_LOG_GPRS_DSDS_Power_Control = 0x5C34,
  eSQF_LOG_GPRS_DSDS_L1_Transfer_Summary = 0x5C35,
  eSQF_LOG_GPRS_DSDS_L1_Hopping_ARFCNs = 0x5C36,
  eSQF_LOG_GPRS_DSDS_TX_Schedule_Results = 0x5C37,
  eSQF_LOG_GPRS_DSDS_Frame_Scheduler_Information = 0x5C3A,
  eSQF_LOG_GPRS_DSDS_UL_TBF_Data_Block_Count = 0x5C3F,
  eSQF_LOG_GPRS_DSDS_L1_Burst_Metrics_A = 0x5C45,
  eSQF_LOG_GPRS_DSDS_L1_Burst_Metrics_B = 0x5C46,
  eSQF_LOG_GPRS_DSDS_L1_Burst_Metrics_C = 0x5C47,
  eSQF_LOG_GPRS_DSDS_L1_Burst_Metrics_D = 0x5C48,
  eSQF_LOG_GPRS_DSDS_L1_Burst_Metrics_E = 0x5C49,
  eSQF_LOG_GPRS_DSDS_L1_Message_Metrics_A_Version_2 = 0x5C4D,
  eSQF_LOG_GPRS_DSDS_L1_Message_Metrics_B_Version_2 = 0x5C4E,
  eSQF_LOG_GPRS_DSDS_L1_Message_Metrics_C_Version_2 = 0x5C4F,
  eSQF_LOG_GPRS_DSDS_L1_Message_Metrics_D_Version_2 = 0x5C50,
  eSQF_LOG_GPRS_DSDS_DLPTCCH_Burst_Metric = 0x5C51,
  eSQF_LOG_GPRS_DSDS_DLPTCCH_Message_Metric = 0x5C52,
  eSQF_LOG_GPRS_DSDS_L1_Message_Metrics_E_Version_2 = 0x5C53,
  eSQF_LOG_GSM_DSDS_Idle_Mode_WCDMA_Known_List = 0x5C58,
  eSQF_LOG_GSM_DSDS_Dedicated_Mode_Fill_Sample_RAM = 0x5C59,
  eSQF_LOG_GSM_DSDS_Dedicated_Mode_WCDMA_Cell_List = 0x5C5A,
  eSQF_LOG_GSM_DSDS_RR_3G_Measurement_Report = 0x5C5B,
  eSQF_LOG_GSM_DSDS_RR_3G_Rejected_Cells = 0x5C5C,
  eSQF_LOG_GSM_DSDS_G2W_Searcher_Step_1 = 0x5C5D,
  eSQF_LOG_GSM_DSDS_G2W_Searcher_Step_2 = 0x5C5E,
  eSQF_LOG_GSM_DSDS_G2W_Searcher_Step_3 = 0x5C5F,
  eSQF_LOG_GSM_DSDS_G2W_Searcher_List = 0x5C60,
  eSQF_LOG_GPRS_DSDS_GRR_3G_Measurement_Parameter = 0x5C62,
  eSQF_LOG_GPRS_DSDS_GRR_3G_Reselection_Measurements = 0x5C63,
  eSQF_LOG_GSM_DSDS_G2T_IRAT_Measurement_Request = 0x5C70,
  eSQF_LOG_GSM_DSDS_G2T_IRAT_Measurement_Response = 0x5C71,
  eSQF_LOG_GSM_DSDS_G2T_IRAT_Acquisition_Request = 0x5C72,
  eSQF_LOG_GSM_DSDS_G2T_IRAT_Acquisition_Response = 0x5C73,
  eSQF_LOG_GSM_DSDS_WMS_Receive_CB = 0x5D84,
  eSQF_LOG_Internal__GSM_DSDS_Frame_Number_Adjustment = 0x5E00,
  eSQF_LOG_Tool_Generated_GSM_Status = 0x5FF6,
  eSQF_LOG_Atlantis_NI_Start_Parameters_TSn3 = 0x6000,
  eSQF_LOG_Atlantis_NI_MLP_LIR_TSn4 = 0x6001,
  eSQF_LOG_Atlantis_NI_MLP_LIA_TSn5 = 0x6002,
  eSQF_LOG_Atlantis_NI_Per_Attempt_Statistics_TSn5 = 0x6003,
  eSQF_LOG_Atlantis_NI_Final_Statistics_TSn6 = 0x6004,
  eSQF_LOG_Atlantis_NI_Test_Completion_Notification_TSn7 = 0x6005,
  eSQF_LOG_Atlantis_WAP_Based_Start_Parameters_TSw3 = 0x6014,
  eSQF_LOG_Atlantis_WAP_Based_MLP_LIR_TSw4 = 0x6015,
  eSQF_LOG_Atlantis_WAP_Based_Trigger_Of_LBS_TSw5 = 0x6016,
  eSQF_LOG_Atlantis_WAP_Based_MLP_LIA_TSw6 = 0x6017,
  eSQF_LOG_Atlantis_WAP_Based_Trigger_Of_LBS_TSw7 = 0x6018,
  eSQF_LOG_Atlantis_WAP_Based_Per_Attempt_Statistics_TSw8 = 0x6019,
  eSQF_LOG_Atlantis_WAP_Based_Final_Statistics_TSw8 = 0x601A,
  eSQF_LOG_Atlantis_WAP_Based_Test_Completion_Notification_TSw9 = 0x601B,
  eSQF_LOG_UMTS_Call_Flow_Analysis = 0x7001,
  eSQF_LOG_AAGPS_Report_Clock = 0x7002,
  eSQF_LOG_AAGPS_Report_Position = 0x7003,
  eSQF_LOG_AAGPS_Report_Position_Status = 0x7004,
  eSQF_LOG_AAGPS_Report_Measurement = 0x7005,
  eSQF_LOG_AAGPS_Report_Measurement_Status = 0x7006,
  eSQF_LOG_AAGPS_Report_Asynchronous_Receiver_Event = 0x7007,
  eSQF_LOG_AAGPS_Report_RF_Status = 0x7008,
  eSQF_LOG_AAGPS_Report_Frequency_Calibration = 0x7009,
  eSQF_LOG_Internal__AAGPS_LSM_Server_Transmit = 0x700A,
  eSQF_LOG_Internal__AAGPS_LSM_Server_Receive = 0x700B,
  eSQF_LOG_AAGPS_Report_Measurement_Version_2 = 0x700C,
  eSQF_LOG_AAGPS_Report_Prescribed_Dwell = 0x700D,
  eSQF_LOG_AAGPS_Report_Time_Tag = 0x700E,
  eSQF_LOG_AAGPS_LSM_Report_GPS_Interface_Transmit = 0x7010,
  eSQF_LOG_AAGPS_LSM_Report_GPS_Interface_Receive = 0x7011,
  eSQF_LOG_UMTS_LSM_Report_Event = 0x7012,
  eSQF_LOG_Internal__UMTS_LSM_Get_Position_Request = 0x7013,
  eSQF_LOG_Internal__UMTS_LSM_Set_Parameters_Request = 0x7014,
  eSQF_LOG_Internal__UMTS_LSM_End_Session = 0x7015,
  eSQF_LOG_Internal__UMTS_LSM_Notify_Verify_Response = 0x7016,
  eSQF_LOG_UMTS_LSM_PDSM_Position_Report_Callback = 0x7017,
  eSQF_LOG_Internal__UMTS_LSM_PDSM_PD_Event_Callback = 0x7018,
  eSQF_LOG_Internal__UMTS_LSM_PDSM_PA_Event_Callback = 0x7019,
  eSQF_LOG_Internal__UMTS_LSM_PDSM_Notify_Verify_Request = 0x701A,
  eSQF_LOG_Internal__UMTS_LSM_PD_Command_Error = 0x701B,
  eSQF_LOG_Internal__UMTS_LSM_PDSM_PA_Command_Error = 0x701C,
  eSQF_LOG_Internal__AAGPS_Report_Uncertainty_Ellipse = 0x701D,
  eSQF_LOG_AAGPS_Report_Position_Version_2 = 0x701E,
  eSQF_LOG_AAGPS_Report_Measurement_Version_3 = 0x701F,
  eSQF_LOG_UMTS_NAS_GMM_State = 0x7130,
  eSQF_LOG_UMTS_NAS_MM_State = 0x7131,
  eSQF_LOG_UMTS_NAS_REG_State = 0x7132,
  eSQF_LOG_UMTS_NAS_CS_Connection_Management_Call_Setup = 0x7133,
  eSQF_LOG_UMTS_NAS_PS_Connection_Management = 0x7134,
  eSQF_LOG_UMTS_NAS_MM_Characteristics = 0x7135,
  eSQF_LOG_UMTS_NAS_QoS = 0x7136,
  eSQF_LOG_UMTS_NAS_Connection_Bearer_Capability = 0x7137,
  eSQF_LOG_UMTS_UE_Dynamic_ID = 0x7138,
  eSQF_LOG_UMTS_UE_Static_ID = 0x7139,
  eSQF_LOG_UMTS_NAS_Signaling_Messages = 0x713A,
  eSQF_LOG_WCDMA_Call_Flow_Analyzer_Unused = 0x713B,
  eSQF_LOG_Internal__UMTS_NAS_Error_Message = 0x713C,
  eSQF_LOG_UMTS_NAS_CS_Connection_Management_Call_Release_Info = 0x713D,
  eSQF_LOG_UMTS_NAS_CS_Connection_Management_Call_Change_Info = 0x713E,
  eSQF_LOG_UMTS_TX_Vocoder_Frame = 0x713F,
  eSQF_LOG_UMTS_RX_Vocoder_Frame = 0x7140,
  eSQF_LOG_UMTS_CS_Data_RX_Frames = 0x7141,
  eSQF_LOG_UMTS_CS_Data_TX_Frames = 0x7142,
  eSQF_LOG_UMTS_TX_Vocoder_Frame_Version_2 = 0x7143,
  eSQF_LOG_UMTS_RX_Vocoder_Frame_Version_2 = 0x7144,
  eSQF_LOG_UMTS_NAS_EPLMN_List = 0x7150,
  eSQF_LOG_UMTS_NAS_FPLMN_List_Update = 0x7151,
  eSQF_LOG_UMTS_NAS_FPLMN_List = 0x7152,
  eSQF_LOG_UMTS_NAS_HPLMN_Search_Timer_Start = 0x7153,
  eSQF_LOG_UMTS_NAS_HPLMN_Search_Timer_Expire = 0x7154,
  eSQF_LOG_UMTS_NAS_HPLMN_Search_Start = 0x7155,
  eSQF_LOG_UMTS_NAS_HPLMN_Search_End = 0x7156,
  eSQF_LOG_UMTS_NAS_White_List = 0x7157,
  eSQF_LOG_UMTS_NAS_Available_CSG_List = 0x7158,
  eSQF_LOG_UMTS_NAS_CB_Log_Packet = 0x7159,
  eSQF_LOG_High_Volume = 0x7200,
  eSQF_LOG_CC_MM = 0x7201,
  eSQF_LOG_MN_CM = 0x7202,
  eSQF_LOG_MN_CC = 0x7203,
  eSQF_LOG_MN_SS = 0x7204,
  eSQF_LOG_MN_SMS = 0x7205,
  eSQF_LOG_Timer = 0x7206,
  eSQF_LOG_CM_REG = 0x7207,
  eSQF_LOG_MN_REG = 0x7208,
  eSQF_LOG_MM_RR = 0x7209,
  eSQF_LOG_MM_REG = 0x720A,
  eSQF_LOG_GHDI_EXPORT = 0x720C,
  eSQF_LOG_GSDI = 0x720D,
  eSQF_LOG_RR_L2 = 0x7211,
  eSQF_LOG_RR_L1 = 0x7212,
  eSQF_LOG_L2_L1 = 0x7219,
  eSQF_LOG_L1_L1 = 0x721B,
  eSQF_LOG_RABM_SM = 0x721D,
  eSQF_LOG_SNDCP_SM = 0x721E,
  eSQF_LOG_CM_SM = 0x721F,
  eSQF_LOG_CNM_RABM = 0x7220,
  eSQF_LOG_RABM_RRC = 0x7221,
  eSQF_LOG_MN_UASMS = 0x7222,
  eSQF_LOG_RRC_MAC = 0x7230,
  eSQF_LOG_RRC_RLC = 0x7231,
  eSQF_LOG_RRC_RR = 0x7232,
  eSQF_LOG_L1_LOCAL = 0x725A,
  eSQF_LOG_L1_EXT = 0x725B,
  eSQF_LOG_L2DL = 0x725C,
  eSQF_LOG_L2UL = 0x725D,
  eSQF_LOG_RRC_INT = 0x725E,
  eSQF_LOG_RRC_L1 = 0x725F,
  eSQF_LOG_MM_RRC = 0x7264,
  eSQF_LOG_GMM_SMS = 0x7265,
  eSQF_LOG_GMM_SM = 0x7266,
  eSQF_LOG_GMM_RABM = 0x7267,
  eSQF_LOG_CM_RABM = 0x726D,
  eSQF_LOG_MAC_L1 = 0x72C8,
  eSQF_LOG_MAC_RR = 0x72C9,
  eSQF_LOG_RLC_L1 = 0x72CA,
  eSQF_LOG_MAC_RLC = 0x72CB,
  eSQF_LOG_MAC_MAC = 0x72CC,
  eSQF_LOG_RLC_LLC = 0x72CD,
  eSQF_LOG_LLC_GMM = 0x72CE,
  eSQF_LOG_LLC_SNDCP = 0x72CF,
  eSQF_LOG_SNDCP_PS = 0x72D0,
  eSQF_LOG_UMTS_Call_Info = 0x7404,
  eSQF_LOG_UMTS_DS_NAS_GMM_State = 0x7B30,
  eSQF_LOG_UMTS_DS_NAS_MM_State = 0x7B31,
  eSQF_LOG_UMTS_DS_NAS_REG_State = 0x7B32,
  eSQF_LOG_UMTS_DS_NAS_CS_Connection_Management_Call_Setup = 0x7B33,
  eSQF_LOG_UMTS_DS_NAS_PS_Connection_Management = 0x7B34,
  eSQF_LOG_UMTS_DS_NAS_MM_Characteristics = 0x7B35,
  eSQF_LOG_UMTS_DS_NAS_QoS = 0x7B36,
  eSQF_LOG_UMTS_DS_NAS_Connection_Bearer_Capability = 0x7B37,
  eSQF_LOG_UMTS_DS_UE_Dynamic_ID = 0x7B38,
  eSQF_LOG_UMTS_DS_UE_Static_ID = 0x7B39,
  eSQF_LOG_UMTS_DS_NAS_Signaling_Messages = 0x7B3A,
  eSQF_LOG_Internal__UMTS_DS_NAS_Error_Message = 0x7B3C,
  eSQF_LOG_UMTS_DS_NAS_CS_Connection_Management_Call_Release_Info = 0x7B3D,
  eSQF_LOG_UMTS_DS_NAS_CS_Connection_Management_Call_Change_Info = 0x7B3E,
  eSQF_LOG_UMTS_DS_NAS_EPLMN_List = 0x7B50,
  eSQF_LOG_UMTS_DS_NAS_FPLMN_List_Update = 0x7B51,
  eSQF_LOG_UMTS_DS_NAS_FPLMN_List = 0x7B52,
  eSQF_LOG_UMTS_DS_NAS_HPLMN_Search_Timer_Start = 0x7B53,
  eSQF_LOG_UMTS_DS_NAS_HPLMN_Search_Timer_Expire = 0x7B54,
  eSQF_LOG_UMTS_DS_NAS_HPLMN_Search_Start = 0x7B55,
  eSQF_LOG_UMTS_DS_NAS_HPLMN_Search_End = 0x7B56,
  eSQF_LOG_Cell_DL_Traffic_Stats = 0x9800,
  eSQF_LOG_Cell_DL_Failure_Stats = 0x9801,
  eSQF_LOG_Cell_Pucch_CQI_Pilot = 0x9802,
  eSQF_LOG_Cell_Pucch_Ack_Despread_pilot = 0x9803,
  eSQF_LOG_Cell_Pucch_CQI_LLR = 0x9804,
  eSQF_LOG_Cell_FTL = 0x9805,
  eSQF_LOG_Cell_Pusch_SNR = 0x9806,
  eSQF_LOG_Cell_RSSI = 0x9807,
  eSQF_LOG_Cell_TOC = 0x9808,
  eSQF_LOG_Cell_CQI_Rpt = 0x9809,
  eSQF_LOG_Cell_SRS_Rpt = 0x980A,
  eSQF_LOG_Cell_UI_Ack_Rpt = 0x980B,
  eSQF_LOG_Cell_Sr_Rpt = 0x980C,
  eSQF_LOG_Cell_Phich_TX_Rpt = 0x980D,
  eSQF_LOG_Cell_PSS_TX_Rpt = 0x980E,
  eSQF_LOG_Cell_SSS_TX_Rpt = 0x980F,
  eSQF_LOG_Cell_Pcfich_TX_Rpt = 0x9810,
  eSQF_LOG_Cell_Pdcch_TX_Rpt = 0x9811,
  eSQF_LOG_Cell_Pbch_TX_Rpt = 0x9812,
  eSQF_LOG_Cell_Pdsch_TX_Rpt = 0x9813,
  eSQF_LOG_Cell_Pusch_Constellation = 0x9814,
  eSQF_LOG_Cell_Time_Domain_Channel_Est = 0x9815,
  eSQF_LOG_Internal__ESG_Provider_Discovery_Descriptor = 0xA104,
  eSQF_LOG_Internal__ESG_Access_Descriptor = 0xA105,
  eSQF_LOG_Internal__ESG_Fragment_Management_Information = 0xA106,
  eSQF_LOG_Internal__ESG_Main_Fragment = 0xA107,
  eSQF_LOG_Internal__ESG_Content_Fragment = 0xA108,
  eSQF_LOG_Internal__ESG_Schedule_Event_Fragment = 0xA109,
  eSQF_LOG_Internal__ESG_Service_Fragment = 0xA10A,
  eSQF_LOG_Internal__ESG_Service_Bundle_Fragment = 0xA10B,
  eSQF_LOG_Internal__ESG_Acquisition_Fragment = 0xA10C,
  eSQF_LOG_Internal__ESG_Purchase_Fragment = 0xA10D,
  eSQF_LOG_Internal__ESG_Purchase_Channel_Fragment = 0xA10E,
  eSQF_LOG_Internal__ESG_Auxiliary_Data_Fragment = 0xA10F,
  eSQF_LOG_Internal__ESG_Private_Auxiliary_Data_Fragment = 0xA110,
  eSQF_LOG_DTV_DVBH_MPE_Frame_Statistics = 0xA120,
  eSQF_LOG_DVBH_MPE_Service_Info = 0xA121,
  eSQF_LOG_DVBH_Platform_List = 0xA122,
  eSQF_LOG_Internal__DTV_DVBH_Security_STKM_Information = 0xA150,
  eSQF_LOG_Internal__DTV_DVBH_Security_CID_Information = 0xA151,
  eSQF_LOG_Internal__DTV_DVBH_Security_STKM_Parse = 0xA152,
  eSQF_LOG_Internal__DTV_DVBH_Transport_Stream_Packet = 0xA209,
  eSQF_LOG_Internal__DVBH_UBM_L1_Control_PID_Information = 0xA301,
  eSQF_LOG_Internal__DVBH_UBM_L1_Raw_Data_PID_Information = 0xA302,
  eSQF_LOG_Internal__DVBH_UBM_L1_CRC_Data_PID_Information = 0xA303,
  eSQF_LOG_DVBH_UBM_L1_Transport_StreamTPS_Information = 0xA304,
  eSQF_LOG_DVBH_UBM_L1_MPEFEC_Information = 0xA305,
  eSQF_LOG_DVBH_UBM_L1_Status_Information = 0xA306,
  eSQF_LOG_Internal__DVBH_UBM_L1_CPCE_Path_Information = 0xA307,
  eSQF_LOG_Internal__DVBH_UBM_L1_CPCE_Utilized_Pathlist_Information = 0xA308,
  eSQF_LOG_Internal__DVBH_UBM_L1_CPCE_Candidate_Pathlist_Information = 0xA309,
  eSQF_LOG_DVBH_UBM_L1_Channel_Impulse_Response_Information = 0xA30A,
  eSQF_LOG_DVBH_UBM_L1_Acquisition_Information = 0xA30B,
  eSQF_LOG_Internal__DVBH_UBM_L1_Acquisition_Likelihood_Information = 0xA30C,
  eSQF_LOG_Internal__DVBH_UBM_L1_Jammer_FFT_Output_Information = 0xA30D,
  eSQF_LOG_Internal__DVBH_UBM_L1_Sample_Server_RAM_Information = 0xA30E,
  eSQF_LOG_DVBH_UBM_L1_Periodic_RDSP_Logging_Information = 0xA30F,
  eSQF_LOG_Internal__DVBH_UBM_L1_Decimated_CIR_Information = 0xA310,
  eSQF_LOG_DVBH_UBM_L1_One_Bit_Error_Test_Result = 0xA311,
  eSQF_LOG_DVBH_UBM_L1_Continuous_Jammer_Detection = 0xA312,
  eSQF_LOG_ISDBT_UBM_L1_During_Acqusition_Information = 0xA313,
  eSQF_LOG_ChOrd_Status_V1 = 0xA314,
  eSQF_LOG_ChOrd_Tx_Activity = 0xA315,
  eSQF_LOG_APU_Task_Profiling__System_Info = 0xB001,
  eSQF_LOG_APU_Task_Profiling__Task_Info = 0xB002,
  eSQF_LOG_Internal__LTE_Searcher_Initial_Acquisition = 0xB010,
  eSQF_LOG_Internal__LTE_PCFICH_Decode_Report = 0xB011,
  eSQF_LOG_Internal__LTE_PHICH_Decode_Report = 0xB012,
  eSQF_LOG_Internal__LTE_PDCCH_Decode_Report = 0xB013,
  eSQF_LOG_Internal__LTE_PBCH_Decode_Report = 0xB014,
  eSQF_LOG_Internal__LTE_PBCH_Channel_Estimation = 0xB015,
  eSQF_LOG_Internal__LTE_PBCH_Interference_Covariance = 0xB016,
  eSQF_LOG_Internal__LTE_PDSCH_Decode_Report = 0xB017,
  eSQF_LOG_Internal__LTE_RS_Time_Aligned_CIR = 0xB018,
  eSQF_LOG_Internal__LTE_Filtered_CIR = 0xB019,
  eSQF_LOG_Internal__LTE_CIR_Information = 0xB01A,
  eSQF_LOG_Internal__LTE_Per_RB_Pilot_Energy = 0xB01B,
  eSQF_LOG_Internal__LTE_Interference_Estimation = 0xB01C,
  eSQF_LOG_Internal__LTE_Per_RB_Whitening_Matrix = 0xB01D,
  eSQF_LOG_Internal__LTE_Traffic_Energy = 0xB01E,
  eSQF_LOG_Internal__LTE_Frequency_Tracking_Report = 0xB01F,
  eSQF_LOG_Internal__LTE_Time_Tracking_Report_Primary = 0xB020,
  eSQF_LOG_Internal__LTE_Time_Tracking_Report_PDP_Display = 0xB021,
  eSQF_LOG_Internal__LTE_Time_Tracking_Report_Floating_PDP = 0xB022,
  eSQF_LOG_Internal__LTE_Time_Tracking_Report_Quantity = 0xB023,
  eSQF_LOG_Internal__LTE_PUSCH_Transmit_Report = 0xB024,
  eSQF_LOG_Internal__LTE_PUCCH_Transmit_Report = 0xB025,
  eSQF_LOG_Internal__LTE_PRACH_Transmit_Report = 0xB026,
  eSQF_LOG_Internal__LTE_Analog_Converter_Card_Information = 0xB027,
  eSQF_LOG_Internal__LTE_PDSCH_Decoder_Statistics_Display = 0xB028,
  eSQF_LOG_Internal__LTE_Constellation_And_SINR_Display = 0xB029,
  eSQF_LOG_Internal__LTE_Channel_State_Feedback = 0xB030,
  eSQF_LOG_Internal__LTE_Neighbor_Search_Packet = 0xB031,
  eSQF_LOG_Internal__LTE_RSRP_Log_Packet = 0xB032,
  eSQF_LOG_Internal__LTE_RLM_Doppler_Log_Packet = 0xB033,
  eSQF_LOG_LTE_MAC_Configuration = 0xB060,
  eSQF_LOG_LTE_MAC_RACH_Trigger = 0xB061,
  eSQF_LOG_LTE_MAC_RACH_Attempt = 0xB062,
  eSQF_LOG_LTE_MAC_DL_Transport_Block = 0xB063,
  eSQF_LOG_LTE_MAC_UL_Transport_Block = 0xB064,
  eSQF_LOG_Internal__LTE_MAC_QoS = 0xB065,
  eSQF_LOG_LTE_MAC_Buffer_Status = 0xB066,
  eSQF_LOG_LTE_MAC_UL_Tx_Statistics = 0xB067,
  eSQF_LOG_LTE_MAC_EMBMS_Statistics = 0xB068,
  eSQF_LOG_LTE_RLC_DL_Configuration = 0xB081,
  eSQF_LOG_LTE_RLC_DL_AM_All_PDU = 0xB082,
  eSQF_LOG_LTE_RLC_DL_AM_Control_PDU = 0xB083,
  eSQF_LOG_LTE_RLC_DL_AM_Polling_PDU = 0xB084,
  eSQF_LOG_LTE_RLC_DL_AM_Signaling_PDU = 0xB085,
  eSQF_LOG_LTE_RLC_DL_UM_Data_PDU = 0xB086,
  eSQF_LOG_LTE_RLC_DL_Statistics = 0xB087,
  eSQF_LOG_Internal__LTE_RLC_DL_AM_State = 0xB088,
  eSQF_LOG_Internal__LTE_RLC_DL_UM_State = 0xB089,
  eSQF_LOG_LTE_RLC_EMBMS_Statistics = 0xB08A,
  eSQF_LOG_LTE_RLC_EMBMS_Configuration = 0xB08B,
  eSQF_LOG_LTE_RLC_UL_Configuration = 0xB091,
  eSQF_LOG_LTE_RLC_UL_AM_All_PDU = 0xB092,
  eSQF_LOG_LTE_RLC_UL_AM_Control_PDU = 0xB093,
  eSQF_LOG_LTE_RLC_UL_AM_Polling_PDU = 0xB094,
  eSQF_LOG_LTE_RLC_UL_AM_Signalling_PDU = 0xB095,
  eSQF_LOG_LTE_RLC_UL_UM_Data_PDU = 0xB096,
  eSQF_LOG_LTE_RLC_UL_Statistics = 0xB097,
  eSQF_LOG_Internal__LTE_RLC_UL_AM_State = 0xB098,
  eSQF_LOG_Internal__LTE_RLC_UL_UM_State = 0xB099,
  eSQF_LOG_LTE_PDCP_DL_Config = 0xB0A0,
  eSQF_LOG_LTE_PDCP_DL_Data_PDU = 0xB0A1,
  eSQF_LOG_LTE_PDCP_DL_Control_PDU = 0xB0A2,
  eSQF_LOG_PDCP_DL_Data_PDU_with_Ciphering = 0xB0A3,
  eSQF_LOG_LTE_PDCP_DL_Statistics = 0xB0A4,
  eSQF_LOG_LTE_PDCP_DL_SRB_Integrity_Data_PDU = 0xB0A5,
  eSQF_LOG_LTE_PDCP_UL_Config = 0xB0B0,
  eSQF_LOG_LTE_PDCP_UL_Data_PDU = 0xB0B1,
  eSQF_LOG_LTE_PDCP_UL_Control_PDU = 0xB0B2,
  eSQF_LOG_PDCP_UL_Data_PDU_with_Ciphering = 0xB0B3,
  eSQF_LOG_LTE_PDCP_UL_Statistics = 0xB0B4,
  eSQF_LOG_LTE_PDCP_UL_SRB_Integrity_Data_PDU = 0xB0B5,
  eSQF_LOG_LTE_PDCP_UL_WM_Delay_Statistics = 0xB0B6,
  eSQF_LOG_LTE_RRC_OTA_Message = 0xB0C0,
  eSQF_LOG_LTE_RRC_MIB_Message = 0xB0C1,
  eSQF_LOG_LTE_RRC_Serving_Cell_Info = 0xB0C2,
  eSQF_LOG_Internal__LTE_PLMN_Search_Request = 0xB0C3,
  eSQF_LOG_Internal__LTE_PLMN_Search_Response = 0xB0C4,
  eSQF_LOG_Internal__LTE_RRC_Partial_PLMN_Search_Response = 0xB0C5,
  eSQF_LOG_LTE_RRC_eMBMS_Bearer_List_Info = 0xB0C6,
  eSQF_LOG_LTE_RRC_eMBMS_OOS_Warning_Indication = 0xB0C7,
  eSQF_LOG_Internal__LTE_RRC_idle_meas_config_info = 0xB0C8,
  eSQF_LOG_LTE_RRC_Logged_Meas_Config = 0xB0C9,
  eSQF_LOG_LTE_RRC_Log_Meas_Info = 0xB0CA,
  eSQF_LOG_Internal__LTE_RRC_CGI_Info = 0xB0CC,
  eSQF_LOG_LTE_PDCP_SDU = 0xB0CF,
  eSQF_LOG_LTE_NAS_ESM_Security_Protected_OTA_Incoming_Message = 0xB0E0,
  eSQF_LOG_LTE_NAS_ESM_Security_Protected_OTA_Outgoing_Message = 0xB0E1,
  eSQF_LOG_LTE_NAS_ESM_Plain_OTA_Incoming_Message = 0xB0E2,
  eSQF_LOG_LTE_NAS_ESM_Plain_OTA_Outgoing_Message = 0xB0E3,
  eSQF_LOG_LTE_NAS_ESM_Bearer_Context_State = 0xB0E4,
  eSQF_LOG_LTE_NAS_ESM_Bearer_Context_Info = 0xB0E5,
  eSQF_LOG_LTE_NAS_ESM_Procedure_State = 0xB0E6,
  eSQF_LOG_LTE_NAS_EMM_Secuirty_Protected_OTA_Incoming_Message = 0xB0EA,
  eSQF_LOG_LTE_NAS_EMM_Secuirty_Protected_OTA_Outgoing_Message = 0xB0EB,
  eSQF_LOG_LTE_NAS_EMM_Plain_OTA_Incoming_Message = 0xB0EC,
  eSQF_LOG_LTE_NAS_EMM_Plain_OTA_Outgoing_Message = 0xB0ED,
  eSQF_LOG_LTE_NAS_EMM_State = 0xB0EE,
  eSQF_LOG_LTE_NAS_EMM_USIM_Card_Mode = 0xB0EF,
  eSQF_LOG_LTE_NAS_EMM_Current_Security_Context = 0xB0F2,
  eSQF_LOG_Internal__LTE_NAS_EMM_Ciphering_And_Integrity_Keys_For_Packet_Switched_Domain = 0xB0F3,
  eSQF_LOG_Internal__LTE_NAS_EMM_Native_Security_ContexT = 0xB0F4,
  eSQF_LOG_LTE_NAS_EMM_USIM_Service_Table = 0xB0F5,
  eSQF_LOG_Internal__LTE_LL1_FW_Message = 0xB110,
  eSQF_LOG_LTE_LL1_RX_AGC = 0xB111,
  eSQF_LOG_Internal__LTE_LL1_RX_AGC = 0xB112,
  eSQF_LOG_LTE_LL1_PSS_Results = 0xB113,
  eSQF_LOG_LTE_LL1_Serving_Cell_Frame_Timing = 0xB114,
  eSQF_LOG_LTE_LL1_SSS_Results = 0xB115,
  eSQF_LOG_LTE_LL1_Serving_Cell_Measurement_Results = 0xB116,
  eSQF_LOG_Internal__LTE_LL1_Debug_0xB117 = 0xB117,
  eSQF_LOG_LTE_LL1_Neighbor_Cell_Measurements_and_Tracking_Results = 0xB119,
  eSQF_LOG_LTE_LL1_PRS_Forward = 0xB11A,
  eSQF_LOG_LTE_LL1_Serving_Cell_FTL_Results = 0xB11B,
  eSQF_LOG_LTE_LL1_FAP_UL_Timing = 0xB11C,
  eSQF_LOG_LTE_LL1_Serving_Cell_TTL_Results = 0xB11D,
  eSQF_LOG_Internal__LTE_LL1_Debug_0xB11E = 0xB11E,
  eSQF_LOG_Internal__LTE_LL1_Debug_0xB11F = 0xB11F,
  eSQF_LOG_LTE_LL1_RS_Signal_Correlation = 0xB120,
  eSQF_LOG_LTE_LL1_Serving_Cell_COM_Loop = 0xB121,
  eSQF_LOG_LTE_LL1_Serving_Cell_CER = 0xB122,
  eSQF_LOG_LTE_LL1_Neighbor_Cell_CER = 0xB123,
  eSQF_LOG_LTE_LL1_PDSCH_HARQ_Offload = 0xB124,
  eSQF_LOG_LTE_LL1_eMBMS_Whitened_Matrices = 0xB125,
  eSQF_LOG_LTE_LL1_PDSCH_Demapper_Configuration = 0xB126,
  eSQF_LOG_LTE_LL1_eMBMS_CER = 0xB127,
  eSQF_LOG_LTE_LL1_UERS_Rx_Tone_Power_Packet = 0xB128,
  eSQF_LOG_Internal__LTE_LL1_Radio_Link_Monitoring = 0xB129,
  eSQF_LOG_LTE_LL1_PCFICH_Decoding_Results = 0xB12A,
  eSQF_LOG_Internal__LTE_LL1_VPE_Scheduler = 0xB12B,
  eSQF_LOG_LTE_LL1_PHICH_Decoding_Results = 0xB12C,
  eSQF_LOG_LTE_LL1_NLIC_Report = 0xB12D,
  eSQF_LOG_LTE_LL1_PBCH_Decoding_Results = 0xB12E,
  eSQF_LOG_LTE_LL1_Demback_PDSCH_Debug = 0xB12F,
  eSQF_LOG_LTE_LL1_PDCCH_Decoding_Results = 0xB130,
  eSQF_LOG_LTE_LL1_Serving_Cell_PETL_Loop = 0xB131,
  eSQF_LOG_LTE_LL1_PDSCH_Decoding_Results = 0xB132,
  eSQF_LOG_Internal__LTE_LL1_Unicast_PDSCH_Decoding_Results = 0xB133,
  eSQF_LOG_Internal__LTE_LL1_Serving_Cell_RS = 0xB134,
  eSQF_LOG_Internal__LTE_LL1_Serving_Cell_Window_Gain = 0xB135,
  eSQF_LOG_LTE_LL1_CSF_SE_TM9_Results = 0xB138,
  eSQF_LOG_LTE_LL1_PUSCH_Tx_Report = 0xB139,
  eSQF_LOG_LTE_LL1_Multi_RAT_DL_Report = 0xB13A,
  eSQF_LOG_LTE_LL1_Multi_RAT_UL_Report = 0xB13B,
  eSQF_LOG_LTE_LL1_PUCCH_Tx_Report = 0xB13C,
  eSQF_LOG_Internal__LTE_LL1_PUCCH_Tx_Report = 0xB13D,
  eSQF_LOG_Internal__LTE_LL1_PUCCH_Power_Control_Report = 0xB13F,
  eSQF_LOG_LTE_LL1_SRS_Tx_Report = 0xB140,
  eSQF_LOG_LTE_LL1_CoExistence_Manager_Configuration = 0xB141,
  eSQF_LOG_LTE_LL1_CoExistence_Status = 0xB142,
  eSQF_LOG_Internal__LTE_LL1_SRS_Power_Control_Report = 0xB143,
  eSQF_LOG_LTE_LL1_RACH_Tx_Report = 0xB144,
  eSQF_LOG_Internal__LTE_LL1_RACH_Tx_Report = 0xB145,
  eSQF_LOG_LTE_LL1_AGC_Tx_Report = 0xB146,
  eSQF_LOG_Internal__LTE_LL1_Tx_AGC = 0xB147,
  eSQF_LOG_LTE_LL1_CSF_CSIRS_Chest_TM9 = 0xB148,
  eSQF_LOG_LTE_LL1_CSF_Spectral_Efficiency_Log_for_TxMode_4_5_6_Rank_1 = 0xB149,
  eSQF_LOG_LTE_LL1_CSF_Spectral_Efficiency_Log_for_TxMode_4_Rank_2 = 0xB14A,
  eSQF_LOG_LTE_LL1_CSF_Spectral_Efficiency_Log_for_TxMode_1_2_7 = 0xB14B,
  eSQF_LOG_LTE_LL1_Whitened_matrices_log = 0xB14C,
  eSQF_LOG_LTE_LL1_PUCCH_CSF_Log = 0xB14D,
  eSQF_LOG_LTE_LL1_PUSCH_CSF_Log = 0xB14E,
  eSQF_LOG_LTE_LL1_UERS_SNR = 0xB14F,
  eSQF_LOG_LTE_ML1_Downlink_Common_Configuration = 0xB160,
  eSQF_LOG_LTE_ML1_Downlink_Dedicated_Configuration = 0xB161,
  eSQF_LOG_LTE_ML1_Uplink_Common_Configuration = 0xB162,
  eSQF_LOG_LTE_ML1_Uplink_Dedicated_Configuration = 0xB163,
  eSQF_LOG_LTE_ML1_Grant_Manager_Common_Configuration = 0xB164,
  eSQF_LOG_LTE_ML1_Grant_Manager_Dedicated_Config = 0xB165,
  eSQF_LOG_LTE_ML1_PRACH_Configuration = 0xB166,
  eSQF_LOG_LTE_ML1_Random_Access_Request_MSG1_Report = 0xB167,
  eSQF_LOG_LTE_ML1_Random_Access_Response_MSG2_Report = 0xB168,
  eSQF_LOG_LTE_ML1_UE_Identification_Message_MSG3_Report = 0xB169,
  eSQF_LOG_LTE_ML1_Contention_Resolution_Message_MSG4_Report = 0xB16A,
  eSQF_LOG_LTE_ML1_PDCCHPHICH_Indication_Report = 0xB16B,
  eSQF_LOG_LTE_ML1_DCI_Information_Report = 0xB16C,
  eSQF_LOG_LTE_ML1_GM_TX_Report = 0xB16D,
  eSQF_LOG_LTE_ML1_PUSCH_Power_Control = 0xB16E,
  eSQF_LOG_LTE_ML1_PUCCH_Power_Control = 0xB16F,
  eSQF_LOG_LTE_ML1_SRS_TX_Report = 0xB170,
  eSQF_LOG_LTE_ML1_SRS_Power_Control_Report = 0xB171,
  eSQF_LOG_LTE_ML1_PKT_Build_Indication = 0xB172,
  eSQF_LOG_LTE_ML1_PDSCH_Stat_Indication = 0xB173,
  eSQF_LOG_Internal__LTE_ML1_List_Frequency_Scan_Results = 0xB174,
  eSQF_LOG_Internal__LTE_ML1_Full_Frequency_Scan_Results = 0xB175,
  eSQF_LOG_LTE_ML1_Initial_Acquisition_Results = 0xB176,
  eSQF_LOG_LTE_ML1_Connected_Mode_Measurement_Configuration = 0xB177,
  eSQF_LOG_Internal__LTE_ML1_Connected_Mode_Measurement_Report = 0xB178,
  eSQF_LOG_LTE_ML1_Connected_Mode_LTE_IntraFrequency_Measurement_Results = 0xB179,
  eSQF_LOG_LTE_ML1_Cell_Select_Reselect_S_check_procedure = 0xB17A,
  eSQF_LOG_LTE_ML1_Idle_DRX_Request = 0xB17C,
  eSQF_LOG_LTE_ML1_Idle_Measurement_Request = 0xB17D,
  eSQF_LOG_LTE_ML1_UE_Mobility_State_change = 0xB17E,
  eSQF_LOG_LTE_ML1_Serving_Cell_Measurements_And_Evaluation = 0xB17F,
  eSQF_LOG_Internal__LTE_ML1_Neighbor_Measurements_Packet = 0xB180,
  eSQF_LOG_LTE_ML1_Cell_Reselection_Packet = 0xB181,
  eSQF_LOG_LTE_ML1_Multisim_Packet = 0xB182,
  eSQF_LOG_LTE_ML1_PBCH_Decode_Packet = 0xB183,
  eSQF_LOG_LTE_ML1_CA_Metrics = 0xB184,
  eSQF_LOG_LTE_ML1_CDMA_Neighbor_Measurements_Log_Packet = 0xB185,
  eSQF_LOG_LTE_ML1_Reselection_Candidates_Log_Packet = 0xB186,
  eSQF_LOG_LTE_ML1_IRAT_Measurement_Request = 0xB187,
  eSQF_LOG_LTE_ML1_IRAT_MDB = 0xB188,
  eSQF_LOG_LTE_ML1_CDMA_System_Time = 0xB189,
  eSQF_LOG_LTE_ML1_Radio_Link_Monitoring = 0xB18A,
  eSQF_LOG_LTE_ML1_Sleep = 0xB18B,
  eSQF_LOG_LTE_ML1_Sleep_Statistics = 0xB18C,
  eSQF_LOG_LTE_ML1_Band_Scan_Results = 0xB18D,
  eSQF_LOG_LTE_ML1_System_Scan_Results = 0xB18E,
  eSQF_LOG_LTE_ML1_AdvRx_IC_Cell_List = 0xB18F,
  eSQF_LOG_LTE_ML1_AdvRx_IC_Request = 0xB190,
  eSQF_LOG_LTE_ML1_Idle_Neighbor_Cell_Measurement_Req_Resp = 0xB192,
  eSQF_LOG_LTE_ML1_Serving_Cell_Measurement_Result = 0xB193,
  eSQF_LOG_LTE_ML1_Search_Request_Response = 0xB194,
  eSQF_LOG_LTE_ML1_Connected_Mode_Neighbor_Meas_Req_Resp = 0xB195,
  eSQF_LOG_Internal__LTE_ML1_Cell_Measurement_Results = 0xB196,
  eSQF_LOG_Internal__LTE_ML1_Serving_Cell_Information = 0xB197,
  eSQF_LOG_LTE_ML1_CDRX_Events_Info = 0xB198,
  eSQF_LOG_LTE_ML1_Macro_Sleep = 0xB19A,
  eSQF_LOG_LTE_ML1_Connected_mode_WCDMA_measurement_results = 0xB19B,
  eSQF_LOG_LTE_ML1_Connected_mode_measurement_evaluations = 0xB19C,
  eSQF_LOG_LTE_ML1_GSM_Measurements = 0xB19D,
  eSQF_LOG_LTE_ML1_Inter_Frequency_Log_Packet = 0xB19E,
  eSQF_LOG_LTE_ML1_BPLMN_Start_Request = 0xB1A0,
  eSQF_LOG_LTE_ML1_BPLMN_Cell_Request = 0xB1A1,
  eSQF_LOG_LTE_ML1_BPLMN_Cell_Confirm = 0xB1A2,
  eSQF_LOG_LTE_ML1_BPLMN_Time_Available_Indication = 0xB1A3,
  eSQF_LOG_LTE_ML1_BPLMN_Complete_Indication = 0xB1A4,
  eSQF_LOG_LTE_ML1_BPLMN_Stop_Request = 0xB1A5,
  eSQF_LOG_LTE_ML1_BPLMN_Stop_Confirm = 0xB1A6,
  eSQF_LOG_LTE_ML1_Scheduler_Log = 0xB1A7,
  eSQF_LOG_LTE_ML1_TDD_Configuration = 0xB1B0,
  eSQF_LOG_LTE_ML1_TDD_ACK_NAK_Report = 0xB1B1,
  eSQF_LOG_LTE_ML1_DC_Offset = 0xB1B2,
  eSQF_LOG_Internal__LTE_ML1_PMCH_Decode_Params = 0xB1B5,
  eSQF_LOG_LTE_ML1_Frame_Timing = 0xB1B7,
  eSQF_LOG_LTE_ML1_Coex_Event_Indication = 0xB1B8,
  eSQF_LOG_LTE_ML1_Coex_State_Info = 0xB1B9,
  eSQF_LOG_LTE_ML1_MSI_Config = 0xB1BA,
  eSQF_LOG_LTE_ML1_EMBMS_Config = 0xB1BB,
  eSQF_LOG_LTE_ML1_PMCH_Decode_Results = 0xB1BC,
  eSQF_LOG_Internal__LTE_ML1_All_DL_Channels_Decode_Results = 0xB1BD,
  eSQF_LOG_LTE_ML1_PMCH_Results_Statistics = 0xB1BE,
  eSQF_LOG_LTE_ML1_Coex_Indication = 0xB1BF,
  eSQF_LOG_LTE_ML1_TDS_Measurement_Results = 0xB1C1,
  eSQF_LOG_LTE_ML1_TDS_Conn_Mode_ACQ_Request = 0xB1C2,
  eSQF_LOG_LTE_ML1_TDS_Conn_Mode_Meas_Request = 0xB1C3,
  eSQF_LOG_LTE_ML1_MCVS_VPE_Frequency = 0xB1C4,
  eSQF_LOG_LTE_ML1_GM_CSF_Tx_Report = 0xB1C6,
  eSQF_LOG_Internal__LTE_ML1_Coex_DSDA_Frequency_Log = 0xB1C7,
  eSQF_LOG_Internal__LTE_ML1_Coex_DSDA_Conflict_Check_Log = 0xB1C8,
  eSQF_LOG_LTE_ML1_DL_BLER_Stats = 0xB1C9,
  eSQF_LOG_Internal__LTE_ML1_COEX_DSDA_PRIO_Switch_Request = 0xB1CB,
  eSQF_LOG_Internal__LTE_ML1_COEX_DSDA_PRIO_Switch_Request_Send_FW = 0xB1CC,
  eSQF_LOG_TDSCDMA_SYNCDL_MID_DETECT_LOG_PACKET = 0xD000,
  eSQF_LOG_TDSCDMA_MEASUREMENT_RSCP_LOG_PACKET = 0xD001,
  eSQF_LOG_TDSCDMA_MEASUREMENT_ISCP_LOG_PACKET = 0xD002,
  eSQF_LOG_TDSCDMA_GAP_DETECT_LOG_PACKET = 0xD003,
  eSQF_LOG_TDSCDMA_Cell_Reselection_Configuration = 0xD004,
  eSQF_LOG_TDSCDMA_MEASUREMENT_INTERNAL_CFG_LOG_PACKET = 0xD005,
  eSQF_LOG_TDSCDMA_MEASUREMENT_QUALITY_CFG_LOG_PACKET = 0xD006,
  eSQF_LOG_TDSCDMA_MEASUREMENT_INTERNAL_RESULT_LOG_PACKET = 0xD007,
  eSQF_LOG_TDSCDMA_MEASUREMENT_SCHEDULE_LOG_PACKET = 0xD008,
  eSQF_LOG_TDSCDMA_CELL_RESEL_RANK_LOG_PACKET = 0xD009,
  eSQF_LOG_TDSCDMA_Measurement_Accumulated_RSCP = 0xD00A,
  eSQF_LOG_TDSCDMA_MEASUREMENT_ACCUMULATED_ISCP_LOG_PACKET = 0xD00B,
  eSQF_LOG_TDSCDMA_MEASUREMENT_QUALITY_RESULT_LOG_PACKET = 0xD00C,
  eSQF_LOG_TDSCDMA_Measurement_Configuration = 0xD00D,
  eSQF_LOG_TDSCDMA_Measurement_GSM_Result = 0xD00E,
  eSQF_LOG_TDSCDMA_Measurement_GSM_Timing_and_Intermediate_Result = 0xD00F,
  eSQF_LOG_TDSCDMA_L1_DL_TRCH_CFG_LOG_PACKET = 0xD010,
  eSQF_LOG_TDSCDMA_L1_DL_TFC_CFG_LOG_PACKET = 0xD011,
  eSQF_LOG_TDSCDMA_L1_DL_COMMON_PHYCHAN_CFG_LOG_PACKET = 0xD012,
  eSQF_LOG_TDSCDMA_L1_DL_DPCH_CFG_LOG_PACKET = 0xD013,
  eSQF_LOG_TDSCDMA_L1_DL_FMO_CFG_LOG_PACKET = 0xD014,
  eSQF_LOG_TDSCDMA_L1_Dl_Fpach_Decode_Result = 0xD015,
  eSQF_LOG_TDSCDMA_L1_Dl_Bler = 0xD016,
  eSQF_LOG_TDSCDMA_L1_DL_FW_Midamble_Config_Command = 0xD017,
  eSQF_LOG_TDSCDMA_L1_DL_FW_PICH_Config_Command = 0xD018,
  eSQF_LOG_TDSCDMA_L1_DL_FW_PCCPCH_Config_Command = 0xD019,
  eSQF_LOG_TDSCDMA_L1_DL_FW_SCCPCH_Config_Command = 0xD01A,
  eSQF_LOG_TDSCDMA_L1_DL_FW_DPCH_Config_Command = 0xD01B,
  eSQF_LOG_TDSCDMA_L1_DL_FW_Rx_Time_Sync_Config_Command = 0xD01C,
  eSQF_LOG_TDSCDMA_L1_DL_FW_CCTRCH_Config_Command = 0xD01D,
  eSQF_LOG_TDSCDMA_L1_DL_FW_PICH_Decode_Result = 0xD01E,
  eSQF_LOG_Internal__TDSCDMA_L1_DL_FW_DPCH_PCCPCH_SCCPCH_Decode_Result = 0xD01F,
  eSQF_LOG_TDSCDMA_L1_UL_DCH_CFG_LOG_PACKET = 0xD020,
  eSQF_LOG_TDSCDMA_L1_UL_DCH_GAIN_FACTOR_CFG_LOG_PACKET = 0xD021,
  eSQF_LOG_TDSCDMA_L1_UL_TFC_CFG_LOG_PACKET = 0xD022,
  eSQF_LOG_TDSCDMA_L1_UL_DPCH_CFG_LOG_PACKET = 0xD023,
  eSQF_LOG_TDSCDMA_L1_UL_RACH_CFG_LOG_PACKET = 0xD024,
  eSQF_LOG_TDSCDMA_L1_UL_PRACH_FPACH_CFG_LOG_PACKET = 0xD025,
  eSQF_LOG_TDSCDMA_L1_UL_Random_Access_CFG_LOG_Packet = 0xD026,
  eSQF_LOG_TDSCDMA_L1_Ul_Fw_Uppch_Fpach_Cfg_Cmd = 0xD027,
  eSQF_LOG_TDSCDMA_L1_Ul_Fw_Prach_Cfg_Cmd = 0xD028,
  eSQF_LOG_TDSCDMA_L1_Ul_Fw_Dpch_Cfg_Cmd = 0xD029,
  eSQF_LOG_TDSCDMA_L1_Tf_Pool_Param = 0xD02D,
  eSQF_LOG_TDSCDMA_L1_Tfc_Poll_Param = 0xD02F,
  eSQF_LOG_TDSCDMA_L1_HSDPA_CFG_LOG_PACKET = 0xD030,
  eSQF_LOG_TDSCDMA_L1_HSDPA_DECODE_STATUS_LOG_PACKET = 0xD031,
  eSQF_LOG_TDSCDMA_L1_HSDPA_HSSCCH_Statistics = 0xD032,
  eSQF_LOG_TDSCDMA_L1_HSDPA_HARQ_Statistics = 0xD033,
  eSQF_LOG_TDSCDMA_L1_HSDPA_MAC_HS_HDR_LOG_PACKET = 0xD034,
  eSQF_LOG_TDSCDMA_L1_UPA_EAGCH_CHAN_INFO_LOG_PACKET = 0xD040,
  eSQF_LOG_TDSCDMA_L1_UPA_SCHED_EHICH_CHAN_INFO_LOG_PACKET = 0xD041,
  eSQF_LOG_TDSCDMA_L1_UPA_NON_SCHED_EHICH_CHAN_INFO_LOG_PACKET = 0xD042,
  eSQF_LOG_TDSCDMA_L1_UPA_NON_SCHED_GRANT_INFO_LOG_PACKET = 0xD043,
  eSQF_LOG_TDSCDMA_L1_UPA_ETFC_RESTRICT_INFO_LOG_PACKET = 0xD044,
  eSQF_LOG_TDSCDMA_L1_UPA_HARQ_DB_INFO_LOG_PACKET = 0xD045,
  eSQF_LOG_TDSCDMA_L1_UPA_EDL_DEC_AND_SG_INFO_LOG_PACKET = 0xD046,
  eSQF_LOG_TDSCDMA_L1_UPA_PWR_CTL_INFO_LOG_PACKET = 0xD047,
  eSQF_LOG_TDSCDMA_L1_UPA_L1_STATS_INFO_LOG_PACKET = 0xD048,
  eSQF_LOG_TDSCDMA_L1_DRX_CYCLE_LOG_PACKET = 0xD050,
  eSQF_LOG_Internal__TDSCDMA_TS0_Cell_Update = 0xD052,
  eSQF_LOG_Internal__TDSCDMA_TS0_Cell_Table = 0xD053,
  eSQF_LOG_Internal__TDSCDMA_Non_TS0_Cell_Update = 0xD054,
  eSQF_LOG_TDSCDMA_NON_TS0_CELL_TABLE_LOG_PACKET = 0xD055,
  eSQF_LOG_Internal__TDSCDMA_Accumulate_TS0_Cell_Table = 0xD056,
  eSQF_LOG_Internal__TDSCDMA_Accumulate_Non_TS0_Cell_Table = 0xD057,
  eSQF_LOG_Internal__TDSCDMA_TS0_Cell_Update_Shorten = 0xD058,
  eSQF_LOG_TDSCDMA_SIB19_Measurement_Configuration_Log_Packet = 0xD059,
  eSQF_LOG_TDSCDMA_Measurement_Eutra_Cells_Log_Packet = 0xD05A,
  eSQF_LOG_TDSCDMA_Absolute_Priority_Cell_Rank_Log_Packet = 0xD05B,
  eSQF_LOG_Internal__TDSCDMA_IRAT_RSCP_RSP_Log_Packet = 0xD05F,
  eSQF_LOG_TDSCDMA_OLPC_CONFIG_LOG_PACKET = 0xD060,
  eSQF_LOG_TDSCDMA_OLPC_UPDATE_LOG_PACKET = 0xD061,
  eSQF_LOG_TDSCDMA_L1_DL_Sync_Detect = 0xD062,
  eSQF_LOG_Internal__TDSCDMA_L1_Int_PCCPCH = 0xD063,
  eSQF_LOG_TDSCDMA_L1_L1M_Profiling_Result_Log_Packet = 0xD064,
  eSQF_LOG_TDSCDMA_InterRAT_EUTRA_Measurement = 0xD066,
  eSQF_LOG_TDSCDMA_InterRAT_EUTRA_Idle_Internal = 0xD067,
  eSQF_LOG_TDSCDMA_InterRAT_EUTRA_DMO_Config = 0xD068,
  eSQF_LOG_TDSCDMA_T2L_TFW_GAP_Config = 0xD069,
  eSQF_LOG_TDSCDMA_T2L_Time_Measurement_Search_Request = 0xD06A,
  eSQF_LOG_TDSCDMA_T2L_Eutra_Measurement_Result = 0xD06B,
  eSQF_LOG_TDSCDMA_T2L_Eutra_Measurement_Accumulate_Result = 0xD06C,
  eSQF_LOG_TDSCDMA_RXD_Table = 0xD06D,
  eSQF_LOG_TDSCDMA_L1_DSDS_QTA_Report = 0xD06E,
  eSQF_LOG_TDSCDMA_L1_UL_FW_UPPCH_TX_Power_Timing_Config = 0xD06F,
  eSQF_LOG_TDSCDMA_L1_UL_FW_DPCH_TX_Power_Timing_Config = 0xD070,
  eSQF_LOG_TDSCDMA_L1_UL_ERUCCH_SI_Data = 0xD071,
  eSQF_LOG_TDSCDMA_L1_UL_FW_ERUCCH_Config_CMD = 0xD072,
  eSQF_LOG_TDSCDMA_UL_RLC_STATE_LOG_PACKET = 0xD080,
  eSQF_LOG_TDSCDMA_UL_RLC_TM_LOG_PACKET = 0xD081,
  eSQF_LOG_TDSCDMA_UL_RLC_UM_LOG_PACKET = 0xD082,
  eSQF_LOG_TDSCDMA_DL_RLC_STATE_LOG_PACKET = 0xD083,
  eSQF_LOG_TDSCDMA_DL_RLC_TM_LOG_PACKET = 0xD084,
  eSQF_LOG_TDSCDMA_DL_RLC_UM_LOG_PACKET = 0xD085,
  eSQF_LOG_TDSCDMA_DL_RLC_AM_LOG_PACKET = 0xD086,
  eSQF_LOG_TDSCDMA_UL_RLC_AM_LOG_PACKET = 0xD087,
  eSQF_LOG_TDSCDMA_DL_RLC_AM_USR_PLANE_PDU_LOG_PACKET = 0xD088,
  eSQF_LOG_TDSCDMA_DL_RLC_AM_SIG_PLANE_PDU_LOG_PACKET = 0xD089,
  eSQF_LOG_TDSCDMA_UL_RLC_AM_STAT_LOG_PACKET = 0xD08A,
  eSQF_LOG_TDSCDMA_UL_RLC_AM_USR_PLANE_PDU_LOG_PACKET = 0xD08B,
  eSQF_LOG_TDSCDMA_UL_RLC_AM_SIG_PLANE_PDU_LOG_PACKET = 0xD08C,
  eSQF_LOG_TDSCDMA_UL_RLC_AM_NAK_PDU_LOG_PACKET = 0xD08D,
  eSQF_LOG_TDSCDMA_DL_RLC_AM_NAK_PDU_LOG_PACKET = 0xD08E,
  eSQF_LOG_TDSCDMA_DL_RLC_AM_STAT_LOG_PACKET = 0xD08F,
  eSQF_LOG_TDSCDMA_UL_RLC_CIPH_CFG_LOG_PACKET = 0xD090,
  eSQF_LOG_TDSCDMA_DL_RLC_CIPH_CFG_LOG_PACKET = 0xD091,
  eSQF_LOG_TDSCDMA_DL_RLC_PDU_CIPHER_LOG_PACKET = 0xD092,
  eSQF_LOG_TDSCDMA_UL_RLC_PDU_CIPHER_LOG_PACKET = 0xD093,
  eSQF_LOG_TDSCDMA_DL_FLEXIBLE_RLC_AM_PDU_LOG_PACKET = 0xD094,
  eSQF_LOG_TDSCDMA_UL_RLC_UM_USR_PLANE_PDU_LOG_PACKET = 0xD095,
  eSQF_LOG_TDSCDMA_DL_RLC_UM_USR_PLANE_PDU_LOG_PACKET = 0xD096,
  eSQF_LOG_TDSCDMA_MAC_UL_TVM_REPORT_LOG_PACKET = 0xD0B0,
  eSQF_LOG_TDSCDMA_MAC_UL_TVM_CFG_LOG_PACKET = 0xD0B1,
  eSQF_LOG_TDSCDMA_UL_MAC_CFG_LOG_PACKET = 0xD0B2,
  eSQF_LOG_TDSCDMA_DL_MAC_CFG_LOG_PACKET = 0xD0B3,
  eSQF_LOG_TDSCDMA_MAC_RACH_CFG_LOG_PACKET = 0xD0B4,
  eSQF_LOG_TDSCDMA_MAC_UL_TFCS_CFG_LOG_PACKET = 0xD0B5,
  eSQF_LOG_TDSCDMA_MAC_HS_CONFIG_LOG_PACKET = 0xD0B6,
  eSQF_LOG_TDSCDMA_MAC_HS_STATUS_REPORT_LOG_PACKET = 0xD0B7,
  eSQF_LOG_TDSCDMA_MAC_HS_RESET_LOG_PACKET = 0xD0B8,
  eSQF_LOG_TDSCDMA_MAC_HS_REASSEMBLY_LOG_PACKET = 0xD0B9,
  eSQF_LOG_TDSCDMA_MAC_HS_UL_CONFIG_LOG_PACKET = 0xD0BA,
  eSQF_LOG_TDSCDMA_MAC_HS_UL_HEADER_STATUS_LOG_PACKET = 0xD0BB,
  eSQF_LOG_TDSCDMA_MAC_HS_UL_ETFCI_STATUS_LOG_PACKET = 0xD0BC,
  eSQF_LOG_TDSCDMA_RRC_MODES_AND_STATES_LOG_PACKET = 0xD0E0,
  eSQF_LOG_TDSCDMA_RRC_PROTOCOL_ERRORS_LOG_PACKET = 0xD0E1,
  eSQF_LOG_TDSCDMA_RRC_CELL_ID_LOG_PACKET = 0xD0E2,
  eSQF_LOG_TDSCDMA_RRC_SIGNALLING_MESSAGE_LOG_PACKET = 0xD0E3,
  eSQF_LOG_TDSCDMA_RRC_RB_RATE_INFO_LOG_PACKET = 0xD0E4,
  eSQF_LOG_TDSCDMA_RRC_ACQ_INFO_LOG_PACKET = 0xD0E5,
  eSQF_LOG_TDSCDMA_RRC_DSDS_LTA = 0xD0E6,
  eSQF_LOG_TDSCDMA_TFW_Tracking_Mode = 0xD100,
  eSQF_LOG_TDSCDMA_AGC_Power_Scan = 0xD101,
  eSQF_LOG_TDSCDMA_AGC_Gap_Detection = 0xD102,
  eSQF_LOG_TDSCDMA_AGC_Step_1_2 = 0xD103,
  eSQF_LOG_TDSCDMA_TFW_REQCQ_Result = 0xD104,
  eSQF_LOG_TDSCDMA_TFW_DL_Sync_Code_Result = 0xD105,
  eSQF_LOG_TDSCDMA_TFW_Midamble_Detect_Result = 0xD106,
  eSQF_LOG_TDSCDMA_TFW_TSRSP_Result = 0xD107,
  eSQF_LOG_TDSCDMA_TFW_Tracking_Loop_Result = 0xD108,
  eSQF_LOG_TDSCDMA_TFW_Step3_Results = 0xD109,
  eSQF_LOG_TDSCDMA_TFW_Serving_Cell_Frame_Timing = 0xD10A,
  eSQF_LOG_TDSCDMA_TFW_Demfront_Config = 0xD10B,
  eSQF_LOG_TDSCDMA_TFW_Demfront_Cell_Config = 0xD10C,
  eSQF_LOG_TDSCDMA_TFW_Channel_Estimation_Short = 0xD10D,
  eSQF_LOG_TDSCDMA_TFW_Equalizer_Weight_Computation = 0xD10E,
  eSQF_LOG_TDSCDMA_TFW_AE_Result = 0xD10F,
  eSQF_LOG_TDSCDMA_TFW_Special_Burst_Result = 0xD110,
  eSQF_LOG_TDSCDMA_TFW_TPC_SS_Decoding_Result = 0xD111,
  eSQF_LOG_TDSCDMA_TFW_TFCI_DECODING_RESULTS = 0xD112,
  eSQF_LOG_TDSCDMA_TFW_EHICH_DECODING_RESULTS = 0xD113,
  eSQF_LOG_TDSCDMA_TFW_EAGCH_DECODING_RESULTS = 0xD114,
  eSQF_LOG_TDSCDMA_TFW_UL_DPCH_Encoding_Result = 0xD115,
  eSQF_LOG_TDSCDMA_TFW_PRACH_ENCODING_RESULTS = 0xD116,
  eSQF_LOG_TDSCDMA_TFW_UPPCH_Encoding_Result = 0xD117,
  eSQF_LOG_TDSCDMA_TFW_HS_SICH_Encoding_Result = 0xD118,
  eSQF_LOG_TDSCDMA_TFW_EPUCH_ENCODING_RESULTS = 0xD119,
  eSQF_LOG_TDSCDMA_TFW_ERUCCH_Encoding_Result = 0xD11A,
  eSQF_LOG_TDSCDMA_TFW_Uplink_Report = 0xD11B,
  eSQF_LOG_TDSCDMA_TFW_TPC_Report = 0xD11C,
  eSQF_LOG_TDSCDMA_TFW_Uplink_Timing = 0xD11D,
  eSQF_LOG_TDSCDMA_TFW_Channel_Estimation_Long = 0xD11E,
  eSQF_LOG_TDSCDMA_TFW_NONHS_SIR = 0xD11F,
  eSQF_LOG_TDSCDMA_TFW_Memory_Chunk = 0xD120,
  eSQF_LOG_TDSCDMA_TFW_CQI = 0xD121,
  eSQF_LOG_Internal__TDSCDMA_TFW_MSG_Logging = 0xD122,
  eSQF_LOG_Internal__TDSCDMA_TFW_Dynamic_Switch = 0xD123,
  eSQF_LOG_TDSCDMA_TFW_HSSCCH_Decoding_Results = 0xD124,
  eSQF_LOG_TDSCDMA_FW_T2X = 0xD125,
  eSQF_LOG_TDSCDMA_FW_Timeline_Profile = 0xD126,
  eSQF_LOG_Internal__TDSCDMA_CE_And_Demfront_Profile = 0xD127,
  eSQF_LOG_TDSCDMA_FW_IRAT_X2T = 0xD128,
  eSQF_LOG_TDSCDMA_FW_Enhance_Non_TS0_Pruning_Results = 0xD129,
  eSQF_LOG_TDSCDMA_TFW_DSDX_CXM_Slot_Status = 0xD12A,
  eSQF_LOG_TDSCDMA_TFW_MultiSIM_Config = 0xD12B,
  eSQF_LOG_TDSCDMA_TFW_DSDS_TG_QTA_Gap = 0xD12C,
  eSQF_LOG_TDSCDMA_TFW_RX_AGC = 0xD12D,
  eSQF_LOG_TDSCDMA_TFW_RFC_Slot_Update = 0xD12E,
  eSQF_LOG_TDSCDMA_TFW_RFC_Events = 0xD12F,
  eSQF_LOG_TDSCDMA_TFW_Exceptional_Events = 0xD130,
  eSQF_LOG_TDSCDMA_TFW_DIME_VPE_Information = 0xD131,
  eSQF_LOG_TDSCDMA_TFW_TX_AGC = 0xD132,
  eSQF_LOG_TDSCDMA_TFW_Debug = 0xD133,
  eSQF_LOG_TDSCDMA_TFW_Command = 0xD134,
  eSQF_LOG_TDSCDMA_TFW_Response = 0xD135,
  eSQF_LOG_TDSCDMA_TFW_TXFE = 0xD136,
  eSQF_LOG_TDSCDMA_TFW_WAV = 0xD137,
  eSQF_LOG_TDSCDMA_FW_HS_Result = 0xD138,
  eSQF_LOG_TDSCDMA_FW_DSDA_TG_Power_Scan = 0xD139,
  eSQF_LOG_Internal__TDSCDMA_TFW_Diag_Log_FBRX = 0xD13A,
}sqf_log;

typedef enum _eSQF_EVENT_{
  eSQF_EVENT_DROP_ID = 0,
  eSQF_EVENT_BAND_CLASS_CHANGE = 256,
  eSQF_EVENT_CDMA_CH_CHANGE = 257,
  eSQF_EVENT_BS_P_REV_CHANGE = 258,
  eSQF_EVENT_P_REV_IN_USE_CHANGE = 259,
  eSQF_EVENT_SID_CHANGE = 260,
  eSQF_EVENT_NID_CHANGE = 261,
  eSQF_EVENT_PZID_CHANGE = 262,
  eSQF_EVENT_PDE_SESSION_END = 263,
  eSQF_EVENT_OP_MODE_CHANGE = 264,
  eSQF_EVENT_MESSAGE_RECEIVED = 265,
  eSQF_EVENT_MESSAGE_TRANSMITTED = 266,
  eSQF_EVENT_TIMER_EXPIRED = 267,
  eSQF_EVENT_COUNTER_THRESHOLD = 268,
  eSQF_EVENT_CALL_PROCESSING_STATE_CHANGE = 269,
  eSQF_EVENT_CALL_CONTROL_INSTANTIATED = 270,
  eSQF_EVENT_CALL_CONTROL_STATE_CHANGE = 271,
  eSQF_EVENT_CALL_CONTROL_TERMINATED = 272,
  eSQF_EVENT_REG_ZONE_CHANGE = 273,
  eSQF_EVENT_SLOTTED_MODE_OPERATION = 274,
  eSQF_EVENT_QPCH_IN_USE = 275,
  eSQF_EVENT_IDLE_HANDOFF = 276,
  eSQF_EVENT_ACCESS_HANDOFF = 277,
  eSQF_EVENT_ACCESS_PROBE_HANDOFF = 278,
  eSQF_EVENT_SOFT_HANDOFF = 279,
  eSQF_EVENT_HARD_HANDOFF_FREQ_CHANGE = 280,
  eSQF_EVENT_HARD_HANDOFF_FRAME_OFFSET_CHANGE = 281,
  eSQF_EVENT_HARD_HANDOFF_DISJOINT_ASET = 282,
  eSQF_EVENT_UNSUCCESSFUL_HARD_HANDOFF = 283,
  eSQF_EVENT_TMSI_ASSIGNED = 284,
  eSQF_EVENT_SERVICE_NEGOTIATION_COMPLETED = 285,
  eSQF_EVENT_SO_NEGOTIATION_COMPLETED = 286,
  eSQF_EVENT_ENTER_CONTROL_HOLD_MODE = 287,
  eSQF_EVENT_EXIT_CONTROL_HOLD_MODE = 288,
  eSQF_EVENT_START_FWD_SUPP_BURST_ASSGN = 289,
  eSQF_EVENT_END_FWD_SUPP_BURST_ASSGN = 290,
  eSQF_EVENT_START_REV_SUPP_BURST_ASSGN = 291,
  eSQF_EVENT_END_REV_SUPP_BURST_ASSGN = 292,
  eSQF_EVENT_DTX = 293,
  eSQF_EVENT_T_ADD_ABORT = 294,
  eSQF_EVENT_CH_IND_CHANGE = 295,
  eSQF_EVENT_TRANSMITTER_DISABLED = 296,
  eSQF_EVENT_TRANSMITTER_ENABLED = 297,
  eSQF_EVENT_SMS_RECEIVED = 298,
  eSQF_EVENT_SMS_SENT = 299,
  eSQF_EVENT_INACTIVITY_TIMER_EXPIRED = 300,
  eSQF_EVENT_DORMANT_TIMER_EXPIRED = 301,
  eSQF_EVENT_ACCESS_ATTEMPT_FAIL_MAX_PROBES_SENT = 302,
  eSQF_EVENT_ACCESS_ATTEMPT_FAIL_LOSS_OF_PC_OR_FCCC = 303,
  eSQF_EVENT_PCH_ACQUIRED = 304,
  eSQF_EVENT_BCCH_ACQUIRED = 305,
  eSQF_EVENT_FFCH_ACQUIRED = 306,
  eSQF_EVENT_FDCCH_ACQUIRED = 307,
  eSQF_EVENT_FFCH_PLUS_DCCH_ACQUIRED = 308,
  eSQF_EVENT_REGISTRATION_PERFORMED = 309,
  eSQF_EVENT_NEW_SYSTEM_IDLE_HANDOFF = 310,
  eSQF_EVENT_SYSTEM_RESELECTION = 311,
  eSQF_EVENT_RESCAN = 312,
  eSQF_EVENT_PROTOCOL_MISMATCH = 313,
  eSQF_EVENT_LOCK = 314,
  eSQF_EVENT_UNLOCK = 315,
  eSQF_EVENT_ACCESS_DENIED = 316,
  eSQF_EVENT_NDSS_OFF = 317,
  eSQF_EVENT_RELEASE = 318,
  eSQF_EVENT_ERROR = 319,
  eSQF_EVENT_REDIRECTION = 320,
  eSQF_EVENT_REGISTRATION_REJECTED = 321,
  eSQF_EVENT_WRONG_SYSTEM = 322,
  eSQF_EVENT_WRONG_NETWORK = 323,
  eSQF_EVENT_LOSS_OF_ACQ_AFTER_SLEEP = 324,
  eSQF_EVENT_POWER_DOWN = 325,
  eSQF_EVENT_CALL_RELEASE_REQUEST = 326,
  eSQF_EVENT_SERVICE_INACTIVE = 327,
  eSQF_EVENT_EXTENDED_RELEASE = 328,
  eSQF_EVENT_HDR_MSG_RX = 329,
  eSQF_EVENT_HDR_RXMSG_IGNORED_STATE = 330,
  eSQF_EVENT_HDR_RXMSG_IGNORED_SEQ = 331,
  eSQF_EVENT_HDR_TXMSG_ACKED = 332,
  eSQF_EVENT_HDR_TXMSG_DROPPED = 333,
  eSQF_EVENT_HDR_STATE_CHANGE = 334,
  eSQF_EVENT_HDR_ALMP_OBEYING_REDIRECTION = 335,
  eSQF_EVENT_HDR_ALMP_CONNECTION_CLOSED = 336,
  eSQF_EVENT_HDR_ALMP_T_SD_RESELECT = 337,
  eSQF_EVENT_HDR_ALMP_CONNECTION_OPENED = 338,
  eSQF_EVENT_HDR_HMP_QUEUED_MSG = 339,
  eSQF_EVENT_HDR_HMP_SENT_MSG = 340,
  eSQF_EVENT_HDR_HMP_ABORTING_ACMAC_ACTIVATION = 341,
  eSQF_EVENT_HDR_IDLE_T_CONFIG_RSP = 342,
  eSQF_EVENT_HDR_IDLE_T_AT_SETUP = 343,
  eSQF_EVENT_HDR_IDLE_T_SUSPEND = 344,
  eSQF_EVENT_HDR_IDLE_CONNECTION_DENIED = 345,
  eSQF_EVENT_HDR_INIT_T_SYNC_ACQ = 346,
  eSQF_EVENT_HDR_INIT_PROTOCOL_MISMATCH = 347,
  eSQF_EVENT_HDR_OVHD_INFO_CURRENT = 348,
  eSQF_EVENT_HDR_OVHD_T_QC_SUPERVISION = 349,
  eSQF_EVENT_HDR_OVHD_T_SP_SUPERVISION = 350,
  eSQF_EVENT_HDR_OVHD_T_AP_SUPERVISION = 351,
  eSQF_EVENT_HDR_OVHD_IGNORED_MSG_UNEXPECTED_LINK = 352,
  eSQF_EVENT_HDR_OVHD_IGNORED_SP_MSG_DIFF_SEC_SIG = 353,
  eSQF_EVENT_HDR_OVHD_IGNORED_AP_MSG_DIFF_ACC_SIG = 354,
  eSQF_EVENT_HDR_OVHD_IGNORED_SP_MSG_DIFF_SEC_ID = 355,
  eSQF_EVENT_HDR_OVHD_SP_MSG_RX = 356,
  eSQF_EVENT_HDR_OVHD_AP_MSG_RX = 357,
  eSQF_EVENT_HDR_RUP_T_CONNECTION_SETUP = 358,
  eSQF_EVENT_HDR_SLP_MAX_RETRIES = 359,
  eSQF_EVENT_HDR_LMAC_ACQ_FAIL_PILOT = 360,
  eSQF_EVENT_HDR_LMAC_ACQ_SUCCESS = 361,
  eSQF_EVENT_HDR_LMAC_NETWORK_LOST = 362,
  eSQF_EVENT_HDR_LMAC_IDLE_HO = 363,
  eSQF_EVENT_HDR_LMAC_CHAN_CHANGE_COMPLETE = 364,
  eSQF_EVENT_HDR_LMAC_ACCESS_HO_NEEDED = 365,
  eSQF_EVENT_HDR_LMAC_ACCESS_HO_COMPLETE = 366,
  eSQF_EVENT_HDR_LMAC_ACQUIRE = 367,
  eSQF_EVENT_HDR_LMAC_CHANGING_CC_HASH = 368,
  eSQF_EVENT_HDR_LMAC_IDLE_CHAN_CHANGE = 369,
  eSQF_EVENT_HDR_CMAC_T_SUPERVISION = 370,
  eSQF_EVENT_HDR_AMAC_START_ACCESS = 371,
  eSQF_EVENT_HDR_AMAC_PROBING_STOPPED = 372,
  eSQF_EVENT_HDR_AMAC_ACCESS_COMPLETE = 373,
  eSQF_EVENT_HDR_AMAC_ACCESS_ABORTED = 374,
  eSQF_EVENT_HDR_AMAC_MAX_PROBES = 375,
  eSQF_EVENT_HDR_FMAC_DROP_PKT = 376,
  eSQF_EVENT_HDR_RMAC_T_RATE_LIMIT = 377,
  eSQF_EVENT_HDR_RMAC_TX_STARTED = 378,
  eSQF_EVENT_HDR_RMAC_TX_STOPPED = 379,
  eSQF_EVENT_HDR_SMP_T_KEEP_ALIVE = 380,
  eSQF_EVENT_HDR_AMP_ASSIGN_MSG_IGNORED_FRESH = 381,
  eSQF_EVENT_HDR_AMP_T_AT_RESPONSE = 382,
  eSQF_EVENT_HDR_AMP_T_DUAL_ADDRESS = 383,
  eSQF_EVENT_HDR_SCP_BEGIN_CONFIGURATION = 384,
  eSQF_EVENT_HDR_SCP_T_CONFIG_RSP = 385,
  eSQF_EVENT_HDR_SCP_T_AN_INIT_STATE = 386,
  eSQF_EVENT_WCDMA_L1_STATE = 387,
  eSQF_EVENT_WCDMA_IMSI = 388,
  eSQF_EVENT_GSM_L1_STATE = 389,
  eSQF_EVENT_RANDOM_ACCESS_REQUEST = 390,
  eSQF_EVENT_HIGH_LEVEL_CALL_PROCESSING_STATE_CHANGE = 391,
  eSQF_EVENT_ENCRYPTION_FAILURE = 392,
  eSQF_EVENT_ACCT_BLOCKED = 393,
  eSQF_EVENT_COMMON_CHANNEL_MONITORED = 394,
  eSQF_EVENT_SOFT_HANDOFF_V2 = 395,
  eSQF_EVENT_HARD_HANDOFF_FREQ_CHANGE_V2 = 396,
  eSQF_EVENT_HARD_HANDOFF_FRAME_OFFSET_CHANGE_V2 = 397,
  eSQF_EVENT_HARD_HANDOFF_DISJOINT_ASET_V2 = 398,
  eSQF_EVENT_WCDMA_NEW_REFERENCE_CELL = 399,
  eSQF_EVENT_CALL_CONTROL_CONREF_CHANGE = 400,
  eSQF_EVENT_GPS_SESSION_BEGIN = 401,
  eSQF_EVENT_GPS_SESSION_END = 402,
  eSQF_EVENT_GPS_WAITING_ON_SA = 403,
  eSQF_EVENT_GPS_PPM_START = 404,
  eSQF_EVENT_GPS_PPM_RESULTS = 405,
  eSQF_EVENT_GPS_PPM_END = 406,
  eSQF_EVENT_GPS_VISIT_BEGIN = 407,
  eSQF_EVENT_GPS_VISIT_END = 408,
  eSQF_EVENT_GPS_CDMA_RESUMED_AFTER_GPS_VISIT = 409,
  eSQF_EVENT_GPS_PD_SESSION_BEGIN = 410,
  eSQF_EVENT_GPS_PD_SESSION_END = 411,
  eSQF_EVENT_GPS_IS801_RX = 412,
  eSQF_EVENT_GPS_IS801_TX = 413,
  eSQF_EVENT_POWERUP = 414,
  eSQF_EVENT_WCDMA_ASET = 415,
  eSQF_EVENT_CM_CALL_STATE = 416,
  eSQF_EVENT_CM_OPERATIONAL_MODE = 417,
  eSQF_EVENT_CM_SYSTEM_MODE = 418,
  eSQF_EVENT_DEEP_SLEEP = 419,
  eSQF_EVENT_WAKEUP = 420,
  eSQF_EVENT_ACQUISITION_MODE = 421,
  eSQF_EVENT_ACQUISITION_TYPE = 422,
  eSQF_EVENT_ACP_EXIT = 423,
  eSQF_EVENT_CDMA_EXIT = 424,
  eSQF_EVENT_HDR_HYBRID_POWER_SAVE = 425,
  eSQF_EVENT_HDR_DEEP_SLEEP = 426,
  eSQF_EVENT_HDR_RESELECTION = 427,
  eSQF_EVENT_SAM_LOCK_GRANTED = 428,
  eSQF_EVENT_SAM_LOCK_RELEASED = 429,
  eSQF_EVENT_GSM_HANDOVER_START = 430,
  eSQF_EVENT_GSM_HANDOVER_END = 431,
  eSQF_EVENT_GSM_LINK_FAILURE = 432,
  eSQF_EVENT_GSM_RESELECT_START = 433,
  eSQF_EVENT_GSM_RESELECT_END = 434,
  eSQF_EVENT_GSM_CAMP_ATTEMPT_START = 435,
  eSQF_EVENT_GSM_RR_IN_SERVICE = 436,
  eSQF_EVENT_GSM_RR_OUT_OF_SERVICE = 437,
  eSQF_EVENT_GSM_PAGE_RECEIVED = 438,
  eSQF_EVENT_GSM_CAMP_ATTEMPT_END = 439,
  eSQF_EVENT_GPS_IS801_TIMEOUT = 440,
  eSQF_EVENT_GPS_IS801_DISCARD = 441,
  eSQF_EVENT_GSM_CELL_SELECTION_START = 442,
  eSQF_EVENT_GSM_CELL_SELECTION_END = 443,
  eSQF_EVENT_GSM_POWER_SCAN_STATUS = 444,
  eSQF_EVENT_GSM_PLMN_LIST_START = 445,
  eSQF_EVENT_GSM_PLMN_LIST_END = 446,
  eSQF_EVENT_WCDMA_INTER_RAT_HANDOVER_START = 447,
  eSQF_EVENT_WCDMA_INTER_RAT_HANDOVER_END = 448,
  eSQF_EVENT_GSM_MESSAGE_SENT = 449,
  eSQF_EVENT_GSM_MESSAGE_RECEIVED = 450,
  eSQF_EVENT_GSM_TIMER_EXPIRED = 451,
  eSQF_EVENT_GSM_COUNTER_EXPIRED = 452,
  eSQF_EVENT_NAS_MESSAGE_SENT = 453,
  eSQF_EVENT_NAS_MESSAGE_RECEIVED = 454,
  eSQF_EVENT_RRC_MESSAGE_SENT = 455,
  eSQF_EVENT_RRC_MESSAGE_RECEIVED = 456,
  eSQF_EVENT_CAMERA_CANNOT_CAPTURE = 457,
  eSQF_EVENT_CAMERA_CANNOT_CONFIG_JPEG = 458,
  eSQF_EVENT_CAMERA_CANNOT_CONFIG_VFE = 459,
  eSQF_EVENT_CAMERA_CANNOT_ENCODE = 460,
  eSQF_EVENT_CAMERA_CANNOT_IDLE_DSP = 461,
  eSQF_EVENT_CAMERA_CANNOT_LOAD_DSP = 462,
  eSQF_EVENT_CAMERA_DSP_FATAL = 463,
  eSQF_EVENT_CAMERA_DSP_REQ_ILLEGAL = 464,
  eSQF_EVENT_CAMERA_EFS_FAILED = 465,
  eSQF_EVENT_CAMERA_EXIT = 466,
  eSQF_EVENT_CAMERA_FORMAT_NOT_SUPPORTED = 467,
  eSQF_EVENT_CAMERA_FUNCTION_REJECTED = 468,
  eSQF_EVENT_CAMERA_IMAGE_CORRUPT = 469,
  eSQF_EVENT_CAMERA_INVALID_CONFIG_PARM = 470,
  eSQF_EVENT_CAMERA_INVALID_SET_ID = 471,
  eSQF_EVENT_CAMERA_INVALID_STATE = 472,
  eSQF_EVENT_CAMERA_JPEG_ENCODED = 473,
  eSQF_EVENT_CAMERA_NO_MEMORY = 474,
  eSQF_EVENT_CAMERA_NO_PICTURE = 475,
  eSQF_EVENT_CAMERA_PICTURE_SAVED = 476,
  eSQF_EVENT_CAMERA_PICTURE_TAKEN = 477,
  eSQF_EVENT_CAMERA_PREVIEW = 478,
  eSQF_EVENT_CAMERA_RECORD = 479,
  eSQF_EVENT_CAMERA_SAVE_PICTURE = 480,
  eSQF_EVENT_CAMERA_SET_FAILED = 481,
  eSQF_EVENT_CAMERA_SET_SUCCEEDED = 482,
  eSQF_EVENT_CAMERA_START = 483,
  eSQF_EVENT_CAMERA_STOP = 484,
  eSQF_EVENT_CAMERA_TAKE_PICTURE = 485,
  eSQF_EVENT_DIAG_STRESS_TEST_NO_PAYLOAD = 486,
  eSQF_EVENT_DIAG_STRESS_TEST_WITH_PAYLOAD = 487,
  eSQF_EVENT_CM_CALL_ORIG_START_P1 = 488,
  eSQF_EVENT_CM_CALL_ORIG_START_P2 = 489,
  eSQF_EVENT_CM_CALL_ORIG_START_P3 = 490,
  eSQF_EVENT_CM_CALL_ORIG_SWITCH_TO_HDR = 491,
  eSQF_EVENT_CM_CALL_ORIG_REDIAL = 492,
  eSQF_EVENT_CM_CALL_ORIG_SEND_HDR_ORIG = 493,
  eSQF_EVENT_CM_CALL_ORIG_SEND_MC_ORIG = 494,
  eSQF_EVENT_CM_CALL_ORIG_END = 495,
  eSQF_EVENT_CM_CALL_ORIG_CONNECTED = 496,
  eSQF_EVENT_MT_SMS_NOTIFY = 497,
  eSQF_EVENT_SMS_SLOT_WAKEUP = 498,
  eSQF_EVENT_MO_SMS_STATUS = 499,
  eSQF_EVENT_GPRS_SURROUND_SEARCH_START = 500,
  eSQF_EVENT_GPRS_SURROUND_SEARCH_END = 501,
  eSQF_EVENT_GPRS_MAC_RESELECT_IND = 502,
  eSQF_EVENT_GPRS_PAGE_RECEIVED = 503,
  eSQF_EVENT_GPRS_LINK_FAILURE = 504,
  eSQF_EVENT_GPRS_CELL_UPDATE_START = 505,
  eSQF_EVENT_GPRS_CELL_UPDATE_END = 506,
  eSQF_EVENT_GPRS_EARLY_CAMPING = 507,
  eSQF_EVENT_PACKET_RANDOM_ACCESS_REQ = 508,
  eSQF_EVENT_GPRS_MAC_MSG_SENT = 509,
  eSQF_EVENT_GPRS_MAC_MSG_RECEIVED = 510,
  eSQF_EVENT_GPRS_SMGMM_MSG_SENT = 511,
  eSQF_EVENT_GPRS_SMGMM_MSG_RECEIVED = 512,
  eSQF_EVENT_CP_MATCHED_MSG = 513,
  eSQF_EVENT_PREF_SYS_RESEL = 514,
  eSQF_EVENT_WCDMA_LAYER1_PRACH = 515,
  eSQF_EVENT_WCDMA_LAYER1_MEASUREMENT = 516,
  eSQF_EVENT_MOBILITY_MANAGEMENT_STATE_CHANGE = 517,
  eSQF_EVENT_LSM_STATE_CHANGE = 518,
  eSQF_EVENT_RLP = 519,
  eSQF_EVENT_CM_MODE_PREF = 520,
  eSQF_EVENT_CM_BAND_PREF = 521,
  eSQF_EVENT_CM_ROAM_PREF = 522,
  eSQF_EVENT_CM_SRV_DOMAIN_PREF = 523,
  eSQF_EVENT_CM_GW_ACQ_ORDER_PREF = 524,
  eSQF_EVENT_CM_HYBRID_PREF = 525,
  eSQF_EVENT_CM_NETWORK_SEL_MODE_PREF = 526,
  eSQF_EVENT_WCDMA_L1_SUSPEND = 527,
  eSQF_EVENT_WCDMA_L1_RESUME = 528,
  eSQF_EVENT_WCDMA_L1_STOPPED = 529,
  eSQF_EVENT_WCDMA_TO_WCDMA_RESELECTION_START = 530,
  eSQF_EVENT_WCDMA_TO_GSM_RESELECTION_START = 531,
  eSQF_EVENT_WCDMA_TO_GSM_RESELECTION_END = 532,
  eSQF_EVENT_WCDMA_TO_WCDMA_RESELECTION_END = 533,
  eSQF_EVENT_WCDMA_RACH_ATTEMPT = 534,
  eSQF_EVENT_START_FWD_SUPP_BURST_ASSIGN = 535,
  eSQF_EVENT_START_REV_SUPP_BURST_ASSIGN = 536,
  eSQF_EVENT_REV_FCH_GATING_IN_USE = 537,
  eSQF_EVENT_PPP = 538,
  eSQF_EVENT_MIP = 539,
  eSQF_EVENT_TCP = 540,
  eSQF_EVENT_CAMERA_EXIF_FAILED = 541,
  eSQF_EVENT_CAMERA_VIDEO_FAILED = 542,
  eSQF_EVENT_CAMERA_NO_SENSOR = 543,
  eSQF_EVENT_CAMERA_ABORT = 544,
  eSQF_EVENT_CM_BLOCK_HDR_ORIG_DURING_GPS = 545,
  eSQF_EVENT_CM_ALLOW_HDR_ORIG_DURING_GPS = 546,
  eSQF_EVENT_GSM_AMR_STATE_CHANGE = 547,
  eSQF_EVENT_GSM_RATSCCH_IN_DTX = 548,
  eSQF_EVENT_GSM_FACCH_IN_DTX = 549,
  eSQF_EVENT_GSM_FACCH_AND_RATSCCH_COLLISION = 550,
  eSQF_EVENT_GSM_FACCH_AND_SID_UPDATE_COLLISION = 551,
  eSQF_EVENT_GSM_RATSCCH_AND_SID_UPDATE_COLLISION = 552,
  eSQF_EVENT_GSM_RATSCCH_CMI_PHASE_CHANGE = 553,
  eSQF_EVENT_GSM_RATSCCH_REQ_ACT_TIMER_EXPIRY = 554,
  eSQF_EVENT_GSM_RATSCCH_ACK_ACT_TIMER_EXPIRY = 555,
  eSQF_EVENT_GSM_AMR_CMC_TURNAROUND_TIME = 556,
  eSQF_EVENT_CM_PLMN_FOUND = 557,
  eSQF_EVENT_CM_SERVICE_CONFIRMED = 558,
  eSQF_EVENT_GPRS_MAC_CAMPED_ON_CELL = 559,
  eSQF_EVENT_GPRS_LLC_READY_TIMER_START = 560,
  eSQF_EVENT_GPRS_LLC_READY_TIMER_END = 561,
  eSQF_EVENT_WCDMA_PHYCHAN_ESTABLISHED = 562,
  eSQF_EVENT_HS_DISPLAY_BMP_CAPTURE_STATUS = 563,
  eSQF_EVENT_WCDMA_CELL_SELECTED = 564,
  eSQF_EVENT_WCDMA_PAGE_RECEIVED = 565,
  eSQF_EVENT_WCDMA_SEND_KEY = 566,
  eSQF_EVENT_WCDMA_RL_FAILURE = 567,
  eSQF_EVENT_WCDMA_MAX_RESET = 568,
  eSQF_EVENT_WCDMA_CALL_SETUP = 569,
  eSQF_EVENT_WCDMA_CALL_DROPPED = 570,
  eSQF_EVENT_WCDMA_RRC_STATE = 571,
  eSQF_EVENT_GPS_PD_CONNECTION_TIMEOUT = 572,
  eSQF_EVENT_GPS_PD_DISCONNECTION_COMPLETE = 573,
  eSQF_EVENT_MEDIA_PLAYER_START = 574,
  eSQF_EVENT_MEDIA_PLAYER_STOP = 575,
  eSQF_EVENT_MEDIA_PLAYER_SEEK = 576,
  eSQF_EVENT_GPS_SRCH_START = 577,
  eSQF_EVENT_GPS_SRCH_END = 578,
  eSQF_EVENT_GPS_PPM_PAUSE = 579,
  eSQF_EVENT_GPS_PPM_RESUME = 580,
  eSQF_EVENT_GPS_SA_RECEIVED = 581,
  eSQF_EVENT_GPS_CLK_ON = 582,
  eSQF_EVENT_GPS_CLK_OFF = 583,
  eSQF_EVENT_GPS_VISIT_REQUEST = 584,
  eSQF_EVENT_GPS_VISIT_RESPONSE = 585,
  eSQF_EVENT_GPS_TA_START = 586,
  eSQF_EVENT_GPS_DSP_READY = 587,
  eSQF_EVENT_GPS_DSP_CHANNEL_START = 588,
  eSQF_EVENT_GPS_DSP_CHANNEL_DONE = 589,
  eSQF_EVENT_GPS_DSP_STOP = 590,
  eSQF_EVENT_GPS_DSP_DONE = 591,
  eSQF_EVENT_GPS_TB_END = 592,
  eSQF_EVENT_GPS_SRCH_LARGE_DOPP_WIN = 593,
  eSQF_EVENT_GPS_SRCH_EXCEPTION = 594,
  eSQF_EVENT_GPS_SRCH_HW_POLLING1 = 595,
  eSQF_EVENT_GPS_SRCH_HW_POLLING2 = 596,
  eSQF_EVENT_GPS_PGI_ACTION_PROCESS = 597,
  eSQF_EVENT_GPS_GSC_ACTION_PROCESS = 598,
  eSQF_EVENT_GPS_PGI_ABORT = 599,
  eSQF_EVENT_GPS_GSC_ABORT = 600,
  eSQF_EVENT_GPS_PD_FIX_START = 601,
  eSQF_EVENT_GPS_PD_FIX_END = 602,
  eSQF_EVENT_GPS_DATA_DOWNLOAD_START = 603,
  eSQF_EVENT_GPS_DATA_DOWNLOAD_END = 604,
  eSQF_EVENT_GPS_PD_SESSION_START = 605,
  eSQF_EVENT_GPS_DORMANCY_BEGIN = 606,
  eSQF_EVENT_GPS_DORMANCY_END = 607,
  eSQF_EVENT_GPS_PRQ_TIMEOUT = 608,
  eSQF_EVENT_GPS_PD_CONNECTION_START = 609,
  eSQF_EVENT_GPS_PD_CONNECTION_ESTABLISHED = 610,
  eSQF_EVENT_GPS_PD_DISCONNECTION_START = 611,
  eSQF_EVENT_GPS_FTEST_FIX_START = 612,
  eSQF_EVENT_GPS_FTEST_FIX_END = 613,
  eSQF_EVENT_GPS_PD_POSITION = 614,
  eSQF_EVENT_GPS_E911_START = 615,
  eSQF_EVENT_GPS_E911_END = 616,
  eSQF_EVENT_GPS_DBM_SEND_FAILURE = 617,
  eSQF_EVENT_GPS_UAPDMS_STATE_CHANGE = 618,
  eSQF_EVENT_WCDMA_OUT_OF_SERVICE = 619,
  eSQF_EVENT_GSM_L1_SUBSTATE = 620,
  eSQF_EVENT_SD_EVENT_ACTION = 621,
  eSQF_EVENT_SD_EVENT_ACTION_HYBR = 622,
  eSQF_EVENT_UMTS_CALLS_STATISTICS = 623,
  eSQF_EVENT_PZID_HAT_STARTED = 624,
  eSQF_EVENT_WCDMA_DRX_CYCLE = 625,
  eSQF_EVENT_WCDMA_RE_ACQUISITION_FAIL = 626,
  eSQF_EVENT_WCDMA_RRC_RB0_SETUP_FAILURE = 627,
  eSQF_EVENT_WCDMA_RRC_PHYCHAN_EST_FAILURE = 628,
  eSQF_EVENT_CM_CALL_EVENT_ORIG = 629,
  eSQF_EVENT_CM_CALL_EVENT_CONNECT = 630,
  eSQF_EVENT_CM_CALL_EVENT_END = 631,
  eSQF_EVENT_CM_ENTER_EMERGENCY_CB = 632,
  eSQF_EVENT_CM_EXIT_EMERGENCY_CB = 633,
  eSQF_EVENT_PZID_HAT_EXPIRED = 634,
  eSQF_EVENT_HDR_SMP_SESSION_CLOSED = 635,
  eSQF_EVENT_WCDMA_MEMORY_LEAK = 636,
  eSQF_EVENT_PZID_HT_STARTED = 637,
  eSQF_EVENT_PZID_HT_EXPIRED = 638,
  eSQF_EVENT_ACCESS_ENTRY_HANDOFF = 639,
  eSQF_EVENT_BREW_APP_START = 640,
  eSQF_EVENT_BREW_APP_STOP = 641,
  eSQF_EVENT_BREW_APP_PAUSE = 642,
  eSQF_EVENT_BREW_APP_RESUME = 643,
  eSQF_EVENT_BREW_EXT_MODULE_START = 644,
  eSQF_EVENT_BREW_EXT_MODULE_STOP = 645,
  eSQF_EVENT_BREW_ERROR = 646,
  eSQF_EVENT_BREW_UNDEFINED_647 = 647,
  eSQF_EVENT_BREW_UNDEFINED_648 = 648,
  eSQF_EVENT_BREW_UNDEFINED_649 = 649,
  eSQF_EVENT_BREW_UNDEFINED_650 = 650,
  eSQF_EVENT_BREW_UNDEFINED_651 = 651,
  eSQF_EVENT_BREW_UNDEFINED_652 = 652,
  eSQF_EVENT_BREW_UNDEFINED_653 = 653,
  eSQF_EVENT_BREW_UNDEFINED_654 = 654,
  eSQF_EVENT_BREW_UNDEFINED_655 = 655,
  eSQF_EVENT_BREW_USER_656 = 656,
  eSQF_EVENT_BREW_GENERIC = 657,
  eSQF_EVENT_BREW_MEDIAPLAYER_SELECT_FILE = 658,
  eSQF_EVENT_BREW_MEDIAPLAYER_CONTROL = 659,
  eSQF_EVENT_BREW_APP_FORMITEM_STACK_CHANGE = 660,
  eSQF_EVENT_BREW_CATAPP_RECV_PROACTIVE_CMD = 661,
  eSQF_EVENT_BREW_CATAPP_TERMINAL_RSP = 662,
  eSQF_EVENT_BREW_CATAPP_NO_DISPLAY = 663,
  eSQF_EVENT_BREW_SIRIUS_EMAIL_DELETE = 664,
  eSQF_EVENT_BREW_SIRIUS_EMAIL_OPERATION_COMPLETE = 665,
  eSQF_EVENT_BREW_SIRIUS_EMAIL_NEW_EMAIL_NOTIFICATION = 666,
  eSQF_EVENT_BREW_UNDEFINED_667 = 667,
  eSQF_EVENT_BREW_UNDEFINED_668 = 668,
  eSQF_EVENT_BREW_UNDEFINED_669 = 669,
  eSQF_EVENT_BREW_UNDEFINED_670 = 670,
  eSQF_EVENT_BREW_UNDEFINED_671 = 671,
  eSQF_EVENT_BREW_UNDEFINED_672 = 672,
  eSQF_EVENT_BREW_UNDEFINED_673 = 673,
  eSQF_EVENT_BREW_UNDEFINED_674 = 674,
  eSQF_EVENT_BREW_UNDEFINED_675 = 675,
  eSQF_EVENT_BREW_UNDEFINED_676 = 676,
  eSQF_EVENT_BREW_UNDEFINED_677 = 677,
  eSQF_EVENT_BREW_UNDEFINED_678 = 678,
  eSQF_EVENT_BREW_UNDEFINED_679 = 679,
  eSQF_EVENT_BREW_UNDEFINED_680 = 680,
  eSQF_EVENT_BREW_UNDEFINED_681 = 681,
  eSQF_EVENT_BREW_UNDEFINED_682 = 682,
  eSQF_EVENT_BREW_UNDEFINED_683 = 683,
  eSQF_EVENT_BREW_UNDEFINED_684 = 684,
  eSQF_EVENT_BREW_UNDEFINED_685 = 685,
  eSQF_EVENT_BREW_UNDEFINED_686 = 686,
  eSQF_EVENT_BREW_UNDEFINED_687 = 687,
  eSQF_EVENT_BREW_UNDEFINED_688 = 688,
  eSQF_EVENT_BREW_UNDEFINED_689 = 689,
  eSQF_EVENT_BREW_UNDEFINED_690 = 690,
  eSQF_EVENT_BREW_UNDEFINED_691 = 691,
  eSQF_EVENT_BREW_UNDEFINED_692 = 692,
  eSQF_EVENT_BREW_UNDEFINED_693 = 693,
  eSQF_EVENT_BREW_UNDEFINED_694 = 694,
  eSQF_EVENT_BREW_UNDEFINED_695 = 695,
  eSQF_EVENT_BREW_UNDEFINED_696 = 696,
  eSQF_EVENT_BREW_UNDEFINED_697 = 697,
  eSQF_EVENT_BREW_UNDEFINED_698 = 698,
  eSQF_EVENT_BREW_UNDEFINED_699 = 699,
  eSQF_EVENT_BREW_UNDEFINED_700 = 700,
  eSQF_EVENT_BREW_UNDEFINED_701 = 701,
  eSQF_EVENT_BREW_UNDEFINED_702 = 702,
  eSQF_EVENT_BREW_UNDEFINED_703 = 703,
  eSQF_EVENT_BREW_UNDEFINED_704 = 704,
  eSQF_EVENT_BREW_UNDEFINED_705 = 705,
  eSQF_EVENT_BREW_UNDEFINED_706 = 706,
  eSQF_EVENT_BREW_UNDEFINED_707 = 707,
  eSQF_EVENT_BREW_UNDEFINED_708 = 708,
  eSQF_EVENT_BREW_UNDEFINED_709 = 709,
  eSQF_EVENT_BREW_UNDEFINED_710 = 710,
  eSQF_EVENT_BREW_UNDEFINED_711 = 711,
  eSQF_EVENT_BREW_UNDEFINED_712 = 712,
  eSQF_EVENT_BREW_UNDEFINED_713 = 713,
  eSQF_EVENT_BREW_UNDEFINED_714 = 714,
  eSQF_EVENT_BREW_UNDEFINED_715 = 715,
  eSQF_EVENT_BREW_UNDEFINED_716 = 716,
  eSQF_EVENT_BREW_UNDEFINED_717 = 717,
  eSQF_EVENT_BREW_UNDEFINED_718 = 718,
  eSQF_EVENT_BREW_UNDEFINED_719 = 719,
  eSQF_EVENT_BREW_UNDEFINED_720 = 720,
  eSQF_EVENT_BREW_UNDEFINED_721 = 721,
  eSQF_EVENT_BREW_UNDEFINED_722 = 722,
  eSQF_EVENT_BREW_UNDEFINED_723 = 723,
  eSQF_EVENT_BREW_UNDEFINED_724 = 724,
  eSQF_EVENT_BREW_UNDEFINED_725 = 725,
  eSQF_EVENT_BREW_UNDEFINED_726 = 726,
  eSQF_EVENT_BREW_UNDEFINED_727 = 727,
  eSQF_EVENT_BREW_UNDEFINED_728 = 728,
  eSQF_EVENT_BREW_UNDEFINED_729 = 729,
  eSQF_EVENT_BREW_UNDEFINED_730 = 730,
  eSQF_EVENT_BREW_UNDEFINED_731 = 731,
  eSQF_EVENT_BREW_UNDEFINED_732 = 732,
  eSQF_EVENT_BREW_UNDEFINED_733 = 733,
  eSQF_EVENT_BREW_UNDEFINED_734 = 734,
  eSQF_EVENT_BREW_UNDEFINED_735 = 735,
  eSQF_EVENT_BREW_UNDEFINED_736 = 736,
  eSQF_EVENT_BREW_UNDEFINED_737 = 737,
  eSQF_EVENT_BREW_UNDEFINED_738 = 738,
  eSQF_EVENT_BREW_UNDEFINED_739 = 739,
  eSQF_EVENT_BREW_UNDEFINED_740 = 740,
  eSQF_EVENT_BREW_UNDEFINED_741 = 741,
  eSQF_EVENT_BREW_UNDEFINED_742 = 742,
  eSQF_EVENT_BREW_UNDEFINED_743 = 743,
  eSQF_EVENT_BREW_UNDEFINED_744 = 744,
  eSQF_EVENT_BREW_UNDEFINED_745 = 745,
  eSQF_EVENT_BREW_UNDEFINED_746 = 746,
  eSQF_EVENT_BREW_UNDEFINED_747 = 747,
  eSQF_EVENT_BREW_UNDEFINED_748 = 748,
  eSQF_EVENT_BREW_UNDEFINED_749 = 749,
  eSQF_EVENT_BREW_UNDEFINED_750 = 750,
  eSQF_EVENT_BREW_UNDEFINED_751 = 751,
  eSQF_EVENT_BREW_UNDEFINED_752 = 752,
  eSQF_EVENT_BREW_UNDEFINED_753 = 753,
  eSQF_EVENT_BREW_UNDEFINED_754 = 754,
  eSQF_EVENT_BREW_UNDEFINED_755 = 755,
  eSQF_EVENT_BREW_UNDEFINED_756 = 756,
  eSQF_EVENT_BREW_UNDEFINED_757 = 757,
  eSQF_EVENT_BREW_UNDEFINED_758 = 758,
  eSQF_EVENT_BREW_UNDEFINED_759 = 759,
  eSQF_EVENT_BREW_UNDEFINED_760 = 760,
  eSQF_EVENT_BREW_UNDEFINED_761 = 761,
  eSQF_EVENT_BREW_UNDEFINED_762 = 762,
  eSQF_EVENT_BREW_UNDEFINED_763 = 763,
  eSQF_EVENT_BREW_UNDEFINED_764 = 764,
  eSQF_EVENT_BREW_UNDEFINED_765 = 765,
  eSQF_EVENT_BREW_UNDEFINED_766 = 766,
  eSQF_EVENT_BREW_UNDEFINED_767 = 767,
  eSQF_EVENT_BREW_UNDEFINED_768 = 768,
  eSQF_EVENT_BREW_UNDEFINED_769 = 769,
  eSQF_EVENT_BREW_UNDEFINED_770 = 770,
  eSQF_EVENT_BREW_UNDEFINED_771 = 771,
  eSQF_EVENT_BREW_UNDEFINED_772 = 772,
  eSQF_EVENT_BREW_UNDEFINED_773 = 773,
  eSQF_EVENT_BREW_UNDEFINED_774 = 774,
  eSQF_EVENT_BREW_UNDEFINED_775 = 775,
  eSQF_EVENT_BREW_UNDEFINED_776 = 776,
  eSQF_EVENT_BREW_UNDEFINED_777 = 777,
  eSQF_EVENT_BREW_UNDEFINED_778 = 778,
  eSQF_EVENT_BREW_UNDEFINED_779 = 779,
  eSQF_EVENT_BREW_UNDEFINED_780 = 780,
  eSQF_EVENT_BREW_UNDEFINED_781 = 781,
  eSQF_EVENT_BREW_UNDEFINED_782 = 782,
  eSQF_EVENT_BREW_UNDEFINED_783 = 783,
  eSQF_EVENT_BREW_UNDEFINED_784 = 784,
  eSQF_EVENT_BREW_UNDEFINED_785 = 785,
  eSQF_EVENT_BREW_UNDEFINED_786 = 786,
  eSQF_EVENT_BREW_UNDEFINED_787 = 787,
  eSQF_EVENT_BREW_UNDEFINED_788 = 788,
  eSQF_EVENT_BREW_UNDEFINED_789 = 789,
  eSQF_EVENT_BREW_UNDEFINED_790 = 790,
  eSQF_EVENT_BREW_UNDEFINED_791 = 791,
  eSQF_EVENT_BREW_UNDEFINED_792 = 792,
  eSQF_EVENT_BREW_UNDEFINED_793 = 793,
  eSQF_EVENT_BREW_UNDEFINED_794 = 794,
  eSQF_EVENT_BREW_UNDEFINED_795 = 795,
  eSQF_EVENT_BREW_UNDEFINED_796 = 796,
  eSQF_EVENT_BREW_UNDEFINED_797 = 797,
  eSQF_EVENT_BREW_UNDEFINED_798 = 798,
  eSQF_EVENT_BREW_UNDEFINED_799 = 799,
  eSQF_EVENT_BREW_UNDEFINED_800 = 800,
  eSQF_EVENT_BREW_UNDEFINED_801 = 801,
  eSQF_EVENT_BREW_UNDEFINED_802 = 802,
  eSQF_EVENT_BREW_UNDEFINED_803 = 803,
  eSQF_EVENT_BREW_UNDEFINED_804 = 804,
  eSQF_EVENT_BREW_UNDEFINED_805 = 805,
  eSQF_EVENT_BREW_UNDEFINED_806 = 806,
  eSQF_EVENT_BREW_UNDEFINED_807 = 807,
  eSQF_EVENT_BREW_UNDEFINED_808 = 808,
  eSQF_EVENT_BREW_UNDEFINED_809 = 809,
  eSQF_EVENT_BREW_UNDEFINED_810 = 810,
  eSQF_EVENT_BREW_UNDEFINED_811 = 811,
  eSQF_EVENT_BREW_UNDEFINED_812 = 812,
  eSQF_EVENT_BREW_UNDEFINED_813 = 813,
  eSQF_EVENT_BREW_UNDEFINED_814 = 814,
  eSQF_EVENT_BREW_UNDEFINED_815 = 815,
  eSQF_EVENT_BREW_UNDEFINED_816 = 816,
  eSQF_EVENT_BREW_UNDEFINED_817 = 817,
  eSQF_EVENT_BREW_UNDEFINED_818 = 818,
  eSQF_EVENT_BREW_UNDEFINED_819 = 819,
  eSQF_EVENT_BREW_UNDEFINED_820 = 820,
  eSQF_EVENT_BREW_UNDEFINED_821 = 821,
  eSQF_EVENT_BREW_UNDEFINED_822 = 822,
  eSQF_EVENT_BREW_UNDEFINED_823 = 823,
  eSQF_EVENT_BREW_UNDEFINED_824 = 824,
  eSQF_EVENT_BREW_UNDEFINED_825 = 825,
  eSQF_EVENT_BREW_UNDEFINED_826 = 826,
  eSQF_EVENT_BREW_UNDEFINED_827 = 827,
  eSQF_EVENT_BREW_UNDEFINED_828 = 828,
  eSQF_EVENT_BREW_UNDEFINED_829 = 829,
  eSQF_EVENT_BREW_UNDEFINED_830 = 830,
  eSQF_EVENT_BREW_UNDEFINED_831 = 831,
  eSQF_EVENT_BREW_UNDEFINED_832 = 832,
  eSQF_EVENT_BREW_UNDEFINED_833 = 833,
  eSQF_EVENT_BREW_UNDEFINED_834 = 834,
  eSQF_EVENT_BREW_UNDEFINED_835 = 835,
  eSQF_EVENT_BREW_UNDEFINED_836 = 836,
  eSQF_EVENT_BREW_UNDEFINED_837 = 837,
  eSQF_EVENT_BREW_UNDEFINED_838 = 838,
  eSQF_EVENT_BREW_UNDEFINED_839 = 839,
  eSQF_EVENT_BREW_UNDEFINED_840 = 840,
  eSQF_EVENT_BREW_UNDEFINED_841 = 841,
  eSQF_EVENT_BREW_UNDEFINED_842 = 842,
  eSQF_EVENT_BREW_UNDEFINED_843 = 843,
  eSQF_EVENT_BREW_UNDEFINED_844 = 844,
  eSQF_EVENT_BREW_UNDEFINED_845 = 845,
  eSQF_EVENT_BREW_UNDEFINED_846 = 846,
  eSQF_EVENT_BREW_UNDEFINED_847 = 847,
  eSQF_EVENT_BREW_UNDEFINED_848 = 848,
  eSQF_EVENT_BREW_UNDEFINED_849 = 849,
  eSQF_EVENT_BREW_UNDEFINED_850 = 850,
  eSQF_EVENT_BREW_UNDEFINED_851 = 851,
  eSQF_EVENT_BREW_UNDEFINED_852 = 852,
  eSQF_EVENT_BREW_UNDEFINED_853 = 853,
  eSQF_EVENT_BREW_UNDEFINED_854 = 854,
  eSQF_EVENT_BREW_UNDEFINED_855 = 855,
  eSQF_EVENT_BREW_UNDEFINED_856 = 856,
  eSQF_EVENT_BREW_UNDEFINED_857 = 857,
  eSQF_EVENT_BREW_UNDEFINED_858 = 858,
  eSQF_EVENT_BREW_UNDEFINED_859 = 859,
  eSQF_EVENT_BREW_UNDEFINED_860 = 860,
  eSQF_EVENT_BREW_UNDEFINED_861 = 861,
  eSQF_EVENT_BREW_UNDEFINED_862 = 862,
  eSQF_EVENT_BREW_UNDEFINED_863 = 863,
  eSQF_EVENT_BREW_UNDEFINED_864 = 864,
  eSQF_EVENT_BREW_UNDEFINED_865 = 865,
  eSQF_EVENT_BREW_UNDEFINED_866 = 866,
  eSQF_EVENT_BREW_UNDEFINED_867 = 867,
  eSQF_EVENT_BREW_UNDEFINED_868 = 868,
  eSQF_EVENT_BREW_UNDEFINED_869 = 869,
  eSQF_EVENT_BREW_UNDEFINED_870 = 870,
  eSQF_EVENT_BREW_UNDEFINED_871 = 871,
  eSQF_EVENT_BREW_UNDEFINED_872 = 872,
  eSQF_EVENT_BREW_UNDEFINED_873 = 873,
  eSQF_EVENT_BREW_UNDEFINED_874 = 874,
  eSQF_EVENT_BREW_UNDEFINED_875 = 875,
  eSQF_EVENT_BREW_UNDEFINED_876 = 876,
  eSQF_EVENT_BREW_UNDEFINED_877 = 877,
  eSQF_EVENT_BREW_UNDEFINED_878 = 878,
  eSQF_EVENT_BREW_UNDEFINED_879 = 879,
  eSQF_EVENT_BREW_UNDEFINED_880 = 880,
  eSQF_EVENT_BREW_UNDEFINED_881 = 881,
  eSQF_EVENT_BREW_UNDEFINED_882 = 882,
  eSQF_EVENT_BREW_UNDEFINED_883 = 883,
  eSQF_EVENT_BREW_UNDEFINED_884 = 884,
  eSQF_EVENT_BREW_UNDEFINED_885 = 885,
  eSQF_EVENT_BREW_UNDEFINED_886 = 886,
  eSQF_EVENT_BREW_UNDEFINED_887 = 887,
  eSQF_EVENT_BREW_UNDEFINED_888 = 888,
  eSQF_EVENT_BREW_UNDEFINED_889 = 889,
  eSQF_EVENT_BREW_UNDEFINED_890 = 890,
  eSQF_EVENT_BREW_UNDEFINED_891 = 891,
  eSQF_EVENT_BREW_UNDEFINED_892 = 892,
  eSQF_EVENT_BREW_UNDEFINED_893 = 893,
  eSQF_EVENT_BREW_UNDEFINED_894 = 894,
  eSQF_EVENT_BREW_UNDEFINED_895 = 895,
  eSQF_EVENT_WCDMA_PS_DATA_RATE = 896,
  eSQF_EVENT_GSM_TO_WCDMA_RESELECT_END = 897,
  eSQF_EVENT_PZID_HAI_ENABLED = 898,
  eSQF_EVENT_PZID_HAI_DISABLED = 899,
  eSQF_EVENT_GSM_TO_WCDMA_HANDOVER_START = 900,
  eSQF_EVENT_WCDMA_RRC_MODE = 901,
  eSQF_EVENT_WCDMA_L1_ACQ_SUBSTATE = 902,
  eSQF_EVENT_WCDMA_PHYCHAN_CFG_CHANGED = 903,
  eSQF_EVENT_QTV_CLIP_STARTED = 904,
  eSQF_EVENT_QTV_CLIP_ENDED = 905,
  eSQF_EVENT_QTV_SDP_PARSER_REJECT = 906,
  eSQF_EVENT_QTV_CLIP_PAUSE = 907,
  eSQF_EVENT_QTV_CLIP_REPOSITIONING = 908,
  eSQF_EVENT_QTV_CLIP_ZOOM_IN = 909,
  eSQF_EVENT_QTV_CLIP_ZOOM_OUT = 910,
  eSQF_EVENT_QTV_CLIP_ROTATE = 911,
  eSQF_EVENT_QTV_CLIP_PAUSE_RESUME = 912,
  eSQF_EVENT_QTV_CLIP_REPOSITION_RESUME = 913,
  eSQF_EVENT_QTV_DSP_INIT = 914,
  eSQF_EVENT_QTV_STREAMING_SERVER_URL = 915,
  eSQF_EVENT_QTV_SERVER_PORTS_USED = 916,
  eSQF_EVENT_QTV_USING_PROXY_SERVER = 917,
  eSQF_EVENT_QTV_STREAMER_STATE_IDLE = 918,
  eSQF_EVENT_QTV_STREAMER_STATE_CONNECTING = 919,
  eSQF_EVENT_QTV_STREAMER_STATE_SETTING_TRACKS = 920,
  eSQF_EVENT_QTV_STREAMER_STATE_STREAMING = 921,
  eSQF_EVENT_QTV_STREAMER_STATE_PAUSED = 922,
  eSQF_EVENT_QTV_STREAMER_STATE_SUSPENDED = 923,
  eSQF_EVENT_QTV_STREAMER_CONNECTED = 924,
  eSQF_EVENT_QTV_STREAMER_INITSTREAM_FAIL = 925,
  eSQF_EVENT_QTV_BUFFERING_STARTED = 926,
  eSQF_EVENT_QTV_BUFFERING_ENDED = 927,
  eSQF_EVENT_QTV_CLIP_FULLSCREEN = 928,
  eSQF_EVENT_QTV_PS_DOWNLOAD_STARTED = 929,
  eSQF_EVENT_QTV_PSEUDO_STREAM_STARTED = 930,
  eSQF_EVENT_QTV_PS_PLAYER_STATE_PSEUDO_PAUSE = 931,
  eSQF_EVENT_QTV_PS_PLAYER_STATE_PSEUDO_RESUME = 932,
  eSQF_EVENT_QTV_PARSER_STATE_READY = 933,
  eSQF_EVENT_QTV_FRAGMENT_PLAYBACK_BEGIN = 934,
  eSQF_EVENT_QTV_FRAGMENT_PLAYBACK_COMPLETE = 935,
  eSQF_EVENT_QTV_PARSER_STATE_PSEUDO_PAUSE = 936,
  eSQF_EVENT_QTV_PLAYER_STATE_PSEUDO_PAUSE = 937,
  eSQF_EVENT_QTV_PARSER_STATE_PSEUDO_RESUME = 938,
  eSQF_EVENT_QTV_PLAYER_STATE_PSEUDO_RESUME = 939,
  eSQF_EVENT_QTV_FRAGMENTED_FILE_DECODE_START = 940,
  eSQF_EVENT_QTV_FRAGMENTED_FILE_END_SUCCESS = 941,
  eSQF_EVENT_QTV_DOWNLOAD_DATA_REPORT = 942,
  eSQF_EVENT_QTV_VDEC_DIAG_DECODE_CALLBACK = 943,
  eSQF_EVENT_QTV_URL_PLAYED_IS_MULTICAST = 944,
  eSQF_EVENT_QTV_VDEC_DIAG_STATUS = 945,
  eSQF_EVENT_QTV_STREAMING_URL_OPEN = 946,
  eSQF_EVENT_QTV_STREAMING_URL_OPENING = 947,
  eSQF_EVENT_QTV_CLIP_ENDED_VER2 = 948,
  eSQF_EVENT_QTV_SILENCE_INSERTION_STARTED = 949,
  eSQF_EVENT_QTV_SILENCE_INSERTION_ENDED = 950,
  eSQF_EVENT_QTV_AUDIO_CHANNEL_SWITCH_FRAME = 951,
  eSQF_EVENT_QTV_FIRST_VIDEO_FRAME_RENDERED = 952,
  eSQF_EVENT_QTV_FIRST_VIDEO_I_FRAME_RENDERED = 953,
  eSQF_EVENT_QTV_SDP_SELECTED = 954,
  eSQF_EVENT_QTV_DIAG_PLAYER_STATUS = 955,
  eSQF_EVENT_QTV_SILENCE_INSERTION_DURATION = 956,
  eSQF_EVENT_QTV_UNDEFINED_957 = 957,
  eSQF_EVENT_QTV_UNDEFINED_958 = 958,
  eSQF_EVENT_QTV_UNDEFINED_959 = 959,
  eSQF_EVENT_QTV_UNDEFINED_960 = 960,
  eSQF_EVENT_QTV_UNDEFINED_961 = 961,
  eSQF_EVENT_QTV_UNDEFINED_962 = 962,
  eSQF_EVENT_QTV_UNDEFINED_963 = 963,
  eSQF_EVENT_QTV_UNDEFINED_964 = 964,
  eSQF_EVENT_QTV_UNDEFINED_965 = 965,
  eSQF_EVENT_QTV_UNDEFINED_966 = 966,
  eSQF_EVENT_QTV_UNDEFINED_967 = 967,
  eSQF_EVENT_DS_SETS_ARM_CLOCK_FASTER = 968,
  eSQF_EVENT_DS_SETS_ARM_CLOCK_SLOWER = 969,
  eSQF_EVENT_SMS_STATISTICS = 970,
  eSQF_EVENT_SM_PDP_STATE = 971,
  eSQF_EVENT_MVS_STATE = 972,
  eSQF_EVENT_SECSSL = 973,
  eSQF_EVENT_SECTEST = 974,
  eSQF_EVENT_SECVPN = 975,
  eSQF_EVENT_SECCRYPT = 976,
  eSQF_EVENT_SECCRYPT_CMD = 977,
  eSQF_EVENT_SEC_RESERVED_978 = 978,
  eSQF_EVENT_SEC_RESERVED_979 = 979,
  eSQF_EVENT_SEC_RESERVED_980 = 980,
  eSQF_EVENT_SEC_RESERVED_981 = 981,
  eSQF_EVENT_ARM_CLK_FREQUENCY_CHANGE = 982,
  eSQF_EVENT_ADSP_CLK_FREQUENCY_CHANGE = 983,
  eSQF_EVENT_MDSP_CLK_FREQUENCY_CHANGE = 984,
  eSQF_EVENT_CELL_CHANGE_INDICATION = 985,
  eSQF_EVENT_CB_STATE_CHANGE = 986,
  eSQF_EVENT_SMSCB_L1_STATE_CHANGE = 987,
  eSQF_EVENT_SMSCB_L1_COLLISION = 988,
  eSQF_EVENT_WMS_SEARCH_REQUEST = 989,
  eSQF_EVENT_CM_GET_PASSWORD_IND = 990,
  eSQF_EVENT_CM_PASSWORD_AUTHENTICATION_STATUS = 991,
  eSQF_EVENT_CM_USS_RESPONSE_NOTIFY_IND = 992,
  eSQF_EVENT_CM_USS_CONF = 993,
  eSQF_EVENT_CM_RELEASE_USS_IND = 994,
  eSQF_EVENT_CM_FWD_AOC_IND = 995,
  eSQF_EVENT_PZID_ID = 996,
  eSQF_EVENT_PZID_HT_VALUE = 997,
  eSQF_EVENT_PZID_EXISTS_IN_LIST = 998,
  eSQF_EVENT_GSDI_GET_FILE_ATTRIBUTES = 999,
  eSQF_EVENT_GSDI_SIM_READ = 1000,
  eSQF_EVENT_GSDI_SIM_WRITE = 1001,
  eSQF_EVENT_GSDI_GET_PIN_STATUS = 1002,
  eSQF_EVENT_GSDI_VERIFY_PIN = 1003,
  eSQF_EVENT_GSDI_UNBLOCK_PIN = 1004,
  eSQF_EVENT_GSDI_DISABLE_PIN = 1005,
  eSQF_EVENT_GSDI_ENABLE_PIN = 1006,
  eSQF_EVENT_GSDI_SIM_INCREASE = 1007,
  eSQF_EVENT_GSDI_EXECUTE_APDU_REQ = 1008,
  eSQF_EVENT_SEG_UPM_ADDR_MISMATCH = 1009,
  eSQF_EVENT_WCDMA_PRACH = 1010,
  eSQF_EVENT_GSDI_SELECT = 1011,
  eSQF_EVENT_WCDMA_RAB_RATE_RECONFIG = 1012,
  eSQF_EVENT_WCDMA_RLC_RESETS = 1013,
  eSQF_EVENT_WCDMA_RLC_OPEN_CLOSE = 1014,
  eSQF_EVENT_WCDMA_RLC_MRW = 1015,
  eSQF_EVENT_QVP_APP_PROCESS_EVENT = 1016,
  eSQF_EVENT_QVP_APP_STATE_CHANGED_EVENT = 1017,
  eSQF_EVENT_QVP_APP_CALL_CONNECTED_EVENT = 1018,
  eSQF_EVENT_GSDI_CARD_EVENT_NOTIFICATION = 1019,
  eSQF_EVENT_CM_DATA_AVAILABLE = 1020,
  eSQF_EVENT_CM_DS_INTERRAT_STATE = 1021,
  eSQF_EVENT_MM_STATE = 1022,
  eSQF_EVENT_GMM_STATE = 1023,
  eSQF_EVENT_PLMN_INFORMATION = 1024,
  eSQF_EVENT_COREAPP_SET_VOICE_PRIVACY = 1025,
  eSQF_EVENT_COREAPP_GET_VOICE_PRIVACY = 1026,
  eSQF_EVENT_HARD_HANDOFF_LONG_CODE_MASK_CHANGE = 1027,
  eSQF_EVENT_VCTCXO_FREEZE = 1028,
  eSQF_EVENT_VCTCXO_UNFREEZE = 1029,
  eSQF_EVENT_SMS_SLOT_WAKEUP_V2 = 1030,
  eSQF_EVENT_QVP_RCVD_FIRST_VIDEO_FRAME = 1031,
  eSQF_EVENT_QVP_CALL_RELEASED = 1032,
  eSQF_EVENT_CB_SMS_NOTIFY = 1033,
  eSQF_EVENT_GPS_PDSM_EVENT_REPORT = 1034,
  eSQF_EVENT_LONG_CODE_MASK_CHANGED = 1035,
  eSQF_EVENT_DS707 = 1036,
  eSQF_EVENT_GSDI_ACTIVATE_FEATURE_IND = 1037,
  eSQF_EVENT_GSDI_DEACTIVATE_FEATURE_IND = 1038,
  eSQF_EVENT_GSDI_GET_FEATURE_IND = 1039,
  eSQF_EVENT_GSDI_SET_FEATURE_DATA = 1040,
  eSQF_EVENT_GSDI_UNBLOCK_FEATURE_IND = 1041,
  eSQF_EVENT_GSDI_GET_CONTROL_KEY = 1042,
  eSQF_EVENT_GSDI_OTA_DEPERSO = 1043,
  eSQF_EVENT_GSDI_GET_PERM_FEATURE_IND = 1044,
  eSQF_EVENT_GSDI_PERM_DISBALE_FEATURE_IND = 1045,
  eSQF_EVENT_GSM_L1_VOCODER_INITIALIZE = 1046,
  eSQF_EVENT_GSM_L1_ALIGN_VFR = 1047,
  eSQF_EVENT_GSM_L1_VOCODER_ENABLED = 1048,
  eSQF_EVENT_HDR_AMAC_PERSISTENCE_FAILED = 1049,
  eSQF_EVENT_HDR_AMAC_PERSISTENCE_PASSED = 1050,
  eSQF_EVENT_MFLO_STREAM_STATE = 1051,
  eSQF_EVENT_MFLO_CONTROL_CHANNEL_STATE_CHANGE = 1052,
  eSQF_EVENT_MFLO_SLEEP_STATE_CHANGE = 1053,
  eSQF_EVENT_MFLO_NETWORK_STATE_CHANGE = 1054,
  eSQF_EVENT_MFLO_TRANS_STATE = 1055,
  eSQF_EVENT_MFLO_OIS_STATE = 1056,
  eSQF_EVENT_MFLO_RXD_STATE = 1057,
  eSQF_EVENT_MFLO_HIPRI_STATE_CHANGE = 1058,
  eSQF_EVENT_MFLO_CAS_STATE = 1059,
  eSQF_EVENT_MFLO_ACQ_STATE = 1060,
  eSQF_EVENT_MFLO_OSCAR_FRAME_DECODED = 1061,
  eSQF_EVENT_MFLO_CHAN_SWITCH_RENDERED = 1062,
  eSQF_EVENT_MFLO_OSCAR_DEC_EXCEPTION_DETECTED = 1063,
  eSQF_EVENT_MFLO_MFN_SUBSTATE = 1064,
  eSQF_EVENT_MFLO_MFN_STATE = 1065,
  eSQF_EVENT_MFLO_MFN_VERTICAL_HANDOFF = 1066,
  eSQF_EVENT_MFLO_MFN_ACQ_STATE = 1067,
  eSQF_EVENT_MFLO_FLOW_STATUS = 1068,
  eSQF_EVENT_MFLO_NETWORK_STATUS = 1069,
  eSQF_EVENT_CM_LCS_MOLR_CONF = 1071,
  eSQF_EVENT_PPP_NETMODEL = 1072,
  eSQF_EVENT_CAMERA_PROFILING = 1073,
  eSQF_EVENT_MAC_HS_T1_EXPIRY = 1074,
  eSQF_EVENT_ASYNC_DS707 = 1075,
  eSQF_EVENT_PKT_DS707 = 1076,
  eSQF_EVENT_GPRS_TIMER_EXPIRY = 1077,
  eSQF_EVENT_GPRS_MAC_IDLE_IND = 1078,
  eSQF_EVENT_GPRS_PACKET_CHANNEL_REQUEST = 1079,
  eSQF_EVENT_GPRS_ACCESS_REJECT = 1080,
  eSQF_EVENT_GPRS_PACKET_RESOURCE_REQUEST = 1081,
  eSQF_EVENT_GPRS_PACKET_UPLINK_ASSIGNMENT = 1082,
  eSQF_EVENT_GPRS_PACKET_DOWNLINK_ASSIGNMENT = 1083,
  eSQF_EVENT_PACKET_TIMESLOT_RECONFIGURE = 1084,
  eSQF_EVENT_GPRS_TBF_RELEASE = 1085,
  eSQF_EVENT_GPRS_CELL_CHANGE_ORDER = 1086,
  eSQF_EVENT_GPRS_CELL_CHANGE_FAILURE = 1087,
  eSQF_EVENT_GSM_AMR_RATSCCH_REQ = 1088,
  eSQF_EVENT_GSM_AMR_RATSCCH_RSP = 1089,
  eSQF_EVENT_SD_SRV_IND_HYBR_WLAN = 1090,
  eSQF_EVENT_SD_EVENT_ACTION_HYBR_WLAN = 1091,
  eSQF_EVENT_GPS_PD_DEMOD_SESS_START = 1092,
  eSQF_EVENT_GPS_PD_DEMOD_SESS_END = 1093,
  eSQF_EVENT_GPS_SV_ACQUIRED = 1094,
  eSQF_EVENT_GPS_SV_BIT_EDGE_FOUND = 1095,
  eSQF_EVENT_GPS_DEMOD_STARTED = 1096,
  eSQF_EVENT_GPS_DEMOD_OUT_OF_LOCK = 1097,
  eSQF_EVENT_GPS_DEMOD_STOPPED = 1098,
  eSQF_EVENT_GPS_DEMOD_PREAMBLE_FOUND = 1099,
  eSQF_EVENT_GPS_DEMOD_FRAME_SYNC_STATUS = 1100,
  eSQF_EVENT_GPS_DEMOD_SUBFRAME = 1101,
  eSQF_EVENT_GPS_DEMOD_EPHEMERIS_COMPLETE = 1102,
  eSQF_EVENT_GPS_DEMOD_ALMANAC_COMPLETE = 1103,
  eSQF_EVENT_GPS_DEMOD_BIT_EDGE_STATUS = 1104,
  eSQF_EVENT_RAT_CHANGE = 1105,
  eSQF_EVENT_REGISTRATION_SUPPRESSED = 1106,
  eSQF_EVENT_HDR_RUP_DIST_BASED_REG = 1107,
  eSQF_EVENT_GPS_DIAG_APP_TRACKING_START = 1108,
  eSQF_EVENT_GPS_DIAG_APP_TRACKING_END = 1109,
  eSQF_EVENT_GPS_DIAG_APP_POSITION_SUCCESS = 1110,
  eSQF_EVENT_GPS_DIAG_APP_POSITION_FAILURE = 1111,
  eSQF_EVENT_GSM_AMR_MULTIRATE_IE = 1112,
  eSQF_EVENT_EPZID_HYSTERESIS_ENABLED = 1113,
  eSQF_EVENT_EPZID_HYSTERESIS_DISABLED = 1114,
  eSQF_EVENT_EPZID_HT_STARTED = 1115,
  eSQF_EVENT_EPZID_HT_EXPIRED = 1116,
  eSQF_EVENT_HDR_BCMCS_FLOW_STATE_CHANGE = 1117,
  eSQF_EVENT_HDR_LMAC_UPDATE_BC_STATUS = 1118,
  eSQF_EVENT_DS_CAM_TIMER = 1119,
  eSQF_EVENT_DS_RDUD_TIMER = 1120,
  eSQF_EVENT_DS_CTA_TIMER = 1121,
  eSQF_EVENT_DS_FALLBACK = 1122,
  eSQF_EVENT_DS3G_CAM_FLOW_CTRL_TIMER = 1123,
  eSQF_EVENT_GPS_JAMMER_DETECTION_TEST_PASS = 1124,
  eSQF_EVENT_GPS_JAMMER_DETECTION_TEST_FAILURE = 1125,
  eSQF_EVENT_JAMMER_DETECT_NOISE_STATS = 1126,
  eSQF_EVENT_GPS_GET_PARAM = 1127,
  eSQF_EVENT_GPS_GET_PARAM_BS_INFO = 1128,
  eSQF_EVENT_HS_SERVING_CELL_CHANGE = 1129,
  eSQF_EVENT_HS_DSCH_STATUS = 1130,
  eSQF_EVENT_SMGMM_REQUEST_SENT = 1131,
  eSQF_EVENT_SMGMM_REJECT_RECEIVED = 1132,
  eSQF_EVENT_LINUX_APP_STOP = 1133,
  eSQF_EVENT_GPS_PD_CME_SESSION_START = 1134,
  eSQF_EVENT_GPS_PD_CME_SESSION_END = 1135,
  eSQF_EVENT_SIP_REGISTER_START = 1136,
  eSQF_EVENT_SIP_REGISTER_DONE = 1137,
  eSQF_EVENT_SIP_CALL_SETUP_START = 1138,
  eSQF_EVENT_SIP_CALL_SETUP_DONE = 1139,
  eSQF_EVENT_SIP_CALL_RELEASE_START = 1140,
  eSQF_EVENT_SIP_CALL_RELEASE_DONE = 1141,
  eSQF_EVENT_AUDIO_FRAME_SENT_TO_DECODER = 1142,
  eSQF_EVENT_VIDEO_FRAME_SENT_TO_DECODER = 1143,
  eSQF_EVENT_DEC_RENDER_FRAME = 1144,
  eSQF_EVENT_DEC_RENDER_DONE = 1145,
  eSQF_EVENT_DEC_START_DECODING = 1146,
  eSQF_EVENT_DEC_FRAME_DECODED = 1147,
  eSQF_EVENT_V_ENCODED = 1148,
  eSQF_EVENT_DEC_START_DECODING_EXT = 1149,
  eSQF_EVENT_DEC_FRAME_DECODED_EXT = 1150,
  eSQF_EVENT_GPS_CME_POS_REQ = 1156,
  eSQF_EVENT_GPS_CME_FIX_START = 1157,
  eSQF_EVENT_GPS_CME_FIX_END = 1158,
  eSQF_EVENT_GPS_SEED_CLM = 1159,
  eSQF_EVENT_GPS_SEED_SID = 1160,
  eSQF_EVENT_GPS_SEED_SL = 1161,
  eSQF_EVENT_GPS_SEED_GET = 1162,
  eSQF_EVENT_HDR_OVHD_BC_MSG_RX = 1163,
  eSQF_EVENT_HDR_OVHD_T_BC_SUPERVISION = 1164,
  eSQF_EVENT_HDR_LMAC_SET_BCMCS_PAGE_CYCLE = 1165,
  eSQF_EVENT_HDR_HMP_SESSION_CLOSED = 1166,
  eSQF_EVENT_WLAN_CP = 1167,
  eSQF_EVENT_ARP = 1168,
  eSQF_EVENT_DHCP = 1169,
  eSQF_EVENT_WLAN_WPA = 1170,
  eSQF_EVENT_EAP = 1171,
  eSQF_EVENT_LAN_1X = 1172,
  eSQF_EVENT_CAMERA_SVCS_START = 1173,
  eSQF_EVENT_CAMERA_SVCS_STOP = 1174,
  eSQF_EVENT_BCMCS_SRVC_AVAILABLE = 1175,
  eSQF_EVENT_BCMCS_SRVC_LOST = 1176,
  eSQF_EVENT_BCMCS_FLOW_REGISTERED = 1177,
  eSQF_EVENT_BCMCS_FLOW_DEREGISTERED = 1178,
  eSQF_EVENT_BCMCS_FLOW_STATUS_CHANGED = 1179,
  eSQF_EVENT_CAMERA_SVCS_X = 1180,
  eSQF_EVENT_CM_CALL_EVENT_ORIG_THR = 1181,
  eSQF_EVENT_VFE_MSG_CONFIG_COMPLETE = 1182,
  eSQF_EVENT_VFE_MSG_IDLE_COMPLETE = 1183,
  eSQF_EVENT_VFE_MSG_UPDATE_COMPLETE = 1184,
  eSQF_EVENT_VFE_MSG_AE_AWB_STATS = 1185,
  eSQF_EVENT_DSP_VIDEO_ENC_DOWNLOAD_DONE = 1186,
  eSQF_EVENT_DSP_VIDEO_ENC_SELECTION_DONE = 1187,
  eSQF_EVENT_DSP_VIDEO_ENC_CONFIG_DONE = 1188,
  eSQF_EVENT_DSP_VIDEO_ENC_FRAME_DONE = 1189,
  eSQF_EVENT_HDR_OVHD_BCMCS_CHAN_CHANGE = 1190,
  eSQF_EVENT_QVS_REGISTER_START = 1191,
  eSQF_EVENT_QVS_REGISTER_DONE = 1192,
  eSQF_EVENT_QVS_REGISTER_FAILED = 1193,
  eSQF_EVENT_QVS_CALL_SETUP_START = 1194,
  eSQF_EVENT_QVS_CALL_SETUP_DONE = 1195,
  eSQF_EVENT_QVS_CALL_SETUP_FAILED = 1196,
  eSQF_EVENT_QVS_CALL_RELEASE_START = 1197,
  eSQF_EVENT_QVS_CALL_RELEASE_DONE = 1198,
  eSQF_EVENT_QVS_CALL_RELEASE_FAILED = 1199,
  eSQF_EVENT_CAMCORDER_START_RECORD = 1200,
  eSQF_EVENT_CAMCORDER_START_TRANSCODE = 1201,
  eSQF_EVENT_CAMCORDER_FRAME_DROP = 1202,
  eSQF_EVENT_CAMCORDER_AUDIODUB = 1203,
  eSQF_EVENT_PSMM_SENT = 1204,
  eSQF_EVENT_GPS_PD_FALLBACK_MODE = 1205,
  eSQF_EVENT_PEAP = 1206,
  eSQF_EVENT_TTLS = 1207,
  eSQF_EVENT_TLS = 1208,
  eSQF_EVENT_WCDMA_TO_WCDMA_RESELECTION_VER2_START = 1209,
  eSQF_EVENT_EUL_RECONFIG_OR_ASU = 1210,
  eSQF_EVENT_EUL_SERVING_CELL_CHANGE = 1211,
  eSQF_EVENT_EUL_PHYSICAL_LAYER_RECONFIG = 1212,
  eSQF_EVENT_DRM_ROAP_TRIGGER_RECEIVED = 1213,
  eSQF_EVENT_DRM_ROAP_PROTOCOL_START = 1214,
  eSQF_EVENT_DRM_ROAP_REQUEST = 1215,
  eSQF_EVENT_DRM_ROAP_REQUEST_EXTENSION = 1216,
  eSQF_EVENT_DRM_ROAP_RESPONSE = 1217,
  eSQF_EVENT_DRM_ROAP_RESPONSE_EXTENSION = 1218,
  eSQF_EVENT_DRM_ROAP_RI_CONTEXT = 1219,
  eSQF_EVENT_DRM_ROAP_ERROR = 1220,
  eSQF_EVENT_DRM_ROAP_RSP_VALIDATION = 1221,
  eSQF_EVENT_DRM_ROAP_PROTOCOL_END = 1222,
  eSQF_EVENT_DS_WMK_ALLOCATED = 1223,
  eSQF_EVENT_DS_WMK_DEALLOCATED = 1224,
  eSQF_EVENT_DS_WMK_FLUSHED = 1225,
  eSQF_EVENT_DS_WMK_FLOW_ENABLED = 1226,
  eSQF_EVENT_DS_WMK_FLOW_DISABLED = 1227,
  eSQF_EVENT_HDR_IDLE_SET_SLEEP_DURATION = 1228,
  eSQF_EVENT_HDR_SCM_SESSION_CHANGED = 1229,
  eSQF_EVENT_UMTS_TO_CDMA_DATA_HANDOVER = 1230,
  eSQF_EVENT_UMTS_TO_CDMA_VOICE_HANDOVER = 1231,
  eSQF_EVENT_MO_SMS_RETRY_ATTEMPT = 1232,
  eSQF_EVENT_HDR_LMAC_UPDATE_QSM_STATUS = 1233,
  eSQF_EVENT_CM_CELL_SRV_IND = 1234,
  eSQF_EVENT_RLP_NAK_ABORT = 1235,
  eSQF_EVENT_DRM_RIGHTS_OPERATION = 1236,
  eSQF_EVENT_DS_RESV_MSG_SENT_REV_FLOWS = 1237,
  eSQF_EVENT_DS_RESV_MSG_SENT_FWD_FLOWS = 1238,
  eSQF_EVENT_DS_RESV_RESP_SUCCESS_RECD = 1239,
  eSQF_EVENT_DS_RESV_RESP_FAILURE_RECD = 1240,
  eSQF_EVENT_GPS_PD_COMM_FAILURE = 1241,
  eSQF_EVENT_GPS_PD_COMM_DONE = 1242,
  eSQF_EVENT_GPS_PD_EVENT_END = 1243,
  eSQF_EVENT_GPS_PA_EVENT_CALLBACK = 1244,
  eSQF_EVENT_GPS_PD_CMD_ERR_CALLBACK = 1245,
  eSQF_EVENT_GPS_PA_CMD_ERR_CALLBACK = 1246,
  eSQF_EVENT_GPS_LM_ENTER_SA_RF_VERIF = 1247,
  eSQF_EVENT_GPS_LM_EXIT_SA_RF_VERIF = 1248,
  eSQF_EVENT_GPS_LM_ERROR_SA_RF_VERIF = 1249,
  eSQF_EVENT_GPS_LM_PD_COMPLETE = 1250,
  eSQF_EVENT_GPS_LM_IQ_TEST_COMPLETE = 1251,
  eSQF_EVENT_PM_APP_OTG_INIT = 1252,
  eSQF_EVENT_PM_APP_OTG_RESET = 1253,
  eSQF_EVENT_PM_APP_OTG_ACQUIRE_BUS_REQ = 1254,
  eSQF_EVENT_PM_APP_OTG_RELINQUISH_BUS_REQ = 1255,
  eSQF_EVENT_PM_APP_OTG_SUSPEND = 1256,
  eSQF_EVENT_PM_APP_OTG_RESUME = 1257,
  eSQF_EVENT_PM_APP_OTG_DEVICE_ATTACHED = 1258,
  eSQF_EVENT_PM_APP_OTG_DEVICE_DETACHED = 1259,
  eSQF_EVENT_PM_APP_OTG_HOST_MODE_REM_PERI_DIS = 1260,
  eSQF_EVENT_PM_APP_OTG_PERI_MODE_PREPARE_FOR_REM_HOST_WAKEUP_SIG = 1261,
  eSQF_EVENT_PM_APP_OTG_PERI_MODE_REM_HOST_WAKEUP_SIG_DONE = 1262,
  eSQF_EVENT_PM_APP_OTG_SET_REM_WAKEUP_CAPABILITY = 1263,
  eSQF_EVENT_PM_APP_OTG_OPERATIONAL_ERROR = 1264,
  eSQF_EVENT_PM_APP_OTG_CONFIGURE_USB_POWER_CONSUMER = 1265,
  eSQF_EVENT_PM_APP_OTG_SET_USB_POWER_CONSUMPTION_REQUIREMENT = 1266,
  eSQF_EVENT_PM_APP_OTG_PERI_MODE_PROCESS_USB_POWER_LINE_CONT_REQ = 1267,
  eSQF_EVENT_PM_APP_OTG_PERI_MODE_SET_REM_A_DEV_INFO = 1268,
  eSQF_EVENT_PM_APP_OTG_STATE_TRANSITION = 1269,
  eSQF_EVENT_DTV_TABLE_ACQ_SUCCESS = 1270,
  eSQF_EVENT_DTV_TABLE_ACQ_FAIL = 1271,
  eSQF_EVENT_DTV_DVBH_SEL_PLTFM_REQ_RCVD = 1272,
  eSQF_EVENT_DTV_DVBH_PLTFM_ACQ_SUCCESS = 1273,
  eSQF_EVENT_DTV_DVBH_PLTFM_ACQ_FAIL = 1274,
  eSQF_EVENT_DTV_DVBH_TBL_MGR_STATE_CHANGED = 1275,
  eSQF_EVENT_DTV_DVBH_CE_STATE_CHANGED = 1276,
  eSQF_EVENT_DTV_DVBH_MCAST_JOIN_REQ_RCVD = 1277,
  eSQF_EVENT_DTV_DVBH_MCAST_LEAVE_REQ_RCVD = 1278,
  eSQF_EVENT_DTV_DVBH_INIT_REQ_RCVD = 1279,
  eSQF_EVENT_DTV_DVBH_MCAST_JOIN_SUCCESS = 1280,
  eSQF_EVENT_DTV_DVBH_MCAST_JOIN_FAILURE = 1281,
  eSQF_EVENT_DTV_DVBH_MCAST_LEAVE_SUCCESS = 1282,
  eSQF_EVENT_DTV_DVBH_MCAST_LEAVE_FAILURE = 1283,
  eSQF_EVENT_DTV_DVBH_INIT_SUCCESS = 1284,
  eSQF_EVENT_DTV_DVBH_INIT_FAILURE = 1285,
  eSQF_EVENT_GPS_LM_SESSION_START = 1286,
  eSQF_EVENT_GPS_LM_SESSION_END = 1287,
  eSQF_EVENT_GPS_LM_FIX_REQUEST_START = 1288,
  eSQF_EVENT_GPS_LM_FIX_REQUEST_END = 1289,
  eSQF_EVENT_GPS_LM_PRM_REQUEST_START = 1290,
  eSQF_EVENT_GPS_LM_PRM_REQUEST_END = 1291,
  eSQF_EVENT_GPS_LM_SESSION_CONTINUE = 1292,
  eSQF_EVENT_GPS_LM_FIX_REQUEST_CONTINUE = 1293,
  eSQF_EVENT_GPS_LM_PRM_REQUEST_CONTINUE = 1294,
  eSQF_EVENT_GPS_LM_PPM_REQUEST_CONTINUE = 1295,
  eSQF_EVENT_GPS_LM_AIDING_DATA_RECEIVED = 1296,
  eSQF_EVENT_GPS_LM_RC_ON_TIMER_TIMEOUT = 1297,
  eSQF_EVENT_GPS_LM_SHUT_OFF_TIMER_TIMEOUT = 1298,
  eSQF_EVENT_GPS_LM_MGP_ON = 1299,
  eSQF_EVENT_GPS_LM_MGP_IDLE = 1300,
  eSQF_EVENT_GPS_LM_MGP_OFF = 1301,
  eSQF_EVENT_DRM_RO_CONSUMPTION_VALIDATION = 1302,
  eSQF_EVENT_DRM_RO_INSTALLATION_VALIDATION = 1303,
  eSQF_EVENT_FLUTE_FDT_INST_RCVD = 1304,
  eSQF_EVENT_FLUTE_FDT_INST_RCV_FAIL = 1305,
  eSQF_EVENT_FLUTE_FDT_INST_EXPIRED = 1306,
  eSQF_EVENT_FLUTE_JOIN_SESSION_REQ_RCVD = 1307,
  eSQF_EVENT_FLUTE_LEAVE_SESSION_REQ_RCVD = 1308,
  eSQF_EVENT_FLUTE_SESSION_CLOSED = 1309,
  eSQF_EVENT_FLUTE_SESSION_CLOSED_BY_APP = 1310,
  eSQF_EVENT_FLUTE_B_FLAG_RCVD = 1311,
  eSQF_EVENT_FLUTE_GET_FILE_REQUEST_RCVD = 1312,
  eSQF_EVENT_FLUTE_JOIN_SESSION_RSP = 1313,
  eSQF_EVENT_FLUTE_FILE_STATUS_RSP = 1314,
  eSQF_EVENT_FLUTE_CANCEL_FILE_REQ_RCVD = 1315,
  eSQF_EVENT_DTV_DVBH_DEINIT_REQ_RCVD = 1316,
  eSQF_EVENT_DTV_DVBH_DEINIT_SUCCESS = 1317,
  eSQF_EVENT_DTV_DVBH_DEINIT_FAILURE = 1318,
  eSQF_EVENT_CONTENT_INSTALL_BEGIN = 1319,
  eSQF_EVENT_CONTENT_INSTALL_COMPLETE = 1320,
  eSQF_EVENT_CONTENT_RETRIEVAL_BEGIN = 1321,
  eSQF_EVENT_CONTENT_RETRIEVAL_COMPLETE = 1322,
  eSQF_EVENT_CONTENT_BACKUP_BEGIN = 1323,
  eSQF_EVENT_CONTENT_BACKUP_COMPLETE = 1324,
  eSQF_EVENT_CONTENT_FWD_BEGIN = 1325,
  eSQF_EVENT_CONTENT_FWD_COMPLETE = 1326,
  eSQF_EVENT_HARD_HANDOFF_VOIP_TO_CDMA = 1327,
  eSQF_EVENT_EAP_SIM_AKA = 1328,
  eSQF_EVENT_WLAN_CP_MEAS = 1329,
  eSQF_EVENT_WLAN_CP_HO = 1330,
  eSQF_EVENT_WLAN_CP_11D = 1331,
  eSQF_EVENT_WLAN_MC = 1332,
  eSQF_EVENT_SVG_CONTENT_SET = 1333,
  eSQF_EVENT_SVG_CONTENT_PLAY = 1334,
  eSQF_EVENT_SVG_CONTENT_RESUME = 1335,
  eSQF_EVENT_SVG_CONTENT_PAUSE = 1336,
  eSQF_EVENT_SVG_CONTENT_STOP = 1337,
  eSQF_EVENT_SVG_CONTENT_USEREVENT = 1338,
  eSQF_EVENT_SVG_CONTENT_GETURIDATA = 1339,
  eSQF_EVENT_SVG_CONTENT_TRANSFORM = 1340,
  eSQF_EVENT_SVG_GET_PARAM = 1341,
  eSQF_EVENT_SVG_SET_PARAM = 1342,
  eSQF_EVENT_WLAN_WPA2 = 1343,
  eSQF_EVENT_WCDMA_PSC_SCANNER_STOP = 1344,
  eSQF_EVENT_MEDIA_PLAYER_KEYPRESS = 1345,
  eSQF_EVENT_WLAN_MC_QOS = 1346,
  eSQF_EVENT_WCDMA_PSC_SCANNER_STATE = 1347,
  eSQF_EVENT_WLAN_CP_ADHOC = 1348,
  eSQF_EVENT_DMB_STACK_SHUTDOWN = 1349,
  eSQF_EVENT_DMB_TUNE_DONE_SUCCESS = 1350,
  eSQF_EVENT_DMB_TUNE_DONE_FAILURE = 1351,
  eSQF_EVENT_DMB_SEARCH_DONE = 1352,
  eSQF_EVENT_DMB_SCAN_DONE = 1353,
  eSQF_EVENT_DMB_RECEPTION_INFO_CHANGED = 1354,
  eSQF_EVENT_DMB_DMB_GUIDE_CHANGED = 1355,
  eSQF_EVENT_DMB_LOCATION_INFO_CHANGED = 1356,
  eSQF_EVENT_DMB_LOST_ENSEMBLE = 1357,
  eSQF_EVENT_DMB_STREAM_TERMINATED = 1358,
  eSQF_EVENT_DMB_STREAM_DATA_AVAILABLE = 1359,
  eSQF_EVENT_HDR_DOS_MO_DOS_STATUS = 1375,
  eSQF_EVENT_GPSONEXTRA_START_DOWNLOAD = 1376,
  eSQF_EVENT_GPSONEXTRA_END_DOWNLOAD = 1377,
  eSQF_EVENT_SNSD_GENERIC = 1378,
  eSQF_EVENT_SNSD_DEVICE_INIT = 1379,
  eSQF_EVENT_SNSD_DEVICE_CONFIGURED = 1380,
  eSQF_EVENT_SNSD_EVENT_DATA_READY = 1381,
  eSQF_EVENT_SNSD_EVENT_COND_MET = 1382,
  eSQF_EVENT_SNSD_DEVICE_DOWN = 1383,
  eSQF_EVENT_SNSD_ERROR = 1384,
  eSQF_EVENT_CM_COUNTRY_SELECTED = 1385,
  eSQF_EVENT_CM_SELECT_COUNTRY = 1386,
  eSQF_EVENT_GPS_DCME_NEW_SV_ADDED_IN_AA = 1387,
  eSQF_EVENT_GPS_DCME_SV_REMOVED_FROM_AA = 1388,
  eSQF_EVENT_ESG_GET_PROV_LIST_REQ_RCVD = 1389,
  eSQF_EVENT_ESG_GET_PROV_LIST_REQ_FAIL = 1390,
  eSQF_EVENT_ESG_PROV_LIST_AVAILABLE = 1391,
  eSQF_EVENT_ESG_ACQ_REQ_RCVD = 1392,
  eSQF_EVENT_ESG_ACQ_REQ_FAIL = 1393,
  eSQF_EVENT_ESG_STOP_REQ_RCVD = 1394,
  eSQF_EVENT_ESG_STOP_REQ_FAIL = 1395,
  eSQF_EVENT_ESG_STOP_COMPLETE = 1396,
  eSQF_EVENT_ADC_ONDIE_THERM_READ = 1397,
  eSQF_EVENT_CONTENT_NO_VALID_OR_EXPIRED_RIGHTS = 1398,
  eSQF_EVENT_GPS_DCME_MEAS_CYCLE_START = 1402,
  eSQF_EVENT_GPS_DCME_MEAS_CYCLE_END = 1403,
  eSQF_EVENT_GPS_CME_ENGAGED = 1404,
  eSQF_EVENT_GPS_CME_NOT_ENGAGED = 1405,
  eSQF_EVENT_GPS_DCME_ENGAGED = 1406,
  eSQF_EVENT_GPS_DCME_NOT_ENGAGED = 1407,
  eSQF_EVENT_HS_USB_DEVICE_ATTACHED = 1408,
  eSQF_EVENT_HS_USB_HID_DISCONECT = 1409,
  eSQF_EVENT_HS_USB_HID_CONNECT = 1410,
  eSQF_EVENT_HS_USB_MSD_CONNECT = 1411,
  eSQF_EVENT_HS_USB_MSD_DISCONECT = 1412,
  eSQF_EVENT_HS_USB_STACK_SUSPENDED = 1413,
  eSQF_EVENT_HS_USB_STACK_RESUMED = 1414,
  eSQF_EVENT_HS_USB_ENTER_HOST_MODE = 1415,
  eSQF_EVENT_HS_USB_OPERATIONAL_ERROR = 1416,
  eSQF_EVENT_DTV_L1_ACQ_DONE = 1417,
  eSQF_EVENT_DTV_L1_SCAN = 1418,
  eSQF_EVENT_DTV_L1_ONLINE = 1419,
  eSQF_EVENT_DTV_L1_SNOOZE = 1420,
  eSQF_EVENT_DTV_L1_SLEEP = 1421,
  eSQF_EVENT_DTV_L1_HANDOFF = 1422,
  eSQF_EVENT_DTV_L1_SIGNAL_LOST = 1423,
  eSQF_EVENT_IMS_SIP_REGISTRATION_START = 1424,
  eSQF_EVENT_IMS_SIP_REGISTER_END = 1425,
  eSQF_EVENT_IMS_SIP_DEREGISTER_START = 1426,
  eSQF_EVENT_IMS_SIP_DEREGISTER_END = 1427,
  eSQF_EVENT_IMS_SIP_SESSION_START = 1428,
  eSQF_EVENT_IMS_SIP_SESSION_RINGING = 1429,
  eSQF_EVENT_IMS_SIP_SESSION_ESTABLISHED = 1430,
  eSQF_EVENT_IMS_SIP_SESSION_TERMINATED = 1431,
  eSQF_EVENT_IMS_SIP_SESSION_CANCEL = 1432,
  eSQF_EVENT_IMS_SIP_SESSION_FAILURE = 1433,
  eSQF_EVENT_IMS_SIP_RESPONSE_RECV = 1434,
  eSQF_EVENT_IMS_SIP_REQUEST_RECV = 1435,
  eSQF_EVENT_IMS_SIP_RESPONSE_SEND = 1436,
  eSQF_EVENT_IMS_SIP_REQUEST_SEND = 1437,
  eSQF_EVENT_WLAN_TKIP_COUNTER_MEAS = 1438,
  eSQF_EVENT_GPS_BLANKING_OFF = 1439,
  eSQF_EVENT_GPS_BLANKING_ON = 1440,
  eSQF_EVENT_MMGSDI_EVENT = 1441,
  eSQF_EVENT_WLAN_CP_SYS_MGR_STATE_TRANS = 1442,
  eSQF_EVENT_GPS_OPTIMISTIC_PUNC_START = 1443,
  eSQF_EVENT_GPS_OPTIMISTIC_PUNC_END = 1444,
  eSQF_EVENT_QVP_SEND_RTP_PACKET = 1445,
  eSQF_EVENT_QVP_RECV_RTP_PACKET = 1446,
  eSQF_EVENT_HDR_IDLE_REACQ_FAIL_DDARF = 1447,
  eSQF_EVENT_BCAST_SEC_STKM_PARSE_STATUS = 1448,
  eSQF_EVENT_BCAST_SEC_STKM_RECEIVED = 1449,
  eSQF_EVENT_BCAST_SEC_SDP_PARSE_STATUS = 1450,
  eSQF_EVENT_CGPS_ME_DPO_STATUS = 1451,
  eSQF_EVENT_GPS_SV_SEARCH_STATE = 1452,
  eSQF_EVENT_GPS_TM_ON_DEMAND_MODE_CHANGE = 1453,
  eSQF_EVENT_GPS_TM_ON_DEMAND_BEGIN = 1454,
  eSQF_EVENT_GPS_TM_ON_DEMAND_DONE = 1455,
  eSQF_EVENT_RMAC_CARRIER_STATE_CHANGED = 1456,
  eSQF_EVENT_GPS_SBAS_DEMOD_REPORT = 1457,
  eSQF_EVENT_GPS_EXTERN_COARSE_POS_INJ_START = 1458,
  eSQF_EVENT_GPS_EXTERN_COARSE_POS_INJ_END = 1459,
  eSQF_EVENT_GPS_EPH_REREQUEST_TIME = 1460,
  eSQF_EVENT_WLAN_QOS_PSTREAM = 1461,
  eSQF_EVENT_WLAN_CP_VCC = 1462,
  eSQF_EVENT_CGPS_DIAG_FIRST_SUCCESSFUL_FIX = 1463,
  eSQF_EVENT_EUL_RECONFIG_OR_ASU_OR_TTI_RECFG = 1464,
  eSQF_EVENT_DS707_PKT_LN_UPDATE = 1465,
  eSQF_EVENT_DS707_PKT_IDM_CHANGE = 1466,
  eSQF_EVENT_RLP_QN_ADD = 1467,
  eSQF_EVENT_RLP_QN_DROP = 1468,
  eSQF_EVENT_RLP_MULTILINK_NAK = 1469,
  eSQF_EVENT_RLP_REV_LINK_NAK = 1470,
  eSQF_EVENT_GSTK_EVENT = 1471,
  eSQF_EVENT_GAN_REGISTRATION_REQUEST = 1472,
  eSQF_EVENT_GAN_REGISTER_ACCEPT = 1473,
  eSQF_EVENT_CALL_RINGING_ALERT = 1474,
  eSQF_EVENT_GAN_PAGING_RECEIVED = 1475,
  eSQF_EVENT_GAN_CALL_DISCONNECT = 1476,
  eSQF_EVENT_GAN_CALL_RELEASE_COMPLETE = 1477,
  eSQF_EVENT_GAN_HANDIN_COMMAND = 1478,
  eSQF_EVENT_GAN_HANDIN_COMPLETE = 1479,
  eSQF_EVENT_GAN_HANDOUT_COMMAND = 1480,
  eSQF_EVENT_GAN_HANDOUT_COMPLETE = 1481,
  eSQF_EVENT_GAN_SMS_START = 1482,
  eSQF_EVENT_GAN_SMS_ACK = 1483,
  eSQF_EVENT_GAN_QDJ_ENQUEUE = 1484,
  eSQF_EVENT_GAN_QDJ_DEQUEUE = 1485,
  eSQF_EVENT_GAN_ACTIVATE_DATA_CHANNEL = 1486,
  eSQF_EVENT_GAN_DATA_CHANNEL_CONNECTED = 1487,
  eSQF_EVENT_GAN_RLP_SUSPEND = 1488,
  eSQF_EVENT_GAN_RLP_RESUME = 1489,
  eSQF_EVENT_GAN_WAKEUP_REQ = 1490,
  eSQF_EVENT_GAN_WAKEUP_CNF = 1491,
  eSQF_EVENT_GAN_HIBERNATION_REQ = 1492,
  eSQF_EVENT_GAN_HIBERNATION_CNF = 1493,
  eSQF_EVENT_WCDMA_UL_AMR_RATE = 1494,
  eSQF_EVENT_EUL_TTI_RECONFIG = 1495,
  eSQF_EVENT_WCDMA_CONN_REL_CAUSE = 1496,
  eSQF_EVENT_WCDMA_CONN_REQ_CAUSE = 1497,
  eSQF_EVENT_LTE_TIMING_ADVANCE = 1498,
  eSQF_EVENT_LTE_UL_OUT_OF_SYNC = 1499,
  eSQF_EVENT_LTE_SPS_DEACTIVATED = 1500,
  eSQF_EVENT_LTE_RACH_ACCESS_START = 1501,
  eSQF_EVENT_LTE_RACH_RAID_MATCH = 1502,
  eSQF_EVENT_LTE_RACH_ACCESS_RESULT = 1503,
  eSQF_EVENT_DTV_L1_POWERUP = 1504,
  eSQF_EVENT_DTV_L1_POWERDOWN = 1505,
  eSQF_EVENT_DTV_L1_SOFT_RESET = 1506,
  eSQF_EVENT_DTV_L1_STATE_CHANGE = 1507,
  eSQF_EVENT_DTV_L1_ACQ_TUNE_STATUS = 1508,
  eSQF_EVENT_DTV_L1_ACQ_DONE_STATUS = 1509,
  eSQF_EVENT_DTV_L1_ACQ_FAIL = 1510,
  eSQF_EVENT_DTV_L1_TRAFFIC_STARTED = 1511,
  eSQF_EVENT_DTV_L1_BAD_FRAME_RECEIVED = 1512,
  eSQF_EVENT_DTV_L1_TMCC_FAILURE = 1513,
  eSQF_EVENT_DTV_L1_RECOVERY_STATUS = 1514,
  eSQF_EVENT_DTV_L1_INTERRUPT_LOG_RECEIVED = 1515,
  eSQF_EVENT_DTV_L1_L3_API_COMMAND = 1516,
  eSQF_EVENT_DTV_L1_MODEM_FAILURE = 1517,
  eSQF_EVENT_GSM_CALL_DROP = 1518,
  eSQF_EVENT_GSM_ACCESS_FAILURE = 1519,
  eSQF_EVENT_DTV_ISDB_ACTIVATE = 1520,
  eSQF_EVENT_DTV_ISDB_DEACTIVATE = 1521,
  eSQF_EVENT_DTV_ISDB_TUNE = 1522,
  eSQF_EVENT_DTV_ISDB_UNTUNE = 1523,
  eSQF_EVENT_DTV_ISDB_SELECT_SERVICE = 1524,
  eSQF_EVENT_DTV_ISDB_SERVICE_AVAILABLE = 1525,
  eSQF_EVENT_DTV_ISDB_TRAFFIC_LOST = 1526,
  eSQF_EVENT_DTV_ISDB_TABLE_UPDATE = 1527,
  eSQF_EVENT_DTV_ISDB_TRACKS_SELECTED = 1528,
  eSQF_EVENT_DTV_ISDB_PES_BUFFER_OVERFLOW = 1529,
  eSQF_EVENT_DTV_ISDB_PES_BUFFER_UNDERFLOW = 1530,
  eSQF_EVENT_DTV_ISDB_ACQUIRE_DATA_COMPONENT = 1531,
  eSQF_EVENT_DTV_ISDB_STOP_COMPONENT_ACQUISITION = 1532,
  eSQF_EVENT_DTV_ISDB_DII_CHANGED = 1533,
  eSQF_EVENT_DTV_ISDB_DATA_EVENT_MESSAGE = 1534,
  eSQF_EVENT_DTV_ISDB_MODULE_CONSTRUCTION = 1535,
  eSQF_EVENT_DTV_ISDB_PARSING_ERROR = 1536,
  eSQF_EVENT_HDR_SLP_SLPQH_TIMER_STARTED = 1537,
  eSQF_EVENT_HDR_SLP_SLPQH_TIMER_STOPPED = 1538,
  eSQF_EVENT_HDR_SLP_SLPQH_NUM_PENDING_MSGS = 1539,
  eSQF_EVENT_HDR_OVHD_FIND_CACHED_MSG = 1540,
  eSQF_EVENT_WCDMA_RRC_TIMER_EXPIRED = 1541,
  eSQF_EVENT_WCDMA_UOOS_TIMER_USED = 1542,
  eSQF_EVENT_WCDMA_UOOS_TIMER_START = 1543,
  eSQF_EVENT_WCDMA_UOOS_TIMER_STOP = 1544,
  eSQF_EVENT_WCDMA_UOOS_TIME_REMAINING = 1545,
  eSQF_EVENT_WCDMA_RRCCSP_SCAN_START = 1546,
  eSQF_EVENT_WCDMA_ACQUISITON_SUCCESS = 1547,
  eSQF_EVENT_WCDMA_CELL_SELECTION_FAIL = 1548,
  eSQF_EVENT_WCDMA_BPLMN_START = 1549,
  eSQF_EVENT_WCDMA_BPLMN_END = 1550,
  eSQF_EVENT_WCDMA_BPLMN_SCAN_START = 1551,
  eSQF_EVENT_WCDMA_BPLMN_SCAN_END = 1552,
  eSQF_EVENT_MSG_HIGH = 1553,
  eSQF_EVENT_MSG_MED = 1554,
  eSQF_EVENT_MSG_LOW = 1555,
  eSQF_EVENT_MSG_ERROR = 1556,
  eSQF_EVENT_MSG_FATAL = 1557,
  eSQF_EVENT_GAN_START_TU3910 = 1558,
  eSQF_EVENT_GAN_STOP_TU3910 = 1559,
  eSQF_EVENT_GAN_EXPIRY_TU3910 = 1560,
  eSQF_EVENT_GAN_START_TU3920 = 1561,
  eSQF_EVENT_GAN_STOP_TU3920 = 1562,
  eSQF_EVENT_GAN_EXPIRY_TU3920 = 1563,
  eSQF_EVENT_GAN_START_TU3906 = 1564,
  eSQF_EVENT_GAN_STOP_TU3906 = 1565,
  eSQF_EVENT_GAN_EXPIRY_TU3906 = 1566,
  eSQF_EVENT_GAN_URR_REGISTER_UPDATE = 1567,
  eSQF_EVENT_IPSEC_IKE_SA_INIT_SENT = 1568,
  eSQF_EVENT_IPSEC_IKE_SA_INIT_RECV = 1569,
  eSQF_EVENT_IPSEC_IKE_SA_ESTABLISHED = 1570,
  eSQF_EVENT_IPSEC_IKE_AUTH_SENT = 1571,
  eSQF_EVENT_IPSEC_IKE_AUTH_RECV = 1572,
  eSQF_EVENT_IPSEC_IKE_EAP_START = 1573,
  eSQF_EVENT_IPSEC_IKE_EAP_FINISH = 1574,
  eSQF_EVENT_IPSEC_CHILD_SA_ESTABLISHED = 1575,
  eSQF_EVENT_IPSEC_IKE_INFO_MSG_SENT = 1576,
  eSQF_EVENT_IPSEC_IKE_INFO_MSG_RECV = 1577,
  eSQF_EVENT_IPSEC_CREATE_CHILD_SA_SENT = 1578,
  eSQF_EVENT_IPSEC_CREATE_CHILD_SA_RECV = 1579,
  eSQF_EVENT_IPSEC_IKE_SA_DELETE_START = 1580,
  eSQF_EVENT_IPSEC_IKE_SA_DELETE_DONE = 1581,
  eSQF_EVENT_IPSEC_CHILD_SA_DELETE_START = 1582,
  eSQF_EVENT_IPSEC_CHILD_SA_DELETE_DONE = 1583,
  eSQF_EVENT_IPSEC_IKE_SA_REKEY_START = 1584,
  eSQF_EVENT_IPSEC_IKE_SA_REKEY_DONE = 1585,
  eSQF_EVENT_IPSEC_CHILD_SA_REKEY_START = 1586,
  eSQF_EVENT_IPSEC_CHILD_SA_REKEY_DONE = 1587,
  eSQF_EVENT_IPSEC_IKE_MESG_RETRANSMIT = 1588,
  eSQF_EVENT_IPSEC_IKE_NAT_DETECTED = 1589,
  eSQF_EVENT_IPSEC_IKE_NAT_KEEPALIVE_SENT = 1590,
  eSQF_EVENT_IPSEC_IKE_DPD_SENT = 1591,
  eSQF_EVENT_IPSEC_IKE_ERR_NOTIFY_SENT = 1592,
  eSQF_EVENT_IPSEC_IKE_ERR_NOTIFY_RECV = 1593,
  eSQF_EVENT_GAN_ROVEIN_CNF = 1594,
  eSQF_EVENT_GAN_ROVEOUT_CNF = 1595,
  eSQF_EVENT_GAN_RRC_ROVEIN_CNF = 1596,
  eSQF_EVENT_GAN_RRC_ROVEIN_REJ = 1597,
  eSQF_EVENT_GAN_RRC_ROVEOUT_CNF = 1598,
  eSQF_EVENT_GAN_RRC_ROVEOUT_REJ = 1599,
  eSQF_EVENT_GPSXTRA_T_SESS_BEGIN = 1600,
  eSQF_EVENT_GPSXTRA_T_SESS_DATA = 1601,
  eSQF_EVENT_GPSXTRA_T_SESS_DONE = 1602,
  eSQF_EVENT_GPSXTRA_T_SESS_END = 1603,
  eSQF_EVENT_DS_GO_NULL_TIMER = 1604,
  eSQF_EVENT_LTE_RRC_TIMER_STATUS = 1605,
  eSQF_EVENT_LTE_RRC_STATE_CHANGE = 1606,
  eSQF_EVENT_LTE_RRC_OUT_OF_SERVICE = 1607,
  eSQF_EVENT_LTE_RRC_RADIO_LINK_FAILURE = 1608,
  eSQF_EVENT_LTE_RRC_DL_MSG = 1609,
  eSQF_EVENT_LTE_RRC_UL_MSG = 1610,
  eSQF_EVENT_LTE_RRC_NEW_CELL_IND = 1611,
  eSQF_EVENT_LTE_RRC_CELL_RESEL_FAILURE = 1612,
  eSQF_EVENT_LTE_RRC_HO_FAILURE = 1613,
  eSQF_EVENT_LTE_RRC_PAGING_DRX_CYCLE = 1614,
  eSQF_EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN = 1615,
  eSQF_EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN_FAILURE = 1616,
  eSQF_EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN = 1617,
  eSQF_EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_FAILURE = 1618,
  eSQF_EVENT_LTE_RRC_SIB_READ_FAILURE = 1619,
  eSQF_EVENT_GAN_ROVEIN_REQ = 1620,
  eSQF_EVENT_GAN_ROVEOUT_REQ = 1621,
  eSQF_EVENT_MBP_RF_ANALOG_JD_MODE_CHANGE = 1622,
  eSQF_EVENT_MBP_RF_ANALOG_JD_INT = 1623,
  eSQF_EVENT_CGPS_QWIP_SYSD_TRANSITION = 1624,
  eSQF_EVENT_HPLMN_TIMER_EXPIRED = 1625,
  eSQF_EVENT_GSDI_GET_FEATURE_INDICATOR_DATA = 1626,
  eSQF_EVENT_LTE_CM_INCOMING_MSG = 1627,
  eSQF_EVENT_LTE_CM_OUTGOING_MSG = 1628,
  eSQF_EVENT_LTE_EMM_INCOMING_MSG = 1629,
  eSQF_EVENT_LTE_EMM_OUTGOING_MSG = 1630,
  eSQF_EVENT_LTE_EMM_TIMER_START = 1631,
  eSQF_EVENT_LTE_EMM_TIMER_EXPIRY = 1632,
  eSQF_EVENT_LTE_REG_INCOMING_MSG = 1633,
  eSQF_EVENT_LTE_REG_OUTGOING_MSG = 1634,
  eSQF_EVENT_LTE_ESM_INCOMING_MSG = 1635,
  eSQF_EVENT_LTE_ESM_OUTGOING_MSG = 1636,
  eSQF_EVENT_LTE_ESM_TIMER_START = 1637,
  eSQF_EVENT_LTE_ESM_TIMER_EXPIRY = 1638,
  eSQF_EVENT_SNS_CONTEXT_OPEN = 1639,
  eSQF_EVENT_SNS_CONTEXT_CLOSE = 1640,
  eSQF_EVENT_SNS_COND_SET = 1641,
  eSQF_EVENT_SNS_COND_CANCEL = 1642,
  eSQF_EVENT_SNS_COND_MET = 1643,
  eSQF_EVENT_SNS_DATA_START = 1644,
  eSQF_EVENT_SNS_DATA_STOP = 1645,
  eSQF_EVENT_WCDMA_RLC_CONFIG = 1646,
  eSQF_EVENT_HSPA_PLUS_CFG = 1647,
  eSQF_EVENT_SNS_DRIVER_STATE_CHANGE = 1648,
  eSQF_EVENT_WCDMA_TIMER_DISCARD_EXPIRY = 1649,
  eSQF_EVENT_NAS_CB_PAGE_RECEIVED = 1650,
  eSQF_EVENT_WCDMA_RLC_RESET = 1651,
  eSQF_EVENT_HDR_MRLP_EHRPD_PERSONALITY_IS_ACTIVE = 1652,
  eSQF_EVENT_WLAN_SECURITY = 1653,
  eSQF_EVENT_WLAN_STATUS = 1654,
  eSQF_EVENT_WLAN_HANDOFF = 1655,
  eSQF_EVENT_WLAN_VCC = 1656,
  eSQF_EVENT_WLAN_QOS = 1657,
  eSQF_EVENT_WLAN_PE = 1658,
  eSQF_EVENT_WLAN_ADD_BLOCK_ACK_SUCCESS = 1659,
  eSQF_EVENT_WLAN_ADD_BLOCK_ACK_FAILED = 1660,
  eSQF_EVENT_WLAN_DELETE_BLOCK_ACK_SUCCESS = 1661,
  eSQF_EVENT_WLAN_DELETE_BLOCK_ACK_FAILED = 1662,
  eSQF_EVENT_WLAN_BSS_PROTECTION = 1663,
  eSQF_EVENT_WLAN_BRINGUP_STATUS = 1664,
  eSQF_EVENT_WLAN_POWERSAVE_GENERIC = 1665,
  eSQF_EVENT_WLAN_POWERSAVE_WOW = 1666,
  eSQF_EVENT_WLAN_WCM = 1667,
  eSQF_EVENT_WLAN_WPS_SCAN_START = 1668,
  eSQF_EVENT_WLAN_WPS_SCAN_COMPLETE = 1669,
  eSQF_EVENT_WLAN_WPS_CONNECT_REQUEST = 1670,
  eSQF_EVENT_WLAN_WPS_CONNECT_RESPONSE = 1671,
  eSQF_EVENT_WLAN_WPS_PBC_SESSION_OVERLAP = 1672,
  eSQF_EVENT_WLAN_WPS_PBC_WALK_TIMER_START = 1673,
  eSQF_EVENT_WLAN_WPS_PBC_WALK_TIMER_STOP = 1674,
  eSQF_EVENT_WLAN_WPS_PBC_AP_DETECTED = 1675,
  eSQF_EVENT_WLAN_WPS_REGISTRATION_START = 1676,
  eSQF_EVENT_WLAN_WPS_WSC_MESSAGE = 1677,
  eSQF_EVENT_WLAN_WPS_DISCOVERY = 1678,
  eSQF_EVENT_WLAN_WPS_REGISTRATION_COMPLETE = 1679,
  eSQF_EVENT_WLAN_WPS_DISCONNECT = 1680,
  eSQF_EVENT_WLAN_BTC = 1681,
  eSQF_EVENT_IPV6_SM_EVENT = 1682,
  eSQF_EVENT_IPV6_SM_TRANSITION = 1683,
  eSQF_EVENT_IPV6_PREFIX_UPDATE = 1684,
  eSQF_EVENT_LTE_ML1_STATE_CHANGE = 1685,
  eSQF_EVENT_AUTH_PROTO = 1686,
  eSQF_EVENT_VSNCP = 1687,
  eSQF_EVENT_IID = 1688,
  eSQF_EVENT_IMS_VIDEOSHARE_REGISTRATION_SUCCESS = 1689,
  eSQF_EVENT_IMS_VIDEOSHARE_INVITE_SENT = 1690,
  eSQF_EVENT_IMS_VIDEOSHARE_INCOMING_INVITE = 1691,
  eSQF_EVENT_IMS_VIDEOSHARE_ACCEPT_REJECT_INVITE = 1692,
  eSQF_EVENT_IMS_VIDEOSHARE_ACCEPTING_SESSION = 1693,
  eSQF_EVENT_IMS_VIDEOSHARE_SESSION_ESTABLISHED = 1694,
  eSQF_EVENT_IMS_VIDEOSHARE_END_SESSION = 1695,
  eSQF_EVENT_IMS_VIDEOSHARE_PREVIEW_VIDEO_FRAME = 1696,
  eSQF_EVENT_IMS_VIDEOSHARE_DECODED_VIDEO_FRAME = 1697,
  eSQF_EVENT_IMS_VIDEOSHARE_RECEIVING = 1698,
  eSQF_EVENT_IMS_VIDEOSHARE_START_APPLICATION = 1699,
  eSQF_EVENT_IMS_VIDEOSHARE_END_APPLICATION = 1700,
  eSQF_EVENT_IMS_VIDEOSHARE_CAPABILITY_SUCCESS = 1701,
  eSQF_EVENT_IMS_VIDEOSHARE_MEDIA_RECORDING_RESOURCE_ACQUIRED = 1702,
  eSQF_EVENT_IMS_VIDEOSHARE_MEDIA_RECORDING_RESOURCE_RELEASED = 1703,
  eSQF_EVENT_IMS_VIDEOSHARE_SENDING = 1704,
  eSQF_EVENT_IMS_VIDEOSHARE_INCOMING_OPTION_RECEIVED = 1705,
  eSQF_EVENT_IMS_VIDEOSHARE_INCOMING_OPTION_RESPONDED = 1706,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_CALL_FAILED = 1707,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_REGISTRATION_FAILED = 1708,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_RECORDER_ERROR = 1709,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_PLAYER_ERROR = 1710,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_MEDIA_SESSION_FAILURE = 1711,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_CAPABILITY_FAILURE = 1712,
  eSQF_EVENT_IMS_VIDEOSHARE_ERR_MEDIA_RECORDING_FAILED = 1713,
  eSQF_EVENT_WLAN_PE_FRAME = 1714,
  eSQF_EVENT_SNS_VCPS_HEADING_COMPUTED = 1715,
  eSQF_EVENT_SNS_VCPS_TRACKED_CAL_SET_SAVED = 1716,
  eSQF_EVENT_GNSS_PRESC_DWELL_COMPLETE = 1717,
  eSQF_EVENT_LTE_MAC_RESET = 1718,
  eSQF_EVENT_LTE_BSR_SR_REQUEST = 1719,
  eSQF_EVENT_LTE_MAC_TIMER = 1720,
  eSQF_EVENT_CM_DS_OPERATIONAL_MODE = 1721,
  eSQF_EVENT_CM_DS_MODE_PREF = 1722,
  eSQF_EVENT_CM_DS_GW_ACQ_ORDER_PREF = 1723,
  eSQF_EVENT_CM_DS_SRV_DOMAIN_PREF = 1724,
  eSQF_EVENT_CM_DS_BAND_PREF = 1725,
  eSQF_EVENT_CM_DS_ROAM_PREF = 1726,
  eSQF_EVENT_CM_DS_HYBRID_PREF = 1727,
  eSQF_EVENT_CM_DS_NETWORK_SEL_MODE_PREF = 1728,
  eSQF_EVENT_CM_DS_CALL_EVENT_ORIG = 1729,
  eSQF_EVENT_CM_DS_CALL_EVENT_CONNECT = 1730,
  eSQF_EVENT_CM_DS_CALL_EVENT_END = 1731,
  eSQF_EVENT_CM_DS_ENTER_EMERGENCY_CB = 1732,
  eSQF_EVENT_CM_DS_EXIT_EMERGENCY_CB = 1733,
  eSQF_EVENT_CM_DS_CALL_STATE = 1734,
  eSQF_EVENT_CM_DS_DS_INTERRAT_STATE = 1735,
  eSQF_EVENT_CM_DS_CELL_SRV_IND = 1736,
  eSQF_EVENT_CM_DS_COUNTRY_SELECTED = 1737,
  eSQF_EVENT_CM_DS_DATA_AVAILABLE = 1738,
  eSQF_EVENT_CM_DS_SELECT_COUNTRY = 1739,
  eSQF_EVENT_CM_DS_CALL_EVENT_ORIG_THR = 1740,
  eSQF_EVENT_CM_DS_PLMN_FOUND = 1741,
  eSQF_EVENT_CM_DS_SERVICE_CONFIRMED = 1742,
  eSQF_EVENT_CM_DS_GET_PASSWORD_IND = 1743,
  eSQF_EVENT_CM_DS_PASSWORD_AUTHENTICATION_STATUS = 1744,
  eSQF_EVENT_CM_DS_USS_RESPONSE_NOTIFY_IND = 1745,
  eSQF_EVENT_CM_DS_LCS_MOLR_CONF = 1746,
  eSQF_EVENT_DS_NAS_MESSAGE_SENT = 1747,
  eSQF_EVENT_DS_NAS_MESSAGE_RECEIVED = 1748,
  eSQF_EVENT_DS_MM_STATE = 1749,
  eSQF_EVENT_DS_GMM_STATE = 1750,
  eSQF_EVENT_DS_PLMN_INFORMATION = 1751,
  eSQF_EVENT_DIAG_STRESS_TEST_COMPLETED = 1752,
  eSQF_EVENT_GNSS_CC_STATUS = 1753,
  eSQF_EVENT_SNS_USER_STATE_CHANGE = 1754,
  eSQF_EVENT_DS_HPLMN_TIMER_EXPIRED = 1755,
  eSQF_EVENT_DS_RAT_CHANGE = 1756,
  eSQF_EVENT_DTV_CMMB_API_CALL_ACTIVATE = 1757,
  eSQF_EVENT_DTV_CMMB_API_CALL_DEACTIVATE = 1758,
  eSQF_EVENT_DTV_CMMB_API_CALL_TUNE = 1759,
  eSQF_EVENT_DTV_CMMB_API_CALL_SELECT_SERVICE = 1760,
  eSQF_EVENT_DTV_CMMB_API_CALL_DESELECT_SERVICE = 1761,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_SIGNAL_PARAMETERS = 1762,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_NIT = 1763,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_CMCT = 1764,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_SMCT = 1765,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_CSCT = 1766,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_SSCT = 1767,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_EADT = 1768,
  eSQF_EVENT_DTV_CMMB_API_CALL_REQUEST_CA_CARD_NUMBER = 1769,
  eSQF_EVENT_DTV_CMMB_API_CALL_REQUEST_CAS_ID = 1770,
  eSQF_EVENT_DTV_CMMB_API_CALL_REGISTER_FOR_CONTROL_NOTIFICATIONS = 1771,
  eSQF_EVENT_DTV_CMMB_API_CALL_DEREGISTER_FROM_CONTROL_NOTIFICATIONS = 1772,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_ACTIVATE = 1773,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_DEACTIVATE = 1774,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_TUNE = 1775,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_SELECT_SERVICE = 1776,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_DESELECT_SERVICE = 1777,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_TABLE_UPDATE = 1778,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_SIGNAL_PARAMETERS = 1779,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_AUTHORIZATION_FAILURE = 1780,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_REGISTER_FOR_CONTROL_NOTIFICATIONS_COMPLETE = 1781,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_DEREGISTER_FROM_CONTROL_NOTIFICATIONS_COMPLETE = 1782,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_CA_CARD_NUMBER = 1783,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_CAS_ID = 1784,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_EMERGENCY_BROADCASTING_TRIGGER = 1785,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_EMERGENCY_BROADCASTING_MESSAGE = 1786,
  eSQF_EVENT_DTV_CMMB_API_CALL_REGISTER_FOR_ESG_NOTIFICATIONS = 1787,
  eSQF_EVENT_DTV_CMMB_API_CALL_DEREGISTER_FROM_ESG_NOTIFICATIONS = 1788,
  eSQF_EVENT_DTV_CMMB_API_CALL_GET_BASIC_DESCRIPTION_INFORMATION = 1789,
  eSQF_EVENT_DTV_CMMB_API_CALL_SET_OUTPUT_PATH = 1790,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_ESG_DATA_INFORMATION = 1791,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_ESG_DATA_INFORMATION_DOWNLOAD_COMPLETE = 1792,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_ESG_PROGRAM_INDICATION_INFORMATION = 1793,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_REGISTER_FOR_ESG_NOTIFICATIONS_COMPLETE = 1794,
  eSQF_EVENT_DTV_CMMB_API_NOTIFICATION_DEREGISTER_FROM_ESG_NOTIFICATIONS_COMPLETE = 1795,
  eSQF_EVENT_DTV_CMMB_CAS_INITIALIZED = 1796,
  eSQF_EVENT_DTV_CMMB_CAS_EMM_RECEIVED_AND_PROCESSED = 1797,
  eSQF_EVENT_DTV_CMMB_CAS_ECM_RECEIVED_AND_PROCESSED = 1798,
  eSQF_EVENT_ECALL_START = 1799,
  eSQF_EVENT_ECALL_STOP = 1800,
  eSQF_EVENT_ECALL_SESSION_START = 1801,
  eSQF_EVENT_ECALL_SESSION_FAILURE = 1802,
  eSQF_EVENT_ECALL_SESSION_COMPLETE = 1803,
  eSQF_EVENT_ECALL_SESSION_RESET = 1804,
  eSQF_EVENT_ECALL_PSAP_MSD_DECODE_SUCCESS = 1805,
  eSQF_EVENT_ECALL_PSAP_LOST_SYNC = 1806,
  eSQF_EVENT_LTE_RRC_IRAT_REDIR_FROM_EUTRAN_START = 1807,
  eSQF_EVENT_LTE_RRC_IRAT_REDIR_FROM_EUTRAN_END = 1808,
  eSQF_EVENT_GPRS_DS_CELL_CHANGE_ORDER = 1809,
  eSQF_EVENT_GSM_DS_CELL_SELECTION_END = 1810,
  eSQF_EVENT_GSM_DS_L1_STATE = 1811,
  eSQF_EVENT_GSM_DS_PLMN_LIST_START = 1812,
  eSQF_EVENT_GSM_DS_PLMN_LIST_END = 1813,
  eSQF_EVENT_GSM_DS_POWER_SCAN_STATUS = 1814,
  eSQF_EVENT_GSM_DS_RESELECT_START = 1815,
  eSQF_EVENT_GSM_DS_RR_IN_SERVICE = 1816,
  eSQF_EVENT_GSM_DS_RR_OUT_OF_SERVICE = 1817,
  eSQF_EVENT_GSM_DS_TIMER_EXPIRED = 1818,
  eSQF_EVENT_GSM_DS_TO_WCDMA_RESELECT_END = 1819,
  eSQF_EVENT_CM_DS_SYSTEM_MODE = 1820,
  eSQF_EVENT_SD_DS_EVENT_ACTION = 1821,
  eSQF_EVENT_SMGMM_DS_REQUEST_SENT = 1822,
  eSQF_EVENT_IFACE = 1823,
  eSQF_EVENTS_DS_GSM_L1_ALIGN_VFR = 1824,
  eSQF_EVENTS_DS_GSM_L1_STATE = 1825,
  eSQF_EVENTS_DS_GSM_RATSCCH_IN_DTX = 1826,
  eSQF_EVENTS_DS_GSM_FACCH_IN_DTX = 1827,
  eSQF_EVENTS_DS_GSM_FACCH_AND_RATSCCH_COLLISION = 1828,
  eSQF_EVENTS_DS_GSM_FACCH_AND_SID_UPDATE_COLLISION = 1829,
  eSQF_EVENTS_DS_GSM_RATSCCH_AND_SID_UPDATE_COLLISION = 1830,
  eSQF_EVENTS_DS_GSM_AMR_STATE_CHANGE = 1831,
  eSQF_EVENTS_DS_GSM_RATSCCH_CMI_PHASE_CHANGE = 1832,
  eSQF_EVENTS_DS_GSM_RATSCCH_REQ_ACT_TIMER_EXPIRY = 1833,
  eSQF_EVENTS_DS_GSM_RATSCCH_ACK_ACT_TIMER_EXPIRY = 1834,
  eSQF_EVENTS_DS_GSM_AMR_RATSCCH_REQ = 1835,
  eSQF_EVENTS_DS_GSM_AMR_RATSCCH_RSP = 1836,
  eSQF_EVENTS_DS_GSM_AMR_CMC_TURNAROUND_TIME = 1837,
  eSQF_EVENTS_DS_GPRS_SMGMM_MSG_RECEIVED = 1838,
  eSQF_EVENTS_DS_GPRS_SMGMM_MSG_SENT = 1839,
  eSQF_EVENTS_DS_GPRS_LLC_READY_TIMER_START = 1840,
  eSQF_EVENTS_DS_GPRS_LLC_READY_TIMER_END = 1841,
  eSQF_EVENTS_DS_PACKET_TIMESLOT_RECONFIGURE = 1842,
  eSQF_EVENTS_DS_GPRS_MAC_MSG_RECEIVED = 1843,
  eSQF_EVENTS_DS_GPRS_MAC_MSG_SENT = 1844,
  eSQF_EVENTS_DS_GPRS_MAC_CAMPED_ON_CELL = 1845,
  eSQF_EVENTS_DS_GPRS_CELL_CHANGE_FAILURE = 1846,
  eSQF_EVENTS_DS_GPRS_PACKET_CHANNEL_REQUEST = 1847,
  eSQF_EVENTS_DS_GPRS_PACKET_UPLINK_ASSIGNMENT = 1848,
  eSQF_EVENTS_DS_GPRS_PACKET_DOWNLINK_ASSIGNMENT = 1849,
  eSQF_EVENTS_DS_GPRS_TBF_RELEASE = 1850,
  eSQF_EVENTS_DS_GPRS_TIMER_EXPIRY = 1851,
  eSQF_EVENTS_DS_GPRS_PACKET_RESOURCE_REQUEST = 1852,
  eSQF_EVENTS_DS_RANDOM_ACCESS_REQUEST = 1853,
  eSQF_EVENTS_DS_GSM_HANDOVER_START = 1854,
  eSQF_EVENTS_DS_GSM_HANDOVER_END = 1855,
  eSQF_EVENTS_DS_GSM_RESELECT_START = 1856,
  eSQF_EVENTS_DS_GSM_RESELECT_END = 1857,
  eSQF_EVENTS_DS_GSM_TO_WCDMA_RESELECT_END = 1858,
  eSQF_EVENTS_DS_GSM_MESSAGE_RECEIVED = 1859,
  eSQF_EVENTS_DS_GSM_RR_IN_SERVICE = 1860,
  eSQF_EVENTS_DS_GSM_RR_OUT_OF_SERVICE = 1861,
  eSQF_EVENTS_DS_GSM_PAGE_RECEIVED = 1862,
  eSQF_EVENTS_DS_GSM_CAMP_ATTEMPT_START = 1863,
  eSQF_EVENTS_DS_GSM_CAMP_ATTEMPT_END = 1864,
  eSQF_EVENTS_DS_GSM_CALL_DROP = 1865,
  eSQF_EVENTS_DS_GSM_ACCESS_FAILURE = 1866,
  eSQF_EVENTS_DS_GSM_CELL_SELECTION_START = 1867,
  eSQF_EVENTS_DS_GSM_CELL_SELECTION_END = 1868,
  eSQF_EVENTS_DS_GSM_POWER_SCAN_STATUS = 1869,
  eSQF_EVENTS_DS_GSM_PLMN_LIST_START = 1870,
  eSQF_EVENTS_DS_GSM_PLMN_LIST_END = 1871,
  eSQF_EVENTS_DS_GSM_AMR_MULTIRATE_IE = 1872,
  eSQF_EVENTS_DS_GPRS_LINK_FAILURE = 1873,
  eSQF_EVENTS_DS_GPRS_PAGE_RECEIVED = 1874,
  eSQF_EVENTS_DS_GPRS_SURROUND_SEARCH_START = 1875,
  eSQF_EVENTS_DS_GPRS_SURROUND_SEARCH_END = 1876,
  eSQF_EVENTS_DS_GPRS_EARLY_CAMPING = 1877,
  eSQF_EVENTS_DS_GSM_LINK_FAILURE = 1878,
  eSQF_EVENT_MTP_FILE_DELETED = 1879,
  eSQF_EVENT_MTP_PLAYLIST_REMOVED_OBJECT = 1880,
  eSQF_EVENT_MTP_SYNC_STARTED = 1881,
  eSQF_EVENT_MTP_SYNC_FINISHED = 1882,
  eSQF_EVENT_MTP_SAVE_ALBUMART_STARTED = 1883,
  eSQF_EVENT_MTP_SAVE_ALBUMART_FINISHED = 1884,
  eSQF_EVENT_MTP_FORMAT_STORE_STARTED = 1885,
  eSQF_EVENT_MTP_FORMAT_STORE_DONE = 1886,
  eSQF_EVENT_MTP_FORMAT_STORE_ERROR = 1887,
  eSQF_EVENT_LTE_RRC_SECURITY_CONFIG = 1888,
  eSQF_EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_START = 1889,
  eSQF_EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_END = 1890,
  eSQF_EVENT_SNS_REST_DETECT_ACCEL_ACTIVE_TS = 1891,
  eSQF_EVENT_SNS_REST_DETECT_ACCEL_STOP_TS = 1892,
  eSQF_EVENT_CPC_CONFIG_ACTION = 1893,
  eSQF_EVENT_FDPCH_CONFIG_ACTION = 1894,
  eSQF_EVENT_SNS_DRV_MOTION_DETECT_SIG = 1895,
  eSQF_EVENT_SNS_DRV_OPMODE_CHANGE = 1896,
  eSQF_EVENT_PM_BATT_CONNECT = 1897,
  eSQF_EVENT_PM_BATT_DISCONNECT = 1898,
  eSQF_EVENT_PM_BATT_TEMP_OUT_OF_RANGE = 1899,
  eSQF_EVENT_PM_CHARGE_STATE_CHANGED = 1900,
  eSQF_EVENT_PM_CHARGE_DONE = 1901,
  eSQF_EVENT_PM_CHARGE_FAIL = 1902,
  eSQF_EVENT_PM_VBAT_DET = 1903,
  eSQF_EVENT_PM_AUTO_CHARGING_EOC_ITERM_SW_TIMER = 1904,
  eSQF_EVENT_PM_AUTO_CHARGING_EOC_DETECTION_SW_TIMER = 1905,
  eSQF_EVENT_PM_AUTO_CHARGING_MAX_CHARGE_SW_TIMER = 1906,
  eSQF_EVENT_PM_AUTO_CHARGING_RESUME_CHARGE_DETECTION_TIMER = 1907,
  eSQF_EVENT_PM_OVP_TRIGGERED = 1908,
  eSQF_EVENT_PM_GEN_VERIFY_REGISTER_DEFAULTS = 1909,
  eSQF_EVENT_1X_FPC_MODE = 1910,
  eSQF_EVENT_1X_FPC_RATCHET = 1911,
  eSQF_EVENT_1X_FSCH_ASSIGN = 1912,
  eSQF_EVENT_1X_RSCH_ASSIGN = 1913,
  eSQF_EVENT_1X_RSCH_REQUEST = 1914,
  eSQF_EVENT_1X_ADV_FL_SB_STATUS = 1915,
  eSQF_EVENT_1X_ADV_RL_SB_STATUS = 1916,
  eSQF_EVENT_1X_ADV_N2M_CHANGE = 1917,
  eSQF_EVENT_PM_COMMON_TEST = 1918,
  eSQF_EVENT_PM_COMMON_TEST_PAYLOAD = 1919,
  eSQF_EVENT_CGPS_PREEMPTION_FLAG = 1920,
  eSQF_EVENT_CM_LTE_BAND_PREF = 1921,
  eSQF_EVENT_PS_ARBITRATION = 1922,
  eSQF_EVENT_SD_AVOIDANCE_LOG = 1923,
  eSQF_EVENT_HSPAPLUS_DC = 1924,
  eSQF_EVENT_HS_SCCH_ORDER = 1925,
  eSQF_EVENT_DSM_POOL_LEVEL = 1926,
  eSQF_EVENT_GPSONEXTRA_DATA_ACK = 1927,
  eSQF_EVENT_MCS_MSGR_SEND = 1928,
  eSQF_EVENT_MCS_MSGR_RECV = 1929,
  eSQF_EVENT_WCDMA_TO_LTE_RESELECTION_START = 1930,
  eSQF_EVENT_WCDMA_TO_LTE_RESELECTION_END = 1931,
  eSQF_EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_START = 1932,
  eSQF_EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_STOP = 1933,
  eSQF_EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_EXPIRED = 1934,
  eSQF_EVENT_LTE_RRC_CELL_BLACKLIST_IND = 1935,
  eSQF_LTE_RRC_INTERNAL_EVENT_0 = 1936,
  eSQF_EVENT_WCDMA_OL_MTD_CONFIG_ACTION = 1937,
  eSQF_EVENT_LTE_ML1_PHR_REPORT = 1938,
  eSQF_EVENT_SMS_COMMAND_PROCESSED = 1939,
  eSQF_EVENT_SMS_MT_NOTIFY = 1940,
  eSQF_EVENT_GPSXTRA_T_CONN_BEGIN = 1941,
  eSQF_EVENT_GPSXTRA_T_CONN_CONNECT = 1942,
  eSQF_EVENT_GPSXTRA_T_CONN_DISCONNET = 1943,
  eSQF_EVENT_GPSXTRA_T_CONN_DONE = 1944,
  eSQF_EVENT_GPSXTRA_T_CONN_FAILURE = 1945,
  eSQF_EVENT_GNSS_TLE_SRV_CHANGE_C = 1946,
  eSQF_EVENT_GNSS_TLE_CELL_CHANGE_C = 1947,
  eSQF_EVENT_GNSS_TLE_POS_UPDATE_C = 1948,
  eSQF_EVENT_GNSS_TLE_TIME_TAG_C = 1949,
  eSQF_EVENT_GNSS_TLE_DELETE_C = 1950,
  eSQF_EVENT_GNSS_TLE_TIME_UPDATE_C = 1951,
  eSQF_EVENT_GNSS_TLE_POSITION_REPORT = 1952,
  eSQF_EVENT_WCDMA_TO_LTE_REDIRECTION_START = 1953,
  eSQF_EVENT_WCDMA_TO_LTE_REDIRECTION_END = 1954,
  eSQF_EVENT_WCDMA_DED_PRIORITIES_VALIDITY_TIMER_START = 1955,
  eSQF_EVENT_WCDMA_DED_PRIORITIES_VALIDITY_TIMER_EXPIRED = 1956,
  eSQF_EVENT_LTE_RRC_IRAT_RTT_FROM_EUTRAN_START = 1957,
  eSQF_EVENT_LTE_RRC_IRAT_RTT_FROM_EUTRAN_END = 1958,
  eSQF_EVENT_WCDMA_RRC_DSIM_TUNEAWAY_START = 1959,
  eSQF_EVENT_WCDMA_RRC_DSIM_TUNEAWAY_STOP = 1960,
  eSQF_EVENT_SMS_ETWS_PRIM_RECEIVED = 1961,
  eSQF_EVENT_SMS_CBS_MSG_RECEIVED = 1962,
  eSQF_EVENT_LTE_ML1_TX_POWER_BACKOFF = 1963,
  eSQF_EVENT_WCDMA_CELL_EFACH_EPCH_ERACH_SUPPORT = 1964,
  eSQF_EVENT_GPSXTRA_T_CONN_TYPE = 1965,
  eSQF_EVENT_LTE_EMM_OTA_INCOMING_MSG = 1966,
  eSQF_EVENT_LTE_EMM_OTA_OUTGOING_MSG = 1967,
  eSQF_EVENT_LTE_ESM_OTA_INCOMING_MSG = 1968,
  eSQF_EVENT_LTE_ESM_OTA_OUTGOING_MSG = 1969,
  eSQF_EVENT_LTE_RRC_PLMN_SEARCH_START = 1970,
  eSQF_EVENT_LTE_RRC_PLMN_SEARCH_STOP = 1971,
  eSQF_EVENT_LTE_RRC_BG_TO_FG_PLMN_SEARCH = 1972,
  eSQF_EVENT_LTE_RRC_LATE_PLMN_SEARCH_RESPONSE = 1973,
  eSQF_EVENT_WCDMA_RRC_CRNTI = 1974,
  eSQF_EVENT_WCDMA_RRC_URNTI = 1975,
  eSQF_EVENT_DS_EPC_PDN = 1976,
  eSQF_EVENT_DS_EPC_SRAT_CLEANUP_TIMER = 1977,
  eSQF_EVENT_DS_EPC_EDCT_TIMER = 1978,
  eSQF_EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_STARTED = 1979,
  eSQF_EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_COMPLETED = 1980,
  eSQF_EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_ABORTED = 1981,
  eSQF_EVENT_GERAN_GRR__REDIR_STARTED = 1982,
  eSQF_EVENT_GERAN_GRR_REDIR_COMPLETED = 1983,
  eSQF_EVENT_GERAN_GRR_REDIR_ABORTED = 1984,
  eSQF_EVENT_1X_FSCH0_BURST_ASSIGN = 1985,
  eSQF_EVENT_1X_RSCH0_BURST_ASSIGN = 1986,
  eSQF_EVENT_SENSOR_STATE = 1987,
  eSQF_EVENT_SENSOR_TIMELINE = 1988,
  eSQF_EVENT_GSM_TO_LTE_RESEL_STARTED = 1989,
  eSQF_EVENT_GSM_TO_LTE_RESEL_ENDED = 1990,
  eSQF_EVENT_GSM_TO_LTE_REDIR_STARTED = 1991,
  eSQF_EVENT_GSM_TO_LTE_REDIR_ENDED = 1992,
  eSQF_EVENT_SD_SS_TIMER_LOG = 1993,
  eSQF_EVENT_LTE_RRC_STATE_CHANGE_TRIGGER = 1994,
  eSQF_EVENT_LTE_RRC_RADIO_LINK_FAILURE_STAT = 1995,
  eSQF_TDSCDMA_MAC_UL_AMR_RATE = 1996,
  eSQF_TDSCDMA_MAC_HS_T1_EXPIRY = 1997,
  eSQF_TDSCDMA_RLC_MAX_RESET = 1998,
  eSQF_TDSCDMA_RLC_RESETS = 1999,
  eSQF_TDSCDMA_RLC_OPEN_CLOSE = 2000,
  eSQF_TDSCDMA_RLC_MRW = 2001,
  eSQF_TDSCDMA_RLC_CONFIG = 2002,
  eSQF_TDSCDMA_RLC_TIMER_DISCARD_EXPIRY = 2003,
  eSQF_TDSCDMA_RRC_INTER_RAT_HANDOVER_START = 2004,
  eSQF_TDSCDMA_RRC_INTER_RAT_HANDOVER_END = 2005,
  eSQF_TDSCDMA_RRC_TDSCDMA_TO_GSM_RESELECTION_START = 2006,
  eSQF_TDSCDMA_RRC_TDSCDMA_TO_GSM_RESELECTION_END = 2007,
  eSQF_TDSCDMA_RRC_CELL_SELECTED = 2008,
  eSQF_TDSCDMA_RRC_PAGE_RECEIVED = 2009,
  eSQF_TDSCDMA_RRC_RL_FAILURE = 2010,
  eSQF_TDSCDMA_RRC_STATE = 2011,
  eSQF_TDSCDMA_RRC_OUT_OF_SERVICE = 2012,
  eSQF_TDSCDMA_RRC_RB0_SETUP_FAILURE = 2013,
  eSQF_TDSCDMA_RRC_PHYCHAN_EST_FAILURE = 2014,
  eSQF_TDSCDMA_RRC_MODE = 2016,
  eSQF_TDSCDMA_RRC_PHYCHAN_CFG_CHANGED = 2017,
  eSQF_TDSCDMA_RRC_CONN_REL_CAUSE = 2018,
  eSQF_TDSCDMA_RRC_CONN_REQ_CAUSE = 2019,
  eSQF_TDSCDMA_RRC_TIMER_EXPIRED = 2020,
  eSQF_TDSCDMA_RRC_UOOS_TIMER_USED = 2021,
  eSQF_TDSCDMA_RRC_UOOS_TIMER_START = 2022,
  eSQF_TDSCDMA_RRC_UOOS_TIMER_STOP = 2023,
  eSQF_TDSCDMA_RRC_CSP_SCAN_START = 2024,
  eSQF_TDSCDMA_RRC_CELL_SELECTION_FAIL = 2025,
  eSQF_TDSCDMA_RRC_BPLMN_START = 2026,
  eSQF_TDSCDMA_RRC_BPLMN_END = 2027,
  eSQF_TDSCDMA_RRC_BPLMN_SCAN_START = 2028,
  eSQF_TDSCDMA_RRC_BPLMN_SCAN_END = 2029,
  eSQF_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_START = 2030,
  eSQF_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_STOP = 2031,
  eSQF_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_EXPIRED = 2032,
  eSQF_TDSCDMA_RRC_MESSAGE_SENT = 2033,
  eSQF_TDSCDMA_RRC_MESSAGE_RECEIVED = 2034,
  eSQF_EVENT_LTE_ML1_UL_SPS_REPORT = 2040,
  eSQF_EVENT_LTE_ML1_DL_SPS_REPORT = 2041,
  eSQF_TDSCDMA_RRC_CSP_STATE = 2042,
  eSQF_TDSCDMA_RRC_HSDPA_START = 2043,
  eSQF_TDSCDMA_RRC_HSDPA_STOP = 2044,
  eSQF_TDSCDMA_RRC_HSUPA_START = 2045,
  eSQF_TDSCDMA_RRC_HSUPA_STOP = 2046,
  eSQF_TDSCDMA_RRC_SIB_RCVD = 2047,
  eSQF_EVENT_T_HDR_STATE = 2049,
  eSQF_EVENT_T_HDR_STATE_ENTRY = 2050,
  eSQF_EVENT_T_HDR_TXMSG_FAILED = 2051,
  eSQF_EVENT_T_HDR_TXMSG_ABORTED = 2052,
  eSQF_EVENT_T_HDR_CMD = 2053,
  eSQF_EVENT_T_HDR_CMD_IGNORED_STATE = 2054,
  eSQF_EVENT_T_HDR_IND = 2055,
  eSQF_EVENT_T_HDR_IND_IGND_STATE = 2056,
  eSQF_EVENT_T_HDR_INIT_DEFAULT = 2057,
  eSQF_EVENT_T_HDR_INIT_NV = 2058,
  eSQF_EVENT_T_HDR_ALMP_CON_OPEN = 2059,
  eSQF_EVENT_T_HDR_ALMP_SYS_ACQRD = 2060,
  eSQF_EVENT_T_HDR_CON_GET_S_TIME = 2061,
  eSQF_EVENT_T_HDR_HMP_WAIT_ACMAC = 2062,
  eSQF_EVENT_T_HDR_IDLE_RSL_ALLOW = 2063,
  eSQF_EVENT_T_HDR_OVHD_GET_SPMSG = 2064,
  eSQF_EVENT_T_HDR_OVHD_GET_APMSG = 2065,
  eSQF_EVENT_T_HDR_OVHD_INFO_UPDT = 2066,
  eSQF_EVENT_T_HDR_OVHD_AP_UPDATE = 2067,
  eSQF_EVENT_T_HDR_OVHD_GET_CC = 2068,
  eSQF_EVENT_T_HDR_OVHD_GET_SEC24 = 2069,
  eSQF_EVENT_T_HDR_OVHD_M_IGN_ST = 2070,
  eSQF_EVENT_T_HDR_OVHD_M_IGN_RED = 2071,
  eSQF_EVENT_T_HDR_OVHD_QC_MSG_RX = 2072,
  eSQF_EVENT_T_HDR_OVHD_IGN_AP_LK = 2073,
  eSQF_EVENT_T_HDR_SLP_AC_MSG_TX = 2074,
  eSQF_EVENT_T_HDR_SLP_RTC_MSG_TX = 2075,
  eSQF_EVENT_T_HDR_SLP_ABORT_MSG = 2076,
  eSQF_EVENT_T_HDR_SLP_ACK_MSG = 2077,
  eSQF_EVENT_T_HDR_LMAC_AMAC_ABRT = 2078,
  eSQF_EVENT_T_HDR_LMAC_RMAC_STOP = 2079,
  eSQF_EVENT_T_HDR_LMAC_WAKEUP = 2080,
  eSQF_EVENT_T_HDR_LMAC_AMODE_ENT = 2081,
  eSQF_EVENT_T_HDR_LMAC_PILOT_MES = 2082,
  eSQF_EVENT_T_HDR_LMAC_CHAN_MEAS = 2083,
  eSQF_EVENT_T_HDR_LMAC_SLEEP = 2084,
  eSQF_EVENT_T_HDR_CMAC_IS_ACTIVE = 2085,
  eSQF_EVENT_T_HDR_AMAC_START_ACC = 2086,
  eSQF_EVENT_T_HDR_AMAC_IS_ACTIVE = 2087,
  eSQF_EVENT_T_HDR_AMAC_LAST_TX_P = 2088,
  eSQF_EVENT_T_HDR_AMAC_SEND_PRBE = 2089,
  eSQF_EVENT_T_HDR_FMAC_IS_ACTIVE = 2090,
  eSQF_EVENT_T_HDR_RMAC_IS_ACTIVE = 2091,
  eSQF_EVENT_T_HDR_SMP_T_KA_IGN_S = 2092,
  eSQF_EVENT_T_HDR_SMP_T_KA_DSBLD = 2093,
  eSQF_EVENT_T_HDR_SMP_T_CRSP_IGN = 2094,
  eSQF_EVENT_T_HDR_SMP_IGN_KA_RSP = 2095,
  eSQF_EVENT_T_HDR_AMP_RXATI_MTCH = 2096,
  eSQF_EVENT_T_HDR_AMP_GET_TX_ATI = 2097,
  eSQF_EVENT_T_HDR_AMP_GET_UATI = 2098,
  eSQF_EVENT_T_HDR_AMP_GET_SSEED = 2099,
  eSQF_EVENT_T_HDR_SCP_PREV_SES = 2100,
  eSQF_EVENT_T_HDR_SCP_CFG_SUBTPE = 2101,
  eSQF_EVENT_T_HDR_SCP_GET_SUBTPE = 2102,
  eSQF_EVENT_T_HDR_SCP_FROM_NV = 2103,
  eSQF_EVENT_T_HDR_SCP_IS_OPEN = 2104,
  eSQF_EVENT_T_HDR_SCP_GET_TOKEN = 2105,
  eSQF_EVENT_T_HDR_SMP_SET_T_KA = 2106,
  eSQF_EVENT_T_HDR_SMP_SET_T_KANV = 2107,
  eSQF_EVENT_T_HDR_SMP_UPD_T_KA = 2108,
  eSQF_EVENT_T_HDR_SMP_CLR_T_KA = 2109,
  eSQF_EVENT_T_HDR_SMP_DEF_T_KA = 2110,
  eSQF_EVENT_T_HDR_BCMCS_FLOW_STATE_ENTRY = 2111,
  eSQF_TDSCDMA_RRC_LLC_SUBSTATE = 2112,
  eSQF_TDSCDMA_RRC_MCM_SUBSTATE = 2113,
  eSQF_TDSCDMA_RRC_CCM_SUBSTATE = 2114,
  eSQF_TDSCDMA_RRC_CU_SUBSTATE = 2115,
  eSQF_TDSCDMA_RRC_NV_RRC_VERSION = 2116,
  eSQF_TDSCDMA_RRC_LLC_TOC_USAGE = 2117,
  eSQF_TDSCDMA_RRC_LLC_OC_STATUS = 2118,
  eSQF_TDSCDMA_RRC_OOS_TRIGGERED = 2119,
  eSQF_EVENT_WCDMA_RRC_RELEASE_CAUSE = 2120,
  eSQF_EVENT_WCDMA_RRC_REJECT_CAUSE = 2121,
  eSQF_EVENT_DS_MO_SMS_STATUS = 2122,
  eSQF_EVENT_DS_MO_SMS_RETRY_ATTEMPT = 2123,
  eSQF_EVENT_DS_MT_SMS_NOTIFY = 2124,
  eSQF_EVENT_DS_WMS_SEARCH_REQUEST = 2125,
  eSQF_EVENT_DS_SMS_COMMAND_PROCESSED = 2126,
  eSQF_EVENT_DS_SMS_MT_NOTIFY = 2127,
  eSQF_EVENT_DS_SMS_CBS_MSG_RECEIVED = 2128,
  eSQF_EVENT_DS_SMS_ETWS_PRIM_RECEIVED = 2129,
  eSQF_EVENT_TDSCDMA_RRC_ACQUISITION_COMPLETE = 2130,
  eSQF_EVENT_TDSCDMA_L1_STATE = 2131,
  eSQF_EVENT_TDSCDMA_NEW_SERVING_CELL = 2132,
  eSQF_EVENT_TDSCDMA_L1_SUSPEND = 2133,
  eSQF_EVENT_TDSCDMA_L1__RESUME = 2134,
  eSQF_EVENT_TDSCDMA_L1_STOPPED = 2135,
  eSQF_EVENT_TDSCDMA_L1_ACQ_SUBSTATE = 2136,
  eSQF_EVENT_TDSCDMA_PHYCHAN_CFG_CHANGED = 2137,
  eSQF_EVENT_TDSCDMA_RACH_STATUS = 2138,
  eSQF_EVENT_TDSCDMA_MEASUREMENT_EVENT = 2139,
  eSQF_EVENT_GNSS_FAST_TCAL_END = 2140,
  eSQF_EVENT_IMS_CODEC_INITIALIZATION = 2141,
  eSQF_EVENT_IMS_CODEC_RATE_CHANGE_EVENT = 2142,
  eSQF_EVENT_T_HDR_CSNA_DUP_3G1X_SRV_MSG = 2143,
  eSQF_EVENT_T_HDR_IDLE_CONNECT_REASON = 2144,
  eSQF_EVENT_T_HDR_IDLE_CONNECTION_DENIED_REASON = 2145,
  eSQF_EVENT_T_HDR_IDLE_CONNECTION_SETUP_FAIL_REASON = 2146,
  eSQF_EVENT_T_HDR_OVHD_PRE_REG_IS_ALLOWED = 2147,
  eSQF_EVENT_T_HDR_SAP_TUNNEL_IS_ENABLED = 2148,
  eSQF_EVENT_T_HDR_SAP_CONNECTION_IS_OPEN = 2149,
  eSQF_EVENT_T_HDR_ALMP_LTE_RESELECT = 2150,
  eSQF_EVENT_T_HDR_OVHD_ORNL_IS_UPDATED = 2151,
  eSQF_EVENT_T_HDR_LTE_RESEL_STATUS = 2152,
  eSQF_EVENT_LTE_TO_1X_TT = 2153,
  eSQF_EVENT_LTE_TO_1X_HO = 2154,
  eSQF_EVENT_LTE_TO_1X_DL_GCSNA_MSG = 2155,
  eSQF_EVENT_LTE_TO_1X_UL_GCSNA_MSG = 2156,
  eSQF_EVENT_LTE_RRC_UL_MSG_MEAS_REPORT = 2157,
  eSQF_EVENT_IMS_QIPCALL_SIP_SESSION_EVENT = 2158,
  eSQF_EVENT_SIP_REG_START_EVENT = 2159,
  eSQF_EVENT_SIP_REG_REQ_SENT_EVENT = 2160,
  eSQF_EVENT_SIP_REG_RESP_RCVD_EVENT = 2161,
  eSQF_EVENT_SIP_REG_END_EVENT = 2162,
  eSQF_EVENT_SIP_REG_DREG_START_EVENT = 2163,
  eSQF_EVENT_SIP_REG_DREG_END_EVENT = 2164,
  eSQF_EVENT_WCDMA_FACH_DRX_ACTION = 2165,
  eSQF_EVENT_RRC_COMPLETE_SIB_RECEIVED = 2166,
  eSQF_EVENT_1X_TO_LTE_RESEL_DONE = 2167,
  eSQF_EVENT_SSR_SUBSYS_PWR_DOWN = 2168,
  eSQF_EVENT_SSR_SUBSYS_PWR_UP = 2169,
  eSQF_EVENT_DS_DSD_PREFERRED_RADIO = 2170,
  eSQF_EVENT_DS_DSD_TIMER_STARTED = 2171,
  eSQF_EVENT_DS_DSD_TIMER_STOPPED = 2172,
  eSQF_EVENT_DS_DSD_TIMER_EXPIRED = 2173,
  eSQF_EVENT_DS_DSD_RADIO_THROTTLE = 2174,
  eSQF_EVENT_DS_DSD_RADIO_UNTHROTTLE = 2175,
  eSQF_EVENT_TDSCDMA_TO_TDSCDMA_RESELECTION_START = 2176,
  eSQF_EVENT_TDSCDMA_TO_TDSCDMA_RESELECTION_END = 2177,
  eSQF_EVENT_GSM_CS_CALL_ESTABLISHMENT_FAILURE = 2178,
  eSQF_EVENT_GSM_CS_CALL_DROPPED = 2179,
  eSQF_EVENT_GSM_LOST_SERVICE = 2180,
  eSQF_EVENT_GSM_IN_SERVICE = 2181,
  eSQF_EVENT_GSM_PLMN_LIST_GSM_SUB_SEARCH_ENDED = 2182,
  eSQF_EVENT_SD_WRLF_2MIN_TIMER_EXPIRY = 2183,
  eSQF_EVENT_CM_RLF_RECOVERY_START = 2184,
  eSQF_EVENT_CM_RLF_RECOVERY_END = 2185,
  eSQF_EVENT_T_HDR_CONN_ATTEMPT_ENDED = 2186,
  eSQF_EVENT_T_HDR_CONN_TERMINATED = 2187,
  eSQF_EVENT_MM_TIMER_EXPIRY = 2188,
  eSQF_EVENT_GNSS_RESET_LOCATION_SERVICE_RECEIVED = 2189,
  eSQF_EVENT_GNSS_RESET_LOCATION_SERVICE_DONE = 2190,
  eSQF_EVENT_TDSCDMA_HANDOVER_START = 2191,
  eSQF_EVENT_TDSCDMA_HANDOVER_END = 2192,
  eSQF_EVENT_TDSCDMA_TS0_JDS_UPDATE = 2193,
  eSQF_EVENT_TDSCDMA_NONTS0_JDS_UPDATE = 2194,
  eSQF_EVENT_TDSCDMA_UE_PAGED = 2195,
  eSQF_EVENT_TDSCDMA_DRX_REACQ = 2196,
  eSQF_EVENT_TDSCDMA_DL_SYNC_STATUS = 2197,
  eSQF_EVENT_TDSCDMA_HSDPA_STATUS = 2198,
  eSQF_EVENT_TDSCDMA_HSUPA_STATUS = 2199,
  eSQF_EVENT_GHDI_MVS_STATE = 2200,
  eSQF_EVENT_LTE_RRC_CELL_RESEL_STARTED = 2201,
  eSQF_EVENT_WCDMA_CM_STATE_CHANGE = 2202,
  eSQF_EVENT_TDSCDMA_TO_LTE_RESELECTION_START = 2203,
  eSQF_EVENT_TDSCDMA_TO_LTE_RESELECTION_END = 2204,
  eSQF_EVENT_TDSCDMA_TO_LTE_REDIRECTION_START = 2205,
  eSQF_EVENT_TDSCDMA_TO_LTE_REDIRECTION_END = 2206,
  eSQF_EVENT_TDSCDMA_DED_PRIORITIES_VALIDITY_TIMER_START = 2207,
  eSQF_EVENT_TDSCDMA_DED_PRIORITIES_VALIDITY_TIMER_EXPIRED = 2208,
  eSQF_EVENT_LTE_RRC_IRAT_CCO_FROM_EUTRAN_START = 2209,
  eSQF_EVENT_LTE_RRC_IRAT_CCO_FROM_EUTRAN_END = 2210,
  eSQF_EVENT_HOCM_TRANSMITTED = 2211,
  eSQF_EVENT_DS_DSD_ATTACH_PDN_CHANGE = 2222,
  eSQF_EVENT_TDSCDMA_INTER_RAT_PFR_START = 2223,
  eSQF_EVENT_TDSCDMA_INTER_RAT_PFR_END = 2224,
  eSQF_EVENT_TDSCDMA_RRC_INTER_RAT_CCO_START = 2225,
  eSQF_EVENT_WCDMA_RRC_CSFB_SIB_CONTAINER = 2226,
  eSQF_EVENT_LTE_RRC_EMBMS_OOS_WARN_IND = 2227,
  eSQF_EVENT_LTE_RRC_EMBMS_ACT_TMGI_LIST_IND = 2228,
  eSQF_EVENT_LTE_RRC_EMBMS_AVAIL_TMGI_LIST_IND = 2229,
  eSQF_EVENT_LTE_RRC_MCCH_CHANGE_NOTIFICATION = 2230,
  eSQF_EVENT_RPM_MCC_MNC_VALUE = 2231,
  eSQF_EVENT_RPM_ENABLED = 2232,
  eSQF_EVENT_CPDP_COUNTERS_UPDATE = 2233,
  eSQF_EVENT_RPM_START_LR3_TIMER = 2234,
  eSQF_EVENT_RPM_LR3_TIMER_EXPIRED = 2235,
  eSQF_EVENT_RPM_BACKOFF_TIMER_VAL = 2236,
  eSQF_EVENT_RPM_READ_ALL_PARAM = 2237,
  eSQF_EVENT_RPM_BACKOFF_TIMER_EXP = 2238,
  eSQF_EVENT_LTE_SCELL_CONFIGURATION = 2239,
  eSQF_EVENT_LTE_SCELL_ACT_DEACT_CMD = 2240,
  eSQF_EVENT_LTE_SCELL_DEACTIVATION_TIMER_EXPIRY = 2241,
  eSQF_EVENT_SCELL_STATE_CHANGE_INTERNAL = 2242,
  eSQF_EVENT_GNSS_SPECTRUM_ANALYZER_STATUS = 2243,
  eSQF_EVENT_GSM_TO_TDSCDMA_RESEL_START = 2244,
  eSQF_EVENT_GSM_TO_TDSCDMA_RESEL_END = 2245,
  eSQF_EVENT_AUDIO_MWS_DIAG_SERVICE = 2246,
  eSQF_EVENT_WCDMA_ASF_TIMER_EXPIRY = 2247,
  eSQF_EVENT_ASF_SCAN_START = 2248,
  eSQF_EVENT_ASF_SCAN_END = 2249,
  eSQF_EVENT_TDSCDMA_RRC_INTER_RAT_CCO_END = 2250,
  eSQF_EVENT_SECAPITEST_TESTCASE_START = 2251,
  eSQF_EVENT_SECAPITEST_TESTCASE_END = 2252,
  eSQF_EVENT_TDSCDMA_RXD_STATE = 2253,
  eSQF_EVENT_WCDMA_RRC_ASF_TIMER_STATUS = 2254,
  eSQF_EVENT_WCDMA_RRC_CSG_DETECTED = 2255,
  eSQF_EVENT_CM_SSAC_CALL = 2256,
  eSQF_EVENT_CM_SSAC_TIME = 2257,
  eSQF_EVENT_PAGE_MATCH = 2258,
  eSQF_EVENT_CSFB_CALL_TYPE = 2259,
  eSQF_EVENT_WCDMA_ASF_MEAS_REQ_RCVD = 2460,
  eSQF_EVENT_SECAPITEST_TESTCASE_SUCCESS = 2461,
  eSQF_EVENT_SECAPITEST_TESTCASE_FAILURE = 2462,
  eSQF_EVENT_HDR_MSG_RX_PAGE = 2463,
  eSQF_EVENT_TDSCDMA_RRC_HANDOVER_START = 2464,
  eSQF_EVENT_TDSCDMA_RRC_HANDOVER_END = 2465,
  eSQF_EVENT_IMS_VIDEO_CODEC_INITIALIZATION = 2466,
  eSQF_EVENT_IMS_VIDEO_CODEC_RATE_CHANGE_EVENT = 2467,
  eSQF_EVENT_GPSXTRA_T_POSITION_INJECTION = 2468,
  eSQF_EVENT_TDSCDMA_RRC_X_TO_TDSCDMA_HANDOVER_START = 2469,
  eSQF_EVENT_WCDMA_ENH_L1_STATE = 2470,
  eSQF_EVENT_CM_CALL_EVENT_ORIG_2 = 2471,
  eSQF_EVENT_CM_CALL_EVENT_CONNECT_2 = 2472,
  eSQF_EVENT_CM_CALL_EVENT_END_2 = 2473,
  eSQF_EVENT_TDSCDMA_RRC_X_TO_TDSCDMA_HANDOVER_END = 2474,
  eSQF_EVENT_1X_TO_LTE_RESEL_START = 2475,
  eSQF_EVENT_DS_DORMANCY_STATUS_UM_QUEUE_STATS = 2476,
  eSQF_EVENT_DS_DORMANCY_STATUS_RM_QUEUE_STATS = 2477,
  eSQF_EVENT_DS_CALL_STATUS = 2478,
  eSQF_EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN_END = 2479,
  eSQF_EVENT_LTE_RRC_IRAT_HO_TO_EUTRAN_START = 2480,
  eSQF_EVENT_LTE_RRC_UL_MSG_MEAS_REPORT_MEASOBJ_MODE = 2481,
  eSQF_EVENT_TDSCDMA_RRC_ACQUISITION_START = 2482,
  eSQF_EVENT_LTE_SCELL_STATE_CHANGE_ENHANCED = 2483,
  eSQF_EVENT_SD_EVENT_ACTION__HYBR2 = 2484,
  eSQF_EVENT_UMTS_NAS_CB_CTCH_START = 2485,
  eSQF_EVENT_UMTS_NAS_CB_BMC_MSG_DECODE_FAIL = 2486,
  eSQF_EVENT_WCDMA_RLC_UL_CONFIG = 2487,
  eSQF_EVENT_NAS_CB_CTCH_STOP = 2488,
  eSQF_EVENT_GPS_PD_COMM_NW_CONNECTING = 2489,
  eSQF_EVENT_GPS_PD_COMM_NW_CONNECTED = 2490,
  eSQF_EVENT_GPS_PD_COMM_SERVER_CONNECTING = 2491,
  eSQF_EVENT_GPS_PD_COMM_SERVER_CONNECTED = 2492,
  eSQF_EVENT_BROADCAST_CYCLE_DISABLED = 2493,
  eSQF_EVENT_BROADCAST_CYCLE_ENABLED = 2494,
  eSQF_EVENT_WCDMA_ASDIV_TYPE1_SWITCH_RSCP_BASED = 2495,
  eSQF_EVENT_WCDMA_ASDIV_TYPE1_SWITCH_TXAGC_BASED = 2496,
  eSQF_EVENT_WCDMA_ASDIV_TYPE1_SWITCHBACK_MTPL_BASED = 2497,
  eSQF_EVENT_WCDMA_ASDIV_TYPE1_SWITCHBACK_TXAGC_BASED = 2498,
  eSQF_EVENT_WCDMA_ASDIV_TYPE2_SWITCH_RSCP_BASED = 2499,
  eSQF_EVENT_WCDMA_ASDIV_TYPE2_SWITCH_MTPL_BASED = 2500,
  eSQF_EVENT_WCDMA_ASDIV_TYPE2_SWITCH_RSCP_LOOPBACK_BASED = 2501,
  eSQF_EVENT_WCDMA_ASDIV_TYPE2_SWITCHBACK_DEGRADATION_BASED = 2502,
  eSQF_EVENT_WCDMA_ASDIV_PROBE_BOTH_ANTENNAS = 2503,
  eSQF_EVENT_TDSCDMA_RRC_HSUPA_SUPPORT_STATUS = 2504,
  eSQF_EVENT_WCDMA_HS_RACH_OP = 2505,
  eSQF_EVENT_WLAN_FW_SLM_CONS_BCN_MISS = 2506,
  eSQF_EVENT_WLAN_FW_SLM_RSSI_MONITOR = 2507,
  eSQF_EVENT_SD_HYBR2_BSR_START = 2508,
  eSQF_EVENT_SD_HYBR2_BSR_END = 2509,
  eSQF_EVENT_IWLAN_S2B_CALL_TRACER_LOGGING = 2510,
  eSQF_EVENT_WCDMA_RRC_FAILURE = 2511,
  eSQF_EVENT_WCDMA_CME_STATE = 2512,
  eSQF_EVENT_WCDMA_RxD_STATE = 2513,
  eSQF_EVENT_WCDMA_RACH_ABORT_CAUSE = 2514,
  eSQF_EVENT_CM_PH_DYN_SWITCH = 2515,
  eSQF_EVENT_TDSCDMA_RRC_DMCR_ENABLED = 2516,
  eSQF_EVENT_ASDIV_TESTMODE1_SWITCH = 2517,
  eSQF_EVENT_PM_UE_MODE = 2518,
  eSQF_EVENT_TDSCDMA_SELF_HOSTING = 2519,
  eSQF_EVENT_LTE_ML1_SEARCH_IDLE = 2520,
  eSQF_EVENT_GSTK_BIP_STATUS = 2521,
  eSQF_EVENT_TDSCDMA_RRC_DSDS_TA_BLOCK = 2522,
  eSQF_EVENT_PS_SYSTEM_STATUS = 2523,
  eSQF_EVENT_QMI_SYSTEM_STATUS = 2524,
  eSQF_EVENT_PS_SYSTEM_STATUS_EX = 2525,
  eSQF_EVENT_QMI_SYSTEM_STATUS_EX = 2526,
  eSQF_EVENT_ASDIV_IDLE_SWITCH_FACH_INIT = 2527,
  eSQF_EVENT_ASDIV_IDLE_SWITCHBACK_FACH_INIT = 2528,
  eSQF_EVENT_ASDIV__IDLE_SWITCH_OOS_TIMER = 2529,
  eSQF_EVENT_ASDIV__IDLE_SWITCHBACK_OOS_TIMER = 2530,
  eSQF_EVENT_ASDIV__IDLE_SWITCH_RACH_NACK = 2531,
  eSQF_EVENT_ASDIV__IDLE_SWITCHBACK_RACH_NACK = 2532,
  eSQF_EVENT_ASDIV__ACQ_SWITCH = 2533,
  eSQF_EVENT_ASDIV__ACQ_SWITCHBACK = 2534,
  eSQF_EVENT_LTE_RRC_PAGING_UE_ID = 2535,
  eSQF_EVENT_LTE_ML1_ASDIV = 2536,
  eSQF_EVENT_LTE_RRC_CGI_START_INDI = 2537,
  eSQF_EVENT_DS_UM_QUEUE_STATS_EX = 2538,
  eSQF_EVENT_HSPA = 2539,
  eSQF_EVENT_TDSCDMA_TO_GSM_REDIRECTION_START = 2540,
  eSQF_EVENT_TDSCDMA_TO_GSM_REDIRECTION_END = 2541,
  eSQF_EVENT_LTE_RRC_EMBMS_AVAIL_SAI_LIST_IND = 2542,
  eSQF_EVENT_LTE_RRC_EMBMS_INTEREST_IND = 2543,
  eSQF_EVENT_LTE_RRC_EMBMS_SIGNAL_STRENGTH_REPORTING = 2544,
  eSQF_EVENT_GSM_VS_INTERFACE_TYPE_1 = 2545,
  eSQF_EVENT_GSM_VS_INTERFACE_TYPE_2 = 2546,
  eSQF_EVENT_GSM_VS_INTERFACE_GHDI_CONTROL = 2547,
  eSQF_EVENT_WCDMA_EUL_REL7_FEAT_OP = 2548,
  eSQF_EVENT_WCDMA_RRC_CU_STATUS = 2549,
  eSQF_EVENT_WCDMA_HS_SCCH_ORDER_VER2 = 2550,
  eSQF_EVENT_AUDIO_PATH_DELAY_CHANGE = 2551,
  eSQF_EVENT_LTE_RRC_CAMPED_CELL_STATUS = 2552,
  eSQF_EVENT_DATAMODEM_IPA_DROP_PKT_DL = 2553,
  eSQF_EVENT_DATAMODEM_IPA_DROP_PKT_UL = 2554,
  eSQF_EVENT_NAS_LAU = 2555,
  eSQF_EVENT_NAS_ATTACH = 2556,
  eSQF_EVENT_NAS_RAU = 2557,
  eSQF_EVENT_NAS_MO_DETACH = 2558,
  eSQF_EVENT_NAS_MT_DETACH = 2559,
  eSQF_EVENT_NAS_TAU = 2560,
  eSQF_EVENT_GSM_CELL_SELECTED = 2561,
  eSQF_EVENT_GSM_DS_CELL_SELECTED = 2562,
  eSQF_EVENT_WLAN_QCA_BMISS = 2563,
  eSQF_EVENT_WLAN_QCA_RSSI_MONITOR = 2564,
  eSQF_EVENT_DS_EPC_PDN_EX = 2565,
  eSQF_EVENT_DS_EPC_SRAT_CLEANUP_TIMER_EX = 2566,
  eSQF_EVENT_DS_DSD_PREFERRED_RADIO_INFO = 2567,
  eSQF_EVENT_LTE_RRC_NEW_CELL_IND_EXT_EARFCN = 2568,
  eSQF_EVENT_LTE_RRC_CELL_RESEL_FAILURE_EXT_EARFCN = 2569,
  eSQF_EVENT_LTE_RRC_HO_FAILURE_EXT_EARFCN = 2570,
  eSQF_EVENT_LTE_RRC_SIB_READ_FAILURE_EXT_EARFCN = 2571,
  eSQF_EVENT_LTE_RRC_CELL_RESEL_STARTED_EXT_EARFCN = 2572,
  eSQF_EVENT_LTE_RRC_MCCH_CHANGE_NOTIFICATION_EXT_EARFCN = 2573,
  eSQF_EVENT_LTE_RRC_CELL_BLACKLIST_IND_EXT_EARFCN = 2574,
  eSQF_EVENT_WCDMA_RRC_INTER_FREQ_HHO_STATUS = 2575,
  eSQF_EVENT_DS_DSD_TIMER = 2576,
  eSQF_EVENT_TDSCDMA_TO_TDSCDMA_REDIRECTION_START = 2577,
  eSQF_EVENT_TDSCDMA_TO_TDSCDMA_REDIRECTION_END = 2578,
  eSQF_EVENT_WLAN_QCA_HEARTBEAT_FAILURE = 2579,
  eSQF_EVENT_DS_3GPP_SVC_THROTTLE = 2580,
  eSQF_EVENT_DS_3GPP_PDN_THROTTLE = 2581,
  eSQF_EVENT_GSM_TO_TDSCDMA_REDIR_STARTED = 2582,
  eSQF_EVENT_GSM_TO_TDSCDMA_REDIR_ENDED = 2583,
  eSQF_EVENTS_DS_GSM_PAGE_MISSED = 2584,
  eSQF_EVENT_GSM_TO_WCDMA_REDIR_STARTED = 2585,
  eSQF_EVENT_GSM_TO_WCDMA_REDIR_ENDED = 2586,
  eSQF_EVENT_DS_RADIO_STACK_STATE = 2587,
  eSQF_EVENT_DS_CALL__CONTROL_STATE = 2588,
  eSQF_EVENT_DS_BEARER_CONTROL_STATE = 2589,
  eSQF_EVENT_LTE_SCELL_STATE_CHANGE_ENHANCED2 = 2590,
  eSQF_EVENT_LTE_SCELL_PCELL_TIME_DRIFT = 2591,
  eSQF_EVENT_LTE_SCELL_WB_NB_TIME_DRIFT = 2592,
  eSQF_TDSCDMA_RRC_SIB_RCVD_V2 = 2593,
  eSQF_EVENT_LTE_ML1_EPHR_REPORT = 2594,
  eSQF_EVENT_LTE_TO_LTE_REDIRECTION = 2595,
  eSQF_EVENT_TDSCDMA_DA_BACKOFF_TIMER_START = 2596,
  eSQF_EVENT_TDSCDMA_DA_BACKOFF_TIMER_STOP = 2597,
  eSQF_EVENT_TDSCDMA_DA_BACKOFF_TIMER_EXPIRED = 2598,
  eSQF_EVENT_WCDMA_TO_GSM_REDIRECTION_START = 2599,
  eSQF_EVENT_WCDMA_TO_GSM_REDIRECTION_END = 2600,
  eSQF_EVENT_WCDMA_TO_WCDMA_REDIRECTION_START = 2601,
  eSQF_EVENT_WCDMA_TO_WCDMA_REDIRECTION_END = 2602,
  eSQF_EVENT_GNSS_RCVR_STATE = 2603,
  eSQF_EVENT_GSM_SI_CACHE_UPDATE_ENTRY = 2604,
  eSQF_EVENT_GSM_SI_CACHE_RETRIEVE = 2605,
  eSQF_EVENT_GSM_SI_CACHE_FLUSH = 2606,
  eSQF_EVENT_NAS_PLMN_FOUND = 2607,
  eSQF_EVENT_LTE_SUB_FRAME_NUMBER = 2608,
  eSQF_EVENT_GNSS_POSITION_INCONSISTENCY = 2609,
  eSQF_EVENT_IPV6_EXT_ADDRESS = 2610,
  eSQF_EVENT_DS3G_COEX_FLOW_CONTROL = 2611,
  eSQF_EVENT_NAS_LTE_IRAT_SHORT_TIMER_STARTED = 2612,
  eSQF_EVENT_NAS_LTE_IRAT_LONG_TIMER_STARTED = 2613,
  eSQF_EVENT_NAS_LTE_IRAT_SEARCH_STARTED = 2614,
  eSQF_EVENT_NAS_HPLMN_IRAT_SEARCH_STARTED = 2615,
  eSQF_EVENT_NAS_LTE_IRAT_AVAIL_TO_NOTAVAIL = 2616,
  eSQF_EVENT_NAS_LTE_IRAT_NOTAVAIL_TO_AVAIL = 2617,
  eSQF_EVENT_DIAG_DROP_DEBUG = 2618,
  eSQF_EVENT_FULL_SRV_EMC_CALL = 2619,
  eSQF_EVENT_LTE_EMM_TIMER_STOP = 2620,
  eSQF_EVENT_LTE_ESM_TIMER_STOP = 2621,
}eSQF_EVENT;

typedef enum _eSQF_MSG_{
  eSQF_MSG_Legacy = 0,
  eSQF_MSG_Audio_Format = 1,
  eSQF_MSG_Audio_Vocoder_Services = 2,
  eSQF_MSG_Boot = 3,
  eSQF_MSG_Blue_Tooth = 4,
  eSQF_MSG_Call_Manager = 5,
  eSQF_MSG_Compact_Multimedia_Extensions = 6,
  eSQF_MSG_Diagnostics_Services = 7,
  eSQF_MSG_Data_Service_Memory_Buffers = 8,
  eSQF_MSG_File_Services = 9,
  eSQF_MSG_HandSet_Services = 10,
  eSQF_MSG_Modem_DSP = 11,
  eSQF_MSG_Qualcomm_DSP_Service_Task = 12,
  eSQF_MSG_Realtime_Executive = 13,
  eSQF_MSG_Radio_Frequency = 14,
  eSQF_MSG_CDMA_System_Determination = 15,
  eSQF_MSG_Serial_Input_Output = 16,
  eSQF_MSG_Voice_Recognition = 17,
  eSQF_MSG_Wireless_Messaging_Services = 18,
  eSQF_MSG_Global_Positioning_System = 19,
  eSQF_MSG_Multi_Mode_Controller = 20,
  eSQF_MSG_User_Identity_Module = 21,
  eSQF_MSG_Task_Main_Controller = 22,
  eSQF_MSG_Factory_Test_Mode = 23,
  eSQF_MSG_AAGPS = 24,
  eSQF_MSG_Sleep = 25,
  eSQF_MSG_System_Arbitration_Module = 26,
  eSQF_MSG_Shared_Resource_Manager = 27,
  eSQF_MSG_Searcher_Debug = 29,
  eSQF_MSG_SanDisk_FAT_Filesystem = 30,
  eSQF_MSG_Joystick = 31,
  eSQF_MSG_Media_Forward_Link_Only = 32,
  eSQF_MSG_Digital_TV = 33,
  eSQF_MSG_TCXO_Manager = 34,
  eSQF_MSG_EFS = 35,
  eSQF_MSG_IRDA = 36,
  eSQF_MSG_FM_Radio = 37,
  eSQF_MSG_Accessory_Attachment_Manager = 38,
  eSQF_MSG_Battery_Manager = 39,
  eSQF_MSG_Position_Engine = 40,
  eSQF_MSG_QIP_Call = 41,
  eSQF_MSG_Flute = 42,
  eSQF_MSG_Camera = 43,
  eSQF_MSG_HSUSB = 44,
  eSQF_MSG_Flow_Controller = 45,
  eSQF_MSG_USB_Host = 46,
  eSQF_MSG_Profiler = 47,
  eSQF_MSG_MGP = 48,
  eSQF_MSG_MGP_ME = 49,
  eSQF_MSG_GPS_OS = 50,
  eSQF_MSG_MGP_PE = 51,
  eSQF_MSG_GPS_SM = 52,
  eSQF_MSG_IMS = 53,
  eSQF_MSG_MBP_RF = 54,
  eSQF_MSG_SNS = 55,
  eSQF_MSG_WM = 56,
  eSQF_MSG_LK = 57,
  eSQF_MSG_Power_Debug = 58,
  eSQF_MSG_Dynamic_Clock_And_Voltage_Scaling = 59,
  eSQF_MSG_Android_ADB = 60,
  eSQF_MSG_Video_Encoder = 61,
  eSQF_MSG_VENC_OMX = 62,
  eSQF_MSG_GAN = 63,
  eSQF_MSG_KINETO_GAN = 64,
  eSQF_MSG_Android_QCRIL = 65,
  eSQF_MSG_A2 = 66,
  eSQF_MSG_Linux_Data = 67,
  eSQF_MSG_ECALL = 68,
  eSQF_MSG_CHORD = 69,
  eSQF_MSG_QCNE = 70,
  eSQF_MSG_APPS_CAD_General = 71,
  eSQF_MSG_OMADM = 72,
  eSQF_MSG_SIWA = 73,
  eSQF_MSG_APR_Modem = 74,
  eSQF_MSG_APR_Apps = 75,
  eSQF_MSG_APR_ADSP = 76,
  eSQF_MSG_SRD_General = 77,
  eSQF_MSG_ACDB_General = 78,
  eSQF_MSG_DALTF = 79,
  eSQF_MSG_CFM = 80,
  eSQF_MSG_PMIC = 81,
  eSQF_MSG_GPS_SDP = 82,
  eSQF_MSG_TLE = 83,
  eSQF_MSG_WWAN_LOC = 85,
  eSQF_MSG_GNSS_LOCMW = 86,
  eSQF_MSG_QSET = 87,
  eSQF_MSG_QBI = 88,
  eSQF_MSG_ADC = 89,
  eSQF_MSG_MMODE_QMI = 90,
  eSQF_MSG_MCFG = 91,
  eSQF_MSG_SSM = 92,
  eSQF_MSG_MPOWER = 93,
  eSQF_MSG_RMTS = 94,
  eSQF_MSG_ADIE = 95,
  eSQF_MSG_VT_VCEL = 96,
  eSQF_MSG_ATS = 97,
  eSQF_MSG_Advanced_Optional_Software_Technology_License_Manager = 108,
  eSQF_MSG_QTV = 500,
  eSQF_MSG_QTV_Levels = 501,
  eSQF_MSG_ONCRPC = 502,
  eSQF_MSG_ONCRPC_Misc_Modem = 503,
  eSQF_MSG_ONCRPC_Misc_Apps = 504,
  eSQF_MSG_ONCRPC_CM_Modem = 505,
  eSQF_MSG_ONCRPC_CM_Apps = 506,
  eSQF_MSG_ONCRPC_DB = 507,
  eSQF_MSG_ONCRPC_SND = 508,
  eSQF_MSG_Graphics = 509,
  eSQF_MSG_TLE_XTM = 600,
  eSQF_MSG_TLE_TLM = 601,
  eSQF_MSG_TLE_TLM_MM = 602,
  eSQF_MSG_1X_Default = 1000,
  eSQF_MSG_Analog_Call_Processing = 1001,
  eSQF_MSG_Digital_Call_Processing = 1002,
  eSQF_MSG_CDMA_Decoder = 1003,
  eSQF_MSG_CDMA_Encoder = 1004,
  eSQF_MSG_GPS_Searcher = 1005,
  eSQF_MSG_Multiplex_Sublayer = 1006,
  eSQF_MSG_Searcher = 1007,
  eSQF_MSG_1xEvDO_Protocol = 2000,
  eSQF_MSG_1xEvDO_Data = 2001,
  eSQF_MSG_1xEvDO_Searcher = 2002,
  eSQF_MSG_1xEvDO_Drivers = 2003,
  eSQF_MSG_1xEvDO_IS_890 = 2004,
  eSQF_MSG_1xEVDO_Debug = 2005,
  eSQF_MSG_RTCMAC_Debug = 2006,
  eSQF_MSG_FTCMAC_Debug = 2007,
  eSQF_MSG_1xEVDO_HIT = 2008,
  eSQF_MSG_1xEVDO_PCP = 2009,
  eSQF_MSG_1xEVDO_HeapMem = 2010,
  eSQF_MSG_UMTS = 3000,
  eSQF_MSG_WCDMA_L1 = 3001,
  eSQF_MSG_WCDMA_L2 = 3002,
  eSQF_MSG_WCDMA_MAC = 3003,
  eSQF_MSG_WCDMA_RLC = 3004,
  eSQF_MSG_WCDMA_RRC = 3005,
  eSQF_MSG_NAS_CNM = 3006,
  eSQF_MSG_NAS_MM = 3007,
  eSQF_MSG_NAS_MN = 3008,
  eSQF_MSG_NAS_RABM = 3009,
  eSQF_MSG_NAS_REG = 3010,
  eSQF_MSG_NAS_SM = 3011,
  eSQF_MSG_NAS_TC = 3012,
  eSQF_MSG_NAS_CB = 3013,
  eSQF_MSG_WCDMA_LEVEL = 3014,
  eSQF_MSG_NAS = 3900,
  eSQF_MSG_GSM = 4000,
  eSQF_MSG_GSM_L1 = 4001,
  eSQF_MSG_GSM_L2 = 4002,
  eSQF_MSG_GSM_RR = 4003,
  eSQF_MSG_GSM_GPRS_GCOMMON = 4004,
  eSQF_MSG_GSM_GPRS_GLLC = 4005,
  eSQF_MSG_GSM_GPRS_GMAC = 4006,
  eSQF_MSG_GSM_GPRS_GPL1 = 4007,
  eSQF_MSG_GSM_GPRS_GRLC = 4008,
  eSQF_MSG_GSM_GPRS_GRR = 4009,
  eSQF_MSG_GSM_GPRS_GSNDCP = 4010,
  eSQF_MSG_WLAN = 4500,
  eSQF_MSG_WLAN_ADP = 4501,
  eSQF_MSG_WLAN_CP = 4502,
  eSQF_MSG_WLAN_FTM = 4503,
  eSQF_MSG_WLAN_OEM = 4504,
  eSQF_MSG_WLAN_SEC = 4505,
  eSQF_MSG_WLAN_TRP = 4506,
  eSQF_MSG_WLAN_Reserved_1 = 4507,
  eSQF_MSG_WLAN_Reserved_2 = 4508,
  eSQF_MSG_WLAN_Reserved_3 = 4509,
  eSQF_MSG_WLAN_Reserved_4 = 4510,
  eSQF_MSG_WLAN_Reserved_5 = 4511,
  eSQF_MSG_WLAN_Reserved_6 = 4512,
  eSQF_MSG_WLAN_Reserved_7 = 4513,
  eSQF_MSG_WLAN_Reserved_8 = 4514,
  eSQF_MSG_WLAN_Reserved_9 = 4515,
  eSQF_MSG_WLAN_Reserved_10 = 4516,
  eSQF_MSG_WLAN_TL = 4517,
  eSQF_MSG_WLAN_BAL = 4518,
  eSQF_MSG_WLAN_SAL = 4519,
  eSQF_MSG_WLAN_SSC = 4520,
  eSQF_MSG_WLAN_HDD = 4521,
  eSQF_MSG_WLAN_SME = 4522,
  eSQF_MSG_WLAN_PE = 4523,
  eSQF_MSG_WLAN_HAL = 4524,
  eSQF_MSG_WLAN_SYS = 4525,
  eSQF_MSG_WLAN_VOSS = 4526,
  eSQF_MSG_MCS = 4600,
  eSQF_MSG_MSGR = 4602,
  eSQF_MSG_APPMGR = 4603,
  eSQF_MSG_QTF = 4604,
  eSQF_MSG_FWS = 4605,
  eSQF_MSG_SRCH4 = 4606,
  eSQF_MSG_MCS_RESERVED_3 = 4607,
  eSQF_MSG_MCS_RESERVED_4 = 4608,
  eSQF_MSG_MCS_RESERVED_5 = 4609,
  eSQF_MSG_MCS_RESERVED_6 = 4610,
  eSQF_MSG_MCS_RESERVED_7 = 4611,
  eSQF_MSG_MCS_RESERVED_8 = 4612,
  eSQF_MSG_IRATMan = 4613,
  eSQF_MSG_Data_Services = 5000,
  eSQF_MSG_DS_Radio_Link_Protocol = 5001,
  eSQF_MSG_DS_PPP = 5002,
  eSQF_MSG_DS_TCPIP = 5003,
  eSQF_MSG_DS_IS_707 = 5004,
  eSQF_MSG_DS_3G_Manager = 5005,
  eSQF_MSG_DS_Protocol_Services = 5006,
  eSQF_MSG_DS_Mobile_IP = 5007,
  eSQF_MSG_DS_UMTS = 5008,
  eSQF_MSG_DS_GPRS = 5009,
  eSQF_MSG_DS_GSM = 5010,
  eSQF_MSG_DS_Sockets = 5011,
  eSQF_MSG_DS_AT_Command_Parser = 5012,
  eSQF_MSG_DS_Serial_IO = 5013,
  eSQF_MSG_DS_BroadCast_MultiCast_Services = 5014,
  eSQF_MSG_DS_Multi_Radio_Link_Protocol = 5015,
  eSQF_MSG_DS_Real_Time_Transport_Protocol = 5016,
  eSQF_MSG_DS_Session_Initiation_Protocol_Stack = 5017,
  eSQF_MSG_DS_ROHC = 5018,
  eSQF_MSG_DS_DO_QoS = 5019,
  eSQF_MSG_DS_IPC = 5020,
  eSQF_MSG_DS_SHIM = 5021,
  eSQF_MSG_DS_ACL_Policy = 5022,
  eSQF_MSG_DS_APPS = 5023,
  eSQF_MSG_DS_MUX = 5024,
  eSQF_MSG_DS_3GPP = 5025,
  eSQF_MSG_DS_LTE = 5026,
  eSQF_MSG_DS_WCDMA = 5027,
  eSQF_MSG_DS_ACL_Policy_Apps = 5028,
  eSQF_MSG_DS_HDR = 5029,
  eSQF_MSG_DS_IPA = 5030,
  eSQF_MSG_DS_EPC = 5031,
  eSQF_MSG_Security = 5500,
  eSQF_MSG_Security_Cryptography = 5501,
  eSQF_MSG_Security_Secure_Sockets_Layer = 5502,
  eSQF_MSG_Security_Internet_Protocol_Security = 5503,
  eSQF_MSG_Security_Secure_File_System = 5504,
  eSQF_MSG_Security_Security_Test_Subsystem = 5505,
  eSQF_MSG_Security_Content_Agent_Interface = 5506,
  eSQF_MSG_Security_Rights_Manager_Interface = 5507,
  eSQF_MSG_Security_Rights_Object_Aquisition_Protocol = 5508,
  eSQF_MSG_Security_Media_Manager_Interface = 5509,
  eSQF_MSG_Security_ID_Store_Interface = 5510,
  eSQF_MSG_Security_File_Interface = 5511,
  eSQF_MSG_Security_SQL_Interface = 5512,
  eSQF_MSG_Security_Common_Interface = 5513,
  eSQF_MSG_Security_Broadcast_Content_Agent_Interface = 5514,
  eSQF_MSG_Security_Play_Ready = 5515,
  eSQF_MSG_Applications_Default = 6000,
  eSQF_MSG_Application_Manager = 6001,
  eSQF_MSG_User_Interface = 6002,
  eSQF_MSG_QTV_Legacy_Applications = 6003,
  eSQF_MSG_QVP_Applications = 6004,
  eSQF_MSG_QVP_Statistics = 6005,
  eSQF_MSG_QVP_Vencoder = 6006,
  eSQF_MSG_QVP_Modem = 6007,
  eSQF_MSG_QVP_UI = 6008,
  eSQF_MSG_QVP_Stack = 6009,
  eSQF_MSG_QVP_VDecoder = 6010,
  eSQF_MSG_ACM = 6011,
  eSQF_MSG_Heap_Profile = 6012,
  eSQF_MSG_QTV_General = 6013,
  eSQF_MSG_QTV_QTV_Debug = 6014,
  eSQF_MSG_QTV_Statistics = 6015,
  eSQF_MSG_QTV_UI_Task = 6016,
  eSQF_MSG_QTV_MP4_Player = 6017,
  eSQF_MSG_QTV_Audio_Task = 6018,
  eSQF_MSG_QTV_Video_Task = 6019,
  eSQF_MSG_QTV_Streaming = 6020,
  eSQF_MSG_QTV_MPEG4_Task = 6021,
  eSQF_MSG_QTV_File_OPS = 6022,
  eSQF_MSG_QTV_RTP = 6023,
  eSQF_MSG_QTV_RTCP = 6024,
  eSQF_MSG_QTV_RTSP = 6025,
  eSQF_MSG_QTV_SDP_Parse = 6026,
  eSQF_MSG_QTV_Atom_Parse = 6027,
  eSQF_MSG_QTV_Text_Task = 6028,
  eSQF_MSG_QTV_DEC_DSP_IF = 6029,
  eSQF_MSG_QTV_Stream_Recording = 6030,
  eSQF_MSG_QTV_Configuration = 6031,
  eSQF_MSG_QCamera = 6032,
  eSQF_MSG_QCamcorder = 6033,
  eSQF_MSG_BREW = 6034,
  eSQF_MSG_QDJ = 6035,
  eSQF_MSG_QDTX = 6036,
  eSQF_MSG_Broadcast_FLO = 6037,
  eSQF_MSG_MDP_General = 6038,
  eSQF_MSG_Phonebook_Manager = 6039,
  eSQF_MSG_Graphics_General = 6040,
  eSQF_MSG_Graphics_EGL = 6041,
  eSQF_MSG_Graphics_Open_GL = 6042,
  eSQF_MSG_Graphics_Direct_3D = 6043,
  eSQF_MSG_Graphics_SVG = 6044,
  eSQF_MSG_Graphics_Open_VG = 6045,
  eSQF_MSG_Graphics_2D = 6046,
  eSQF_MSG_Graphics_QX_Profiler = 6047,
  eSQF_MSG_Graphics_DSP = 6048,
  eSQF_MSG_Graphics_GRP = 6049,
  eSQF_MSG_Graphics_MDP = 6050,
  eSQF_MSG_CAD = 6051,
  eSQF_MSG_IMS_DPL = 6052,
  eSQF_MSG_IMS_FW = 6053,
  eSQF_MSG_IMS_SIP = 6054,
  eSQF_MSG_IMS_REGMGR = 6055,
  eSQF_MSG_IMS_RTP = 6056,
  eSQF_MSG_IMS_SDP = 6057,
  eSQF_MSG_IMS_VS = 6058,
  eSQF_MSG_IMS_XDM = 6059,
  eSQF_MSG_IMS_HOM = 6060,
  eSQF_MSG_IMS_IM_ENABLER = 6061,
  eSQF_MSG_IMS_IMS_CORE = 6062,
  eSQF_MSG_IMS_FWAPI = 6063,
  eSQF_MSG_IMS_SERVICES = 6064,
  eSQF_MSG_IMS_POLICYMGR = 6065,
  eSQF_MSG_IMS_PRESENCE = 6066,
  eSQF_MSG_IMS_QIPCALL = 6067,
  eSQF_MSG_IMS_SIGCOMP = 6068,
  eSQF_MSG_IMS_PSVT = 6069,
  eSQF_MSG_IMS_UNKNOWN = 6070,
  eSQF_MSG_IMS_Settings = 6071,
  eSQF_MSG_OMX_Common = 6072,
  eSQF_MSG_CD = 6073,
  eSQF_MSG_IM = 6074,
  eSQF_MSG_FT = 6075,
  eSQF_MSG_IS = 6076,
  eSQF_MSG_AUTO_CONFIG = 6077,
  eSQF_MSG_COMMON = 6078,
  eSQF_MSG_IMS_XML = 6080,
  eSQF_MSG_Application_DSP_Tasks_Default = 6500,
  eSQF_MSG_Application_DSP_Tasks_Kernel = 6501,
  eSQF_MSG_Application_DSP_Tasks_AFE_Task = 6502,
  eSQF_MSG_Application_DSP_Tasks_Voice_Processing_Task = 6503,
  eSQF_MSG_Application_DSP_Tasks_Voice_Decoder_Task = 6504,
  eSQF_MSG_Application_DSP_Tasks_Voice_Encoder_Task = 6505,
  eSQF_MSG_Application_DSP_Tasks_Video_Task = 6506,
  eSQF_MSG_Application_DSP_Tasks_VFE_Task = 6507,
  eSQF_MSG_Application_DSP_Tasks_Video_Enc_Task = 6508,
  eSQF_MSG_Application_DSP_Tasks_JPEG_Task = 6509,
  eSQF_MSG_Application_DSP_Tasks_Audio_PP_Task = 6510,
  eSQF_MSG_Application_DSP_Tasks_Audio_Play_0_Task = 6511,
  eSQF_MSG_Application_DSP_Tasks_Audio_Play_1_Task = 6512,
  eSQF_MSG_Application_DSP_Tasks_Audio_Play_2_Task = 6513,
  eSQF_MSG_Application_DSP_Tasks_Audio_Play_3_Task = 6514,
  eSQF_MSG_Application_DSP_Tasks_Audio_Play_4_Task = 6515,
  eSQF_MSG_Application_DSP_Tasks_LPM_Task = 6516,
  eSQF_MSG_Application_DSP_Tasks_DIAG_Task = 6517,
  eSQF_MSG_Application_DSP_Tasks_Audio_Recorder_Task = 6518,
  eSQF_MSG_Application_DSP_Tasks_Audio_Preprocessor_Task = 6519,
  eSQF_MSG_Application_DSP_Tasks_Modmath_Task = 6520,
  eSQF_MSG_Application_DSP_Tasks_Graphics_Task = 6521,
  eSQF_MSG_L4_Linux_Kernel = 7000,
  eSQF_MSG_L4_Linux_Keypad = 7001,
  eSQF_MSG_L4_Linux_Applications = 7002,
  eSQF_MSG_L4_Linux_QDDAEMON = 7003,
  eSQF_MSG_L4_Iguana_Server = 7100,
  eSQF_MSG_L4_Iguana_EFS2 = 7101,
  eSQF_MSG_L4_Iguana_QDMS = 7102,
  eSQF_MSG_L4_Iguana_REX = 7103,
  eSQF_MSG_L4_Iguana_SMMS = 7104,
  eSQF_MSG_L4_Iguana_Frame_Buffer = 7105,
  eSQF_MSG_L4_Iguana_Keypad = 7106,
  eSQF_MSG_L4_Iguana_Naming = 7107,
  eSQF_MSG_L4_Iguana_SDIO = 7108,
  eSQF_MSG_L4_Iguana_Serial = 7109,
  eSQF_MSG_L4_Iguana_Timer = 7110,
  eSQF_MSG_L4_Iguana_Tramp = 7111,
  eSQF_MSG_L4_AMSS_QDiag = 7200,
  eSQF_MSG_L4_AMSS_APS = 7201,
  eSQF_MSG_HIT = 8000,
  eSQF_MSG_QDSP6 = 8500,
  eSQF_MSG_ADSP_Audio_Service = 8501,
  eSQF_MSG_ADSP_Audio_ENCDEC = 8502,
  eSQF_MSG_ADSP_Voice_ENCDEC = 8503,
  eSQF_MSG_ADSP_Voice_Services = 8504,
  eSQF_MSG_ADSP_MIDI = 8505,
  eSQF_MSG_ADSP_PostProcessing = 8506,
  eSQF_MSG_ADSP_PreProcessing = 8507,
  eSQF_MSG_ADSP_AFE = 8508,
  eSQF_MSG_ADSP_Media_Session = 8509,
  eSQF_MSG_ADSP_Device_Session = 8510,
  eSQF_MSG_ADSP_Device_Config = 8511,
  eSQF_MSG_ADSP_Video_Encoder = 8512,
  eSQF_MSG_ADSP_Video_Encoder_DAL_Driver = 8513,
  eSQF_MSG_ADSP_Video_Decoder = 8514,
  eSQF_MSG_ADSP_Video_Decoder_DAL_Driver = 8515,
  eSQF_MSG_ADSP_Video_Common_Software_Units = 8516,
  eSQF_MSG_ADSP_Video_Hardware = 8517,
  eSQF_MSG_ADSP_JPEG_Encoder = 8518,
  eSQF_MSG_ADSP_JPEG_Decoder = 8519,
  eSQF_MSG_ADSP_OpenMM = 8520,
  eSQF_MSG_ADSP_Power_or_DEM = 8521,
  eSQF_MSG_ADSP_Resource_Manager = 8522,
  eSQF_MSG_ADSP_General_Core = 8523,
  eSQF_MSG_UMB = 9000,
  eSQF_MSG_UMB_Application = 9001,
  eSQF_MSG_UMB_Data_Services = 9002,
  eSQF_MSG_UMB_Call_Processing = 9003,
  eSQF_MSG_UMB_Radio_Link_Layer = 9004,
  eSQF_MSG_UMB_MAC = 9005,
  eSQF_MSG_UMB_SRCH = 9006,
  eSQF_MSG_UMB_Firmware = 9007,
  eSQF_MSG_UMB_PLT = 9008,
  eSQF_MSG_LTE = 9500,
  eSQF_MSG_LTE_RRC = 9501,
  eSQF_MSG_LTE_MACUL = 9502,
  eSQF_MSG_LTE_MACDL = 9503,
  eSQF_MSG_LTE_MACCTRL = 9504,
  eSQF_MSG_LTE_RLCUL = 9505,
  eSQF_MSG_LTE_RLCDL = 9506,
  eSQF_MSG_LTE_PDCPUL = 9507,
  eSQF_MSG_LTE_PDCPDL = 9508,
  eSQF_MSG_LTE_ML1 = 9509,
  eSQF_MSG_DISCOVERY = 9510,
  eSQF_MSG_QCHAT = 10200,
  eSQF_MSG_QCHAT_CAPP = 10201,
  eSQF_MSG_QCHAT_CENG = 10202,
  eSQF_MSG_QCHAT_CREG = 10203,
  eSQF_MSG_QCHAT_CMED = 10204,
  eSQF_MSG_QCHAT_CAUTH = 10205,
  eSQF_MSG_QCHAT_QBAL = 10206,
  eSQF_MSG_QCHAT_OSAL = 10207,
  eSQF_MSG_QCHAT_OEMCUST = 10208,
  eSQF_MSG_QCHAT_MULTI_PROC = 10209,
  eSQF_MSG_QCHAT_UPK = 10210,
  eSQF_MSG_TDSCDMA = 10250,
  eSQF_MSG_TDSCDMA_L1 = 10251,
  eSQF_MSG_TDSCDMA_L2 = 10252,
  eSQF_MSG_TDSCDMA_MAC = 10253,
  eSQF_MSG_TDSCDMA_RLC = 10254,
  eSQF_MSG_TDSCDMA_RRC = 10255,
  eSQF_MSG_CTA = 10300,
  eSQF_MSG_QCNEA = 10350,
  eSQF_MSG_QCNEA_CAC = 10351,
  eSQF_MSG_QCNEA_CORE = 10352,
  eSQF_MSG_QCNEA_CORE_CAS = 10353,
  eSQF_MSG_QCNEA_CORE_CDE = 10354,
  eSQF_MSG_QCNEA_CORE_COM = 10355,
  eSQF_MSG_QCNEA_CORE_LEE = 10356,
  eSQF_MSG_QCNEA_CORE_QMI = 10357,
  eSQF_MSG_QCNEA_CORE_SRM = 10358,
  eSQF_MSG_QCNEA_GENERIC = 10359,
  eSQF_MSG_QCNEA_NETLINK = 10360,
  eSQF_MSG_QCNEA_NIMS = 10361,
  eSQF_MSG_QCNEA_NSRM = 10362,
  eSQF_MSG_QCNEA_NSRM_CORE = 10363,
  eSQF_MSG_QCNEA_NSRM_GATESM = 10364,
  eSQF_MSG_QCNEA_NSRM_TRG = 10365,
  eSQF_MSG_QCNEA_PLCY = 10366,
  eSQF_MSG_QCNEA_PLCY_ANDSF = 10367,
  eSQF_MSG_QCNEA_TEST = 10368,
  eSQF_MSG_QCNEA_WQE = 10369,
  eSQF_MSG_QCNEA_WQE_BQE = 10370,
  eSQF_MSG_QCNEA_WQE_CQE = 10371,
  eSQF_MSG_QCNEA_WQE_ICD = 10372,
  eSQF_MSG_QCNEA_WQE_IFSEL = 10373,
  eSQF_MSG_QCNEA_WQE_IFSELRSM = 10374,
  eSQF_MSG_QCNEA_ATP = 10375,
  eSQF_MSG_QCNEA_ATP_PLCY = 10376,
  eSQF_MSG_QCNEA_ATP_RPRT = 10377,
  eSQF_MSG_1xEVDO = 90000,
  eSQF_MSG_Known_Messages_By_Subsystem = 100000,
  eSQF_MSG_Known_Messages_By_Level = 100001,
  eSQF_MSG_Low = 200000,
  eSQF_MSG_Medium = 200001,
  eSQF_MSG_High = 200002,
  eSQF_MSG_Error = 200003,
  eSQF_MSG_Fatal = 200004,
  eSQF_MSG_Custom = 200005,
  eSQF_MSG_QTV_Low = 206000,
  eSQF_MSG_QTV_Medium = 206001,
  eSQF_MSG_QTV_High = 206002,
  eSQF_MSG_QTV_Error = 206003,
  eSQF_MSG_QTV_Fatal = 206004,
  eSQF_MSG_QTV_Levels_QTV_Debug = 206005,
  eSQF_MSG_ADSP_Audio = 206006,
  eSQF_MSG_ADSP_Video = 206007,
  eSQF_MSG_ADSP_JPEG = 206008,
  eSQF_MSG_ADSP_General = 206009,
  eSQF_MSG_L4 = 206011,
  eSQF_MSG_GNSS = 206012,
  eSQF_MSG_GNSS_Legacy = 206013,
  eSQF_MSG_CXM = 206014,
  eSQF_MSG_IMS_RCS = 206015,
  eSQF_MSG_VSTMR = 206016,
  eSQF_MSG_Storage = 206017,
  eSQF_MSG_Flash_Scrub = 206018,
  eSQF_MSG_ADSP_RDA = 206020,
  eSQF_MSG_STRIDE = 206021,
  eSQF_MSG_Policy_Manager = 206022,
  eSQF_MSG_Task_Management_Services = 206023,
  eSQF_MSG_LWIP = 206025,
  eSQF_MSG_RFS = 206026,
  eSQF_MSG_CFCM = 206027,
  eSQF_MSG_RFS_Access = 206028,
  eSQF_MSG_RLC = 206029,
  eSQF_MSG_MEMHEAP = 206030,
  eSQF_MSG_DPM = 206031,
  eSQF_MSG_DPM_Common = 206032,
  eSQF_MSG_DPM_COM = 206033,
  eSQF_MSG_DPM_QMI = 206034,
  eSQF_MSG_DPM_DSM = 206035,
  eSQF_MSG_DPM_CONFIG = 206036,
  eSQF_MSG_DPM_Generic = 206037,
  eSQF_MSG_DPM_Netlink = 206038,
  eSQF_MSG_DPM_FD_MGR = 206039,
  eSQF_MSG_DPM_CT_MGR = 206040,
  eSQF_MSG_DPM_NSRM = 206041,
  eSQF_MSG_DPM_NSRM_Core = 206042,
  eSQF_MSG_DPM_NSRM_GATESM = 206043,
  eSQF_MSG_DPM_NSRM_TRG = 206044,
  eSQF_MSG_DPM_Test = 206045,
  eSQF_MSG_WCI2 = 206046,
  eSQF_MSG_LOWI = 206047,
}eSQF_MSG;

typedef enum _log_service_enum_{
LOG_MASK,
EVENT_MASK,
MSG_MASK,
}log_service_enum;

int sqf_createbuffer();
void sqf_destroybuffer();
void sqf_set(log_service_enum iLogService ,uint32_t iNo);
void sqf_clear(log_service_enum iLogService ,uint32_t iNo);
void sqf_save_file(char *szFilePath);
int sqf_load_file(char *szFilePath);

#endif

