#include "lua.h"
#include "lualib.h"
#include "lauxlib.h"

#include "SWIWWANCMAPI.h"
#include "devtree_v2.h"
#include "qmerrno.h"


#include <string.h>
#include <stdint.h>

#define nMaxStrLen        0xFF

enum{
    DISCONNECTED = 1,
    CONNECTED,
    SUSPENDED,
    AUTHENTICATING
};

enum{
    STOP,
    START
};

enum{
    V4      = 4,
    V6      = 6,
    V4V6    = 7
};

static int is_connected(lua_State *L)
{
    ULONG   state = -1;
    ULONG   nRet;
    BYTE    instance = 0; //FIXME hardcoded

    nRet = GetSessionState( &state, instance);
    if (!nRet)
        printf("GetSessionState returned %d\n", nRet);

    printf("[c-netman]state %d\n", state);
    lua_pushnumber(L, (state == CONNECTED) );

    nRet = iInitPdsLocationData();
    if( nRet != eQCWWAN_ERR_NONE)
    {
        printf("\033[0;32;31mInit Pds Location Data Fail!\n\033[0m");
    }
    return 1;
}

static int data_call(struct ssdatasession_params *pSession)
{
    ULONG nRet;

    printf("[c-netman]connecting with default profile\n");
    nRet = SLQSStartStopDataSession(pSession);
    printf("[c-netman]SLQSStartStopDataSession returned %d\n", nRet);

    return nRet;
}

static int start_data_call(lua_State *L)
{
    ULONG nRet;
    int connected = 0;
    struct ssdatasession_params session;
    char *pUsername = NULL;
    char *pPwd = NULL;
    int  isCdma = lua_toboolean(L,1);
    int  auth = 0;

    memset(&session, 0, sizeof(session));
    if (isCdma)
    {
        auth = lua_tointeger(L,2);
        if (auth) {
            pUsername = (char*)lua_tostring(L,3);
            pPwd = (char*)lua_tostring(L,4);
        }
        session.pAuthentication = (ULONG*)&auth;
        session.pUsername = pUsername;
        session.pPassword = pPwd;
    }

    session.action = START;
    session.ipfamily = V4;

    nRet = data_call(&session);

    printf("[c-netman] data call returned %d\n", nRet);
    if (nRet)
    {
        connected = 0;
    }
    else
        connected = 1;

    if(connected)
        SetServiceAutomaticTracking(eSetServiceAutomaticTrackingEnable);
    
    lua_pushnumber(L, connected);

    
    
    return 1;
}

int
get_default_apn(
      int      is3gpp,
      char*    apn,
      uint8_t  sz
      )
{
    ULONG nRet;
    ULONG PDPType;
    ULONG IPAddress;
    ULONG PrimaryDNS;
    ULONG SecondaryDNS;
    ULONG Authentication;
    BYTE  nameSize = nMaxStrLen-1;
    CHAR  Name[nMaxStrLen]={0};
    BYTE  userSize = nMaxStrLen-1;
    CHAR  Username[nMaxStrLen]={0};

    memset(Name, 0, sizeof(Name));
    memset(Username, 0, sizeof(Username));
    nRet = GetDefaultProfile(is3gpp? 1:0,
          &PDPType,
          &IPAddress,
          &PrimaryDNS,
          &SecondaryDNS,
          &Authentication,
          nameSize,
          &Name[0],
          sz,
          apn,
          userSize,
          &Username[0]);

    return nRet;
}


static int get_apn(lua_State *L)
{
    ULONG nRet;
    char cur_apn[nMaxStrLen]={0};
    int tech = lua_toboolean(L,1);

    memset(cur_apn, 0, sizeof(cur_apn));
    nRet = get_default_apn(tech, cur_apn, sizeof(cur_apn));

    printf("[c-netman] get default apn returned %d\n", nRet);

    lua_pushstring(L, cur_apn);
    return 1;
}

int
set_default_apn(
      const char*    apn,
      int profileType
      )
{
   ULONG nRet;

   nRet = SetDefaultProfile(profileType,
         NULL,
         NULL,
         NULL,
         NULL,
         NULL,
         NULL,
         (char*)apn,
         NULL,
         NULL);

   return nRet;
}

static int set_apn(lua_State *L)
{
    ULONG nRet;
    const char *apn = lua_tostring(L,1);
    int isCDMA = lua_toboolean(L,2);

    nRet = set_default_apn(apn, isCDMA);

    printf("[c-netman] set default apn returned %d\n", nRet);

    return 1;
}


static const struct luaL_reg data_call_lib[] = {
    {"connect",         start_data_call},
    {"is_connected",    is_connected},
    {"get_apn",         get_apn},
    {"set_apn",         set_apn},
    {NULL, NULL}
};

int luaopen_data_call (lua_State *L) {
    luaL_register(L, "data_call", data_call_lib);
    return 1;
}
