/*
 * \ingroup wds
 *
 * \file    qaWdsSWIGetCurrentChannelRate.c
 *
 * \brief   Contains Packing and UnPacking routines for the 
 *           eQMI_WDS_SWI_GET_CURRENT_CHANNEL_RATE message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiWds.h"
#include "qaWdsSWIGetCurrentChannelRate.h"

/* Response handling */

/*
 * This function unpacks the QMI WDS Current Channel Rate from the
 * QMI response message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                           to return data for this TLV.
 *
 * \return  eQCWWAN_ERR_NONE, on success
 */

enum eQCWWANError UnpackTlvPacketQmiWdsSWIGetCurrentChannelRate(
BYTE *pTlvData, BYTE *pResp)
{
    struct QmiWdsSWIGetCurrentChannelRateResp *lResp =
                       (struct QmiWdsSWIGetCurrentChannelRateResp *)pResp;
    swi_uint32 u32Temp= UINT32_MAX;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode = GetLong(pTlvData,&u32Temp);
    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;
    lResp->CurrentCahnnelRate.current_channel_tx_rate = u32Temp;
    u32Temp= UINT32_MAX;
    eRCode = GetLong(pTlvData,&u32Temp);
    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;
    lResp->CurrentCahnnelRate.current_channel_rx_rate = u32Temp;
    u32Temp= UINT32_MAX;
    eRCode = GetLong(pTlvData,&u32Temp);
    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;
    lResp->CurrentCahnnelRate.max_channel_tx_rate = u32Temp;
    u32Temp= UINT32_MAX;
    eRCode = GetLong(pTlvData,&u32Temp);
    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;
    lResp->CurrentCahnnelRate.max_channel_rx_rate = u32Temp;
    return eRCode;
}

/* Request handling */

/*
 * This function packs the QMI WDS Current Channel Rate parameters
 * to the QMI message SDU
 *
 * \param  pParamField - Pointer to storage into which the packed
 *                       data will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success
 *
 * \sa     qaGobiApiWds.h for remaining parameter descriptions.
 *
 */

enum eQCWWANError PkQmiWdsSWIGetCurrentChannelRateReq(
    WORD                 *pMlength,
    BYTE                 *pParamField )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID,                 NULL } /* Important. Sentinel.
                                                     * Signifies last item in map
                                                     */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode = qmbuild( pParamField,
                      (BYTE *)NULL,
                      map,
                      eQMI_WDS_SWI_GET_CURRENT_CHANNEL_RATE,
                      pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the  QMI WDS SWI Get Current Channel Rate response message to a user-
 * provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiWdsSWIGetCurrentChannelRateReq(
    BYTE                                *pMdmResp,
    struct QmiWdsSWIGetCurrentChannelRateResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
     /* The unpack of the Callback contains only result code */
    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_SWI_GET_CURRENT_CHANNEL_RATE_CHANNEL_RATE,
            &UnpackTlvPacketQmiWdsSWIGetCurrentChannelRate},
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_SWI_GET_CURRENT_CHANNEL_RATE );
    return eRCode;
}



