/*
 * \ingroup wds
 *
 * \file    qaWdsSLQSResetPacketStatics.c
 *
 * \brief   Contains Packing and UnPacking routines for the eQMI_WDS_RESET_PKT_STATISTICS
 *          message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiWds.h"
#include "qaWdsSLQSResetPacketStatics.h"

/*
 * This function packs the SLQS Reset Packet Statics parameters to the QMI
 * message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed
 *                              data will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 * \sa qaWdsSLQSResetPacketStatics.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiWdsSLQSResetPacketStatics(
    WORD                 *pMlength,
    BYTE                 *pParamField )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID,                 NULL } /* Important. Sentinel.
                                                     * Signifies last item in map
                                                     */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode = qmbuild( pParamField,
                      NULL,
                      map,
                      eQMI_WDS_RESET_PKT_STATISTICS,
                      pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the  QMI WDS Reset Packet Statics response message to a user-
 * provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiWdsSLQSResetPacketStatics(
    BYTE                                *pMdmResp,
    struct QmiWdsSLQSResetPacketStaticsResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
     /* The unpack of the Callback contains only result code */
    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_RESET_PKT_STATISTICS );
    return eRCode;
}



