/*
 * \ingroup wds
 *
 * \file qaWdsIntSLQSSetSessionID.c
 *
 * \brief  Contains Packing and UnPacking routines for the
 *         QMI_WDS_INT_SET_SESSIONID message.
 *
 * Copyright: © 2014 Sierra Wireless, Inc., all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiWds.h"
#include "qaWdsIntSLQSSetSessionID.h"

/*****************************************************************************
 * Request handling
 ******************************************************************************/
/*
 * This function packs the iSLQSSetSessionID instance ID field to
 * the QMI message SDU
 *
 * \param   pBuf    [OUT] - Pointer to storage into which the packed
 *                          data will be placed by this function.
 *
 * \param   pParam  [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return  eQCWWAN_ERR_NONE, on success
 */
enum eQCWWANError BuildTlvInstanceID(BYTE *pBuf, BYTE *pParam)
{
    struct QmiWdsSLQSSetSessionIDReq *pReq =
                (struct QmiWdsSLQSSetSessionIDReq *)pParam;

    /* Add TLV data */
    return PutByte( pBuf, pReq->InstanceID );
}

/*
 * This function packs the iSLQSSetSessionID session ID field to
 * the QMI message SDU
 *
 * \param   pBuf    [OUT] - Pointer to storage into which the packed
 *                          data will be placed by this function.
 *
 * \param   pParam  [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return  eQCWWAN_ERR_NONE, on success
 */
enum eQCWWANError BuildTlvSessnID(BYTE *pBuf, BYTE *pParam)
{
    struct QmiWdsSLQSSetSessionIDReq *pReq =
                (struct QmiWdsSLQSSetSessionIDReq *)pParam;

    /* Add TLV data */
    return PutLong( pBuf, pReq->sessionID );
}

/*
 * This function packs the iSLQSSetSessionID parameters
 * to the QMI message SDU
 *
 * \param  pParamField [OUT] - Pointer to storage into which the packed
 *                             data will be placed by this function.
 *
 * \param  pMlength    [OUT] - Total length of built message.
 *
 * \param  sessionID   [OUT] - session ID to pack.
 *
 * \return eQCWWAN_ERR_NONE, on success
 *
 * \sa     qaGobiApiWds.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiWdsIntSetSessnID(
    WORD  *pMlength,
    BYTE  *pParamField,
    BYTE  InstanceID,
    ULONG sessionID )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_WDS_INTERNAL_SET_INSTANCEID, &BuildTlvInstanceID },
        { eTLV_WDS_INTERNAL_SET_SESSIONID,  &BuildTlvSessnID },
        { eTLV_TYPE_INVALID,                NULL }  /* Important. Sentinel.
                                                     * Signifies last item
                                                     * in map. */
    };

    struct QmiWdsSLQSSetSessionIDReq req;
    enum   eQCWWANError           eRCode;

    slmemset((char *)&req, 0, sizeof (struct QmiWdsSLQSSetSessionIDReq));
    req.InstanceID = InstanceID;
    req.sessionID = sessionID;

    eRCode = qmbuild( pParamField,
                      (BYTE *)&req,
                      map,
                      eQMI_WDS_INT_SET_SESSIONID,
                      pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 ******************************************************************************/

/*
 * This function unpacks the iSLQSSetSessionID response message to a
 * user-provided response structure.
 *
 * \param     pMdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param     pApiResp   [OUT] - Pointer to storage to unpack into.
 *
 * \return    eQCWWAN_ERR_NONE, on success
 */
enum eQCWWANError UpkQmiWdsIntSetSessnID(
    BYTE                              *pMdmResp,
    struct QmiWdsSLQSSetSessionIDResp *pApiResp)
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };
    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_INT_SET_SESSIONID );
    return eRCode;
}
