/*
 * \ingroup wds
 *
 * \file qaWdsGetDataBearerTechnology.c
 *
 * \brief Contains Packing and UnPacking routines for the
 *        QMI_WDS_GET_DATA_BEARER message.
 *
 * Copyright:  2011 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaWdsGetDataBearerTechnologyExt.h"

/*****************************************************************************
 * Request handling
 ******************************************************************************/
/*
 * This function packs the GetDataBearerTechnology parameters
 * to the QMI message SDU
 *
 * \param  pParamField [OUT] - Pointer to storage into which the packed
 *                             data will be placed by this function.
 *
 * \param  pMlength    [OUT] - Total length of built message.
 *
 * \return eQCWWAN_ERR_NONE, on success
 * \return eQCWWAN_ERR_NO_MEMORY, on error
 *
 */
enum eQCWWANError PkQmiWdsGetDataBearerTechnologyExt(
    WORD    *pMlength,
    BYTE    *pParamField)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID, NULL }  /* Important. Sentinel.
                                      * Signifies last item in map.
                                      */
    };

    enum eQCWWANError eRCode;

    eRCode = qmbuild (pParamField,
                      NULL,
                      map,
                      eQMI_WDS_GET_DATA_BEARER_TECHNOLOGY_EXT,
                      pMlength);

    return eRCode;
}

enum eQCWWANError UnpackTlvDataBearerTech(BYTE *pTlvData, BYTE *pResp)
{
    struct QmiWdsGetDataBearerTechExtResp *lResp =
                (struct QmiWdsGetDataBearerTechExtResp *)pResp;
    DataBearerTechExt *pDataBearerTech = lResp->pDataBearerTechExt;
    DataBearerTech *lTemp = pDataBearerTech->pBearerTech;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    if ( NULL == lTemp ) 
       return eQCWWAN_ERR_INVALID_ARG;


    eRCode = GetLong(pTlvData, &lTemp->techType);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;
        
    eRCode = GetLong(pTlvData, &lTemp->ratValue);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = GetLongLong(pTlvData, &lTemp->soMask);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    return eRCode;
}

enum eQCWWANError UnpackTlvLastCallDataBearerTech(BYTE *pTlvData, BYTE *pResp)
{
    struct QmiWdsGetDataBearerTechExtResp *lResp =
                (struct QmiWdsGetDataBearerTechExtResp *)pResp;
    DataBearerTechExt *pDataBearerTech = lResp->pDataBearerTechExt;
    DataBearerTech *lTemp = pDataBearerTech->pLastBearerTech;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    if ( NULL == lTemp ) 
       return eQCWWAN_ERR_INVALID_ARG;


    eRCode = GetLong(pTlvData, &lTemp->techType);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;
        
    eRCode = GetLong(pTlvData, &lTemp->ratValue);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = GetLongLong(pTlvData, &lTemp->soMask);
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    return eRCode;
}


/*
 * This function unpacks the GetDataBearerTechnology response message to a
 * user-provided response structure.
 *
 * \param  pMdmResp - Pointer to packed response from the modem.
 *
 * \param  pApiResp - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success
 *
 */
enum eQCWWANError UpkQmiWdsGetDataBearerTechnologyExt(
    BYTE   *pMdmResp,
    struct QmiWdsGetDataBearerTechExtResp *pApiResp)
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_DATA_BEARER_TECH,   &UnpackTlvDataBearerTech },
        { eTLV_LAST_CALL_DATA_BEARER_TECH,   &UnpackTlvLastCallDataBearerTech },
        { eTLV_TYPE_INVALID, NULL }  /* Important. Sentinel.
                                      * Signifies last item in map.
                                      */
    };

    eRCode = qmunpackresp( pMdmResp,
                          (BYTE *)pApiResp,
                          map,
                          eQMI_WDS_GET_DATA_BEARER_TECHNOLOGY_EXT );
    return eRCode;
}
