/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiWds.h"
#include "qaWdsDefaultProfileNum.h"

typedef struct
{
    BYTE type;
    BYTE family;
} profile_t;

typedef struct
{
    BYTE type;
    BYTE family;
    BYTE index;
} set_profile_t;

enum eQCWWANError UnpackProfileNo(
        BYTE *pTlvData, BYTE *pResp)
{
    struct sQmiWdsGetDefaultProfileNumResp *lResp =
                       (struct sQmiWdsGetDefaultProfileNumResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    if(pResp==NULL)
        return eQCWWAN_ERR_INVALID_ARG;
    
    eRCode = GetByte(pTlvData, &lResp->profile_no);
    return eRCode;
}

enum eQCWWANError BuildProfileType( BYTE *pBuf, BYTE *pParam )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    profile_t *p = (profile_t *)pParam;

    eRCode = PutByte( pBuf, p->type );

    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;

    eRCode = PutByte( pBuf, p->family );
    return eRCode;
}

enum eQCWWANError PkQmiWdsGetDefaultProfileNum(
    WORD    *pMlength,
    BYTE    *pParamField,
    BYTE    type,
    BYTE    family
    )
{
    static struct qmTlvBuilderItem map[] =
    {
        { 1,       &BuildProfileType },
        { eTLV_TYPE_INVALID,     NULL } /* Important. Sentinel.
                                         * Signifies last item in map
                                         */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    profile_t p = {type, family};

    eRCode = qmbuild( pParamField,
                      (BYTE *)&p,
                      map,
                      eQMI_WDS_GET_DEFAULT_PROFILE_NUM,
                      pMlength );
    return eRCode;
}

enum eQCWWANError UpkQmiWdsGetDefaultProfileNum(
    BYTE                                *pMdmResp,
    struct sQmiWdsGetDefaultProfileNumResp *pApiResp)
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
     /* The unpack of the Callback contains only result code */
    static struct qmTlvUnpackerItem map[] =
    {
        { 1, UnpackProfileNo},
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_GET_DEFAULT_PROFILE_NUM );
    return eRCode;
}

enum eQCWWANError BuildProfile( BYTE *pBuf, BYTE *pParam )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    set_profile_t *p = (set_profile_t *)pParam;

    eRCode = PutByte( pBuf, p->type );

    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;

    eRCode = PutByte( pBuf, p->family );

    if(eRCode != eQCWWAN_ERR_NONE)
        return eRCode;

    eRCode = PutByte( pBuf, p->index );
    return eRCode;
}

enum eQCWWANError PkQmiWdsSetDefaultProfileNum(
    WORD    *pMlength,
    BYTE    *pParamField,
    BYTE    type,
    BYTE    family,
    BYTE    index
    )
{
    static struct qmTlvBuilderItem map[] =
    {
        { 1,       &BuildProfile },
        { eTLV_TYPE_INVALID,     NULL } /* Important. Sentinel.
                                         * Signifies last item in map
                                         */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    set_profile_t p = {type, family, index};

    eRCode = qmbuild( pParamField,
                      (BYTE *)&p,
                      map,
                      eQMI_WDS_SET_DEFAULT_PROFILE_NUM,
                      pMlength );
    return eRCode;
}

enum eQCWWANError UpkQmiWdsSetDefaultProfileNum(
    BYTE                                *pMdmResp,
    struct sQmiWdsSetDefaultProfileNumResp *pApiResp)
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
     /* The unpack of the Callback contains only result code */
    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_SET_DEFAULT_PROFILE_NUM );
    return eRCode;
}
