/*
 *\ingroup wds
 *
 * \file qaWdsSWISetDataLoopback.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsSWISetDataLoopback.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef _WDS_SWI_SET_DATA_LOOPBACK_H_
#define _WDS_SWI_SET_DATA_LOOPBACK_H_

/* enum declarations */
/*
 *
 * An enumeration of eTLV_SWI_SET_DATA_LOOPBACK_CHANNEL_RATE response TLV IDs
 *
 */

enum eWDS_SWI_SET_DATA_LOOPBACK_REQ
{
    eTLV_SWI_SET_DATA_LOOPBACK_MODE = 0x010,
    eTLV_SWI_SET_DATA_LOOPBACK_MULTIPLIER = 0x11
};

/**
 * WDS SWI Set Data Loopback Req
 *
 *  \param  u8LoopbackMode
 *          - Loopback Mode.
 *
 *  \param  u8LoopbackMultiplier
 *          - Loopback multiplier. Number of downlink bytes to send for each uplink byte.
 */

struct sQmiWdsSWISetDataLoopbackReq
{
    swi_uint8 u8LoopbackMode;
    swi_uint8 u8LoopbackMultiplier;
};

/*
 * This structure contains the SLQSWdsSetEventReport response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */

struct sQmiWdsSWISetDataLoopboackResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};


/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiWdsSWISetDataLoopbackReq(
WORD                 *pMlength,
BYTE                 *pParamField,
WDSSetLoopbackData *pQmiWdsSWISetDataLoopboackReq);

extern enum eQCWWANError UpkQmiWdsSWISetDataLoopbackReq(
    BYTE                                *pMdmResp,
    struct sQmiWdsSWISetDataLoopboackResp *pAipResp);

    
#endif /* _WDS_SWI_SET_DATA_LOOPBACK_H_ */
