/*
 *\ingroup wds
 *
 * \file qaWdsSWIGetDataLoopback.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsSWIGetDataLoopback.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef _WDS_SWI_GET_DATA_LOOPBACK_H_
#define _WDS_SWI_GET_DATA_LOOPBACK_H_

#include "qaGobiApiWds.h"

/* enum declarations */
/*
 *
 * An enumeration of eTLV_SWI_GET_DATA_LOOPBACK response TLV IDs
 *
 */

enum eWDS_SWI_GET_DATA_LOOPBACK_RESP
{
    eTLV_SWI_GET_DATA_LOOPBACK_MODE         = 0x10,
    eTLV_SWI_GET_DATA_LOOPBACK_MULTIPLIER   = 0x11
};


/*
 * This structure contains the WdsSWIGetCurrentChannelRate response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */

struct QmiWdsSWIGetDataLoopBackResp
{
    struct qmTlvResult results;
    /* Every response message must have a results structure */
    WDSGetLoopbackData *sGetDataLoopbackData;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiWdsSWIGetDataLoopbackReq(
WORD                 *pMlength,
BYTE                 *pParamField);

extern enum eQCWWANError UpkQmiWdsSWIGetDataLoopbackReq(
    BYTE                                *pMdmResp,
    struct QmiWdsSWIGetDataLoopBackResp *pAipResp);

    
#endif /* _WDS_SWI_GET_DATA_LOOPBACK_H_ */
