/*
 *\ingroup wds
 *
 * \file qaWdsSWIGetCurrentChannelRate.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsSWIGetCurrentChannelRate.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __WDS_SWI_GET_CURRENT_CHANNEL_RATE_H__
#define __WDS_SWI_GET_CURRENT_CHANNEL_RATE_H__
#include <stdint.h>
/* enum declarations */
/*
 *
 * An enumeration of eTLV_SWI_GET_CURRENT_CHANNEL_RATE_CHANNEL_RATE response TLV IDs
 *
 */

enum eWDS_SWI_GET_CURRENT_CHANNEL_RATE_RESP
{
    eTLV_SWI_GET_CURRENT_CHANNEL_RATE_CHANNEL_RATE = 0x01,
};

/**
 * WDS SWI Current Channel Rates
 *
 *  \param  current_channel_tx_rate
 *          - Current Channel Tx Rate.
 *
 *  \param  current_channel_rx_rate
 *          - Current Channel Rx Rate.
 *
 *  \param  max_channel_tx_rate
 *          - Max Channel Tx Rate.
 *
 *  \param  max_channel_rx_rate
 *          - Max Channel Rx Rate.
 */

struct sQmiWdsSWIGetCurrentChannelRate
{
    uint32_t current_channel_tx_rate;
    uint32_t current_channel_rx_rate;
    uint32_t max_channel_tx_rate;
    uint32_t max_channel_rx_rate;
};

/*
 * This structure contains the WdsSWIGetCurrentChannelRate response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */

struct QmiWdsSWIGetCurrentChannelRateResp
{
    struct qmTlvResult results;
    /* Every response message must have a results structure */
    struct sQmiWdsSWIGetCurrentChannelRate CurrentCahnnelRate;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiWdsSWIGetCurrentChannelRateReq(
WORD                 *pMlength,
BYTE                 *pParamField);

extern enum eQCWWANError UpkQmiWdsSWIGetCurrentChannelRateReq(
    BYTE                                *pMdmResp,
    struct QmiWdsSWIGetCurrentChannelRateResp *pAipResp);

    
#endif /* __WDS_SWI_GET_CURRENT_CHANNEL_RATE_H__ */
