/*
 * \ingroup wds
 *
 * \file qaWdsSLQSGetDUNCallInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsSLQSGetDUNCallInfo.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __WDS_SLQS_GET_DUN_CALL_INFO_MSG_H__
#define __WDS_SLQS_GET_DUN_CALL_INFO_MSG_H__

#include "qaGobiApiWds.h"

/* enum declarations */

/*
 * An enumeration of eQMI_WDS_GET_DUN_CALL_INFO request TLV IDs
 */
enum eWDS_GET_DUN_CALL_INFO_REQ
{
    eTLV_REQUEST_INFO      = 0x01,
    eTLV_CONNECT_STAT_IND  = 0x10,
    eTLV_TRANSFER_STAT_IND = 0x11,
    eTLV_DORM_STAT_IND     = 0x12,
    eTLV_DATA_BEAR_TECH  = 0x13,
    eTLV_CHANNEL_RATE_IND  = 0x14,
};

/*
 * An enumeration of eQMI_WDS_GET_DUN_CALL_INFO response TLV IDs
 */
enum eWDS_GET_DUN_CALL_INFO_RESP
{
    eTLV_CONNECTIONSTATUS     = 0x10,
    eTLV_LASTMDMCALLENDREASON = 0x11,
    eTLV_TXBYTESOKCNT         = 0x12,
    eTLV_RXBYTESOKCNT         = 0x13,
    eTLV_DORMSTATUS           = 0x14,
    eTLV_DATABEARERTECH       = 0x15,
    eTLV_CHANNRATE            = 0x16,
    eTLV_LASTCALLTXBYTESOK    = 0x17,
    eTLV_LASTCALLRXBYTESOK    = 0x18,
    eTLV_CALLACTIVEDURATION   = 0x19,
    eTLV_LASTCALLDATABEARTECH = 0x20,
};

/*
 * This structure contains the SLQSGetDUNCallInfo response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSlqsGetDUNCallInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Get DUN Call Info response structure */
    getDUNCallInfoResp *pGetDUNCallInfoResp;
};

/* Prototypes */
extern enum eQCWWANError PkQmiWdsSlqsGetDUNCallInfo(
    WORD              *pMlength,
    BYTE              *pBuffer,
    getDUNCallInfoReq *pGetDUNCallInfoReq );

extern enum eQCWWANError UpkQmiWdsSlqsGetDUNCallInfo(
    BYTE                                *pMdmResp,
    struct QmiWdsSlqsGetDUNCallInfoResp *pApiResp );

#endif /* __WDS_SLQS_GET_DUN_CALL_INFO_MSG_H__ */
