/*
 * \ingroup wds
 *
 * \file qaWdsSLQSGetCurrDataSystemStat.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsSLQSGetCurrDataSystemStat.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __WDS_SLQS_GET_CURR_DATA_SYSTEM_DATA_H__
#define __WDS_SLQS_GET_CURR_DATA_SYSTEM_DATA_H__

#include "qaGobiApiWds.h"

/* enum declarations */

/*
 * An enumeration of eQMI_SLQS_CURR_DATA_SYSTEM response TLV IDs
 */
enum eWDS_SLQS_CURR_DATA_SYSTEM_RESP
{
    eTLV_DATASYSTEMSTATUS = 0x10,
};

/*
 * This structure contains the SLQSGetCurrDataSystemStat response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSGetCurrDataSystemStat
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Current Data System Status response structure */
    CurrDataSysStat *pCurrDataSysStat;
};

/* Prototypes */
extern enum eQCWWANError PkQmiWdsSLQSGetCurrDataSystemStat(
    WORD *pMlength,
    BYTE *pBuffer );

extern enum eQCWWANError UpkQmiWdsSLQSGetCurrDataSystemStat(
    BYTE                                   *pMdmResp,
    struct QmiWdsSLQSGetCurrDataSystemStat *pApiResp );

#endif /* __WDS_SLQS_GET_CURR_DATA_SYSTEM_DATA_H__ */
