/*
 * \ingroup wds
 *
 * Filename: qaWdsIntSLQSSetSessionID.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsIntSLQSSetSessionID.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __WDS_INT_SLQS_SET_SESSION_ID_H__
#define __WDS_INT_SLQS_SET_SESSION_ID_H__

/*
 * This structure contains the iSLQSSetSessionID request parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSSetSessionIDReq
{
    BYTE  InstanceID;
    ULONG sessionID;
};

/*
 * This structure contains the iSLQSSetSessionID response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSSetSessionIDResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiWdsIntSetSessnID(
    WORD  *pMlength,
    BYTE  *pBuffer,
    BYTE  InstanceID,
    ULONG sessionID );

extern enum eQCWWANError UpkQmiWdsIntSetSessnID(
    BYTE                              *pMdmResp,
    struct QmiWdsSLQSSetSessionIDResp *pApiResp);

#endif /* __WDS_INT_SLQS_SET_SESSION_ID_H__ */
