/*
 * \ingroup wds
 *
 * Filename: qaWdsIntSLQSGetSessionID.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsIntSLQSGetSessionID.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __WDS_INT_SLQS_GET_SESSION_ID_H__
#define __WDS_INT_SLQS_GET_SESSION_ID_H__

/*
 * This structure contains the iSLQSGetSessionID request parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSGetSessionIDReq
{
    BYTE  InstanceID;
};

/*
 * This structure contains the iSLQSGetSessionID response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSGetSessionIDResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    GetSessionIDResp *pGetSessionIDResp;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiWdsIntGetSessnID(
    WORD  *pMlength,
    BYTE  *pBuffer,
    BYTE  InstanceID );

extern enum eQCWWANError UpkQmiWdsIntGetSessnID(
    BYTE                              *pMdmResp,
    struct QmiWdsSLQSGetSessionIDResp *pApiResp);

#endif /* __WDS_INT_SLQS_GET_SESSION_ID_H__ */
