/*
 * \ingroup wds
 *
 * Filename: qaWdsIntSLQSGetInstanceID.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsIntSLQSGetInstanceID.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __WDS_INT_SLQS_GET_INSTANCE_ID_H__
#define __WDS_INT_SLQS_GET_INSTANCE_ID_H__

/*
 * This structure contains the iSLQSGetInstanceID request parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSGetInstIDReq
{
    ULONG sessionID;
};

/*
 * This structure contains the iSLQSGetInstanceID response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsSLQSGetInstIDResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* iSLQSGetInstanceID response parameters */
    GetInstIDResp *pGetInstIDResp;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiWdsIntGetInstID(
    WORD  *pMlength,
    BYTE  *pBuffer,
    ULONG sessionID );

extern enum eQCWWANError UpkQmiWdsIntGetInstID(
    BYTE                           *pMdmResp,
    struct QmiWdsSLQSGetInstIDResp *pApiResp);

#endif /* __WDS_INT_SLQS_GET_INSTANCE_ID_H__ */
