/*
 * \ingroup wds
 *
 * \file qaWdsGetDataBearerTechnology.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaWdsGetDataBearerTechnology.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __WDS_GET_DATA_BEARER_TECH_EXT_MSG_H__
#define __WDS_GET_DATA_BEARER_TECH_EXT_MSG_H__

#include "qaGobiApiWds.h"

/* enum declarations */
/*
 *
 * An enumeration of eQMI_WDS_GET_DATA_BEARER response TLV IDs
 *
 */
enum eWDS_GET_DATA_BEARER_TECHNOLOGY_EXT_RESP
{
    eTLV_DATA_BEARER_TECH = 0x10,
    eTLV_LAST_CALL_DATA_BEARER_TECH = 0x11,    
};

/*
 * This structure contains the GetDataBearerTechnology response parameters.
 *
 * \sa qaGobiApiWds.h for parameter descriptions
 *
 */
struct QmiWdsGetDataBearerTechExtResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* GetDataBearerTechnology response parameters */
    DataBearerTechExt    *pDataBearerTechExt;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiWdsGetDataBearerTechnologyExt(
    WORD    *pMlength,
    BYTE    *pBuffer);

extern enum eQCWWANError UpkQmiWdsGetDataBearerTechnologyExt(
    BYTE    *pMdmResp,
    struct  QmiWdsGetDataBearerTechExtResp *pApiResp);

#endif /* __WDS_GET_DATA_BEARER_TECH_EXT_MSG_H__ */
