/*
 * \ingroup uim
 *
 * \file    qaUimSLQSUimSwitchSlot.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaUimSLQSUimSwitchSlot.c
 *
 * Copyright:  2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __UIM_SLQS_UIM_SWITCH_SLOT_H__
#define __UIM_SLQS_UIM_SWITCH_SLOT_H__

#include "qaGobiApiUim.h"

/* enum declarations */
/*
 * An enumeration of eQMI_UIM_SWITCH_SLOT_REQ request TLV IDs
 */
enum eUIM_SLQS_UIM_SWITCH_SLOT_REQ
{
    eTLV_UIM_SWITCH_SLOT_LOGICAL_SLOT       = 0x01,
    eTLV_UIM_SWITCH_SLOT_PHYICAL_SLOT       = 0x02,
    
};

/*
 * This structure contains the UimSLQSSwitchSlot response parameters.
 *
 *  \param  qmTlvResult[IN]
 *          - See \ref qmTlvResult for more information.
 */
typedef struct
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
}QmiUimSLQSSwitchSlotResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiUimSlqsSwitchSlot(
    WORD            *pMlength,
    BYTE            *pBuffer,
    UIMSwitchSlotReq *pReq );

extern enum eQCWWANError UpkQmiUimSlqsSwitchSlot(
    BYTE                           *pMdmResp,
    QmiUimSLQSSwitchSlotResp *pApiResp );

#endif /* __UIM_SLQS_UIM_SWITCH_SLOT_H__ */
