/*
 * \ingroup uim
 *
 * \file    qaUimSLQSUimPowerUp.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaUimSLQSUimPowerUp.c
 *
 * Copyright:  2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __UIM_SLQS_UIM_POWER_UP_H__
#define __UIM_SLQS_UIM_POWER_UP_H__

#include "qaGobiApiUim.h"

/* enum declarations */
/*
 * An enumeration of eUIM_SLQS_POWER_UP_REQ request TLV IDs
 */
enum eUIM_SLQS_POWER_UP_REQ
{
    eTLV_POWER_UP_SLOT  = 0x01,
    eTLV_POWER_UP_IGNORE_HOT_SWAP_SWITCH  = 0x10,
    
};

/*
 * This structure contains the UimSLQSPowerUp response parameters.
 */
struct QmiUimSLQSPowerUpResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiUimSlqsPowerUp(
    WORD            *pMlength,
    BYTE            *pBuffer,
    UIMPowerUpReq *pUIMPowerUpReq );

extern enum eQCWWANError UpkQmiUimSlqsPowerUp(
    BYTE                           *pMdmResp,
    struct QmiUimSLQSPowerUpResp *pApiResp );

#endif /* __UIM_SLQS_UIM_POWER_UP_H__ */
