/*
 * \ingroup uim
 *
 * \file    qaUimSLQSUimGetSlotsStatus.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaUimSLQSUimGetSlotsStatus.c
 *
 * Copyright:  2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __UIM_SLQS_UIM_GET_SLOTS_STATUS_H__
#define __UIM_SLQS_UIM_GET_SLOTS_STATUS_H__

#include "qaGobiApiUim.h"

/* enum declarations */
/*
 * An enumeration of eUIM_SLQS_GET_SLOTS_STATUS_RESP request TLV IDs
 */
enum eUIM_SLQS_GET_SLOTS_STATUS_RESP
{
    eTLV_UIM_GET_SLOTS_STATUS_PHY_SLOT_STATUS  = 0x10
};

/*
 * This structure contains the UimGetSlotsStatus response parameters.
 *
 *  \param  qmTlvResult[IN]
 *          - See \ref qmTlvResult for more information.
 *
 *  \param  pGetSlotsStatusResp[OUT]
 *          - See \ref UIMGetSlotsStatusResp for more information.
 */
typedef struct
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    UIMGetSlotsStatusResp *pGetSlotsStatusResp;
}QmiUimSLQSGetSlotsStatusResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiUimSlqsGetSlotsStatus(
    WORD            *pMlength,
    BYTE            *pBuffer);

extern enum eQCWWANError UpkQmiUimSlqsGetSlotsStatus(
    BYTE                           *pMdmResp,
    QmiUimSLQSGetSlotsStatusResp *pApiResp );

#endif /* __UIM_SLQS_UIM_GET_SLOTS_STATUS_H__ */
