/**************
 *
 *  Filename: qaGobiApiImsaTest.c
 *
 *  Purpose:  Contains functions implementing specific tests for
 *            Ims Service called by the main() routine in qatest.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc., all rights reserved
 *
 **************/

/* Linux definitions */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* include files */
#include "SwiDataTypes.h"
#include "qmerrno.h"
#include "qmudefs.h"

#include "qaGobiApiImsa.h"
#include "qaGobiApiImsaTest.h"
#include "qatesthelper.h"
#include "qatestproto.h"

/*******************
    TEST DATA
 *******************/

/* Constants */

/* Global Variables */

/* Indication Register Parameters */
local BYTE RegStatusInd = 0x01;
local BYTE SvcStatusInd = 0x01;
local BYTE RatStatusInd = 0x01;
local BYTE PdpStatusInd = 0x01;

/* Forward declaration */


/*******************
  TEST FUNCTIONS
 *******************/
/*
 * Name:    doSLQSRegisterIMSAIndication
 *
 * Purpose: Perform the tests that call the SLQSRegisterIMSAIndicationr() API
 *
 * Return:  none
 *
 * Notes:   none
 *
 */
void doSLQSRegisterIMSAIndication( void )
{
    /* Test Cases */
    SLQSIMSAIndRegisterTestCase_t SLQSIMSAIndRegisterTestCases[]=
    {
        { eQCWWAN_ERR_NONE, 1, NULL, NULL, NULL, NULL,
          "Error: At Least One Optional Parameter to be provided" },

        { eQCWWAN_ERR_NONE, 2, &RegStatusInd, NULL, NULL, NULL,
          "Set Reg Status Ind Event" },

        { eQCWWAN_ERR_NONE, 3, NULL, &SvcStatusInd, NULL, NULL,
          "Set Svc Status Ind Event" },

        { eQCWWAN_ERR_NONE, 4, NULL, NULL, &RatStatusInd, NULL,
          "Set Rat Status Ind Event" },        

        { eQCWWAN_ERR_NONE, 5, NULL, NULL, NULL, &PdpStatusInd,
          "Set PDP Status Ind Event" },

        { eQCWWAN_ERR_NONE, 6, &RegStatusInd, &SvcStatusInd, &RatStatusInd, &PdpStatusInd,
          "Set All" },
    };

    FILE  *fp = tfopen("../../imsa/test/results/slqsimsaindregister.txt", "w");

    IMSAIndRegisterInfo req;

    if (fp)
    {
        BYTE tc = 0;
        BYTE ncases = sizeof( SLQSIMSAIndRegisterTestCases )/
                      sizeof( SLQSIMSAIndRegisterTestCases[0] );
        while ( tc < ncases )
        {
            SLQSIMSAIndRegisterTestCase_t *pd =
                                    &SLQSIMSAIndRegisterTestCases[tc++];
            fprintf(fp, "\nTest Case %d / %d : %s\n",
                        tc,
                        ncases,
                        pd->desc);

            req.pRegStatusConfig          = pd->pRegStatusConfig;
            req.pServiceStatusConfig      = pd->pSvcStatusConfig;
            req.pRatHandoverStatusConfig  = pd->pRatStatusConfig;
            req.pPdpStatusConfig          = pd->pPdpStatusConfig;

            IFPRINTF(fp, "Reg Status Ind Event          : %x\n",
                                                 req.pRegStatusConfig);
            IFPRINTF(fp, "Svc Status Ind Event          : %x\n",
                                                 req.pServiceStatusConfig);
            IFPRINTF(fp, "Rat Status Ind Event          : %x\n",
                                                 req.pRatHandoverStatusConfig);
            IFPRINTF(fp, "PDP Status Ind Event          : %x\n",
                                                 req.pPdpStatusConfig);

            ULONG nRet = SLQSRegisterIMSAIndication( &req );
            doprintreason( fp, nRet );

            if ( eQCWWAN_ERR_NONE == nRet )
            {
                fprintf(fp, "SLQSRegisterIMSAIndication Successful\n");
            }
        }
    }
    if (fp)
        tfclose(fp);
}

/*
 * Name:    doSLQSGetIMSASupportedMsg
 *
 * Purpose: Perform the tests that call the SLQSGetIMSASupportedMsg() API
 *
 * Return:  none
 *
 * Notes:   none
 *
 */
void doSLQSGetIMSASupportedMsg( void )
{

    IMSASupportedMsgInfo resp;
    struct SupportedMsgList lSupportMsgList;

    resp.pSupportedMsgList = &lSupportMsgList;

    resp.pSupportedMsgList->supportedMsgLen = 0;

    /* Define the test cases to be executed */
    SLQSIMSASupportedMsgTestCase_t SLQSIMSASupportedMsgTestCases[] =
    {
        { eQCWWAN_ERR_INVALID_ARG, 1, NULL, "Invalid Test Case - Response structure NULL"},
        { eQCWWAN_ERR_NONE, 2, &resp, "Valid test Case "},
    };

    FILE  *fp = tfopen("../../imsa/test/results/slqsimsasupportedmsg.txt", "w");


    if (fp)
    {
        BYTE tc = 0;
        BYTE ncases = sizeof( SLQSIMSASupportedMsgTestCases )/
                      sizeof( SLQSIMSASupportedMsgTestCases[0] );
        while ( tc < ncases )
        {
           SLQSIMSASupportedMsgTestCase_t *pd =
                                    &SLQSIMSASupportedMsgTestCases[tc++];

           fprintf(fp, "\nTest Case %d / %d : %s\n",
                        tc,
                        ncases,
                        pd->desc);

            ULONG nRet = SLQSGetIMSASupportedMsg( pd->pIMSASupportedMsgInfo );
            doprintreason( fp, nRet );

            if ( eQCWWAN_ERR_NONE == nRet )
            {
                fprintf(fp, "SLQSGetIMSASupportedMsg Successful\n");
                if(resp.pSupportedMsgList->supportedMsgLen)
                {
                    if (resp.pSupportedMsgList != NULL)
                    {
                        BYTE i = 0;
                        fprintf( fp, "Supported Message Length: %d\n",
                                     (resp.pSupportedMsgList->supportedMsgLen));
                        for ( i = 0; i < resp.pSupportedMsgList->supportedMsgLen; i++ )
                        {
                            fprintf( fp, "Supported Msgs: %x\n",
                                 resp.pSupportedMsgList->supportedMsgs[i]);
                        }
                    }
                }
            }
        }
    }
    if (fp)
        tfclose(fp);
}

/*
 * Name:    doSLQSGetIMSASupportedFields
 *
 * Purpose: Perform the tests that call the SLQSGetIMSASupportedFields() API
 *
 * Return:  none
 *
 * Notes:   none
 *
 */
void doSLQSGetIMSASupportedFields( void )
{

    IMSASupportedFieldsResp resp;
    struct ReqFieldsList        lReqFieldsList;
    struct RespFieldsList       lRespFieldsList;
    struct IndFieldsList        lIndFieldsList;

    resp.pReqFieldsList  = &lReqFieldsList;
    resp.pRespFieldsList = &lRespFieldsList;
    resp.pIndFieldsList  = &lIndFieldsList;

    resp.pReqFieldsList->requestFieldsLen    = 0;
    resp.pRespFieldsList->responseFieldsLen  = 0;
    resp.pIndFieldsList->indicationFieldsLen = 0;

  /* Define the test cases to be executed */
    SLQSIMSASupportedFieldsTestCase_t SLQSIMSASupportedFieldsTestCases[] =
    {
        { eQCWWAN_ERR_INVALID_ARG, 1, 2, NULL, "Invalid Test Case - Response structure NULL"},
        { eQCWWAN_ERR_NONE, 2, 3, &resp, "Valid test Case "},
    };

    FILE  *fp = tfopen("../../imsa/test/results/slqsimsasupportedfields.txt", "w");

    if (fp)
    {
        BYTE tc = 0;
        BYTE ncases = sizeof( SLQSIMSASupportedFieldsTestCases )/
                      sizeof( SLQSIMSASupportedFieldsTestCases[0] );
        while ( tc < ncases )
        {
        	SLQSIMSASupportedFieldsTestCase_t *pd =
                                    &SLQSIMSASupportedFieldsTestCases[tc++];

           fprintf(fp, "\nTest Case %d / %d : %s\n",
                        tc,
                        ncases,
                        pd->desc);

            ULONG nRet = SLQSGetIMSASupportedFields( pd->messageID,
                                    pd->pIMSASupportedFieldsResp );
            doprintreason( fp, nRet );

            if ( eQCWWAN_ERR_NONE == nRet )
            {
                fprintf(fp, "SLQSGetIMSASupportedFields Successful\n");
                if (resp.pReqFieldsList != NULL)
                {
                    if(resp.pReqFieldsList->requestFieldsLen)
                    {
                        BYTE i = 0;
                        fprintf( fp, "Requested Fields Length: %d\n",
                                     (resp.pReqFieldsList->requestFieldsLen));
                        for ( i = 0; i < resp.pReqFieldsList->requestFieldsLen; i++ )
                        {
                              fprintf( fp, "Requested Fields: %x\n",
                                      resp.pReqFieldsList->requestFields[i]);
                        }
                    }
                }
                if (resp.pRespFieldsList != NULL)
                {
                    if(resp.pRespFieldsList->responseFieldsLen)
                    {
                        BYTE i = 0;
                        fprintf( fp, "Response Fields Length: %d\n",
                                     (resp.pRespFieldsList->responseFieldsLen));
                        for ( i = 0; i < resp.pRespFieldsList->responseFieldsLen; i++ )
                        {
                              fprintf( fp, "Response Fields: %x\n",
                                     resp.pRespFieldsList->responseFields[i]);
                        }
                    }
                }
                if (resp.pIndFieldsList != NULL)
                {
                    if(resp.pRespFieldsList->responseFieldsLen)
                    {
                        BYTE i = 0;
                        fprintf( fp, "Indication Fields Length: %d\n",
                                     (resp.pIndFieldsList->indicationFieldsLen));
                        for ( i = 0; i < resp.pIndFieldsList->indicationFieldsLen; i++ )
                        {
                              fprintf( fp, "Indication Fields: %x\n",
                                      resp.pIndFieldsList->indicationFields[i]);
                        }
                    }
                }
            }
        }
    }
    if (fp)
        tfclose(fp);
}

/*
 * Name:    doSLQSGetIMSARegStatus
 *
 * Purpose: Perform the tests that call the SLQSGetIMSARegStatus() API
 *
 * Return:  none
 *
 * Notes:   none
 *
 */
void doSLQSGetIMSARegStatus( void )
{

    IMSARegistrationStatus resp;

    BYTE  lImsRegStatus = 0xFF;
    WORD  lImsRegErrCode = 0xFFFF;
    ULONG lNewImsRegStatus = 0xFFFFFFFF;

    resp.pImsRegStatus    = &lImsRegStatus;
    resp.pImsRegErrCode   = &lImsRegErrCode;
    resp.pNewImsRegStatus = &lNewImsRegStatus;

  /* Define the test cases to be executed */
    SLQSIMSARegtrationStatusTestCase_t SLQSIMSARegtrationStatusTestCases[] =
    {
        { eQCWWAN_ERR_INVALID_ARG, 1, NULL, "Invalid Test Case - Response structure NULL"},
        { eQCWWAN_ERR_NONE, 2, &resp, "Valid test Case "},
    };

    FILE  *fp = tfopen("../../imsa/test/results/slqsimsaregistrationstatus.txt", "w");

    if (fp)
    {
        BYTE tc = 0;
        BYTE ncases = sizeof( SLQSIMSARegtrationStatusTestCases )/
                      sizeof( SLQSIMSARegtrationStatusTestCases[0] );
        while ( tc < ncases )
        {
        	SLQSIMSARegtrationStatusTestCase_t *pd =
                                    &SLQSIMSARegtrationStatusTestCases[tc++];

           fprintf(fp, "\nTest Case %d / %d : %s\n",
                        tc,
                        ncases,
                        pd->desc);

            ULONG nRet = SLQSGetIMSARegStatus(pd->pIMSARegistrationStatus );
            doprintreason( fp, nRet );

            if ( eQCWWAN_ERR_NONE == nRet )
            {
                fprintf(fp, "SLQSGetIMSARegStatus Successful\n");
                if(*resp.pImsRegStatus != MAXBYTE)
                    fprintf( fp, "IMS Registration Status: %x\n",*resp.pImsRegStatus );
                if(*resp.pImsRegErrCode != MAXWORD)
                    fprintf( fp, "IMS Registration Failure Error Code: 0x%x\n",*resp.pImsRegErrCode );
                if(*resp.pNewImsRegStatus != MAXULONG)
                    fprintf( fp, "New IMS Registration Status: %u\n",*resp.pNewImsRegStatus);
            } 
        }
    }
    if (fp)
        tfclose(fp);
}

/*
 * Name:    doSLQSGetIMSAServiceStatus
 *
 * Purpose: Perform the tests that call the SLQSGetIMSAServiceStatus() API
 *
 * Return:  none
 *
 * Notes:   none
 *
 */
void doSLQSGetIMSAServiceStatus( void )
{

    IMSAServiceStatus resp;

    ULONG  lSmsServiceStatus    = 0xFFFFFFFF;
    ULONG  lVoipServiceStatus   = 0xFFFFFFFF;
    ULONG  lVtServiceStatus     = 0xFFFFFFFF;
    ULONG  lSmsServiceRat       = 0xFFFFFFFF;
    ULONG  lVoipServiceRat      = 0xFFFFFFFF;
    ULONG  lVtServiceRat        = 0xFFFFFFFF;
    ULONG  lUtServiceStatus     = 0xFFFFFFFF;
    ULONG  lUtServiceRat        = 0xFFFFFFFF;
    ULONG  lVsServiceStatus     = 0xFFFFFFFF;
    ULONG  lVsServiceRat        = 0xFFFFFFFF;

    resp.pSmsServiceStatus  = &lSmsServiceStatus;
    resp.pVoipServiceStatus = &lVoipServiceStatus;
    resp.pVtServiceStatus   = &lVtServiceStatus;
    resp.pSmsServiceRat     = &lSmsServiceRat;
    resp.pVoipServiceRat    = &lVoipServiceRat;
    resp.pVtServiceRat      = &lVtServiceRat;
    resp.pUtServiceStatus   = &lUtServiceStatus;
    resp.pUtServiceRat      = &lUtServiceRat;
    resp.pVsServiceStatus   = &lVsServiceStatus;
    resp.pVsServiceRat      = &lVsServiceRat;

  /* Define the test cases to be executed */
    SLQSIMSAServiceStatusTestCase_t SLQSIMSAServiceStatusTestCases[] =
    {
        { eQCWWAN_ERR_INVALID_ARG, 1, NULL, "Invalid Test Case - Response structure NULL"},
        { eQCWWAN_ERR_NONE, 2, &resp, "Valid test Case "},
    };

    FILE  *fp = tfopen("../../imsa/test/results/slqsimsaservicestatus.txt", "w");

    if (fp)
    {
        BYTE tc = 0;
        BYTE ncases = sizeof( SLQSIMSAServiceStatusTestCases )/
                      sizeof( SLQSIMSAServiceStatusTestCases[0] );
        while ( tc < ncases )
        {
            SLQSIMSAServiceStatusTestCase_t *pd =
                                    &SLQSIMSAServiceStatusTestCases[tc++];

           fprintf(fp, "\nTest Case %d / %d : %s\n",
                        tc,
                        ncases,
                        pd->desc);

            ULONG nRet = SLQSGetIMSAServiceStatus(pd->pIMSAServiceStatus );
            doprintreason( fp, nRet );

            if ( eQCWWAN_ERR_NONE == nRet )
            {
                fprintf(fp, "SLQSGetIMSAServiceStatus Successful\n");
                if(*resp.pSmsServiceStatus != MAXULONG)
                    fprintf( fp, "SMS Service Status: %u\n",*resp.pSmsServiceStatus );
                if(*resp.pVoipServiceStatus != MAXULONG)
                    fprintf( fp, "VOIP Service Status: %u\n",*resp.pVoipServiceStatus );
                if(*resp.pVtServiceStatus != MAXULONG)
                    fprintf( fp, "VT Service Status: %u\n",*resp.pVtServiceStatus );
                if(*resp.pSmsServiceRat != MAXULONG)
                    fprintf( fp, "SMS Service RAT: %u\n",*resp.pSmsServiceRat );
                if(*resp.pVoipServiceRat != MAXULONG)
                    fprintf( fp, "VOIP Service RAT: %u\n",*resp.pVoipServiceRat );
                if(*resp.pVtServiceRat != MAXULONG)
                    fprintf( fp, "VT Service RAT: %u\n",*resp.pVtServiceRat );
                if(*resp.pUtServiceStatus != MAXULONG)
                    fprintf( fp, "UT Service Status: %u\n",*resp.pUtServiceStatus );
                if(*resp.pUtServiceRat != MAXULONG)
                    fprintf( fp, "UT Service RAT: %u\n",*resp.pUtServiceRat );
                if(*resp.pVsServiceStatus != MAXULONG)
                    fprintf( fp, "VS Service Status: %u\n",*resp.pVsServiceStatus );
                if(*resp.pVsServiceRat != MAXULONG)
                    fprintf( fp, "VS Service RAT: %u\n",*resp.pVsServiceRat );
            }
        }
    }
    if (fp)
        tfclose(fp);
}

