/**************
 *
 *  Filename:   qaGobiApiCbkTest.c
 *
 *  Purpose:    Gobi Callback API driver.
 *
 * Copyright: © 2011-2013 Sierra Wireless, Inc., all rights reserved
 *
 **************/

/* Linux definitions */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* include files */
#include "SwiDataTypes.h"
#include "qmerrno.h"
#include "qmudefs.h"
#include "qaGobiApiCbk.h"
#include "qatesthelper.h"
#include "qaCbkCatEventReportInd.h"
#include "qaCbkSwiOmaDmEventReportInd.h"
#include "qaCbkVoiceUssdInd.h"
#include "qaCbkWdsSWIRMTransferStatisticsInd.h"
#include "qatestproto.h"
#include "qaGobiApiQos.h"

#define OPTION_LENG 0x04
#define IPADDREESS_OCTET_MASK 0x000000FF
#define MAX_SIZE_IP 128

/*
 * Name:     UlongToDotIP
 *
 * Purpose:  Convert the IP address passed by the user in the form of ULONG
 *           value to a DOT format and copy it into the user buffer.
 *
 * Params:   IPAddress  - IP Address to be converted in dot notation.
 *           pIPAddress - Buffer to store IP Address converted to dot notation.
 *
 * Return:   None
 *
 * Notes:    None
 */
static void UlongToDotIP( ULONG IPAddress, char* pIPAddress )
{
    CHAR  tempBuf[5];
    BYTE  idx = 0;
    BYTE  shift = 0;
    ULONG tempIPAddress = 0;

    for( idx = 4; idx > 0; idx-- )
    {
        int   IPAddr = 0;
        shift = ( idx - 1 ) * 8;
        tempIPAddress = IPAddress >> shift;
        IPAddr = tempIPAddress & IPADDREESS_OCTET_MASK;
        sprintf( tempBuf, "%d", IPAddr );
        strcat( pIPAddress, tempBuf );
        tempIPAddress = 0;
        if( 1 >= idx )
        {
            continue;
        }
        strcat( pIPAddress, "." );
    }
}
/*******************
  TEST FUNCTIONS
 *******************/
/*
 * Name:     doprintsysInfoCommonCB
 *
 * Purpose:  This is a wrapper for printing System Information that is common
 *
 * Parms:    fp          - pointer to FILE
 *           pSys        - pointer to sysInfoCommon
 *
 * Return:   None
 *
 * Notes:    None.
 *
 */
void doprintsysInfoCommonCB( FILE *fp, sysInfoCommon *pSys )
{
    FILE *fpTmp;
    fpTmp = fp;
    fprintf( fpTmp,"Service Domain Valid   : %x\n",pSys->srvDomainValid );
    fprintf( fpTmp,"Service Domain         : %x\n",pSys->srvDomain );
    fprintf( fpTmp,"Service Capability Valid: %x\n",pSys->srvCapabilityValid );
    fprintf( fpTmp,"Service Capability     : %x\n",pSys->srvCapability );
    fprintf( fpTmp,"Roam Status Valid      : %x\n",pSys->roamStatusValid );
    fprintf( fpTmp,"Roam Status            : %x\n",pSys->roamStatus );
    fprintf( fpTmp,"Forbidden System Valid : %x\n",pSys->isSysForbiddenValid );
    fprintf( fpTmp,"Is Forbidden System    : %x\n",pSys->isSysForbiddenValid );
}

/*************
 *
 * Name:    cbkTestSetSessionStateCB
 *
 * Purpose: SLQSSetSessionStateCallback API callback function
 *
 * Parms:   pSessionStateInfo    - session state information
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetSessionStateCB(slqsSessionStateInfo *pSessionStateInfo)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setslqssessionstatecallback.txt", "a");
    if( fp == NULL )
    {
        perror("cbkTestSetSessionStateCB");
        return;
    }

    fprintf( fp,
             "\nInterface Instance ID: %d\tService %d\tv4 SID %u\tv6 SID %u\n",
             pSessionStateInfo->pQmiInterfaceInfo->qaQmiinstanceid,
             pSessionStateInfo->pQmiInterfaceInfo->qaQmisvctype,
             pSessionStateInfo->pQmiInterfaceInfo->v4sessionId,
             pSessionStateInfo->pQmiInterfaceInfo->v6sessionId );
    fprintf( fp,
             "state: %u\treconfiguration_required: %u\tsessionEndReason: %u\n",
             pSessionStateInfo->state,
             pSessionStateInfo->reconfiguration_required,
             pSessionStateInfo->sessionEndReason );

    tfclose(fp);
}

/*************
 *
 * Name:    doSetSessionStateCallback
 *
 * Purpose: SetSessionStateCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetSessionStateCallback( void )
{
    ULONG rc;

    rc = SLQSSetSessionStateCallback(&cbkTestSetSessionStateCB);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSetSessionStateCallback: failed to enable callback\n" );
    }
    else
    {
        printf( "doSetSessionStateCallback: enable callbackcbk "\
                "(cbkTestSetSessionStateCB)\n" );
    }
}

/*************
 *
 * Name:    doClearSessionStateCallback
 *
 * Purpose: SetSessionStateCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearSessionStateCallback( void )
{
    ULONG rc;

    rc = SLQSSetSessionStateCallback(NULL);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doClearSessionStateCallback: failed to disable callback\n" );
    }
    else
    {
        printf( "doClearSessionStateCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestdoSLQSSetWdsEventCB
 *
 * Purpose: SLQSSetWdsEventCallback API callback function
 *
 * Parms:   pWdsEventInfo  - WDS Event info
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestdoSLQSSetWdsEventCB( slqsWdsEventInfo *pWdsEventInfo )
{
    time_t rawtime;
    struct tm * timeinfo;
    char szBuff[64]={0};
    if(time( &rawtime )<0)
    {
        perror("cbkTestdoSLQSSetWdsEventCB Time");
        return;
    }
    timeinfo = localtime ( &rawtime );
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setwdseventcallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestdoSLQSSetWdsEventCB");
        return;
    }
    (void)strftime(szBuff, sizeof(szBuff), "%a %b %e %T %Y", timeinfo);
    fprintf(fp, "%s \n %s\n", szBuff, __func__);
    fprintf( fp,
             "\nInterface Instance ID: %d\tService %d\tv4 SID %u\tv6 SID %u\n",
             pWdsEventInfo->pQmiInterfaceInfo->qaQmiinstanceid,
             pWdsEventInfo->pQmiInterfaceInfo->qaQmisvctype,
             pWdsEventInfo->pQmiInterfaceInfo->v4sessionId,
             pWdsEventInfo->pQmiInterfaceInfo->v6sessionId );

    if (pWdsEventInfo->pDataBearer)
        fprintf(fp, "dataBearer: %u\n", *(pWdsEventInfo->pDataBearer) );

    if (pWdsEventInfo->pDormancyStatus)
        fprintf(fp, "Dormancy Status: %u\n", *(pWdsEventInfo->pDormancyStatus));

    if (pWdsEventInfo->pPacketsCountTX)
        fprintf(fp, "Transmitted Packets: %u\n", *(pWdsEventInfo->pPacketsCountTX));

    if (pWdsEventInfo->pPacketsCountRX)
        fprintf(fp, "Received Packets:    %u\n", *(pWdsEventInfo->pPacketsCountRX) );

    if (pWdsEventInfo->pTotalBytesTX)
        fprintf(fp, "Transmitted Bytes: %llu\n", *(pWdsEventInfo->pTotalBytesTX));

    if (pWdsEventInfo->pTotalBytesRX)
        fprintf(fp, "Received Bytes:    %llu\n", *(pWdsEventInfo->pTotalBytesRX) );

    tfclose(fp);
}

local void cbkTestdoSLQSSetQosEventCB(
        BYTE    instance,
        QosFlowInfo *pFlowInfo
        )
{
    FILE *fp;
    int count = 0;
    int tempCount = 0;
    CHAR  bufIPAddress[MAX_SIZE_IP];
    fp = tfopen("../../cbk/test/results/setQosEventCallback.txt", "a");

	if (fp == NULL)
	{
		perror("cbkTestdoSLQSSetQosEventCB");
		return ;
	}

    fprintf(fp, "\n%s: QMI %d\n", __func__, instance);

    if (pFlowInfo->pQFlowState)
    {
        fprintf(fp, "\t id %d, isNew %d, event %d \n",
                pFlowInfo->pQFlowState->id,
                pFlowInfo->pQFlowState->isNewFlow,
                pFlowInfo->pQFlowState->state
               );
    }
    IFPRINTF( fp, "\t Bearer ID   : %d\n",pFlowInfo->pBearerID);

    if (pFlowInfo->pTxQFlowGranted)
    {
        fprintf(fp, "\t tx flow index %d\n",
                pFlowInfo->pTxQFlowGranted->index);

        if (pFlowInfo->pTxQFlowGranted->pDataRate)
        {
            fprintf(fp, "\t\t max %d\n",
                    pFlowInfo->pTxQFlowGranted->pDataRate->dataRateMax);
            fprintf(fp, "\t\t guaranteedRate %d\n",
                    pFlowInfo->pTxQFlowGranted->pDataRate->guaranteedRate);
        }

        if (pFlowInfo->pTxQFlowGranted->pLatency)
        {
            fprintf(fp, "\t\t latency %d\n",
                    *pFlowInfo->pTxQFlowGranted->pLatency);
        }

        if (pFlowInfo->pTxQFlowGranted->pJitter)
        {
            fprintf(fp, "\t\t jitter %d\n",
                    *pFlowInfo->pTxQFlowGranted->pJitter);
        }

        if (pFlowInfo->pTxQFlowGranted->pLteQci)
        {
            fprintf(fp, "\t\t qci %d\n",
                    *pFlowInfo->pTxQFlowGranted->pLteQci);
        }

        if (pFlowInfo->pTxQFlowGranted->pMaxAllowedPktSz)
        {
            fprintf(fp, "\t\t Max Allowed Pkt Size = %u\n",
                    *pFlowInfo->pTxQFlowGranted->pMaxAllowedPktSz);
        }

        if (pFlowInfo->pTxQFlowGranted->p3GPP2Pri)
        {
            fprintf(fp, "\t\t 3GPP2 Priority = %d\n",
                    *pFlowInfo->pTxQFlowGranted->p3GPP2Pri);
        }

        if (pFlowInfo->pTxQFlowGranted->p3GPPImCn)
        {
            fprintf(fp, "\t\t 3GPP2 IM CN Flag = %d\n",
                    *pFlowInfo->pTxQFlowGranted->p3GPPImCn);
        }

        if (pFlowInfo->pTxQFlowGranted->p3GPPResResidualBER)
        {
            fprintf(fp, "\t\t Bit Error Rate = %d\n",
                    *pFlowInfo->pTxQFlowGranted->p3GPPResResidualBER);
        }

        if (pFlowInfo->pTxQFlowGranted->p3GPPSigInd)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %d\n",
                    *pFlowInfo->pTxQFlowGranted->p3GPPSigInd);
        }

        if (pFlowInfo->pTxQFlowGranted->p3GPPTraHdlPri)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %d\n",
                    *pFlowInfo->pTxQFlowGranted->p3GPPTraHdlPri);
        }

        if (pFlowInfo->pTxQFlowGranted->pMinPolicedPktSz)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %u\n",
                    *pFlowInfo->pTxQFlowGranted->pMinPolicedPktSz);
        }

        if (pFlowInfo->pTxQFlowGranted->pPktErrRate)
        {
        	fprintf(fp, "\t\t Packet Error Rate :\n" );
            fprintf(fp, "\t\t\tmultiplier = %d\n\t\t\texponent = %d\n",
                    pFlowInfo->pTxQFlowGranted->pPktErrRate->multiplier,
                    pFlowInfo->pTxQFlowGranted->pPktErrRate->exponent);
        }

        if (pFlowInfo->pTxQFlowGranted->pProfileId3GPP2)
        {
            fprintf(fp, "\t\t 3GPP2 Profile ID = %d\n",
                    *pFlowInfo->pTxQFlowGranted->pProfileId3GPP2);
        }

        if (pFlowInfo->pTxQFlowGranted->pTokenBucket)
        {
            fprintf(fp, "\t\t Token Bucket :\n" );
            fprintf(fp, "\t\t\t Bucket size = %u\n",
                    pFlowInfo->pTxQFlowGranted->pTokenBucket->bucketSz);
            fprintf(fp, "\t\t\t Peak Rate = %u\n",
                    pFlowInfo->pTxQFlowGranted->pTokenBucket->peakRate);
            fprintf(fp, "\t\t\t Token Rate = %u\n",
                    pFlowInfo->pTxQFlowGranted->pTokenBucket->tokenRate);
        }

        if (pFlowInfo->pTxQFlowGranted->pTrafficClass)
        {
            fprintf(fp, "\t\t Traffic Class = %d\n",
                    *pFlowInfo->pTxQFlowGranted->pTrafficClass);
        }

    }

    if (pFlowInfo->pRxQFlowGranted)
    {
        fprintf(fp, "\t rx flow index %d\n",
                pFlowInfo->pRxQFlowGranted->index);

        if (pFlowInfo->pRxQFlowGranted->pDataRate)
        {
            fprintf(fp, "\t\t max %d\n",
                    pFlowInfo->pRxQFlowGranted->pDataRate->dataRateMax);
            fprintf(fp, "\t\t guaranteedRate %d\n",
                    pFlowInfo->pRxQFlowGranted->pDataRate->guaranteedRate);
        }

        if (pFlowInfo->pRxQFlowGranted->pLatency)
        {
            fprintf(fp, "\t\t latency %d\n",
                    *pFlowInfo->pRxQFlowGranted->pLatency);
        }

        if (pFlowInfo->pRxQFlowGranted->pJitter)
        {
            fprintf(fp, "\t\t jitter %d\n",
                    *pFlowInfo->pRxQFlowGranted->pJitter);
        }

        if (pFlowInfo->pRxQFlowGranted->pLteQci)
        {
            fprintf(fp, "\t\t qci %d\n",
                    *pFlowInfo->pRxQFlowGranted->pLteQci);
        }

        if (pFlowInfo->pRxQFlowGranted->pMaxAllowedPktSz)
        {
            fprintf(fp, "\t\t Max Allowed Pkt Size = %u\n",
                    *pFlowInfo->pRxQFlowGranted->pMaxAllowedPktSz);
        }

        if (pFlowInfo->pRxQFlowGranted->p3GPP2Pri)
        {
            fprintf(fp, "\t\t 3GPP2 Priority = %d\n",
                    *pFlowInfo->pRxQFlowGranted->p3GPP2Pri);
        }

        if (pFlowInfo->pRxQFlowGranted->p3GPPImCn)
        {
            fprintf(fp, "\t\t 3GPP2 IM CN Flag = %d\n",
                    *pFlowInfo->pRxQFlowGranted->p3GPPImCn);
        }

        if (pFlowInfo->pRxQFlowGranted->p3GPPResResidualBER)
        {
            fprintf(fp, "\t\t Bit Error Rate = %d\n",
                    *pFlowInfo->pRxQFlowGranted->p3GPPResResidualBER);
        }

        if (pFlowInfo->pRxQFlowGranted->p3GPPSigInd)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %d\n",
                    *pFlowInfo->pRxQFlowGranted->p3GPPSigInd);
        }

        if (pFlowInfo->pRxQFlowGranted->p3GPPTraHdlPri)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %d\n",
                    *pFlowInfo->pRxQFlowGranted->p3GPPTraHdlPri);
        }

        if (pFlowInfo->pRxQFlowGranted->pMinPolicedPktSz)
        {
            fprintf(fp, "\t\t 3GPP2 Sig Indication = %u\n",
                    *pFlowInfo->pRxQFlowGranted->pMinPolicedPktSz);
        }

        if (pFlowInfo->pRxQFlowGranted->pPktErrRate)
        {
        	fprintf(fp, "\t\t Packet Error Rate :\n" );
            fprintf(fp, "\t\t\tmultiplier = %d\n\t\t\texponent = %d\n",
                    pFlowInfo->pRxQFlowGranted->pPktErrRate->multiplier,
                    pFlowInfo->pRxQFlowGranted->pPktErrRate->exponent);
        }

        if (pFlowInfo->pRxQFlowGranted->pProfileId3GPP2)
        {
            fprintf(fp, "\t\t 3GPP2 Profile ID = %d\n",
                    *pFlowInfo->pRxQFlowGranted->pProfileId3GPP2);
        }

        if (pFlowInfo->pRxQFlowGranted->pTokenBucket)
        {
            fprintf(fp, "\t\t Token Bucket :\n" );
            fprintf(fp, "\t\t\t Bucket size = %u\n",
                    pFlowInfo->pRxQFlowGranted->pTokenBucket->bucketSz);
            fprintf(fp, "\t\t\t Peak Rate = %u\n",
                    pFlowInfo->pRxQFlowGranted->pTokenBucket->peakRate);
            fprintf(fp, "\t\t\t Token Rate = %u\n",
                    pFlowInfo->pRxQFlowGranted->pTokenBucket->tokenRate);
        }

        if (pFlowInfo->pRxQFlowGranted->pTrafficClass)
        {
            fprintf(fp, "\t\t Traffic Class = %d\n",
                    *pFlowInfo->pRxQFlowGranted->pTrafficClass);
        }

     }

    if(NULL == pFlowInfo->pTxQFilter[0])
        fprintf(fp, "\tEither Tx QoS filter TLV is not present or "
                    "buffer size is not enough\n");
    if(NULL == pFlowInfo->pRxQFilter[0])
        fprintf(fp, "\tEither Rx QoS filter TLV is not present or "
                    "buffer size is not enough\n");
    for(tempCount=0; tempCount < MAX_QOS_FILTER_TLV; tempCount++)
    {
        if (pFlowInfo->pTxQFilter[tempCount])
        {
            fprintf(fp, "\t tx filter index %d ver %d\n",
                    pFlowInfo->pTxQFilter[tempCount]->index,
                    pFlowInfo->pTxQFilter[tempCount]->version);

            if (pFlowInfo->pTxQFilter[tempCount]->pTos)
            {
                fprintf(fp, "\t\t v4 tos val 0x%x mask 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTos->val,
                        pFlowInfo->pTxQFilter[tempCount]->pTos->mask);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv6TrafCls)
            {
                fprintf(fp, "\t\t v6 tc val 0x%x mask 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6TrafCls->val,
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6TrafCls->mask);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pNxtHdrProto)
            {
                fprintf(fp, "\t\t nxt hdr proto 0x%x\n",
                        *pFlowInfo->pTxQFilter[tempCount]->pNxtHdrProto);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pPrecedence)
            {
                fprintf(fp, "\t\t precedence 0x%x\n",
                        *pFlowInfo->pTxQFilter[tempCount]->pPrecedence);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pId)
            {
                fprintf(fp, "\t\t id 0x%x\n",
                        *pFlowInfo->pTxQFilter[tempCount]->pId);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pTCPSrcPort)
            {
                fprintf(fp, "\t\t TCP Source Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTCPSrcPort->port);
                fprintf(fp, "\t\t TCP Source port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTCPSrcPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pTCPDstPort)
            {
                fprintf(fp, "\t\t TCP Dest Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTCPDstPort->port);
                fprintf(fp, "\t\t TCP Dest port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTCPDstPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pUDPSrcPort)
            {
                fprintf(fp, "\t\t UDP Source Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pUDPSrcPort->port);
                fprintf(fp, "\t\t UDP Source port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pUDPSrcPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pUDPDstPort)
            {
                fprintf(fp, "\t\t UDP Dest Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pUDPDstPort->port);
                fprintf(fp, "\t\t UDP Dest port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pUDPDstPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv6SrcAddr)
            {
                fprintf(fp, "\t\t IPV6 Source Add = ");

                for(count =0;count<16;count=count+2)
                {
                    fprintf(fp,"%x%x",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6SrcAddr->addr[count],
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6SrcAddr->addr[count+1]);
                    if(count<14)
                    {
                    	fprintf(fp,":");
                    }
                }
                fprintf(fp, "\n");
                fprintf(fp, "\t\t IPV6 Source Prefix Len = 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6SrcAddr->prefixLen);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv6DstAddr)
            {
                fprintf(fp, "\t\t IPV6 Dest Add = ");

                for(count=0;count<16;count=count+2)
                {
                    fprintf(fp,"%x%x",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6DstAddr->addr[count],
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6DstAddr->addr[count+1]);
                    if(count<14)
                    {
                    	fprintf(fp,":");
                    }
                }
                fprintf(fp, "\n");
                fprintf(fp, "\t\t IPV6 Dest Prefix Len = 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv6DstAddr->prefixLen);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv6Label)
            {
                fprintf(fp, "\t\t IPV6 Label = %u\n",
                        *pFlowInfo->pTxQFilter[tempCount]->pIPv6Label);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pTranSrcPort)
            {
                fprintf(fp, "\t\t TP Src Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTranSrcPort->port);
                fprintf(fp, "\t\t TP Src port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTranSrcPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pTranDstPort)
            {
                fprintf(fp, "\t\t TP Dest Port %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTranDstPort->port);
                fprintf(fp, "\t\t TP Dest port range %d\n",
                        pFlowInfo->pTxQFilter[tempCount]->pTranDstPort->range);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pEspSpi)
            {
                fprintf(fp, "\t\t ESP SPI = 0x%x\n",
                        *pFlowInfo->pTxQFilter[tempCount]->pEspSpi);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv4SrcAddr)
            {
                memset( bufIPAddress, 0, MAX_SIZE_IP );
                UlongToDotIP( pFlowInfo->pTxQFilter[tempCount]->pIPv4SrcAddr->addr,
                              bufIPAddress );

                fprintf(fp, "\t\t IPV4 Source Add = %s\n",
                        bufIPAddress);
                fprintf(fp, "\t\t IPV4 Subnet Mask 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv4SrcAddr->subnetMask);
            }

            if (pFlowInfo->pTxQFilter[tempCount]->pIPv4DstAddr)
            {
                memset( bufIPAddress, 0, MAX_SIZE_IP );
                UlongToDotIP( pFlowInfo->pTxQFilter[tempCount]->pIPv4DstAddr->addr,
                              bufIPAddress );

                fprintf(fp, "\t\t IPV4 Dest Add = %s\n",
                        bufIPAddress);
                fprintf(fp, "\t\t IPV4 Subnet Mask 0x%x\n",
                        pFlowInfo->pTxQFilter[tempCount]->pIPv4DstAddr->subnetMask);
            }
        }
    }

    for(tempCount=0; tempCount < MAX_QOS_FILTER_TLV; tempCount++)
    {
        if (pFlowInfo->pRxQFilter[tempCount])
        {
            fprintf(fp, "\t rx filter index %d ver %d\n",
                    pFlowInfo->pRxQFilter[tempCount]->index,
                    pFlowInfo->pRxQFilter[tempCount]->version);

            if (pFlowInfo->pRxQFilter[tempCount]->pTos)
            {
                fprintf(fp, "\t\t v4 tos val 0x%x mask 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTos->val,
                        pFlowInfo->pRxQFilter[tempCount]->pTos->mask);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv6TrafCls)
            {
                fprintf(fp, "\t\t v6 tc val 0x%x mask 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6TrafCls->val,
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6TrafCls->mask);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pNxtHdrProto)
            {
                fprintf(fp, "\t\t nxt hdr proto 0x%x\n",
                        *pFlowInfo->pRxQFilter[tempCount]->pNxtHdrProto);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pPrecedence)
            {
                fprintf(fp, "\t\t precedence 0x%x\n",
                        *pFlowInfo->pRxQFilter[tempCount]->pPrecedence);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pId)
            {
                fprintf(fp, "\t\t id 0x%x\n",
                        *pFlowInfo->pRxQFilter[tempCount]->pId);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pTCPSrcPort)
            {
                fprintf(fp, "\t\t TCP Source Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTCPSrcPort->port);
                fprintf(fp, "\t\t TCP Source port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTCPSrcPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pTCPDstPort)
            {
                fprintf(fp, "\t\t TCP Dest Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTCPDstPort->port);
                fprintf(fp, "\t\t TCP Dest port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTCPDstPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pUDPSrcPort)
            {
                fprintf(fp, "\t\t UDP Source Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pUDPSrcPort->port);
                fprintf(fp, "\t\t UDP Source port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pUDPSrcPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pUDPDstPort)
            {
                fprintf(fp, "\t\t UDP Dest Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pUDPDstPort->port);
                fprintf(fp, "\t\t UDP Dest port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pUDPDstPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv6SrcAddr)
            {
                fprintf(fp, "\t\t IPV6 Source Add = ");

                for(count =0;count<16;count=count+2)
                {
                    fprintf(fp,"%x%x",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6SrcAddr->addr[count],
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6SrcAddr->addr[count+1]);
                    if(count<14)
                    {
                    	fprintf(fp,":");
                    }
                }
                fprintf(fp, "\n");
                fprintf(fp, "\t\t IPV6 Source Prefix Len = 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6SrcAddr->prefixLen);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv6DstAddr)
            {
                fprintf(fp, "\t\t IPV6 Dest Add = ");

                for(count=0;count<16;count=count+2)
                {
                    fprintf(fp,"%x%x",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6DstAddr->addr[count],
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6DstAddr->addr[count+1]);
                    if(count<14)
                    {
                    	fprintf(fp,":");
                    }
                }
                fprintf(fp, "\n");
                fprintf(fp, "\t\t IPV6 Dest Prefix Len = 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv6DstAddr->prefixLen);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv6Label)
            {
                fprintf(fp, "\t\t IPV6 Label = %u\n",
                        *pFlowInfo->pRxQFilter[tempCount]->pIPv6Label);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pTranSrcPort)
            {
                fprintf(fp, "\t\t TP Src Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTranSrcPort->port);
                fprintf(fp, "\t\t TP Src port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTranSrcPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pTranDstPort)
            {
                fprintf(fp, "\t\t TP Dest Port %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTranDstPort->port);
                fprintf(fp, "\t\t TP Dest port range %d\n",
                        pFlowInfo->pRxQFilter[tempCount]->pTranDstPort->range);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pEspSpi)
            {
                fprintf(fp, "\t\t id 0x%x\n",
                        *pFlowInfo->pRxQFilter[tempCount]->pEspSpi);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv4SrcAddr)
            {
                memset( bufIPAddress, 0, MAX_SIZE_IP );
                UlongToDotIP( pFlowInfo->pRxQFilter[tempCount]->pIPv4SrcAddr->addr,
                              bufIPAddress );

                fprintf(fp, "\t\t IPV4 Source Add = %s\n",
                        bufIPAddress);
                fprintf(fp, "\t\t IPV4 Subnet Mask 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv4SrcAddr->subnetMask);
            }

            if (pFlowInfo->pRxQFilter[tempCount]->pIPv4DstAddr)
            {
                memset( bufIPAddress, 0, MAX_SIZE_IP );
                UlongToDotIP( pFlowInfo->pRxQFilter[tempCount]->pIPv4DstAddr->addr,
                              bufIPAddress );

                fprintf(fp, "\t\t IPV4 Dest Add = %s\n",
                        bufIPAddress);
                fprintf(fp, "\t\t IPV4 Subnet Mask 0x%x\n",
                        pFlowInfo->pRxQFilter[tempCount]->pIPv4DstAddr->subnetMask);
            }
        }
    }
    tfclose(fp);
}

local void iSLQSSetQosEventCallback(
    BYTE            instance,
    tFNSLQSQOSEvent pCallback)
{
    ULONG rc;
    rc = SLQSSetQosEventCallback(instance, pCallback );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "%s: failed to enable callback\n", __func__ );
    }
    else
    {
        fprintf(stderr,
                "%s: callback enabled\n", __func__ );
    }
}

package void doSLQSSetQosFirstInstEventCallback( void )
{
    iSLQSSetQosEventCallback(0, &cbkTestdoSLQSSetQosEventCB);
}

package void doSLQSClearQosFirstInstEventCallback( void )
{
    iSLQSSetQosEventCallback(0, NULL);
}

package void doSLQSSetQosSecondInstEventCallback( void )
{
    iSLQSSetQosEventCallback(1, &cbkTestdoSLQSSetQosEventCB);
}

package void doSLQSClearQosSecondInstEventCallback( void )
{
    iSLQSSetQosEventCallback(1, NULL);
}

package void doSLQSSetQosThirdInstEventCallback( void )
{
    iSLQSSetQosEventCallback(2, &cbkTestdoSLQSSetQosEventCB);
}

package void doSLQSClearQosThirdInstEventCallback( void )
{
    iSLQSSetQosEventCallback(2, NULL);
}

/*************
 *
 * Name:    doSLQSSetWdsSecondInstEventCallback
 *
 * Purpose: SLQSSetWdsEventCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSLQSSetWdsEventCallback( void )
{
    ULONG rc;
    CHAR  *pEndOfLine;
    CHAR  selOption[OPTION_LENG];
    ULONG userOption;
    BYTE  len;
    BYTE  instance = 0;
    BYTE ipfamily = 0;

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter InstanceID value (  0 to 2 )  \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default Instance ID - 0 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        instance = userOption;
        switch( userOption )
        {
            case 0:
                break;
            case 1:
                break;
            case 2:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid InstanceID\n");
               continue;
        }
        break;
    }

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter ip family value  (  4(IPv4), 6(IPv6) or 7(IPv4v6) )  \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default ip family  - ipv4 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        ipfamily = userOption;
        switch( ipfamily )
        {
            case 4:
                break;
            case 6:
                break;
            case 7:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid ip family\n");
               continue;
        }
        break;
    }

    rc = SLQSSetWdsEventCallback( &cbkTestdoSLQSSetWdsEventCB,
                                  10,
                                  instance,
                                  ipfamily );
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSLQSSetWdsEventCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf(stderr,
                "doSLQSSetWdsEventCallback: enable callback (cbkTestdoSLQSSetWdsEventCB, 10)\n" );
    }
}


/*************
 *
 * Name:    doClearSLQSWdsEventCallback
 *
 * Purpose: SLQSSetWdsEventCallback driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearSLQSWdsEventCallback( void )
{
    ULONG rc;
    CHAR  *pEndOfLine;
    CHAR  selOption[OPTION_LENG];
    ULONG userOption;
    BYTE  len;
    BYTE  instance = 0;
    BYTE ipfamily = 0;

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter InstanceID value (  0 to 2 )  \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default Instance ID - 0 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        instance = userOption;
        switch( userOption )
        {
            case 0:
                break;
            case 1:
                break;
            case 2:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid InstanceID\n");
               continue;
        }
        break;
    }

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter ip family value (  4(IPv4), 6(IPv6) or 7(IPv4v6) )    \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default ip family  - ipv4 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        ipfamily = userOption;
        switch( ipfamily )
        {
            case 4:
                break;
            case 6:
                break;
            case 7:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid ip family\n");
               continue;
        }
        break;
    }

    rc = SLQSSetWdsEventCallback( NULL,
                                  10,
                                  instance,
                                  ipfamily );
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSLQSSetWdsEventCallback: failed to Clear callback\n" );
    }
    else
    {
        fprintf(stderr,
                "doSLQSSetWdsEventCallback: cleared callback \n" );
    }
}

/*************
 *
 * Name:    cbkTestSetPowerCB
 *
 * Purpose: SetPowerCallback API callback function
 *
 * Parms:   operatingMode - Operating Mode
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetPowerCB(
    ULONG operatingMode )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setpowercallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetPowerCB");
        return;
    }

    fprintf(fp, "Operating Mode: %u\n", operatingMode );
    tfclose(fp);
}

/*************
 *
 * Name:    doSetPowerCallback
 *
 * Purpose: SetPowerCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetPowerCallback( void )
{
    ULONG rc;

    rc = SetPowerCallback(&cbkTestSetPowerCB);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doSetPowerCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetPowerCallback: enable callback (cbkTestSetPowerCB)\n" );
    }
}

/*************
 *
 * Name:    doClearPowerCallback
 *
 * Purpose: SetPowerCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearPowerCallback( void )
{
    ULONG rc;

    rc = SetPowerCallback(NULL);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doClearPowerCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearPowerCallback: disable callback (NULL)\n" );

   }
}

/*************
 *
 * Name:    cbkTestSetActivationStatusCB
 *
 * Purpose: SetActivationStatusCallback API callback function
 *
 * Parms:   activationStatus  - Activation Status
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetActivationStatusCB(
    ULONG activationStatus )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setactivationstatuscallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetActivationStatusCB");
        return;
    }

    fprintf(fp, "Activation Status: %u\n", activationStatus );
    tfclose(fp);
}

/*************
 *
 * Name:    doSetActivationStatusCallback
 *
 * Purpose: SetActivationStatusCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetActivationStatusCallback( void )
{
    ULONG rc;

    rc = SetActivationStatusCallback(&cbkTestSetActivationStatusCB);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doSetActivationStatusCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetActivationStatusCallback: enable callback (cbkTestSetActivationStatusCB)\n" );
    }
}

/*************
 *
 * Name:    doClearActivationStatusCallback
 *
 * Purpose: SetActivationStatusCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearActivationStatusCallback( void )
{
    ULONG rc;

    rc = SetActivationStatusCallback(NULL);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doClearActivationStatusCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearActivationStatusCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetMobileIPStatusCB
 *
 * Purpose: SetMobileIPStatusCallback API callback function
 *
 * Parms:   dormancyStatus  - Dormancy Status
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetMobileIPStatusCB(
    ULONG dormancyStatus )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setmobileipstatuscallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetMobileIPStatusCB");
        return;
    }

    fprintf(fp, "Dormancy Status: %u\n", dormancyStatus );
    tfclose(fp);
}

/*************
 *
 * Name:    doSetMobileIPStatusCallback
 *
 * Purpose: SetMobileIPStatusCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetMobileIPStatusCallback( void )
{
    ULONG rc;

    rc = SetMobileIPStatusCallback(&cbkTestSetMobileIPStatusCB);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doSetMobileIPStatusCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetMobileIPStatusCallback: enable callback (cbkTestSetMobileIPStatusCB)\n" );
    }
}

/*************
 *
 * Name:    doClearMobileIPStatusCallback
 *
 * Purpose: SetMobileIPStatusCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearMobileIPStatusCallback( void )
{
    ULONG rc;

    rc = SetMobileIPStatusCallback(NULL);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doClearMobileIPStatusCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearMobileIPStatusCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetRoamingIndicatorCB
 *
 * Purpose: SetRoamingIndicatorCallback API callback function
 *
 * Parms:   roaming - Roaming indicator
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetRoamingIndicatorCB(
    ULONG roaming )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setroamingindicatorcallback.txt", "a");
    if( fp == NULL )
    {
        perror("cbkTestSetRoamingIndicatorCB");
        return;
    }

    fprintf( fp,
             "roaming indicator: %u\n", roaming );

    tfclose(fp);
}

/*************
 *
 * Name:    doSetRoamingIndicatorCallback
 *
 * Purpose: SetRoamingIndicatorCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetRoamingIndicatorCallback( void )
{
    ULONG rc;

    rc = SetRoamingIndicatorCallback(&cbkTestSetRoamingIndicatorCB);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSetRoamingIndicatorCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetRoamingIndicatorCallback: enable callbackcbk "\
                "(cbkTestSetRoamingIndicatorCB)\n" );
    }
}

/*************
 *
 * Name:    doClearRoamingIndicatorCallback
 *
 * Purpose: SetRoamingIndicatorCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearRoamingIndicatorCallback( void )
{
    ULONG rc;

    rc = SetRoamingIndicatorCallback(NULL);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doClearRoamingIndicatorCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearRoamingIndicatorCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetDataCapabilitiesCB
 *
 * Purpose: SetDataCapabilitiesCallback API callback function
 *
 * Parms:   datacapslen - Data Capabilities Length
 *          datacaps    - Data Capabilities
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetDataCapabilitiesCB(
    BYTE datacapslen,
    BYTE *datacaps )
{
    FILE *fp;
    BYTE count = 0;
    fp = tfopen("../../cbk/test/results/setdatacapabilitiescallback.txt", "a");
    if( fp == NULL )
    {
        perror("cbkTestSetDataCapabilitiesCB");
        return;
    }

    fprintf( fp, "data capabilities length: %d\n", datacapslen );
    for ( count = 0; count < datacapslen; count++ )
        fprintf( fp, "data capabilities[%d]: %d\n", count, datacaps[count] );

    tfclose(fp);
}

/*************
 *
 * Name:    doSetDataCapabilitiesCallback
 *
 * Purpose: SetDataCapabilitiesCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetDataCapabilitiesCallback( void )
{
    ULONG rc;

    rc = SetDataCapabilitiesCallback(&cbkTestSetDataCapabilitiesCB);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSetDataCapabilitiesCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetDataCapabilitiesCallback: enable callbackcbk "\
                "(cbkTestSetDataCapabilitiesCB)\n" );
    }
}

/*************
 *
 * Name:    doClearDataCapabilitiesCallback
 *
 * Purpose: SetDataCapabilitiesCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearDataCapabilitiesCallback( void )
{
    ULONG rc;

    rc = SetDataCapabilitiesCallback(NULL);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doClearDataCapabilitiesCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearDataCapabilitiesCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetSignalStrengthCB
 *
 * Purpose: SetSignalStrengthCallback API callback function
 *
 * Parms:   activationStatus  - Activation Status
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetSignalStrengthCB(
    INT8  signalStrength,
    ULONG radioInterface )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setsignalstrengthcallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetSignalStrengthCB");
        return;
    }
    fprintf(fp, "Signal Strength: %d\n", signalStrength );
    fprintf(fp, "Radio Interface: %u\n", radioInterface );
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSignalStrengthCallback
 *
 * Purpose: SetSignalStrengthCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetSignalStrengthCallback( void )
{
    ULONG rc;
    BYTE thresholdsSize = 5;
    INT8 thresholds[5]  = {-100,-90,-80,-70,-60};

    rc = SetSignalStrengthCallback(&cbkTestSetSignalStrengthCB,
                                           thresholdsSize,thresholds);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                "doSetSignalStrengthCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetSignalStrengthCallback:\
        enable callback(cbkTestSetSignalStrengthCB)\n" );
    }
}

/*************
 *
 * Name:    doClearSignalStrengthCallback
 *
 * Purpose: SetSignalStrengthCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearSignalStrengthCallback( void )
{
    ULONG rc;
    BYTE thresholdsSize = 0;
    INT8 thresholds[1]  = {0};

    rc = SetSignalStrengthCallback(NULL,thresholdsSize,thresholds);

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                    "doClearSignalStrengthCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearSignalStrengthCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetRFInfoCallbackCB
 *
 * Purpose: SetRFInfoCallback API callback function
 *
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetRFInfoCallbackCB(
    ULONG radioInterface,
    ULONG activeBandClass,
    ULONG activeChannel )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setrfinfocallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetRFInfoCB");
        return;
    }

    fprintf(fp, "Radio Interface: %x\n", radioInterface );
    fprintf(fp, "Active Band Class: %x\n", activeBandClass );
    fprintf(fp, "Active Channel: %x\n", activeChannel );
    tfclose(fp);
}

/*************
 *
 * Name:    doSetRFInfoCallback
 *
 * Purpose: SetRFInfoCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetRFInfoCallback( void )
{
    ULONG rc;

    rc = SetRFInfoCallback(&cbkTestSetRFInfoCallbackCB );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                "doSetRFInfoCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetRFInfoCallback:\
                          enable callback(cbkTestSetRFInfoCallbackCB)\n" );
    }
}

/*************
 *
 * Name:    doClearRFInfoCallback
 *
 * Purpose: SetRFInfoCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearRFInfoCallback( void )
{
    ULONG rc;

    rc = SetRFInfoCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                   "doClearSetRFInfoCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearSetRFInfoCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetLURejectCallbackCB
 *
 * Purpose: SetLURejectCallback API callback function
 *
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetLURejectCallbackCB()

{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setLUrejectcallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetLUrejectCB");
        return;
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetLURejectCallback
 *
 * Purpose: SetLURejectCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSetLURejectCallback( void )
{
    ULONG rc;

    rc = SetLURejectCallback(&cbkTestSetLURejectCallbackCB );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                "doSetLURejectCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSetLUrejectCallback:\
                          enable callback(cbkTestSetLURejectCallbackCB)\n" );
    }
}

/*************
 *
 * Name:    doClearLURejectCallback
 *
 * Purpose: SetLURejectCallback API driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearLURejectCallback( void )
{
    ULONG rc;

    rc = SetLURejectCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                   "doClearLURejectCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr, "doClearLURejectCallback: disable callback (NULL)\n" );
    }
}

/*************
 *
 * Name:    cbkTestSetCatEventCB
 *
 * Purpose: SetCATEventCallback API callback function
 *
 **************/
local void cbkTestSetCatEventCB(
    ULONG EventID,
    ULONG EventLength,
    BYTE  *pEventData
)
{
    FILE *fp;
    ULONG index;

    fp = tfopen("../../cbk/test/results/cbkTestSetCatEventCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetCatEventCB");
    else
    {
        fprintf ( fp, "Event ID: %x\r\n\n", EventID );
        fprintf ( fp, "Event Length is: %x\r\n\n", EventLength );
        if( (EventID == eTLV_CBK_DISPLAY_TEXT)          ||
            (EventID == eTLV_CBK_GET_IN_KEY)            ||
            (EventID == eTLV_CBK_GET_INPUT)             ||
            (EventID == eTLV_CBK_SETUP_MENU)            ||
            (EventID == eTLV_CBK_SELECT_ITEM)           ||
            (EventID == eTLV_CBK_LANGUAGE_NOTIFICATION) ||
            (EventID == eTLV_CBK_SETUP_IDLE_MODE_TEXT) )
        {
            struct CatEventIDDataTlv *pData =
                    (struct CatEventIDDataTlv *)pEventData;
            fprintf ( fp, "Reference ID is: %x\r\n\n", pData->ReferenceID );
            fprintf ( fp, "Data Length is: %d\r\n\n", pData->DataLength );
            fprintf ( fp, "Event Data is: \r\n" );
            for ( index = 0; index < pData->DataLength; index++ )
                fprintf ( fp, "%c", pData->Data[index] );

            fprintf ( fp, "\r\nEvent Data is (in HEX): \r\n" );
            for ( index = 0; index < pData->DataLength; index++ )
                fprintf ( fp, "%x ", pData->Data[index] );

            fprintf ( fp, "\r\n" );
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetCATEventCallback
 *
 * Purpose: SetCATEventCallback API test function
 *
 **************/
package void doSetCATEventCallback( void )
{
    ULONG rc;
    ULONG eventMask = 0xFFFF;
    ULONG pErrorMask;

    rc = SetCATEventCallback( &cbkTestSetCatEventCB, eventMask, &pErrorMask  );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetCATEventCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetCATEventCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearCATEventCallback
 *
 * Purpose: Clear the SetCATEventCallback API
 *
 **************/
package void doClearCATEventCallback( void )
{
    ULONG rc;
    ULONG eventMask = 0xFFFF;
    ULONG pErrorMask;

    rc = SetCATEventCallback( NULL, eventMask, &pErrorMask  );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearCATEventCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearCATEventCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetNMEACB
 *
 * Purpose: SetNMEACallback API callback function
 *
 **************/
local void cbkTestSetNMEACB(
const char *pNMEAData)

{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/setPositionDataNMEAcallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetNMEACB");
    else
    {
        fprintf ( fp, "NMEA Data Follows:\r\n\n" );
        fprintf ( fp, "%s\r\n", pNMEAData );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetNMEACallback
 *
 * Purpose: SetNMEACallback API test function
 *
 **************/
package void doSetNMEACallback( void )
{
    ULONG rc;

    rc = SetNMEACallback(&cbkTestSetNMEACB );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetNMEACallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetNMEACallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearNMEACallback
 *
 * Purpose: Clear the SetNMEACallback API
 *
 **************/
package void doClearNMEACallback( void )
{
    ULONG rc;

    rc = SetNMEACallback( NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearNMEACallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearNMEACallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetPdsStateCB
 *
 * Purpose: SetPdsStateCallback API callback function
 *
 **************/
local void cbkTestSetPdsStateCB(
    ULONG EnabledMode,
    ULONG TrackingState)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetPdsStateCbk.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetPdsStateCbk");
    else
    {
        fprintf ( fp, "Enabled Mode is: %u\r\n\n", EnabledMode );
        fprintf ( fp, "cbkTestSetPdsStateCbk is: %u\r\n\n", TrackingState );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetPdsStateCallback
 *
 * Purpose: SetPdsStateCallback API test function
 *
 **************/
package void doSetPdsStateCallback( void )
{
    ULONG rc;

    rc = SetPDSStateCallback( &cbkTestSetPdsStateCB );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetPdsStateCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetPdsStateCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearPdsStateCallback
 *
 * Purpose: Clear the SetPdsStateCallback API
 *
 **************/
package void doClearPdsStateCallback( void )
{
    ULONG rc;

    rc = SetPDSStateCallback( NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearPdsStateCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearPdsStateCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetNewSMSCB
 *
 * Purpose: SetNewSMSCallback API callback function
 *
 **************/
local void cbkTestSetNewSMSCB(
    ULONG StorageType,
    ULONG MessageIndex
)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetNewSMSCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetNewSMSCB");
    else
    {
        fprintf ( fp, "SMS Storage Type is: %u\r\n\n", StorageType );
        fprintf ( fp, "SMS Message Index is: %u\r\n\n", MessageIndex );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetNewSMSCallback
 *
 * Purpose: SetNewSMSCallback API test function
 *
 **************/
package void doSetNewSMSCallback( void )
{
    ULONG rc;

    rc = SetNewSMSCallback( &cbkTestSetNewSMSCB );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetNewSMSCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetNewSMSCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearNewSMSCallback
 *
 * Purpose: Clear the SetNewSMSCallback API
 *
 **************/
package void doClearNewSMSCallback( void )
{
    ULONG rc;

    rc = SetNewSMSCallback( NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearNewSMSCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearNewSMSCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSMSEventCB
 *
 * Purpose: SLQSSetSMSEventCallback API callback function
 *
 **************/
local void cbkTestSMSEventCB( SMSEventInfo *pSMSEventInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSMSEventCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSMSEventCB");
    else
    {
        if ( pSMSEventInfo->smsEventType & SMS_EVENT_MT_MESSAGE )
        {
            fprintf ( fp, "Event : SMS_EVENT_MT_MESSAGE\r\n" );
            fprintf ( fp,
                      "SMS Storage Type is: %u\r\n\n",
                      pSMSEventInfo->pMTMessageInfo->storageType );
            fprintf ( fp,
                      "SMS Message Index is: %u\r\n\n",
                      pSMSEventInfo->pMTMessageInfo->messageIndex );
        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_MESSAGE_MODE )
        {
            fprintf ( fp, "Event : SMS_EVENT_MESSAGE_MODE\r\n" );
            fprintf ( fp,
                      "SMS Mode is: %d\r\n\n",
                      pSMSEventInfo->pMessageModeInfo->messageMode );
        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_TRANSFER_ROUTE_MT_MESSAGE )
        {
            int lLength;
            int lIndex = 0;

            fprintf ( fp, "Event : SMS_EVENT_TRANSFER_ROUTE_MT_MESSAGE\r\n" );
            fprintf ( fp,
                      "Ack Indicator is: %d\r\n\n",
                      pSMSEventInfo->pTransferRouteMTMessageInfo->ackIndicator );
            fprintf ( fp,
                      "Transaction ID is: %u\r\n\n",
                      pSMSEventInfo->pTransferRouteMTMessageInfo->transactionID );
            fprintf ( fp,
                      "Format is: %d\r\n\n",
                      pSMSEventInfo->pTransferRouteMTMessageInfo->format );
            fprintf ( fp,
                      "length is: %d\r\n\n",
                      pSMSEventInfo->pTransferRouteMTMessageInfo->length );

            lLength = pSMSEventInfo->pTransferRouteMTMessageInfo->length;

            lIndex = 0;
            fprintf ( fp, "data is: \n");
            while(lLength--)
            {
                fprintf ( fp,
                          "%2xH",
                          pSMSEventInfo->pTransferRouteMTMessageInfo->data[lIndex++] );
                if (lIndex % 16 ==0)
                {
                    fprintf ( fp, "\n");
                }
            }
            fprintf ( fp, "\r\n\n" );
        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_ETWS )
        {
            int lLength;
            int lIndex = 0;

            fprintf ( fp, "Event : SMS_EVENT_ETWS\r\n" );
            fprintf ( fp,
                      "SMS Notification Type is: %d\r\n\n",
                      pSMSEventInfo->pEtwsMessageInfo->notificationType );
            fprintf ( fp,
                      "ETWS Message length is: %d\r\n\n",
                      pSMSEventInfo->pEtwsMessageInfo->length );

            lLength = pSMSEventInfo->pEtwsMessageInfo->length;
            lIndex = 0;
            fprintf ( fp, "data is: ");
            while(lLength--)
                fprintf ( fp,
                          "%2X ",
                          pSMSEventInfo->pEtwsMessageInfo->data[lIndex++] );

            fprintf ( fp, "\r\n\n" );

        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_ETWS_PLMN )
        {
            fprintf ( fp, "Event : SMS_EVENT_ETWS_PLMN\r\n" );
            fprintf ( fp,
                      "MCC: %xH\r\n\n",
                      pSMSEventInfo->pEtwsPlmnInfo->mobileCountryCode );
            fprintf ( fp,
                      "MNC: %xH\r\n\n",
                      pSMSEventInfo->pEtwsPlmnInfo->mobileNetworkCode );
        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_SMSC_ADDRESS )
        {
            int lLength;
            int lIndex = 0;

            fprintf ( fp, "Event : SMS_EVENT_SMSC_ADDRESS\r\n" );
            fprintf ( fp,
                      "SMSC length is: %d\r\n\n",
                      pSMSEventInfo->pSMSCAddressInfo->length );

            lLength = pSMSEventInfo->pSMSCAddressInfo->length;
            lIndex = 0;
            fprintf ( fp, "data is: ");
            while(lLength--)
                fprintf ( fp,
                          "%2x",
                          pSMSEventInfo->pSMSCAddressInfo->data[lIndex++] );

            fprintf ( fp, "\r\n\n" );
        }

        if ( pSMSEventInfo->smsEventType & SMS_EVENT_SMS_ON_IMS )
        {
            fprintf ( fp, "Event : SMS_EVENT_SMS_ON_IMS\r\n" );
            fprintf ( fp,
                      "SMS on IMS is: %x\r\n\n",
                      pSMSEventInfo->pSMSOnIMSInfo->smsOnIMS );
        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSLQSSetSMSEventCallback
 *
 * Purpose: SLQSSetSMSEventCallback API test function
 *
 **************/
package void doSLQSSetSMSEventCallback( void )
{
    ULONG rc;

    rc = SLQSSetSMSEventCallback( &cbkTestSMSEventCB );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSLQSSetSMSEventCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSLQSSetSMSEventCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSMSEventCallback
 *
 * Purpose: Clear the SLQSSetSMSEventCallback API
 *
 **************/
package void doClearSLQSSetSMSEventCallback( void )
{
    ULONG rc;

    rc = SLQSSetSMSEventCallback( NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetSMSEventCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetSMSEventCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetSLQSOMADMAlertCallback
 *
 * Purpose: SetSLQSOMADMAlertCallback API callback function
 *
 **************/
local void cbkTestSetSLQSOMADMAlertCallback(
   ULONG eventType,
   BYTE* pEventFields )
{
    FILE                         *fp;
    struct omaDmFotaTlv          *sessionInfoFota;
    struct omaDmConfigTlv        *sessionInfoConfig;
    USHORT                       lLength = 0;

    fp = tfopen("../../cbk/test/results/cbkTestSetSLQSOMADMAlertCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetSLQSOMADMAlertCallback");
    else
    {
        fprintf ( fp, "\n>>Event Type is: %u\n", eventType );
        if ( eventType == QMI_SWIOMA_DM_FOTA )
        {
            fprintf ( fp, ">>Event Information for FOTA is as follows:\n");
            if ( pEventFields )
            {
                BYTE    *pLByte;
                sessionInfoFota = (struct omaDmFotaTlv *)pEventFields;
                fprintf( fp, ">>State: %x\n", sessionInfoFota->state );
                fprintf( fp, ">>User Input Req: %x\n",\
                    sessionInfoFota->userInputReq );
                fprintf( fp, ">>User Input Timeout: %d\n",\
                    sessionInfoFota->userInputTimeout );
                fprintf( fp, ">>Fwd Load Size: %u\n",\
                    sessionInfoFota->fwdloadsize );
                fprintf( fp, ">>Fwd Load Complete: %u\n",\
                    sessionInfoFota->fwloadComplete );
                fprintf( fp, ">>Update Complete Status: %d\n",\
                    sessionInfoFota->updateCompleteStatus );
                fprintf( fp, ">>Severity: %x\n",\
                    sessionInfoFota->severity );
                fprintf( fp, ">>Version Length: %d\n",\
                    sessionInfoFota->versionlength );
                fprintf( fp, ">>Version: " );
                lLength = sessionInfoFota->versionlength;
                pLByte  = sessionInfoFota->version;
                while ( lLength-- )
                    fprintf( fp, ">>%x", *(pLByte)++ );
                fprintf( fp, ">>\n" );
                fprintf( fp, ">>Name Length: %d\n",\
                    sessionInfoFota->namelength );
                fprintf( fp, ">>Package Name: " );
                lLength = sessionInfoFota->namelength;
                pLByte  = sessionInfoFota->package_name;
                while ( lLength-- )
                    fprintf( fp, ">>%x", *(pLByte)++ );
                fprintf( fp, ">>\n" );
                fprintf( fp, ">>Description Length: %d\n",\
                    sessionInfoFota->descriptionlength );
                fprintf( fp, ">>Description: " );
                lLength = sessionInfoFota->descriptionlength;
                pLByte  = sessionInfoFota->description;
                while ( lLength-- )
                    fprintf( fp, ">>%x", *(pLByte)++ );
                fprintf( fp, ">>\n" );
            }
        }
        else if( eventType == QMI_SWIOMA_DM_CONFIG )
        {
            fprintf ( fp, ">>Event Information for Config is as follows:\n");
            if ( pEventFields )
            {
                BYTE    *pLByte;
                sessionInfoConfig = (struct omaDmConfigTlv *)pEventFields;
                fprintf( fp, ">>State: %x\n", sessionInfoConfig->state );
                fprintf( fp, ">>User Input Req: %x\n",\
                    sessionInfoConfig->userInputReq );
                fprintf( fp, ">>User Input Timeout: %d\n",\
                    sessionInfoConfig->userInputTimeout );
                fprintf( fp, ">>Alert Message Length: %d\n",\
                    sessionInfoConfig->alertmsglength );
                fprintf( fp, ">>Alert Message: " );
                lLength = sessionInfoConfig->alertmsglength;
                pLByte  = sessionInfoConfig->alertmsg;
                while ( lLength-- )
                    fprintf( fp, ">>%x", *(pLByte)++ );
                fprintf( fp, ">>\n" );
            }
        }
        else if( eventType == QMI_SWIOMA_DM_NOT )
        {
            fprintf ( fp, ">>Event Information for Notification is as follows:\n");
            if ( pEventFields )
            {
                struct omaDmNotificationsTlv *sessionInfoNotification;
                sessionInfoNotification = (struct omaDmNotificationsTlv *)pEventFields;
                fprintf( fp, ">>Notification: %02x\n", sessionInfoNotification->notification );
                fprintf( fp, ">>Session Status: 0x%04x\n",\
                        sessionInfoNotification->sessionStatus );
            }
        }
        else
            fprintf ( fp, ">>Invalid Event Type Received\n");
        if(fp)
            tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSOMADMAlertCallback
 *
 * Purpose: SetSLQSOMADMAlertCallback API test function
 *
 **************/
package void doSetSLQSOMADMAlertCallback( void )
{
    ULONG rc;

    rc = SetSLQSOMADMAlertCallback( &cbkTestSetSLQSOMADMAlertCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSOMADMAlertCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSOMADMAlertCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSOMADMAlertCallback
 *
 * Purpose: Clear the SetSLQSOMADMAlertCallback API
 *
 **************/
package void doClearSLQSOMADMAlertCallback( void )
{
    ULONG rc;

    rc = SetSLQSOMADMAlertCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSOMADMAlertCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSOMADMAlertCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetDeviceStateChangeCallback
 *
 * Purpose: SetDeviceStateChangeCallback API callback function
 *
 **************/
local void cbkTestSetDeviceStateChangeCallback(
   eDevState   device_state )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetDeviceStateChangeCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetDeviceStateChangeCallback");
    else
    {
        fprintf( fp, "Device State: %d\n", device_state );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetDeviceStateChangeCallback
 *
 * Purpose: SetDeviceStateChangeCallback API test function
 *
 **************/
package void doSetDeviceStateChangeCallback( void )
{
    ULONG rc;

    rc = SetDeviceStateChangeCbk( &cbkTestSetDeviceStateChangeCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetDeviceStateChangeCallback: Failed : %u\r\n",\
                 rc );
    else
        fprintf( stderr, "doSetDeviceStateChangeCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearDeviceStateChangeCallback
 *
 * Purpose: Clear the DeviceStateChangeCallback API
 *
 **************/
package void doClearDeviceStateChangeCallback( void )
{
    ULONG rc;

    rc = SetDeviceStateChangeCbk( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearDeviceStateChangeCallback: Failed : %u\n",\
                 rc );
    else
        fprintf( stderr, "doClearDeviceStateChangeCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetFwDldCompletionCallback
 *
 * Purpose: SetFwDldCompletionCallback API callback function
 *
 **************/
local void cbkTestSetFwDldCompletionCallback(
    ULONG   fwdwl_com_status )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetFwDldCompletionCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetFwDldCompletionCallback");
    else
    {
        fprintf( fp, "Firmware Download Completion Status: %u\n",\
                 fwdwl_com_status );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetFwDldCompletionCallback
 *
 * Purpose: SetFwDldCompletionCallback API test function
 *
 **************/
package void doSetFwDldCompletionCallback( void )
{
    ULONG rc;

    rc = SetFwDldCompletionCbk( &cbkTestSetFwDldCompletionCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetFwDldCompletionCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetFwDldCompletionCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearFwDldCompletionCallback
 *
 * Purpose: Clear the ClearFwDldCompletionCallback API
 *
 **************/
package void doClearFwDldCompletionCallback( void )
{
    ULONG rc;

    rc = SetFwDldCompletionCbk( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearFwDldCompletionCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearFwDldCompletionCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkSLQSServingSystemCallback
 *
 * Purpose: SLQSServingSystemCallback API callback function
 *
 **************/
local void cbkSLQSServingSystemCallback(
    struct ServingSystemInfo *pServingSystem ,struct RoamingInfo *pRoamingInfo)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkSLQSServingSystemCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkSLQSServingSystemCallback");
    else
    {
        BYTE i;
        fprintf( fp, "SLQSServing System Parameters:\n" );
        fprintf( fp, "RegistrationState %d\n",
                 pServingSystem->registrationState );
        fprintf( fp, "CS AttachState:%d\n",
                 pServingSystem->csAttachState );
        fprintf( fp, "PS AttachState:%d\n",
                 pServingSystem->psAttachState );
        fprintf( fp, "SelectedNetwork:%d\n",
                 pServingSystem->selectedNetwork );
        fprintf( fp, "radioInterfaceNo:%d\n",
                 pServingSystem->radioInterfaceNo );
        fprintf( fp, "HDR Personality %d\n",
                 pServingSystem->hdrPersonality );
        for( i = 0; i < pServingSystem->radioInterfaceNo ; i++ )
            fprintf( fp, "RadioInterfaces:%d\n",
                     pServingSystem->radioInterfaceList[i] );
        if(pRoamingInfo->TlvPresent)
            fprintf( fp, "Roaming %d\n",
                     pRoamingInfo->roaming_ind );
                        
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSServingSystemCallBack
 *
 * Purpose: SetSLQSServingSystemCallback API test function
 *
 **************/
package void doSetSLQSServingSystemCallback( void )
{
    ULONG rc;

    rc = SLQSSetServingSystemCallback( &cbkSLQSServingSystemCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSServingSystemCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSServingSystemCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSServingSystemCallback
 *
 * Purpose: Clear the SLQSServingSystemCallback API
 *
 **************/
package void doClearSLQSServingSystemCallback( void )
{
    ULONG rc;

    rc = SLQSSetServingSystemCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSServingSystemCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSServingSystemCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetOMADMStateCallback
 *
 * Purpose: SetOMADMStateCallback API callback function
 *
 **************/
local void cbkTestSetOMADMStateCallback(
    ULONG sessionState,
    ULONG failureReason )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetOMADMStateCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetOMADMStateCallback");
    else
    {
        fprintf( fp, "OMA DM State: %u :: Fail Reason: %u\n",
                 sessionState,
                 failureReason );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetOMADMStateCallback
 *
 * Purpose: SetOMADMStateCallback API test function
 *
 **************/
package void doSetOMADMStateCallback( void )
{
    ULONG rc;

    rc = SetOMADMStateCallback( &cbkTestSetOMADMStateCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetOMADMStateCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetOMADMStateCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearOMADMStateCallback
 *
 * Purpose: Clear the SetOMADMStateCallback API
 *
 **************/
package void doClearOMADMStateCallback( void )
{
    ULONG rc;

    rc = SetOMADMStateCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearOMADMStateCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearOMADMStateCallback: Disabled\n" );
}
/*************
 *
 * Name:    cbkSLQSSetBandPreferenceCallback
 *
 * Purpose: SLQSSetBandPreferenceCallback API callback function
 *
 **************/
local void cbkSLQSSetBandPreferenceCallback(
    ULONGLONG band_pref )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkSLQSSetBandPreferenceCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkSLQSSetBandPreferenceCallback");
    else
    {
        fprintf( fp, "SLQSSetBandPreferenceCallback Parameters:\n" );
        fprintf( fp, "Band Preference %llx\n", band_pref );
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSSetBandPrefCallBack
 *
 * Purpose: SLQSSetBandPreferenceCallback API test function
 *
 **************/
package void doSetSLQSSetBandPrefCallBack( void )
{
    ULONG rc;

    rc = SLQSSetBandPreferenceCbk( &cbkSLQSSetBandPreferenceCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSSetBandPrefCallBack: Failed :"
                 " %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSSetBandPrefCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetBandPrefCallback
 *
 * Purpose: Clear the SLQSSetBandPreferenceCallback API
 *
 **************/
package void doClearSLQSSetBandPrefCallback( void )
{
    ULONG rc;

    rc = SLQSSetBandPreferenceCbk( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetBandPrefCallback: Failed : "
                 "%u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetBandPrefCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetUSSDReleaseCallback
 *
 * Purpose: SetUSSDReleaseCallback API callback function
 *
 **************/
local void cbkTestSetUSSDReleaseCallback()
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetUSSDReleaseCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetUSSDReleaseCallback");
    else
    {
        fprintf( fp, "USSD release indication received\n" );

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetUSSDReleaseCallback
 *
 * Purpose: SetUSSDReleaseCallback API test function
 *
 **************/
package void doSetUSSDReleaseCallback( void )
{
    ULONG rc;

    rc = SetUSSDReleaseCallback( &cbkTestSetUSSDReleaseCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSetUSSDReleaseCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetUSSDReleaseCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:   doClearSetUSSDReleaseCallback
 *
 * Purpose: Clear the SetUSSDReleaseCallback
 *
 **************/
package void doClearSetUSSDReleaseCallback( void )
{
    ULONG rc;

    rc = SetUSSDReleaseCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSetUSSDReleaseCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSetUSSDReleaseCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetUSSDNotificationCallback
 *
 * Purpose: SetUSSDNotificationCallback API callback function
 *
 **************/
local void cbkTestSetUSSDNotificationCallback(
    ULONG Notification_type,
    BYTE *pNetworkInfo )
{
    FILE *fp;
    BYTE           lLength = 0;

    fp = tfopen("../../cbk/test/results/cbkTestSetUSSDNotificationCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetUSSDNotificationCallback");
    else
    {
        fprintf( fp, "Voice Ussd Notification Type: %u :: \n",
                 Notification_type );
        if( pNetworkInfo )
        {
           struct USSInfo *pNwInfo;
           pNwInfo = (struct USSInfo *)pNetworkInfo;
           fprintf( fp, "USS DCS: %d\n", pNwInfo->ussDCS );
           fprintf( fp, "USS Len: %d\n", pNwInfo->ussLen );

           fprintf( fp, "USS Data: ");
           while ( lLength < pNwInfo->ussLen )
           {
                fprintf( fp, " 0x%x", pNwInfo->ussData[lLength]);
                lLength++;
           }
           fprintf( fp, "\n\n");
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetUSSDNotificationCallback
 *
 * Purpose: SetUSSDNotificationCallback API test function
 *
 **************/
package void doSetUSSDNotificationCallback( void )
{
    ULONG rc;
    rc = SetUSSDNotificationCallback(&cbkTestSetUSSDNotificationCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetUSSDNotificationCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SetUSSDNotificationCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearUSSDNotificationCallback
 *
 * Purpose: Clear the SetUSSDNotificationCallback API
 *
 **************/
package void doClearUSSDNotificationCallback( void )
{
    ULONG rc;

    rc = SetUSSDNotificationCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearUSSDNotificationCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearUSSDNotificationCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetUSSDNoWaitIndicationCallback
 *
 * Purpose: SetUSSDNoWaitIndicationCallback API callback function
 *
 **************/
local void cbkTestSetUSSDNoWaitIndicationCallback(
        USSDNoWaitIndicationInfo *pNetworkInfo )
{
    FILE *fp;
    BYTE           lLength = 0;

    fp = tfopen("../../cbk/test/results/cbkTestSetUSSDNoWaitIndicationCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSetUSSDNoWaitIndicationCallback");
    else
    {
        if( pNetworkInfo )
        {
           if( NULL != pNetworkInfo->pUSSDData )
           {
               struct USSInfo *pNwInfo;
               pNwInfo = pNetworkInfo->pUSSDData;
               fprintf( fp, "USS DCS: %d\n", pNwInfo->ussDCS );
               fprintf( fp, "USS Len: %d\n", pNwInfo->ussLen );

               fprintf( fp, "USS Data: ");
               while ( lLength < pNwInfo->ussLen )
               {
                    fprintf( fp, "%c", pNwInfo->ussData[lLength]);
                    lLength++;
               }
           }
           fprintf( fp, "\n\n");
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetUSSDNoWaitIndicationCallback
 *
 * Purpose: SetUSSDNoWaitIndicationCallback API test function
 *
 **************/
package void doSetUSSDNoWaitIndicationCallback( void )
{
    ULONG rc;
    rc = SetUSSDNoWaitIndicationCallback(&cbkTestSetUSSDNoWaitIndicationCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetUSSDNoWaitIndicationCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetUSSDNoWaitIndicationCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearUSSDNoWaitIndicationCallback
 *
 * Purpose: Clear the SetUSSDNoWaitIndicationCallback API
 *
 **************/
package void doClearUSSDNoWaitIndicationCallback( void )
{
    ULONG rc;

    rc = SetUSSDNoWaitIndicationCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearUSSDNotificationCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearUSSDNotificationCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetSignalStrengthsCallback
 *
 * Purpose: SLQSSetSignalStrengthsCallback API callback function
 *
 **************/
local void cbkTestSLQSSetSignalStrengthsCallback(
    struct SLQSSignalStrengthsInformation sSLQSSignalStrengthsInfo )
{
    FILE *fp;

    fp = tfopen( "../../cbk/test/results/cbkTestSLQSSetSignalStrengthsCallback.txt", "a" );

    if ( fp == NULL )
        perror( "cbkTestSLQSSetSignalStrengthsCallback" );
    else
    {
        fprintf( fp, "RSSI Information :\n" );
        fprintf( fp, "Received Signal Strength : %d\n",
                     sSLQSSignalStrengthsInfo.rxSignalStrengthInfo.
                     rxSignalStrength );
        fprintf( fp, "Radio IF : %d\n\n",
                      sSLQSSignalStrengthsInfo.rxSignalStrengthInfo.radioIf );

        fprintf( fp, "ECIO Information :\n" );
        fprintf( fp, "ECIO     : %d\n",
                      sSLQSSignalStrengthsInfo.ecioInfo.ecio );
        fprintf( fp, "Radio IF : %d\n\n",
                     sSLQSSignalStrengthsInfo.ecioInfo.radioIf );

        fprintf( fp, "IO   : %u\n", sSLQSSignalStrengthsInfo.io );
        fprintf( fp, "SINR : %d\n\n", sSLQSSignalStrengthsInfo.sinr );

        fprintf( fp, "Error Rate Information :\n" );
        fprintf( fp, "Error Rate : %d\n",
                     sSLQSSignalStrengthsInfo.errorRateInfo.errorRate );
        fprintf( fp, "Radio IF   : %d\n\n",
                     sSLQSSignalStrengthsInfo.errorRateInfo.radioIf );

        fprintf( fp, "RSRQ Information :\n" );
        fprintf( fp, "RSRQ     : %d\n",
                     sSLQSSignalStrengthsInfo.rsrqInfo.rsrq );
        fprintf( fp, "Radio IF : %d\n\n",
                     sSLQSSignalStrengthsInfo.rsrqInfo.radioIf );
        
        fprintf( fp, "LTE SNR LEVEL :%.1f dB (%d)\n\n",
                             (float)((float)sSLQSSignalStrengthsInfo.lteSnrinfo.snrlevel/10 ),
                              sSLQSSignalStrengthsInfo.lteSnrinfo.snrlevel );
        fprintf( fp, "LTE RSRP(-44 to -140) : %d dBm\n\n",
                             sSLQSSignalStrengthsInfo.lteRsrpinfo.rsrplevel );
        fprintf( fp, "\n\n");
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSLQSSetSignalStrengthsCallback
 *
 * Purpose: SLQSSetSignalStrengthsCallback API test function
 *
 **************/
package void doSLQSSetSignalStrengthsCallback( void )
{
    struct SLQSSignalStrengthsIndReq sSLQSSignalStrengthsIndReq;
    ULONG                            rc;
    BYTE                             idx = 0;
    SHORT                            ecioBuf[] = { -10, -20, -30, -40, -50 };
    BYTE                             sinrBuf[] = { 10, 20, 30, 40, 50 };

    /* Intialize the input parameters */
    sSLQSSignalStrengthsIndReq.rxSignalStrengthDelta = 1;
    sSLQSSignalStrengthsIndReq.ecioDelta             = 1;
    sSLQSSignalStrengthsIndReq.ioDelta               = 1;
    sSLQSSignalStrengthsIndReq.sinrDelta             = 1;
    sSLQSSignalStrengthsIndReq.rsrqDelta             = 1;
    sSLQSSignalStrengthsIndReq.ecioThresholdListLen  = 5;
    sSLQSSignalStrengthsIndReq.sinrThresholdListLen  = 5;
    sSLQSSignalStrengthsIndReq.lteSnrDelta           = 1;
    sSLQSSignalStrengthsIndReq.lteRsrpDelta          = 1;
    for( idx = 0;
         idx < sSLQSSignalStrengthsIndReq.ecioThresholdListLen;
         idx++ )
    {
        sSLQSSignalStrengthsIndReq.ecioThresholdList[idx] = ecioBuf[idx];
    }

    for( idx = 0;
         idx < sSLQSSignalStrengthsIndReq.sinrThresholdListLen;
         idx++ )
    {
        sSLQSSignalStrengthsIndReq.sinrThresholdList[idx] = sinrBuf[idx];
    }

    rc = SLQSSetSignalStrengthsCallback(&cbkTestSLQSSetSignalStrengthsCallback,
                                        &sSLQSSignalStrengthsIndReq );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr, "doSLQSSetSignalStrengthsCallback: "\
                         "Failed : %u\r\n", rc );
    }
    else
    {
        fprintf( stderr, "SLQSSetSignalStrengthsCallback: Enabled callback\r\n" );
    }
}

/*************
 *
 * Name:    doClearSLQSSetSignalStrengthsCallback
 *
 * Purpose: Clear the SLQSSetSignalStrengthsCallback API
 *
 **************/
package void doClearSLQSSetSignalStrengthsCallback( void )
{
    struct SLQSSignalStrengthsIndReq sSLQSSignalStrengthsIndReq;
    ULONG                            rc;

    rc = SLQSSetSignalStrengthsCallback( NULL,
                                         &sSLQSSignalStrengthsIndReq );
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr, "doClearSLQSSetSignalStrengthsCallback:"\
                         "Failed : %u\n", rc );
    }
    else
    {
        fprintf( stderr, "doClearSLQSSetSignalStrengthsCallback: Disabled\n" );
    }
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetSUPSNotificationCallback
 *
 * Purpose: SLQSVoiceSetSUPSNotificationCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetSUPSNotificationCallback(
    voiceSUPSNotification *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSVoiceSetSUPSNotificationCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetSUPSNotificationCallback");
    else
    {
        fprintf( fp, "Voice SUPS: Call ID: %x :: Notification Type : %x \n",
                 pInfo->callID, pInfo->notifType );

        if( pInfo->pCUGIndex )
        {
            fprintf( fp, "CUG Index: %d\n", *(pInfo->pCUGIndex) );
        }
        if( pInfo->pECTNum )
        {
            fprintf(fp, "ECT Information:\n" );
            fprintf(fp, "Call State: %x\n", pInfo->pECTNum->ECTCallState );
            fprintf(fp, "Presentation Ind: %x\n", pInfo->pECTNum->presentationInd);
            fprintf(fp, "CUG Index: %s\n", pInfo->pECTNum->number);
        }
        fprintf( fp, "\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSVoiceSetSUPSNotificationCallback
 *
 * Purpose: SLQSVoiceSetSUPSNotificationCallback test function
 *
 **************/
package void doSLQSVoiceSetSUPSNotificationCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceSetSUPSNotificationCallback(&cbkTestSLQSVoiceSetSUPSNotificationCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSVoiceSetSUPSNotificationCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSVoiceSetSUPSNotificationCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceSetSUPSNotificationCallback
 *
 * Purpose: Clear the doSLQSVoiceSetSUPSNotificationCallback API
 *
 **************/
package void doClearSLQSVoiceSetSUPSNotificationCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetSUPSNotificationCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSVoiceSetSUPSNotificationCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSVoiceSetSUPSNotificationCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetSLQSSDKTerminatedCallback
 *
 * Purpose: SetSLQSKillSDKProcessCallback API callback function
 *
 **************/
local void cbkTestSetSLQSSDKTerminatedCallback(
    BYTE *psReason)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetSLQSSDKTerminatedCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetSLQSSDKTerminatedCallback");
    else
    {
        fprintf( fp, "\nSDK terminated indication:%s\n", psReason );

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSKillSDKProcessCallback
 *
 * Purpose: Set SLQSKillSDKProcessCallback API test function
 *
 **************/
package void doSetSLQSSDKTerminatedCallback( void )
{
    ULONG rc;
    rc = SLQSSetSDKTerminatedCallback (&cbkTestSetSLQSSDKTerminatedCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SetSLQSSDKTerminatedCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SetSLQSSDKTerminatedCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSKillSDKProcessCallback
 *
 * Purpose: Clear the SLQSSetSignalStrengthsCallback API
 *
 **************/
package void doClearSLQSSDKTerminatedCallback( void )
{
    ULONG                            rc;

    rc = SLQSSetSDKTerminatedCallback( NULL ) ;
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr, "doClearSLQSSDKTerminatedCallback:"\
                         "Failed : %u\n", rc );
    }
    else
    {
        fprintf( stderr, "ClearSLQSSDKTerminatedCallback: Disabled\n" );
    }
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetAllCallStatusCB
 *
 * Purpose: SLQSSetSMSEventCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetAllCallStatusCB(
    voiceSetAllCallStatusCbkInfo *pVoiceSetAllCallStatusCbkInfo )
{
    FILE *fp;
    voiceSetAllCallStatusCbkInfo *pLVACS = pVoiceSetAllCallStatusCbkInfo;

    fp = tfopen("../../cbk/test/results/cbkTestSLQSVoiceSetAllCallStatusCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetAllCallStatusCB");
    else
    {
        fprintf( fp, "\nCall Information:\n" );
        {
            int lCount  = 0;
            arrCallInfo temp =
               (arrCallInfo )pLVACS->arrCallInfomation;

            fprintf( fp, "Num of instances:%d\n",
                              temp.numInstances );
            for(lCount = 0; lCount < temp.numInstances; lCount++)
            {
                fprintf( fp, "Call Identifier:%d\n",
                    temp.getAllCallInfo[lCount].Callinfo.callID);
                fprintf( fp, "Call State:%d\n",
                    temp.getAllCallInfo[lCount].Callinfo.callState);
                fprintf( fp, "Call Type:%d\n",
                    temp.getAllCallInfo[lCount].Callinfo.callType);
                fprintf( fp, "Direction:%d\n",
                    temp.getAllCallInfo[lCount].Callinfo.direction);
                fprintf( fp, "Mode:%d\n",
                    temp.getAllCallInfo[lCount].Callinfo.mode);
            }
        }

        if( pLVACS->pArrRemotePartyNum )
        {
             fprintf( fp, "\nRemote Party Number:\n" );
             {
                 int lCount = 0;
                 arrRemotePartyNum *pTemp =
                    (arrRemotePartyNum * )pLVACS->pArrRemotePartyNum;
                 fprintf( fp, "Num Of Instances :%d\n",
                               pTemp->numInstances );

                 for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                 {
                     int lLcount = 0;
                     fprintf( fp, "Call Identifier:%d\n",
                          pTemp->RmtPtyNum[lCount].callID);

                     fprintf( fp, "Presentation Indicator:%d\n",
                         pTemp->RmtPtyNum[lCount].RemotePartyNum.presentationInd);

                     fprintf( fp, "Number Length:%d\n",
                         pTemp->RmtPtyNum[lCount].RemotePartyNum.numLen);

                     fprintf( fp, "Number:" );
                     for( lLcount = 0; lLcount < pTemp->RmtPtyNum[lCount].
                                              RemotePartyNum.numLen; lLcount++ )
                     {
                         fprintf( fp, "%c",pTemp->RmtPtyNum[lCount].
                                      RemotePartyNum.remPartyNumber[lLcount]);
                     }
                 }
             }
             fprintf( fp, "\n");
        }

        if ( pLVACS->pArrRemotePartyName )
        {
            fprintf( fp, "\nRemote Party Name:\n" );
            {
                int lCount = 0;
                arrRemotePartyName *pTemp =
                   (arrRemotePartyName * )pLVACS->pArrRemotePartyName;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                       pTemp->GetAllCallRmtPtyName[lCount].callID);

                    fprintf( fp, "Presentation Indicator :%d\n",
                                 pTemp->GetAllCallRmtPtyName[lCount].
                                        RemotePartyName.namePI);

                    fprintf( fp, "Coding Scheme:%d\n",
                       pTemp->GetAllCallRmtPtyName[lCount].
                              RemotePartyName.codingScheme);

                    fprintf( fp, "Number Length:%d\n",
                       pTemp->GetAllCallRmtPtyName[lCount].
                              RemotePartyName.nameLen);

                    fprintf( fp, "Caller Name:\n");
                    for( lLcount = 0; lLcount <
                                      pTemp->GetAllCallRmtPtyName[lCount].
                                      RemotePartyName.nameLen; lLcount++ )
                    {
                        fprintf( fp, "%c",
                                     pTemp->GetAllCallRmtPtyName[lCount].
                                     RemotePartyName.callerName[lLcount]);
                    }
                }
            }
            fprintf( fp, "\n");
        }

        if ( pLVACS->pArrAlertingType )
        {
            fprintf( fp, "\nAlerting Type:\n" );
            {
                int lCount = 0;
                arrAlertingType *pTemp =
                   (arrAlertingType* )pLVACS->pArrAlertingType;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->callID[lCount]);

                    fprintf( fp, "Alerting type :%d\n",
                        pTemp->AlertingType[lCount]);

                }
            }
        }
        if ( pLVACS->pArrSvcOption )
        {
            fprintf( fp, "\nService Option:\n" );
            {
                int lCount = 0;
                arrSvcOption *pTemp =
                   (arrSvcOption* )pLVACS->pArrSvcOption;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->callID[lCount]);

                    fprintf( fp, "Service Option:%d\n",
                        pTemp->srvOption[lCount]);
                }
            }
        }
        if ( pLVACS->pArrCallEndReason )
        {
            fprintf( fp, "\nCall End Reason:\n" );
            {
                int lCount = 0;
                arrCallEndReason *pTemp =
                   (arrCallEndReason* )pLVACS->pArrCallEndReason;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->callID[lCount]);

                    fprintf( fp, "Service Option:%d\n",
                        pTemp->callEndReason[lCount]);
                }
            }
        }
        if ( pLVACS->pArrAlphaID )
        {
            fprintf( fp, "\nAlpha Identifier:\n" );
            {
                int lCount = 0;
                arrAlphaID *pTemp =
                   (arrAlphaID* )pLVACS->pArrAlphaID;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                      pTemp->allCallsAlphaIDInfoArr[lCount].callID);

                    fprintf( fp, "Alpha DCS:%d\n",
                      pTemp->allCallsAlphaIDInfoArr[lCount].AlphaIDInfo.alphaDcs);

                    fprintf( fp, "Alpha Lenth:%d\n",
                      pTemp->allCallsAlphaIDInfoArr[lCount].AlphaIDInfo.alphaLen);

                    fprintf( fp, "Call Identifier:\n");
                    for(lLcount = 0; lLcount <
                                     pTemp->allCallsAlphaIDInfoArr[lCount].
                                     AlphaIDInfo.alphaLen; lLcount++ )
                    {
                        fprintf( fp, "%d",
                        pTemp->allCallsAlphaIDInfoArr[lCount].
                               AlphaIDInfo.alphaText[lLcount]);
                    }
                }
            }
            fprintf( fp, "\n");
        }
        if ( pLVACS->pArrConnectPartyNum )
        {
            fprintf( fp, "\nConnected Party Number:\n" );
            {
                int lCount = 0;
                arrConnectPartyNum *pTemp =
                   (arrConnectPartyNum* )pLVACS->pArrConnectPartyNum;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->ConnectedPartyNum[lCount].callID);

                    fprintf( fp, "Presentation indicator:%d\n",
                        pTemp->ConnectedPartyNum[lCount].numPI);

                    fprintf( fp, "screening indicator:%d\n",
                        pTemp->ConnectedPartyNum[lCount].numSI);

                    fprintf( fp, "Connected number type:%d\n",
                        pTemp->ConnectedPartyNum[lCount].numType);

                    fprintf( fp, "Connected number plan:%d\n",
                        pTemp->ConnectedPartyNum[lCount].numPlan);

                    fprintf( fp, "Connected Length:%d\n",
                        pTemp->ConnectedPartyNum[lCount].numLen);

                    fprintf( fp, "Connected Number:");
                    for(lLcount = 0; lLcount < pTemp->ConnectedPartyNum[lCount]
                                               .numLen; lLcount++)
                    {
                        fprintf( fp, "%d",
                           pTemp->ConnectedPartyNum[lCount].number[lLcount]);
                    }
                }
            }
            fprintf( fp, "\n");
        }

        if ( pLVACS->pArrDiagInfo )
        {
            fprintf( fp, "\nDiagnostic Information:\n" );
            {
                int lCount = 0;
                arrDiagInfo *pTemp =
                   (arrDiagInfo* )pLVACS->pArrDiagInfo;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->DiagInfo[lCount].callID);

                    fprintf( fp, "Diagnostic Info Length:%d\n",
                        pTemp->DiagInfo[lCount].DiagInfo.diagInfoLen);

                    fprintf( fp, "Diagnostic Information:");
                    for(lLcount = 0; lLcount < pTemp->DiagInfo[lCount].
                                               DiagInfo.diagInfoLen; lLcount++)
                    {
                        fprintf( fp, "%d",pTemp->DiagInfo[lCount].
                                     DiagInfo.diagnosticInfo[lLcount]);
                    }

                }
                fprintf( fp, "\n");
            }

            fprintf( fp, "\nCalled Party Number:\n" );
            {
                int lCount = 0;
                arrCalledPartyNum *pTemp =
                   (arrCalledPartyNum* )pLVACS->pArrCalledPartyNum;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->CalledPartyNum[lCount].callID);

                    fprintf( fp, "Presentation indicator.:%d\n",
                         pTemp->CalledPartyNum[lCount].numPI);

                    fprintf( fp, "Number screening indicator:%d\n",
                         pTemp->CalledPartyNum[lCount].numSI);

                    fprintf( fp, "Number Type:%d\n",
                         pTemp->CalledPartyNum[lCount].numType);

                    fprintf( fp, "Number Plan:%d\n",
                         pTemp->CalledPartyNum[lCount].numPlan);

                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->CalledPartyNum[lCount].numLen);

                    fprintf( fp, "Connected Number:");
                    for(lLcount = 0; lLcount < pTemp->CalledPartyNum[lCount].
                                               numLen; lLcount++)
                    {
                        fprintf( fp, "%d",
                          pTemp->CalledPartyNum[lCount].number[lLcount]);
                    }

                }
            }
            fprintf( fp, "\n");
        }

        if ( pLVACS->pArrRedirPartyNum )
        {
            fprintf( fp, "\nRedirecting Party Number:\n" );
            {
                int lCount = 0;
                arrRedirPartyNum *pTemp =
                   (arrRedirPartyNum* )pLVACS->pArrRedirPartyNum;
                    fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    int lLcount = 0;
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->RedirPartyNum[lCount].callID);

                    fprintf( fp, "Presentation indicator.:%d\n",
                         pTemp->RedirPartyNum[lCount].numPI);

                    fprintf( fp, "Number screening indicator:%d\n",
                         pTemp->RedirPartyNum[lCount].numSI);

                    fprintf( fp, "Number type:%d\n",
                         pTemp->RedirPartyNum[lCount].numType);

                    fprintf( fp, "Number plan:%d\n",
                         pTemp->RedirPartyNum[lCount].numPlan);

                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->RedirPartyNum[lCount].numLen);

                    fprintf( fp, "Connected Number");
                    for(lLcount = 0; lLcount < pTemp->RedirPartyNum[lCount].
                                               numLen; lLcount++)
                    {
                        fprintf( fp, "%d",
                          pTemp->RedirPartyNum[lCount].number[lLcount]);
                    }
                }
            }
            fprintf( fp, "\n");
        }

        if ( pLVACS->pArrAlertingPattern )
        {

            fprintf( fp, "Alerting Pattern:\n" );
            {
                int lCount = 0;
                arrAlertingPattern *pTemp =
                   (arrAlertingPattern* )pLVACS->pArrAlertingPattern;
                fprintf( fp, "Num of instances :%d\n", pTemp->numInstances );

                for(lCount = 0; lCount < pTemp->numInstances; lCount++)
                {
                    fprintf( fp, "Call Identifier:%d\n",
                         pTemp->callID[lCount]);

                    fprintf( fp, "Service Option:%d\n",
                        pTemp->alertingPattern[lCount]);
                }
            }
        }
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSVoiceSetAllCallStatusCallback
 *
 * Purpose: SLQSVoiceSetAllCallStatusCallback API test function
 *
 **************/
package void doSetSLQSVoiceSetAllCallStatusCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetAllCallStatusCallBack( &cbkTestSLQSVoiceSetAllCallStatusCB );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSLQSVoiceSetAllCallStatusCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSVoiceSetAllCallStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceSetAllCallStatusCallback
 *
 * Purpose: Clear the SLQSVoiceSetAllCallStatusCallback API
 *
 **************/
package void doClearSLQSVoiceSetAllCallStatusCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetAllCallStatusCallBack( NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSVoiceSetAllCallStatusCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "SLQSVoiceSetAllCallStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetTransLayerInfoCallback
 *
 * Purpose: SLQSSetTransLayerInfoCallback API callback function
 *
 **************/
local void cbkTestSLQSSetTransLayerInfoCallback(
    transLayerNotification *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetTransLayerInfoCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetTransLayerInfoCallback");
    else
    {
        fprintf( fp, "Registration Indication 0x%x \n",
                 pInfo->regInd );

        if( pInfo->pTransLayerInfo )
        {
            transLayerInfo Temp = *(pInfo->pTransLayerInfo);
            fprintf( fp, "Transport Layer Information:\n" );
            fprintf( fp, "Transport Type: 0x%x\n", Temp.TransType );
            fprintf( fp, "Transport Capabilities 0x%x\n", Temp.TransCap );
        }
        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetTransLayerInfoCallback
 *
 * Purpose: SLQSSetTransLayerInfoCallback test function
 *
 **************/
package void doSLQSSetTransLayerInfoCallback( void )
{
    ULONG rc;
    rc = SLQSSetTransLayerInfoCallback( &cbkTestSLQSSetTransLayerInfoCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetTransLayerInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSetTransLayerInfoCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetTransLayerInfoCallback
 *
 * Purpose: Clear the doSLQSSetTransLayerInfoCallback API
 *
 **************/
package void doClearSLQSSetTransLayerInfoCallback( void )
{
    ULONG rc;

    rc = SLQSSetTransLayerInfoCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetTransLayerInfoCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetTransLayerInfoCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetTransNWRegInfoCallback
 *
 * Purpose: SLQSSetTransNWRegInfoCallback API callback function
 *
 **************/
local void cbkTestSLQSSetTransNWRegInfoCallback(
    transNWRegInfoNotification *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetTransNWRegInfoCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetTransNWRegInfoCallback");
    else
    {
        fprintf( fp, "Network Registration Status 0x%x \n",
                 pInfo->NWRegStat );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetTransNWRegInfoCallback
 *
 * Purpose: SLQSSetTransNWRegInfoCallback test function
 *
 **************/
package void doSLQSSetTransNWRegInfoCallback( void )
{
    ULONG rc;
    rc = SLQSSetTransNWRegInfoCallback( &cbkTestSLQSSetTransNWRegInfoCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetTransNWRegInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSetTransNWRegInfoCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetTransNWRegInfoCallback
 *
 * Purpose: Clear the doSLQSSetTransNWRegInfoCallback API
 *
 **************/
package void doClearSLQSSetTransNWRegInfoCallback( void )
{
    ULONG rc;

    rc = SLQSSetTransNWRegInfoCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetTransNWRegInfoCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetTransNWRegInfoCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetSysSelectionPrefCallBack
 *
 * Purpose: SLQSSetSysSelectionPrefCallBack API callback function
 *
 **************/
local void cbkTestSLQSSetSysSelectionPrefCallBack(
    sysSelectPrefInfo *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetSysSelectionPrefCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetSysSelectionPrefCallBack");
    else
    {
        fprintf( fp, "System Selection Preferences \n" );

        if( pInfo->pEmerMode )
        {
            fprintf( fp, "Emergency Mode: 0x%x\n", *(pInfo->pEmerMode) );
        }

        if( pInfo->pModePref)
        {
            fprintf( fp, "Mode Preference: 0x%x\n", *(pInfo->pModePref) );
        }

        if( pInfo->pBandPref)
        {
            fprintf( fp, "Band Preference: 0x%llx\n", *(pInfo->pBandPref) );
        }

        if( pInfo->pPRLPref)
        {
            fprintf( fp, "CDMA PRL Preference: 0x%x\n", *(pInfo->pPRLPref) );
        }

        if( pInfo->pRoamPref)
        {
            fprintf( fp, "Roaming Preference: 0x%x\n", *(pInfo->pRoamPref) );
        }

        if( pInfo->pLTEBandPref)
        {
            fprintf( fp, "LTE Band Preference: 0x%llx\n",
                    *(pInfo->pLTEBandPref) );
        }

        if( pInfo->pNetSelPref)
        {
            fprintf( fp, "Network Selection Preference: 0x%x\n",
                    *(pInfo->pNetSelPref) );
        }

        if( pInfo->pSrvDomainPref)
        {
            fprintf( fp, "Service Domain Preference: 0x%x\n",
                    *(pInfo->pSrvDomainPref) );
        }

        if( pInfo->pGWAcqOrderPref)
        {
            fprintf( fp, "GSM/WCDMA Acquisition order Preference: 0x%x\n",
                    *(pInfo->pGWAcqOrderPref) );
        }
        fprintf( fp, "\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetSysSelectionPrefCallBack
 *
 * Purpose: SLQSSetSysSelectionPrefCallBack test function
 *
 **************/
package void doSLQSSetSysSelectionPrefCallBack( void )
{
    ULONG rc;
    rc = SLQSSetSysSelectionPrefCallBack(&cbkTestSLQSSetSysSelectionPrefCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetSysSelectionPrefCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSetSysSelectionPrefCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSysSelectionPrefCallBack
 *
 * Purpose: Clear the doSLQSSetSysSelectionPrefCallBack API
 *
 **************/
package void doClearSLQSSetSysSelectionPrefCallBack( void )
{
    ULONG rc;

    rc = SLQSSetSysSelectionPrefCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetSysSelectionPrefCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetSysSelectionPrefCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSUIMSetRefreshCallBack
 *
 * Purpose: SLQSUIMSetRefreshCallBack API callback function
 *
 **************/
local void cbkTestSLQSUIMSetRefreshCallBack(
     UIMRefreshEvent *pUIMRefreshEvent )
{
    FILE *fp;
    BYTE lCount,lIcount;
    fp = tfopen("../../cbk/test/results/SLQSUIMSetRefreshCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSUIMSetRefreshCallBack");
    else
    {
        fprintf( fp, "\nUIM refresh event\n" );

        fprintf( fp, "Refresh Stage: %d\n", pUIMRefreshEvent->stage );
        fprintf( fp, "Refresh Mode : %d\n", pUIMRefreshEvent->mode );
        fprintf( fp, "Session Type : %d\n", pUIMRefreshEvent->sessionType );
        fprintf( fp, "aid Length   : %d\n", pUIMRefreshEvent->aidLength );

        fprintf( fp, "AID :" );
        for( lCount = 0; lCount < pUIMRefreshEvent->aidLength; lCount++ )
        {
            fprintf( fp, "%d", pUIMRefreshEvent->aid[lCount] );
        }
        fprintf( fp, "\n");

        fprintf( fp, "Number of files : %d\n", pUIMRefreshEvent->numOfFiles );

        for ( lCount = 0; lCount < pUIMRefreshEvent->numOfFiles; lCount++ )
        {
            fileInfo *pTmp = &pUIMRefreshEvent->arrfileInfo[lCount];
            fprintf( fp, "File ID : %x\n", pTmp->fileID );
            fprintf( fp, "pathLen : %d\n", pTmp->pathLen );

            fprintf( fp, "Path :" );
            for( lIcount = 0; lIcount < pTmp->pathLen; lIcount++ )
            {
                fprintf( fp, "%x", pTmp->path[lIcount] );
            }
            fprintf( fp, "\n");
        }
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSUIMSetRefreshCallBack
 *
 * Purpose: SLQSUIMSetRefreshCallBack test function
 *
 **************/
package void doSLQSUIMSetRefreshCallBack( void )
{
    ULONG rc;
    rc = SLQSUIMSetRefreshCallBack(&cbkTestSLQSUIMSetRefreshCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSUIMSetRefreshCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSUIMSetRefreshCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSUIMSetRefreshCallBack
 *
 * Purpose: Clear the SLQSUIMSetRefreshCallBack API
 *
 **************/
package void doClearSLQSUIMSetRefreshCallBack( void )
{
    ULONG rc;

    rc = SLQSUIMSetRefreshCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSUIMSetRefreshCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSUIMSetRefreshCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSUIMSetStatusChangeCallBack
 *
 * Purpose: SLQSUIMSetStatusChangeCallBack API callback function
 *
 **************/
local void cbkTestSLQSUIMSetStatusChangeCallBack(
    UIMStatusChangeInfo *pUIMStatusChangeInfo )
{
    FILE *fp;
    WORD lcount,lIcount,lIcount1;
    fp = tfopen("../../cbk/test/results/SLQSUIMSetStatusChangeCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSUIMSetStatusChangeCallBack");
    else
    {
        cardStatus *lpCardStatus = &pUIMStatusChangeInfo->statusChange;
        fprintf(fp, "\nSLQSUIMSetStatusChangeCallBack Successful\n");
        fprintf(fp, "---------------------.----------------------\n");
        if ( NULL != lpCardStatus )
        {
            fprintf(fp, "Index of the primary GW   : %x\n", lpCardStatus->indexGwPri);
            fprintf(fp, "Index of the primary 1X   : %x\n", lpCardStatus->index1xPri);
            fprintf(fp, "Index of the secondary GW : %x\n", lpCardStatus->indexGwSec);
            fprintf(fp, "Index of the secondary 1X : %x\n", lpCardStatus->index1xSec);
            fprintf(fp, "Slots Available           : %x\n", lpCardStatus->numSlot);
            for ( lcount=0 ; lcount < lpCardStatus->numSlot; lcount++ )
            {
                slotInfo *temp = &lpCardStatus->SlotInfo[lcount];
                fprintf(fp, "\tInformation for SLOT%d\n ",lcount+1);
                fprintf(fp, "\tState of the Card         : %x\n", temp->cardState);
                fprintf(fp, "\tState of the UPIN         : %x\n", temp->upinState);
                fprintf(fp, "\tRetries Remaining(UPIN)   : %d\n", temp->upinRetries);
                fprintf(fp, "\tRetries Remaining(UPUK)   : %d\n", temp->upukRetries);
                fprintf(fp, "\tReason For Error          : %x\n", temp->errorState);
                fprintf(fp, "\tNo. of Apps Allowed       : %d\n", temp->numApp);
                for ( lIcount=0 ; lIcount < temp->numApp; lIcount++ )
                {
                    appStatus *lresp = &temp->AppStatus[lIcount];
                    fprintf(fp, "\t\tApplication Status Information for App%d\n ",lIcount+1);
                    fprintf(fp, "\t\tType of Application       : %x\n", lresp->appType);
                    fprintf(fp, "\t\tState of Application      : %x\n", lresp->appState);
                    fprintf(fp, "\t\tState of perso for App    : %x\n", lresp->persoState);
                    fprintf(fp, "\t\tIndicates perso feature   : %x\n", lresp->persoFeature);
                    fprintf(fp, "\t\tRetries Remaining(Perso BL): %d\n",
                                         lresp->persoRetries);
                    fprintf(fp, "\t\tRetries Remaining(Perso UB): %d\n",
                                         lresp->persoUnblockRetries);
                    fprintf(fp, "\t\tApplication Identifier Len: %d\n", lresp->aidLength);
                    fprintf(fp, "\t\tApplication Identifier Value : ");
                    for ( lIcount1=0 ; lIcount1 < lresp->aidLength; lIcount1++ )
                    {
                        fprintf(fp, "%x ", lresp->aidVal[lIcount1]);
                    }
                    fprintf(fp,"\n");
                    fprintf(fp, "\t\tIndication for UPIN       : %x\n", lresp->univPin);
                    fprintf(fp, "\t\tIndicates State of Pin1   : %x\n", lresp->pin1State);
                    fprintf(fp, "\t\tRetries Remaining(PIN1)   : %d\n", lresp->pin1Retries);
                    fprintf(fp, "\t\tRetries Remaining(PUK1)   : %d\n", lresp->puk1Retries);
                    fprintf(fp, "\t\tIndicates State of Pin2   : %x\n", lresp->pin2State);
                    fprintf(fp, "\t\tRetries Remaining(PIN2)   : %d\n", lresp->pin2Retries);
                    fprintf(fp, "\t\tRetries Remaining(PUK2)   : %d\n", lresp->puk2Retries);
                }
            }
        }
        fprintf(fp, "--------------------xxx---------------------\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSUIMSetStatusChangeCallBack
 *
 * Purpose: SLQSUIMSetStatusChangeCallBack test function
 *
 **************/
package void doSLQSUIMSetStatusChangeCallBack( void )
{
    ULONG rc;
    rc = SLQSUIMSetStatusChangeCallBack(&cbkTestSLQSUIMSetStatusChangeCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSUIMSetStatusChangeCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSUIMSetStatusChangeCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSUIMSetStatusChangeCallBack
 *
 * Purpose: Clear the SLQSUIMSetStatusChangeCallBack API
 *
 **************/
package void doClearSLQSUIMSetStatusChangeCallBack( void )
{
    ULONG rc;

    rc = SLQSUIMSetStatusChangeCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSUIMSetStatusChangeCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSUIMSetStatusChangeCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetPrivacyChangeCallback
 *
 * Purpose: SLQSVoiceSetPrivacyChangeCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetPrivacyChangeCallback(
    voicePrivacyInfo *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSVoiceSetPrivacyChangeCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetPrivacyChangeCallback");
    else
    {
        fprintf( fp, "Privacy Change: Call ID: %x :: Voice Privacy : %x \n",
                 pInfo->callID, pInfo->voicePrivacy );

        fprintf( fp, "\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSVoiceSetPrivacyChangeCallback
 *
 * Purpose: SLQSVoiceSetPrivacyChangeCallback test function
 *
 **************/
package void doSetSLQSVoiceSetPrivacyChangeCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceSetPrivacyChangeCallBack(&cbkTestSLQSVoiceSetPrivacyChangeCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSVoiceSetPrivacyChangeCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSVoiceSetPrivacyChangeCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceSetPrivacyChangeCallback
 *
 * Purpose: Clear the doSLQSVoiceSetPrivacyChangeCallback API
 *
 **************/
package void doClearSLQSVoiceSetPrivacyChangeCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetPrivacyChangeCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSVoiceSetPrivacyChangeCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSVoiceSetPrivacyChangeCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetDTMFEventCallback
 *
 * Purpose: SLQSVoiceSetDTMFEventCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetDTMFEventCallback(
    voiceDTMFEventInfo *pInfo )
{
    FILE *fp;
    WORD lcount;
    fp = tfopen("../../cbk/test/results/SLQSVoiceSetDTMFEventCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetDTMFEventCallback");
    else
    {
        DTMFInfo *lTemp = &(pInfo->DTMFInformation);
        fprintf( fp, "Voice DTMF EVent Info ");
        fprintf( fp, "Call ID      : %x \n", lTemp->callID);
        fprintf( fp, "DTMF Event   : %x \n", lTemp->DTMFEvent);
        fprintf( fp, "No.of Digits : %d \n", lTemp->digitCnt);
        fprintf( fp, "Digit Values : ");
        for ( lcount = 0 ; lcount < lTemp->digitCnt ; lcount++ )
        {
            fprintf( fp, "%c", lTemp->digitBuff[lcount]);
           }
        fprintf( fp, "\n");
        IFPRINTF( fp, "On Length   : %d\n",pInfo->pOnLength);
        IFPRINTF( fp, "Off Length  : %d\n",pInfo->pOffLength);
        fprintf( fp, "\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSVoiceSetDTMFEventCallback
 *
 * Purpose: SLQSVoiceSetDTMFEventCallback test function
 *
 **************/
package void doSetSLQSVoiceSetDTMFEventCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceSetDTMFEventCallBack(&cbkTestSLQSVoiceSetDTMFEventCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSVoiceSetDTMFEventCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSVoiceSetDTMFEventCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceSetDTMFEventCallback
 *
 * Purpose: Clear the doSLQSVoiceSetDTMFEventCallback API
 *
 **************/
package void doClearSLQSVoiceSetDTMFEventCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetDTMFEventCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSVoiceSetDTMFEventCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSVoiceSetDTMFEventCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetSUPSCallback
 *
 * Purpose: SLQSVoiceSetSUPSCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetSUPSCallback(
    voiceSUPSInfo *pInfo )
{
    FILE *fp;
    WORD lcount,lIcount;
    fp = tfopen("../../cbk/test/results/SLQSVoiceSetSUPSCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetSUPSCallback");
    else
    {
        SUPSInfo *lTemp = &(pInfo->SUPSInformation);
        fprintf( fp, "Voice SUPS Info From SLQSVoiceSetSUPSCallback\n");
        fprintf( fp, "Service Type   : %x \n", lTemp->svcType);
        fprintf( fp, "Modified by CC : %x \n", lTemp->isModByCC);

        IFPRINTF( fp, "Service Class  : %x\n",pInfo->pSvcClass);
        IFPRINTF( fp, "Reason         : %x\n",pInfo->pReason);
        if ( NULL != pInfo->pCallFWNum )
        {
            fprintf( fp, "Call FW Number : ");
            for ( lcount = 0 ; pInfo->pCallFWNum[lcount] != EOS ; lcount++ )
            {
                fprintf( fp, "%x ", pInfo->pCallFWNum[lcount]);
               }
            fprintf( fp, "\n");
        }
        IFPRINTF( fp, "Call FW No Reply Timer: %d\n",pInfo->pCallFWTimerVal);
        if ( NULL != pInfo->pUSSInfo )
        {
            fprintf( fp, "USS DCS        : %x \n", pInfo->pUSSInfo->ussDCS);
            fprintf( fp, "USS Length     : %d \n", pInfo->pUSSInfo->ussLen);
            fprintf( fp, "USS Data       : ");
            for ( lcount = 0 ; lcount < pInfo->pUSSInfo->ussLen ; lcount++ )
            {
                fprintf( fp, "%c", pInfo->pUSSInfo->ussData[lcount]);
            }
            fprintf( fp, "\n");
        }
        IFPRINTF( fp, "Call Id        : %x\n",pInfo->pCallID);
        if ( NULL != pInfo->pAlphaIDInfo )
        {
            alphaIDInfo *pAlphaIDInfo = pInfo->pAlphaIDInfo;
            fprintf( fp, "Alpha DCS       : %x \n", pAlphaIDInfo->alphaDcs);
            fprintf( fp, "Alpha Len       : %d \n", pAlphaIDInfo->alphaLen);
            fprintf( fp, "Alpha Text      : ");
            for (lcount = 0;lcount < pAlphaIDInfo->alphaLen;lcount++)
            {
                fprintf( fp, "%c", pAlphaIDInfo->alphaText[lcount]);
            }
            fprintf( fp,"\n");
        }
        if ( NULL != pInfo->pCallBarPasswd )
        {
            fprintf( fp, "Call Bar Password : ");
            for ( lcount = 0 ; lcount < PASSWORD_LENGTH ; lcount++ )
            {
                fprintf( fp, "%c", pInfo->pCallBarPasswd[lcount]);
               }
            fprintf( fp, "\n");
        }
        if ( NULL != pInfo->pNewPwdData )
        {
            newPwdData *pNewPwdData = pInfo->pNewPwdData;
            fprintf( fp, "New Password      : ");
            for ( lcount = 0 ; lcount < PASSWORD_LENGTH ; lcount++ )
            {
                fprintf( fp, "%c", pNewPwdData->newPwd[lcount]);
               }
            fprintf( fp, "\n");
            fprintf( fp, "New Password Again : ");
            for ( lcount = 0 ; lcount < PASSWORD_LENGTH ; lcount++ )
            {
                fprintf( fp, "%c", pNewPwdData->newPwdAgain[lcount]);
               }
            fprintf( fp, "\n");
        }
        IFPRINTF( fp, "Data Source      : %x\n",pInfo->pDataSrc);
        IFPRINTF( fp, "Failure Cause    : %x\n",pInfo->pFailCause);
        if ( NULL != pInfo->pCallFwdInfo )
        {
            fprintf(fp, "Instances of Call Forwarding Info : %x\n",
            pInfo->pCallFwdInfo->numInstances);
            for ( lcount = 0;lcount<pInfo->pCallFwdInfo->numInstances;lcount++)
            {
                callFWInfo *temp = &pInfo->pCallFwdInfo->CallFWInfo[lcount];
                fprintf(fp, "\tService Status   : %x \n",temp->SvcStatus);
                fprintf(fp, "\tService Class    : %x \n",temp->SvcClass);
                fprintf(fp, "\tNum Len          : %x \n",temp->numLen);
                fprintf(fp, "\tNumber           : ");
                for ( lIcount=0; lIcount<temp->numLen ;lIcount++ )
                {
                    fprintf(fp,"%c",temp->number[lIcount]);
                }
                fprintf(fp,"\n");
                fprintf(fp, "\tNo Reply Timer   : %x \n",temp->noReplyTimer);
            }
        }
        if ( NULL != pInfo->pCLIRstatus )
        {
            CLIRResp *pCLIRResp = pInfo->pCLIRstatus;
            fprintf( fp, "Activation Status : %x \n", pCLIRResp->ActiveStatus);
            fprintf( fp, "Provisioned Status: %x \n", pCLIRResp->ProvisionStatus);
        }
        if ( NULL != pInfo->pCLIPstatus )
        {
            CLIPResp *pCLIPResp = pInfo->pCLIPstatus;
            fprintf( fp, "Activation Status : %x \n", pCLIPResp->ActiveStatus);
            fprintf( fp, "Provisioned Status: %x \n", pCLIPResp->ProvisionStatus);
        }
        if ( NULL != pInfo->pCOLPstatus )
        {
            COLPResp *pCOLPResp = pInfo->pCOLPstatus;
            fprintf( fp, "Activation Status : %x \n", pCOLPResp->ActiveStatus);
            fprintf( fp, "Provisioned Status: %x \n", pCOLPResp->ProvisionStatus);
        }
        if ( NULL != pInfo->pCOLRstatus )
        {
            COLRResp *pCOLRResp = pInfo->pCOLRstatus;
            fprintf( fp, "Activation Status : %x \n", pCOLRResp->ActiveStatus);
            fprintf( fp, "Provisioned Status: %x \n", pCOLRResp->ProvisionStatus);
        }
        if ( NULL != pInfo->pCNAPstatus )
        {
            CNAPResp *pCNAPResp = pInfo->pCNAPstatus;
            fprintf( fp, "Activation Status : %x \n", pCNAPResp->ActiveStatus);
            fprintf( fp, "Provisioned Status: %x \n", pCNAPResp->ProvisionStatus);
        }
        fprintf( fp, "\n--------\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSVoiceSetSUPSCallback
 *
 * Purpose: SLQSVoiceSetSUPSCallback test function
 *
 **************/
package void doSetSLQSVoiceSetSUPSCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceSetSUPSCallBack(&cbkTestSLQSVoiceSetSUPSCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSVoiceSetSUPSCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSVoiceSetSUPSCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceSetSUPSCallback
 *
 * Purpose: Clear the doSLQSVoiceSetSUPSCallback API
 *
 **************/
package void doClearSLQSVoiceSetSUPSCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetSUPSCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSVoiceSetSUPSCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSVoiceSetSUPSCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSNasSysInfoCallBack
 *
 * Purpose: SLQSNasSysInfoCallBack API callback function
 *
 **************/
local void cbkTestSLQSNasSysInfoCallBack(
    nasSysInfo *pInfo )
{
    FILE *fp;
    WORD lC;
    fp = tfopen("../../cbk/test/results/SLQSNasSysInfoCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSNasSysInfoCallBack");
    else
    {
        fprintf( fp, "\n------------------------.------------------------\n\n");
        fprintf( fp, "NAS System Information From SLQSNasSysInfoCallBack\n");
        if ( pInfo->pCDMASrvStatusInfo )
        {
            fprintf( fp,"Service Status(CDMA) : %x\n",pInfo->pCDMASrvStatusInfo->srvStatus );
            fprintf( fp,"Is Preferred(CDMA)   : %x\n",pInfo->pCDMASrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pHDRSrvStatusInfo )
        {
            fprintf( fp,"Service Status(HDR) : %x\n",pInfo->pHDRSrvStatusInfo->srvStatus );
            fprintf( fp,"Is Preferred(HDR)   : %x\n",pInfo->pHDRSrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pGSMSrvStatusInfo )
        {
            fprintf( fp,"Service Status(GSM)      : %x\n",pInfo->pGSMSrvStatusInfo->srvStatus );
            fprintf( fp,"True Service Status(GSM) : %x\n",pInfo->pGSMSrvStatusInfo->trueSrvStatus );
            fprintf( fp,"Is Preferred(GSM)        : %x\n",pInfo->pGSMSrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pWCDMASrvStatusInfo )
        {
            fprintf( fp,"Service Status(WCDMA)     : %x\n",pInfo->pWCDMASrvStatusInfo->srvStatus );
            fprintf( fp,"True Service Status(WCDMA): %x\n",pInfo->pWCDMASrvStatusInfo->trueSrvStatus );
            fprintf( fp,"Is Preferred(WCDMA)       : %x\n",pInfo->pWCDMASrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pLTESrvStatusInfo )
        {
            fprintf( fp,"Service Status(LTE)      : %x\n",pInfo->pLTESrvStatusInfo->srvStatus );
            fprintf( fp,"True Service Status(LTE) : %x\n",pInfo->pLTESrvStatusInfo->trueSrvStatus );
            fprintf( fp,"Is Preferred(LTE)        : %x\n",pInfo->pLTESrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pCDMASysInfo )
        {
            fprintf( fp,"\nCDMA SYSTEM INFORMATION ----\n");
            CDMASysInfo *t = pInfo->pCDMASysInfo;
            doprintsysInfoCommonCB( fp, &t->sysInfoCDMA );
            fprintf( fp,"System PRL Valid    : %x\n",t->isSysPrlMatchValid );
            fprintf( fp,"System PRL          : %x\n",t->isSysPrlMatch );
            fprintf( fp,"P_Rev Valid         : %x\n",t->pRevInUseValid );
            fprintf( fp,"P_Rev In Use        : %x\n",t->pRevInUse );
            fprintf( fp,"BS P_Rev Valid      : %x\n",t->bsPRevValid );
            fprintf( fp,"P_Rev In Use        : %x\n",t->bsPRev );
            fprintf( fp,"CCS_supp Valid      : %x\n",t->ccsSupportedValid );
            fprintf( fp,"CCS_supp            : %x\n",t->ccsSupported );
            fprintf( fp,"System Id           : %x\n",t->systemID );
            fprintf( fp,"Network Id          : %x\n",t->networkID );
            fprintf( fp,"BS Info Valid       : %x\n",t->bsInfoValid );
            fprintf( fp,"Base ID             : %x\n",t->baseId );
            fprintf( fp,"Base Latitude       : %x\n",t->baseLat );
            fprintf( fp,"Base Longitude      : %x\n",t->baseLong );
            fprintf( fp,"Packet Zone Valid   : %x\n",t->packetZoneValid );
            fprintf( fp,"Packet Zone         : %x\n",t->packetZone );
            fprintf( fp,"Network ID Valid    : %x\n",t->networkIdValid );
            fprintf( fp,"MCC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MCC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"MNC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MNC[lC] );
            }
            fprintf( fp,"\n" );
        }

        if ( pInfo->pHDRSysInfo )
        {
            fprintf( fp,"\nHDR SYSTEM INFORMATION ----\n");
            HDRSysInfo *t = pInfo->pHDRSysInfo;
            doprintsysInfoCommonCB( fp, &t->sysInfoHDR );
            fprintf( fp,"System PRL Valid    : %x\n",t->isSysPrlMatchValid );
            fprintf( fp,"System PRL          : %x\n",t->isSysPrlMatch );
            fprintf( fp,"Personality Valid   : %x\n",t->hdrPersonalityValid );
            fprintf( fp,"Personality         : %x\n",t->hdrPersonality );
            fprintf( fp,"Active Prot Valid   : %x\n",t->hdrActiveProtValid );
            fprintf( fp,"Active Protocol     : %x\n",t->hdrActiveProt );
            fprintf( fp,"IS-856 Sys Valid    : %x\n",t->is856SysIdValid );
            fprintf( fp,"IS-856 system ID    : " );
            for ( lC = 0 ; lC < SLQS_SYSTEM_ID_SIZE ; lC++ )
            {
                fprintf( fp,"%x ",t->is856SysId[lC] );
            }
            fprintf( fp,"\n" );
        }
        if ( pInfo->pGSMSysInfo )
        {
            fprintf( fp,"\nGSM SYSTEM INFORMATION ----\n");
            GSMSysInfo *t = pInfo->pGSMSysInfo;
            doprintsysInfoCommonCB( fp, &t->sysInfoGSM );
            fprintf( fp,"LAC Valid           : %x\n",t->lacValid );
            fprintf( fp,"LAC                 : %x\n",t->lac );
            fprintf( fp,"Cell ID Valid       : %x\n",t->cellIdValid );
            fprintf( fp,"Cell ID             : %x\n",t->cellId );
            fprintf( fp,"Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            fprintf( fp,"Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            fprintf( fp,"Reject Cause        : %x\n",t->rejCause );
            fprintf( fp,"Network Id Valid    : %x\n",t->networkIdValid );
            fprintf( fp,"MCC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MCC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"MNC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MNC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"EGPRS Support Valid : %x\n",t->egprsSuppValid );
            fprintf( fp,"EGPRS Support       : %x\n",t->egprsSupp );
            fprintf( fp,"DTM Support Valid   : %x\n",t->dtmSuppValid );
            fprintf( fp,"DTM Support         : %x\n",t->dtmSupp );
        }
        if ( pInfo->pWCDMASysInfo )
        {
            fprintf( fp,"\nWCDMA SYSTEM INFORMATION ----\n");
            WCDMASysInfo *t = pInfo->pWCDMASysInfo;
            doprintsysInfoCommonCB( fp, &t->sysInfoWCDMA );
            fprintf( fp,"LAC Valid           : %x\n",t->lacValid );
            fprintf( fp,"LAC                 : %x\n",t->lac );
            fprintf( fp,"Cell ID Valid       : %x\n",t->cellIdValid );
            fprintf( fp,"Cell ID             : %x\n",t->cellId );
            fprintf( fp,"Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            fprintf( fp,"Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            fprintf( fp,"Reject Cause        : %x\n",t->rejCause );
            fprintf( fp,"Network Id Valid    : %x\n",t->networkIdValid );
            fprintf( fp,"MCC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MCC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"MNC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MNC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"HS Call Status Valid: %x\n",t->hsCallStatusValid );
            fprintf( fp,"HS Call Status      : %x\n",t->hsCallStatus );
            fprintf( fp,"HS Ind Valid        : %x\n",t->hsIndValid );
            fprintf( fp,"HS Indication       : %x\n",t->hsInd );
            fprintf( fp,"PSC Valid           : %x\n",t->pscValid );
            fprintf( fp,"Primary Scrambling Code : %x\n",t->psc );
        }
        if ( pInfo->pLTESysInfo )
        {
            fprintf( fp,"\nLTE SYSTEM INFORMATION ----\n");
            LTESysInfo *t = pInfo->pLTESysInfo;
            doprintsysInfoCommonCB( fp, &t->sysInfoLTE );
            fprintf( fp,"LAC Valid           : %x\n",t->lacValid );
            fprintf( fp,"LAC                 : %x\n",t->lac );
            fprintf( fp,"Cell ID Valid       : %x\n",t->cellIdValid );
            fprintf( fp,"Cell ID             : %x\n",t->cellId );
            fprintf( fp,"Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            fprintf( fp,"Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            fprintf( fp,"Reject Cause        : %x\n",t->rejCause );
            fprintf( fp,"Network Id Valid    : %x\n",t->networkIdValid );
            fprintf( fp,"MCC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MCC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"MNC info            : " );
            for ( lC = 0 ; lC < PLMN_LENGTH ; lC++ )
            {
                fprintf( fp,"%x ",t->MNC[lC] );
            }
            fprintf( fp,"\n" );
            fprintf( fp,"TAC Valid           : %x\n",t->tacValid );
            fprintf( fp,"Tracking Area Code  : %x\n",t->tac );
        }
        if ( pInfo->pAddCDMASysInfo )
        {
            fprintf( fp, "Geo Sys Idx(CDMA) : %x\n", pInfo->pAddCDMASysInfo->geoSysIdx );
            fprintf( fp, "Reg Period (CDMA) : %x\n", pInfo->pAddCDMASysInfo->regPrd );
        }
        IFPRINTF( fp, "Geo Sys Idx(HDR) : %x\n", pInfo->pAddHDRSysInfo );
        if ( pInfo->pAddGSMSysInfo )
        {
            fprintf( fp, "Geo Sys Idx(GSM) : %x\n", pInfo->pAddGSMSysInfo->geoSysIdx );
            fprintf( fp, "Cell Br Cap(GSM) : %x\n", pInfo->pAddGSMSysInfo->cellBroadcastCap );
        }
        if ( pInfo->pAddWCDMASysInfo )
        {
            fprintf( fp, "Geo Sys Idx(WCDMA) : %x\n", pInfo->pAddWCDMASysInfo->geoSysIdx );
            fprintf( fp, "Cell Br Cap(WCDMA) : %x\n", pInfo->pAddWCDMASysInfo->cellBroadcastCap );
        }
        IFPRINTF( fp, "Geo Sys Idx(LTE) : %x\n", pInfo->pAddLTESysInfo );
        if ( pInfo->pGSMCallBarringSysInfo )
        {
            fprintf( fp, "CS Bar Status(GSM): %x\n", pInfo->pGSMCallBarringSysInfo->csBarStatus );
            fprintf( fp, "PS Bar Status(GSM): %x\n", pInfo->pGSMCallBarringSysInfo->psBarStatus );
        }
        if ( pInfo->pWCDMACallBarringSysInfo )
        {
            fprintf( fp, "CS Bar Status(WCDMA): %x\n", pInfo->pWCDMACallBarringSysInfo->csBarStatus );
            fprintf( fp, "PS Bar Status(WCDMA): %x\n", pInfo->pWCDMACallBarringSysInfo->psBarStatus );
        }
        IFPRINTF( fp, "Voice Supp on LTE: %x\n", pInfo->pLTEVoiceSupportSysInfo );
        IFPRINTF( fp, "GSM Cipher Domain: %x\n", pInfo->pGSMCipherDomainSysInfo );
        IFPRINTF( fp, "WCDMA Cipher Domain: %x\n", pInfo->pWCDMACipherDomainSysInfo );
        IFPRINTF( fp, "System Info No Change Indication: %x\n", pInfo->pSysInfoNoChange );
        fprintf( fp, "\n-----------------------xxx-----------------------\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSNasSysInfoCallBack
 *
 * Purpose: SLQSNasSysInfoCallBack test function
 *
 **************/
package void doSetSLQSNasSysInfoCallBack( void )
{
    ULONG rc;
    rc = SLQSNasSysInfoCallBack(&cbkTestSLQSNasSysInfoCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasSysInfoCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasSysInfoCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSNasSysInfoCallBack
 *
 * Purpose: Clear the doSLQSNasSysInfoCallBack API
 *
 **************/
package void doClearSLQSNasSysInfoCallBack( void )
{
    ULONG rc;

    rc = SLQSNasSysInfoCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasSysInfoCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasSysInfoCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSNasNetworkTimeCallBack
 *
 * Purpose: SLQSNasNetworkTimeCallBack API callback function
 *
 **************/
local void cbkTestSLQSNasNetworkTimeCallBack(
    nasNetworkTime *pInfo )
{
    FILE *fp;
    fp = tfopen("../../cbk/test/results/SLQSNasNetworkTimeCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSNasNetworkTimeCallBack");
    else
    {
        fprintf( fp, "\n------------------------.------------------------\n\n");
        fprintf( fp, "NAS Network Time From SLQSNasNetworkTimeCallBack\n");
        fprintf( fp, "Universal Time \n");
        fprintf( fp, "Year        : %d\n", pInfo->universalTime.year);
        fprintf( fp, "Month       : %d\n", pInfo->universalTime.month);
        fprintf( fp, "Day         : %d\n", pInfo->universalTime.day);
        fprintf( fp, "Hours       : %d\n", pInfo->universalTime.hour);
        fprintf( fp, "Minutes     : %d\n", pInfo->universalTime.minute);
        fprintf( fp, "Seconds     : %d\n", pInfo->universalTime.second);
        fprintf( fp, "Day of Week : %d\n", pInfo->universalTime.dayOfWeek);

        IFPRINTF( fp, "Time Zone          : %x\n", pInfo->pTimeZone );
        IFPRINTF( fp, "Daylight Saving Adj: %x\n", pInfo->pDayltSavAdj );

        fprintf( fp, "\n-----------------------xxx-----------------------\n\n");
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSNasNetworkTimeCallBack
 *
 * Purpose: SLQSNasNetworkTimeCallBack test function
 *
 **************/
package void doSetSLQSNasNetworkTimeCallBack( void )
{
    ULONG rc;
    rc = SLQSNasNetworkTimeCallBack(&cbkTestSLQSNasNetworkTimeCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasNetworkTimeCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasNetworkTimeCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSNasNetworkTimeCallBack
 *
 * Purpose: Clear the doSLQSNasNetworkTimeCallBack API
 *
 **************/
package void doClearSLQSNasNetworkTimeCallBack( void )
{
    ULONG rc;

    rc = SLQSNasNetworkTimeCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasNetworkTimeCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasNetworkTimeCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetMemeryFullInfoCallback
 *
 * Purpose: cbkTestSLQSSetMemeryFullInfoCallback API callback function
 *
 **************/
local void cbkTestSLQSSetMemeryFullInfoCallback(
    SMSMemoryInfo *pInfo )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSLQSWmsMemoryFullCallBack.txt", "a");

    if ( fp )
    {
        if( pInfo )
        {
            fprintf( fp, "\nMemory Full Information:\n" );
            fprintf( fp, "Storage Type: %x\n", pInfo->storageType );
            fprintf( fp, "Message Mode: %x\n", pInfo->messageMode );
        }
    }
    if( fp )
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSMemoryFullInfoCallback
 *
 * Purpose: SLQSWmsMemoryFullCallBack test function
 *
 **************/
package void doSetSLQSWmsMemoryFullCallBack( void )
{
    ULONG rc;
    rc = SLQSWmsMemoryFullCallBack( &cbkTestSLQSSetMemeryFullInfoCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSLQSWmsMemoryFullCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSLQSWmsMemoryFullCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSWmsMemoryFullCallBack
 *
 * Purpose: Clear the doSLQSWmsMemoryFullCallBack API
 *
 **************/
package void doClearSLQSWmsMemoryFullCallBack( void )
{
    ULONG rc;

    rc = SLQSWmsMemoryFullCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSWmsMemoryFullCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSWmsMemoryFullCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSVoiceInfoRecCallbackCB
 *
 * Purpose: SLQSSetSMSEventCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceInfoRecCallbackCB(
    voiceInfoRec *pVoiceInfoRec )
{
    FILE *fp;
    voiceInfoRec *pLVACS = pVoiceInfoRec;

    fp = tfopen("../../cbk/test/results/cbkTestSLQSVoiceInfoRecCallbackCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSLQSVoiceInfoRecCallbackCB");
    else
    {
        fprintf( fp, "\nCall ID : %d", pLVACS->callID );

        if( pLVACS->pSignalInfo )
        {
            fprintf( fp, "\nSingnal Information:\n" );
            {
                signalInfo *pTemp = pLVACS->pSignalInfo;

                fprintf( fp, "Signal Type:%d\n", pTemp->signalType );
                fprintf( fp, "alertPitch :%d\n", pTemp->alertPitch );
                fprintf( fp, "signal     :%d\n", pTemp->signal );
            }
        }

        if ( pLVACS->pCallerIDInfo )
        {
            fprintf( fp, "Caller Id Information:\n" );
            {
                callerIDInfo *pTemp = pLVACS->pCallerIDInfo;
                fprintf( fp, "PI         :%d\n", pTemp->PI );
                fprintf(fp,"Caller ID :%s",pTemp->callerID);
            }
        }

        IFPRINTF(fp,"Display information     : %d\n",pLVACS->pDispInfo);
        IFPRINTF(fp,"Extended Display info   : %d\n",pLVACS->pExtDispInfo);
        IFPRINTF(fp,"Caller Name information : %d\n",pLVACS->pCallerNameInfo);
        IFPRINTF(fp,"Call wait Indicator     : %d\n",pLVACS->pCallWaitInd);

        if ( pLVACS->pConnectNumInfo )
        {
            fprintf( fp, "Connected Number Information:\n" );
            {
                connectNumInfo *pTemp = pLVACS->pConnectNumInfo;
                fprintf( fp, "PI          :%d\n", pTemp->numPresInd );
                fprintf( fp, "SI          :%d\n", pTemp->screeningInd );
                fprintf( fp, "numType     :%d\n", pTemp->numType );
                fprintf( fp, "numPlan     :%d\n", pTemp->numPlan );
                fprintf(fp,"Connected number Info :%s\n",pTemp->callerID);
            }
        }

        if ( pLVACS->pCallingPartyInfo )
        {
            fprintf( fp, "Calling Party Information:\n" );
            {
                /* Structure Element of connectNumInfo
                   are same as CallingPartyInfo */
                connectNumInfo *pTemp = pLVACS->pCallingPartyInfo;
                fprintf( fp, "PI          :%d\n", pTemp->numPresInd );
                fprintf( fp, "SI          :%d\n", pTemp->screeningInd );
                fprintf( fp, "numType     :%d\n", pTemp->numType );
                fprintf( fp, "numPlan     :%d\n", pTemp->numPlan );
                fprintf( fp, "callerIdlen :%d\n", pTemp->callerIDLen );

                fprintf(fp,"Calling Party Info :%s\n",pTemp->callerID);
            }
        }

        if ( pLVACS->pCalledPartyInfo )
        {
            fprintf( fp, "Called Party Information:\n" );
            {
                calledPartyInfo *pTemp = pLVACS->pCalledPartyInfo;
                fprintf( fp, "PI          :%d\n", pTemp->PI );
                fprintf( fp, "SI          :%d\n", pTemp->SI );
                fprintf( fp, "numType     :%d\n", pTemp->numType );
                fprintf( fp, "numPlan     :%d\n", pTemp->numPlan );
                fprintf( fp, "callerIdlen :%d\n", pTemp->numLen );

                fprintf(fp," Called Party Number :%s\n",pTemp->number);
            }
        }

        if ( pLVACS->pRedirNumInfo )
        {
            fprintf( fp, "Redirecting Number Information:\n" );
            {
                redirNumInfo *pTemp = pLVACS->pRedirNumInfo;
                fprintf( fp, "PI      :%d\n", pTemp->PI );
                fprintf( fp, "SI      :%d\n", pTemp->SI );
                fprintf( fp, "numType :%d\n", pTemp->numType );
                fprintf( fp, "numPlan :%d\n", pTemp->numPlan );
                fprintf( fp, "Reason  :%d\n", pTemp->reason );
                fprintf( fp, "numLen  :%d\n", pTemp->numLen );

                fprintf(fp,"Redirecting Number :%s\n",pTemp->number);
            }
        }
        fprintf( fp, "\n");
        IFPRINTF(fp,"CLIR Cause : %d\n",pLVACS->pCLIRCause);

        if ( pLVACS->pNSSAudioCtrl )
        {
            fprintf( fp, "NSS Audio Control:\n" );
            {
                NSSAudioCtrl *pTemp = pLVACS->pNSSAudioCtrl;
                fprintf( fp, "uplink   :%d\n", pTemp->upLink );
                fprintf( fp, "Downlink :%d\n", pTemp->downLink );
            }
        }
        fprintf( fp, "\n");

        IFPRINTF(fp,"CLIR Cause : %d\n",pLVACS->pNSSRelease);

        if ( pLVACS->pLineCtrlInfo )
        {
            fprintf( fp, "NSS Audio Control:\n" );
            {
                lineCtrlInfo *pTemp = pLVACS->pLineCtrlInfo;
                fprintf( fp, "polarityIncluded:%d\n", pTemp->polarityIncluded );
                fprintf( fp, "toggleMode      :%d\n", pTemp->toggleMode );
                fprintf( fp, "revPolarity     :%d\n", pTemp->revPolarity );
                fprintf( fp, "pwrDenialTime   :%d\n", pTemp->pwrDenialTime );
            }
        }
        fprintf( fp, "\n");

        if ( pLVACS->pExtDispRecInfo )
        {
            fprintf( fp, " Extended display Info record:\n" );
            {
                extDispRecInfo *pTemp = pLVACS->pExtDispRecInfo;
                fprintf( fp, "dispType       :%d\n", pTemp->dispType );
                fprintf( fp, "extDispInfoLen :%d\n", pTemp->extDispInfoLen );
                fprintf( fp, "Extended Disp Info :%s\n",pTemp->extDispInfo);
            }
        }
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSVoiceInfoRecCallback
 *
 * Purpose: SLQSVoiceInfoRecCallback API test function
 *
 **************/
package void doSetSLQSVoiceInfoRecCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceInfoRecCallback( &cbkTestSLQSVoiceInfoRecCallbackCB );

    if ( rc != eQCWWAN_ERR_NONE )

        fprintf( stderr, "doSLQSVoiceInfoRecCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSVoiceInfoRecCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSVoiceInfoRecCallback
 *
 * Purpose: Clear the SLQSVoiceInfoRecCallback API
 *
 **************/

package void doClearSLQSVoiceInfoRecCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceInfoRecCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )

        fprintf( stderr, "SLQSVoiceInfoRecCallback: Failed : %u\n", rc );
    else
        printf( "SLQSVoiceInfoRecCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSVoiceSetOTASPStatusCB
 *
 * Purpose: SLQSSetSMSEventCallback API callback function
 *
 **************/
local void cbkTestSLQSVoiceSetOTASPStatusCB(
   voiceOTASPStatusInfo *pVoiceOTASPStatusInfo )
{
    FILE *fp;
    voiceOTASPStatusInfo *pLOSI = pVoiceOTASPStatusInfo;

    fp = tfopen("../../cbk/test/results/cbkTestSLQSVoiceSetOTASPStatusCB.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSLQSVoiceSetOTASPStatusCB");
    else
    {
        fprintf( fp, "\nOTASP Status Information :\n" );
        {
            fprintf( fp, "Call Identifier:%d\n", pLOSI->callID);
            fprintf( fp, "OTASP Status   :%d\n", pLOSI->OTASPStatus);
        }

    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSVoiceSetOTASPStatusCallBack
 *
 * Purpose: SLQSVoiceSetOTASPStatusCallBack test function
 *
 **************/
package void doSLQSVoiceSetOTASPStatusCallback( void )
{
    ULONG rc;
    rc = SLQSVoiceSetOTASPStatusCallBack(&cbkTestSLQSVoiceSetOTASPStatusCB);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSVoiceSetOTASPStatusCallBack: Failed : %u\r\n", rc );
    else
        printf( "SLQSVoiceSetOTASPStatusCallBack: Enabled callback\r\n" );
}
/*************
 *
 * Name:    doClearSLQSVoiceSetOTASPStatusCallback
 *
 * Purpose: Clear the SLQSVoiceSetOTASPStatusCallback API
 *
 **************/
package void doClearSLQSVoiceSetOTASPStatusCallback( void )
{
    ULONG rc;

    rc = SLQSVoiceSetOTASPStatusCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSVoiceSetOTASPStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSVoiceSetOTASPStatusCallback: Disabled\n" );
}

local void cbkTestSLQSSetQosNWStatusCallback(
    BYTE status )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetQosNWStatusCallback.txt", "a");

    if ( fp )
    {
        fprintf( fp, "\nNetwork Qos Support Status: %d\n", status );
    }
    if( fp )
    tfclose(fp);
}

package void doSetSLQSSetQosNWStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetQosNWStatusCallback( &cbkTestSLQSSetQosNWStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetQosNWStatusCallback : Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSetQosNWStatusCallback : Enabled callback\r\n" );
}

package void doClearSLQSSetQosNWStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetQosNWStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetQosNWStatusCallback : Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetQosNWStatusCallback : Disabled\n" );
}

local void cbkTestSetNetChangeCbk(
    ULONG q_depth,
    BYTE isThrottle,
    BYTE instanceId )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SetNetChangeCbk.txt", "a");

    if ( fp )
    {
        fprintf( fp, "\n: Queue depth = %u isThrottle = %u, instance id = %u\n", q_depth, isThrottle, instanceId );
        tfclose(fp);
    }
}

package void doSetNetChangeCbk( void )
{
    static ULONG period = 5;
    int i;
    ULONG rc;
    for(i=0;i<2;i++)
    {
        rc = SetNetChangeCbk(i, (tFNNet)&cbkTestSetNetChangeCbk, 2, 0, period );

        if ( rc != eQCWWAN_ERR_NONE )
            fprintf( stderr, "SetNetChangeCbk : Failed : %u\r\n", rc );
        else
            fprintf( stderr, "SetNetChangeCbk : Enabled callback\r\n" );
    }
}

package void doClearNetChangeCbk( void )
{
    ULONG rc;
    int i;

    for(i=0;i<2;i++)
    {
        rc = SetNetChangeCbk(i, NULL, 0, 0, 0 );

        if ( rc != eQCWWAN_ERR_NONE )
            fprintf( stderr, "%s : Failed : %u\n", __func__, rc );
        else
            fprintf( stderr, "%s : Disabled\n", __func__ );
    }
}

/*************
 *
 * Name:    cbkTestSLQSSetMessageWaitingCallback
 *
 * Purpose: cbkTestSLQSSetMessageWaitingCallback API callback function
 *
 **************/
local void cbkTestSLQSSetMessageWaitingCallback(
    msgWaitingInfo *pInfo )
{
    FILE *fp;
    BYTE i;

    fp = tfopen("../../cbk/test/results/SLQSWmsMessageWaitingCallBack.txt", "a");

    if ( fp )
    {
        if( pInfo )
        {
            fprintf(fp, "\nreceive Message Waiting Info Indication\n");

            for ( i = 0; i < pInfo->numInstances; i++)
            {
                fprintf(fp, "message type: %d\n", pInfo->msgWaitInfo[i].msgType);
                fprintf(fp, "active indication: %d\n", pInfo->msgWaitInfo[i].activeInd);
                fprintf(fp, "message count: %d\n", pInfo->msgWaitInfo[i].msgCount);
                fprintf(fp, "\n");
            }
        }
    }
    if( fp )
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSWmsMessageWaitingCallBack
 *
 * Purpose: SLQSWmsMessageWaitingCallBack test function
 *
 **************/
package void doSetSLQSWmsMessageWaitingCallBack( void )
{
    ULONG rc;
    rc = SLQSWmsMessageWaitingCallBack( &cbkTestSLQSSetMessageWaitingCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSWmsMessageWaitingCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSWmsMessageWaitingCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSWmsMessageWaitingCallBack
 *
 * Purpose: Clear the doSetSLQSWmsMessageWaitingCallBack API
 *
 **************/
package void doClearSLQSWmsMessageWaitingCallBack( void )
{
    ULONG rc;

    rc = SLQSWmsMessageWaitingCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSWmsMessageWaitingCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSWmsMessageWaitingCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSNasSigInfoCallBack
 *
 * Purpose: SLQSNasSigInfoCallBack API callback function
 *
 **************/
local void cbkTestSLQSNasSigInfoCallBack(
    nasSigInfo *pInfo )
{
    FILE *fp;
    fp = tfopen("../../cbk/test/results/SLQSNasSigInfoCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSNasSigInfoCallBack");
    else
    {
        fprintf( fp, "\n------------------------.------------------------\n\n");
        fprintf( fp, "NAS Signal Strength Information From SLQSNasSigInfoCallBack\n");
        if ( pInfo->pCDMASigInfo )
        {
            fprintf( fp,"RSSI(CDMA) : %d\n",pInfo->pCDMASigInfo->rssi );
            fprintf( fp,"ECIO(CDMA) : %d\n",pInfo->pCDMASigInfo->ecio );
        }
        if ( pInfo->pHDRSigInfo )
        {
            fprintf( fp,"RSSI(HDR) : %d\n",pInfo->pHDRSigInfo->rssi );
            fprintf( fp,"ECIO(HDR) : %d\n",pInfo->pHDRSigInfo->ecio );
            fprintf( fp,"SINR(HDR) : %d\n",pInfo->pHDRSigInfo->sinr );
            fprintf( fp,"IO(HDR)   : %d\n",pInfo->pHDRSigInfo->io );
        }
        if ( pInfo->pGSMSigInfo )
        {
            fprintf( fp,"GSM Signal Info(GSM)      : %d\n",*pInfo->pGSMSigInfo );
        }
        if ( pInfo->pWCDMASigInfo )
        {
            fprintf( fp,"RSSI(WCDMA)  : %d\n",pInfo->pWCDMASigInfo->rssi );
            fprintf( fp,"ECIO(WCDMA)  : %d\n",pInfo->pWCDMASigInfo->ecio );
        }
        if ( pInfo->pLTESigInfo )
        {
            fprintf( fp,"RSSI(LTE)  : %d\n",pInfo->pLTESigInfo->rssi );
            fprintf( fp,"RSRQ(LTE)  : %d\n",pInfo->pLTESigInfo->rsrq );
            fprintf( fp,"RSRP(LTE)  : %d\n",pInfo->pLTESigInfo->rsrp );
            fprintf( fp,"SNR(LTE)   : %d\n",pInfo->pLTESigInfo->snr );
        }
        if ( pInfo->pRscp)
        {
            fprintf( fp,"RSCP(TDSCDMA)  : %d\n",*pInfo->pRscp );
        }
        if ( pInfo->pTDSCDMASigInfoExt )
        {
            fprintf( fp,"RSSI(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->rssi );
            fprintf( fp,"RSCP(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->rscp );
            fprintf( fp,"ECIO(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->ecio );
            fprintf( fp,"SINR(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->sinr );
        }
    }
	if(fp)
	tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSNasSigInfoCallBack
 *
 * Purpose: SLQSNasSigInfoCallBack test function
 *
 **************/
package void doSetSLQSNasSigInfoCallBack( void )
{
    ULONG         rc;
    INT8          rssiThresList[3] = { 0x96, 0xAA, 0xB4 };
    BYTE          rssiThresListlen = 3;
    RSSIThresh    rssiThresh;

    SHORT         ecioThresList[3] = { 0x02, 0x10, 0x18 }; /* -1dB, -8dB, -12dB */
    BYTE          ecioThresListLen = 3;
    ECIOThresh    ecioThresh;

    BYTE          hdrsinrThresList[3] = { 0x02, 0x10, 0x1A };
    BYTE          hdrsinrThresListLen = 3;
    HDRSINRThresh hdrsinrThresh;

    SHORT        ltesnrThresList[3] = { -2, 24, 26 }; /* -2dB, 24dB, 26dB */
    BYTE         ltesnrThresListLen = 3;
    LTESNRThresh ltesnrThresh;

    INT32        ioThresList[3] = { -10, 6, 14 };
    BYTE         ioThresListLen = 3;
    IOThresh     ioThresh;

    INT8         rsrqThresList[1] = { -11 };
    BYTE         rsrqThresListLen = 1;
    RSRQThresh   rsrqThresh;

    SHORT         rsrpThresList[3] = { 150, 200 };
    BYTE         rsrpThresListlen = 3;
    RSRPThresh   rsrpThresh;

    BYTE         rptRate = 2;
    BYTE         avgPeriod = 2;
    LTESigRptCfg lteSigRptCfg;

    BYTE         lCtr = 0;
    sigInfo      req;

    /* Assign request parameters */
    rssiThresh.RSSIThresListLen = rssiThresListlen;
    rssiThresh.pRSSIThresList   = rssiThresList;
    req.pRSSIThresh             = &rssiThresh;

    ecioThresh.ECIOThresListLen = ecioThresListLen;
    ecioThresh.pECIOThresList   = ecioThresList;
    req.pECIOThresh             = &ecioThresh;

    hdrsinrThresh.HDRSINRThresListLen = hdrsinrThresListLen;
    hdrsinrThresh.pHDRSINRThresList   = hdrsinrThresList;
    req.pHDRSINRThresh                = &hdrsinrThresh;

    ltesnrThresh.LTESNRThresListLen = ltesnrThresListLen;
    ltesnrThresh.pLTESNRThresList   = ltesnrThresList;
    req.pLTESNRThresh               = &ltesnrThresh;

    ioThresh.IOThresListLen = ioThresListLen;
    ioThresh.pIOThresList   = ioThresList;
    req.pIOThresh           = &ioThresh;

    rsrqThresh.RSRQThresListLen = rsrqThresListLen;
    rsrqThresh.pRSRQThresList   = rsrqThresList;
    req.pRSRQThresh             = &rsrqThresh;

    rsrpThresh.RSRPThresListLen = rsrpThresListlen;
    rsrpThresh.pRSRPThresList   = rsrpThresList;
    req.pRSRPThresh             = &rsrpThresh;

    lteSigRptCfg.rptRate   = rptRate;
    lteSigRptCfg.avgPeriod = avgPeriod;
    req.pLTESigRptCfg      = &lteSigRptCfg;

    fprintf( stderr, "Parameter Set:\n" );

    fprintf( stderr, "\nRSSI Threshold list\n");
    fprintf( stderr, "RSSI Threshold list length: %d\n", rssiThresh.RSSIThresListLen );
    for( lCtr=0; lCtr < rssiThresh.RSSIThresListLen; lCtr++ )
    {
        fprintf( stderr, "RSSI Threshold [%d]: %d\n", lCtr, rssiThresList[lCtr] );
    }

    fprintf( stderr, "\nECIO Threshold list\n");
    fprintf( stderr, "ECIO Threshold list length: %d\n", ecioThresh.ECIOThresListLen );
    for( lCtr=0; lCtr < ecioThresh.ECIOThresListLen; lCtr++ )
    {
        fprintf( stderr, "ECIO Threshold [%d]: %d\n", lCtr, ecioThresList[lCtr] );
    }

    fprintf( stderr, "\nHDR SINR Threshold list\n");
    fprintf( stderr, "HDR SINR Threshold list length: %d\n", hdrsinrThresh.HDRSINRThresListLen );
    for( lCtr=0; lCtr < hdrsinrThresh.HDRSINRThresListLen; lCtr++ )
    {
        fprintf( stderr, "HDR SINR Threshold [%d]: %d\n", lCtr, hdrsinrThresList[lCtr] );
    }

    fprintf( stderr, "\nLTE SNR Threshold list\n");
    fprintf( stderr, "LTE SNR Threshold list length: %d\n", ltesnrThresh.LTESNRThresListLen );
    for( lCtr=0; lCtr < ltesnrThresh.LTESNRThresListLen; lCtr++ )
    {
        fprintf( stderr, "LTE SNR Threshold [%d]: %d\n", lCtr, ltesnrThresList[lCtr] );
    }

    fprintf( stderr, "\nIO Threshold list\n");
    fprintf( stderr, "IO Threshold list length: %d\n", ioThresh.IOThresListLen );
    for( lCtr=0; lCtr < ioThresh.IOThresListLen; lCtr++ )
    {
        fprintf( stderr, "IO Threshold [%d]: %d\n", lCtr, ioThresList[lCtr] );
    }

    fprintf( stderr, "\nRSRQ Threshold list\n");
    fprintf( stderr, "RSRQ Threshold list length: %d\n", rsrqThresh.RSRQThresListLen );
    for( lCtr=0; lCtr < rsrqThresh.RSRQThresListLen; lCtr++ )
    {
        fprintf( stderr, "RSRQ Threshold [%d]: %d\n", lCtr, rsrqThresList[lCtr] );
    }

    fprintf( stderr, "\nRSRP Threshold list\n");
    fprintf( stderr, "RSRP Threshold list length: %d\n", rsrpThresh.RSRPThresListLen );
    for( lCtr=0; lCtr < rsrpThresh.RSRPThresListLen; lCtr++ )
    {
        fprintf( stderr, "RSRP Threshold [%d]: %d\n", lCtr, rsrpThresList[lCtr] );
    }

    fprintf( stderr, "\nLTE signal report configuration\n");
    fprintf( stderr, "Report Rate %d\n", lteSigRptCfg.rptRate );
    fprintf( stderr, "Averaging period %d\n", lteSigRptCfg.avgPeriod );

    rc = SLQSNasSigInfoCallBack( &cbkTestSLQSNasSigInfoCallBack, &req );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasSigInfoCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasSigInfoCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSNasSigInfoCallBack
 *
 * Purpose: Clear the doSLQSNasSigInfoCallBack API
 *
 **************/
package void doClearSLQSNasSigInfoCallBack( void )
{
    ULONG rc;

    rc = SLQSNasSigInfoCallBack( NULL, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasSigInfoCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasSigInfoCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetModemTempCallback
 *
 * Purpose: SLQSSetModemTempCallback API callback function
 *
 **************/
local void cbkTestSLQSSetModemTempCallback(
    modemTempNotification *pModemTempNotification )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetModemTempCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetModemTempCallback");
    else
    {
        fprintf( fp, "Modem Temperature State 0x%x \n",
                 pModemTempNotification->ModemTempState );

        fprintf( fp, "Modem Temperature (in degree celsius) 0x%x \n",
                 pModemTempNotification->ModemTemperature );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetModemTempCallback
 *
 * Purpose: SLQSSetModemTempCallback test function
 *
 **************/
package void doSLQSSetModemTempCallback( void )
{
    ULONG rc;
    rc = SLQSSetModemTempCallback( &cbkTestSLQSSetModemTempCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetModemTempCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSSetModemTempCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetModemTempCallback
 *
 * Purpose: Clear the doSLQSSetModemTempCallback API
 *
 **************/
package void doClearSLQSSetModemTempCallback( void )
{
    ULONG rc;

    rc = SLQSSetModemTempCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetModemTempCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetModemTempCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetPacketSrvStatCallback
 *
 * Purpose: SLQSSetPacketSrvStatusCallback API callback function
 *
 * Parms:   pPacketSrvStatus - Packet Service Status
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSLQSSetPacketSrvStatCallback(
    packetSrvStatus *pPacketSrvStatus )
{
    FILE *fp;

    fp = tfopen("TestReport/slqssetpacketsrvstatuscallback.txt", "a");
    if( fp == NULL )
    {
        perror("cbkTestSLQSSetPacketSrvStatusCallback");
        return;
    }

    fprintf( fp,
             "\nInterface Instance ID: %d\tService %d\tv4 SID %u\tv6 SID %u\n",
             pPacketSrvStatus->pQmiInterfaceInfo->qaQmiinstanceid,
             pPacketSrvStatus->pQmiInterfaceInfo->qaQmisvctype,
             pPacketSrvStatus->pQmiInterfaceInfo->v4sessionId,
             pPacketSrvStatus->pQmiInterfaceInfo->v6sessionId );

    fprintf( fp, "State: %d\n", pPacketSrvStatus->connStatus );
    fprintf( fp, "Reconfig. Required: %d\n", pPacketSrvStatus->reconfigReqd );
    fprintf( fp, "Session End Reason: %d\n",
             pPacketSrvStatus->sessionEndReason );
    fprintf( fp, "Verbose Session End Reason Type: %d\n",
             pPacketSrvStatus->verboseSessnEndReasonType );
    fprintf( fp, "Verbose Session End Reason: %d\n",
             pPacketSrvStatus->verboseSessnEndReason );
    fprintf( fp, "IP Family: %d\n", pPacketSrvStatus->ipFamily );
    fprintf( fp, "Tech. Name: %d\n", pPacketSrvStatus->techName );
    fprintf( fp, "Bearer ID: %d\n", pPacketSrvStatus->bearerID );
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetPacketSrvStatusCallback
 *
 * Purpose: SLQSSetPacketSrvStatusCallback test function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSLQSSetPacketSrvStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetPacketSrvStatusCallback(&cbkTestSLQSSetPacketSrvStatCallback);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSLQSSetPacketSrvStatusCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "doSLQSSetPacketSrvStatusCallback: enabled callback\n" );
    }
}

/*************
 *
 * Name:    doClearSLQSSetPacketSrvStatusCallback
 *
 * Purpose: clear the SLQSSetPacketSrvStatusCallback API
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearSLQSSetPacketSrvStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetPacketSrvStatusCallback(NULL);

    if( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doClearSLQSSetPacketSrvStatusCallback: failed to disable callback\n" );
    }
    else
    {
        fprintf( stderr,
                 "doClearSLQSSetPacketSrvStatusCallback: disabled\n" );
    }
}

/*************
 *
 * Name:    cbkTestSLQSSetSwiHDRPersCallBack
 *
 * Purpose: SLQSNasHDRPersCallBack API callback function
 *
 **************/
local void cbkTestSLQSSetSwiHDRPersCallBack(
    HDRPersonalityInd *pInfo )
{
    FILE *fp;
    BYTE count;
    fp = tfopen("../../cbk/test/results/SLQSNasSwiHDRPersCallBack.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetSwiHDRPersCallBack");
    else
    {
        fprintf( fp, "\n------------------------.------------------------\n\n");
        fprintf( fp, "NAS HDR Personality From SLQSSetSwiHDRPersCallback\n");

        IFPRINTF( fp, "Current Personality  : 0x%x\n", pInfo->pCurrentPersonality );
        IFPRINTF( fp, "PersonalityListLength:0x%x\n", pInfo->pPersonalityListLength );

        if( NULL != pInfo->pPersonalityListLength &&
            NULL != pInfo->pProtocolSubtypeElement )
        {
            for( count = 0; count < *(pInfo->pPersonalityListLength); count++ )
            {
                fprintf( fp, "Accessmac      : %d\n", pInfo->pProtocolSubtypeElement[count].AccessMac );
                fprintf( fp, "AuthPort       : %d\n", pInfo->pProtocolSubtypeElement[count].AuthProt );
                fprintf( fp, "Controlmac     : %d\n", pInfo->pProtocolSubtypeElement[count].ControlMac );
                fprintf( fp, "EncryptProt    : %d\n", pInfo->pProtocolSubtypeElement[count].EncryptProt );
                fprintf( fp, "ForwardMac     : %d\n", pInfo->pProtocolSubtypeElement[count].ForwardMac );
                fprintf( fp, "Idle State     : %d\n", pInfo->pProtocolSubtypeElement[count].IdleState );
                fprintf( fp, "KeyExchange    : %d\n", pInfo->pProtocolSubtypeElement[count].KeyExchange );
                fprintf( fp, "MultDisc       : %d\n", pInfo->pProtocolSubtypeElement[count].MultDisc );
                fprintf( fp, "Physical Layer : %d\n", pInfo->pProtocolSubtypeElement[count].PhysicalLayer );
                fprintf( fp, "Reversemac     : %d\n", pInfo->pProtocolSubtypeElement[count].ReverseMac );
                fprintf( fp, "Secprot        : %d\n", pInfo->pProtocolSubtypeElement[count].SecProt );
                fprintf( fp, "VirtStream     : %d\n", pInfo->pProtocolSubtypeElement[count].VirtStream );
            }
        }

    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSSetSwiHDRPersCallBack
 *
 * Purpose: SLQSSetSwiHDRPersCallback test function
 *
 **************/
package void doSetSLQSSetSwiHDRPersCallBack( void )
{
    ULONG rc;
    rc = SLQSSetSwiHDRPersCallback(&cbkTestSLQSSetSwiHDRPersCallBack);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasHDRPersCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasHDRPersCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSwiHDRPersCallBack
 *
 * Purpose: Clear the SLQSSetSwiHDRPersCallback API
 *
 **************/
package void doClearSLQSSetSwiHDRPersCallBack( void )
{
    ULONG rc;

    rc = SLQSSetSwiHDRPersCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasHDRPersCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasHDRPersCallBack: Disabled\n" );
}


/*************
 *
 * Name:    cbkTestSLQSSetSIPConfigCallback
 *
 * Purpose: SLQSSetSIPConfigCallback API callback function
 *
 **************/
local void cbkTestSLQSSetSIPConfigCallback(
    imsSIPConfigInfo *pImsSIPConfigInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetSIPConfigCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetSIPConfigCallback");
    else
    {
        fprintf( fp, "SIP Port Number 0x%x \n",
                 *pImsSIPConfigInfo->pSIPLocalPort );

        fprintf( fp, "SIP Registration Timer 0x%x \n",
                 *pImsSIPConfigInfo->pTimerSIPReg );

        fprintf( fp, "Subscribe Timer 0x%x \n",
                 *pImsSIPConfigInfo->pSubscribeTimer );

        fprintf( fp, "Timer T1 0x%x \n",
                 *pImsSIPConfigInfo->pTimerT1 );

        fprintf( fp, "Timer T2 0x%x \n",
                 *pImsSIPConfigInfo->pTimerT2 );

        fprintf( fp, "Timer Tf 0x%x \n",
                 *pImsSIPConfigInfo->pTimerTf );

        fprintf( fp, "SigComp Enabled 0x%x \n",
                 *pImsSIPConfigInfo->pSigCompEnabled );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetSIPConfigCallback
 *
 * Purpose: SLQSSetSIPConfigCallback test function
 *
 **************/
package void doSLQSSetSIPConfigCallback( void )
{
    ULONG rc;
    rc = SLQSSetSIPConfigCallback( &cbkTestSLQSSetSIPConfigCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetSIPConfigCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetSIPConfigCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSIPConfigCallback
 *
 * Purpose: Clear the doSLQSSetSIPConfigCallback API
 *
 **************/
package void doClearSLQSSetSIPConfigCallback( void )
{
    ULONG rc;

    rc = SLQSSetSIPConfigCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetSIPConfigCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetSIPConfigCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetRegMgrConfigCallback
 *
 * Purpose: SLQSSetRegMgrConfigCallback API callback function
 *
 **************/
local void cbkTestSLQSSetRegMgrConfigCallback(
    imsRegMgrConfigInfo *pImsRegMgrConfigInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetRegMgrConfigCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetRegMgrConfigCallback");
    else
    {
        fprintf( fp, "Primary CSCF Port 0x%x \n",
                 *pImsRegMgrConfigInfo->pPriCSCFPort );

        fprintf( fp, "CSCF Port Name %s \n",
                 pImsRegMgrConfigInfo->pCSCFPortName );

        fprintf( fp, "IMS Test Mode 0x%x \n",
                 *pImsRegMgrConfigInfo->pIMSTestMode );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetRegMgrConfigCallback
 *
 * Purpose: SLQSSetRegMgrConfigCallback test function
 *
 **************/
package void doSLQSSetRegMgrConfigCallback( void )
{
    ULONG rc;
    rc = SLQSSetRegMgrConfigCallback( &cbkTestSLQSSetRegMgrConfigCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetRegMgrConfigCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetRegMgrConfigCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetRegMgrConfigCallback
 *
 * Purpose: Clear the doSLQSSetRegMgrConfigCallback API
 *
 **************/
package void doClearSLQSSetRegMgrConfigCallback( void )
{
    ULONG rc;

    rc = SLQSSetRegMgrConfigCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetRegMgrConfigCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetRegMgrConfigCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetSMSConfigCallback
 *
 * Purpose: SLQSSetSMSConfigCallback API callback function
 *
 **************/
local void cbkTestSLQSSetSMSConfigCallback(
    imsSMSConfigInfo *pImsSMSConfigInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetSMSConfigCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetSMSConfigCallback");
    else
    {
        fprintf( fp, "SMS Format 0x%x \n",
                 *pImsSMSConfigInfo->pSMSFormat );

        fprintf( fp, "SMS over IP Nw indication flag 0x%x \n",
                 *pImsSMSConfigInfo->pSMSOverIPNwInd );

        fprintf( fp, "Phone Context URI %s \n",
                 pImsSMSConfigInfo->pPhoneCtxtURI );

        fprintf( fp, "\n\n" );
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetSMSConfigCallback
 *
 * Purpose: SLQSSetSMSConfigCallback test function
 *
 **************/
package void doSLQSSetSMSConfigCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSSMSConfigCallback( &cbkTestSLQSSetSMSConfigCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetSMSConfigCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetSMSConfigCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSMSConfigCallback
 *
 * Purpose: Clear the doSLQSSetSMSConfigCallback API
 *
 **************/
package void doClearSLQSSetSMSConfigCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSSMSConfigCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetSMSConfigCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetSMSConfigCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetUserConfigCallback
 *
 * Purpose: SLQSSetUserConfigCallback API callback function
 *
 **************/
local void cbkTestSLQSSetUserConfigCallback(
    imsUserConfigInfo *pImsUserConfigInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetUserConfigCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetUserConfigCallback");
    else
    {
        fprintf( fp, "IMS Domain Name %s \n",
                 pImsUserConfigInfo->pIMSDomain );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetUserConfigCallback
 *
 * Purpose: SLQSSetUserConfigCallback test function
 *
 **************/
package void doSLQSSetUserConfigCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSUserConfigCallback( &cbkTestSLQSSetUserConfigCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetUserConfigCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetUserConfigCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetUserConfigCallback
 *
 * Purpose: Clear the doSLQSSetUserConfigCallback API
 *
 **************/
package void doClearSLQSSetUserConfigCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSUserConfigCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetUserConfigCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetUserConfigCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetVoIPConfigCallback
 *
 * Purpose: SLQSSetVoIPConfigCallback API callback function
 *
 **************/
local void cbkTestSLQSSetVoIPConfigCallback(
    imsVoIPConfigInfo *pImsVoIPConfigInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetVoIPConfigCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetVoIPConfigCallback");
    else
    {
        fprintf( fp, "Session Expiry Timer: 0x%x \n",
                 *pImsVoIPConfigInfo->pSessionExpiryTimer );

        fprintf( fp, "Minimum Session Expiry Timer: 0x%x \n",
                 *pImsVoIPConfigInfo->pMinSessionExpiryTimer );

        fprintf( fp, "AMR WB Enable: 0x%x \n",
                 *pImsVoIPConfigInfo->pAmrWbEnable );

        fprintf( fp, "SCR AMR Enable: 0x%x \n",
                 *pImsVoIPConfigInfo->pScrAmrEnable );

        fprintf( fp, "SCR AMR WB Enable: 0x%x \n",
                 *pImsVoIPConfigInfo->pScrAmrWbEnable );

        fprintf( fp, "AMR Mode: 0x%x \n",
                 *pImsVoIPConfigInfo->pAmrMode );

        fprintf( fp, "AMR WB Mode: 0x%x \n",
                 *pImsVoIPConfigInfo->pAmrWBMode );

        fprintf( fp, "AMR Octet Aligned: 0x%x \n",
                 *pImsVoIPConfigInfo->pAmrOctetAligned );

        fprintf( fp, "AMR WB Octet Aligned: 0x%x \n",
                 *pImsVoIPConfigInfo->pAmrWBOctetAligned );

        fprintf( fp, "Ringing Timer: 0x%x \n",
                 *pImsVoIPConfigInfo->pRingingTimer );

        fprintf( fp, "Ringback Timer: 0x%x \n",
                 *pImsVoIPConfigInfo->pRingBackTimer );

        fprintf( fp, "RTP/RTCP Inactivity Timer: 0x%x \n",
                 *pImsVoIPConfigInfo->pRTPRTCPInactTimer );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetVoIPConfigCallback
 *
 * Purpose: SLQSSetVoIPConfigCallback test function
 *
 **************/
package void doSLQSSetVoIPConfigCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSVoIPConfigCallback( &cbkTestSLQSSetVoIPConfigCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetVoIPConfigCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetVoIPConfigCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetVoIPConfigCallback
 *
 * Purpose: Clear the doSLQSSetVoIPConfigCallback API
 *
 **************/
package void doClearSLQSSetVoIPConfigCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSVoIPConfigCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetVoIPConfigCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetVoIPConfigCallback: Disabled\n" );
}

local void cbkTestSLQSSetQosStatusCallback(
        BYTE    instance,
        ULONG   id,
        BYTE    status,
        BYTE    event,
        BYTE    reason
        )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetQosStatusCallback.txt", "a");

    if ( fp )
    {
        fprintf( fp, "\nQos Flow Status QMI/id/status/event/reason: %d/0x%x/%d/%d/0x%x\n",
                instance, id, status, event, reason);
    }
    if( fp ) tfclose(fp);
}

package void doSetSLQSSetQosStatusCallback( void )
{
    ULONG rc;
    BYTE instance = 0;

    rc = SLQSSetQosStatusCallback(instance, &cbkTestSLQSSetQosStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSSetQosStatusCallback : Failed : %u\n", rc );
    else
        fprintf( stderr, "doSetSLQSSetQosStatusCallback : Enabled callback\n" );
}

package void doClearSLQSSetQosStatusCallback( void )
{
    ULONG rc;
    BYTE instance = 0;

    rc = SLQSSetQosStatusCallback(instance, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetQosStatusCallback : Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetQosStatusCallback : Disabled\n" );
}

local void cbkTestSLQSSetQosPriEventCallback( WORD event )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SLQSSetQosPriEventCallback.txt", "a");

    if ( fp )
    {
        fprintf( fp, "\nQos Primary Flow modify operation: %d\n", event);
    }
    if( fp ) tfclose(fp);
}

package void doSetSLQSSetQosPriEventCallback( void )
{
    ULONG rc;

    rc = SLQSSetQosPriEventCallback(&cbkTestSLQSSetQosPriEventCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSSetQosPriEventCallback : Failed : %u\n", rc );
    else
        fprintf( stderr, "doSetSLQSSetQosPriEventCallback : Enabled callback\n" );
}

package void doClearSLQSSetQosPriEventCallback( void )
{
    ULONG rc;

    rc = SLQSSetQosPriEventCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetQosPriEventCallback : Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetQosPriEventCallback : Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetDUNCallInfoCallback
 *
 * Purpose: SLQSSetDUNCallInfoCallback API callback function
 *
 **************/
local void cbkTestSLQSSetDUNCallInfoCallback(
    DUNCallInfoInd *pDUNCallInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetDUNCallInfoCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetDUNCallInfoCallback");
    else
    {
        fprintf( fp, "Connection Status: 0x%x \n",
                 pDUNCallInfo->MdmConnStatus );

        fprintf( fp, "Call End Reason: 0x%x \n",
                 pDUNCallInfo->CallEndReason );

        fprintf( fp, "Tx Bytes OK: 0x%llx \n",
                 pDUNCallInfo->TXOKBytesCount );

        fprintf( fp, "Rx Bytes OK: 0x%llx \n",
                 pDUNCallInfo->RXOKBytesCount );

        fprintf( fp, "Dormancy Status: 0x%x \n",
                 pDUNCallInfo->DormancyStatus );

        fprintf( fp, "Data Bearer Technology: 0x%x \n",
                 pDUNCallInfo->DataBearerTech );

        fprintf( fp, "Current Channel Tx Rate: 0x%x \n",
                 pDUNCallInfo->ChannelRate.CurrChanTxRate );

        fprintf( fp, "Current Channel Rx Rate: 0x%x \n",
                 pDUNCallInfo->ChannelRate.CurrChanRxRate );

        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetDUNCallInfoCallback
 *
 * Purpose: SLQSSetDUNCallInfoCallback test function
 *
 **************/
package void doSLQSSetDUNCallInfoCallback( void )
{
    ULONG rc;
    BYTE  StatInterval = 0x05;
    rc = SLQSSetDUNCallInfoCallback( StatInterval, &cbkTestSLQSSetDUNCallInfoCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetDUNCallInfoCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetDUNCallInfoCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetDUNCallInfoCallback
 *
 * Purpose: Clear the doSLQSSetDUNCallInfoCallback API
 *
 **************/
package void doClearSLQSSetDUNCallInfoCallback( void )
{
    ULONG rc;

    rc = SLQSSetDUNCallInfoCallback( 0, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetDUNCallInfoCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetDUNCallInfoCallback: Disabled\n" );
}

local void cbkTestSLQSSetWdsTransferStatisticCallback( slqsWdsEventInfo *pWdsEventInfo )
{
    time_t rawtime;
    struct tm * timeinfo;
    char szBuff[64]={0};

    if(time ( &rawtime )<0)
    {
        perror("cbkTestSLQSSetWdsTransferStatisticCallback time");
        return;
    }
    timeinfo = localtime ( &rawtime );

    FILE *fp;

    fp = tfopen("../../cbk/test/results/setwdxferstatscallback.txt", "a");

    if ( fp == NULL )
    {
        perror(__func__);
        return;
    }
    (void)strftime(szBuff, sizeof(szBuff), "%a %b %e %T %Y", timeinfo);
    fprintf(fp, "%s \n %s\n", szBuff, __func__);

    if (pWdsEventInfo->pPacketsCountTX)
        fprintf(fp, "Transmitted Packets: %u\n", *(pWdsEventInfo->pPacketsCountTX));

    if (pWdsEventInfo->pPacketsCountRX)
        fprintf(fp, "Received Packets:    %u\n", *(pWdsEventInfo->pPacketsCountRX) );

    if (pWdsEventInfo->pTotalBytesTX)
        fprintf(fp, "Transmitted Bytes: %llu\n", *(pWdsEventInfo->pTotalBytesTX));

    if (pWdsEventInfo->pTotalBytesRX)
        fprintf(fp, "Received Bytes:    %llu\n", *(pWdsEventInfo->pTotalBytesRX) );

    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetWdsTransferStatisticCallback
 *
 * Purpose: SLQSSetWdsTransferStatisticCallback API driver function
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doSLQSSetWdsTransferStatisticCallback( void )
{
    ULONG rc;
    CHAR  *pEndOfLine;
    CHAR  selOption[OPTION_LENG];
    ULONG userOption;
    BYTE  len;
    BYTE  instance = 0;
    BYTE ipfamily = 0;

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter InstanceID value (  0 to 1 )  \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default Instance ID - 0 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 1 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        instance = userOption;
        switch( userOption )
        {
            case 0:
                break;
            case 1:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid InstanceID\n");
               continue;
        }
        break;
    }

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter ip family value (  4(IPv4), 6(IPv6) or 7(IPv4v6) )    \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default ip family  - ipv4 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        ipfamily = userOption;
        switch( ipfamily )
        {
            case 4:
                break;
            case 6:
                break;
            case 7:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid ip family\n");
               continue;
        }
        break;
    }

    rc = SLQSSetWdsTransferStatisticCallback(&cbkTestSLQSSetWdsTransferStatisticCallback,
                                  10,
                                  instance,
                                  ipfamily);
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doSLQSSetWdsTransferStatisticCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf(stderr,
                "doSLQSSetWdsTransferStatisticCallback: enable callback (cbkTestSLQSSetWdsTransferStatisticCallback, 10)\n" );
    }
}


/*************
 *
 * Name:    doClearSLQSWdsEventCallback
 *
 * Purpose: SLQSSetWdsEventCallback driver
 *
 * Parms:   none
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
package void doClearSLQSSetWdsTransferStatisticCallback( void )
{
    ULONG rc;
    CHAR  *pEndOfLine;
    CHAR  selOption[OPTION_LENG];
    ULONG userOption;
    BYTE  len;
    BYTE  instance = 0;
    BYTE ipfamily = 0;

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter InstanceID value (  0 to 1 )  \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default Instance ID - 0 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 1 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        instance = userOption;
        switch( userOption )
        {
            case 0:
                break;
            case 1:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid InstanceID\n");
               continue;
        }
        break;
    }

    while(1)
    {
        fprintf( stderr,
                 "\nPlease enter ip family value (  4(IPv4), 6(IPv6) or 7(IPv4v6) )    \n"\
                 "Option: " );

        /* Receive the input from the user */
        fgets( selOption, ( OPTION_LENG ), stdin );

        /*If only <ENTER> is pressed quit authentication params */
        if( ENTER_KEY == selOption[0])
        {
            fprintf( stderr,"Default ip family  - ipv4 chosen !!\n\n");
        }

        /* If '/n' character is not read, there are more characters in input
         * stream. Clear the input stream.
         */
        pEndOfLine = strchr( selOption, ENTER_KEY );

        if( NULL == pEndOfLine )
        {
            FlushStdinStream();
        }
        len = strlen( selOption );

        /* Convert the option added by user into integer */
        selOption[ len - 1 ] = '\0';
        userOption = atoi( selOption );

        /* If user has entered an invalid input, prompt again */
        if( 2 < strlen(selOption) )
        {
            fprintf(stderr,"Please choose valid option from menu \n");
            continue;
        }
        ipfamily = userOption;
        switch( ipfamily )
        {
            case 4:
                break;
            case 6:
                break;
            case 7:
                break;
            default:
                fprintf(stderr,"\nPlesae enter valid ip family\n");
               continue;
        }
        break;
    }

    rc = SLQSSetWdsTransferStatisticCallback( NULL,
                                  10,
                                  instance,
                                  ipfamily );
    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                 "doClearSLQSSetWdsTransferStatisticCallback: failed to Clear callback\n" );
    }
    else
    {
        fprintf(stderr,
                "doClearSLQSSetWdsTransferStatisticCallback: cleared callback \n" );
    }
}

/*************
 *
 * Name:    cbkTestSLQSSetDataSystemStatusCallback
 *
 * Purpose: SLQSSetDataSystemStatusCallback API callback function
 *
 **************/
local void cbkTestSLQSSetDataSystemStatusCallback(
    CurrDataSysStat *pCurrDataSysStat )
{
    FILE            *fp;
    BYTE            lCtr = 0;

    fp = tfopen("TestReport/SLQSSetDataSystemStatusCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetDataSystemStatusCallback");
    else
    {
        fprintf( fp, "Preferred Network: 0x%x \n",
                 *(pCurrDataSysStat->pPrefNetwork) );

        fprintf( fp, "Network Information length: 0x%x \n",
                 *(pCurrDataSysStat->pNetworkInfoLen) );

        fprintf( fp, "\n\n" );
        for( lCtr = 0; lCtr < *(pCurrDataSysStat->pNetworkInfoLen); lCtr++ )
        {
            CurrNetworkInfo *pCurrNetworkInfo;
            pCurrNetworkInfo = &(pCurrDataSysStat->pCurrNetworkInfo[lCtr]);
            fprintf( fp, "Network Information : 0x%x \n", lCtr );

            fprintf( fp, "Network Type: 0x%x \n",
                     pCurrNetworkInfo->NetworkType );

            fprintf( fp, "RAT Mask: 0x%x \n",
                     pCurrNetworkInfo->RATMask );

            fprintf( fp, "SO Mask: 0x%x \n\n",
                     pCurrNetworkInfo->SOMask );
        }
        fprintf( fp, "\n\n" );
    }
	if(fp)
    tfclose(fp);
}

/*************
 *
 * Name:    doSLQSSetDataSystemStatusCallback
 *
 * Purpose: SLQSSetDataSystemStatusCallback test function
 *
 **************/
package void doSLQSSetDataSystemStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetDataSystemStatusCallback( &cbkTestSLQSSetDataSystemStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetDataSystemStatusCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetDataSystemStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetDataSystemStatusCallback
 *
 * Purpose: Clear the doSLQSSetDataSystemStatusCallback API
 *
 **************/
package void doClearSLQSSetDataSystemStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetDataSystemStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetDataSystemStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetDataSystemStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetAsyncRawSendCallback
 *
 * Purpose: cbkTestSLQSSetAsyncRawSendCallback API callback function
 *
 **************/
local void cbkTestSLQSSetAsyncRawSendCallback(
    SMSAsyncRawSend *pInfo )
{
    FILE *fp;
    fp = tfopen("../../cbk/test/results/SLQSWmsAsyncRawSendCallBack.txt", "a");

    if ( fp )
    {
        if( pInfo )
        {
            fprintf(fp, "\nreceive Async Raw Send Indication\n");

                fprintf(fp, "Send Status     : %d\n", pInfo->sendStatus);
                fprintf(fp, "Message Id      : %d\n", pInfo->messageID);
                fprintf(fp, "Cause Code      : %d\n", pInfo->causeCode);
                fprintf(fp, "Error Class     : %d\n", pInfo->errorClass);
                fprintf(fp, "RP Cause        : %d\n", pInfo->RPCause);
                fprintf(fp, "TP Cause        : %d\n", pInfo->TPCause);
                fprintf(fp, "Alpha Id Length : %d\n", pInfo->alphaIDLen);
                fprintf(fp, "Alpha ID        : %s\n", pInfo->pAlphaID);
                fprintf(fp, "User Data       : %u\n", pInfo->userData);
                fprintf(fp, "Message Delivery Failure Type  : %d\n", pInfo->msgDelFailureType);
                fprintf(fp, "Message Delivery Failure Cause : %d\n", pInfo->msgDelFailureCause);
                fprintf(fp, "\n");
        }
    }
    if( fp )
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSWmsAsyncRawSendCallBack
 *
 * Purpose: SLQSWmsAsyncRawSendCallBack test function
 *
 **************/
package void doSetSLQSWmsAsyncRawSendCallBack( void )
{
    ULONG rc;
    rc = SLQSWmsAsyncRawSendCallBack( &cbkTestSLQSSetAsyncRawSendCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSWmsMessageWaitingCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "SLQSWmsMessageWaitingCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSWmsAsyncRawSendCallBack
 *
 * Purpose: Clear the doClearSLQSWmsAsyncRawSendCallBack API
 *
 **************/
package void doClearSLQSWmsAsyncRawSendCallBack( void )
{
    ULONG rc;

    rc = SLQSWmsAsyncRawSendCallBack( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSWmsMessageWaitingCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSWmsMessageWaitingCallBack: Disabled\n" );
}

/*************
 *
 * Name:    doSetSLQSOMADMAlertCallbackExt
 *
 * Purpose: SetSLQSOMADMAlertCallbackExt API test function
 *
 **************/
package void doSetSLQSOMADMAlertCallbackExt( void )
{
    ULONG rc;

    rc = SetSLQSOMADMAlertCallbackExt( &cbkTestSetSLQSOMADMAlertCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSOMADMAlertCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSOMADMAlertCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSOMADMAlertCallbackExt
 *
 * Purpose: Clear the SetSLQSOMADMAlertCallbackExt API
 *
 **************/
package void doClearSLQSOMADMAlertCallbackExt( void )
{
    ULONG rc;

    rc = SetSLQSOMADMAlertCallbackExt( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSOMADMAlertCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSOMADMAlertCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetSLQSNasSwiOTAMessageCallBack
 *
 * Purpose: SetSLQSNasSwiOTAMessageCallBack API callback function
 *
 **************/
local void cbkTestSetSLQSNasSwiOTAMessageCallBack( SwiOTAMsg *pSwiOTAMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetSLQSNasSwiOTAMessageCallBack.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetSLQSNasSwiOTAMessageCallBack");
    else
    {
        int i;
        fprintf ( fp, "\nOTA Message Type is: %u\r\n", pSwiOTAMsg->type);
        fprintf ( fp, "OTA Message Data Length is: %d\r\n", pSwiOTAMsg->data_len);
        for (i = 0; i < pSwiOTAMsg->data_len; i++)
        {
            fprintf( fp, "0x%02x ", pSwiOTAMsg->data[i]);
            if ( (i+1) % 16 == 0)
            {
                fprintf(fp, "\r\n");
            }
        }
        fprintf(fp, "\r\n");

        if (pSwiOTAMsg->pLteNasRelInfo != NULL)
        {
            fprintf ( fp, "LTE Nas Release Info release is: 0x%02x\n", pSwiOTAMsg->pLteNasRelInfo->nas_release);
            fprintf ( fp, "LTE Nas Release Info major is: 0x%02x\n", pSwiOTAMsg->pLteNasRelInfo->nas_major);
            fprintf ( fp, "LTE Nas Release Info minor is: 0x%02x\n", pSwiOTAMsg->pLteNasRelInfo->nas_minor);
        }
        if (pSwiOTAMsg->pTime != NULL)
        {
            /* Seconds in local time since Jan. 6th 1980 00:00:00 UTC */
            fprintf ( fp, "Time: %llu\n", *pSwiOTAMsg->pTime);
        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSNasSwiOTAMessageCallBack
 *
 * Purpose: SetSLQSNasSwiOTAMessageCallBack API test function
 *
 **************/
package void doSetSLQSNasSwiOTAMessageCallBack( void )
{
    ULONG rc;
    NasSwiIndReg req;

    /* enable all message type */
    req.lteEsmUl = 1;
    req.lteEsmDl = 1;
    req.lteEmmUl = 1;
    req.lteEmmDl = 1;
    req.gsmUmtsUl= 1;
    req.gsmUmtsDl = 1;

    rc = SLQSNasSwiOTAMessageCallback( &req, &cbkTestSetSLQSNasSwiOTAMessageCallBack );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasSwiOTAMessageCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasSwiOTAMessageCallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSNasSwiOTAMessageCallBack
 *
 * Purpose: Clear the SetSLQSNasSwiOTAMessageCallBack API
 *
 **************/
package void doClearSLQSNasSwiOTAMessageCallBack( void )
{
    ULONG rc;

    rc = SLQSNasSwiOTAMessageCallback( NULL, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasSwiOTAMessageCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasSwiOTAMessageCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetRMTransferStatisticsCallBack
 *
 * Purpose: SetRMTransferStatisticsCallback API callback function
 *
 **************/
local void cbkTestSetRMTransferStatisticsCallBack( QmiCbkWdsStatisticsIndState *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetRMTransferStatisicsCallBack.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetRMTransferStaticsCallBack");
    else
    {
        if (pMsg != NULL)
        {
           if(pMsg->TxOkConutTlv.TlvPresent)
           fprintf ( fp, "TxOkConut: %u\n",pMsg->TxOkConutTlv.ulData );
           if(pMsg->RxOkConutTlv.TlvPresent)
           fprintf ( fp, "RxOkConut: %u\n",pMsg->RxOkConutTlv.ulData );
           if(pMsg->TxOkByteCountTlv.TlvPresent)
           fprintf ( fp, "TxOkByteCount: %llu\n",pMsg->TxOkByteCountTlv.ullData );
           if(pMsg->RxOkByteCountTlv.TlvPresent)
           fprintf ( fp, "RxOkByteCount: %llu\n",pMsg->RxOkByteCountTlv.ullData );
           if(pMsg->TxDropConutTlv.TlvPresent)
           fprintf ( fp, "TxDropConut: %u\n",pMsg->TxDropConutTlv.ulData );
           if(pMsg->RxDropConutTlv.TlvPresent)
           fprintf ( fp, "RxDropConut: %u\n",pMsg->RxDropConutTlv.ulData );

        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetRMTransferStatisticsCallBack
 *
 * Purpose: Clear the SetRMTransferStatisticsCallback API
 *
 **************/
package void doSetRMTransferStatisticsCallBack(void)

{
    ULONG rc;
    rc = SetRMTransferStatisticsCallback(  &cbkTestSetRMTransferStatisticsCallBack );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetRMTransferStatisticsCallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetRMTransferStatisticsCallBack: Enabled callback\r\n" );
    
}

/*************
 *
 * Name:    doClearRMTransferStatisticsCallBack
 *
 * Purpose: Clear the SetRMTransferStatisticsCallback API
 *
 **************/
package void doClearRMTransferStatisticsCallBack( void )
{
    ULONG rc;

    rc = SetRMTransferStatisticsCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearRMTransferStatisticsCallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearRMTransferStatisticsCallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetLocCradleMountCallback
 *
 * Purpose: SetLocCradleMountCallback API callback function
 *
 **************/
local void cbkTestSetLocCradleMountCallback( QmiCbkLocCradleMountInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocCradleMountCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocCradleMountCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf( fp, "\nLOC Cradle Mount Status: %d\n",
                         pMsg->cradleMountConfigStatus);
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocCradleMountCallback
 *
 * Purpose: Set the SetLocCradleMountCallback API
 *
 **************/
package void doSetLocCradleMountCallback(void)

{
    ULONG rc;
    BYTE confidence  = 70;

    LocSetCradleMountReq req;

    req.state = 1;
    req.pConfidence = &confidence;

    /*enable callback*/
    rc = SetLocCradleMountCallback(  &cbkTestSetLocCradleMountCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocCradleMountCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocCradleMountCallback: Enabled callback\r\n" );

    /*Set Cradle mount Config*/
    rc = SLQSLOCSetCradleMountConfig( &req );
    if ( eQCWWAN_ERR_NONE != rc )
    {
        fprintf(stderr, "SLQSLOCSetCradleMountConfig Failed\n");
    }

}

/*************
 *
 * Name:    doClearLocCradleMountCallback
 *
 * Purpose: Clear the SetLocCradleMountCallback API
 *
 **************/
package void doClearLocCradleMountCallback(void)

{
    ULONG rc;
    rc = SetLocCradleMountCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocCradleMountCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocCradleMountCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSetLocEventTimeSyncCallback
 *
 * Purpose: SetLocEventTimeSyncCallback API callback function
 *
 **************/
local void cbkTestSetLocEventTimeSyncCallback( QmiCbkLocEventTimeSyncInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocEventTimeSyncCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocEventTimeSyncCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf( fp, "\nLOC Time Sync Ref Counter: %d\n",
                         pMsg->timeSyncRefCounter);

        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocEventTimeSyncCallback
 *
 * Purpose: Set the SetLocEventTimeSyncCallback API
 *
 **************/
package void doSetLocEventTimeSyncCallback(void)

{
    ULONG rc;
    rc = SetLocEventTimeSyncCallback( &cbkTestSetLocEventTimeSyncCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocEventTimeSyncCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocEventTimeSyncCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocEventTimeSyncCallback
 *
 * Purpose: Clear the SetLocEventTimeSyncCallback API
 *
 **************/
package void doClearLocEventTimeSyncCallback(void)

{
    ULONG rc;
    rc = SetLocEventTimeSyncCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocEventTimeSyncCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocEventTimeSyncCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSetLocInjectTimeCallback
 *
 * Purpose: SetLocInjectTimeCallback API callback function
 *
 **************/
local void cbkTestSetLocInjectTimeCallback( QmiCbkLocInjectTimeInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocInjectTimeCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocInjectTimeCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf( fp, "\nLOC Inject Time Sync Status: %d\n",
                         pMsg->injectTimeSyncStatus);

        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocInjectTimeCallback
 *
 * Purpose: Set the SetLocInjectTimeCallback API
 *
 **************/
package void doSetLocInjectTimeCallback(void)

{
    ULONG rc;
    rc = SetLocInjectTimeCallback(  &cbkTestSetLocInjectTimeCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocInjectTimeCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocInjectTimeCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocInjectTimeCallback
 *
 * Purpose: Clear the SetLocInjectTimeCallback API
 *
 **************/
package void doClearLocInjectTimeCallback(void)

{
    ULONG rc;
    rc = SetLocInjectTimeCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocInjectTimeCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocInjectTimeCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSetLocSensorStreamCallback
 *
 * Purpose: SetLocSensorStreamingCallback API callback function
 *
 **************/
local void cbkTestSetLocSensorStreamCallback( QmiCbkLocSensorStreamingInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocSensorStreamCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocSensorStreamCallback");
    else
    {
        fprintf(fp, "\nSensor Streaming Ready Status\n");
        if (pMsg->pAccelAcceptReady)
        {
            fprintf( fp, "\nAccel Inject Enable: %d\n",
                         pMsg->pAccelAcceptReady->injectEnable);
            fprintf( fp, "\nAccel SamplesPerBatch: %d\n",
                         pMsg->pAccelAcceptReady->samplesPerBatch);
            fprintf( fp, "\nAccel BatchesPerSecond: %d\n",
                         pMsg->pAccelAcceptReady->batchPerSec);
        }
        if (pMsg->pGyroAcceptReady)
        {
            fprintf( fp, "\nGyro Inject Enable: %d\n",
                         pMsg->pGyroAcceptReady->injectEnable);
            fprintf( fp, "\nGyro SamplesPerBatch: %d\n",
                         pMsg->pGyroAcceptReady->samplesPerBatch);
            fprintf( fp, "\nGyro BatchesPerSecond: %d\n",
                        pMsg->pGyroAcceptReady->batchPerSec);
        }
        if (pMsg->pAccelTempAcceptReady)
        {
            fprintf( fp, "\nAccel Temp. Inject Enable: %d\n",
                         pMsg->pAccelTempAcceptReady->injectEnable);
            fprintf( fp, "\nAccel Temp. SamplesPerBatch: %d\n",
                         pMsg->pAccelTempAcceptReady->samplesPerBatch);
            fprintf( fp, "\nAccel Temp. BatchesPerSecond: %d\n",
                         pMsg->pAccelTempAcceptReady->batchPerSec);
        }
        if (pMsg->pGyroTempAcceptReady)
        {
            fprintf( fp, "\nGyro Temp. Inject Enable: %d\n",
                         pMsg->pGyroTempAcceptReady->injectEnable);
            fprintf( fp, "\nGyro Temp. SamplesPerBatch: %d\n",
                         pMsg->pGyroTempAcceptReady->samplesPerBatch);
            fprintf( fp, "\nGyro Temp. BatchesPerSecond: %d\n",
                         pMsg->pGyroTempAcceptReady->batchPerSec);
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocSensorStreamCallback
 *
 * Purpose: Set the SetLocSensorStreamingCallback API
 *
 **************/
package void doSetLocSensorStreamCallback(void)

{
    ULONG rc;
    rc = SetLocSensorStreamingCallback(  &cbkTestSetLocSensorStreamCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocSensorStreamCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocSensorStreamCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocSensorStreamCallback
 *
 * Purpose: Clear the SetLocSensorStreamingCallback API
 *
 **************/
package void doClearLocSensorStreamCallback(void)

{
    ULONG rc;
    rc = SetLocSensorStreamingCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocSensorStreamCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocSensorStreamCallback: Disabled callback\r\n" );

}
/*************
 *
 * Name:    cbkTestSetLocInjectSensorDataCallback
 *
 * Purpose: SetLocInjectSensorDataCallback API callback function
 *
 **************/
local void cbkTestSetLocInjectSensorDataCallback( QmiCbkLocInjectSensorDataInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocInjectSensorDataCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocInjectSensorDataCallback");
    else
    {
        if (pMsg != NULL)
        {
             fprintf(fp, "\nInject Sensor Data\n");
             fprintf( fp, "\nInject Sensor Data Status: %d\n",
                          pMsg->injectSensorDataStatus);
             IFPRINTF( fp, "\nOpaque Identifier: %d\n",
                          pMsg->pOpaqueIdentifier);
             IFPRINTF( fp, "\nAccel Samples Accepted: %d\n",
                          pMsg->pAccelSamplesAccepted);
             IFPRINTF( fp, "\nGyro Samples Accepted: %d\n",
                          pMsg->pGyroSamplesAccepted);
             IFPRINTF( fp, "\nAccel Temp Samples Accepted: %d\n",
                          pMsg->pAccelTempSamplesAccepted);
             IFPRINTF( fp, "\nGyro Temp Samples Accepted: %d\n",
                          pMsg->pGyroTempSamplesAccepted);
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocInjectSensorDataCallback
 *
 * Purpose: Set the SetLocInjectSensorDataCallback API
 *
 **************/
package void doSetLocInjectSensorDataCallback(void)

{
    ULONG rc;
    LocInjectSensorDataReq req;

    ULONG opaqueIdentifier = 123456;

    sensorData AcceleroData;
    AcceleroData.timeOfFirstSample = 100000;
    AcceleroData.flags             = 0x02;
    AcceleroData.sensorDataLen     = 1;
    AcceleroData.timeOffset[0]     = 10000;
    float xAxis = 10.234;
    float yAxis = 10.235;
    float zAxis = 10.236;
    AcceleroData.xAxis[0]          = *(ULONG*)&xAxis;
    AcceleroData.yAxis[0]          = *(ULONG*)&yAxis;
    AcceleroData.zAxis[0]          = *(ULONG*)&zAxis;

    tempratureData   AcceleroTempData;
    AcceleroTempData.timeOfFirstSample  = 100000;
    AcceleroTempData.timeSource         = 0x01;
    AcceleroTempData.temperatureDataLen = 1;
    AcceleroTempData.timeOffset[0]      = 10000;
    float temperature    = 28.24;
    AcceleroTempData.temperature[0] = *(ULONG*)&temperature;

    req.pOpaqueIdentifier = &opaqueIdentifier;
    req.pAcceleroData     = &AcceleroData;
    req.pGyroData         = NULL;
    req.pAcceleroTimeSrc  = NULL;
    req.pGyroTimeSrc      = NULL;
    req.pAcceleroTempData = &AcceleroTempData;
    req.pGyroTempData     = NULL;

    rc = SetLocInjectSensorDataCallback(  &cbkTestSetLocInjectSensorDataCallback);

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocInjectSensorDataCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocInjectSensorDataCallback: Enabled callback\r\n" );

    /* Set Sensor data values */
        rc = SLQSLOCInjectSensorData( &req );
        if ( eQCWWAN_ERR_NONE != rc )
        {
            fprintf(stderr, "SLQSLOCInjectSensorData Failed\n");
        }
}

/*************
 *
 * Name:    doClearLocInjectSensorDataCallback
 *
 * Purpose: Clear the SetLocInjectSensorDataCallback API
 *
 **************/
package void doClearLocInjectSensorDataCallback(void)

{
    ULONG rc;
    rc = SetLocInjectSensorDataCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocInjectSensorDataCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocInjectSensorDataCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSetLocEventPositionCallback
 *
 * Purpose: SetLocEventPositionCallback API callback function
 *
 **************/
local void cbkTestSetLocEventPositionCallback( QmiCbkLocPositionReportInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocEventPositionCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocEventPositionCallback");
    else
    {
        if (pMsg != NULL)
        {
             fprintf(fp, "Event Position Report\n");
             fprintf( fp, "Session Status: %d\n",
                          pMsg->sessionStatus);
             fprintf( fp, "Session ID: %d\n",
                          pMsg->sessionId);
             IFPRINTF( fp, "Latitude: %lf\n",
                          (double*)pMsg->pLatitude);
             IFPRINTF( fp, "Longitude: %lf\n",
                          (double*)pMsg->pLongitude);
             IFPRINTF( fp, "Horizontal position uncertainty: %f\n",
                          (float*)pMsg->pHorUncCircular);
             IFPRINTF( fp, "Semi-minor axis of horizontal elliptical uncertainty: %f\n",
                          (float*)pMsg->pHorUncEllipseSemiMinor);
             IFPRINTF( fp, "Semi-major axis of horizontal elliptical uncertainty: %f\n",
                          (float*)pMsg->pHorUncEllipseSemiMajor);
             IFPRINTF( fp, "Elliptical Horizontal Uncertainty Azimuth: %f\n",
                          (float*)pMsg->pHorUncEllipseOrientAzimuth);
             IFPRINTF( fp, "Horizontal Confidence: %d\n",
                           pMsg->pHorConfidence);
             IFPRINTF( fp, "Horizontal Reliability: %d\n",
                           (pMsg->pHorReliability));
             IFPRINTF( fp, "Horizontal Speed: %f\n",
                           (float*)pMsg->pSpeedHorizontal);
             IFPRINTF( fp, "Speed Uncertainty: %f\n",
                           (float*)pMsg->pSpeedUnc);
             IFPRINTF( fp, "Altitude With Respect to Ellipsoid: %f\n",
                           (float*)pMsg->pAltitudeWrtEllipsoid);
             IFPRINTF( fp, "Altitude With Respect to Sea Level: %f\n",
                           (float*)pMsg->pAltitudeWrtMeanSeaLevel);
             IFPRINTF( fp, "Vertical Uncertainty: %f\n",
                           (float*)pMsg->pVertUnc);
             IFPRINTF( fp, "Vertical Confidence: %d\n",
                            pMsg->pVertConfidence);
             IFPRINTF( fp, "Vertical Reliability: %d\n",
                            pMsg->pVertReliability);
             IFPRINTF( fp, "Vertical Speed: %f\n",
                           (float*)pMsg->pSpeedVertical);
             IFPRINTF( fp, "Heading: %f\n",
                           (float*)pMsg->pHeading);
             IFPRINTF( fp, "Heading Uncertainty: %f\n",
                           (float*)pMsg->pHeadingUnc);
             IFPRINTF( fp, "Magnetic Deviation: %f\n",
                           (float*)pMsg->pMagneticDeviation);
             IFPRINTF( fp, "Technology Mask: %u\n",
                            pMsg->pTechnologyMask);
             if (pMsg->pPrecisionDilution != NULL)
             {
                 fprintf( fp, "Position dilution of precision: %f\n",
                              *((float*)&pMsg->pPrecisionDilution->PDOP));
                 fprintf( fp, "Horizontal dilution of precision: %f\n",
                              *((float*)&pMsg->pPrecisionDilution->HDOP));
                 fprintf( fp, "Vertical dilution of precision: %f\n",
                              *((float*)&pMsg->pPrecisionDilution->VDOP));
             }
             IFPRINTF( fp, "UTC Timestamp: %lf\n",
                           (double*)pMsg->pTimestampUtc);
             IFPRINTF( fp, "Leap Seconds: %d\n",
                            pMsg->pLeapSeconds);
             if (pMsg->pGpsTime != NULL)
             {
                 fprintf( fp, "GPS Week: %d\n",
                              (pMsg->pGpsTime->gpsWeek));
                 fprintf( fp, "Amount of time into the current GPS week: %d\n",
                              (pMsg->pGpsTime->gpsTimeOfWeekMs));
             }
             IFPRINTF( fp, "Time Uncertainty: %f\n",
                          (float*)pMsg->pTimeUnc);
             IFPRINTF( fp, "Time Source: %d\n",
                            pMsg->pTimeSrc);
             if (pMsg->pSensorDataUsage != NULL)
             {
                 fprintf( fp, "Usage Mask: %d\n",
                              (pMsg->pSensorDataUsage->usageMask));
                 fprintf( fp, "Aided Indicator Mask: %d\n",
                              (pMsg->pSensorDataUsage->aidingIndicatorMask));
             }
             IFPRINTF( fp, "Fix ID: %d\n",
                            pMsg->pFixId);
             if (pMsg->pSvUsedforFix != NULL)
             {
                  BYTE i = 0;
                  fprintf( fp, "GNSS SV Used List Length: %d\n",
                              (pMsg->pSvUsedforFix->gnssSvUsedList_len));
                 for ( i = 0; i < pMsg->pSvUsedforFix->gnssSvUsedList_len; i++ )
                 {
                       fprintf( fp, "GNSS SVs Used List: %d\n",
                              pMsg->pSvUsedforFix->gnssSvUsedList[i]);
                 }
             }
             IFPRINTF( fp, "Altitude Assumed: %x\n",
                           pMsg->pAltitudeAssumed);
             }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocEventPositionCallback
 *
 * Purpose: Set the SetLocEventPositionCallback API
 *
 **************/
package void doSetLocEventPositionCallback(void)

{
    ULONG rc;
    rc = SetLocEventPositionCallback(  &cbkTestSetLocEventPositionCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocEventPositionCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocEventPositionCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocEventPositionCallback
 *
 * Purpose: Clear the SetLocEventPositionCallback API
 *
 **************/
package void doClearLocEventPositionCallback(void)

{
    ULONG rc;
    rc = SetLocEventPositionCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocEventPositionCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocEventPositionCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSLQSSetIMSARegStatusCallback
 *
 * Purpose: SLQSSetIMSARegStatusCallback API callback function
 *
 **************/
local void cbkTestSLQSSetIMSARegStatusCallback(
    imsaRegStatusInfo *pImsaRegStatusInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetIMSARegStatusCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetIMSARegStatusCallback");
    else
    {
        IFPRINTF( fp, "\nIMS Registration Status %d ",
                 pImsaRegStatusInfo->pbIMSRegistered );

        IFPRINTF( fp, "\nIMS Registration Error Code 0x%04x ",
                 pImsaRegStatusInfo->pRegStatusErrorCode );

        IFPRINTF( fp, "\nNew IMS Reg Status %u ",
                 pImsaRegStatusInfo->pImsRegStatus );

        fprintf( fp, "\n\n" );
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSSetIMSARegStatusCallback
 *
 * Purpose: SLQSSetIMSARegStatusCallback test function
 *
 **************/
package void doSetSLQSSetIMSARegStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSARegStatusCallback( &cbkTestSLQSSetIMSARegStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetIMSARegStatusCallback: Failed : %u\r\n", rc );
    else
        printf( "SSLQSSetIMSARegStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetIMSARegStatusCallback
 *
 * Purpose: Clear the doSetSLQSSetIMSARegStatusCallback API
 *
 **************/
package void doClearSLQSSetIMSARegStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSARegStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetIMSARegStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetIMSARegStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetIMSASvcStatusCallback
 *
 * Purpose: SLQSSetIMSASvcStatusCallback API callback function
 *
 **************/
local void cbkTestSLQSSetIMSASvcStatusCallback(
    imsaSvcStatusInfo *pImsaSvcStatusInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetIMSASvcStatusCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetIMSASvcStatusCallback");
    else
    {
        IFPRINTF( fp, "\nSMS Service Status %u ",
                 pImsaSvcStatusInfo->pSMSSvcStatus );

        IFPRINTF( fp, "\nVOIP Service Status %u ",
                 pImsaSvcStatusInfo->pVOIPSvcStatus );

        IFPRINTF( fp, "\nVT Service Status %u ",
                 pImsaSvcStatusInfo->pVTSvcStatus );

        IFPRINTF( fp, "\nSMS Service RAT %u ",
                 pImsaSvcStatusInfo->pSMSSvcRAT );

        IFPRINTF( fp, "\nVOIP Service RAT %u ",
                 pImsaSvcStatusInfo->pVOIPSvcRAT );

        IFPRINTF( fp, "\nVT Service RAT %u ",
                 pImsaSvcStatusInfo->pVTSvcRAT );

        IFPRINTF( fp, "\nUT Service Status %u ",
                 pImsaSvcStatusInfo->pUTSvcStatus );

        IFPRINTF( fp, "\nUT Service RAT %u ",
                 pImsaSvcStatusInfo->pUTSvcRAT );

        fprintf( fp, "\n\n" );
    }

    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSSetIMSASvcStatusCallback
 *
 * Purpose: SLQSSetIMSASvcStatusCallback test function
 *
 **************/
package void doSetSLQSSetIMSASvcStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSASvcStatusCallback( &cbkTestSLQSSetIMSASvcStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetIMSASvcStatusCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetIMSASvcStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetIMSASvcStatusCallback
 *
 * Purpose: Clear the doSetSLQSSetIMSASvcStatusCallback API
 *
 **************/
package void doClearSLQSSetIMSASvcStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSASvcStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetIMSASvcStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetIMSASvcStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetIMSARatStatusCallback
 *
 * Purpose: SLQSSetIMSARatStatusCallback API callback function
 *
 **************/
local void cbkTestSLQSSetIMSARatStatusCallback(
    imsaRatStatusInfo *pImsaRatStatusInfo )
{
    FILE *fp;
    BYTE count=0;
    fp = tfopen("TestReport/SLQSSetIMSARatStatusCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetIMSARatStatusCallback");
    else
    {
        IFPRINTF( fp, "\nRAT Status %u ",
                 pImsaRatStatusInfo->pRATStatus );

        IFPRINTF( fp, "\nSource RAT %u ",
                 pImsaRatStatusInfo->pSrcRAT );

        IFPRINTF( fp, "\nTarget RAT %u ",
                 pImsaRatStatusInfo->pTgtRAT );

        if(pImsaRatStatusInfo->pErrorCodeStr)
        {
           fprintf(fp,"\nCause Code ");
            while(pImsaRatStatusInfo->pErrorCodeStr[count] != 0)
            {
                IFPRINTF( fp, "%c",
                            &pImsaRatStatusInfo->pErrorCodeStr[count] );
                count++;
             }
        }
        fprintf( fp, "\n\n" );
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSSetIMSARatStatusCallback
 *
 * Purpose: SLQSSetIMSARatStatusCallback test function
 *
 **************/
package void doSetSLQSSetIMSARatStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSARatStatusCallback( &cbkTestSLQSSetIMSARatStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetIMSARatStatusCallback: Failed : %u\r\n", rc );
    else
        printf( "SSLQSSetIMSARatStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetIMSARatStatusCallback
 *
 * Purpose: Clear the doSetSLQSSetIMSARatStatusCallback API
 *
 **************/
package void doClearSLQSSetIMSARatStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSARatStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetIMSARatStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetIMSARatStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSLQSSetIMSAPdpStatusCallback
 *
 * Purpose: SLQSSetIMSAPdpStatusCallback API callback function
 *
 **************/
local void cbkTestSLQSSetIMSAPdpStatusCallback(
        imsaPdpStatusInfo *pImsaPdpStatusInfo )
{
    FILE *fp;

    fp = tfopen("TestReport/SLQSSetIMSAPdpStatusCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSetIMSAPdpStatusCallback");
    else
    {
        fprintf( fp, "\nPDP Connection State %u ",
                 pImsaPdpStatusInfo->connetionState );

        IFPRINTF( fp, "\nPDP Failure Error Code %u ",
                 pImsaPdpStatusInfo->pFailErrorCode );

        fprintf( fp, "\n\n" );
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetSLQSSetIMSAPdpStatusCallback
 *
 * Purpose: SLQSSetIMSAPdpStatusCallback test function
 *
 **************/
package void doSetSLQSSetIMSAPdpStatusCallback( void )
{
    ULONG rc;
    rc = SLQSSetIMSAPdpStatusCallback( &cbkTestSLQSSetIMSAPdpStatusCallback );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "SLQSSetIMSAPdpStatusCallback: Failed : %u\r\n", rc );
    else
        printf( "SLQSSetIMSAPdpStatusCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetIMSAPdpStatusCallback
 *
 * Purpose: Clear the doSetSLQSSetIMSAPdpStatusCallback API
 *
 **************/
package void doClearSLQSSetIMSAPdpStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetIMSAPdpStatusCallback( NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetIMSAPdpStatusCallback: Failed : %u\n", rc );
    else
        printf( "doClearSLQSSetIMSAPdpStatusCallback: Disabled\n" );
}

/*************
 *
 * Name:    doSetSLQSNasSigInfo2CallBack
 *
 * Purpose: SLQSNasSigInfo2CallBack test function
 *
 **************/
package void doSetSLQSNasSigInfo2CallBack( void )
{
    ULONG         rc;
    WORD              cdmaRssiThreshList[2] = { -1020,-400 };/* -102dB, -40dB */
    BYTE              cdmaRssiThreshListlen = 0x02;
    CDMARSSIThresh    cdmaRssiThresh;

    WORD              cdmaEcioThreshList[2] = { -400, -310 }; /* -20dB, -15.5dB */
    BYTE              cdmaEcioThreshListLen = 0x02;
    CDMAECIOThresh    cdmaEcioThresh;

    WORD              hdrRssiThreshList[2] = { -500, -150 }; /* -50dB, -15dB */
    BYTE              hdrRssiThresListLen = 2;
    HDRRSSIThresh     hdrRssiThresh;

    WORD              hdrEcioThreshList[2] = { -400, -310 }; /* -20dB, -15.5dB */
    BYTE              hdrEcioThresListLen = 2;
    HDRECIOThresh     hdrEcioThresh;

    WORD              hdrSinrThreshList[2] = { 0x01, 0x03 }; /* -6dB, -3dB */
    BYTE              hdrSinrThresListLen = 2;
    HDRSINRThreshold  hdrSinrThresh;

    WORD              hdrIoThreshList[2] = { -1110, -730 }; /* -110dB, -73dB */
    BYTE              hdrIoThresListLen = 2;
    HDRIOThresh       hdrIoThresh;

    WORD              gsmRssiThreshList[2] = { -950, -800 }; /* -95dB, -80dB */
    BYTE              gsmRssiThresListLen = 2;
    GSMRSSIThresh     gsmRssiThresh;

    WORD              wcdmaRssiThreshList[2] = { -1000, -200 }; /* -100dB, -20dB */
    BYTE              wcdmaRssiThresListLen = 2;
    WCDMARSSIThresh   wcdmaRssiThresh;

    WORD              wcdmaEcioThreshList[2] = { -400, -310 }; /* -20dB, -15.5dB */
    BYTE              wcdmaEcioThresListLen = 2;
    WCDMAECIOThresh   wcdmaEcioThresh;

    WORD              lteRssiThreshList[2] = { -1000, -400 }; /* -100dB, -40dB */
    BYTE              lteRssiThresListLen = 2;
    LTERSSIThresh     lteRssiThresh;

    WORD              lteSnrThreshList[2] = { -198, -230 }; /* -19.8dB, 23dB */
    BYTE              lteSnrThresListLen = 2;
    LTESNRThreshold   lteSnrThresh;

    WORD              lteRsrqThreshList[2] = { -110, -60 }; /* -11dB, -6dB */
    BYTE              lteRsrqThresListLen = 2;
    LTERSRQThresh     lteRsrqThresh;

    WORD              lteRsrpThreshList[2] = { -1250, -640 }; /* -125dB, -64dB */
    BYTE              lteRsrpThresListLen = 2;
    LTERSRPThresh     lteRsrpThresh;

    WORD              tdscdmaRscpThreshList[2] = { -950, -800 }; /* -95dB, -80dB */
    BYTE              tdscdmaRscpThresListLen = 2;
    TDSCDMARSCPThresh tdscdmaRscpThresh;

    float             tdscdmaRssiThreshList[2] = { -950, -800 }; /* -95dB, -80dB */
    BYTE              tdscdmaRssiThresListLen = 2;
    TDSCDMARSSIThresh tdscdmaRssiThresh;

    float             tdscdmaEcioThreshList[2] = { -400, -310 }; /* -20dB, -15.5dB */
    BYTE              tdscdmaEcioThresListLen = 2;
    TDSCDMAECIOThresh tdscdmaEcioThresh;

    float             tdscdmaSinrThreshList[2] = { 0x01, 0x03 };
    BYTE              tdscdmaSinrThresListLen = 2;
    TDSCDMASINRThresh tdscdmaSinrThresh;

    BYTE                rptRate = 2;
    BYTE                avgPeriod = 2;
    LTESigRptConfig     lteSigRptCfg;

    BYTE                       lCtr = 0;
    setSignalStrengthInfo      req;

    /* Assign request parameters */
    cdmaRssiThresh.CDMARSSIThreshListLen = cdmaRssiThreshListlen;
    cdmaRssiThresh.pCDMARSSIThreshList   = cdmaRssiThreshList;
    req.pCDMARSSIThresh                  = &cdmaRssiThresh;

    cdmaEcioThresh.CDMAECIOThreshListLen = cdmaEcioThreshListLen;
    cdmaEcioThresh.pCDMAECIOThreshList   = cdmaEcioThreshList;
    req.pCDMAECIOThresh                  = &cdmaEcioThresh;

    hdrRssiThresh.HDRRSSIThreshListLen   = hdrRssiThresListLen;
    hdrRssiThresh.pHDRRSSIThreshList     = hdrRssiThreshList;
    req.pHDRRSSIThresh                   = &hdrRssiThresh;

    hdrEcioThresh.HDRECIOThreshListLen   = hdrEcioThresListLen;
    hdrEcioThresh.pHDRECIOThreshList     = hdrEcioThreshList;
    req.pHDRECIOThresh                   = &hdrEcioThresh;

    hdrSinrThresh.HDRSINRThreshListLen   = hdrSinrThresListLen;
    hdrSinrThresh.pHDRSINRThreshList     = hdrSinrThreshList;
    req.pHDRSINRThresh                   = &hdrSinrThresh;

    hdrIoThresh.HDRIOThreshListLen       = hdrIoThresListLen;
    hdrIoThresh.pHDRIOThreshList         = hdrIoThreshList;
    req.pHDRIOThresh                     = &hdrIoThresh;

    gsmRssiThresh.GSMRSSIThreshListLen   = gsmRssiThresListLen;
    gsmRssiThresh.pGSMRSSIThreshList     = gsmRssiThreshList;
    req.pGSMRSSIThresh                   = &gsmRssiThresh;

    wcdmaRssiThresh.WCDMARSSIThreshListLen   = wcdmaRssiThresListLen;
    wcdmaRssiThresh.pWCDMARSSIThreshList     = wcdmaRssiThreshList;
    req.pWCDMARSSIThresh                     = &wcdmaRssiThresh;

    wcdmaEcioThresh.WCDMAECIOThreshListLen   = wcdmaEcioThresListLen;
    wcdmaEcioThresh.pWCDMAECIOThreshList     = wcdmaEcioThreshList;
    req.pWCDMAECIOThresh                     = &wcdmaEcioThresh;

    lteRssiThresh.LTERSSIThreshListLen   = lteRssiThresListLen;
    lteRssiThresh.pLTERSSIThreshList     = lteRssiThreshList;
    req.pLTERSSIThresh                   = &lteRssiThresh;

    lteSnrThresh.LTESNRThreshListLen   = lteSnrThresListLen;
    lteSnrThresh.pLTESNRThreshList     = lteSnrThreshList;
    req.pLTESNRThresh                  = &lteSnrThresh;

    lteRsrqThresh.LTERSRQThreshListLen   = lteRsrqThresListLen;
    lteRsrqThresh.pLTERSRQThreshList     = lteRsrqThreshList;
    req.pLTERSRQThresh                  = &lteRsrqThresh;

    lteRsrpThresh.LTERSRPThreshListLen = lteRsrpThresListLen;
    lteRsrpThresh.pLTERSRPThreshList   = lteRsrpThreshList;
    req.pLTERSRPThresh                 = &lteRsrpThresh;

    tdscdmaRscpThresh.TDSCDMARSCPThreshListLen = tdscdmaRscpThresListLen;
    tdscdmaRscpThresh.pTDSCDMARSCPThreshList   = tdscdmaRscpThreshList;
    req.pTDSCDMARSCPThresh                     = &tdscdmaRscpThresh;

    tdscdmaRssiThresh.TDSCDMARSSIThreshListLen = tdscdmaRssiThresListLen;
    tdscdmaRssiThresh.pTDSCDMARSSIThreshList   = (ULONG*)tdscdmaRssiThreshList;
    req.pTDSCDMARSSIThresh                     = &tdscdmaRssiThresh;

    tdscdmaEcioThresh.TDSCDMAECIOThreshListLen = tdscdmaEcioThresListLen;
    tdscdmaEcioThresh.pTDSCDMAECIOThreshList   = (ULONG*)tdscdmaEcioThreshList;
    req.pTDSCDMAECIOThresh                     = &tdscdmaEcioThresh;

    tdscdmaSinrThresh.TDSCDMASINRThreshListLen = tdscdmaSinrThresListLen;
    tdscdmaSinrThresh.pTDSCDMASINRThreshList   = (ULONG*)tdscdmaSinrThreshList;
    req.pTDSCDMASINRThresh                     = &tdscdmaSinrThresh;

    lteSigRptCfg.rptRate   = rptRate;
    lteSigRptCfg.avgPeriod = avgPeriod;
    req.pLTESigRptConfig   = &lteSigRptCfg;

        req.pCDMARSSIDelta    = NULL;
        req.pCDMAECIODelta    = NULL;
        req.pHDRRSSIDelta     = NULL;
        req.pHDRECIODelta     = NULL;
        req.pHDRSINRDelta     = NULL;
        req.pHDRIODelta       = NULL;
        req.pGSMRSSIDelta     = NULL;
        req.pWCDMARSSIDelta   = NULL;
        req.pWCDMAECIODelta   = NULL;
        req.pLTERSSIDelta     = NULL;
        req.pLTESNRDelta      = NULL;
        req.pLTERSRQDelta     = NULL;
        req.pLTERSRPDelta     = NULL;
        req.pTDSCDMARSCPDelta = NULL;
        req.pTDSCDMARSSIDelta = NULL;
        req.pTDSCDMAECIODelta = NULL;
        req.pTDSCDMASINRDelta = NULL;

    fprintf( stderr, "Parameter Set:\n" );
    if(req.pCDMARSSIThresh)
    {
        fprintf( stderr, "\nCDMA RSSI Threshold list\n");
        fprintf( stderr, "CDMA RSSI Threshold list length: %d\n", cdmaRssiThresh.CDMARSSIThreshListLen );
        for( lCtr=0; lCtr < cdmaRssiThresh.CDMARSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "CDMA RSSI Threshold [0x%x]: %d\n", lCtr, (short)cdmaRssiThreshList[lCtr] );
        }
    }
    if(req.pCDMAECIOThresh)
    {
        fprintf( stderr, "\nCDMA ECIO Threshold list\n");
        fprintf( stderr, "CDMA ECIO Threshold list length: %d\n", cdmaEcioThresh.CDMAECIOThreshListLen );
        for( lCtr=0; lCtr < cdmaEcioThresh.CDMAECIOThreshListLen; lCtr++ )
        {
            fprintf( stderr, "CDMA ECIO Threshold [%d]: %d\n", lCtr, (short)cdmaEcioThreshList[lCtr] );
        }
    }
    if(req.pHDRRSSIThresh)
    {
        fprintf( stderr, "\nHDR RSSI Threshold list\n");
        fprintf( stderr, "HDR RSSI Threshold list length: %d\n", hdrRssiThresh.HDRRSSIThreshListLen );
        for( lCtr=0; lCtr < hdrRssiThresh.HDRRSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "HDR RSSI Threshold [%d]: %d\n", lCtr, (short)hdrRssiThreshList[lCtr] );
        }
    }
    if(req.pHDRECIOThresh)
    {
        fprintf( stderr, "\nHDR ECIO Threshold list\n");
        fprintf( stderr, "HDR ECIO Threshold list length: %d\n", hdrEcioThresh.HDRECIOThreshListLen );
        for( lCtr=0; lCtr < hdrEcioThresh.HDRECIOThreshListLen; lCtr++ )
        {
            fprintf( stderr, "HDR ECIO Threshold [%d]: %d\n", lCtr, (short)hdrEcioThreshList[lCtr] );
        }
    }
    if(req.pHDRSINRThresh)
    {
        fprintf( stderr, "\nHDR SINR Threshold list\n");
        fprintf( stderr, "HDR SINR Threshold list length: %d\n", hdrSinrThresh.HDRSINRThreshListLen );
        for( lCtr=0; lCtr < hdrSinrThresh.HDRSINRThreshListLen; lCtr++ )
        {
            fprintf( stderr, "HDR SINR Threshold [%d]: %d\n", lCtr, (short)hdrSinrThreshList[lCtr] );
        }
    }
    if(req.pHDRIOThresh)
    {
        fprintf( stderr, "\nHDR IO Threshold list\n");
        fprintf( stderr, "HDR IO Threshold list length: %d\n", hdrIoThresh.HDRIOThreshListLen );
        for( lCtr=0; lCtr < hdrIoThresh.HDRIOThreshListLen; lCtr++ )
        {
            fprintf( stderr, "HDR IO [%d]: %d\n", lCtr, (short)hdrIoThreshList[lCtr] );
        }
    }
    if(req.pGSMRSSIThresh)
    {
        fprintf( stderr, "\nGSM RSSI Threshold list\n");
        fprintf( stderr, "GSM RSSI Threshold list length: %d\n", gsmRssiThresh.GSMRSSIThreshListLen );
        for( lCtr=0; lCtr < gsmRssiThresh.GSMRSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "CDMA ECIO Threshold [%d]: %d\n", lCtr, (short)gsmRssiThreshList[lCtr] );
        }
    }
    if(req.pWCDMARSSIThresh)
    {
        fprintf( stderr, "\nWCDMA RSSI Threshold list\n");
        fprintf( stderr, "WCDMA RSSI Threshold list length: %d\n", wcdmaRssiThresh.WCDMARSSIThreshListLen );
        for( lCtr=0; lCtr < wcdmaRssiThresh.WCDMARSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "WCDMA RSSI Threshold [%d]: %d\n", lCtr, (short)wcdmaRssiThreshList[lCtr] );
        }
    }
    if(req.pWCDMAECIOThresh)
    {
        fprintf( stderr, "\nWCDMA ECIO Threshold list\n");
        fprintf( stderr, "WCDMA ECIO Threshold list length: %d\n", wcdmaEcioThresh.WCDMAECIOThreshListLen );
        for( lCtr=0; lCtr < wcdmaEcioThresh.WCDMAECIOThreshListLen; lCtr++ )
        {
            fprintf( stderr, "WCDMA ECIO Threshold [%d]: %d\n", lCtr, (short)wcdmaEcioThreshList[lCtr] );
        }
    }
    if(req.pLTERSSIThresh)
    {
        fprintf( stderr, "\nLTE RSSI Threshold list\n");
        fprintf( stderr, "LTE RSSI Threshold list length: %d\n", lteRssiThresh.LTERSSIThreshListLen );
        for( lCtr=0; lCtr < lteRssiThresh.LTERSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "LTE RSSI Threshold [%d]: %d\n", lCtr, (short)lteRssiThreshList[lCtr] );
        }
    }
    if(req.pLTESNRThresh)
    {
        fprintf( stderr, "\nLTE SNR Threshold list\n");
        fprintf( stderr, "LTE SNR Threshold list length: %d\n", lteSnrThresh.LTESNRThreshListLen );
        for( lCtr=0; lCtr < lteSnrThresh.LTESNRThreshListLen; lCtr++ )
        {
            fprintf( stderr, "LTE SNR Threshold [%d]: %d\n", lCtr, (short)lteSnrThreshList[lCtr] );
        }
    }
    if(req.pLTERSRQThresh)
    {
        fprintf( stderr, "\nLTE RSRQ Threshold list\n");
        fprintf( stderr, "LTE RSRQ Threshold list length: %d\n", lteRsrqThresh.LTERSRQThreshListLen );
        for( lCtr=0; lCtr < lteRsrqThresh.LTERSRQThreshListLen; lCtr++ )
        {
            fprintf( stderr, "LTE RSRQ Threshold [%d]: %d\n", lCtr, (short)lteRsrqThreshList[lCtr] );
        }
    }
    if(req.pLTERSRPThresh)
    {
        fprintf( stderr, "\nLTE RSRP Threshold list\n");
        fprintf( stderr, "LTE RSRP Threshold list length: %d\n", lteRsrpThresh.LTERSRPThreshListLen );
        for( lCtr=0; lCtr < lteRsrpThresh.LTERSRPThreshListLen; lCtr++ )
        {
            fprintf( stderr, "LTE RSRP Threshold [%d]: %d\n", lCtr, (short)lteRsrpThreshList[lCtr] );
        }
    }
    if(req.pTDSCDMARSCPThresh)
    {
        fprintf( stderr, "\nTDSCDMA RSCP Threshold list\n");
        fprintf( stderr, "TDSCDMA RSCP Threshold list length: %d\n", tdscdmaRscpThresh.TDSCDMARSCPThreshListLen );
        for( lCtr=0; lCtr < tdscdmaRscpThresh.TDSCDMARSCPThreshListLen; lCtr++ )
        {
            fprintf( stderr, "TDSCDMA RSCP Threshold [%d]: %d\n", lCtr, (short)tdscdmaRscpThreshList[lCtr] );
        }
    }
    if(req.pTDSCDMARSSIThresh)
    {
        fprintf( stderr, "\nTDSCDMA RSSI Threshold list\n");
        fprintf( stderr, "TDSCDMA RSSI Threshold list length: %d\n", tdscdmaRssiThresh.TDSCDMARSSIThreshListLen );
        for( lCtr=0; lCtr < tdscdmaRssiThresh.TDSCDMARSSIThreshListLen; lCtr++ )
        {
            fprintf( stderr, "TDSCDMA RSSI Threshold [%d]: %f\n", lCtr, (float)tdscdmaRssiThreshList[lCtr] );
        }
    }
    if(req.pTDSCDMAECIOThresh)
    {
        fprintf( stderr, "\nTDSCDMA ECIO Threshold list\n");
        fprintf( stderr, "TDSCDMA ECIO Threshold list length: %d\n", tdscdmaEcioThresh.TDSCDMAECIOThreshListLen );
        for( lCtr=0; lCtr < tdscdmaEcioThresh.TDSCDMAECIOThreshListLen; lCtr++ )
        {
            fprintf( stderr, "TDSCDMA ECIO Threshold [%d]: %f\n", lCtr, (float)tdscdmaEcioThreshList[lCtr] );
        }
    }
    if(req.pTDSCDMASINRThresh)
    {
        fprintf( stderr, "\nTDSCDMA SINR Threshold list\n");
        fprintf( stderr, "TDSCDMA SINR Threshold list length: %d\n", tdscdmaSinrThresh.TDSCDMASINRThreshListLen );
        for( lCtr=0; lCtr < tdscdmaSinrThresh.TDSCDMASINRThreshListLen; lCtr++ )
        {
            fprintf( stderr, "TDSCDMA SINR Threshold [%d]: %f\n", lCtr, (float)tdscdmaSinrThreshList[lCtr] );
        }
    }

    rc = SLQSNasSigInfo2CallBack( &cbkTestSLQSNasSigInfoCallBack, &req );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSNasSigInfo2CallBack: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSNasSigInfo2CallBack: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSNasSigInfo2CallBack
 *
 * Purpose: Clear the doClearSLQSNasSigInfo2CallBack API
 *
 **************/
package void doClearSLQSNasSigInfo2CallBack( void )
{
    ULONG rc;

    rc = SLQSNasSigInfo2CallBack( NULL, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSNasSigInfo2CallBack: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearSLQSNasSigInfo2CallBack: Disabled\n" );
}

/*************
 *
 * Name:    cbkTestSetLocGnssSvInfoCallback
 *
 * Purpose: SetLocSensorStreamingCallback API callback function
 *
 **************/
local void cbkTestSetLocGnssSvInfoCallback( gnssSvInfoNotification *pMsg)
{
    FILE *fp;
    BYTE i;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocGnssSvInfoCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocGnssSvInfoCallback");
    else
    {
        fprintf(fp, "\nLoc GNSS SV Info:\n");
        fprintf(fp, "Altitude Assumed:%d\n", pMsg->bAltitudeAssumed);
        if (pMsg->pSatelliteInfo != NULL)
        {
            fprintf(fp, "\nLoc Satellite Info:\n");
            fprintf(fp, "\nNumber of sets of the following elements: %d\n", pMsg->pSatelliteInfo->svListLen);
            for ( i = 0; i < pMsg->pSatelliteInfo->svListLen; i++ )
            {
                fprintf(fp, "\nInstance[%d]\n", i);
                fprintf( fp, "Valid Mask: 0x%08x\n", pMsg->pSatelliteInfo[i].validMask);
                fprintf( fp, "System: %u\n", pMsg->pSatelliteInfo[i].system);
                fprintf( fp, "GNSS SV ID: %d\n", pMsg->pSatelliteInfo[i].gnssSvId);
                fprintf( fp, "Health Status: %d\n", pMsg->pSatelliteInfo[i].healthStatus);
                fprintf( fp, "SV Status: %u\n", pMsg->pSatelliteInfo[i].svStatus);
                fprintf( fp, "SV Info Mask: %d\n", pMsg->pSatelliteInfo[i].svInfoMask);
                fprintf( fp, "Elevation: %f\n", pMsg->pSatelliteInfo[i].elevation);
                fprintf( fp, "Azimuth: %f\n", pMsg->pSatelliteInfo[i].azimuth);
                fprintf( fp, "SNR: %f\n", pMsg->pSatelliteInfo[i].snr);
            }
        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    dosetLocGnssSvInfoCallback
 *
 * Purpose: Set the SetLocGnssSvInfoCallback API
 *
 **************/
package void doSetLocGnssSvInfoCallback(void)
{
    ULONG rc;
    rc = SetLocGnssSvInfoCallback(  &cbkTestSetLocGnssSvInfoCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "dosetLocGnssSvInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "dosetLocGnssSvInfoCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocGnssSvInfoCallback
 *
 * Purpose: Clear the SetLocGnssSvInfoCallback API
 *
 **************/
package void doClearLocGnssSvInfoCallback(void)
{
    ULONG rc;
    rc = SetLocGnssSvInfoCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocGnssSvInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocGnssSvInfoCallback: Disabled callback\r\n" );

}

local void cbkTestSetLocOpModeCallback( ULONG mode )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocOpModeCallback.txt", "a");
    if ( fp == NULL )
    {
        perror("cbkTestSetLocOpModeCallback");
    }
    else
    {
        fprintf(fp, "\nIndication: Loc Operating Mode: %d\n", mode);
        tfclose(fp);
    }
}

package void doSetLocOpModeCallback(void)
{
    ULONG rc;
    rc = SetLocOpModeCallback(  &cbkTestSetLocOpModeCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "%s: Failed : %u\r\n", __func__, rc );
    else
        fprintf( stderr, "%s: Enabled callback\r\n", __func__ );

}

/*************
 *
 * Name:    doClearLocOpModeCallback
 *
 * Purpose: Clear the SetLocOpModeCallback API
 *
 **************/
package void doClearLocOpModeCallback(void)

{
    ULONG rc;
    rc = SetLocOpModeCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocOpModeCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocOpModeCallback: Disabled callback\r\n" );

}

local void cbkTestSetLocDeleteAssistDataCallback( delAssistDataStatus *pStatus )
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocDeleteAssistDataCallback.txt", "a");
    if ( fp == NULL )
    {
        perror("cbkTestSetLocDeleteAssistDataCallback");
    }
    else
    {
        fprintf(fp, "\nIndication: Delete Assist Data Status: %d\n", pStatus->status);
        tfclose(fp);
    }
}

package void doSetLocDeleteAssistDataCallback(void)
{
    ULONG rc;
    rc = SetLocDeleteAssistDataCallback(  &cbkTestSetLocDeleteAssistDataCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "%s: Failed : %u\r\n", __func__, rc );
    else
        fprintf( stderr, "%s: Enabled callback\r\n", __func__ );

}

/*************
 *
 * Name:    doClearLocDeleteAssistDataCallback
 *
 * Purpose: Clear the SetLocDeleteAssistDataCallback API
 *
 **************/
package void doClearLocDeleteAssistDataCallback(void)

{
    ULONG rc;
    rc = SetLocDeleteAssistDataCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocDeleteAssistDataCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocDeleteAssistDataCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestNasLLteCphyCaCallback
 *
 * Purpose: SetNasLTECphyCaIndCallback API callback function
 *
 **************/
local void cbkTestNasLLteCphyCaCallback( QmiCbkNasLTECphyCaInfo *pMsg)
{
    FILE *fp;
    BYTE i=0;
    UNUSEDPARAM(i);
    UNUSEDPARAM(pMsg);
    fp = tfopen("../../cbk/test/results/cbkTestNasLLteCphyCaCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestNasLLteCphyCaCallback");
    else
    {
        fprintf(fp, "\nNasLLteCphyCa Info:\n");
        if(pMsg->sPhyCaAggScellIndType.TlvPresent)
        {
            fprintf(fp, "\nScell Indicator Type\n");
            fprintf(fp, "\tPhysical Cell ID %d\n",pMsg->sPhyCaAggScellIndType.pci);
            fprintf(fp, "\tFrequency %d\n",pMsg->sPhyCaAggScellIndType.freq);
            fprintf(fp, "\tScell State %d\n",pMsg->sPhyCaAggScellIndType.scell_state);
        }

        if(pMsg->sPhyCaAggScellDlBw.TlvPresent)
        {
            fprintf(fp, "\nDownlink Bandwidth for Scell %d\n",pMsg->sPhyCaAggScellDlBw.dl_bw_value);
        }

        
        if(pMsg->sPhyCaAggScellInfo.TlvPresent)
        {
            fprintf(fp, "\nScell Information\n");
            fprintf(fp, "\tPhysical Cell ID %d\n",pMsg->sPhyCaAggScellInfo.pci);
            fprintf(fp, "\tFrequency %d\n",pMsg->sPhyCaAggScellInfo.freq);
            fprintf(fp, "\tDownlink Bandwidth %d\n",pMsg->sPhyCaAggScellInfo.dl_bw_value);
            fprintf(fp, "\tLTE Band %d\n",pMsg->sPhyCaAggScellInfo.iLTEbandValue);
            fprintf(fp, "\tScell State %d\n",pMsg->sPhyCaAggScellInfo.scell_state);
        }

        if(pMsg->sPhyCaAggPcellInfo.TlvPresent)
        {
            fprintf(fp, "\nPcell Information\n");
            fprintf(fp, "\tPhysical Cell ID %d\n",pMsg->sPhyCaAggPcellInfo.pci);
            fprintf(fp, "\tDownlink Bandwidth %d\n",pMsg->sPhyCaAggPcellInfo.dl_bw_value);
            fprintf(fp, "\tFrequency %d\n",pMsg->sPhyCaAggPcellInfo.freq);
            fprintf(fp, "\tLTE Band %d\n",pMsg->sPhyCaAggPcellInfo.iLTEbandValue);
        }

         if(pMsg->sPhyCaAggScellIndex.TlvPresent)
        {
            fprintf(fp, "\nScell Index : %02X\n",pMsg->sPhyCaAggScellIndex.scell_idx);
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetNasLTECphyCaIndCallback
 *
 * Purpose: Set the SetNasLTECphyCaIndCallback API
 *
 **************/
package void doSetNasLTECphyCaIndCallback(void)
{
    ULONG rc;
    rc = SetNasLTECphyCaIndCallback(  &cbkTestNasLLteCphyCaCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetNasLTECphyCaIndCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetNasLTECphyCaIndCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearNasLTECphyCaIndCallback
 *
 * Purpose: Clear the SetNasLTECphyCaIndCallback API
 *
 **************/
package void doClearNasLTECphyCaIndCallback(void)
{
    ULONG rc;
    rc = SetNasLTECphyCaIndCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearNasLTECphyCaIndCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearNasLTECphyCaIndCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSetRankIndicatorCallbackCB
 *
 * Purpose: SetRankIndicatorCallback API callback function
 *
 *
 * Return:  none
 *
 * Abort:   none
 *
 * Notes:
 *
 **************/
local void cbkTestSetRankIndicatorCallbackCB(RankIndicatorInd *pMsg)

{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/SetRankIndicatorCallback.txt", "a");

    if ( fp == NULL )
    {
        perror("cbkTestSetRankIndicatorCallbackCB");
        return;
    }
    fprintf(stderr,"\ncbkTestSetRankIndicatorCallbackCB : \n");
    if(pMsg!=NULL)
    {
        fprintf( stderr,
                    "\tcount1:%d\n",pMsg->Count1);
        fprintf( stderr,
                    "\tcount2:%d\n",pMsg->Count2);
    }
    else
    {
        fprintf( stderr,
                    "\tNULL\n");
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetRankIndicatorCallback
 *
 * Purpose: Set the SetRankIndicatorCallback API
 *
 **************/
 package void doSetRankIndicatorCallback( void )
{
    ULONG rc;

    rc = SetRankIndicatorCallback(&cbkTestSetRankIndicatorCallbackCB );

    if ( rc != eQCWWAN_ERR_NONE )
    {
        fprintf( stderr,
                "\ndoSetRankIndicatorCallback: failed to enable callback\n" );
    }
    else
    {
        fprintf( stderr, "\ndoSetRankIndicatorCallback:\
                          enable callback(cbkTestSetRankIndicatorCallbackCB)\n" );
    }
}

/*************
 *
 * Name:    doClearRankIndicatorCallback
 *
 * Purpose: Clear the SetRankIndicatorCallback API
 *
 **************/
package void doClearRankIndicatorCallback(void)
{
    ULONG rc;
    rc = SetRankIndicatorCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearRankIndicatorCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearRankIndicatorCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSlotStatusChangeCallback
 *
 * Purpose: SetUimSlotStatusChangeCallback API callback function
 *
 **************/
local void cbkTestSlotStatusChangeCallback(
    UIMSlotStatusChangeInfo *pUIMSlotStatusChangeInfo  )
{
    FILE *fp = NULL;

    fp = tfopen("TestReport/SLQSSlotStatusChangeCallback.txt", "a");

    if ( fp == NULL )
        perror("cbkTestSLQSSlotStatusChangeCallback");
    else
    {
        int i = 0;
        int slotcount = 0;
        fprintf(fp,"NumberOfPhySlots:%d\n",pUIMSlotStatusChangeInfo->bNumberOfPhySlots);
        
        for(slotcount=0;slotcount<pUIMSlotStatusChangeInfo->bNumberOfPhySlots;slotcount++)
        {
            fprintf(fp,"Slot:%d\n",slotcount+1);
            fprintf(fp,"\tPhysical Card Status:%u\n",pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].uPhyCardStatus);
            fprintf(fp,"\tPhysical Slot Status:%u\n",pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].uPhySlotStatus);
            fprintf(fp,"\tLogicalSlot:%d\n",pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].bLogicalSlot);
            fprintf(fp,"\tICCIDLength:%d\n",pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].bICCIDLength);
            fprintf(fp,"\tICCID: ");
            for(i=0;i<pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].bICCIDLength;i++)
                fprintf(fp,"0x%02X ",pUIMSlotStatusChangeInfo->slotsstatusChange.uimSlotStatus[slotcount].bICCID[i]);
            fprintf( fp, "\n" );
        }
        fprintf( fp, "\n\n" );
    }
    tfclose(fp);
}

/*************
 *
 * Name:    doSetUIMSlotStatusChangeCallback
 *
 * Purpose: Set the SetUimSlotStatusChangeCallback API
 *
 **************/
package void doSetUIMSlotStatusChangeCallback(void)
{
    ULONG rc;
    FILE                *fp = NULL;
    
    fp = tfopen( "../../loc/test/results/slqsuimslotstatuschangeind.txt", "w" );
    if ( fp )
    {
        rc = SetUimSlotStatusChangeCallback( &cbkTestSlotStatusChangeCallback );
        if ( rc != eQCWWAN_ERR_NONE )
            fprintf( stderr, "doSetUIMSlotStatusChange: Failed : %u\r\n", rc );
        else
            printf( "doSetUIMSlotStatusChange: Enabled callback\r\n" );
    }
    if (fp)
        tfclose(fp);
}

/*************
 *
 * Name:    doClearUIMSlotStatusChangeCallback
 *
 * Purpose: Clear the SetUimSlotStatusChangeCallback API
 *
 **************/
package void doClearUIMSlotStatusChangeCallback(void)
{
    ULONG rc;
    FILE                *fp = NULL;
    
    fp = tfopen( "../../loc/test/results/slqsuimslotstatuschangeind.txt", "w" );
    if ( fp )
    {
        rc = SetUimSlotStatusChangeCallback( NULL );
        if ( rc != eQCWWAN_ERR_NONE )
            fprintf( stderr, "doSLQSSClearUIMSlotStatusChange: Failed : %u\r\n", rc );
        else
            printf( "doSLQSSClearUIMSlotStatusChange: Cleared callback\r\n" );
    }
    if (fp)
        tfclose(fp);
}

/*************
 *
 * Name:    cbkTestSetLocEngineStateCallback
 *
 * Purpose: SetLocEngineStateCallback API callback function
 *
 **************/
local void cbkTestSetLocEngineStateCallback( QmiCbkLocEngineStateInd *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSetLocEngineStateCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetLocEngineStateCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf( fp, "\nLOC Engine State: %d\n",
                         pMsg->engineState);

        }

        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetLocEngineStateCallback
 *
 * Purpose: Set the SetLocEngineStateCallback API
 *
 **************/
package void doSetLocEngineStateCallback(void)

{
    ULONG rc;
    rc = SetLocEngineStateCallback( &cbkTestSetLocEngineStateCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetLocEngineStateCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetLocEngineStateCallback: Enabled callback\r\n" );

}

/*************
 *
 * Name:    doClearLocEngineStateCallback
 *
 * Purpose: Clear the SetLocEngineStateCallback API
 *
 **************/
package void doClearLocEngineStateCallback(void)

{
    ULONG rc;
    rc = SetLocEngineStateCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearLocEngineStateCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearLocEngineStateCallback: Disabled callback\r\n" );

}

/*************
 *
 * Name:    cbkTestSLQSSetSwiGetResetInfoCallback
 *
 * Purpose: SetSLQSSetSwiGetResetInfoCallback API callback function
 *
 **************/
local void cbkTestSLQSSetSwiGetResetInfoCallback( ResetInfoNotification *pMsg)
{
    FILE *fp;

    fp = tfopen("../../cbk/test/results/cbkTestSLQSSetSwiGetResetInfoCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSLQSSetSwiGetResetInfoCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf( fp, "\ntype : %d\n", pMsg->type);
            fprintf( fp, "source : %d\n", pMsg->source);
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetSLQSSetSwiGetResetInfoCallback
 *
 * Purpose: Set the SLQSSetSwiGetResetInfoCallback API
 *
 **************/
package void doSetSLQSSetSwiGetResetInfoCallback(void)

{
    ULONG rc;
    rc = SLQSSetSwiGetResetInfoCallback( &cbkTestSLQSSetSwiGetResetInfoCallback);
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetSLQSSetSwiGetResetInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetSLQSSetSwiGetResetInfoCallback: Enabled callback\r\n" );
}

/*************
 *
 * Name:    doClearSLQSSetSwiGetResetInfoCallback
 *
 * Purpose: Clear the SLQSSetSwiGetResetInfoCallback API
 *
 **************/
package void doClearSLQSSetSwiGetResetInfoCallback(void)

{
    ULONG rc;
    rc = SLQSSetSwiGetResetInfoCallback(  NULL );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearSLQSSetSwiGetResetInfoCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doClearSLQSSetSwiGetResetInfoCallback: Disabled callback\r\n" );
}

/*************
 *
 * Name:    cbkTestSetDHCPv4ClientLeaseStatusCallback
 *
 * Purpose: SetDHCPv4ClientLeaseStatusCallback API callback function
 *
 **************/
local void cbkTestSetDHCPv4ClientLeaseStatusCallback( BYTE instance, WdsDHCPv4ClientLeaseInd *pMsg)
{
    FILE *fp;
    swi_uint8 i,j;
    CHAR bufIPAddress[MAX_SIZE_IP] = {0};
    DHCPOption *pOption = NULL;

    fp = tfopen("../../cbk/test/results/cbkTestSetDHCPv4ClientLeaseStatusCallback.txt", "a");
    if ( fp == NULL )
        perror("cbkTestSetDHCPv4ClientLeaseStatusCallback");
    else
    {
        if (pMsg != NULL)
        {
            fprintf ( fp, "Instance: %d\n", instance );
            if(pMsg->pProfileId != NULL)
            {
                fprintf ( fp, "Profile type: %d\n", pMsg->pProfileId->profileType );
                fprintf ( fp, "Profile id: %d\n", pMsg->pProfileId->profileId );
            }
            if(pMsg->pLeaseState != NULL)
                fprintf ( fp, "Lease state: %d\n", *pMsg->pLeaseState );
            if(pMsg->pIPv4Addr != NULL)
            {
                UlongToDotIP( *pMsg->pIPv4Addr, bufIPAddress );
                fprintf ( fp, "IPv4 address: %s\n", bufIPAddress );
            }
            if(pMsg->pOptList != NULL)
            {
                fprintf ( fp, "Num lease options: %d\n", pMsg->pOptList->numOpt );
                fprintf ( fp, "Lease options:\n" );
                for (i=0; i < pMsg->pOptList->numOpt; i++)
                {
                    pOption = pMsg->pOptList->pOptions + i;
                    fprintf ( fp, "%2d  ", pOption->optCode);
                    for (j=0; j < pOption->optValLen; j++)
                    {
                        fprintf ( fp, "%02X", *(pOption->pOptVal + j) );
                    }
                    fprintf ( fp, "\n" );
                }
            }
            fprintf ( fp, "\n" );
        }
        tfclose(fp);
    }
}

/*************
 *
 * Name:    doSetDHCPv4ClientLeaseCallback
 *
 * Purpose: Set the SetDHCPv4ClientLeaseStatusCallback API
 *
 **************/
package void doSetDHCPv4ClientLeaseStatusCallback(void)

{
    ULONG rc;
    rc = SLQSSetDHCPv4ClientLeaseStatusCallback( 0, &cbkTestSetDHCPv4ClientLeaseStatusCallback );
    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doSetDHCPv4ClientLeaseCallback: Failed : %u\r\n", rc );
    else
        fprintf( stderr, "doSetDHCPv4ClientLeaseCallback: Enabled callback\r\n" );
    
}

/*************
 *
 * Name:    doClearRMTransferStatisticsCallBack
 *
 * Purpose: Clear the ClearDHCPv4ClientLeaseStatusCallback API
 *
 **************/
package void doClearDHCPv4ClientLeaseStatusCallback( void )
{
    ULONG rc;

    rc = SLQSSetDHCPv4ClientLeaseStatusCallback( 0, NULL );

    if ( rc != eQCWWAN_ERR_NONE )
        fprintf( stderr, "doClearDHCPv4ClientLeaseCallback: Failed : %u\n", rc );
    else
        fprintf( stderr, "doClearDHCPv4ClientLeaseCallback: Disabled\n" );
}

