/**************
 *
 *  Filename: qaGobiApiImsaTest.h
 *
 *  Purpose:  Contains prototypes for functions implementing specific
 *            tests for Imsa Service
 *            called by the main() routine in qatest.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc., all rights reserved
 *
 **************/

#ifndef __GOBI_API_IMSA_TEST_H__
#define __GOBI_API_IMSA_TEST_H__

#define MAXBYTE  0xFF
#define MAXWORD  0xFFFF
#define MAXULONG 0xFFFFFFFF

typedef struct _SLQSIMSAIndRegisterTestCase_t
{
    enum eQCWWANError expectedReturnValue;
    ULONG             testCaseId;
    BYTE              *pRegStatusConfig;
    BYTE              *pSvcStatusConfig;
    BYTE              *pRatStatusConfig;
    BYTE              *pPdpStatusConfig;
    CHAR              desc[100];
} SLQSIMSAIndRegisterTestCase_t;


typedef struct _SLQSIMSASupportedMsgTestCase_t
{
    enum eQCWWANError expectedReturnValue;
    ULONG             testCaseId;
    IMSASupportedMsgInfo *pIMSASupportedMsgInfo;
    CHAR              desc[100];
} SLQSIMSASupportedMsgTestCase_t;

typedef struct _SLQSIMSASupportedFieldsTestCase_t
{
    enum eQCWWANError       expectedReturnValue;
    ULONG                   testCaseId;
    WORD                    messageID;
    IMSASupportedFieldsResp *pIMSASupportedFieldsResp;
    CHAR                    desc[100];
} SLQSIMSASupportedFieldsTestCase_t;

typedef struct _SLQSIMSARegtrationStatusTestCase_t
{
    enum eQCWWANError       expectedReturnValue;
    ULONG                   testCaseId;
    IMSARegistrationStatus *pIMSARegistrationStatus;
    CHAR                    desc[100];
} SLQSIMSARegtrationStatusTestCase_t;

typedef struct _SLQSIMSAServiceStatusTestCase_t
{
    enum eQCWWANError       expectedReturnValue;
    ULONG                   testCaseId;
    IMSAServiceStatus       *pIMSAServiceStatus;
    CHAR                    desc[100];
} SLQSIMSAServiceStatusTestCase_t;

#endif /* __GOBI_API_IMSA_TEST_H__ */
