/*
 * \ingroup sms
 *
 * \file    qaSmsSwiSetSMSStorage.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaSmsSwiSetSMSStorage.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __SMS_SLQS_SET_SMS_STORAGE_H__
#define __SMS_SLQS_SET_SMS_STORAGE_H__

/* enum declarations */

/*
 * An enumeration of eQMI_SMS_SLQS_SET_SMS_STORAGE request TLV IDs
 *
 */
enum eQMI_SMS_SLQS_GET_SMS_STORAGE_REQ
{
	eTLV_SET_SMS_STORAGE = 0x01
};

/*
 * This structure contains the SetSmsStorage request parameters
 */
struct QmiSmsSwiSetSMSStorageReq
{
    BYTE smsStorage;
};

/*
 * This structure contains the SetSmsStorage response parameters
 */
struct QmiSmsSwiSetSMSStorageResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiSmsSwiSetSMSStorage(
    WORD *pMlength,
    BYTE *pParamField,
    BYTE mode );

extern enum eQCWWANError UpkQmiSmsSwiSetSMSStorage(
    BYTE                              *pMdmResp,
    struct QmiSmsSwiSetSMSStorageResp *pApiResp );

#endif /* __SMS_SLQS_SET_SMS_STORAGE_H__ */
