/*
 * \ingroup sms
 *
 * \file    qaSmsSwiGetSMSStorage.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaSmsSwiGetSMSStorage.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __SMS_SLQS_GET_SMS_STORAGE_H__
#define __SMS_SLQS_GET_SMS_STORAGE_H__

#include "qaGobiApiSms.h"

/* enum declarations */

/*
 * An enumeration of eQMI_SMS_SLQS_GET_SMS_STORAGE_RESP request TLV IDs
 */
enum eQMI_SMS_SLQS_GET_SMS_STORAGE_RESP
{
    eTLV_SMS_STORAGE = 0x01
};

/*
 * This structure contains the SLQSSmsGetMessageProtocol response parameters.
 */
struct QmiSmsSwiGetSMSStorageResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    ULONG *pSmsStorage;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiSmsSwiGetSMSStorage(
    WORD *pMlength,
    BYTE *pBuffer );

extern enum eQCWWANError UpkQmiSmsSwiGetSMSStorage(
    BYTE                              *pMdmResp,
    struct QmiSmsSwiGetSMSStorageResp *pApiResp );

#endif /* __SMS_SLQS_GET_SMS_STORAGE_H__ */
