/*
 * \ingroup sms
 *
 * \file    qaSmsAsyncRawSend.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaSmsAsyncRawSend.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __SMS_ASYNC_RAW_SEND_H__
#define __SMS_ASYNC_RAW_SEND_H__

#include"qaGobiApiSms.h"

/* enum declarations */

/*
 * An enumeration of eQMI_SMS_ASYNC_RAW_SEND request TLV IDs
 *
 */
enum eQMI_SMS_ASYNC_RAW_SEND_REQ
{
    eTLV_ASYNC_MESSAGE_DATA = 0x01,
    eTLV_ASYNC_FORCE_ON_DC  = 0x10,
    eTLV_ASYNC_FOLLOW_ON_DC = 0x11,
    eTLV_ASYNC_LINK_TIMER   = 0x12,
    eTLV_ASYNC_SMS_ON_IMS   = 0x13,
    eTLV_ASYNC_RETRY_MSG    = 0x14,
    eTLV_ASYNC_RETRY_MSG_ID = 0x15,
    eTLV_ASYNC_USER_DATA    = 0x16
};

/*
 * This structure contains the AsyncSendSMS request parameters.
 */
struct QmiSmsAsyncRawSendReq
{
    ULONG messageFormat;
    ULONG messageSize;
    BYTE  *pForceOnDC;
    BYTE  *pServiceOption;
    BYTE  *pFollowOnDC;
    BYTE  *pLinktimer;
    BYTE  *pSmsOnIms;
    BYTE  *pRetryMessage;
    ULONG *pRetryMessageId;
    ULONG *pUserData;
    BYTE  *pMessage;
};

/*
 * This structure contains the AsyncSendSMS response parameters
 */
struct QmiSmsAsyncRawSendResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */

enum eQCWWANError PkQmiSmsAsyncRawSend(
    WORD                     *pMlength,
    BYTE                     *pParamField,
    slqssendasyncsmsparams_s *pSendSMSParam );

extern enum eQCWWANError UpkQmiSmsAsyncRawSend(
    BYTE                          *pMdmResp,
    struct QmiSmsAsyncRawSendResp *pApiResp );

#endif /* __SMS_ASYNC_RAW_SEND_H__ */
