/*
 * Copyright: © 2013 Sierra Wireless, Inc. all rights reserved
 */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaQmiBasic.h"

#include "qaQosCommon.h"
#include "qaQosSwiReadDataStats.h"

enum eQCWWANError PkQmiQosSwiReadDataStats (
    WORD    *pMlength,
    BYTE    *pParamField,
    ULONG   apnId)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eREQ_TLV_APN,         &BuildTlvApnId },
        { eTLV_TYPE_INVALID,    NULL }  /* Important. Sentinel.
                                        * Signifies last item in map.
                                        */
    };

    enum eQCWWANError eRCode;

    eRCode = qmbuild( pParamField,
                      (BYTE*) &apnId,
                      map,
                      eQMI_QOS_SWI_READ_DATA_STATS,
                      pMlength );

    return eRCode;
}

static enum eQCWWANError unFlow(
    BYTE* pTlvData,
    BYTE *pResp )
{
    struct QmiQosSwiReadDataStatsResp *lResp =
              (struct QmiQosSwiReadDataStatsResp *)pResp;
    enum eQCWWANError eRCode;
    ULONG len, i;

    eRCode = GetLong( pTlvData, &len);
    if ( len > MAX_QOS_SPEC_PER_APN )
    {
        return eQCWWAN_ERR_INTERNAL;
    }
    lResp->pQosStat->numQosFlow = len;
    

    for(i=0;i<len;i++)
    {
        eRCode = GetLong( pTlvData, &lResp->pQosStat->qosFlow[i].bearerId);
        CHECK();

        eRCode = GetLong( pTlvData, &lResp->pQosStat->qosFlow[i].tx_pkt);
        CHECK();

        eRCode = GetLong( pTlvData, &lResp->pQosStat->qosFlow[i].tx_pkt_drp);
        CHECK();

        eRCode = GetLongLong( pTlvData, &lResp->pQosStat->qosFlow[i].tx_bytes);
        CHECK();

        eRCode = GetLongLong( pTlvData, &lResp->pQosStat->qosFlow[i].tx_bytes_drp);
        CHECK();

    }

    return eQCWWAN_ERR_NONE;
}

static enum eQCWWANError unApn(
    BYTE* pTlvData,
    BYTE *pResp )
{
    struct QmiQosSwiReadDataStatsResp *lResp =
              (struct QmiQosSwiReadDataStatsResp *)pResp;
    enum eQCWWANError eRCode;

    eRCode = GetLong( pTlvData, &lResp->pQosStat->apnId);
    CHECK();

    eRCode = GetLong( pTlvData, &lResp->pQosStat->total_tx_pkt);
    CHECK();

    eRCode = GetLong( pTlvData, &lResp->pQosStat->total_tx_pkt_drp);
    CHECK();

    eRCode = GetLong( pTlvData, &lResp->pQosStat->total_rx_pkt);
    CHECK();

    eRCode = GetLongLong( pTlvData, &lResp->pQosStat->total_tx_bytes);
    CHECK();

    eRCode = GetLongLong( pTlvData, &lResp->pQosStat->total_tx_bytes_drp);
    CHECK();

    eRCode = GetLongLong( pTlvData, &lResp->pQosStat->total_rx_bytes);
    CHECK();

    return eQCWWAN_ERR_NONE;
}

enum eQCWWANError UpkQmiQosSwiReadDataStats(
    BYTE    *pMdmResp,
    struct  QmiQosSwiReadDataStatsResp *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,             &qmUnpackTlvResultCode },
        { eTLV_APN,                     &unApn },
        { eTLV_FLOW,                    &unFlow },
        { eTLV_TYPE_INVALID,            NULL }  /* Important. Sentinel.
                                                 * Signifies last item in map.
                                                 */
    };

    eRCode = qmunpackresp( pMdmResp,
                          (BYTE*)pApiResp,
                          map,
                          eQMI_QOS_SWI_READ_DATA_STATS );
    return eRCode;
}

