/*
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaQmiBasic.h"

#include "qaQosCommon.h"
#include "qaQosSwiReadApnExtraParams.h"

static enum eQCWWANError unAmbr(
    BYTE* pTlvData,
    BYTE *pResp )
{
    struct QmiQosSwiReadApnExtraParamsResp *lResp =
              (struct QmiQosSwiReadApnExtraParamsResp *)pResp;
    enum eQCWWANError eRCode;

    eRCode = GetLong( pTlvData, &lResp->pApnExtraParams->apnId);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_ul);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_dl);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_ul_ext);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_dl_ext);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_ul_ext2);
    CHECK();

    eRCode = GetByte( pTlvData, &lResp->pApnExtraParams->ambr_dl_ext2);
    CHECK();
    return eQCWWAN_ERR_NONE;
}

enum eQCWWANError PkQmiQosSwiReadApnExtraParams (
    WORD    *pMlength,
    BYTE    *pParamField,
    ULONG   apnId)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eREQ_TLV_APN,         &BuildTlvApnId },
        { eTLV_TYPE_INVALID,    NULL }  /* Important. Sentinel.
                                        * Signifies last item in map.
                                        */
    };

    enum eQCWWANError eRCode;

    eRCode = qmbuild( pParamField,
                      (BYTE*) &apnId,
                      map,
                      eQMI_QOS_SWI_READ_APN_PARAMS,
                      pMlength );

    return eRCode;
}

enum eQCWWANError UpkQmiQosSwiReadApnExtraParams(
    BYTE    *pMdmResp,
    struct  QmiQosSwiReadApnExtraParamsResp *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,             &qmUnpackTlvResultCode },
        { eTLV_APN,                     &unAmbr },
        { eTLV_TYPE_INVALID,            NULL }  /* Important. Sentinel.
                                                 * Signifies last item in map.
                                                 */
    };

    eRCode = qmunpackresp( pMdmResp,
                          (BYTE*)pApiResp,
                          map,
                          eQMI_QOS_SWI_READ_APN_PARAMS );
    return eRCode;
}
