#ifndef __QOS_COMMON_H__
#define __QOS_COMMON_H__

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaQmiBasic.h"

#define CHECK() \
    if (eRCode!=eQCWWAN_ERR_NONE) return eRCode;

#define MAX_QOS_FLOW_SUPPORTED  (8)

enum
{
    eTLV_QOS_IDS = 0x01
};

enum
{
    eTLV_QOS_FLOW_IDX                  = 0x10,
    eTLV_QOS_FLOW_TRAFFIC_CLASS        = 0x11,
    eTLV_QOS_FLOW_DATA_RATE            = 0x12,
    eTLV_QOS_FLOW_BUCKET               = 0x13,
    eTLV_QOS_FLOW_LATAENCY             = 0x14,
    eTLV_QOS_FLOW_JITTER               = 0x15,
    eTLV_QOS_FLOW_PKT_ERR_RATE         = 0x16,
    eTLV_QOS_FLOW_MIN_POL_PKT_SIZE     = 0x17,
    eTLV_QOS_FLOW_MAX_ALLOWED_PKT_SIZE = 0x18,
    eTLV_QOS_FLOW_RB_ERROR_RATE        = 0x19,
    eTLV_QOS_FLOW_3GPP_TH_Priority     = 0x1A,
    eTLV_QOS_FLOW_3GPP2_PRO_ID         = 0x1B,
    eTLV_QOS_FLOW_3GPP2_FLOW_PRIORITY  = 0x1C,
    eTLV_QOS_FLOW_3GPP_IM_CN_FLAG      = 0x1D,
    eTLV_QOS_FLOW_3GPP_SIG_IND         = 0x1E,
    eTLV_QOS_FLOW_LTE_QCI              = 0x1F,
};

enum
{
    eTLV_APN  = 0x03,
    eTLV_FLOW = 0x04,
};

enum
{
    eREQ_TLV_APN = 0x01
};

enum
{
    eTLV_QOS_FILTER_IDX           = 0x10,
    eTLV_QOS_FILTER_VER           = 0x11,
    eTLV_QOS_FILTER_V4_SRC_ADDR   = 0x12,
    eTLV_QOS_FILTER_V4_DEST_ADDR  = 0x13,
    eTLV_QOS_FILTER_NXT_HDR_PROTO = 0x14,
    eTLV_QOS_FILTER_V4_TOS        = 0x15,
    eTLV_QOS_FILTER_V6_SRC_ADDR   = 0x16,
    eTLV_QOS_FILTER_V6_DEST_ADDR  = 0x17,
    eTLV_QOS_FILTER_V6_TC         = 0x19,
    eTLV_QOS_FILTER_V6_FLOW_LBL   = 0x1A,
    eTLV_QOS_FILTER_TCP_SRC_PORT  = 0x1B,
    eTLV_QOS_FILTER_TCP_DEST_PORT = 0x1C,
    eTLV_QOS_FILTER_UDP_SRC_PORT  = 0x1D,
    eTLV_QOS_FILTER_UDP_DEST_PORT = 0x1E,
    eTLV_QOS_FILTER_ESP_SP_INDEX  = 0x21,
    eTLV_QOS_FILTER_PRECEDENCE    = 0x22,
    eTLV_QOS_FILTER_ID            = 0x23,
    eTLV_QOS_FILTER_TP_SRC_PORT   = 0x24,
    eTLV_QOS_FILTER_TP_DEST_PORT  = 0x25,
};


enum eQCWWANError mBuildTlvQosIds(BYTE *pBuf, BYTE  *pParam);
enum eQCWWANError mBuildTlvId(BYTE *pBuf, BYTE  *pParam);
enum eQCWWANError BuildTlvApnId(BYTE *pBuf, BYTE *pParam);

#endif  /* __QOS_COMMON_H__ */
