/*
 * \ingroup pds
 *
 * \file qaPdsSetPositionMethodState.c
 *
 * \brief Contains Packing and UnPacking routines for the
 *        QMI_PDS_SET_POSITION_METHOD_STATE message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaPdsSetPositionMethodState.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/

/*
 * packs the SetPositionMethodState location server field to the
 * QMI message SDU
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvXtraTime( BYTE *pBuf, BYTE *pParam )
{
     PDSPosMethodStateReq *pReq =
        (PDSPosMethodStateReq *)pParam;

    if(pReq->pXtraTimeState == NULL)
        return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    return PutByte( pBuf, *(pReq->pXtraTimeState));

}
/*
 * packs the SetPositionMethodState location server field to the
 * QMI message SDU
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvXtraData( BYTE *pBuf, BYTE *pParam )
{
     PDSPosMethodStateReq *pReq =
        (PDSPosMethodStateReq *)pParam;

    if(pReq->pXtraDataState == NULL)
        return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    return PutByte( pBuf, *(pReq->pXtraDataState));

}
/*
 * packs the SetPositionMethodState location server field to the
 * QMI message SDU
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvWifiState( BYTE *pBuf, BYTE *pParam )
{
     PDSPosMethodStateReq *pReq =
        (PDSPosMethodStateReq *)pParam;

    if(pReq->pWifiState == NULL)
        return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    return PutByte( pBuf, *(pReq->pWifiState));

}
/*
 * This function packs the SetPositionMethodState parameters to the QMI message SDU
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed
 *                              data will be placed by this function.
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiPdsSlqsSetPosMethodState(
    WORD                  *pMlength,
    BYTE                  *pParamField,
    PDSPosMethodStateReq *pPDSPosMethodStateReq)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_XTAT_TIME,                &BuildTlvXtraTime },
        { eTLV_XTAR_DATA,                &BuildTlvXtraData },
        { eTLV_WIFI_STATE,               &BuildTlvWifiState},
        { eTLV_TYPE_INVALID,             NULL }/* Important. Sentinel.
                                                * Signifies last item in map
                                                */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode = qmbuild( pParamField,
                      (BYTE *)pPDSPosMethodStateReq,
                      map,
                      eQMI_PDS_SET_METHODS,
                      pMlength );
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/

/*
 * This function unpacks the SetPositionMethodState response message to a user-provided
 * response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiPdsSlqsSetPosMethodState(
    BYTE                           *pMdmResp,
    struct QmiPdsPosMethodStateResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_PDS_SET_METHODS );
    return eRCode;
}
