/*
 * \ingroup pds
 *
 * \file    qaPdsSetPositionMethodState.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaPdsSetPositionMethodState.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __PDS_SET_POSITION_METHOD_H__
#define __PDS_SET_POSITION_METHOD_H__

#include "qaGobiApiPds.h"

/* enum declarations */
/*
 * An enumeration of eQMI_PDS_SET_POSITION_METHOD_STATE request TLV IDs
 */
enum eQMI_PDS_SET_POSITION_METHOD_STATE_REQ
{
    eTLV_XTAT_TIME              = 0x10,
    eTLV_XTAR_DATA              = 0x11,
    eTLV_WIFI_STATE             = 0x12,
};

/*
 * This structure contains the PdsInjectPositionDataResp response parameters
 */
struct QmiPdsPosMethodStateResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * prototypes
 */
extern enum eQCWWANError PkQmiPdsSlqsSetPosMethodState(
    WORD                  *pMlength,
    BYTE                  *pParamField,
    PDSPosMethodStateReq *pPDSPosMethodStateReq);

extern enum eQCWWANError UpkQmiPdsSlqsSetPosMethodState(
    BYTE                           *pMdmResp,
    struct QmiPdsPosMethodStateResp *pApiResp );

#endif /* __PDS_SET_POSITION_METHOD_H__ */
