/*
 * \ingroup pds
 *
 * \file qaPdsSLQSGetGPSStateInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaPdsSLQSGetGPSStateInfo.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __PDS_SLQS_GET_GPS_STATE_INFO_H__
#define __PDS_SLQS_GET_GPS_STATE_INFO_H__

#include "qaGobiApiPds.h"
/*
 * An enumeration of eQMI_PDS_SLQS_GET_GPS_STATE response TLV IDs
 */
enum eQMI_PDS_GET_GPS_STATE_RESP
{
    eTLV_GPS_STATE_INFO = 0x10
};

/*
 * This structure contains the SLQSGetGPSStateInfo response parameters
 *
 * \sa qaGobiApiPds.h for parameter descriptions
 *
 */
struct QmiPdsSLQSGetGPSStateInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* SLQSGetGPSStateInfo response parameters */
    GPSStateInfo *pGPSStateInfo;
};

/*
 * Prototypes
 *
 */
extern enum eQCWWANError PkQmiPdsSlqsGetGPSStateInfo(
    WORD *pMlength,
    BYTE *pBuffer );

extern enum eQCWWANError UpkQmiSlqsGetGPSStateInfo(
    BYTE                                 *pMdmResp,
    struct QmiPdsSLQSGetGPSStateInfoResp *pApiResp );

#endif /* __PDS_SLQS_GET_GPS_STATE_INFO_H__ */
