/*
 * \ingroup : nas
 *
 * \file    : qaNasSLQSSwiSetChannelLock.c
 *
 * \brief   : Contains Packing and UnPacking routines for the
 *            eQMI_NAS_SWI_SET_CHANNEL_LOCK message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 */

/* include files */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"

#include "qaNasSLQSSwiSetChannelLock.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/
/*
 * This function packs the WCDMA UARFCN field to the QMI message SDU.
 *
 * \param pBuf   - Pointer to storage into which the packed
 *                  data will be placed by this function.
 *
 * \param pParam - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE  on success, eQCWWAN_ERR_XXX on error
 */
enum eQCWWANError BuildTlvSetWcdmaUARFCN( BYTE *pBuf, BYTE *pParam )
{
    wcdmaUARFCN *pReq =
                     ((struct QmiNasSlqsSwiSetChannelLockReq *)pParam)->pNasSwiSetChannelLockReq->pWcdmaUARFCN;
    enum eQCWWANError eRCode;

    if ( pReq == NULL )
         return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    eRCode = PutByte( pBuf, (pReq->status) );
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = PutLong( pBuf, (pReq->uarfcn) );

    return eRCode;
}

/*
 * This function packs the LTE EARFCN field to the QMI message SDU.
 *
 * \param pBuf   - Pointer to storage into which the packed
 *                  data will be placed by this function.
 *
 * \param pParam - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE  on success, eQCWWAN_ERR_XXX on error
 */
enum eQCWWANError BuildTlvSetLteEARFCN( BYTE *pBuf, BYTE *pParam )
{
    lteEARFCN *pReq =
                     ((struct QmiNasSlqsSwiSetChannelLockReq *)pParam)->pNasSwiSetChannelLockReq->pLteEARFCN;
    enum eQCWWANError eRCode;

    if ( pReq == NULL )
         return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    eRCode = PutByte( pBuf, (pReq->status) );
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = PutLong( pBuf, (pReq->earfcn0) );
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = PutLong( pBuf, (pReq->earfcn1) );

    return eRCode;
}

/*
 * This function packs the LTE PCI field to the QMI message SDU.
 *
 * \param pBuf   - Pointer to storage into which the packed
 *                  data will be placed by this function.
 *
 * \param pParam - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE  on success, eQCWWAN_ERR_XXX on error
 */
enum eQCWWANError BuildTlvSetLtePCI( BYTE *pBuf, BYTE *pParam )
{
    ltePCI *pReq =
                     ((struct QmiNasSlqsSwiSetChannelLockReq *)pParam)->pNasSwiSetChannelLockReq->pLtePCI;
    enum eQCWWANError eRCode;

    if ( pReq == NULL )
         return eQCWWAN_ERR_NONE;

    /* Add TLV data */
    eRCode = PutByte( pBuf, (pReq->status) );
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = PutLong( pBuf, (pReq->earfcn) );
    if( eQCWWAN_ERR_NONE != eRCode )
        return eRCode;

    eRCode = PutLong( pBuf, (pReq->pci) );

    return eRCode;
}

/*
 * This function packs the SetChannelLock parameters to the QMI message SDU
 *
 * \param  pParamField [OUT] - Pointer to storage into which the packed
 *                                    data will be placed by this function.
 *
 * \param  pMlength    [OUT] - Total length of built message.
 *
 * \return eQCWWAN_ERR_NONE  on success, eQCWWAN_ERR_XXX on error
 *
 * \sa     qaGobiApiNas.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiNasSlqsSwiSetChannelLock (
        WORD *pMlength,
        BYTE *pParamField,
        nasSwiSetChannelLockReq *pNasSwiSetChannelLockReq)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_SET_WCDMA_UARFCN,       &BuildTlvSetWcdmaUARFCN },
        { eTLV_SET_LTE_EARFCN,         &BuildTlvSetLteEARFCN },
        { eTLV_SET_LTE_PCI,            &BuildTlvSetLtePCI },
        { eTLV_TYPE_INVALID,           NULL } /* Important. Sentinel.
                                              * Signifies last item in map.
                                              */
    };

    struct QmiNasSlqsSwiSetChannelLockReq req;
    enum   eQCWWANError             eRCode;

    req.pNasSwiSetChannelLockReq = pNasSwiSetChannelLockReq;

    eRCode = qmbuild( pParamField,
                      (BYTE *)&req,
                      map,
                      eQMI_NAS_SWI_SET_CHANNEL_LOCK,
                      pMlength );
    return eRCode;
}

/******************************************************************************
 * Response handling
 *****************************************************************************/

/*
 * This function unpacks the eQMI_NAS_SWI_SET_CHANNEL_LOCK response
 * message to a user-provided response structure.
 *
 * \param  pMdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param  pApiResp  [OUT] - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE  on success, eQCWWAN_ERR_XXX on error
 *
 */
enum eQCWWANError UpkQmiNasSlqsSwiSetChannelLock(
    BYTE                                   *pMdmResp,
    struct QmiNasSlqsSwiSetChannelLockResp *pApiResp)
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };
    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_NAS_SWI_SET_CHANNEL_LOCK );
    return eRCode;
}

