/*
 * \ingroup nas
 *
 * \file  qaNasSwiIndicationRegister.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasSwiIndicationRegister.c
 *
 * Copyright: © 2011 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SWI_INDICATION_REGISTER_MSG_H__
#define __NAS_SWI_INDICATION_REGISTER_MSG_H__

#include "qaGobiApiNas.h"

/* enum declarations */

/*
 *
 * An enumeration of eQMI_NAS_SWI_INDICATION_REGISTER request TLV IDs
 *
 */
enum eQMI_NAS_SWI_INDICATION_REGISTER_REQ
{
    eTLV_OTA_MSG_IND               = 0x10,
    eTLV_NAS_SWI_INDICATION_RANK_INDICATOR_IND        = 0x11,

};

/*
 * This structure contains the SwiIndicationRegister response parameters
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSwiIndicationRegisterResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 *
 */
extern enum eQCWWANError PkQmiNasSwiIndicationRegister(
    WORD  *pMlength,
    BYTE  *pBuffer,
    NasSwiIndReg *pSwiIndReg );

extern enum eQCWWANError UpkQmiNasSwiIndicationRegister(
    BYTE                             *pMdmresp,
    struct QmiNasSwiIndicationRegisterResp *pApiresp);

#endif /* __NAS_SWI_INDICATION_REGISTER_MSG_H__ */
