/*
 * \ingroup nas
 *
 * \file qaNasSLQSSwiSetChannelLock.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasSLQSSwiSetChannelLock.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SET_SWI_GET_CHANNEL_LOCK_H__
#define __NAS_SET_SWI_GET_CHANNEL_LOCK_H__

#include "qaGobiApiNas.h"
/*
 *
 * An enumeration of QMI_NAS_SWI_SET_CHANNEL_LOCK request TLV IDs
 *
 */
enum eQMI_NAS_SWI_GET_CHANNEL_LOCK_REQ
{
    eTLV_SET_WCDMA_UARFCN = 0x10,
    eTLV_SET_LTE_EARFCN   = 0x11,
    eTLV_SET_LTE_PCI      = 0x12
};
/*
 * This structure contains the SLQSNASSwiSetChannelLock request parameters.
 *
 * \sa  qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiSetChannelLockReq
{
    nasSwiSetChannelLockReq *pNasSwiSetChannelLockReq;
};
/*
 * This structure contains the SLQSNASSwiSetChannelLock response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiSetChannelLockResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiNasSlqsSwiSetChannelLock (
    WORD *pMlength,
    BYTE *pParamField,
    nasSwiSetChannelLockReq *pNasSwiSetChannelLockReq);

extern enum eQCWWANError UpkQmiNasSlqsSwiSetChannelLock(
    BYTE                           *pMdmResp,
    struct QmiNasSlqsSwiSetChannelLockResp *pAipResp);

#endif /* __NAS_SET_SWI_GET_CHANNEL_LOCK_H__ */
