/*
 * \ingroup nas
 *
 * \file    qaNasSLQSSwiNetworkDebug.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaNasSLQSSwiNetworkDebug.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SLQS_SWI_NETWORK_DEBUG_H__
#define __NAS_SLQS_SWI_NETWORK_DEBUG_H__

/*
 * \internal
 *
 * An enumeration of NAS_SLQS_SWI_NETWORK_DEBUG_RESP response TLV IDs
 *
 */
enum eNAS_SLQS_SWI_NETWORK_DEBUG_RESP
{
    eTLV_VERSION_NUMBER        = 0x10,
    eTLV_1X_NW_STATUS          = 0x11,
    eTLV_EVDO_NW_STATUS        = 0x12,
    eTLV_DEVICE_CONFIG_DETAILS = 0x13,
    eTLV_DATA_STATUS_DETAILS   = 0x14
};

/*
 * \internal
 *
 * This structure contains the SLQSSwiNetworkDebug response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiNetworkDebugResp
{
    /*
     * \internal
     *
     * Every response message must have a results structure
     */
    struct qmTlvResult results;

    /*
     * \internal
     *
     * Response parameters
     */
    NetworkDebugResp *pNetworkDebugResp;
};

/*
 * \internal
 *
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasSlqsSwiNetworkDebug(
    WORD *pMlength,
    BYTE *pParamField );

enum eQCWWANError UpkQmiNasSlqsSwiNetworkDebug(
    BYTE                                 *pMdmResp,
    struct QmiNasSlqsSwiNetworkDebugResp *pApiResp );

#endif /* __NAS_SLQS_SWI_NETWORK_DEBUG_H__ */
