/*
 * \ingroup nas
 *
 * \file   qaNasSLQSSwiGetHRPDStats.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaNasSLQSSwiGetHRPDStats.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SLQS_SWI_GET_HRPD_STATS_H__
#define __NAS_SLQS_SWI_GET_HRPD_STATS_H__

/*
 * \internal
 *
 * An enumeration of NAS_SLQS_SWI_GET_HRPD_STATS_RESP response TLV IDs
 *
 */
enum eNAS_SLQS_SWI_GET_HRPD_STATS_RESP
{
    eTLV_DRC       = 0x10,
    eTLV_UATI      = 0x11,
    eTLV_PILOT_SET = 0x12,
};

/*
 * \internal
 *
 * This structure contains the SLQSSwiGetHRPDStats response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiGetHRPDStatsResp
{
    /*
     * \internal
     *
     * Every response message must have a results structure
     */
    struct qmTlvResult results;

    /*
     * \internal
     *
     * Response parameters
     */
    GetHRPDStatsResp *pGetHRPDStatsResp;
};

/*
 * \internal
 *
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasSlqsSwiGetHRPDStats(
    WORD *pMlength,
    BYTE *pParamField );

enum eQCWWANError UpkQmiNasSlqsSwiGetHRPDStats(
    BYTE                                 *pMdmResp,
    struct QmiNasSlqsSwiGetHRPDStatsResp *pApiResp );

#endif /* __NAS_SLQS_SWI_GET_HRPD_STATS_H__ */
