/*
 * \ingroup nas
 *
 * \file qaNasSLQSSwiGetChannelLock.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasSLQSSwiGetChannelLock.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_GET_SWI_GET_CHANNEL_LOCK_H__
#define __NAS_GET_SWI_GET_CHANNEL_LOCK_H__

/*
 *
 * An enumeration of QMI_NAS_SWI_GET_CHANNEL_LOCK response TLV IDs
 *
 */
enum eQMI_NAS_SWI_GET_CHANNEL_LOCK_RESP
{
    eTLV_WCDMA_UARFCN = 0x10,
    eTLV_LTE_EARFCN   = 0x11,
    eTLV_LTE_PCI      = 0x12
};

/*
 * This structure contains the SLQSNASSwiGetChannelLock response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiGetChannelLockResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Response parameters */
    nasSwiGetChannelLockResp *pNasSwiGetChannelLockResp;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiNasSlqsSwiGetChannelLock (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiNasSlqsSwiGetChannelLock(
    BYTE                           *pMdmResp,
    struct QmiNasSlqsSwiGetChannelLockResp *pAipResp);

#endif /* __NAS_GET_SWI_GET_CHANNEL_LOCK_H__ */
