/*
 * \ingroup nas
 *
 * \file qaNasSLQSSwiGetCQI.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasSLQSSwiGetCQI.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_GET_SWI_GET_CQI_REQ_MSG_H__
#define __NAS_GET_SWI_GET_CQI_REQ_MSG_H__

/*
 *
 * An enumeration of eQMI_NAS_SWI_GET_CQI response TLV IDs
 *
 */
enum eQMI_NAS_SWI_GET_CQI_RESP
{
    eTLV_LTE_CQI = 0x01
};

/*
 * This structure contains the SLQSSwiGetCQI response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsSwiGetCQIResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Response parameters */
    LteCQIParm *pLteCQI;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiNasSlqsSwiGetCQI (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiNasSlqsSwiGetCQI(
    BYTE                           *pMdmResp,
    struct QmiNasSlqsSwiGetCQIResp *pAipResp);

#endif /* __NAS_GET_SWI_GET_CQI_REQ_MSG_H__ */
