/*
 * \ingroup nas
 *
 * \file   qaNasSLQSGetErrorRate.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaNasSLQSGetErrorRate.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SLQS_GET_ERROR_RATE_H__
#define __NAS_SLQS_GET_ERROR_RATE_H__

/*
 * \internal
 *
 * An enumeration of NAS_SLQS_GET_ERROR_RATE_RESP response TLV IDs
 *
 */
enum eNAS_SLQS_GET_ERROR_RATE_RESP
{
    eTLV_CDMA_FRAME_ERR_RATE  = 0x10,
    eTLV_HDR_PACKET_ERR_RATE  = 0x11,
    eTLV_GSM_BIT_ERR_RATE     = 0x12,
    eTLV_WCDMA_BLOCK_ERR_RATE = 0x13,
};

/*
 * \internal
 *
 * This structure contains the SLQSGetErrorRate response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasSlqsGetErrorRateResp
{
    /*
     * \internal
     *
     * Every response message must have a results structure
     */
    struct qmTlvResult results;

    /*
     * \internal
     *
     * Response parameters
     */
    GetErrRateResp *pGetErrRateResp;
};

/*
 * \internal
 *
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasSlqsGetErrorRate (
    WORD *pMlength,
    BYTE *pParamField );

enum eQCWWANError UpkQmiNasSlqsGetErrorRate(
    BYTE                              *pMdmResp,
    struct QmiNasSlqsGetErrorRateResp *pApiResp );

#endif /* __NAS_SLQS_GET_ERROR_RATE_H__ */
