/*
 * \ingroup nas
 *
 * \file    qaNasGetLteCphycaInfo.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaNasGetLteCphycaInfo.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SLQS_GET_LTE_CPHY_CA_INFO_H__
#define __NAS_SLQS_GET_LTE_CPHY_CA_INFO_H__

#include "qaGobiApiNas.h"

/* enum declarations */
/*
 * An enumeration of eNAS_SLQS_GET_SYS_INFO_RESP response TLV IDs
 */
enum eNAS_SLQS_GET_LTE_CPHY_CA_RESP
{
    eTLV_GET_LTE_CPHY_CA_SCELL_IND_TYPE = 0x10,
    eTLV_GET_LTE_CPHY_CA_SCELL_DL_BW    = 0x11,
    eTLV_GET_LTE_CPHY_CA_SCELL_INFO     = 0x12,
    eTLV_GET_LTE_CPHY_CA_PCELL_INFO     = 0x13,
    eTLV_GET_LTE_CPHY_CA_SCELL_INDEX    = 0x14,
};

/*
 * This structure contains the SLQSNasGetSysInfo response parameters.
 */
typedef struct 
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    nasGetLTECphyCa *pnasGetLTECphyCaResp;
}QmiNasSLQSGetLTECphyCAResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasSlqsGetLTECphyCAInfo(
    WORD *pMlength,
    BYTE *pBuffer );

extern enum eQCWWANError UpkQmiNasSlqsGetLTECphyCAInfo(
    BYTE                            *pMdmResp,
    QmiNasSLQSGetLTECphyCAResp *pApiResp );

#endif /* __NAS_SLQS_GET_LTE_CPHY_CA_INFO_H__ */
