/*
 * \ingroup nas
 *
 * \file qaNasGetHomeNetwork3GPP2.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasGetHomeNetwork3GPP2.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_GET_HOME_NETWORK_3GPP2_H__
#define __NAS_GET_HOME_NETWORK_3GPP2_H__

/*
 *
 * An enumeration of eQMI_NAS_GET_HOME_NETWORK response TLV IDs
 *
 */
enum eQMI_NAS_GET_HOME_NETWORK_3GPP2_RESP
{
    eTLV_HOME_NETWORK_EXT        = 0x01,
    eTLV_HOME_SYSTEM_ID_EXT      = 0x10,
    eTLV_HOME_NW_3GPP2           = 0x11
};

/*
 * This structure contains the GetHomeNetwork3GPP2 response parameters.
 *
 * \sa qaGobiApiNas.h for parameter descriptions
 *
 */
struct QmiNasGetHomeNetwork3GPP2Resp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Response parameters */
    WORD    *pMCC;
    WORD    *pMNC;
    BYTE     nameSize;
    CHAR    *pName;
    WORD    *pSID;
    WORD    *pNID;
    WORD    *pNw2MCC;
    WORD    *pNw2MNC;
    BYTE    *pNw2DescDisp;
    BYTE    *pNw2DescEnc;
    BYTE    *pNw2DescLen;
    BYTE    *pNw2Name;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasGetHomeNetwork3GPP2 (
    WORD    *pMlength,
    BYTE    *pParamField );

extern enum eQCWWANError UpkQmiNasGetHomeNetwork3GPP2 (
    BYTE     *pMdmResp,
    struct   QmiNasGetHomeNetwork3GPP2Resp *pAipResp );

#endif /* __NAS_GET_HOME_NETWORK_3GPP2_H__ */
