/*
 * \ingroup nas
 *
 * \file qaNasConfigSigInfo2.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaNasConfigSigInfo2.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_CONFIG_SIG_INFO2_H__
#define __NAS_CONFIG_SIG_INFO2_H__

#include "qaGobiApiNas.h"
/*
 *
 * An enumeration of eQMI_NAS_CONFIG_SIG_INFO2 req TLV IDs
 *
 */
enum eQMI_NAS_CONFIG_SIG_INFO2_REQ
{
    eTLV_CDMA_RSSI_THRESHOLD        = 0x10,
    eTLV_CDMA_RSSI_DELTA            = 0x11,
    eTLV_CDMA_ECIO_THRESHOLD        = 0x12,
    eTLV_CDMA_ECIO_DELTA            = 0x13,
    eTLV_HDR_RSSI_THRESHOLD         = 0x14,
    eTLV_HDR_RSSI_DELTA             = 0x15,
    eTLV_HDR_ECIO_THRESHOLD         = 0x16,
    eTLV_HDR_ECIO_DELTA             = 0x17,
    eTLV_HDR_SINR_THRESH            = 0x18,
    eTLV_HDR_SINR_DELTA             = 0x19,
    eTLV_HDR_IO_THRESHOLD           = 0x1A,
    eTLV_HDR_IO_DELTA               = 0x1B,
    eTLV_GSM_RSSI_THRESHOLD         = 0x1C,
    eTLV_GSM_RSSI_DELTA             = 0x1D,
    eTLV_WCDMA_RSSI_THRESHOLD       = 0x1E,
    eTLV_WCDMA_RSSI_DELTA           = 0x1F,
    eTLV_WCDMA_ECIO_THRESHOLD       = 0x20,
    eTLV_WCDMA_ECIO_DELTA           = 0x21,
    eTLV_LTE_RSSI_THRESHOLD         = 0x22,
    eTLV_LTE_RSSI_DELTA             = 0x23,
    eTLV_LTE_SNR_THRESH             = 0x24,
    eTLV_LTE_SNR_DELTA              = 0x25,
    eTLV_LTE_RSRQ_THRESHOLD         = 0x26,
    eTLV_LTE_RSRQ_DELTA             = 0x27,
    eTLV_LTE_RSRP_THRESHOLD         = 0x28,
    eTLV_LTE_RSRP_DELTA             = 0x29,
    eTLV_LTE_SIG_RPT_CONFIG         = 0x2A,
    eTLV_TDSCDMA_RSCP_THRESHOLD     = 0x2B,
    eTLV_TDSCDMA_RSCP_DELTA         = 0x2C,
    eTLV_TDSCDMA_RSSI_THRESHOLD     = 0x2D,
    eTLV_TDSCDMA_RSSI_DELTA         = 0x2E,
    eTLV_TDSCDMA_ECIO_THRESHOLD     = 0x2F,
    eTLV_TDSCDMA_ECIO_DELTA         = 0x30,
    eTLV_TDSCDMA_SINR_THRESHOLD     = 0x31,
    eTLV_TDSCDMA_SINR_DELTA         = 0x32
};

/*
 * This structure contains the SLQSNasConfigSigInfo2 response parameters.
 */

struct QmiNasConfigSigInfo2Resp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiNasConfigSigInfo2 (
    WORD    *pMlength,
    BYTE    *pParamField,
    setSignalStrengthInfo *pSetSignalStrengthInfo);

extern enum eQCWWANError UpkQmiNasConfigSigInfo2 (
    BYTE     *pMdmResp,
    struct   QmiNasConfigSigInfo2Resp *pAipResp );

#endif /* __NAS_CONFIG_SIG_INFO2_H__ */
