/**
 * \ingroup voice
 *
 * \file    qaGobiApiTableFwDldErrorCodes.h
 *
 * \brief   FOTA update agent errors and FDT/SSDP reported errors
 *
 * \section Table15 FOTA update agent errors
 * \subsection Insignia defined error code ( in hexadecimal )
 * \li 01  - Flash driver init failed (invisible)
 * \li 02  - could not open/read workspace
 * \li 03  - could not open FOTO
 * \li 04  - could not open FOTO header
 * \li 05  - bad FOTO magic number
 * \li 06  - bad FOTO format
 * \li 08  - could not allocate memory for bitmap
 * \li 09  - could not read restart bitmap from FOTO
 * \li 0a  - could not read FOTO digest
 * \li 0b  - FOTO checksum error
 * \li 0d  - could not allocate memory for FOTO DGD
 * \li 0f  - flash driver SSP_FD_query for size failed
 * \li 10  - flash driver SSP_FD_query for DGD failed
 * \li 11  - could not allocate memory for driver DGD
 * \li 12  - FOTO DGD did not match driver DGD
 * \li 13  - DGD_init() failed
 * \li 14  - reference image checksum error
 * \li 15  - could not initialize decompressor
 * \li 16  - flash read failed during verification
 * \li 18  - assertion failed (debug builds only)
 * \li 19  - invalid FOTO extension header
 * \li 1a  - could not read xheader data from FOTO
 * \li 1b  - could not allocate memory for xheader
 * \li 1c  - could not get state from workspace
 * \li 1d  - FOTO image base block ID out of range
 * \li 1e  - FOTO read failed during verification
 * \li 1f  - could not open backup block/file
 * \li 20  - unsupported FOTO header revision
 * \li 21  - FOTO size invalid: too small
 * \li 22  - unsupported FOTO_flags value
 * \li 23  - illegal FOTO_DIGEST_OFFSET value
 * \li 24  - illegal FOTO_PARTITION value
 * \li 25  - FOTO_BODY too small for expected data
 * \li 26  - could not allocate digest storage
 * \li 27  - could not allocate image regions data
 * \li 29  - badly formed restart bitmap in FOTO
 * \li 2a  - illegal/unsupported restart map type
 * \li 2b  - invalid I/RDATA section offsets in FOTO
 * \li 2c  - new restart map not clean
 * \li 2d  - FOTO requires feature unsupported by UA
 * \li 2e  - could not allocate memory for RAM block
 * \li 2f  - could not read package header
 * \li 30  - bad package format
 * \li 31  - bad component package magic number
 * \li 32  - file has unknown/unsupported status
 * \li 33  - source or target file missing
 * \li 34  - target parent directory missing
 * \li 35  - target file exists
 * \li 36  - target directory exists
 * \li 37  - source file is a directory
 * \li 38  - extant file digest mismatch
 * \li 39  - buffer overflow
 * \li 3a  - digest mismatch (internal only)
 * \li 3b  - internal pseudo-error => skip to next pkg
 * \li 3c  - internal pseudo-error => op is complete
 * \li 3d  - internal pseudo-error => nothing to do
 * \li 3e  - could not reset decompressor
 * \li 3f  - reference or version image too large
 * \li 40  - FOTO ref. img size did not match img store
 * \li 41  - insufficient free space in image store
 * \li 42  - could not allocate memory for image cache
 * \li 43  - ZBM blockmap inconsistency
 * \li 44  - ZBM could not find vBlock in image store
 * \li 80  - version image digest/checksum error
 * \li 81  - bad FCP command
 * \li 82  - premature end of FCP stream
 * \li 83  - error reading fFCP stream from FOTO
 * \li 84  - decompression error
 * \li 85  - error reading flash memory
 * \li 86  - error writing flash memory
 * \li 87  - error erasing flash memory
 * \li 88  - error writing to restart bitmap in FOTO
 * \li 89  - flash block number out of range
 * \li 8a  - flash byte offset out of range
 * \li 8b  - error unlocking flash memory
 * \li 8c  - error reading backup block
 * \li 8d  - error writing backup block
 * \li 8e  - error erasing backup block
 * \li 8f  - error writing to FOTO
 * \li 90  - error writing to workspace
 * \li 91  - could not set workspace state (internal)
 * \li 92  - UA re-enetered after fatal error (internal)
 * \li 93  - could not initialize compressor
 * \li 94  - could not reset compressor
 * \li 95  - compression error
 * \li 96  - ZBM ran out of free blocks in image store
 * \li c0  - management client error
 * \li c1  - DL auth failure
 * \li c2  - DL download timeout
 * \li c3  - Not implemented operation
 * \li c4  - Malformed or bad DL URL
 * \li c5  - DL server unavailable
 * \li c6  - DL server error
 * \li c7  - DL fails due to out of memory
 * \subsection Sierra defined error code ( in hexadecimal )
 * \li 100 - CWE hdr allocation error
 * \li 101 - CWE hdr read error
 * \li 102 - CWE hdr check error
 * \li 103 - package descriptor error
 * \li 104 - CWE full image prog error
 * \li 105 - no reverse package found
 * \li 106 - reverse package applied already
 * \li 107 - package preprocessing error
 * \li 108 - package postprocessing error
 *
 * \section Table14 FDT/SSDP reported errors
 * \subsection Status Code(in hex) - Description - Reference BUT error Message
 * \li 80 - Invalid image type(in CWE header)    - Download Failed(Invalid Image Type)
 * \li 81 - Invalid product type(in CWE header)  - Download Failed(Wrong Image for this product)
 * \li 82 - Invalid size mismatch(with size specified in CWE header) - Download Failed(File size inconsistent with file header)
 * \li 83 - Image size out of range(could not fit into flash partition) - Download Failed (Firmware image is out of range)
 * \li 84 - Application image not compatible with boot loader or target - Download Failed (App not compatible with bootloader or target)
 * \li 85 - Boot loader not compatible with target - Download Failed(Bootloader not compatible with target)
 * \li 86 - Package not compatible with target     - Download Failed(Package not compatible with target)
 * \li 87 - Wrong Signature in application image   - Download Failed(Wrong signature for this application)
 * \li 88 - Flash read error                       - Download Failed(Read flash error)
 * \li 89 - CRC32 check failed                     - Download Failed(CRC32 check failed)
 * \li 8A - CRC16 check failed                     - Download Failed(Failed file checksum)
 * \li 8B - Invalid CWE header(too short or other check failed) - Download Failed(Start download packet too short)
 * \li 8C - Decompression error                    - Could not decompress the zipped image
 * \li 8F - Unspecified CWE processing error       - Download Failed(Unknown error) \n
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __GOBI_API_FW_DOWNLOAD_ERROR_CODES_H__
#define __GOBI_API_FW_DOWNLOAD_ERROR_CODES_H__


#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif /* __GOBI_API_FW_DOWNLOAD_ERROR_CODES_H__ */
