/**
 * \ingroup wds
 *
 * \file    qaGobiApiTableCallEndReasons.h
 *
 * \brief   Wireless Data Service Call End Reasons
 *
 * \section Table1 Call end reason codes (Code - Reason)
 * \subsection gen Technology-agnostic call end reasons
 * \li 1 - Reason unspecified, check the verbose call end reason
 * \li 2 - Client ended the call
 * \li 3 - Device has no service
 * \li 4 - Call ended abnormally
 * \li 5 - Received release from base station; no reason given
 * \li 6 - Access attempt already in progress; SD2.0 only
 * \li 7 - Access failure for reason other than the above
 * \li 8 - Call rejected because of redirection or handoff
 * \li 9 - Call failed because close is in progress
 * \li 10 - Authentication failed, 3GPP equivalent ESM(EPS Session Management) cause code value 29, User authentication failed
 * \li 11 - Call ended because of internal call end. This error code is returned when data call is brought down
 *          due to some unknown error, such as not specific to any RAT
 * \li 12 - Call ended because of internal error. This error code is returned when data call is brought down 
 *          due to some unspecified internal error, such as NULL pointer
 * \li 13 - Internal unknown cause code
 * \subsection CDMA CDMA
 * \li 500 - Device is CDMA-locked until power cycle
 * \li 501 - Received intercept from base station; origination only
 * \li 502 - Received reorder from base station; origination only
 * \li 503 - Received release from base station; service option reject
 * \li 504 - Received incoming call from base station
 * \li 505 - Received alert stop from base station; incoming only
 * \li 506 - Received end activation; OTASP call only
 * \li 507 - Max access probes transmitted
 * \li 508 - Concurrent service is not supported by base station
 * \li 509 - No response received from base station
 * \li 510 - Call rejected by the base station; CDMA only
 * \li 511 - Concurrent services requested were not compatible; CDMA only
 * \li 512 - Corresponds to CM CALL ORIG ERR ALREADY IN TC
 * \li 513 - Used if Call manager subsystem is ending a GPS call in favor of a user call
 * \li 514 - Used if Call manager subsystem is ending a SMS call in favor of a user call
 * \li 515 - CDMA Only; Device has no service
 * \subsection GSM WCDMA/GSM call end reasons
 * \li 1000 - Call origination request failed; WCDMA/GSM Only
 * \li 1001 - Client rejected the incoming call; WCDMA/GSM Only
 * \li 1002 - Device has no UMTS service; WCDMA/GSM Only
 * \li 1003 - Network ended the call, look in cc call; WCDMA/GSM Only
 * \li 1004 - LLC(Logical Link Control) or SNDCP(Sub Network Dependent Convergence Protocol) failure
 * \li 1005 - Insufficient resources, 3GPP equivalent ESM(EPS Session Management) cause code value 26, Insufficient resources
 * \li 1006 - Service option temporarily out of order, 3GPP equivalent ESM(EPS Session Management) cause code value 34, Service option temporarily out of order
 * \li 1007 - PTI already used, 3GPP equivalent ESM(EPS Session Management) cause code value 35, PTI(Procedure Transaction Identity) already in use
 * \li 1008 - Regular PDP context deactivation, 3GPP equivalent ESM(EPS Session Management) cause code value 36, Regular deactivation
 * \li 1009 - Network failure, 3GPP equivalent ESM(EPS Session Management) cause code value 38, Network failure
 * \li 1010 - Reactivation requested, 3GPP equivalent ESM(EPS Session Management) cause code value 39, Reactivation requested
 * \li 1011 - Protocol error, unspecified, 3GPP equivalent ESM(EPS Session Management) cause code value 111, Protocol error, unspecified
 * \li 1012 - Operator determined barring, 3GPP equivalent ESM(EPS Session Management) cause code value 8, Operator Determined Barring
 * \li 1013 - Unknown or missing Access Point Name (APN), 3GPP equivalent ESM(EPS Session Management) cause code value 27, Missing or unknown APN
 * \li 1014 - Unknown PDP address or PDP type, 3GPP equivalent ESM(EPS Session Management) cause code value 28, Unknown PDN type
 * \li 1015 - Activation rejected by GGSN, 3GPP equivalent ESM(EPS Session Management) cause code value 30, Requested rejected by Serving GW or PDN GW
 * \li 1016 - Activation rejected, unspecified, 3GPP equivalent ESM(EPS Session Management) cause code value 31, Request rejected, unspecified
 * \li 1017 - Service option not supported, 3GPP equivalent ESM(EPS Session Management) cause code value 32, Service option not supported
 * \li 1018 - Requested service option not subscribed, 3GPP equivalent ESM(EPS Session Management) cause code value 33, Requested service option not subscribed
 * \li 1019 - EPS Quality of Service (QoS) not accepted, 3GPP equivalent ESM(EPS Session Management) cause code value 37, EPS QoS not accepted
 * \li 1020 - Semantic error in the TFT operation, 3GPP equivalent ESM(EPS Session Management) cause code value 41, Semantic error in the TFT operation
 * \li 1021 - Syntactical error in the TFT operation, 3GPP equivalent ESM(EPS Session Management) cause code value 42, Syntactical error in the TFT operation
 * \li 1022 - Unknown PDP context, 3GPP equivalent ESM(EPS Session Management) cause code value 43, Invalid EPS bearer identity
 * \li 1023 - Semantic errors in packet filter(s), 3GPP equivalent ESM(EPS Session Management) cause code value 44, Semantic errors in packet filter(s)
 * \li 1024 - Syntactical error in packet filter(s), 3GPP equivalent ESM(EPS Session Management) cause code value 45, Syntactical errors in packet filter(s)
 * \li 1025 - PDP context without TFT already activated, 3GPP equivalent ESM(EPS Session Management) cause code value 46, Unused
 * \li 1026 - Invalid transaction identifier value, 3GPP equivalent ESM(EPS Session Management) cause code value 81, Invalid PTI value
 * \li 1027 - Semantically incorrect message, 3GPP equivalent ESM(EPS Session Management) cause code value 95, Semantically incorrect message
 * \li 1028 - Invalid mandatory information, 3GPP equivalent ESM(EPS Session Management) cause code value 96, Invalid mandatory information
 * \li 1029 - Message type non-existent or not implemented, 3GPP equivalent ESM(EPS Session Management) cause code value 97, Message type non-existent or not implemented
 * \li 1030 - Message not compatible with state, 3GPP equivalent ESM(EPS Session Management) cause code value 98, Message type not compatible with the protocol state
 * \li 1031 - Information element nonexistent or not implemented, 3GPP equivalent ESM(EPS Session Management) cause code value 99, Information element non-existent or not implemented
 * \li 1032 - Conditional information element error, 3GPP equivalent ESM(EPS Session Management) cause code value 100, Conditional IE error
 * \li 1033 - Message not compatible with protocol state, 3GPP equivalent ESM(EPS Session Management) cause code value 101, Message not compatible with the protocol state
 * \li 1034 - APN restriction value incompatible with active PDP context, 3GPP equivalent ESM(EPS Session Management) cause code value 112, APN restriction value incompatible with
 *          - active EPS bearer context
 * \li 1035 - No GPRS context present
 * \li 1036 - Requested feature not supported, 3GPP equivalent ESM(EPS Session Management) cause code value 40, Feature not supported
 * \li 1037 - Illegal MS, 3GPP equivalent EMM(EPS Mobility Management) cause code value 3, Illegal UE (MS)
 * \li 1038 - Illegal ME, 3GPP equivalent EMM(EPS Mobility Management) cause code value 6, Illegal ME. This error code is sent to the MS if the ME used is not acceptable
 *          - to the network, e.g. blacklisted
 * \li 1039 - GPRS and non GPRS services not allowed
 * \li 1040 - GPRS services not allowed
 * \li 1041 - MS identity not derived by the network, 3GPP equivalent EMM(EPS Mobility Management) cause code value 9, UE (MS) Identify cannot be derived by the network
 * \li 1042 - Implicitly detached, 3GPP equivalent EMM(EPS Mobility Management) cause code value 10, Implicitly Detached
 * \li 1043 - PLMN not allowed, 3GPP equivalent EMM(EPS Mobility Management) cause code value 11, PLMN not allowed
 * \li 1044 - LA not allowed, this cause is sent to the MS if it requests location updating in a location area where the HPLMN determines that
 *            the MS, by subscription, is not allowed to operate.
 * \li 1045 - GPRS services not allowed in PLMN
 * \li 1046 - PDP duplicate
 * \li 1047 - UE radio access technology change
 * \li 1048 - app preempted
 * \li 1049 - Congestion, This cause is sent if the service request or LOCATION UPDATING REQUEST message cannot be actioned
 *            because of congestion (e.g. congestion of the MSC or SGSN or GGSN or PDN Gateway; no channel; facility busy/congested etc.).
 * \li 1050 - No PDP context activated
 * \li 1051 - Access class DSAC rejection
 * \subsection CDMA EVDO CDMA 1xEV-DO
 * \li 1500 - Abort connection setup due to the reception of a Connection Deny message with deny code set
 *            to either general or network busy.
 * \li 1501 - Abort connection setup due to the reception of a Connection Deny message with deny code set
 *            to either billing or authentication failure.
 * \li 1502 - Change HDR system due to redirection or PRL not preferred
 * \li 1503 - Exit HDR due to redirection or PRL not preferred
 * \li 1504 - No HDR session
 * \li 1505 - Used if Call manager is ending an HDR call origination in favor of a GPS fix
 * \li 1506 - Connection setup timeout
 * \li 1507 - Call manager released HDR call so 1x call can continue
 * \subsection reason call end reason type
 * \li 1 - Mobile IP
 * \li 2 - Internal
 * \li 3 - Call Manager defined
 * \li 6 - 3GPP specification defined
 * \li 7 - PPP
 * \li 8 - EHRPD
 * \li 9 - IPv6
 * \subsection MobileIP Mobile IP call end reasons (Type=1)
 * \li 64  - MIP(Mobile IP) FA(Foreign Agent) ERR REASON UNSPECIFIED, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration with unspecified reason
 * \li 65  - MIP(Mobile IP) FA(Foreign Agent) ERR ADMINISTRATIVELY PROHIBITED, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent administratively prohibited MIP registration
 * \li 66  - MIP(Mobile IP) FA(Foreign Agent) ERR INSUFFICIENT RESOURCES, this error code is returned when the data call bring up fails
 *           in MIP setup phase since foreign agent rejected MIP registration due to insufficient resources
 * \li 67  - MIP(Mobile IP) FA(Foreign Agent) ERR MOBILE NODE AUTHENTICATION FAILURE, this error code is returned when the data call
 *           bring up fails in MIP setup phase since foreign agent rejected MIP registration because MN-AAA authenticator was wrong
 * \li 68  - MIP(Mobile IP) FA(Foreign Agent) ERR HA AUTHENTICATION FAILURE, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent rejected MIP registration because of home agent authentication failure
 * \li 69  - MIP(Mobile IP) FA(Foreign Agent) ERR REQUESTED LIFETIME TOO LONG, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent rejected MIP registration because  requested lifetime is too long
 * \li 70  - MIP(Mobile IP) FA(Foreign Agent) ERR MALFORMED REQUEST, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to malformed request
 * \li 71  - MIP(Mobile IP) FA(Foreign Agent) ERR MALFORMED REPLY, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to malformed reply
 * \li 72  - MIP(Mobile IP) FA(Foreign Agent) ERR ENCAPSULATION UNAVAILABLE, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent rejected MIP registration because requested encapsulation is unavailable 
 * \li 73  - MIP(Mobile IP) FA(Foreign Agent) ERR VJHC UNAVAILABLE, this error code is returned when the data call bring up fails in  
             MIP setup phase since foreign agent rejected MIP registration because VJ Header Compression is unavailable
 * \li 74  - MIP(Mobile IP) FA(Foreign Agent) ERR REVERSE TUNNEL UNAVAILABLE, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent rejected MIP registration because reverse tunnel is unavailable
 * \li 75  - MIP(Mobile IP) FA(Foreign Agent) ERR REVERSE TUNNEL IS MANDATORY AND T BIT NOT SET, this error code is returned when the
 *           data call bring up fails in MIP setup phase since foreign agent rejected MIP registration because reverse tunnel is mandatory
 *           but not requested by device
 * \li 79  - MIP(Mobile IP) FA(Foreign Agent) ERR DELIVERY STYLE NOT SUPPORTED, this error code is returned when the data call bring up
 *           fails in MIP setup phase since foreign agent rejected MIP registration because delivery style is not supported
 * \li 97  - MIP(Mobile IP) FA(Foreign Agent) ERR MISSING NAI, this error code is returned when the data call bring up fails in MIP setup
 *           phase since foreign agent rejected MIP registration due to missing NAI
 * \li 98  - MIP(Mobile IP) FA(Foreign Agent) ERR MISSING HA, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to missing Home Agent
 * \li 99  - MIP(Mobile IP) FA(Foreign Agent) ERR MISSING HOME ADDR, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to missing Home Address
 * \li 104 - MIP(Mobile IP) FA(Foreign Agent) ERR UNKNOWN CHALLENGE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to unknown challenge
 * \li 105 - MIP(Mobile IP) FA(Foreign Agent) ERR MISSING CHALLENGE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to missing challenge
 * \li 106 - MIP(Mobile IP) FA(Foreign Agent) ERR STALE CHALLENGE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since foreign agent rejected MIP registration due to stale challenge
 * \li 128 - MIP(Mobile IP) FA(Home Agent) ERR REASON UNSPECIFIED, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since home agent rejected MIP registration with unspecified reason
 * \li 129 - MIP(Mobile IP) FA(Home Agent) ERR ADMINISTRATIVELY PROHIBITED, this error code is returned when the data call bring up
 *           fails in MIP setup phase since home agent administratively prohibited MIP registration
 * \li 130 - MIP(Mobile IP) FA(Home Agent) ERR INSUFFICIENT RESOURCES, this error code is returned when the data call bring up fails
 *           in MIP setup phase since home agent rejected MIP registration due to insufficient resources
 * \li 131 - MIP(Mobile IP) FA(Home Agent) ERR MOBILE NODE AUTHENTICATION FAILURE, this error code is returned when the data call bring up
 *           fails in MIP setup phase since home agent fails authentication because MN-HA authenticator was wrong
 * \li 132 - MIP(Mobile IP) FA(Home Agent) ERR FA AUTHENTICATION FAILURE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since home agent rejected MIP registration due to FA authentication failure
 * \li 133 - MIP(Mobile IP) FA(Home Agent) ERR REGISTRATION ID MISMATCH, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since home agent rejected MIP registration due to registration id mismatch
 * \li 134 - MIP(Mobile IP) FA(Home Agent) ERR MALFORMED REQUEST, this error code is returned when the data call bring up fails in MIP
 *           setup phase since home agent rejected MIP registration due to malformed request
 * \li 136 - MIP(Mobile IP) FA(Home Agent) ERR UNKNOWN HA ADDR, this error code is returned when the data call bring up fails in MIP setup
 *           phase since home agent rejected MIP registration due to unknown Home Agent address. This code is returned by a home agent
 *           when the mobile node is performing dynamic home agent address resolution as described in RFC 3220 (IP Mobility Support for IPV4)
 *           Sections 3.6.1.1 and 3.6.1.2
 * \li 137 - MIP(Mobile IP) FA(Home Agent) ERR REVERSE TUNNEL UNAVAILABLE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since home agent rejected MIP registration because reverse tunnel is unavailable
 * \li 138 - MIP(Mobile IP) FA(Home Agent) ERR REVERSE TUNNEL IS MANDATORY AND T BIT NOT SET, this error code is returned when the data call
 *           bring up fails in MIP setup phase since home agent rejected MIP registration because reverse tunnel is mandatory but not requested
 *           by device
 * \li 139 - MIP(Mobile IP) FA(Home Agent) ERR ENCAPSULATION UNAVAILABLE, this error code is returned when the data call bring up fails in  
 *           MIP setup phase since home agent rejected MIP registration due to encapsulation unavailable
 * \li 65536 - MIP ERR REASON UNKNOWN
 * \subsection Internal Internal call end reasons (Type=2)
 * \li 200 - INTERNAL MIN, internal error table offset value, no meaningful message to the error.
 * \li 201 - INTERNAL ERROR, this error code is returned when data call is brought down due to some unspecified internal error
 * \li 202 - CALL ENDED
 * \li 203 - INTERNAL UNKNOWN CAUSE CODE, this error code is returned when data call is brought down due to some unknown error
 * \li 204 - UNKNOWN CAUSE CODE, this error code is returned when data call is brought down due to some unknown error
 * \li 205 - CLOSE IN PROGRESS
 * \li 206 - NETWORK INITIATED TERMINATION
 * \li 207 - APP PREEMPTED
 * \li 208 - ERR PDN IPV4 CALL DISALLOWED, this error code is returned when V4 PDN is in throttled state due to network providing only V6
 *           address during the previous VSNCP bring up (subs_limited_to_v6). The time for which the IPv4 PDN is throttled is
 *           determined by the IPv4 throttling timers maintained in the profile
 * \li 209 - ERR PDN IPV4 CALL THROTTLED, this error code is returned when V4 PDN is in throttled state due to previous VSNCP bring up failure(s).
 *           The time for which the IPv4 PDN is throttled is determined by the IPv4 throttling timers maintained in the profile
 * \li 210 - ERR PDN IPV6 CALL DISALLOWED, this error code is returned when V6 PDN is in throttled state due to network providing only V4
 *           address during the previous VSNCP bring up (subs_limited_to_v4). The time for which the IPv6 PDN is throttled is determined by
 *           the IPv6 throttling timers maintained in the profile
 * \li 211 - ERR PDN IPV6 CALL THROTTLED, this error code is returned when V6 PDN is in throttled state due to previous VSNCP bring up failure(s).
 *           The time for which the IPv6 PDN is throttled is determined by the IPv6 throttling timers maintained in the profile
 * \li 212 - MODEM RESTART
 * \li 213 - PDP PPP NOT SUPPORTED
 * \li 214 - UNPREFERRED RAT, this error code is returned when data call is brought down since the RAT on which the data call is
 *           attempted/connected is no longer the preferred RAT
 * \li 215 - PHYS LINK CLOSE IN PROGRESS, this error code is returned when data call bring up is rejected because physical link is in the
 *           process of cleanup
 * \li 216 - APN PENDING HANDOVER, this error code is returned when interface bring up is attempted for an APN that is yet to be handed over
 *           to target RAT
 * \li 217 - PROFILE BEARER INCOMPATIBLE
 * \li 218 - MMGSDI CARD EVT, this error code is returned when data call is brought down because card got refreshed/removed
 * \li 219 - LPM OR PWR DOWN, this error code is returned when data call is brought down because device is going into lower power mode or powering down
 * \li 220 - APN DISABLED, this error code is returned when APN is disabled in card
 * \li 221 - MPIT EXPIRED, this error code is returned when data call is brought down because maximum PPP inactivity timer expired
 * \li 222 - IPV6 ADDR TRANSFER FAILED
 * \li 223 - TRAT SWAP FAILED
 * \li 224 - EHRPD TO HRPD FALLBACK, this error code is returned when data call is brought down because device falls back from eHRPD to HRPD
 *           (not because of OOS on eHRPD but due to operator/spec driven eHRPD to HRPD fallback requirements)
 * \li 225 - MANDATORY APN DISABLED, this error code is returned when any mandatory APN is disabled, and MinApnList Disallow call config item is
 *           set to TRUE in device
 * \li 226 - MIP CONFIG FAILURE, this error code is returned when UE is in MIP Only config (QCMIP=2) but MIP config fails on call bring up
 *           due to incorrect provisioning
 * \subsection CM Call Manager defined call end reasons (Type=3)
 * \li 500 - CDMA LOCK, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to device in CDMA locked state
 * \li 501 - INTERCEPT, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           since it received an intercept order from the base station
 * \li 502 - REORDER, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           due to receiving a reorder from base station
 * \li 503 - REL SO REJ, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to receiving a release from base station with reason: SO Reject
 * \li 504 - INCOM CALL, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           since it received an incoming call from base station
 * \li 505 - ALERT STOP, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to RL/FL fade (or) receiving call release from base stations
 * \li 506 - ACTIVATION, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to channel acquisition failures. This indicates that device has failed acquiring all the channels in the PRL
 * \li 507 - MAX ACCESS PROBE, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           due maximum access probes transmitted
 * \li 508 - CCS NOT SUPPORTED BY BS, this error code is returned when data call is brought down because traffic channel request got rejected by
 *           CM(Call Manager) since concurrent service is not supported by base station
 * \li 509 - NO RESPONSE FROM BS, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           since there is no response received from base station
 * \li 510 - REJECTED BY BS, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           due to base station rejecting the call
 * \li 511 - INCOMPATIBLE, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           since concurrent services requested were not compatible
 * \li 512 - ALREADY IN TC, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           since traffic channel is already up for voice calls
 * \li 513 - USER CAL ORIG DURING GPS
 * \li 514 - USER CAL ORIG DURING SMS, this error code is returned when data call is brought down because traffic channel request got rejected since
 *           SMS is ongoing
 * \li 515 - NO CDMA SRV, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
             since device does not have CDMA service
 * \li 516 - MC ABORT, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           since MC aborted the origination/conversation
 * \li 517 - PSIST NG, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to persistence test failure
 * \li 518 - UIM NOT PRESENT, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           due to RUIM not present
 * \li 519 - RETRY ORDER, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           due to receiving a retry order from base station
 * \li 520 - ACCESS BLOCK, this error code is returned when data call is brought down because traffic channel rejected/released due to Access blocked by 
 *           base station
 * \li 521 - ACCESS BLOCK ALL, this error code is returned when data call is brought down because traffic channel rejected due to Access blocked by the 
 *           base station for all mobile devices
 * \li 522 - IS707B MAX ACC, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           due maximum access probes for IS-707B call
 * \li 523 - THERMAL EMERGENCY, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *           to put device in thermal emergency
 * \li 524 - CALL ORIG THROTTLED, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *           since call origination is throttled by DCTM module
 * \li 525 - USER CALL ORIGINATE DURING VOICE CALL, this error code is returned when data call is brought down because traffic channel got released by
 *           CM(Call Manager) in favor of voice call or SMS when concurrent voice and data are not supported
 * \li 1000 - CONFERENCE FAILED
 * \li 1001 - INCOMING REJECTED
 * \li 1002 - NO GATEWAY SERVICE
 * \li 1003 - NO GPRS CONTEXT
 * \li 1004 - ILLEGAL MS, This cause is sent to the MS when the network refuses service to the MS either because an identity of the MS is
 *            not acceptable to the network or because the MS does not pass the authentication check, i.e. the SRES received from the MS
 *            is different from that generated by the network
 * \li 1005 - ILLEGAL ME, This cause is sent to the MS if the ME used is not acceptable to the network, e.g. blacklisted
 * \li 1006 - GPRS SERVICES AND NON GPRS SERVICES NOT ALLOWED
 * \li 1007 - GPRS SERVICES NOT ALLOWED
 * \li 1008 - MS IDENTITY CANNOT BE DERIVED BY THE NETWORK
 * \li 1009 - IMPLICITLY DETACHED, this error code is sent to the MS either if the network has implicitly detached the MS, e.g. some while after the
 *            Mobile reachable timer has expired, or if the GMM context data related to the subscription does not exist in the SGSN e.g. because of 
 *            a SGSN restart.
 * \li 1010 - PLMN NOT ALLOWED, this error code is sent to the MS if it requests location updating in a PLMN where the MS, by subscription or due to
 *            operator determined barring is not allowed to operate
 * \li 1011 - LOCAL AREA NOT ALLOWED
 * \li 1012 - GPRS SERVICES NOT ALLOWED IN THIS PLMN
 * \li 1013 - PDP DUPLICATE
 * \li 1014 - USER EQUIPMENT RADIO ACCESS TECHNOLOGY CHANGE
 * \li 1015 - CONGESTION
 * \li 1016 - NO PDP CONEXT ACTIVATED
 * \li 1017 - ACCESS CLASS DSAC REJECTION
 * \li 1018 - PDP ACTIVATE MAX RETRY FAILED
 * \li 1019 - RAB FAILURE
 * \li 1020 - EPS SERVICE NOT ALLOWED
 * \li 1021 - TRACKING AREA NOT ALLOWED
 * \li 1022 - ROAMING NOT ALLOWED IN THIS TRACKING AREA
 * \li 1023 - NO SUITABLE CELLS IN TRACKING AREA
 * \li 1024 - NOT AUTHORIZED FOR THIS CLOSED SUBSCRIBER GROUP
 * \li 1025 - ESM UNKNOWN EPS BEARER CONTEXT
 * \li 1026 - DRB RELEASED AT RRC
 * \li 1027 - NAS SIG CONN RELEASED
 * \li 1028 - EPS MOBILITY MANAGEMENT DETACHED
 * \li 1029 - EPS MOBILITY MANAGEMENT ATTACH FAILED
 * \li 1030 - EPS MOBILITY MANAGEMENT ATTACH STARTED
 * \li 1031 - LTE NAS SERVICE REQ FAILED
 * \li 1032 - ESM(EPS Session Management) ACTIVE DEDICATED BEARER REACTIVATED BY NW
 * \li 1033 - ESM(EPS Session Management) LOWER LAYER FAILURE
 * \li 1034 - ESM(EPS Session Management) SYNC UP WITH NW
 * \li 1035 - ESM(EPS Session Management) NW ACTIVATED DED BEARER WITH ID OF DEF BEARER
 * \li 1036 - ESM(EPS Session Management) BAD OTA MESSAGE
 * \li 1037 - ESM DS REJECTED THE CALL
 * \li 1038 - ESM(EPS Session Management) CONTEXT TRANSFERRED DUE TO IRAT
 * \li 1039 - DS EXPLICIT DEACT
 * \li 1040 - ESM(EPS Session Management) LOCAL CAUSE NONE
 * \li 1041 - LTE NAS SERVICE REQ FAILED NO THROTTLE
 * \li 1042 - ACL FAILURE, This error code should rarely triggered and reported to the application
 * \li 1043 - LTE NAS SERVICE REQ FAILED DS DISALLOW
 * \li 1044 - EMM(EPS Mobility Management) T3417 EXPIRED
 * \li 1045 - EMM(EPS Mobility Management) T3417 EXT EXPIRED
 * \li 1046 - LRRC(LTE Radio Resource Control) UL DATA CNF FAILURE TXN - Light Radio Resource Controller Uplink data confirmation failure
 * \li 1047 - LRRC(LTE Radio Resource Control) UL DATA CNF FAILURE HO
 * \li 1048 - LRRC(LTE Radio Resource Control) UL DATA CNF FAILURE CONN REL
 * \li 1049 - LRRC(LTE Radio Resource Control) UL DATA CNF FAILURE RLF
 * \li 1050 - LRRC(LTE Radio Resource Control) UL DATA CNF FAILURE CTRL NOT CONN
 * \li 1051 - LRRC(LTE Radio Resource Control) CONN EST FAILURE
 * \li 1052 - LRRC(LTE Radio Resource Control) CONN EST FAILURE ABORTED
 * \li 1053 - LRRC(LTE Radio Resource Control) CONN EST FAILURE ACCESS BARRED
 * \li 1054 - LRRC(LTE Radio Resource Control) CONN EST FAILURE CELL RESEL
 * \li 1055 - LRRC(LTE Radio Resource Control) CONN EST FAILURE CONFIG FAILURE
 * \li 1056 - LRRC(LTE Radio Resource Control) CONN EST FAILURE TIMER EXPIRED
 * \li 1057 - LRRC(LTE Radio Resource Control) CONN EST FAILURE LINK FAILURE
 * \li 1058 - LRRC(LTE Radio Resource Control) CONN EST FAILURE NOT CAMPED
 * \li 1059 - LRRC(LTE Radio Resource Control) CONN EST FAILURE SI FAILURE
 * \li 1060 - LRRC(LTE Radio Resource Control) CONN EST FAILURE CONN REJECT
 * \li 1061 - LRRC(LTE Radio Resource Control) CONN REL NORMAL
 * \li 1062 - LRRC(LTE Radio Resource Control) CONN REL RLF
 * \li 1063 - LRRC(LTE Radio Resource Control) CONN REL CRE FAILURE
 * \li 1064 - LRRC(LTE Radio Resource Control) CONN REL OOS DURING CRE
 * \li 1065 - LRRC(LTE Radio Resource Control) CONN REL ABORTED
 * \li 1066 - LRRC(LTE Radio Resource Control) CONN REL SIB READ ERROR
 * \li 1067 - DETACH WITH REATTACH LTE NW DETACH
 * \li 1068 - DETACH WITH OUT REATTACH LTE NW DETACH
 * \li 1069 - ESM(EPS Session Management) PROC TIME OUT
 * \li 1070 - MESSAGE EXCEED MAX L2 LIMIT
 * \li 1500 - CD GEN OR BUSY, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) due to the reception of a Connection Deny message with a deny code of general or network busy
 * \li 1501 - CD BILL OR AUTH, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) due to the reception of a Connection Deny message with a deny code of billing failure or authentication failure
 * \li 1502 - CHG HDR, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) since there is a change to HDR system due to redirection or PRL not preferred
 * \li 1503 - EXIT HDR, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) since device exited HDR due to redirection or PRL not preferred
 * \li 1504 - HDR NO SESSION, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) since device does not have a HDR session
 * \li 1505 - HDR ORIG DURING GPS FIX, this error code is returned when data call is brought down because traffic channel request got
 *            rejected by CM(Call Manager) since it is ending an HDR call origination in favor of a GPS fix
 * \li 1506 - HDR CS TIMEOUT, this error code is returned when data call is brought down because traffic channel request got rejected
 *            by CM(Call Manager) since connection setup on HDR system timed out
 * \li 1507 - HDR RELEASED BY CM, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) when it wants to release a HDR call so a 1X call can continue
 * \li 1508 - COLLOC ACQ FAIL, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) when device failed to acquire co-located HDR for origination
 * \li 1509 - OTASP COMMIT IN PROG, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) since an OTASP commit is in progress
 * \li 1510 - NO HYBR HDR SRV, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) since device has no Hybrid HDR service
 * \li 1511 - HDR NO LOCK GRANTED, this error code is returned when data call is brought down because traffic channel got rejected/released
 *            by CM(Call Manager) since HDR module could not get the RF lock
 * \li 1512 - HOLD OTHER IN PROG, this error code is returned when data call is brought down by CM(Call Manager) because DBM or SMS is in progress
 * \li 1513 - HDR FADE, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *            since HDR module released the call due to fade
 * \li 1514 - HDR ACC FAIL, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) due to HDR system Access Failure
 * \li 2000 - CLIENT END, this error code is returned when client ends the data call
 * \li 2001 - NO SRV, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *            since device has no service
 * \li 2002 - FADE, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *            since device lost the system due to fade
 * \li 2003 - REL NORMAL, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) due to receiving a release from base station with no reason
 * \li 2004 - ACC IN PROG, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) due to Access attempt already in progress
 * \li 2005 - ACC FAIL, this error code is returned when data call is brought down because traffic channel got rejected/released by
 *            CM(Call Manager) due to Access Failure
 * \li 2006 - REDIR OR HANDOFF, this error code is returned when data call is brought down because device is in the process of redirecting/handing
 *            off to a different target system
 * \li 2500 - OFFLINE, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *            since device went offline
 * \li 2501 - EMERGENCY MODE, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *            since device is operating in Emergency mode
 * \li 2502 - PHONE IN USE, this error code is returned when data call is brought down because traffic channel got rejected/released by CM(Call Manager)
 *            since device is in use (e.g voice call)
 * \li 2503 - INVALID MODE, this error code is returned when data call is brought down because traffic channel request got rejected by CM(Call Manager)
 *            since the device's operational mode is different from the mode requested in the traffic channel bring up
 * \li 2504 - INVALID SIM STATE, this error code is returned when data call is brought down because traffic channel request got rejected by
 *            CM(Call Manager) since the SIM was marked by network as invalid for circuit and/or packet service domain
 * \li 2505 - NO COLLOC HDR, this error code is returned when data call is brought down because traffic channel got rejected/released by
              CM(Call Manager) since there is no collocated HDR
 * \li 2506 - CALL CONTROL REJECTED, this error code is returned when data call is brought down because traffic channel request got rejected by
              CM(Call Manager) since Call control module rejected the request
 * \subsection  _3GPP 3GPP specification defined call end reasons (Type=6)
 * \li 8 - OPERATOR DETERMINED BARRING, this reason code is posted by the MME(Mobility Management Entity) to indicate
 *         operator has barred the UE
 * \li 25 - LLC SNDCP FAILURE, PDP context deactivation initiated by the MS or by the Network
 * \li 26 - INSUFFICIENT RESOURCES, this reason is posted to indicate that the network cannot provide the requested service
 *          due to insufficient resources
 * \li 27 - MISSING OR UNKNOWN APN, the APN was required and not specified or APN could not be resolved. In LTE mode of operation,
 *          this is a PDN throttling cause code, meaning the UE may endup throttling further requests to the same APN
 * \li 28 - UNKNOWN PDN TYPE, the reason is posted by the network to indicate that the PDN type was not recognized
 * \li 29 - AUTH FAILED, the reason is posted when authentication fails. In LTE mode of operation, this is a PDN throttling cause
 *          code, meaning the UE may end up throttling further requests to the same APN
 * \li 30 - GGSN REJECT, the reason is posted when the request was rejected by Serving GW or PDN GW. In LTE mode of operation,
 *          this is a PDN throttling cause code, meaning the UE may end up throttling further requests to the same APN
 * \li 31 - ACTIVATION REJECT, the reason is posted when the request is rejected by the network due to unspecified reasons
 * \li 32 - OPTION NOT SUPPORTED, the reason is posted when UE requested a service not supported by the PLMN
 * \li 33 - OPTION UNSUBSCRIBED, This cause is sent when the MS requests a service option for which it has no subscription
 * \li 34 - OPTION TEMP OOO, service option temporarily out of order, this reason is posted when the network is temporarily out of
 *          resources to service the request
 * \li 35 - PTI ALREADY USED, the reason is posted to indicate that PTI (Procedure Transaction Identifier) used in the request is
 *          already active via another UE requested procedure
 * \li 36 - REGULAR DEACTIVATION, this reason is posted by the network to initiate a regular release of 
 *          bearer resources
 * \li 37 - EPS QOS NOT ACCEPTED, this reason is posted by the network to indicate that the QoS requested by the UE could not be accepted
 * \li 38 - NETWORK FAILURE, this reason is posted when an error occurs in the network
 * \li 39 - UMTS REACTIVATION REQ, this reason is posted by the network to request for bearer reactivation. This code may be posted
 *          during network congestion
 * \li 40 - FEATURE NOT SUPPORTED, Unsuccessful MBMS context activation requested by the network
 * \li 41 - TFT SEMANTIC ERROR, the reason is posted by the network to indicate semantic error(s) in specifying TFT operation included
 *          in the request
 * \li 42 - TFT SYNTAX ERROR, the reason is posted by the network to indicate syntactic error(s) in specifying TFT operation included
 *          in the request
 * \li 43 - UNKNOWN PDP CONTEXT, the reason is posted when the bearer identity (or linked bearer identity) in the request is invalid
 *          (or inactive)
 * \li 44 - FILTER SEMANTIC ERROR, the reason is posted by the network to indicate semantic error(s) in specifying packet filter(s)
 *          associated with a TFT
 * \li 45 - FILTER SYNTAX ERROR, the reason is posted by the network to indicate syntactic error(s) in specifying packet filter(s)
 *          associated with a TFT
 * \li 46 - PDP WITHOUT ACTIVE TFT, the reason is posted by the network when UW requested more than one PDP connection without TFT
 * \li 50 - IPV4 ONLY ALLOWED, 3GPP equivalent ESM(EPS Session Management) cause code value 50, PDN type IPv4 only allowed.
 * \li 51 - IPV6 ONLY ALLOWED, 3GPP equivalent ESM(EPS Session Management) cause code value 51, PDN type IPv6 only allowed
 * \li 52 - SINGLE ADDRESS BEARER ONLY, 3GPP equivalent ESM(EPS Session Management) cause code value 52, Single address bearers only allowed.
 *          The reason is posted when the network supports single address bearers only, meaning dual IP bearers are not supported
 * \li 53 - ESM INFORMATION NOT RECEIVED, 3GPP equivalent ESM(EPS Session Management) cause code value 53, ESM information not received.
 *          The reason is posted by the network to indicate that the PDN connection request was rejected because ESM information was
 *          not received
 * \li 54 - PND CONNECTION DOES NOT EXIST, 3GPP equivalent ESM(EPS Session Management) cause code value 54, PDN connection does not exist
 *          The reason is posted by the network during handover from a non-3GPP network to indicate that the MME does not have any information
 *          regarding the requested PDN connection
 * \li 55 - MULTIPLE CONNECTION TO SAME PDN NOT ALLOWED, 3GPP equivalent ESM(EPS Session Management) cause code value 55, Multiple PDN
 *          connections for a given APN not allowed. The reason is posted by the network to indicate that the UE is already connected to
 *          the requested APN via another PDN/PDN connection
 * \li 81 - INVALID TRANSACTION ID, the reason is posted by the network to indicate that the PTI used in the request is unassigned or reserved
 * \li 95 - MESSAGE INCORRECT SEMANTIC, the reason is posted by the network to indicate receipt of an invalid message
 * \li 96 - INVALID MANDATORY INFO, the reason is posted by the network to indicate receipt of a message with semantic error in a mandatory
 *          information element
 * \li 97 - MESSAGE TYPE UNSUPPORTED, the reason is posted by the network to indicate receipt of a message that is either undefined or defined
 *          but not implemented by the equipment sending this ESM cause
 * \li 98 - MSG TYPE NONCOMPATIBLE STATE, the reason is posted by the network to indicate receipt of a message type that cannot be handled
 *          in the current network protocol state
 * \li 99 - UNKNOWN INFO ELEMENT, the reason is posted by the network to indicate receipt of a message that includes and information element
 *          that is either not defined or defined but not implemented by the equipment sending the ESM cause
 * \li 100 - CONDITIONAL IE ERROR, the reason is posted by the network to indicate receipt of a message that includes a syntactically incorrect
 *           information element. This message is ignored by the network.
 * \li 101 - MSG AND PROTOCOL STATE UNCOMPATIBLE, the reason is posted by the network to indicate receipt of a message that cannot be handled
 *           in the current network protocol state
 * \li 111 - PROTOCOL ERROR, the reason is posted by the network to indicate a protocol error when no other error applies
 * \li 112 - APN TYPE CONFLICT
 * \li 113 - INVALID PROXY-CALL SESSION CONTROL FUNCTION ADDRESS
 * \subsection PPP PPP call end reasons (Type=7)
 * \li 1 - TIMEOUT, this error code is returned when the data call bring up fails in PPP setup due to timeout (For e.g: LCP Conf Ack not
 *         received from network)
 * \li 2 - AUTH FAILURE, this error code is returned when the data call bring up fails in PPP setup due to authentication failure
 * \li 3 - OPTION MISMATCH, this error code is returned when the data call bring up fails in PPP setup due option mismatch (e.g: Authentication is
 *         required, but not negotiated with network during LCP phase)
 * \li 31 - PAP FAILURE, this error code is returned when the data call bring up fails in PPP setup due to PAP failure
 * \li 32 - CHAP FAILURE, this error code is returned when the data call bring up fails in PPP setup due to CHAP failure
 * \li 33 - CLOSE IN PROGRESS, this error code is returned when the data call bring up fails in PPP setup since PPP is in the process of
 *          cleaning the previous PPP session
 * \li -1 - UNKNOWN, this error code is unused
 * \subsection EHRPD EHRPD call end reasons (Type=8)
 * \li 1 - SUBS LIMITED TO V4, this error code is returned when the V6 interface bring up fails because network provided only V4 address
 *         for the upcoming PDN 
 * \li 2 - SUBS LIMITED TO V6, this error code is returned when the V4 interface bring up fails because network provided only V6 address
 *         for the upcoming PDN
 * \li 4 - VSNCP(Vendor Specific Network Control Protocol) TIMEOUT, this error code is returned when the data call bring up fails in VSNCP
 *         phase due to VSNCP timeout error
 * \li 5 - VSNCP(Vendor Specific Network Control Protocol) FAILURE, this error code is returned when VSNCP configuration failed during
 *         call bring up
 * \li 6 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I GEN ERROR, this error code is returned when the data call bring up fails
 *         in VSNCP phase due to general error
 * \li 7 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I UNAUTH APN, this error code is returned when the data call bring up fails
 *         in VSNCP phase since network rejected VSNCP config request with reason requested APN is unauthorized
 * \li 8 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I PDN LIMIT EXCEED, this error code is returned when the data call bring up
 *         fails in VSNCP phase since network rejected VSNCP config request with reason PDN limit exceeded
 * \li 9 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I NO PDN GW, this error code is returned when the data call bring up fails
 *         in VSNCP phase since network rejected VSNCP config request with reason no PDN gateway
 * \li 10 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I PDN GW UNREACH, this error code is returned when the data call bring up
 *          fails in VSNCP phase since network rejected VSNCP config request with reason PDN gateway unreachable
 * \li 11 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I PDN GW REJ, this error code is returned when the data call bring up fails
 *          in VSNCP phase since network rejected VSNCP config request with reason PDN gateway reject
 * \li 12 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I INSUFF PARAM, this error code is returned when the data call bring up
 *          fails in VSNCP phase since network rejected VSNCP config request with reason insufficient parameter
 * \li 13 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I RESOURCE UNAVAIL, this error code is returned when the data call bring up
 *          fails in VSNCP phase since network rejected VSNCP config request with reason resource unavailable
 * \li 14 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I ADMIN PROHIBIT, this error code is returned when the data call bring up
 *          fails in SNCP phase since network rejected VSNCP config request with reason admin prohibited
 * \li 15 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I PDN ID IN USE, this error code is returned when the data call bring up
 *          fails in VSNCP phase because network rejected with reason PDN ID IN USE (or) All existing PDNs are brought down with this end
 *          reason because one of the PDN bring up got rejected by network with reason PDN ID IN USE
 * \li 16 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I SUBSCR LIMITATION, this error code is returned when the data call bring up
 *          fails in VSNCP phase since network rejected VSNCP config request with reason subscriber limitation
 * \li 17 - VSNCP(Vendor Specific Network Control Protocol) 3GPP2I PDN EXISTS FOR THIS APN, this error code is returned when the data call
 *          bring up fails in VSNCP phase since network rejected VSNCP config request with reason PDN exists for this APN
 * \subsection IPV6 IPV6 call end reasons (Type=9)
 * \li 1 - PREFIX UNAVAILABLE, this error code is returned when V6 data call is brought down because device failed to get the prefix from network
 * \li 2 - IPV6 ERR HRPD IPV6 DISABLED, this error code is returned when V6 data call bring up is rejected because IPV6 is disabled in 1X/HRPD mode
 * \li 3 - IPV6 DISABLED, this error code is returned when IPv6 data call bring up is rejected because NV1896 (IPV6 enable) is disabled
 *
 * Copyright: © 2011-2013 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __GOBI_API_CALL_END_REASONS_H__
#define __GOBI_API_CALL_END_REASONS_H__


#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif /* __GOBI_API_CALL_END_REASONS_H__ */

