/**
 * \ingroup nas
 *
 * \file    qaGobiApiTableBandClasses.h
 *
 * \brief   Network Access Service API Band Classes table
 *
 * \section Table6 Band Classes (Value - Description)
 * \li 0 - CDMA Band Class 0
 * \li 1 - CDMA Band Class 1
 * \li 3 - CDMA Band Class 3
 * \li 4 - CDMA Band Class 4
 * \li 5 - CDMA Band Class 5
 * \li 6 - CDMA Band Class 6
 * \li 7 - CDMA Band Class 7
 * \li 8 - CDMA Band Class 8
 * \li 9 - CDMA Band Class 9
 * \li 10 - CDMA Band Class 10
 * \li 11 - CDMA Band Class 11
 * \li 12 - CDMA Band Class 12
 * \li 13 - CDMA Band Class 13
 * \li 14 - CDMA Band Class 14
 * \li 15 - CDMA Band Class 15
 * \li 16 - CDMA Band Class 16
 * \li 17 - CDMA Band Class 17
 * \li 18 - CDMA Band Class 18
 * \li 19 - CDMA Band Class 19
 * \li 40 - GSM 450
 * \li 41 - GSM 480
 * \li 42 - GSM 750
 * \li 43 - GSM 850
 * \li 44 - GSM 900 (Extended)
 * \li 45 - GSM 900 (Primary)
 * \li 46 - GSM 900 (Railways)
 * \li 47 - GSM 1800
 * \li 48 - GSM 1900
 * \li 80 - WCDMA 2100
 * \li 81 - WCDMA PCS 1900
 * \li 82 - WCDMA DCS 1800
 * \li 83 - WCDMA 1700 (US)
 * \li 84 - WCDMA 850
 * \li 85 - WCDMA 800
 * \li 86 - WCDMA 2600
 * \li 87 - WCDMA 900
 * \li 88 - WCDMA 1700 (Japan)
 * \li 90 - WCDMA 1500 band (Japan)
 * \li 91 - WCDMA 850 band (Japan)
 * \li < Reserved 89, 92-109 for WCDMA band classes>
 * \li 110 - WLAN US 2400 MHz
 * \li 111 - WLAN JAPAN 2400 MHz
 * \li 112 - WLAN EUROPEAN 2400 MHz
 * \li 113 - WLAN FRANCE 2400 MHz
 * \li 114 - WLAN SPAIN 2400 MHz
 * \li 115 - WLAN US 5000 MHz band
 * \li 116 - WLAN JAPAN 5000 MHz
 * \li 117 - WLAN EUROPEAN 5000 MHz
 * \li 118 - WLAN FRANCE 5000 MHz
 * \li 119 - WLAN SPAIN 5000 MHz
 * \subsection LTE LTE Bands
 * \li 28 - LTE Band Class 28
 * \li 39 - LTE Band Class 39
 * \li 40 - LTE Band Class 40
 * \li 41 - LTE Band Class 41
 * \li 120 - FDD UL:1920-1980; DL:2110-2170; E-UTRA Operating Band 1
 * \li 121 - FDD UL:1850-1910; DL:1930-1990; E-UTRA Operating Band 2
 * \li 122 - FDD UL:1710-1785; DL:1805-1880; E-UTRA Operating Band 3
 * \li 123 - FDD UL:1710-1755; DL:2110-2155; E-UTRA Operating Band 4
 * \li 124 - FDD UL: 824- 849; DL: 869- 894; E-UTRA Operating Band 5
 * \li 125 - FDD UL: 830- 840; DL: 875- 885; E-UTRA Operating Band 6
 * \li 126 - FDD UL:2500-2570; DL:2620-2690; E-UTRA Operating Band 7
 * \li 127 - FDD UL: 880- 915; DL: 925- 960; E-UTRA Operating Band 8
 * \li 128 - FDD UL:1749.9-1784.9; DL:1844.9-1879.9; E-UTRA Operating Band 9
 * \li 129 - FDD UL:1710-1770; DL:2110-2170; E-UTRA Operating Band 10
 * \li 130 - FDD UL:1427.9-1452.9; DL:1475.9-1500.9; E-UTRA Operating Band 11
 * \li 131 - FDD UL:698-716; DL:728-746; E-UTRA Operating Band 12
 * \li 132 - FDD UL: 777- 787; DL: 746-756; E-UTRA Operating Band 13
 * \li 133 - FDD UL: 788- 798; DL: 758-768; E-UTRA Operating Band 14
 * \li 134 - FDD UL: 704-716; DL: 734-746; E-UTRA Operating Band 17
 * \li 135 - TDD LTE UL: 1900-1920; DL: 1900-1920; E-UTRA Operating Band 33
 * \li 136 - TDD LTE UL: 2010-2025; DL: 2010-2025; E-UTRA Operating Band 34
 * \li 137 - TDD LTE UL: 1850-1910; DL: 1850-1910; E-UTRA Operating Band 35
 * \li 138 - TDD LTE UL: 1930-1990; DL: 1930-1990; E-UTRA Operating Band 36
 * \li 139 - TDD LTE UL: 1910-1930; DL: 1910-1930; E-UTRA Operating Band 37
 * \li 140 - TDD LTE UL: 2570-2620; DL: 2570-2620; E-UTRA Operating Band 38
 * \li 141 - TDD LTE UL: 1880-1920; DL: 1880-1920; E-UTRA Operating Band 39
 * \li 142 - TDD LTE UL: 2300-2400; DL: 2300-2400; E-UTRA Operating Band 40
 * \li 143 - FDD LTE UL: 815-830; DL: 860-875; E-UTRA Operating Band 18
 * \li 144 - FDD LTE UL: 830-845; DL: 875-890; E-UTRA Operating Band 19
 * \li 145 - FDD LTE UL: 832-862; DL: 791-821; E-UTRA Operating Band 20
 * \li 146 - FDD LTE UL: 1447.9-1462.9; DL: 1495.9-1510.9; E-UTRA Operating Band 21
 * \li 147 - FDD LTE UL: 1626.5-1660.5; DL: 1525-1559; E-UTRA Operating Band 24
 * \li 148 - FDD LTE UL: 1850-19195; DL: 1930-1995; E-UTRA Operating Band 25
 * \li 149 - TDD LTE UL: 2496-2690; DL: 2496-2690; E-UTRA Operating Band 41
 * \li 150 - TDD LTE UL: 3400-3600; DL: 3400-3600; E-UTRA Operating Band 42
 * \li 151 - TDD LTE UL: 3600-3800; DL: 3600-3800; E-UTRA Operating Band 43
 * \li 200 - TD-SCDMA Band A
 * \li 201 - TD-SCDMA Band B
 * \li 202 - TD-SCDMA Band C
 * \li 203 - TD-SCDMA Band D
 * \li 204 - TD-SCDMA Band E
 * \li 205 - TD-SCDMA Band F
 *
 * Copyright: © 2011 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __GOBI_API_BANDCLASSES_H__
 #define __GOBI_API_BANDCLASSES_H__

#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif /* __GOBI_API_BANDCLASSES_H__ */
