/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetSupportedMsg.c
 *
 * \brief  Contains Packing and UnPacking routines for the
 *         eQMI_IMSA_GET_SUPPORTED_MSGS message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaQmiBasic.h"
#include "qaGobiApiImsa.h"
#include "qaImsaSLQSGetSupportedMsg.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/

/*
 * This function packs the SLQSGetIMSASupportedMsg parameters
 * to the QMI message SDU
 *
 * \param  pParamField [OUT] - Pointer to storage into which the packed
 *                             data will be placed by this function.
 *
 * \param  pMlength    [OUT] - Total length of built message.
 *
 * \return eQCWWAN_ERR_NONE, on success
 * \return eQCWWAN_ERR_NO_MEMORY, on error
 *
 */
enum eQCWWANError PkQmiImsaSLQSGetSupportMsg(
    WORD *pMlength,
    BYTE *pParamField)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };
    enum eQCWWANError eRCode;

    eRCode = qmbuild( pParamField,
                      NULL,
                      map,
                      eQMI_IMSA_GET_SUPPORTED_MSGS,
                      pMlength );
    return eRCode;
}
/*
 * This function unpacks the SLQSGetIMSASupportedMsg
 * Supported Messages List from the QMI response
 * message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                   to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 * \return      eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UnpackTlvSupportedMsgList( BYTE *pTlvData, BYTE *pResp )
{
    struct QmiImsaGetSupportMsgResp *lResp =
                (struct QmiImsaGetSupportMsgResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    WORD lTemp;
    if ( lResp->pIMSASupportedMsgInfo == NULL )
         return eRCode;

    eRCode = GetWord( pTlvData, &lTemp);
    (lResp->pIMSASupportedMsgInfo->pSupportedMsgList->supportedMsgLen) = lTemp;
    if (eQCWWAN_ERR_NONE != eRCode)
    {
        return eRCode;
    }
    WORD count = 0;

    while ( lTemp-- )
    {
         eRCode = GetByte( pTlvData,
         (BYTE *)&lResp->pIMSASupportedMsgInfo->pSupportedMsgList->supportedMsgs[count++]);

        if (eQCWWAN_ERR_NONE != eRCode)
        {
            return eRCode;
        }
    }
    return eRCode;
}
/*
 * This function unpacks the SLQSGetIMSASupportedMsg response message to a
 * user-provided response structure.
 *
 * \param     MdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param     pApiResp  [OUT] - Pointer to storage to unpack into.
 *
 * \return    eQCWWAN_ERR_NONE, on success
 * \return    eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UpkQmiImsaSLQSGetSupportMsg(
    BYTE                            *pMdmResp,
    struct QmiImsaGetSupportMsgResp *pApiResp)
{
    enum eQCWWANError rCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,             &qmUnpackTlvResultCode },
        { eTLV_IMSA_SUPPORT_MSG_LIST,   &UnpackTlvSupportedMsgList },
        { eTLV_TYPE_INVALID,            NULL } /* Important. Sentinel.
                                                * Signifies last item in map.
                                                */
    };
    rCode = qmunpackresp( pMdmResp,
                          (BYTE *)pApiResp,
                          map,
                          eQMI_IMSA_GET_SUPPORTED_MSGS );
    return rCode;
}

