/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetRegistrationStatus.c
 *
 * \brief  Contains Packing and UnPacking routines for the
 *         eQMI_IMSA_GET_REGISTRATION_STATUS message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaQmiBasic.h"
#include "qaGobiApiImsa.h"
#include "qaImsaSLQSGetRegistrationStatus.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/

/*
 * This function packs the SLQSGetIMSARegStatus parameters
 * to the QMI message SDU
 *
 * \param  pParamField [OUT] - Pointer to storage into which the packed
 *                             data will be placed by this function.
 *
 * \param  pMlength    [OUT] - Total length of built message.
 *
 * \return eQCWWAN_ERR_NONE, on success
 * \return eQCWWAN_ERR_NO_MEMORY, on error
 *
 */
enum eQCWWANError PkQmiImsaSLQSGetRegStatus(
    WORD *pMlength,
    BYTE *pParamField)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };
    enum eQCWWANError eRCode;

    eRCode = qmbuild( pParamField,
                      NULL,
                      map,
                      eQMI_IMSA_GET_REGISTRATION_STATUS,
                      pMlength );
    return eRCode;
}

/*
 * This function unpacks the SLQSGetIMSARegStatus
 * Registration Status from the QMI response
 * message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                   to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 * \return      eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UnpackTlvRegStatus( BYTE *pTlvData, BYTE *pResp )
{
    struct QmiImsaGetRegStatusResp *lResp =
                (struct QmiImsaGetRegStatusResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    if ( lResp->pIMSARegistrationStatus->pImsRegStatus == NULL )
         return eRCode;

    eRCode = GetByte( pTlvData, lResp->pIMSARegistrationStatus->pImsRegStatus);

    return eRCode;
}
/*
 * This function unpacks the SLQSGetIMSARegStatus
 * Registration Error Code from the QMI response
 * message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                   to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 * \return      eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UnpackTlvRegErrorCode( BYTE *pTlvData, BYTE *pResp )
{
    struct QmiImsaGetRegStatusResp *lResp =
                (struct QmiImsaGetRegStatusResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    if ( lResp->pIMSARegistrationStatus->pImsRegErrCode == NULL )
         return eRCode;

    eRCode = GetWord( pTlvData, lResp->pIMSARegistrationStatus->pImsRegErrCode);

    return eRCode;
}
/*
 * This function unpacks the SLQSGetIMSARegStatus
 * New Registration Status from the QMI response
 * message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                   to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 * \return      eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UnpackTlvNewRegStatus( BYTE *pTlvData, BYTE *pResp )
{
    struct QmiImsaGetRegStatusResp *lResp =
                (struct QmiImsaGetRegStatusResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    if ( lResp->pIMSARegistrationStatus->pNewImsRegStatus == NULL )
         return eRCode;

    eRCode = GetLong( pTlvData, lResp->pIMSARegistrationStatus->pNewImsRegStatus);

    return eRCode;
}
/*
 * This function unpacks the SLQSGetIMSARegStatus response message to a
 * user-provided response structure.
 *
 * \param     MdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param     pApiResp  [OUT] - Pointer to storage to unpack into.
 *
 * \return    eQCWWAN_ERR_NONE, on success
 * \return    eQCWWAN_ERR_NO_MEMORY, on error
 */
enum eQCWWANError UpkQmiImsaSLQSGetRegStatus(
    BYTE                            *pMdmResp,
    struct QmiImsaGetRegStatusResp  *pApiResp)
{
    enum eQCWWANError rCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,             &qmUnpackTlvResultCode },
        { eTLV_IMSA_REG_STATUS,         &UnpackTlvRegStatus },
        { eTLV_IMSA_REG_ERROR_CODE,     &UnpackTlvRegErrorCode },
        { eTLV_IMSA_NEW_REG_STATUS,     &UnpackTlvNewRegStatus },
        { eTLV_TYPE_INVALID,            NULL } /* Important. Sentinel.
                                                * Signifies last item in map.
                                                */
    };
    rCode = qmunpackresp( pMdmResp,
                          (BYTE *)pApiResp,
                          map,
                          eQMI_IMSA_GET_REGISTRATION_STATUS );
    return rCode;
}

