/*
 * \ingroup ims
 *
 * \file qaGobiApiImsa.c
 *
 * \brief  Entry points for Gobi APIs for the IMS Service ( IMS )
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "amudefs.h"
#include "sludefs.h"
#include "qaQmiBasic.h"
#include "qaGobiApiImsa.h"
#include "qaImsaSLQSIndRegister.h"
#include "qaImsaSLQSGetSupportedMsg.h"
#include "qaImsaSLQSGetSupportedFields.h"
#include "qaImsaSLQSGetRegistrationStatus.h"
#include "qaImsaSLQSGetServiceStatus.h"

ULONG SLQSRegisterIMSAIndication (
    IMSAIndRegisterInfo *pImsaIndRegisterInfo )
{
    ULONG  resultCode;  /* Result code to be returned by this function */
    BYTE   *pInParam;   /* ptr to param field rx'd from modem */
    BYTE   *pOutParam;  /* ptr to outbound param field */
    BYTE   *pReqBuf;    /* Pointer to outgoing request buffer */
    USHORT paramLength; /* Ret'd length of the QMI Param field */

    /* Storage for results and response variable */
    struct QmiImsaSLQSIndRegisterResp response;

    /* structure params has IN/OUT Param, hence validated against NULL */
    if ( !pImsaIndRegisterInfo )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Initialize the pointer to the outgoing request buffer pointer */
      resultCode = qmgetreqbkp(&pReqBuf);
       if (resultCode != eQCWWAN_ERR_NONE)
           return resultCode;

    /* Get a pointer to the start of the outbound QMI Parameter field */
    pOutParam = amgetparamp( AMTYPEQMIREQUEST, pReqBuf );

    /* Invoke the function which packs the QMI message */
    resultCode = PkQmiImsaSLQSIndRegister( &paramLength,
                                           pOutParam,
                                           pImsaIndRegisterInfo );

    if ( eQCWWAN_ERR_NONE != resultCode )
    {
        qmrelreqbkp();
        return resultCode; /* No Memory */
    }

    resultCode = SwiQmiSendnWait( pReqBuf,
                                  eQMI_SVC_IMSA,
                                  paramLength,
                                  eQMI_TIMEOUT_5_S, /* 5 seconds */
                                  &pInParam,
                                  &paramLength );

    /* Only parse out the response data if we got a positive return */
    if ( eQCWWAN_ERR_NONE == resultCode )
    {
        /* Copy to the caller's buffer */
        resultCode = UpkQmiImsaSLQSIndRegister( pInParam, &response );
    }

    qmrelreqbkp();
    return resultCode;
}

ULONG SLQSGetIMSASupportedMsg (
       IMSASupportedMsgInfo *pIMSASupportedMsgInfo )
{
    ULONG  resultCode;  /* Result code to be returned by this function */
    BYTE   *pInParam;   /* ptr to param field rx'd from modem */
    BYTE   *pOutParam;  /* ptr to outbound param field */
    BYTE   *pReqBuf;    /* Pointer to outgoing request buffer */
    USHORT paramLength; /* Ret'd length of the QMI Param field */

    /* Storage for results and response variable */
    struct QmiImsaGetSupportMsgResp response;

    /* structure params has IN/OUT Param, hence validated against NULL */
    if ( !pIMSASupportedMsgInfo )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Initialize the pointer to the outgoing request buffer pointer */
      resultCode = qmgetreqbkp(&pReqBuf);
       if (resultCode != eQCWWAN_ERR_NONE)
           return resultCode;

    /* Get a pointer to the start of the outbound QMI Parameter field */
    pOutParam = amgetparamp( AMTYPEQMIREQUEST, pReqBuf );

    /* Invoke the function which packs the QMI message */
    resultCode = PkQmiImsaSLQSGetSupportMsg( &paramLength,
                                             pOutParam );

    if ( eQCWWAN_ERR_NONE != resultCode )
    {
        qmrelreqbkp();
        return resultCode; /* No Memory */
    }

    resultCode = SwiQmiSendnWait( pReqBuf,
                                  eQMI_SVC_IMSA,
                                  paramLength,
                                  eQMI_TIMEOUT_5_S, /* 5 seconds */
                                  &pInParam,
                                  &paramLength );

    /* Only parse out the response data if we got a positive return */
    if ( eQCWWAN_ERR_NONE == resultCode )
    {
        /* Copy the obtained values to the function OUT parameters */
        response.pIMSASupportedMsgInfo = pIMSASupportedMsgInfo;

        /* Copy to the caller's buffer */
        resultCode = UpkQmiImsaSLQSGetSupportMsg( pInParam, &response );
    }

    qmrelreqbkp();
    return resultCode;
}

ULONG SLQSGetIMSASupportedFields (
        WORD                    messageID,
        IMSASupportedFieldsResp *pIMSASupportedFieldsResp )
{
    ULONG  resultCode;  /* Result code to be returned by this function */
    BYTE   *pInParam;   /* ptr to param field rx'd from modem */
    BYTE   *pOutParam;  /* ptr to outbound param field */
    BYTE   *pReqBuf;    /* Pointer to outgoing request buffer */
    USHORT paramLength; /* Ret'd length of the QMI Param field */

    /* Storage for results and response variable */
    struct QmiImsaGetSupportFieldsResp response;

    /* structure params has IN/OUT Param, hence validated against NULL */
    if ( !pIMSASupportedFieldsResp )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Initialize the pointer to the outgoing request buffer pointer */
      resultCode = qmgetreqbkp(&pReqBuf);
       if (resultCode != eQCWWAN_ERR_NONE)
           return resultCode;

    /* Get a pointer to the start of the outbound QMI Parameter field */
    pOutParam = amgetparamp( AMTYPEQMIREQUEST, pReqBuf );

    /* Invoke the function which packs the QMI message */
    resultCode = PkQmiImsaSLQSGetSupportFields( &paramLength,
                                                 pOutParam,
                                                 messageID);

    if ( eQCWWAN_ERR_NONE != resultCode )
    {
        qmrelreqbkp();
        return resultCode; /* No Memory */
    }

    resultCode = SwiQmiSendnWait( pReqBuf,
                                  eQMI_SVC_IMSA,
                                  paramLength,
                                  eQMI_TIMEOUT_5_S, /* 5 seconds */
                                  &pInParam,
                                  &paramLength );

    /* Only parse out the response data if we got a positive return */
    if ( eQCWWAN_ERR_NONE == resultCode )
    {
        /* Copy the obtained values to the function OUT parameters */
        response.pIMSASupportedFieldsResp = pIMSASupportedFieldsResp;

        /* Copy to the caller's buffer */
        resultCode = UpkQmiImsaSLQSGetSupportFields( pInParam, &response );
    }

    qmrelreqbkp();
    return resultCode;
}

ULONG SLQSGetIMSARegStatus (
        IMSARegistrationStatus *pIMSARegistrationStatus )
{
    ULONG  resultCode;  /* Result code to be returned by this function */
    BYTE   *pInParam;   /* ptr to param field rx'd from modem */
    BYTE   *pOutParam;  /* ptr to outbound param field */
    BYTE   *pReqBuf;    /* Pointer to outgoing request buffer */
    USHORT paramLength; /* Ret'd length of the QMI Param field */

    /* Storage for results and response variable */
    struct QmiImsaGetRegStatusResp response;

    /* structure params has IN/OUT Param, hence validated against NULL */
    if ( !pIMSARegistrationStatus )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Initialize the pointer to the outgoing request buffer pointer */
      resultCode = qmgetreqbkp(&pReqBuf);
       if (resultCode != eQCWWAN_ERR_NONE)
           return resultCode;

    /* Get a pointer to the start of the outbound QMI Parameter field */
    pOutParam = amgetparamp( AMTYPEQMIREQUEST, pReqBuf );

    /* Invoke the function which packs the QMI message */
    resultCode = PkQmiImsaSLQSGetRegStatus( &paramLength,
                                             pOutParam );

    if ( eQCWWAN_ERR_NONE != resultCode )
    {
        qmrelreqbkp();
        return resultCode; /* No Memory */
    }

    resultCode = SwiQmiSendnWait( pReqBuf,
                                  eQMI_SVC_IMSA,
                                  paramLength,
                                  eQMI_TIMEOUT_5_S, /* 5 seconds */
                                  &pInParam,
                                  &paramLength );

    /* Only parse out the response data if we got a positive return */
    if ( eQCWWAN_ERR_NONE == resultCode )
    {
        /* Copy the obtained values to the function OUT parameters */
        response.pIMSARegistrationStatus = pIMSARegistrationStatus;

        /* Copy to the caller's buffer */
        resultCode = UpkQmiImsaSLQSGetRegStatus( pInParam, &response );
    }

    qmrelreqbkp();
    return resultCode;
}

ULONG SLQSGetIMSAServiceStatus (
        IMSAServiceStatus *pIMSAServiceStatus )
{
    ULONG  resultCode;  /* Result code to be returned by this function */
    BYTE   *pInParam;   /* ptr to param field rx'd from modem */
    BYTE   *pOutParam;  /* ptr to outbound param field */
    BYTE   *pReqBuf;    /* Pointer to outgoing request buffer */
    USHORT paramLength; /* Ret'd length of the QMI Param field */

    /* Storage for results and response variable */
    struct QmiImsaGetServiceStatusResp response;

    /* structure params has IN/OUT Param, hence validated against NULL */
    if ( !pIMSAServiceStatus )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Initialize the pointer to the outgoing request buffer pointer */
      resultCode = qmgetreqbkp(&pReqBuf);
       if (resultCode != eQCWWAN_ERR_NONE)
           return resultCode;

    /* Get a pointer to the start of the outbound QMI Parameter field */
    pOutParam = amgetparamp( AMTYPEQMIREQUEST, pReqBuf );

    /* Invoke the function which packs the QMI message */
    resultCode = PkQmiImsaSLQSGetServiceStatus( &paramLength,
                                                pOutParam );

    if ( eQCWWAN_ERR_NONE != resultCode )
    {
        qmrelreqbkp();
        return resultCode; /* No Memory */
    }

    resultCode = SwiQmiSendnWait( pReqBuf,
                                  eQMI_SVC_IMSA,
                                  paramLength,
                                  eQMI_TIMEOUT_5_S, /* 5 seconds */
                                  &pInParam,
                                  &paramLength );

    /* Only parse out the response data if we got a positive return */
    if ( eQCWWAN_ERR_NONE == resultCode )
    {
        /* Copy the obtained values to the function OUT parameters */
        response.pIMSAServiceStatus = pIMSAServiceStatus;

        /* Copy to the caller's buffer */
        resultCode = UpkQmiImsaSLQSGetServiceStatus( pInParam, &response );
    }

    qmrelreqbkp();
    return resultCode;
}
