/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetSupportedMsg.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaImsaSLQSGetSupportedMsg.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __IMSA_SLQS_GET_SUPPORTED_MSG_H__
#define __IMSA_SLQS_GET_SUPPORTED_MSG_H__

/* enum declarations */

/*
 * An enumeration of eQMI_IMSA_SLQS_IND_REGISTER request TLV IDs
 */
enum eQMI_IMSA_SLQS_GET_MSG_RESP
{
    eTLV_IMSA_SUPPORT_MSG_LIST     = 0x10
};

/*
 * This structure contains the SLQSRegisterIMSAIndication response
 * parameters.
 *
 */
struct QmiImsaGetSupportMsgResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Get Supported Message response parameters */
    IMSASupportedMsgInfo *pIMSASupportedMsgInfo;
};
/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiImsaSLQSGetSupportMsg(
    WORD *pMlength,
    BYTE *pParamField);

extern enum eQCWWANError UpkQmiImsaSLQSGetSupportMsg(
    BYTE                            *pMdmResp,
    struct QmiImsaGetSupportMsgResp *pApiResp);

#endif /* __IMSA_SLQS_GET_SUPPORTED_MSG_H__ */
